# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WaitingRoomSettingsArgs', 'WaitingRoomSettings']

@pulumi.input_type
class WaitingRoomSettingsArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[_builtins.str],
                 search_engine_crawler_bypass: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a WaitingRoomSettings resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.bool] search_engine_crawler_bypass: Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
               Verified search engine crawlers will not be tracked or counted by the waiting room system,
               and will not appear in waiting room analytics.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if search_engine_crawler_bypass is not None:
            pulumi.set(__self__, "search_engine_crawler_bypass", search_engine_crawler_bypass)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="searchEngineCrawlerBypass")
    def search_engine_crawler_bypass(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
        Verified search engine crawlers will not be tracked or counted by the waiting room system,
        and will not appear in waiting room analytics.
        """
        return pulumi.get(self, "search_engine_crawler_bypass")

    @search_engine_crawler_bypass.setter
    def search_engine_crawler_bypass(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "search_engine_crawler_bypass", value)


@pulumi.input_type
class _WaitingRoomSettingsState:
    def __init__(__self__, *,
                 search_engine_crawler_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WaitingRoomSettings resources.
        :param pulumi.Input[_builtins.bool] search_engine_crawler_bypass: Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
               Verified search engine crawlers will not be tracked or counted by the waiting room system,
               and will not appear in waiting room analytics.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if search_engine_crawler_bypass is not None:
            pulumi.set(__self__, "search_engine_crawler_bypass", search_engine_crawler_bypass)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="searchEngineCrawlerBypass")
    def search_engine_crawler_bypass(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
        Verified search engine crawlers will not be tracked or counted by the waiting room system,
        and will not appear in waiting room analytics.
        """
        return pulumi.get(self, "search_engine_crawler_bypass")

    @search_engine_crawler_bypass.setter
    def search_engine_crawler_bypass(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "search_engine_crawler_bypass", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/waitingRoomSettings:WaitingRoomSettings")
class WaitingRoomSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 search_engine_crawler_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_waiting_room_settings = cloudflare.WaitingRoomSettings("example_waiting_room_settings",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            search_engine_crawler_bypass=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/waitingRoomSettings:WaitingRoomSettings example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] search_engine_crawler_bypass: Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
               Verified search engine crawlers will not be tracked or counted by the waiting room system,
               and will not appear in waiting room analytics.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_waiting_room_settings = cloudflare.WaitingRoomSettings("example_waiting_room_settings",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            search_engine_crawler_bypass=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/waitingRoomSettings:WaitingRoomSettings example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 search_engine_crawler_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomSettingsArgs.__new__(WaitingRoomSettingsArgs)

            __props__.__dict__["search_engine_crawler_bypass"] = search_engine_crawler_bypass
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(WaitingRoomSettings, __self__).__init__(
            'cloudflare:index/waitingRoomSettings:WaitingRoomSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            search_engine_crawler_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WaitingRoomSettings':
        """
        Get an existing WaitingRoomSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] search_engine_crawler_bypass: Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
               Verified search engine crawlers will not be tracked or counted by the waiting room system,
               and will not appear in waiting room analytics.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomSettingsState.__new__(_WaitingRoomSettingsState)

        __props__.__dict__["search_engine_crawler_bypass"] = search_engine_crawler_bypass
        __props__.__dict__["zone_id"] = zone_id
        return WaitingRoomSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="searchEngineCrawlerBypass")
    def search_engine_crawler_bypass(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to allow verified search engine crawlers to bypass all waiting rooms on this zone.
        Verified search engine crawlers will not be tracked or counted by the waiting room system,
        and will not appear in waiting room analytics.
        """
        return pulumi.get(self, "search_engine_crawler_bypass")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

