# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['Web3HostnameArgs', 'Web3Hostname']

@pulumi.input_type
class Web3HostnameArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 target: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dnslink: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Web3Hostname resource.
        :param pulumi.Input[_builtins.str] name: Specify the hostname that points to the target gateway via CNAME.
        :param pulumi.Input[_builtins.str] target: Specify the target gateway of the hostname.
               Available values: "ethereum", "ipfs", "ipfs*universal*path".
        :param pulumi.Input[_builtins.str] zone_id: Specify the identifier of the hostname.
        :param pulumi.Input[_builtins.str] description: Specify an optional description of the hostname.
        :param pulumi.Input[_builtins.str] dnslink: Specify the DNSLink value used if the target is ipfs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "zone_id", zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dnslink is not None:
            pulumi.set(__self__, "dnslink", dnslink)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the hostname that points to the target gateway via CNAME.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the target gateway of the hostname.
        Available values: "ethereum", "ipfs", "ipfs*universal*path".
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the identifier of the hostname.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify an optional description of the hostname.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dnslink(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the DNSLink value used if the target is ipfs.
        """
        return pulumi.get(self, "dnslink")

    @dnslink.setter
    def dnslink(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dnslink", value)


@pulumi.input_type
class _Web3HostnameState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dnslink: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Web3Hostname resources.
        :param pulumi.Input[_builtins.str] description: Specify an optional description of the hostname.
        :param pulumi.Input[_builtins.str] dnslink: Specify the DNSLink value used if the target is ipfs.
        :param pulumi.Input[_builtins.str] name: Specify the hostname that points to the target gateway via CNAME.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the hostname's activation.
               Available values: "active", "pending", "deleting", "error".
        :param pulumi.Input[_builtins.str] target: Specify the target gateway of the hostname.
               Available values: "ethereum", "ipfs", "ipfs*universal*path".
        :param pulumi.Input[_builtins.str] zone_id: Specify the identifier of the hostname.
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dnslink is not None:
            pulumi.set(__self__, "dnslink", dnslink)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify an optional description of the hostname.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dnslink(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the DNSLink value used if the target is ipfs.
        """
        return pulumi.get(self, "dnslink")

    @dnslink.setter
    def dnslink(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dnslink", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the hostname that points to the target gateway via CNAME.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the status of the hostname's activation.
        Available values: "active", "pending", "deleting", "error".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the target gateway of the hostname.
        Available values: "ethereum", "ipfs", "ipfs*universal*path".
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the identifier of the hostname.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/web3Hostname:Web3Hostname")
class Web3Hostname(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dnslink: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_web3_hostname = cloudflare.Web3Hostname("example_web3_hostname",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="gateway.example.com",
            target="ipfs",
            description="This is my IPFS gateway.",
            dnslink="/ipns/onboarding.ipfs.cloudflare.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/web3Hostname:Web3Hostname example '<zone_id>/<identifier>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specify an optional description of the hostname.
        :param pulumi.Input[_builtins.str] dnslink: Specify the DNSLink value used if the target is ipfs.
        :param pulumi.Input[_builtins.str] name: Specify the hostname that points to the target gateway via CNAME.
        :param pulumi.Input[_builtins.str] target: Specify the target gateway of the hostname.
               Available values: "ethereum", "ipfs", "ipfs*universal*path".
        :param pulumi.Input[_builtins.str] zone_id: Specify the identifier of the hostname.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Web3HostnameArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_web3_hostname = cloudflare.Web3Hostname("example_web3_hostname",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="gateway.example.com",
            target="ipfs",
            description="This is my IPFS gateway.",
            dnslink="/ipns/onboarding.ipfs.cloudflare.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/web3Hostname:Web3Hostname example '<zone_id>/<identifier>'
        ```

        :param str resource_name: The name of the resource.
        :param Web3HostnameArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Web3HostnameArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dnslink: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Web3HostnameArgs.__new__(Web3HostnameArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dnslink"] = dnslink
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["status"] = None
        super(Web3Hostname, __self__).__init__(
            'cloudflare:index/web3Hostname:Web3Hostname',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dnslink: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Web3Hostname':
        """
        Get an existing Web3Hostname resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specify an optional description of the hostname.
        :param pulumi.Input[_builtins.str] dnslink: Specify the DNSLink value used if the target is ipfs.
        :param pulumi.Input[_builtins.str] name: Specify the hostname that points to the target gateway via CNAME.
        :param pulumi.Input[_builtins.str] status: Specifies the status of the hostname's activation.
               Available values: "active", "pending", "deleting", "error".
        :param pulumi.Input[_builtins.str] target: Specify the target gateway of the hostname.
               Available values: "ethereum", "ipfs", "ipfs*universal*path".
        :param pulumi.Input[_builtins.str] zone_id: Specify the identifier of the hostname.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Web3HostnameState.__new__(_Web3HostnameState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["dnslink"] = dnslink
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["target"] = target
        __props__.__dict__["zone_id"] = zone_id
        return Web3Hostname(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify an optional description of the hostname.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def dnslink(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the DNSLink value used if the target is ipfs.
        """
        return pulumi.get(self, "dnslink")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the hostname that points to the target gateway via CNAME.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the status of the hostname's activation.
        Available values: "active", "pending", "deleting", "error".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the target gateway of the hostname.
        Available values: "ethereum", "ipfs", "ipfs*universal*path".
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the identifier of the hostname.
        """
        return pulumi.get(self, "zone_id")

