# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WebAnalyticsRuleArgs', 'WebAnalyticsRule']

@pulumi.input_type
class WebAnalyticsRuleArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 ruleset_id: pulumi.Input[_builtins.str],
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 inclusive: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a WebAnalyticsRule resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] ruleset_id: The Web Analytics ruleset identifier.
        :param pulumi.Input[_builtins.bool] inclusive: Whether the rule includes or excludes traffic from being measured.
        :param pulumi.Input[_builtins.bool] is_paused: Whether the rule is paused or not.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "ruleset_id", ruleset_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if inclusive is not None:
            pulumi.set(__self__, "inclusive", inclusive)
        if is_paused is not None:
            pulumi.set(__self__, "is_paused", is_paused)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Web Analytics ruleset identifier.
        """
        return pulumi.get(self, "ruleset_id")

    @ruleset_id.setter
    def ruleset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ruleset_id", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def inclusive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule includes or excludes traffic from being measured.
        """
        return pulumi.get(self, "inclusive")

    @inclusive.setter
    def inclusive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inclusive", value)

    @_builtins.property
    @pulumi.getter(name="isPaused")
    def is_paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is paused or not.
        """
        return pulumi.get(self, "is_paused")

    @is_paused.setter
    def is_paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_paused", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class _WebAnalyticsRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 inclusive: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.float]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WebAnalyticsRule resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] inclusive: Whether the rule includes or excludes traffic from being measured.
        :param pulumi.Input[_builtins.bool] is_paused: Whether the rule is paused or not.
        :param pulumi.Input[_builtins.str] ruleset_id: The Web Analytics ruleset identifier.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if inclusive is not None:
            pulumi.set(__self__, "inclusive", inclusive)
        if is_paused is not None:
            pulumi.set(__self__, "is_paused", is_paused)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if ruleset_id is not None:
            pulumi.set(__self__, "ruleset_id", ruleset_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def inclusive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule includes or excludes traffic from being measured.
        """
        return pulumi.get(self, "inclusive")

    @inclusive.setter
    def inclusive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inclusive", value)

    @_builtins.property
    @pulumi.getter(name="isPaused")
    def is_paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is paused or not.
        """
        return pulumi.get(self, "is_paused")

    @is_paused.setter
    def is_paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_paused", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Web Analytics ruleset identifier.
        """
        return pulumi.get(self, "ruleset_id")

    @ruleset_id.setter
    def ruleset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ruleset_id", value)


@pulumi.type_token("cloudflare:index/webAnalyticsRule:WebAnalyticsRule")
class WebAnalyticsRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 inclusive: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_web_analytics_rule = cloudflare.WebAnalyticsRule("example_web_analytics_rule",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            ruleset_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            host="example.com",
            inclusive=True,
            is_paused=False,
            paths=["*"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] inclusive: Whether the rule includes or excludes traffic from being measured.
        :param pulumi.Input[_builtins.bool] is_paused: Whether the rule is paused or not.
        :param pulumi.Input[_builtins.str] ruleset_id: The Web Analytics ruleset identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAnalyticsRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_web_analytics_rule = cloudflare.WebAnalyticsRule("example_web_analytics_rule",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            ruleset_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            host="example.com",
            inclusive=True,
            is_paused=False,
            paths=["*"])
        ```

        :param str resource_name: The name of the resource.
        :param WebAnalyticsRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAnalyticsRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 inclusive: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAnalyticsRuleArgs.__new__(WebAnalyticsRuleArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["host"] = host
            __props__.__dict__["inclusive"] = inclusive
            __props__.__dict__["is_paused"] = is_paused
            __props__.__dict__["paths"] = paths
            if ruleset_id is None and not opts.urn:
                raise TypeError("Missing required property 'ruleset_id'")
            __props__.__dict__["ruleset_id"] = ruleset_id
            __props__.__dict__["created"] = None
            __props__.__dict__["priority"] = None
        super(WebAnalyticsRule, __self__).__init__(
            'cloudflare:index/webAnalyticsRule:WebAnalyticsRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            inclusive: Optional[pulumi.Input[_builtins.bool]] = None,
            is_paused: Optional[pulumi.Input[_builtins.bool]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            priority: Optional[pulumi.Input[_builtins.float]] = None,
            ruleset_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WebAnalyticsRule':
        """
        Get an existing WebAnalyticsRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] inclusive: Whether the rule includes or excludes traffic from being measured.
        :param pulumi.Input[_builtins.bool] is_paused: Whether the rule is paused or not.
        :param pulumi.Input[_builtins.str] ruleset_id: The Web Analytics ruleset identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebAnalyticsRuleState.__new__(_WebAnalyticsRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created"] = created
        __props__.__dict__["host"] = host
        __props__.__dict__["inclusive"] = inclusive
        __props__.__dict__["is_paused"] = is_paused
        __props__.__dict__["paths"] = paths
        __props__.__dict__["priority"] = priority
        __props__.__dict__["ruleset_id"] = ruleset_id
        return WebAnalyticsRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def inclusive(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the rule includes or excludes traffic from being measured.
        """
        return pulumi.get(self, "inclusive")

    @_builtins.property
    @pulumi.getter(name="isPaused")
    def is_paused(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the rule is paused or not.
        """
        return pulumi.get(self, "is_paused")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Web Analytics ruleset identifier.
        """
        return pulumi.get(self, "ruleset_id")

