# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkerVersionArgs', 'WorkerVersion']

@pulumi.input_type
class WorkerVersionArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 worker_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input['WorkerVersionAnnotationsArgs']] = None,
                 assets: Optional[pulumi.Input['WorkerVersionAssetsArgs']] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]]] = None,
                 compatibility_date: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 limits: Optional[pulumi.Input['WorkerVersionLimitsArgs']] = None,
                 main_module: Optional[pulumi.Input[_builtins.str]] = None,
                 migrations: Optional[pulumi.Input['WorkerVersionMigrationsArgs']] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]]] = None,
                 placement: Optional[pulumi.Input['WorkerVersionPlacementArgs']] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkerVersion resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] worker_id: Identifier.
        :param pulumi.Input['WorkerVersionAnnotationsArgs'] annotations: Metadata about the version.
        :param pulumi.Input['WorkerVersionAssetsArgs'] assets: Configuration for assets within a Worker.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[_builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input['WorkerVersionLimitsArgs'] limits: Resource limits enforced at runtime.
        :param pulumi.Input[_builtins.str] main_module: The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        :param pulumi.Input['WorkerVersionMigrationsArgs'] migrations: Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]] modules: Code, sourcemaps, and other content used at runtime.
        :param pulumi.Input['WorkerVersionPlacementArgs'] placement: Placement settings for the version.
        :param pulumi.Input[_builtins.str] usage_model: Usage model for the version.
               Available values: "standard", "bundled", "unbound".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "worker_id", worker_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if compatibility_date is not None:
            pulumi.set(__self__, "compatibility_date", compatibility_date)
        if compatibility_flags is not None:
            pulumi.set(__self__, "compatibility_flags", compatibility_flags)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if main_module is not None:
            pulumi.set(__self__, "main_module", main_module)
        if migrations is not None:
            pulumi.set(__self__, "migrations", migrations)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if usage_model is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""usage_model is deprecated: This attribute is deprecated.""")
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "worker_id")

    @worker_id.setter
    def worker_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "worker_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input['WorkerVersionAnnotationsArgs']]:
        """
        Metadata about the version.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input['WorkerVersionAnnotationsArgs']]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input['WorkerVersionAssetsArgs']]:
        """
        Configuration for assets within a Worker.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input['WorkerVersionAssetsArgs']]):
        pulumi.set(self, "assets", value)

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]]]:
        """
        List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @_builtins.property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        """
        return pulumi.get(self, "compatibility_date")

    @compatibility_date.setter
    def compatibility_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compatibility_date", value)

    @_builtins.property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        """
        return pulumi.get(self, "compatibility_flags")

    @compatibility_flags.setter
    def compatibility_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatibility_flags", value)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['WorkerVersionLimitsArgs']]:
        """
        Resource limits enforced at runtime.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['WorkerVersionLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @_builtins.property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        """
        return pulumi.get(self, "main_module")

    @main_module.setter
    def main_module(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "main_module", value)

    @_builtins.property
    @pulumi.getter
    def migrations(self) -> Optional[pulumi.Input['WorkerVersionMigrationsArgs']]:
        """
        Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        """
        return pulumi.get(self, "migrations")

    @migrations.setter
    def migrations(self, value: Optional[pulumi.Input['WorkerVersionMigrationsArgs']]):
        pulumi.set(self, "migrations", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]]]:
        """
        Code, sourcemaps, and other content used at runtime.
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['WorkerVersionPlacementArgs']]:
        """
        Placement settings for the version.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['WorkerVersionPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @_builtins.property
    @pulumi.getter(name="usageModel")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def usage_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Usage model for the version.
        Available values: "standard", "bundled", "unbound".
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_model", value)


@pulumi.input_type
class _WorkerVersionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input['WorkerVersionAnnotationsArgs']] = None,
                 assets: Optional[pulumi.Input['WorkerVersionAssetsArgs']] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]]] = None,
                 compatibility_date: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 limits: Optional[pulumi.Input['WorkerVersionLimitsArgs']] = None,
                 main_module: Optional[pulumi.Input[_builtins.str]] = None,
                 migrations: Optional[pulumi.Input['WorkerVersionMigrationsArgs']] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]]] = None,
                 number: Optional[pulumi.Input[_builtins.int]] = None,
                 placement: Optional[pulumi.Input['WorkerVersionPlacementArgs']] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkerVersion resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input['WorkerVersionAnnotationsArgs'] annotations: Metadata about the version.
        :param pulumi.Input['WorkerVersionAssetsArgs'] assets: Configuration for assets within a Worker.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[_builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[_builtins.str] created_on: When the version was created.
        :param pulumi.Input['WorkerVersionLimitsArgs'] limits: Resource limits enforced at runtime.
        :param pulumi.Input[_builtins.str] main_module: The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        :param pulumi.Input['WorkerVersionMigrationsArgs'] migrations: Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]] modules: Code, sourcemaps, and other content used at runtime.
        :param pulumi.Input[_builtins.int] number: The integer version number, starting from one.
        :param pulumi.Input['WorkerVersionPlacementArgs'] placement: Placement settings for the version.
        :param pulumi.Input[_builtins.str] source: The client used to create the version.
        :param pulumi.Input[_builtins.str] usage_model: Usage model for the version.
               Available values: "standard", "bundled", "unbound".
        :param pulumi.Input[_builtins.str] worker_id: Identifier.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if compatibility_date is not None:
            pulumi.set(__self__, "compatibility_date", compatibility_date)
        if compatibility_flags is not None:
            pulumi.set(__self__, "compatibility_flags", compatibility_flags)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if main_module is not None:
            pulumi.set(__self__, "main_module", main_module)
        if migrations is not None:
            pulumi.set(__self__, "migrations", migrations)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if usage_model is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""usage_model is deprecated: This attribute is deprecated.""")
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)
        if worker_id is not None:
            pulumi.set(__self__, "worker_id", worker_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input['WorkerVersionAnnotationsArgs']]:
        """
        Metadata about the version.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input['WorkerVersionAnnotationsArgs']]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input['WorkerVersionAssetsArgs']]:
        """
        Configuration for assets within a Worker.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input['WorkerVersionAssetsArgs']]):
        pulumi.set(self, "assets", value)

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]]]:
        """
        List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @_builtins.property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        """
        return pulumi.get(self, "compatibility_date")

    @compatibility_date.setter
    def compatibility_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compatibility_date", value)

    @_builtins.property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        """
        return pulumi.get(self, "compatibility_flags")

    @compatibility_flags.setter
    def compatibility_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "compatibility_flags", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the version was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['WorkerVersionLimitsArgs']]:
        """
        Resource limits enforced at runtime.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['WorkerVersionLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @_builtins.property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        """
        return pulumi.get(self, "main_module")

    @main_module.setter
    def main_module(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "main_module", value)

    @_builtins.property
    @pulumi.getter
    def migrations(self) -> Optional[pulumi.Input['WorkerVersionMigrationsArgs']]:
        """
        Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        """
        return pulumi.get(self, "migrations")

    @migrations.setter
    def migrations(self, value: Optional[pulumi.Input['WorkerVersionMigrationsArgs']]):
        pulumi.set(self, "migrations", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]]]:
        """
        Code, sourcemaps, and other content used at runtime.
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerVersionModuleArgs']]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The integer version number, starting from one.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['WorkerVersionPlacementArgs']]:
        """
        Placement settings for the version.
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['WorkerVersionPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client used to create the version.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="usageModel")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def usage_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Usage model for the version.
        Available values: "standard", "bundled", "unbound".
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage_model", value)

    @_builtins.property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "worker_id")

    @worker_id.setter
    def worker_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_id", value)


@pulumi.type_token("cloudflare:index/workerVersion:WorkerVersion")
class WorkerVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Union['WorkerVersionAnnotationsArgs', 'WorkerVersionAnnotationsArgsDict']]] = None,
                 assets: Optional[pulumi.Input[Union['WorkerVersionAssetsArgs', 'WorkerVersionAssetsArgsDict']]] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionBindingArgs', 'WorkerVersionBindingArgsDict']]]]] = None,
                 compatibility_date: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 limits: Optional[pulumi.Input[Union['WorkerVersionLimitsArgs', 'WorkerVersionLimitsArgsDict']]] = None,
                 main_module: Optional[pulumi.Input[_builtins.str]] = None,
                 migrations: Optional[pulumi.Input[Union['WorkerVersionMigrationsArgs', 'WorkerVersionMigrationsArgsDict']]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionModuleArgs', 'WorkerVersionModuleArgsDict']]]]] = None,
                 placement: Optional[pulumi.Input[Union['WorkerVersionPlacementArgs', 'WorkerVersionPlacementArgsDict']]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workerVersion:WorkerVersion example '<account_id>/<worker_id>/<version_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Union['WorkerVersionAnnotationsArgs', 'WorkerVersionAnnotationsArgsDict']] annotations: Metadata about the version.
        :param pulumi.Input[Union['WorkerVersionAssetsArgs', 'WorkerVersionAssetsArgsDict']] assets: Configuration for assets within a Worker.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionBindingArgs', 'WorkerVersionBindingArgsDict']]]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[_builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[Union['WorkerVersionLimitsArgs', 'WorkerVersionLimitsArgsDict']] limits: Resource limits enforced at runtime.
        :param pulumi.Input[_builtins.str] main_module: The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        :param pulumi.Input[Union['WorkerVersionMigrationsArgs', 'WorkerVersionMigrationsArgsDict']] migrations: Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionModuleArgs', 'WorkerVersionModuleArgsDict']]]] modules: Code, sourcemaps, and other content used at runtime.
        :param pulumi.Input[Union['WorkerVersionPlacementArgs', 'WorkerVersionPlacementArgsDict']] placement: Placement settings for the version.
        :param pulumi.Input[_builtins.str] usage_model: Usage model for the version.
               Available values: "standard", "bundled", "unbound".
        :param pulumi.Input[_builtins.str] worker_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkerVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workerVersion:WorkerVersion example '<account_id>/<worker_id>/<version_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkerVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkerVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Union['WorkerVersionAnnotationsArgs', 'WorkerVersionAnnotationsArgsDict']]] = None,
                 assets: Optional[pulumi.Input[Union['WorkerVersionAssetsArgs', 'WorkerVersionAssetsArgsDict']]] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionBindingArgs', 'WorkerVersionBindingArgsDict']]]]] = None,
                 compatibility_date: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 limits: Optional[pulumi.Input[Union['WorkerVersionLimitsArgs', 'WorkerVersionLimitsArgsDict']]] = None,
                 main_module: Optional[pulumi.Input[_builtins.str]] = None,
                 migrations: Optional[pulumi.Input[Union['WorkerVersionMigrationsArgs', 'WorkerVersionMigrationsArgsDict']]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionModuleArgs', 'WorkerVersionModuleArgsDict']]]]] = None,
                 placement: Optional[pulumi.Input[Union['WorkerVersionPlacementArgs', 'WorkerVersionPlacementArgsDict']]] = None,
                 usage_model: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkerVersionArgs.__new__(WorkerVersionArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["assets"] = assets
            __props__.__dict__["bindings"] = bindings
            __props__.__dict__["compatibility_date"] = compatibility_date
            __props__.__dict__["compatibility_flags"] = compatibility_flags
            __props__.__dict__["limits"] = limits
            __props__.__dict__["main_module"] = main_module
            __props__.__dict__["migrations"] = migrations
            __props__.__dict__["modules"] = modules
            __props__.__dict__["placement"] = placement
            __props__.__dict__["usage_model"] = usage_model
            if worker_id is None and not opts.urn:
                raise TypeError("Missing required property 'worker_id'")
            __props__.__dict__["worker_id"] = worker_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["number"] = None
            __props__.__dict__["source"] = None
        super(WorkerVersion, __self__).__init__(
            'cloudflare:index/workerVersion:WorkerVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            annotations: Optional[pulumi.Input[Union['WorkerVersionAnnotationsArgs', 'WorkerVersionAnnotationsArgsDict']]] = None,
            assets: Optional[pulumi.Input[Union['WorkerVersionAssetsArgs', 'WorkerVersionAssetsArgsDict']]] = None,
            bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionBindingArgs', 'WorkerVersionBindingArgsDict']]]]] = None,
            compatibility_date: Optional[pulumi.Input[_builtins.str]] = None,
            compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            limits: Optional[pulumi.Input[Union['WorkerVersionLimitsArgs', 'WorkerVersionLimitsArgsDict']]] = None,
            main_module: Optional[pulumi.Input[_builtins.str]] = None,
            migrations: Optional[pulumi.Input[Union['WorkerVersionMigrationsArgs', 'WorkerVersionMigrationsArgsDict']]] = None,
            modules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionModuleArgs', 'WorkerVersionModuleArgsDict']]]]] = None,
            number: Optional[pulumi.Input[_builtins.int]] = None,
            placement: Optional[pulumi.Input[Union['WorkerVersionPlacementArgs', 'WorkerVersionPlacementArgsDict']]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            usage_model: Optional[pulumi.Input[_builtins.str]] = None,
            worker_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkerVersion':
        """
        Get an existing WorkerVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Union['WorkerVersionAnnotationsArgs', 'WorkerVersionAnnotationsArgsDict']] annotations: Metadata about the version.
        :param pulumi.Input[Union['WorkerVersionAssetsArgs', 'WorkerVersionAssetsArgsDict']] assets: Configuration for assets within a Worker.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionBindingArgs', 'WorkerVersionBindingArgsDict']]]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[_builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[_builtins.str] created_on: When the version was created.
        :param pulumi.Input[Union['WorkerVersionLimitsArgs', 'WorkerVersionLimitsArgsDict']] limits: Resource limits enforced at runtime.
        :param pulumi.Input[_builtins.str] main_module: The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        :param pulumi.Input[Union['WorkerVersionMigrationsArgs', 'WorkerVersionMigrationsArgsDict']] migrations: Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerVersionModuleArgs', 'WorkerVersionModuleArgsDict']]]] modules: Code, sourcemaps, and other content used at runtime.
        :param pulumi.Input[_builtins.int] number: The integer version number, starting from one.
        :param pulumi.Input[Union['WorkerVersionPlacementArgs', 'WorkerVersionPlacementArgsDict']] placement: Placement settings for the version.
        :param pulumi.Input[_builtins.str] source: The client used to create the version.
        :param pulumi.Input[_builtins.str] usage_model: Usage model for the version.
               Available values: "standard", "bundled", "unbound".
        :param pulumi.Input[_builtins.str] worker_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkerVersionState.__new__(_WorkerVersionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["assets"] = assets
        __props__.__dict__["bindings"] = bindings
        __props__.__dict__["compatibility_date"] = compatibility_date
        __props__.__dict__["compatibility_flags"] = compatibility_flags
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["limits"] = limits
        __props__.__dict__["main_module"] = main_module
        __props__.__dict__["migrations"] = migrations
        __props__.__dict__["modules"] = modules
        __props__.__dict__["number"] = number
        __props__.__dict__["placement"] = placement
        __props__.__dict__["source"] = source
        __props__.__dict__["usage_model"] = usage_model
        __props__.__dict__["worker_id"] = worker_id
        return WorkerVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output['outputs.WorkerVersionAnnotations']:
        """
        Metadata about the version.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def assets(self) -> pulumi.Output[Optional['outputs.WorkerVersionAssets']]:
        """
        Configuration for assets within a Worker.
        """
        return pulumi.get(self, "assets")

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> pulumi.Output[Optional[Sequence['outputs.WorkerVersionBinding']]]:
        """
        List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        """
        return pulumi.get(self, "bindings")

    @_builtins.property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        """
        return pulumi.get(self, "compatibility_date")

    @_builtins.property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        """
        return pulumi.get(self, "compatibility_flags")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the version was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> pulumi.Output['outputs.WorkerVersionLimits']:
        """
        Resource limits enforced at runtime.
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the main module in the `modules` array (e.g. the name of the module that exports a `fetch` handler).
        """
        return pulumi.get(self, "main_module")

    @_builtins.property
    @pulumi.getter
    def migrations(self) -> pulumi.Output[Optional['outputs.WorkerVersionMigrations']]:
        """
        Migrations for Durable Objects associated with the version. Migrations are applied when the version is deployed.
        """
        return pulumi.get(self, "migrations")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> pulumi.Output[Optional[Sequence['outputs.WorkerVersionModule']]]:
        """
        Code, sourcemaps, and other content used at runtime.
        """
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Output[_builtins.int]:
        """
        The integer version number, starting from one.
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> pulumi.Output[Optional['outputs.WorkerVersionPlacement']]:
        """
        Placement settings for the version.
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        The client used to create the version.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="usageModel")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def usage_model(self) -> pulumi.Output[_builtins.str]:
        """
        Usage model for the version.
        Available values: "standard", "bundled", "unbound".
        """
        return pulumi.get(self, "usage_model")

    @_builtins.property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "worker_id")

