# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustAccessPolicyArgs', 'ZeroTrustAccessPolicy']

@pulumi.input_type
class ZeroTrustAccessPolicyArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 decision: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]]] = None,
                 approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]]] = None,
                 isolation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ZeroTrustAccessPolicy resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[_builtins.str] name: The name of the Access policy.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[_builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[_builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[_builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[_builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[_builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "name", name)
        if approval_groups is not None:
            pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if isolation_required is not None:
            pulumi.set(__self__, "isolation_required", isolation_required)
        if purpose_justification_prompt is not None:
            pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required is not None:
            pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> pulumi.Input[_builtins.str]:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "decision", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]]]:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @approval_groups.setter
    def approval_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]]]):
        pulumi.set(self, "approval_groups", value)

    @_builtins.property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "approval_required", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]]]:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]]]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @_builtins.property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @isolation_required.setter
    def isolation_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "isolation_required", value)

    @_builtins.property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @purpose_justification_prompt.setter
    def purpose_justification_prompt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose_justification_prompt", value)

    @_builtins.property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @purpose_justification_required.setter
    def purpose_justification_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purpose_justification_required", value)

    @_builtins.property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]]]:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_duration", value)


@pulumi.input_type
class _ZeroTrustAccessPolicyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]]] = None,
                 approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]]] = None,
                 isolation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessPolicy resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[_builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[_builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[_builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[_builtins.str] name: The name of the Access policy.
        :param pulumi.Input[_builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[_builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[_builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if approval_groups is not None:
            pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)
        if decision is not None:
            pulumi.set(__self__, "decision", decision)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if isolation_required is not None:
            pulumi.set(__self__, "isolation_required", isolation_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if purpose_justification_prompt is not None:
            pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required is not None:
            pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]]]:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @approval_groups.setter
    def approval_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyApprovalGroupArgs']]]]):
        pulumi.set(self, "approval_groups", value)

    @_builtins.property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "approval_required", value)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decision", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]]]:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]]]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @_builtins.property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @isolation_required.setter
    def isolation_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "isolation_required", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @purpose_justification_prompt.setter
    def purpose_justification_prompt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose_justification_prompt", value)

    @_builtins.property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @purpose_justification_required.setter
    def purpose_justification_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purpose_justification_required", value)

    @_builtins.property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]]]:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessPolicyRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_duration", value)


@pulumi.type_token("cloudflare:index/zeroTrustAccessPolicy:ZeroTrustAccessPolicy")
class ZeroTrustAccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyApprovalGroupArgs', 'ZeroTrustAccessPolicyApprovalGroupArgsDict']]]]] = None,
                 approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyExcludeArgs', 'ZeroTrustAccessPolicyExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyIncludeArgs', 'ZeroTrustAccessPolicyIncludeArgsDict']]]]] = None,
                 isolation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyRequireArgs', 'ZeroTrustAccessPolicyRequireArgsDict']]]]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessPolicy:ZeroTrustAccessPolicy example '<account_id>/<policy_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyApprovalGroupArgs', 'ZeroTrustAccessPolicyApprovalGroupArgsDict']]]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[_builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[_builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyExcludeArgs', 'ZeroTrustAccessPolicyExcludeArgsDict']]]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyIncludeArgs', 'ZeroTrustAccessPolicyIncludeArgsDict']]]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[_builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[_builtins.str] name: The name of the Access policy.
        :param pulumi.Input[_builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[_builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyRequireArgs', 'ZeroTrustAccessPolicyRequireArgsDict']]]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[_builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustAccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessPolicy:ZeroTrustAccessPolicy example '<account_id>/<policy_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyApprovalGroupArgs', 'ZeroTrustAccessPolicyApprovalGroupArgsDict']]]]] = None,
                 approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyExcludeArgs', 'ZeroTrustAccessPolicyExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyIncludeArgs', 'ZeroTrustAccessPolicyIncludeArgsDict']]]]] = None,
                 isolation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyRequireArgs', 'ZeroTrustAccessPolicyRequireArgsDict']]]]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessPolicyArgs.__new__(ZeroTrustAccessPolicyArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["approval_groups"] = approval_groups
            __props__.__dict__["approval_required"] = approval_required
            if decision is None and not opts.urn:
                raise TypeError("Missing required property 'decision'")
            __props__.__dict__["decision"] = decision
            __props__.__dict__["excludes"] = excludes
            __props__.__dict__["includes"] = includes
            __props__.__dict__["isolation_required"] = isolation_required
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["purpose_justification_prompt"] = purpose_justification_prompt
            __props__.__dict__["purpose_justification_required"] = purpose_justification_required
            __props__.__dict__["requires"] = requires
            __props__.__dict__["session_duration"] = session_duration
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/accessPolicy:AccessPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustAccessPolicy, __self__).__init__(
            'cloudflare:index/zeroTrustAccessPolicy:ZeroTrustAccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyApprovalGroupArgs', 'ZeroTrustAccessPolicyApprovalGroupArgsDict']]]]] = None,
            approval_required: Optional[pulumi.Input[_builtins.bool]] = None,
            decision: Optional[pulumi.Input[_builtins.str]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyExcludeArgs', 'ZeroTrustAccessPolicyExcludeArgsDict']]]]] = None,
            includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyIncludeArgs', 'ZeroTrustAccessPolicyIncludeArgsDict']]]]] = None,
            isolation_required: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            purpose_justification_prompt: Optional[pulumi.Input[_builtins.str]] = None,
            purpose_justification_required: Optional[pulumi.Input[_builtins.bool]] = None,
            requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyRequireArgs', 'ZeroTrustAccessPolicyRequireArgsDict']]]]] = None,
            session_duration: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZeroTrustAccessPolicy':
        """
        Get an existing ZeroTrustAccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyApprovalGroupArgs', 'ZeroTrustAccessPolicyApprovalGroupArgsDict']]]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[_builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[_builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyExcludeArgs', 'ZeroTrustAccessPolicyExcludeArgsDict']]]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyIncludeArgs', 'ZeroTrustAccessPolicyIncludeArgsDict']]]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[_builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[_builtins.str] name: The name of the Access policy.
        :param pulumi.Input[_builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[_builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessPolicyRequireArgs', 'ZeroTrustAccessPolicyRequireArgsDict']]]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[_builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessPolicyState.__new__(_ZeroTrustAccessPolicyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["approval_groups"] = approval_groups
        __props__.__dict__["approval_required"] = approval_required
        __props__.__dict__["decision"] = decision
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["includes"] = includes
        __props__.__dict__["isolation_required"] = isolation_required
        __props__.__dict__["name"] = name
        __props__.__dict__["purpose_justification_prompt"] = purpose_justification_prompt
        __props__.__dict__["purpose_justification_required"] = purpose_justification_required
        __props__.__dict__["requires"] = requires
        __props__.__dict__["session_duration"] = session_duration
        return ZeroTrustAccessPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessPolicyApprovalGroup']]]:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @_builtins.property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @_builtins.property
    @pulumi.getter
    def decision(self) -> pulumi.Output[_builtins.str]:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessPolicyExclude']]]:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def includes(self) -> pulumi.Output[Sequence['outputs.ZeroTrustAccessPolicyInclude']]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @_builtins.property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @_builtins.property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @_builtins.property
    @pulumi.getter
    def requires(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessPolicyRequire']]]:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

