# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDexTestArgs', 'ZeroTrustDexTest']

@pulumi.input_type
class ZeroTrustDexTestArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 data: pulumi.Input['ZeroTrustDexTestDataArgs'],
                 enabled: pulumi.Input[_builtins.bool],
                 interval: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 target_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]]] = None,
                 targeted: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ZeroTrustDexTest resource.
        :param pulumi.Input['ZeroTrustDexTestDataArgs'] data: The configuration object which contains the details for the WARP client to conduct the test.
        :param pulumi.Input[_builtins.bool] enabled: Determines whether or not the test is active.
        :param pulumi.Input[_builtins.str] interval: How often the test will run.
        :param pulumi.Input[_builtins.str] name: The name of the DEX test. Must be unique.
        :param pulumi.Input[_builtins.str] description: Additional details about the test.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]] target_policies: DEX rules targeted by this test
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if target_policies is not None:
            pulumi.set(__self__, "target_policies", target_policies)
        if targeted is not None:
            pulumi.set(__self__, "targeted", targeted)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Input['ZeroTrustDexTestDataArgs']:
        """
        The configuration object which contains the details for the WARP client to conduct the test.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input['ZeroTrustDexTestDataArgs']):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Determines whether or not the test is active.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.str]:
        """
        How often the test will run.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the DEX test. Must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional details about the test.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="targetPolicies")
    def target_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]]]:
        """
        DEX rules targeted by this test
        """
        return pulumi.get(self, "target_policies")

    @target_policies.setter
    def target_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]]]):
        pulumi.set(self, "target_policies", value)

    @_builtins.property
    @pulumi.getter
    def targeted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "targeted")

    @targeted.setter
    def targeted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "targeted", value)


@pulumi.input_type
class _ZeroTrustDexTestState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input['ZeroTrustDexTestDataArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]]] = None,
                 targeted: Optional[pulumi.Input[_builtins.bool]] = None,
                 test_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDexTest resources.
        :param pulumi.Input['ZeroTrustDexTestDataArgs'] data: The configuration object which contains the details for the WARP client to conduct the test.
        :param pulumi.Input[_builtins.str] description: Additional details about the test.
        :param pulumi.Input[_builtins.bool] enabled: Determines whether or not the test is active.
        :param pulumi.Input[_builtins.str] interval: How often the test will run.
        :param pulumi.Input[_builtins.str] name: The name of the DEX test. Must be unique.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]] target_policies: DEX rules targeted by this test
        :param pulumi.Input[_builtins.str] test_id: The unique identifier for the test.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_policies is not None:
            pulumi.set(__self__, "target_policies", target_policies)
        if targeted is not None:
            pulumi.set(__self__, "targeted", targeted)
        if test_id is not None:
            pulumi.set(__self__, "test_id", test_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input['ZeroTrustDexTestDataArgs']]:
        """
        The configuration object which contains the details for the WARP client to conduct the test.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input['ZeroTrustDexTestDataArgs']]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional details about the test.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether or not the test is active.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How often the test will run.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the DEX test. Must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="targetPolicies")
    def target_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]]]:
        """
        DEX rules targeted by this test
        """
        return pulumi.get(self, "target_policies")

    @target_policies.setter
    def target_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDexTestTargetPolicyArgs']]]]):
        pulumi.set(self, "target_policies", value)

    @_builtins.property
    @pulumi.getter
    def targeted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "targeted")

    @targeted.setter
    def targeted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "targeted", value)

    @_builtins.property
    @pulumi.getter(name="testId")
    def test_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the test.
        """
        return pulumi.get(self, "test_id")

    @test_id.setter
    def test_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "test_id", value)


@pulumi.type_token("cloudflare:index/zeroTrustDexTest:ZeroTrustDexTest")
class ZeroTrustDexTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Union['ZeroTrustDexTestDataArgs', 'ZeroTrustDexTestDataArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDexTestTargetPolicyArgs', 'ZeroTrustDexTestTargetPolicyArgsDict']]]]] = None,
                 targeted: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dex_test = cloudflare.ZeroTrustDexTest("example_zero_trust_dex_test",
            account_id="01a7362d577a6c3019a474fd6f485823",
            data={
                "host": "https://dash.cloudflare.com",
                "kind": "http",
                "method": "GET",
            },
            enabled=True,
            interval="30m",
            name="HTTP dash health check",
            description="Checks the dash endpoint every 30 minutes",
            target_policies=[{
                "id": "id",
                "default": True,
                "name": "name",
            }],
            targeted=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDexTest:ZeroTrustDexTest example '<account_id>/<dex_test_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ZeroTrustDexTestDataArgs', 'ZeroTrustDexTestDataArgsDict']] data: The configuration object which contains the details for the WARP client to conduct the test.
        :param pulumi.Input[_builtins.str] description: Additional details about the test.
        :param pulumi.Input[_builtins.bool] enabled: Determines whether or not the test is active.
        :param pulumi.Input[_builtins.str] interval: How often the test will run.
        :param pulumi.Input[_builtins.str] name: The name of the DEX test. Must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDexTestTargetPolicyArgs', 'ZeroTrustDexTestTargetPolicyArgsDict']]]] target_policies: DEX rules targeted by this test
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDexTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dex_test = cloudflare.ZeroTrustDexTest("example_zero_trust_dex_test",
            account_id="01a7362d577a6c3019a474fd6f485823",
            data={
                "host": "https://dash.cloudflare.com",
                "kind": "http",
                "method": "GET",
            },
            enabled=True,
            interval="30m",
            name="HTTP dash health check",
            description="Checks the dash endpoint every 30 minutes",
            target_policies=[{
                "id": "id",
                "default": True,
                "name": "name",
            }],
            targeted=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDexTest:ZeroTrustDexTest example '<account_id>/<dex_test_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDexTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDexTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data: Optional[pulumi.Input[Union['ZeroTrustDexTestDataArgs', 'ZeroTrustDexTestDataArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDexTestTargetPolicyArgs', 'ZeroTrustDexTestTargetPolicyArgsDict']]]]] = None,
                 targeted: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDexTestArgs.__new__(ZeroTrustDexTestArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["target_policies"] = target_policies
            __props__.__dict__["targeted"] = targeted
            __props__.__dict__["test_id"] = None
        super(ZeroTrustDexTest, __self__).__init__(
            'cloudflare:index/zeroTrustDexTest:ZeroTrustDexTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            data: Optional[pulumi.Input[Union['ZeroTrustDexTestDataArgs', 'ZeroTrustDexTestDataArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            interval: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            target_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDexTestTargetPolicyArgs', 'ZeroTrustDexTestTargetPolicyArgsDict']]]]] = None,
            targeted: Optional[pulumi.Input[_builtins.bool]] = None,
            test_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZeroTrustDexTest':
        """
        Get an existing ZeroTrustDexTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ZeroTrustDexTestDataArgs', 'ZeroTrustDexTestDataArgsDict']] data: The configuration object which contains the details for the WARP client to conduct the test.
        :param pulumi.Input[_builtins.str] description: Additional details about the test.
        :param pulumi.Input[_builtins.bool] enabled: Determines whether or not the test is active.
        :param pulumi.Input[_builtins.str] interval: How often the test will run.
        :param pulumi.Input[_builtins.str] name: The name of the DEX test. Must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDexTestTargetPolicyArgs', 'ZeroTrustDexTestTargetPolicyArgsDict']]]] target_policies: DEX rules targeted by this test
        :param pulumi.Input[_builtins.str] test_id: The unique identifier for the test.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDexTestState.__new__(_ZeroTrustDexTestState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["data"] = data
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["interval"] = interval
        __props__.__dict__["name"] = name
        __props__.__dict__["target_policies"] = target_policies
        __props__.__dict__["targeted"] = targeted
        __props__.__dict__["test_id"] = test_id
        return ZeroTrustDexTest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output['outputs.ZeroTrustDexTestData']:
        """
        The configuration object which contains the details for the WARP client to conduct the test.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Additional details about the test.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Determines whether or not the test is active.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[_builtins.str]:
        """
        How often the test will run.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the DEX test. Must be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetPolicies")
    def target_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDexTestTargetPolicy']]]:
        """
        DEX rules targeted by this test
        """
        return pulumi.get(self, "target_policies")

    @_builtins.property
    @pulumi.getter
    def targeted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "targeted")

    @_builtins.property
    @pulumi.getter(name="testId")
    def test_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the test.
        """
        return pulumi.get(self, "test_id")

