import { Resource, aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Represents a GitHub repository
 */
export interface RepositoryConfig {
    /**
     * The owner of the repository.
     */
    readonly owner: string;
    /**
     * The name of the repository.
     */
    readonly repo: string;
    /**
     * The sub prefix string from the JWT token used to be validated by AWS. Appended after `repo:${owner}/${repo}:`
     * in an IAM role trust relationship. The default value '*' indicates all branches and all tags from this repo.
     *
     * Example:
     * repo:octo-org/octo-repo:ref:refs/heads/demo-branch - only allowed from `demo-branch`
     * repo:octo-org/octo-repo:ref:refs/tags/demo-tag - only allowed from `demo-tag`.
     * repo:octo-org/octo-repo:pull_request - only allowed from the `pull_request` event.
     * repo:octo-org/octo-repo:environment:Production - only allowd from `Production` environment name.
     *
     * @default '*'
     * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect#configuring-the-oidc-trust-with-the-cloud
     */
    readonly filter?: string;
}
export declare abstract class ProviderBase extends Resource {
    abstract readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    /**
     *
     * @param repo a list of repositories
     * @returns a list of subjects
     */
    private formatSubject;
    createRole(id: string, repo: RepositoryConfig[], roleProps?: iam.RoleProps): iam.Role;
}
/**
 * The Github OpenID Connect Provider
 */
export declare class Provider extends ProviderBase {
    /**
     * import the existing provider
     */
    static fromAccount(scope: Construct, id: string): ProviderBase;
    readonly issuer: string;
    readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    constructor(scope: Construct, id: string);
}
