"""Author: Jorrit Bakker.

File containing results from testing data for the transport model.
"""

import numpy as np
from mibitrans.data.read import AdsorptionParameters
from mibitrans.data.read import DegradationParameters
from mibitrans.data.read import HydrologicalParameters
from mibitrans.data.read import ModelParameters
from mibitrans.data.read import SourceParameters

test_hydro_pars = HydrologicalParameters(velocity=10 / 365, porosity=0.25, alpha_x=10, alpha_y=1, alpha_z=0.1)

test_ads_pars = AdsorptionParameters(retardation=1)

test_deg_pars = DegradationParameters(
    half_life=0.1 * 365, delta_oxygen=0.5, delta_nitrate=0.5, ferrous_iron=0.5, delta_sulfate=0.5, methane=0.5
)

test_source_pars = SourceParameters(
    source_zone_boundary=np.array([5, 10, 15]),
    source_zone_concentration=np.array([10, 5, 2]),
    depth=10,
    total_mass=1000000,
)

test_model_pars = ModelParameters(model_length=50, model_width=30, model_time=3 * 365, dx=10, dy=5, dt=1 * 365)

testingdata_nodecay = np.array(
    [
        [
            [0.00000000e00, 7.29338809e-01, 4.61369298e-01, 1.76413628e-01, 4.15239315e-02, 6.03372787e-03],
            [1.99151804e00, 1.94666325e00, 9.82280001e-01, 3.24800918e-01, 6.92390684e-02, 9.36629471e-03],
            [4.97879509e00, 3.50737679e00, 1.54150103e00, 4.67518683e-01, 9.39808944e-02, 1.21848229e-02],
            [9.95759018e00, 4.30230160e00, 1.79262755e00, 5.27813089e-01, 1.04040721e-01, 1.33000836e-02],
            [4.97879509e00, 3.50737679e00, 1.54150103e00, 4.67518683e-01, 9.39808944e-02, 1.21848229e-02],
            [1.99151804e00, 1.94666325e00, 9.82280001e-01, 3.24800918e-01, 6.92390684e-02, 9.36629471e-03],
            [0.00000000e00, 7.29338809e-01, 4.61369298e-01, 1.76413628e-01, 4.15239315e-02, 6.03372787e-03],
        ],
        [
            [0.00000000e00, 1.00434327e00, 9.62188073e-01, 6.92059770e-01, 3.88730984e-01, 1.72346862e-01],
            [1.98307205e00, 2.68067203e00, 2.04855005e00, 1.27417395e00, 6.48189376e-01, 2.67538002e-01],
            [4.95768011e00, 4.82986815e00, 3.21480841e00, 1.83404693e00, 8.79812781e-01, 3.48046189e-01],
            [9.91536023e00, 5.92452728e00, 3.73853409e00, 2.07057816e00, 9.73988987e-01, 3.79902396e-01],
            [4.95768011e00, 4.82986815e00, 3.21480841e00, 1.83404693e00, 8.79812781e-01, 3.48046189e-01],
            [1.98307205e00, 2.68067203e00, 2.04855005e00, 1.27417395e00, 6.48189376e-01, 2.67538002e-01],
            [0.00000000e00, 1.00434327e00, 9.62188073e-01, 6.92059770e-01, 3.88730984e-01, 1.72346862e-01],
        ],
        [
            [0.00000000e00, 1.14678447e00, 1.26173994e00, 1.12151632e00, 8.36842100e-01, 5.34290144e-01],
            [1.97466187e00, 3.06085890e00, 2.68631207e00, 2.06486049e00, 1.39539214e00, 8.29390894e-01],
            [4.93665468e00, 5.51486523e00, 4.21565419e00, 2.97216173e00, 1.89402030e00, 1.07897322e00],
            [9.87330937e00, 6.76477462e00, 4.90242805e00, 3.35547203e00, 2.09675848e00, 1.17773021e00],
            [4.93665468e00, 5.51486523e00, 4.21565419e00, 2.97216173e00, 1.89402030e00, 1.07897322e00],
            [1.97466187e00, 3.06085890e00, 2.68631207e00, 2.06486049e00, 1.39539214e00, 8.29390894e-01],
            [0.00000000e00, 1.14678447e00, 1.26173994e00, 1.12151632e00, 8.36842100e-01, 5.34290144e-01],
        ],
    ]
)

testingdata_lineardecay = np.array(
    [
        [
            [0.00000000e00, 1.64750580e-01, 2.43834704e-02, 3.08739472e-03, 3.33028964e-04, 2.86132827e-05],
            [1.99136794e00, 4.39732393e-01, 5.19137172e-02, 5.68430372e-03, 5.55309057e-04, 4.44170576e-05],
            [4.97841984e00, 7.92282480e-01, 8.14686732e-02, 8.18199099e-03, 7.53742693e-04, 5.77831466e-05],
            [9.95683968e00, 9.71848303e-01, 9.47407663e-02, 9.23719650e-03, 8.34424206e-04, 6.30719617e-05],
            [4.97841984e00, 7.92282480e-01, 8.14686732e-02, 8.18199099e-03, 7.53742693e-04, 5.77831466e-05],
            [1.99136794e00, 4.39732393e-01, 5.19137172e-02, 5.68430372e-03, 5.55309057e-04, 4.44170576e-05],
            [0.00000000e00, 1.64750580e-01, 2.43834704e-02, 3.08739472e-03, 3.33028964e-04, 2.86132827e-05],
        ],
        [
            [0.00000000e00, 1.64220190e-01, 2.45987826e-02, 3.24153453e-03, 4.00200991e-04, 4.75580882e-05],
            [1.98307196e00, 4.38316741e-01, 5.23721285e-02, 5.96809559e-03, 6.67315036e-04, 7.38255155e-05],
            [4.95767991e00, 7.89731846e-01, 8.21880621e-02, 8.59048121e-03, 9.05772787e-04, 9.60412692e-05],
            [9.91535982e00, 9.68719584e-01, 9.55773511e-02, 9.69836842e-03, 1.00272778e-03, 1.04831800e-04],
            [4.95767991e00, 7.89731846e-01, 8.21880621e-02, 8.59048121e-03, 9.05772787e-04, 9.60412692e-05],
            [1.98307196e00, 4.38316741e-01, 5.23721285e-02, 5.96809559e-03, 6.67315036e-04, 7.38255155e-05],
            [0.00000000e00, 1.64220190e-01, 2.45987826e-02, 3.24153453e-03, 4.00200991e-04, 4.75580882e-05],
        ],
        [
            [0.00000000e00, 1.63523832e-01, 2.44946190e-02, 3.24171843e-03, 4.00357048e-04, 4.76590051e-05],
            [1.97466187e00, 4.36458104e-01, 5.21503587e-02, 5.96843416e-03, 6.67575252e-04, 7.39821710e-05],
            [4.93665468e00, 7.86383070e-01, 8.18400367e-02, 8.59096855e-03, 9.06125988e-04, 9.62450659e-05],
            [9.87330937e00, 9.64611829e-01, 9.51726288e-02, 9.69891861e-03, 1.00311879e-03, 1.05054250e-04],
            [4.93665468e00, 7.86383070e-01, 8.18400367e-02, 8.59096855e-03, 9.06125988e-04, 9.62450659e-05],
            [1.97466187e00, 4.36458104e-01, 5.21503587e-02, 5.96843416e-03, 6.67575252e-04, 7.39821710e-05],
            [0.00000000e00, 1.63523832e-01, 2.44946190e-02, 3.24171843e-03, 4.00357048e-04, 4.76590051e-05],
        ],
    ]
)

testingdata_instantreaction = np.array(
    [
        [
            [0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            [1.95334576, 1.34915424, 0.13895001, 0.0, 0.0, 0.0],
            [4.93831241, 2.96941714, 0.73579509, 0.0, 0.0, 0.0],
            [9.91325682, 3.7702826, 0.99651157, 0.0, 0.0, 0.0],
            [4.93831241, 2.96941714, 0.73579509, 0.0, 0.0, 0.0],
            [1.95334576, 1.34915424, 0.13895001, 0.0, 0.0, 0.0],
            [0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
        ],
        [
            [0.0, 0.31594434, 0.18056652, 0.0, 0.0, 0.0],
            [1.93838774, 2.2443136, 1.40961081, 0.47088322, 0.0, 0.0],
            [4.90839637, 4.47378712, 2.65433433, 1.0790903, 0.0, 0.0],
            [9.85841075, 5.57577393, 3.19805989, 1.33118869, 0.08612541, 0.0],
            [4.90839637, 4.47378712, 2.65433433, 1.0790903, 0.0, 0.0],
            [1.93838774, 2.2443136, 1.40961081, 0.47088322, 0.0, 0.0],
            [0.0, 0.31594434, 0.18056652, 0.0, 0.0, 0.0],
        ],
        [
            [0.0, 0.50587302, 0.55671969, 0.33985742, 0.0, 0.0],
            [1.92350468, 2.7060307, 2.167148, 1.40325966, 0.60594149, 0.0],
            [4.87863024, 5.24973091, 3.79812094, 2.38888864, 1.15448996, 0.21662451],
            [9.80383951, 6.50703406, 4.51056967, 2.79742628, 1.37461168, 0.3252639],
            [4.87863024, 5.24973091, 3.79812094, 2.38888864, 1.15448996, 0.21662451],
            [1.92350468, 2.7060307, 2.167148, 1.40325966, 0.60594149, 0.0],
            [0.0, 0.50587302, 0.55671969, 0.33985742, 0.0, 0.0],
        ],
    ]
)


testing_massbalance_nodecay = {
    "time": np.int64(1095),
    "source_mass_0": 1000000,
    "source_mass_t": np.float64(987330.9369029925),
    "source_mass_change": np.float64(12669.063097007456),
    "plume_mass_no_decay": np.float64(10884.801775892505),
    "transport_outside_extent_nodecay": np.float64(1784.261321114951),
}

testing_massbalance_lindecay = {
    "time": np.int64(1095),
    "source_mass_0": 1000000,
    "source_mass_t": np.float64(987330.9369029925),
    "source_mass_change": np.float64(12669.063097007456),
    "plume_mass_no_decay": np.float64(10884.801775892505),
    "transport_outside_extent_nodecay": np.float64(1784.261321114951),
    "plume_mass_linear_decay": np.float64(1682.1452404554184),
    "transport_outside_extent_lineardecay": np.float64(275.74105168269006),
    "plume_mass_degraded_linear": np.float64(10711.176804869348),
}

testing_massbalance_instant = {
    "time": np.int64(1095),
    "source_mass_0": 1000000,
    "source_mass_t": np.float64(987330.9369029925),
    "source_mass_change": np.float64(12669.063097007456),
    "plume_mass_no_decay": np.float64(10884.801775892505),
    "transport_outside_extent_nodecay": np.float64(1784.261321114951),
    "source_mass_instant_t": np.float64(985041.8543464276),
    "source_mass_instant_change": np.float64(14958.1456535724),
    "plume_mass_no_decay_instant_reaction": np.float64(12672.723731642844),
    "plume_mass_instant_reaction": np.float64(8702.610542371283),
    "plume_mass_degraded_instant": np.float64(3970.1131892715603),
    "electron_acceptor_mass_change": np.array(
        [1924.21133006, 1924.21133006, 1924.21133006, 1924.21133006, 1924.21133006]
    ),
}
