# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.auth_type import AuthType
from ..types.bulk_export_connections_response import BulkExportConnectionsResponse
from ..types.bulk_import_connections_response import BulkImportConnectionsResponse
from ..types.bulk_ops_response import BulkOpsResponse
from ..types.connection_recipe import ConnectionRecipe
from ..types.demo_connection_status import DemoConnectionStatus
from ..types.demo_providers import DemoProviders
from ..types.http_validation_error import HttpValidationError
from ..types.link_token_exchange_response import LinkTokenExchangeResponse
from ..types.manual_providers import ManualProviders
from ..types.o_auth_providers import OAuthProviders
from ..types.password_providers import PasswordProviders
from ..types.provider_link_response import ProviderLinkResponse
from ..types.providers import Providers
from ..types.region import Region
from ..types.source import Source
from ..types.source_link import SourceLink
from ..types.vital_token_created_response import VitalTokenCreatedResponse
from .types.link_bulk_export_request_team_id import LinkBulkExportRequestTeamId
from .types.link_bulk_import_request_team_id import LinkBulkImportRequestTeamId
from .types.link_bulk_pause_request_team_id import LinkBulkPauseRequestTeamId
from .types.link_bulk_trigger_historical_pull_request_team_id import LinkBulkTriggerHistoricalPullRequestTeamId
from .types.link_list_bulk_ops_request_team_id import LinkListBulkOpsRequestTeamId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawLinkClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_bulk_ops(
        self,
        *,
        next_cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        team_id: typing.Optional[LinkListBulkOpsRequestTeamId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[BulkOpsResponse]:
        """
        Parameters
        ----------
        next_cursor : typing.Optional[str]

        page_size : typing.Optional[int]

        team_id : typing.Optional[LinkListBulkOpsRequestTeamId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BulkOpsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/bulk_op",
            method="GET",
            params={
                "next_cursor": next_cursor,
                "page_size": page_size,
                "team_id": team_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkOpsResponse,
                    parse_obj_as(
                        type_=BulkOpsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def bulk_import(
        self,
        *,
        provider: OAuthProviders,
        connections: typing.Sequence[ConnectionRecipe],
        team_id: typing.Optional[LinkBulkImportRequestTeamId] = None,
        wait_for_completion: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[BulkImportConnectionsResponse]:
        """
        Parameters
        ----------
        provider : OAuthProviders

        connections : typing.Sequence[ConnectionRecipe]

        team_id : typing.Optional[LinkBulkImportRequestTeamId]

        wait_for_completion : typing.Optional[bool]

            Whether or not the endpoint should wait for the Bulk Op to complete before responding.

            When `wait_for_completion` is enabled, the endpoint may respond 200 OK if the Bulk Op takes less than 20 seconds to complete.

            Otherwise, the endpoint always responds with 202 Created once the submitted data have been enqueued successfully. You can use
            the [List Bulk Ops](https://docs.tryvital.io/api-reference/link/list-bulk-ops) endpoint to inspect the progress of the Bulk Op.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BulkImportConnectionsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/bulk_import",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "provider": provider,
                "connections": connections,
                "wait_for_completion": wait_for_completion,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkImportConnectionsResponse,
                    parse_obj_as(
                        type_=BulkImportConnectionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def bulk_trigger_historical_pull(
        self,
        *,
        user_ids: typing.Sequence[str],
        provider: OAuthProviders,
        team_id: typing.Optional[LinkBulkTriggerHistoricalPullRequestTeamId] = None,
        wait_for_completion: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        user_ids : typing.Sequence[str]

        provider : OAuthProviders

        team_id : typing.Optional[LinkBulkTriggerHistoricalPullRequestTeamId]

        wait_for_completion : typing.Optional[bool]

            Whether or not the endpoint should wait for the Bulk Op to complete before responding.

            When `wait_for_completion` is enabled, the endpoint may respond 200 OK if the Bulk Op takes less than 20 seconds to complete.

            Otherwise, the endpoint always responds with 202 Created once the submitted data have been enqueued successfully. You can use
            the [List Bulk Ops](https://docs.tryvital.io/api-reference/link/list-bulk-ops) endpoint to inspect the progress of the Bulk Op.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/bulk_trigger_historical_pull",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "user_ids": user_ids,
                "provider": provider,
                "wait_for_completion": wait_for_completion,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def bulk_export(
        self,
        *,
        provider: OAuthProviders,
        team_id: typing.Optional[LinkBulkExportRequestTeamId] = None,
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        next_token: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[BulkExportConnectionsResponse]:
        """
        Parameters
        ----------
        provider : OAuthProviders

        team_id : typing.Optional[LinkBulkExportRequestTeamId]

        user_ids : typing.Optional[typing.Sequence[str]]

        next_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[BulkExportConnectionsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/bulk_export",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "user_ids": user_ids,
                "provider": provider,
                "next_token": next_token,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkExportConnectionsResponse,
                    parse_obj_as(
                        type_=BulkExportConnectionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def bulk_pause(
        self,
        *,
        user_ids: typing.Sequence[str],
        provider: OAuthProviders,
        team_id: typing.Optional[LinkBulkPauseRequestTeamId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        user_ids : typing.Sequence[str]

        provider : OAuthProviders

        team_id : typing.Optional[LinkBulkPauseRequestTeamId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/bulk_pause",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "user_ids": user_ids,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def token(
        self,
        *,
        user_id: str,
        provider: typing.Optional[Providers] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        filter_on_providers: typing.Optional[typing.Sequence[Providers]] = OMIT,
        on_error: typing.Optional[typing.Literal["redirect"]] = OMIT,
        on_close: typing.Optional[typing.Literal["redirect"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[LinkTokenExchangeResponse]:
        """
        Endpoint to generate a user link token, to be used throughout the vital
        link process. The vital link token is a one time use token, that
        expires after 10 minutes. If you would like vital-link widget to launch
        with a specific provider, pass in a provider in the body. If you would
        like to redirect to a custom url after successful or error connection,
        pass in your own custom redirect_url parameter.

        Parameters
        ----------
        user_id : str
            User id returned by vital create user request. This id should be stored in your database against the user and used for all interactions with the vital api.

        provider : typing.Optional[Providers]

        redirect_url : typing.Optional[str]

        filter_on_providers : typing.Optional[typing.Sequence[Providers]]
            An allowlist of providers dictating what Vital Link Widget should show to the end user.
            If unspecified, all linkable providers are shown.

            This has no effect on programmatic Vital Link API usage.

        on_error : typing.Optional[typing.Literal["redirect"]]
            By default, Vital Link Widget input forms for password and email providers have in-built error handling.

            Specifying `on_error=redirect` disables this Vital Link Widget UI behaviour — it would
            instead redirect to your `redirect_url`, with Link Error parameters injected.

            This has no effect on OAuth providers — they always redirect to your `redirect_url`. This also has
            no effect on programmatic Vital Link API usage.

        on_close : typing.Optional[typing.Literal["redirect"]]
            By default, Vital Link Widget closes the window or tab when the user taps the Close button.

            Specifying `on_close=redirect` would change the Close button behaviour to redirect to your `redirect_url`
            with the `user_cancelled` error specified.

            This has no effect on programmatic Vital Link API usage.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[LinkTokenExchangeResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/token",
            method="POST",
            json={
                "user_id": user_id,
                "provider": provider,
                "redirect_url": redirect_url,
                "filter_on_providers": filter_on_providers,
                "on_error": on_error,
                "on_close": on_close,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LinkTokenExchangeResponse,
                    parse_obj_as(
                        type_=LinkTokenExchangeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def is_token_valid(
        self, *, token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        Parameters
        ----------
        token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/token/isValid",
            method="POST",
            json={
                "token": token,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def code_create(
        self,
        *,
        user_id: str,
        expires_at: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[VitalTokenCreatedResponse]:
        """
        Generate a token to invite a user of Vital mobile app to your team

        Parameters
        ----------
        user_id : str

        expires_at : typing.Optional[dt.datetime]
            When the link code should expire. Defaults to server time plus 1 hour.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[VitalTokenCreatedResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/code/create",
            method="POST",
            params={
                "user_id": user_id,
                "expires_at": serialize_datetime(expires_at) if expires_at is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VitalTokenCreatedResponse,
                    parse_obj_as(
                        type_=VitalTokenCreatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def start_connect(
        self, *, link_token: str, provider: Providers, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        REQUEST_SOURCE: VITAL-LINK
        Start link token process

        Parameters
        ----------
        link_token : str

        provider : Providers

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/start",
            method="POST",
            json={
                "link_token": link_token,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def token_state(
        self, *, vital_link_token: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        REQUEST_SOURCE: VITAL-LINK
        Check link token state - can be hit continuously used as heartbeat

        Parameters
        ----------
        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/state",
            method="GET",
            headers={
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def email_auth(
        self,
        *,
        email: str,
        provider: Providers,
        auth_type: AuthType,
        vital_link_token: typing.Optional[str] = None,
        region: typing.Optional[Region] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Deprecated. Use `POST /v2/link/provider/email/{provider}` instead.

        Parameters
        ----------
        email : str

        provider : Providers

        auth_type : AuthType

        vital_link_token : typing.Optional[str]

        region : typing.Optional[Region]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/auth/email",
            method="POST",
            json={
                "email": email,
                "provider": provider,
                "auth_type": auth_type,
                "region": region,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def password_auth(
        self,
        *,
        username: str,
        password: str,
        provider: Providers,
        auth_type: AuthType,
        vital_link_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Deprecated. Use `POST /v2/link/provider/password/{provider}` instead.

        Parameters
        ----------
        username : str

        password : str

        provider : Providers

        auth_type : AuthType

        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/auth",
            method="POST",
            json={
                "username": username,
                "password": password,
                "provider": provider,
                "auth_type": auth_type,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def generate_oauth_link(
        self,
        oauth_provider: OAuthProviders,
        *,
        vital_link_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Source]:
        """
        This endpoint generates an OAuth link for oauth provider

        Parameters
        ----------
        oauth_provider : OAuthProviders

        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Source]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/link/provider/oauth/{jsonable_encoder(oauth_provider)}",
            method="GET",
            headers={
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Source,
                    parse_obj_as(
                        type_=Source,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def connect_password_provider(
        self,
        provider: PasswordProviders,
        *,
        username: str,
        password: str,
        vital_link_token: typing.Optional[str] = None,
        region: typing.Optional[Region] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProviderLinkResponse]:
        """
        This connects auth providers that are password based.

        Parameters
        ----------
        provider : PasswordProviders

        username : str
            Username for provider

        password : str
            Password for provider

        vital_link_token : typing.Optional[str]

        region : typing.Optional[Region]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProviderLinkResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/link/provider/password/{jsonable_encoder(provider)}",
            method="POST",
            json={
                "username": username,
                "password": password,
                "region": region,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProviderLinkResponse,
                    parse_obj_as(
                        type_=ProviderLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def complete_password_provider_mfa(
        self,
        provider: PasswordProviders,
        *,
        mfa_code: str,
        vital_link_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProviderLinkResponse]:
        """
        This connects auth providers that are password based.

        Parameters
        ----------
        provider : PasswordProviders

        mfa_code : str

        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProviderLinkResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/link/provider/password/{jsonable_encoder(provider)}/complete_mfa",
            method="POST",
            json={
                "mfa_code": mfa_code,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProviderLinkResponse,
                    parse_obj_as(
                        type_=ProviderLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def connect_email_auth_provider(
        self,
        *,
        email: str,
        vital_link_token: typing.Optional[str] = None,
        email_provider_auth_link_provider: typing.Optional[Providers] = OMIT,
        region: typing.Optional[Region] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        This connects auth providers that are email based.

        Parameters
        ----------
        email : str

        vital_link_token : typing.Optional[str]

        email_provider_auth_link_provider : typing.Optional[Providers]

        region : typing.Optional[Region]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/provider/email/freestyle_libre",
            method="POST",
            json={
                "email": email,
                "provider": email_provider_auth_link_provider,
                "region": region,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_all_providers(
        self, *, vital_link_token: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[SourceLink]]:
        """
        GET List of all available providers given the generated link token.

        Parameters
        ----------
        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[SourceLink]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/providers",
            method="GET",
            headers={
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[SourceLink],
                    parse_obj_as(
                        type_=typing.List[SourceLink],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def connect_manual_provider(
        self,
        provider: ManualProviders,
        *,
        user_id: str,
        provider_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Dict[str, bool]]:
        """
        Parameters
        ----------
        provider : ManualProviders

        user_id : str

        provider_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, bool]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/link/provider/manual/{jsonable_encoder(provider)}",
            method="POST",
            json={
                "user_id": user_id,
                "provider_id": provider_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, bool],
                    parse_obj_as(
                        type_=typing.Dict[str, bool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def connect_demo_provider(
        self, *, user_id: str, provider: DemoProviders, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DemoConnectionStatus]:
        """
        POST Connect the given Vital user to a demo provider.

        Parameters
        ----------
        user_id : str
            Vital user ID

        provider : DemoProviders
            Demo provider. For more information, please check out our docs (https://docs.tryvital.io/wearables/providers/test_data)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DemoConnectionStatus]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/link/connect/demo",
            method="POST",
            json={
                "user_id": user_id,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DemoConnectionStatus,
                    parse_obj_as(
                        type_=DemoConnectionStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawLinkClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_bulk_ops(
        self,
        *,
        next_cursor: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        team_id: typing.Optional[LinkListBulkOpsRequestTeamId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[BulkOpsResponse]:
        """
        Parameters
        ----------
        next_cursor : typing.Optional[str]

        page_size : typing.Optional[int]

        team_id : typing.Optional[LinkListBulkOpsRequestTeamId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BulkOpsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/bulk_op",
            method="GET",
            params={
                "next_cursor": next_cursor,
                "page_size": page_size,
                "team_id": team_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkOpsResponse,
                    parse_obj_as(
                        type_=BulkOpsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def bulk_import(
        self,
        *,
        provider: OAuthProviders,
        connections: typing.Sequence[ConnectionRecipe],
        team_id: typing.Optional[LinkBulkImportRequestTeamId] = None,
        wait_for_completion: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[BulkImportConnectionsResponse]:
        """
        Parameters
        ----------
        provider : OAuthProviders

        connections : typing.Sequence[ConnectionRecipe]

        team_id : typing.Optional[LinkBulkImportRequestTeamId]

        wait_for_completion : typing.Optional[bool]

            Whether or not the endpoint should wait for the Bulk Op to complete before responding.

            When `wait_for_completion` is enabled, the endpoint may respond 200 OK if the Bulk Op takes less than 20 seconds to complete.

            Otherwise, the endpoint always responds with 202 Created once the submitted data have been enqueued successfully. You can use
            the [List Bulk Ops](https://docs.tryvital.io/api-reference/link/list-bulk-ops) endpoint to inspect the progress of the Bulk Op.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BulkImportConnectionsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/bulk_import",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "provider": provider,
                "connections": connections,
                "wait_for_completion": wait_for_completion,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkImportConnectionsResponse,
                    parse_obj_as(
                        type_=BulkImportConnectionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def bulk_trigger_historical_pull(
        self,
        *,
        user_ids: typing.Sequence[str],
        provider: OAuthProviders,
        team_id: typing.Optional[LinkBulkTriggerHistoricalPullRequestTeamId] = None,
        wait_for_completion: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        user_ids : typing.Sequence[str]

        provider : OAuthProviders

        team_id : typing.Optional[LinkBulkTriggerHistoricalPullRequestTeamId]

        wait_for_completion : typing.Optional[bool]

            Whether or not the endpoint should wait for the Bulk Op to complete before responding.

            When `wait_for_completion` is enabled, the endpoint may respond 200 OK if the Bulk Op takes less than 20 seconds to complete.

            Otherwise, the endpoint always responds with 202 Created once the submitted data have been enqueued successfully. You can use
            the [List Bulk Ops](https://docs.tryvital.io/api-reference/link/list-bulk-ops) endpoint to inspect the progress of the Bulk Op.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/bulk_trigger_historical_pull",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "user_ids": user_ids,
                "provider": provider,
                "wait_for_completion": wait_for_completion,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def bulk_export(
        self,
        *,
        provider: OAuthProviders,
        team_id: typing.Optional[LinkBulkExportRequestTeamId] = None,
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        next_token: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[BulkExportConnectionsResponse]:
        """
        Parameters
        ----------
        provider : OAuthProviders

        team_id : typing.Optional[LinkBulkExportRequestTeamId]

        user_ids : typing.Optional[typing.Sequence[str]]

        next_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[BulkExportConnectionsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/bulk_export",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "user_ids": user_ids,
                "provider": provider,
                "next_token": next_token,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    BulkExportConnectionsResponse,
                    parse_obj_as(
                        type_=BulkExportConnectionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def bulk_pause(
        self,
        *,
        user_ids: typing.Sequence[str],
        provider: OAuthProviders,
        team_id: typing.Optional[LinkBulkPauseRequestTeamId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        user_ids : typing.Sequence[str]

        provider : OAuthProviders

        team_id : typing.Optional[LinkBulkPauseRequestTeamId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/bulk_pause",
            method="POST",
            params={
                "team_id": team_id,
            },
            json={
                "user_ids": user_ids,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def token(
        self,
        *,
        user_id: str,
        provider: typing.Optional[Providers] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        filter_on_providers: typing.Optional[typing.Sequence[Providers]] = OMIT,
        on_error: typing.Optional[typing.Literal["redirect"]] = OMIT,
        on_close: typing.Optional[typing.Literal["redirect"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[LinkTokenExchangeResponse]:
        """
        Endpoint to generate a user link token, to be used throughout the vital
        link process. The vital link token is a one time use token, that
        expires after 10 minutes. If you would like vital-link widget to launch
        with a specific provider, pass in a provider in the body. If you would
        like to redirect to a custom url after successful or error connection,
        pass in your own custom redirect_url parameter.

        Parameters
        ----------
        user_id : str
            User id returned by vital create user request. This id should be stored in your database against the user and used for all interactions with the vital api.

        provider : typing.Optional[Providers]

        redirect_url : typing.Optional[str]

        filter_on_providers : typing.Optional[typing.Sequence[Providers]]
            An allowlist of providers dictating what Vital Link Widget should show to the end user.
            If unspecified, all linkable providers are shown.

            This has no effect on programmatic Vital Link API usage.

        on_error : typing.Optional[typing.Literal["redirect"]]
            By default, Vital Link Widget input forms for password and email providers have in-built error handling.

            Specifying `on_error=redirect` disables this Vital Link Widget UI behaviour — it would
            instead redirect to your `redirect_url`, with Link Error parameters injected.

            This has no effect on OAuth providers — they always redirect to your `redirect_url`. This also has
            no effect on programmatic Vital Link API usage.

        on_close : typing.Optional[typing.Literal["redirect"]]
            By default, Vital Link Widget closes the window or tab when the user taps the Close button.

            Specifying `on_close=redirect` would change the Close button behaviour to redirect to your `redirect_url`
            with the `user_cancelled` error specified.

            This has no effect on programmatic Vital Link API usage.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[LinkTokenExchangeResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/token",
            method="POST",
            json={
                "user_id": user_id,
                "provider": provider,
                "redirect_url": redirect_url,
                "filter_on_providers": filter_on_providers,
                "on_error": on_error,
                "on_close": on_close,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LinkTokenExchangeResponse,
                    parse_obj_as(
                        type_=LinkTokenExchangeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def is_token_valid(
        self, *, token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        Parameters
        ----------
        token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/token/isValid",
            method="POST",
            json={
                "token": token,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def code_create(
        self,
        *,
        user_id: str,
        expires_at: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[VitalTokenCreatedResponse]:
        """
        Generate a token to invite a user of Vital mobile app to your team

        Parameters
        ----------
        user_id : str

        expires_at : typing.Optional[dt.datetime]
            When the link code should expire. Defaults to server time plus 1 hour.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[VitalTokenCreatedResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/code/create",
            method="POST",
            params={
                "user_id": user_id,
                "expires_at": serialize_datetime(expires_at) if expires_at is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VitalTokenCreatedResponse,
                    parse_obj_as(
                        type_=VitalTokenCreatedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def start_connect(
        self, *, link_token: str, provider: Providers, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        REQUEST_SOURCE: VITAL-LINK
        Start link token process

        Parameters
        ----------
        link_token : str

        provider : Providers

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/start",
            method="POST",
            json={
                "link_token": link_token,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def token_state(
        self, *, vital_link_token: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        REQUEST_SOURCE: VITAL-LINK
        Check link token state - can be hit continuously used as heartbeat

        Parameters
        ----------
        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/state",
            method="GET",
            headers={
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.Optional[typing.Any]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.Optional[typing.Any]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def email_auth(
        self,
        *,
        email: str,
        provider: Providers,
        auth_type: AuthType,
        vital_link_token: typing.Optional[str] = None,
        region: typing.Optional[Region] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Deprecated. Use `POST /v2/link/provider/email/{provider}` instead.

        Parameters
        ----------
        email : str

        provider : Providers

        auth_type : AuthType

        vital_link_token : typing.Optional[str]

        region : typing.Optional[Region]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/auth/email",
            method="POST",
            json={
                "email": email,
                "provider": provider,
                "auth_type": auth_type,
                "region": region,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def password_auth(
        self,
        *,
        username: str,
        password: str,
        provider: Providers,
        auth_type: AuthType,
        vital_link_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Deprecated. Use `POST /v2/link/provider/password/{provider}` instead.

        Parameters
        ----------
        username : str

        password : str

        provider : Providers

        auth_type : AuthType

        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/auth",
            method="POST",
            json={
                "username": username,
                "password": password,
                "provider": provider,
                "auth_type": auth_type,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def generate_oauth_link(
        self,
        oauth_provider: OAuthProviders,
        *,
        vital_link_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Source]:
        """
        This endpoint generates an OAuth link for oauth provider

        Parameters
        ----------
        oauth_provider : OAuthProviders

        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Source]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/link/provider/oauth/{jsonable_encoder(oauth_provider)}",
            method="GET",
            headers={
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Source,
                    parse_obj_as(
                        type_=Source,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def connect_password_provider(
        self,
        provider: PasswordProviders,
        *,
        username: str,
        password: str,
        vital_link_token: typing.Optional[str] = None,
        region: typing.Optional[Region] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProviderLinkResponse]:
        """
        This connects auth providers that are password based.

        Parameters
        ----------
        provider : PasswordProviders

        username : str
            Username for provider

        password : str
            Password for provider

        vital_link_token : typing.Optional[str]

        region : typing.Optional[Region]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProviderLinkResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/link/provider/password/{jsonable_encoder(provider)}",
            method="POST",
            json={
                "username": username,
                "password": password,
                "region": region,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProviderLinkResponse,
                    parse_obj_as(
                        type_=ProviderLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def complete_password_provider_mfa(
        self,
        provider: PasswordProviders,
        *,
        mfa_code: str,
        vital_link_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProviderLinkResponse]:
        """
        This connects auth providers that are password based.

        Parameters
        ----------
        provider : PasswordProviders

        mfa_code : str

        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProviderLinkResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/link/provider/password/{jsonable_encoder(provider)}/complete_mfa",
            method="POST",
            json={
                "mfa_code": mfa_code,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProviderLinkResponse,
                    parse_obj_as(
                        type_=ProviderLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def connect_email_auth_provider(
        self,
        *,
        email: str,
        vital_link_token: typing.Optional[str] = None,
        email_provider_auth_link_provider: typing.Optional[Providers] = OMIT,
        region: typing.Optional[Region] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        This connects auth providers that are email based.

        Parameters
        ----------
        email : str

        vital_link_token : typing.Optional[str]

        email_provider_auth_link_provider : typing.Optional[Providers]

        region : typing.Optional[Region]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/provider/email/freestyle_libre",
            method="POST",
            json={
                "email": email,
                "provider": email_provider_auth_link_provider,
                "region": region,
            },
            headers={
                "content-type": "application/json",
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_all_providers(
        self, *, vital_link_token: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[SourceLink]]:
        """
        GET List of all available providers given the generated link token.

        Parameters
        ----------
        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[SourceLink]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/providers",
            method="GET",
            headers={
                "x-vital-link-token": str(vital_link_token) if vital_link_token is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[SourceLink],
                    parse_obj_as(
                        type_=typing.List[SourceLink],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def connect_manual_provider(
        self,
        provider: ManualProviders,
        *,
        user_id: str,
        provider_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Dict[str, bool]]:
        """
        Parameters
        ----------
        provider : ManualProviders

        user_id : str

        provider_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, bool]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/link/provider/manual/{jsonable_encoder(provider)}",
            method="POST",
            json={
                "user_id": user_id,
                "provider_id": provider_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, bool],
                    parse_obj_as(
                        type_=typing.Dict[str, bool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def connect_demo_provider(
        self, *, user_id: str, provider: DemoProviders, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DemoConnectionStatus]:
        """
        POST Connect the given Vital user to a demo provider.

        Parameters
        ----------
        user_id : str
            Vital user ID

        provider : DemoProviders
            Demo provider. For more information, please check out our docs (https://docs.tryvital.io/wearables/providers/test_data)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DemoConnectionStatus]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/link/connect/demo",
            method="POST",
            json={
                "user_id": user_id,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DemoConnectionStatus,
                    parse_obj_as(
                        type_=DemoConnectionStatus,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
