# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_electrocardiogram_classification import ClientFacingElectrocardiogramClassification
from .client_facing_electrocardiogram_inconclusive_cause import ClientFacingElectrocardiogramInconclusiveCause
from .client_facing_electrocardiogram_source_provider import ClientFacingElectrocardiogramSourceProvider
from .client_facing_electrocardiogram_source_type import ClientFacingElectrocardiogramSourceType
from .client_facing_source import ClientFacingSource


class ClientFacingElectrocardiogram(UniversalBaseModel):
    id: str
    session_start: dt.datetime
    session_end: dt.datetime
    voltage_sample_count: int
    heart_rate_mean: typing.Optional[int] = None
    sampling_frequency_hz: typing.Optional[float] = None
    classification: typing.Optional[ClientFacingElectrocardiogramClassification] = None
    inconclusive_cause: typing.Optional[ClientFacingElectrocardiogramInconclusiveCause] = None
    algorithm_version: typing.Optional[str] = None
    time_zone: typing.Optional[str] = None
    source_provider: ClientFacingElectrocardiogramSourceProvider
    source_type: ClientFacingElectrocardiogramSourceType = pydantic.Field()
    """
    ℹ️ This enum is non-exhaustive.
    """

    source_app_id: typing.Optional[str] = None
    source_device_model: typing.Optional[str] = None
    created_at: dt.datetime
    updated_at: dt.datetime
    user_id: str
    source: ClientFacingSource

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
