# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .billing import Billing
from .client_facing_lab_test import ClientFacingLabTest
from .client_facing_order_details import ClientFacingOrderDetails
from .client_facing_order_event import ClientFacingOrderEvent
from .client_facing_patient_details_compatible import ClientFacingPatientDetailsCompatible
from .client_facing_physician import ClientFacingPhysician
from .interpretation import Interpretation
from .order_top_level_status import OrderTopLevelStatus
from .patient_address_compatible import PatientAddressCompatible
from .shipping_address import ShippingAddress


class ClientFacingOrder(UniversalBaseModel):
    user_id: str = pydantic.Field()
    """
    User id returned by vital create user request. This id should be stored in your database against the user and used for all interactions with the vital api.
    """

    id: str = pydantic.Field()
    """
    The Vital Order ID
    """

    team_id: str = pydantic.Field()
    """
    Your team id.
    """

    patient_details: typing.Optional[ClientFacingPatientDetailsCompatible] = pydantic.Field(default=None)
    """
    Patient Details
    """

    patient_address: typing.Optional[PatientAddressCompatible] = pydantic.Field(default=None)
    """
    Patient Address
    """

    lab_test: ClientFacingLabTest = pydantic.Field()
    """
    The Vital Test associated with the order
    """

    details: ClientFacingOrderDetails
    sample_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sample ID
    """

    notes: typing.Optional[str] = pydantic.Field(default=None)
    """
    Notes associated with the order
    """

    created_at: dt.datetime = pydantic.Field()
    """
    When your order was created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    When your order was last updated.
    """

    events: typing.List[ClientFacingOrderEvent]
    status: typing.Optional[OrderTopLevelStatus] = None
    physician: typing.Optional[ClientFacingPhysician] = None
    health_insurance_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Vital ID of the health insurance.
    """

    requisition_form_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    DEPRECATED. Requistion form url.
    """

    priority: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Defines whether order is priority or not. For some labs, this refers to a STAT order.
    """

    shipping_details: typing.Optional[ShippingAddress] = pydantic.Field(default=None)
    """
    Shipping Details. For unregistered testkit orders.
    """

    activate_by: typing.Optional[str] = pydantic.Field(default=None)
    """
    Schedule an Order to be processed in a future date.
    """

    passthrough: typing.Optional[str] = None
    billing_type: typing.Optional[Billing] = None
    icd_codes: typing.Optional[typing.List[str]] = None
    has_abn: bool = pydantic.Field()
    """
    Defines whether the order has an Advanced Beneficiary Notice (ABN) form or not.
    """

    interpretation: typing.Optional[Interpretation] = pydantic.Field(default=None)
    """
    Interpretation of the order result. Can be one of (normal, abnormal, critical).
    """

    expected_result_by_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    The common-case date by which the order result is expected to be available.
    """

    worst_case_result_by_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    The latest date by which the order result is expected to be available.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
