# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .address import Address


class ClientFacingPayorSearchResponse(UniversalBaseModel):
    payor_code: str = pydantic.Field()
    """
    Payor code returned for the insurance information.
    """

    name: str = pydantic.Field()
    """
    Insurance name returned for the insurance information.
    """

    aliases: typing.List[str] = pydantic.Field()
    """
    Insurance name aliases returned for the insurance information.
    """

    org_address: Address = pydantic.Field()
    """
    Insurance business address returned for the insurance information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
