
# Packet Types
from __future__ import annotations

OW_ACK = 0xE0
OW_NAK = 0xE1
OW_CMD = 0xE2
OW_RESP = 0xE3
OW_DATA = 0xE4
OW_ONE_WIRE = 0xE5
OW_TX7332 = 0xE6
OW_AFE_READ = 0xE7
OW_AFE_SEND = 0xE8
OW_I2C_PASSTHRU = 0xE9
OW_CONTROLLER = 0xEA
OW_POWER = 0xEB
OW_ONEWIRE_RESP = 0xEC
OW_ERROR = 0xEF

OW_SUCCESS = 0x00
OW_UNKNOWN_COMMAND = 0xFC
OW_BAD_CRC = 0xFD
OW_INVALID_PACKET = 0xFE
OW_UNKNOWN_ERROR = 0xFF

# Global Commands
OW_CMD_PING = 0x00
OW_CMD_PONG = 0x01
OW_CMD_VERSION = 0x02
OW_CMD_ECHO = 0x03
OW_CMD_TOGGLE_LED = 0x04
OW_CMD_HWID = 0x05
OW_CMD_GET_TEMP = 0x06
OW_CMD_GET_AMBIENT = 0x07
OW_CMD_ASYNC = 0x09
OW_CMD_DFU = 0x0D
OW_CMD_NOP = 0x0E
OW_CMD_RESET = 0x0F

# Controller Commands
OW_CTRL_SET_SWTRIG = 0x13
OW_CTRL_GET_SWTRIG = 0x14
OW_CTRL_START_SWTRIG = 0x15
OW_CTRL_STOP_SWTRIG = 0x16
OW_CTRL_STATUS_SWTRIG = 0x17
OW_CTRL_RESET = 0x1F

# TX7332 Commands
OW_TX7332_STATUS = 0x20
OW_TX7332_ENUM = 0x21
OW_TX7332_WREG = 0x22
OW_TX7332_RREG = 0x23
OW_TX7332_WBLOCK = 0x24
OW_TX7332_VWREG = 0x25
OW_TX7332_VWBLOCK = 0x26
OW_TX7332_DEMO = 0x2D
OW_TX7332_RESET = 0x2F

# Power Commands
OW_POWER_STATUS = 0x30
OW_POWER_SET_HV = 0x31
OW_POWER_GET_HV = 0x32
OW_POWER_HV_ON = 0x33
OW_POWER_HV_OFF = 0x34
OW_POWER_12V_ON = 0x35
OW_POWER_12V_OFF = 0x36
OW_POWER_GET_TEMP1 = 0x37
OW_POWER_GET_TEMP2 = 0x38
OW_POWER_SET_FAN = 0x39
OW_POWER_GET_FAN = 0x3A
OW_POWER_SET_RGB = 0x3B
OW_POWER_GET_RGB = 0x3C
OW_POWER_GET_HVON = 0x3D
OW_POWER_GET_12VON = 0x3E
OW_POWER_SET_DACS = 0x3F

TRIGGER_MODE_SEQUENCE = 0
TRIGGER_MODE_CONTINUOUS = 1
TRIGGER_MODE_SINGLE = 2

TRIGGER_STATUS_READY = 0
TRIGGER_STATUS_RUNNING = 1
TRIGGER_STATUS_ERROR = 2
TRIGGER_STATUS_NOT_CONFIGURED = 3
