To remove source map files at build time, follow the corresponding guide:

#### React Native:

On Android, source maps are enabled but not generated by default. However, they're only generated when `hermesFlags` are present in `android/app/build.gradle` and `-output-source-map` option is set.

On iOS, source maps are disabled by default. 

#### Ionic:

To exclude sourcemap files from Ionic application builds, set `ionic_generate_source_map` to `false` in you `package.json` file

```json
"dependencies": {
   ...
}
"config": {
   "ionic_generate_source_map": "false",
},
```

Alternatively, If the build is generated from the command line, ensure the `--generateSourceMap` flag is set to `false`.

#### Native iOS/Android:

Source map files are generally not used in native iOS and Android development. However, if you're using any tools or libraries that generate source maps, ensure that they are configured to exclude source map generation for release builds.

#### Other frameworks:

For other frameworks like PhoneGap or Cordova, sourcemap files are not generated by default. However, if you're using additional tools or plugins that generate source maps, you'll need to configure them to exclude source map generation for production builds.
