"""Add model for ip and link

Revision ID: 5629037e8282
Revises: e0ef8ab7d038
Create Date: 2024-06-12 10:06:09.222596

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "5629037e8282"
down_revision = "e0ef8ab7d038"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "ip",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("host", sa.String(length=50), nullable=True),
        sa.Column("mask", sa.String(length=50), nullable=True),
        sa.Column("network_asset_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["network_asset_id"],
            ["network.id"],
            name=op.f("fk_ip_network_asset_id_network"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_ip")),
    )
    op.create_table(
        "link",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("url", sa.String(length=4096), nullable=True),
        sa.Column("method", sa.String(length=8), nullable=True),
        sa.Column("urls_asset_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["urls_asset_id"], ["urls.id"], name=op.f("fk_link_urls_asset_id_urls")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_link")),
    )

    with op.batch_alter_table("network", schema=None) as batch_op:
        batch_op.drop_column("networks")

    with op.batch_alter_table("urls", schema=None) as batch_op:
        batch_op.drop_column("links")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("urls", schema=None) as batch_op:
        batch_op.add_column(sa.Column("links", sa.VARCHAR(length=1024), nullable=True))

    with op.batch_alter_table("network", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("networks", sa.VARCHAR(length=1024), nullable=True)
        )

    op.drop_table("link")
    op.drop_table("ip")
    # ### end Alembic commands ###
