"""Add domain asset model

Revision ID: b31a27c8584f
Revises: 3aa6ae380275
Create Date: 2024-06-13 17:05:48.425291

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "b31a27c8584f"
down_revision = "3aa6ae380275"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "domain_asset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["id"], ["asset.id"], name=op.f("fk_domain_asset_id_asset")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_domain_asset")),
    )
    op.create_table(
        "domain_name",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=True),
        sa.Column("domain_asset_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["domain_asset_id"],
            ["domain_asset.id"],
            name=op.f("fk_domain_name_domain_asset_id_domain_asset"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_domain_name")),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("domain_name")
    op.drop_table("domain_asset")
    # ### end Alembic commands ###
