"""Add scan risk rating

Revision ID: d47f712dab53
Revises: cbb2e16e146a
Create Date: 2024-07-12 16:49:37.847290

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "d47f712dab53"
down_revision = "cbb2e16e146a"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("scan", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "risk_rating",
                sa.Enum(
                    "CRITICAL",
                    "HIGH",
                    "MEDIUM",
                    "LOW",
                    "POTENTIALLY",
                    "HARDENING",
                    "SECURE",
                    "IMPORTANT",
                    "INFO",
                    name="riskrating",
                ),
                nullable=True,
            )
        )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("scan", schema=None) as batch_op:
        batch_op.drop_column("risk_rating")
    # ### end Alembic commands ###
