"""malware detection module."""

from django.utils.functional import LazyObject

from .handler import MalwareDetectionHandler


class DefaultMalwareDetection(LazyObject):
    """Lazy object to handle the malware detection backend."""

    def _setup(self):
        """Configure the malware detection backend."""
        self._wrapped = malware_detection_handler()


malware_detection_handler = MalwareDetectionHandler()
malware_detection = DefaultMalwareDetection()
