"""Module contains the dummy backend for the malware detection system."""

from ..enums import ReportStatus
from .base import BaseBackend


class DummyBackend(BaseBackend):
    """A dummy backend that does nothing."""

    def analyse_file(self, file_path: str, **kwargs) -> None:
        """Analyse a file and call the callback with the result."""
        self.callback(file_path, ReportStatus.SAFE, error_info={}, **kwargs)

    def launch_next_analysis(self) -> None:
        """Launch the next analysis."""
