"""Management command to check for pending analyses and trigger them if needed."""

from django.core.management.base import BaseCommand

from lasuite.malware_detection import MalwareDetectionHandler


class Command(BaseCommand):
    """Management command to check for pending analyses and trigger them if needed."""

    help = "Call, for the active backend, the method launch_next_analysisin order to not have pending analysis blocked."

    def handle(self, *args, **options):
        """Handle the command."""
        backend = MalwareDetectionHandler()()
        backend.launch_next_analysis()
