#
# SPDX-FileCopyrightText: Copyright (c) 2025 provide.io llc. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#

"""TODO: Add module docstring."""

from __future__ import annotations

from pyvider.cty.types.base import CtyType
from pyvider.cty.types.capsule import CtyCapsule, CtyCapsuleWithOps
from pyvider.cty.types.capsule_types import BytesCapsule
from pyvider.cty.types.collections import (
    CtyList,
    CtyMap,
    CtySet,
)
from pyvider.cty.types.primitives import (
    CtyBool,
    CtyNumber,
    CtyString,
)
from pyvider.cty.types.structural import (
    CtyDynamic,
    CtyObject,
    CtyTuple,
)

#
# pyvider/cty/types/__init__.py
#
"""
Defines the core CTY (Compatible Type System) types.

This package includes the base CtyType class and all concrete type
implementations such as primitives (string, number, bool), collections
(list, map, set), and structural types (object, tuple, dynamic, capsule).
"""

__all__ = [
    "BytesCapsule",
    "CtyBool",
    "CtyCapsule",
    "CtyCapsuleWithOps",
    "CtyDynamic",
    "CtyList",
    "CtyMap",
    "CtyNumber",
    "CtyObject",
    "CtySet",
    "CtyString",
    "CtyTuple",
    "CtyType",
]

# 🌊🪢🔚
