#
# SPDX-FileCopyrightText: Copyright (c) 2025 provide.io llc. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#

"""TODO: Add module docstring."""

from __future__ import annotations

from pyvider.cty.values.base import CtyValue
from pyvider.cty.values.markers import (
    UNREFINED_UNKNOWN,
    RefinedUnknownValue,
    UnknownValue,
)

#
# pyvider/cty/values/__init__.py
#
"""
CTY Value Representation.

This package defines CtyValue, the runtime representation of values
within the CTY type system. CtyValue instances pair a Python value
with its corresponding CtyType and associated metadata.
"""

__all__ = [
    "UNREFINED_UNKNOWN",
    "CtyValue",
    "RefinedUnknownValue",
    "UnknownValue",
]

# 🌊🪢🔚
