"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class StreamActivatedJobsRequest(google.protobuf.message.Message):
    """For a more complete documentation, refer to Zeebe documentation at:
    https://docs.camunda.io/docs/reference/grpc
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    FETCHVARIABLE_FIELD_NUMBER: builtins.int
    TENANTIDS_FIELD_NUMBER: builtins.int
    type: builtins.str
    """the job type, as defined in the BPMN process (e.g. <zeebe:taskDefinition
    type="payment-service" />)
    """
    worker: builtins.str
    """the name of the worker activating the jobs, mostly used for logging purposes"""
    timeout: builtins.int
    """a job returned after this call will not be activated by another call until the
    timeout (in ms) has been reached
    """
    @property
    def fetchVariable(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of variables to fetch as the job variables; if empty, all visible variables at
        the time of activation for the scope of the job will be returned
        """

    @property
    def tenantIds(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of identifiers of tenants for which to stream jobs"""

    def __init__(
        self,
        *,
        type: builtins.str = ...,
        worker: builtins.str = ...,
        timeout: builtins.int = ...,
        fetchVariable: collections.abc.Iterable[builtins.str] | None = ...,
        tenantIds: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fetchVariable", b"fetchVariable", "tenantIds", b"tenantIds", "timeout", b"timeout", "type", b"type", "worker", b"worker"]) -> None: ...

global___StreamActivatedJobsRequest = StreamActivatedJobsRequest

@typing.final
class ActivateJobsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    MAXJOBSTOACTIVATE_FIELD_NUMBER: builtins.int
    FETCHVARIABLE_FIELD_NUMBER: builtins.int
    REQUESTTIMEOUT_FIELD_NUMBER: builtins.int
    TENANTIDS_FIELD_NUMBER: builtins.int
    type: builtins.str
    """the job type, as defined in the BPMN process (e.g. <zeebe:taskDefinition
    type="payment-service" />)
    """
    worker: builtins.str
    """the name of the worker activating the jobs, mostly used for logging purposes"""
    timeout: builtins.int
    """a job returned after this call will not be activated by another call until the
    timeout (in ms) has been reached
    """
    maxJobsToActivate: builtins.int
    """the maximum jobs to activate by this request"""
    requestTimeout: builtins.int
    """The request will be completed when at least one job is activated or after the requestTimeout (in ms).
    if the requestTimeout = 0, a default timeout is used.
    if the requestTimeout < 0, long polling is disabled and the request is completed immediately, even when no job is activated.
    """
    @property
    def fetchVariable(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of variables to fetch as the job variables; if empty, all visible variables at
        the time of activation for the scope of the job will be returned
        """

    @property
    def tenantIds(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of IDs of tenants for which to activate jobs"""

    def __init__(
        self,
        *,
        type: builtins.str = ...,
        worker: builtins.str = ...,
        timeout: builtins.int = ...,
        maxJobsToActivate: builtins.int = ...,
        fetchVariable: collections.abc.Iterable[builtins.str] | None = ...,
        requestTimeout: builtins.int = ...,
        tenantIds: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fetchVariable", b"fetchVariable", "maxJobsToActivate", b"maxJobsToActivate", "requestTimeout", b"requestTimeout", "tenantIds", b"tenantIds", "timeout", b"timeout", "type", b"type", "worker", b"worker"]) -> None: ...

global___ActivateJobsRequest = ActivateJobsRequest

@typing.final
class ActivateJobsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBS_FIELD_NUMBER: builtins.int
    @property
    def jobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActivatedJob]:
        """list of activated jobs"""

    def __init__(
        self,
        *,
        jobs: collections.abc.Iterable[global___ActivatedJob] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["jobs", b"jobs"]) -> None: ...

global___ActivateJobsResponse = ActivateJobsResponse

@typing.final
class ActivatedJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PROCESSINSTANCEKEY_FIELD_NUMBER: builtins.int
    BPMNPROCESSID_FIELD_NUMBER: builtins.int
    PROCESSDEFINITIONVERSION_FIELD_NUMBER: builtins.int
    PROCESSDEFINITIONKEY_FIELD_NUMBER: builtins.int
    ELEMENTID_FIELD_NUMBER: builtins.int
    ELEMENTINSTANCEKEY_FIELD_NUMBER: builtins.int
    CUSTOMHEADERS_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    RETRIES_FIELD_NUMBER: builtins.int
    DEADLINE_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    key: builtins.int
    """the key, a unique identifier for the job"""
    type: builtins.str
    """the type of the job (should match what was requested)"""
    processInstanceKey: builtins.int
    """the job's process instance key"""
    bpmnProcessId: builtins.str
    """the bpmn process ID of the job process definition"""
    processDefinitionVersion: builtins.int
    """the version of the job process definition"""
    processDefinitionKey: builtins.int
    """the key of the job process definition"""
    elementId: builtins.str
    """the associated task element ID"""
    elementInstanceKey: builtins.int
    """the unique key identifying the associated task, unique within the scope of the
    process instance
    """
    customHeaders: builtins.str
    """a set of custom headers defined during modelling; returned as a serialized
    JSON document
    """
    worker: builtins.str
    """the name of the worker which activated this job"""
    retries: builtins.int
    """the amount of retries left to this job (should always be positive)"""
    deadline: builtins.int
    """when the job can be activated again, sent as a UNIX epoch timestamp"""
    variables: builtins.str
    """JSON document, computed at activation time, consisting of all visible variables to
    the task scope
    """
    tenantId: builtins.str
    """the id of the tenant that owns the job"""
    def __init__(
        self,
        *,
        key: builtins.int = ...,
        type: builtins.str = ...,
        processInstanceKey: builtins.int = ...,
        bpmnProcessId: builtins.str = ...,
        processDefinitionVersion: builtins.int = ...,
        processDefinitionKey: builtins.int = ...,
        elementId: builtins.str = ...,
        elementInstanceKey: builtins.int = ...,
        customHeaders: builtins.str = ...,
        worker: builtins.str = ...,
        retries: builtins.int = ...,
        deadline: builtins.int = ...,
        variables: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bpmnProcessId", b"bpmnProcessId", "customHeaders", b"customHeaders", "deadline", b"deadline", "elementId", b"elementId", "elementInstanceKey", b"elementInstanceKey", "key", b"key", "processDefinitionKey", b"processDefinitionKey", "processDefinitionVersion", b"processDefinitionVersion", "processInstanceKey", b"processInstanceKey", "retries", b"retries", "tenantId", b"tenantId", "type", b"type", "variables", b"variables", "worker", b"worker"]) -> None: ...

global___ActivatedJob = ActivatedJob

@typing.final
class CancelProcessInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSINSTANCEKEY_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    processInstanceKey: builtins.int
    """the process instance key (as, for example, obtained from
    CreateProcessInstanceResponse)
    """
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    def __init__(
        self,
        *,
        processInstanceKey: builtins.int = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference", "processInstanceKey", b"processInstanceKey"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___CancelProcessInstanceRequest = CancelProcessInstanceRequest

@typing.final
class CancelProcessInstanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CancelProcessInstanceResponse = CancelProcessInstanceResponse

@typing.final
class CompleteJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBKEY_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    jobKey: builtins.int
    """the unique job identifier, as obtained from ActivateJobsResponse"""
    variables: builtins.str
    """a JSON document representing the variables in the current task scope"""
    def __init__(
        self,
        *,
        jobKey: builtins.int = ...,
        variables: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["jobKey", b"jobKey", "variables", b"variables"]) -> None: ...

global___CompleteJobRequest = CompleteJobRequest

@typing.final
class CompleteJobResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CompleteJobResponse = CompleteJobResponse

@typing.final
class CreateProcessInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSDEFINITIONKEY_FIELD_NUMBER: builtins.int
    BPMNPROCESSID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    STARTINSTRUCTIONS_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    processDefinitionKey: builtins.int
    """the unique key identifying the process definition (e.g. returned from a process
    in the DeployProcessResponse message)
    """
    bpmnProcessId: builtins.str
    """the BPMN process ID of the process definition"""
    version: builtins.int
    """the version of the process; set to -1 to use the latest version"""
    variables: builtins.str
    """JSON document that will instantiate the variables for the root variable scope of the
    process instance; it must be a JSON object, as variables will be mapped in a
    key-value fashion. e.g. { "a": 1, "b": 2 } will create two variables, named "a" and
    "b" respectively, with their associated values. [{ "a": 1, "b": 2 }] would not be a
    valid argument, as the root of the JSON document is an array and not an object.
    """
    tenantId: builtins.str
    """the tenant id of the process definition"""
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    @property
    def startInstructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcessInstanceCreationStartInstruction]:
        """List of start instructions. If empty (default) the process instance
        will start at the start event. If non-empty the process instance will apply start
        instructions after it has been created
        """

    def __init__(
        self,
        *,
        processDefinitionKey: builtins.int = ...,
        bpmnProcessId: builtins.str = ...,
        version: builtins.int = ...,
        variables: builtins.str = ...,
        startInstructions: collections.abc.Iterable[global___ProcessInstanceCreationStartInstruction] | None = ...,
        tenantId: builtins.str = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "bpmnProcessId", b"bpmnProcessId", "operationReference", b"operationReference", "processDefinitionKey", b"processDefinitionKey", "startInstructions", b"startInstructions", "tenantId", b"tenantId", "variables", b"variables", "version", b"version"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___CreateProcessInstanceRequest = CreateProcessInstanceRequest

@typing.final
class ProcessInstanceCreationStartInstruction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENTID_FIELD_NUMBER: builtins.int
    elementId: builtins.str
    """for now, however, the start instruction is implicitly a
    "startBeforeElement" instruction

    element ID
    """
    def __init__(
        self,
        *,
        elementId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["elementId", b"elementId"]) -> None: ...

global___ProcessInstanceCreationStartInstruction = ProcessInstanceCreationStartInstruction

@typing.final
class CreateProcessInstanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSDEFINITIONKEY_FIELD_NUMBER: builtins.int
    BPMNPROCESSID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    PROCESSINSTANCEKEY_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    processDefinitionKey: builtins.int
    """the key of the process definition which was used to create the process instance"""
    bpmnProcessId: builtins.str
    """the BPMN process ID of the process definition which was used to create the process
    instance
    """
    version: builtins.int
    """the version of the process definition which was used to create the process instance"""
    processInstanceKey: builtins.int
    """the unique identifier of the created process instance; to be used wherever a request
    needs a process instance key (e.g. CancelProcessInstanceRequest)
    """
    tenantId: builtins.str
    """the tenant identifier of the created process instance"""
    def __init__(
        self,
        *,
        processDefinitionKey: builtins.int = ...,
        bpmnProcessId: builtins.str = ...,
        version: builtins.int = ...,
        processInstanceKey: builtins.int = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bpmnProcessId", b"bpmnProcessId", "processDefinitionKey", b"processDefinitionKey", "processInstanceKey", b"processInstanceKey", "tenantId", b"tenantId", "version", b"version"]) -> None: ...

global___CreateProcessInstanceResponse = CreateProcessInstanceResponse

@typing.final
class CreateProcessInstanceWithResultRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_FIELD_NUMBER: builtins.int
    REQUESTTIMEOUT_FIELD_NUMBER: builtins.int
    FETCHVARIABLES_FIELD_NUMBER: builtins.int
    requestTimeout: builtins.int
    """timeout (in ms). the request will be closed if the process is not completed
    before the requestTimeout.
    if requestTimeout = 0, uses the generic requestTimeout configured in the gateway.
    """
    @property
    def request(self) -> global___CreateProcessInstanceRequest: ...
    @property
    def fetchVariables(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """list of names of variables to be included in `CreateProcessInstanceWithResultResponse.variables`
        if empty, all visible variables in the root scope will be returned.
        """

    def __init__(
        self,
        *,
        request: global___CreateProcessInstanceRequest | None = ...,
        requestTimeout: builtins.int = ...,
        fetchVariables: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["request", b"request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fetchVariables", b"fetchVariables", "request", b"request", "requestTimeout", b"requestTimeout"]) -> None: ...

global___CreateProcessInstanceWithResultRequest = CreateProcessInstanceWithResultRequest

@typing.final
class CreateProcessInstanceWithResultResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSDEFINITIONKEY_FIELD_NUMBER: builtins.int
    BPMNPROCESSID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    PROCESSINSTANCEKEY_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    processDefinitionKey: builtins.int
    """the key of the process definition which was used to create the process instance"""
    bpmnProcessId: builtins.str
    """the BPMN process ID of the process definition which was used to create the process
    instance
    """
    version: builtins.int
    """the version of the process definition which was used to create the process instance"""
    processInstanceKey: builtins.int
    """the unique identifier of the created process instance; to be used wherever a request
    needs a process instance key (e.g. CancelProcessInstanceRequest)
    """
    variables: builtins.str
    """JSON document
    consists of visible variables in the root scope
    """
    tenantId: builtins.str
    """the tenant identifier of the process definition"""
    def __init__(
        self,
        *,
        processDefinitionKey: builtins.int = ...,
        bpmnProcessId: builtins.str = ...,
        version: builtins.int = ...,
        processInstanceKey: builtins.int = ...,
        variables: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bpmnProcessId", b"bpmnProcessId", "processDefinitionKey", b"processDefinitionKey", "processInstanceKey", b"processInstanceKey", "tenantId", b"tenantId", "variables", b"variables", "version", b"version"]) -> None: ...

global___CreateProcessInstanceWithResultResponse = CreateProcessInstanceWithResultResponse

@typing.final
class EvaluateDecisionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECISIONKEY_FIELD_NUMBER: builtins.int
    DECISIONID_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    decisionKey: builtins.int
    """the unique key identifying the decision to be evaluated (e.g. returned
    from a decision in the DeployResourceResponse message)
    """
    decisionId: builtins.str
    """the ID of the decision to be evaluated"""
    variables: builtins.str
    """JSON document that will instantiate the variables for the decision to be
    evaluated; it must be a JSON object, as variables will be mapped in a
    key-value fashion, e.g. { "a": 1, "b": 2 } will create two variables,
    named "a" and "b" respectively, with their associated values.
    [{ "a": 1, "b": 2 }] would not be a valid argument, as the root of the
    JSON document is an array and not an object.
    """
    tenantId: builtins.str
    """the tenant identifier of the decision"""
    def __init__(
        self,
        *,
        decisionKey: builtins.int = ...,
        decisionId: builtins.str = ...,
        variables: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["decisionId", b"decisionId", "decisionKey", b"decisionKey", "tenantId", b"tenantId", "variables", b"variables"]) -> None: ...

global___EvaluateDecisionRequest = EvaluateDecisionRequest

@typing.final
class EvaluateDecisionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECISIONKEY_FIELD_NUMBER: builtins.int
    DECISIONID_FIELD_NUMBER: builtins.int
    DECISIONNAME_FIELD_NUMBER: builtins.int
    DECISIONVERSION_FIELD_NUMBER: builtins.int
    DECISIONREQUIREMENTSID_FIELD_NUMBER: builtins.int
    DECISIONREQUIREMENTSKEY_FIELD_NUMBER: builtins.int
    DECISIONOUTPUT_FIELD_NUMBER: builtins.int
    EVALUATEDDECISIONS_FIELD_NUMBER: builtins.int
    FAILEDDECISIONID_FIELD_NUMBER: builtins.int
    FAILUREMESSAGE_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    DECISIONINSTANCEKEY_FIELD_NUMBER: builtins.int
    decisionKey: builtins.int
    """the unique key identifying the decision which was evaluated (e.g. returned
    from a decision in the DeployResourceResponse message)
    """
    decisionId: builtins.str
    """the ID of the decision which was evaluated"""
    decisionName: builtins.str
    """the name of the decision which was evaluated"""
    decisionVersion: builtins.int
    """the version of the decision which was evaluated"""
    decisionRequirementsId: builtins.str
    """the ID of the decision requirements graph that the decision which was
    evaluated is part of.
    """
    decisionRequirementsKey: builtins.int
    """the unique key identifying the decision requirements graph that the
    decision which was evaluated is part of.
    """
    decisionOutput: builtins.str
    """JSON document that will instantiate the result of the decision which was
    evaluated; it will be a JSON object, as the result output will be mapped
    in a key-value fashion, e.g. { "a": 1 }.
    """
    failedDecisionId: builtins.str
    """an optional string indicating the ID of the decision which
    failed during evaluation
    """
    failureMessage: builtins.str
    """an optional message describing why the decision which was evaluated failed"""
    tenantId: builtins.str
    """the tenant identifier of the evaluated decision"""
    decisionInstanceKey: builtins.int
    """the unique key identifying this decision evaluation"""
    @property
    def evaluatedDecisions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EvaluatedDecision]:
        """a list of decisions that were evaluated within the requested decision evaluation"""

    def __init__(
        self,
        *,
        decisionKey: builtins.int = ...,
        decisionId: builtins.str = ...,
        decisionName: builtins.str = ...,
        decisionVersion: builtins.int = ...,
        decisionRequirementsId: builtins.str = ...,
        decisionRequirementsKey: builtins.int = ...,
        decisionOutput: builtins.str = ...,
        evaluatedDecisions: collections.abc.Iterable[global___EvaluatedDecision] | None = ...,
        failedDecisionId: builtins.str = ...,
        failureMessage: builtins.str = ...,
        tenantId: builtins.str = ...,
        decisionInstanceKey: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["decisionId", b"decisionId", "decisionInstanceKey", b"decisionInstanceKey", "decisionKey", b"decisionKey", "decisionName", b"decisionName", "decisionOutput", b"decisionOutput", "decisionRequirementsId", b"decisionRequirementsId", "decisionRequirementsKey", b"decisionRequirementsKey", "decisionVersion", b"decisionVersion", "evaluatedDecisions", b"evaluatedDecisions", "failedDecisionId", b"failedDecisionId", "failureMessage", b"failureMessage", "tenantId", b"tenantId"]) -> None: ...

global___EvaluateDecisionResponse = EvaluateDecisionResponse

@typing.final
class EvaluatedDecision(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DECISIONKEY_FIELD_NUMBER: builtins.int
    DECISIONID_FIELD_NUMBER: builtins.int
    DECISIONNAME_FIELD_NUMBER: builtins.int
    DECISIONVERSION_FIELD_NUMBER: builtins.int
    DECISIONTYPE_FIELD_NUMBER: builtins.int
    DECISIONOUTPUT_FIELD_NUMBER: builtins.int
    MATCHEDRULES_FIELD_NUMBER: builtins.int
    EVALUATEDINPUTS_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    decisionKey: builtins.int
    """the unique key identifying the decision which was evaluated (e.g. returned
    from a decision in the DeployResourceResponse message)
    """
    decisionId: builtins.str
    """the ID of the decision which was evaluated"""
    decisionName: builtins.str
    """the name of the decision which was evaluated"""
    decisionVersion: builtins.int
    """the version of the decision which was evaluated"""
    decisionType: builtins.str
    """the type of the decision which was evaluated"""
    decisionOutput: builtins.str
    """JSON document that will instantiate the result of the decision which was
    evaluated; it will be a JSON object, as the result output will be mapped
    in a key-value fashion, e.g. { "a": 1 }.
    """
    tenantId: builtins.str
    """the tenant identifier of the evaluated decision"""
    @property
    def matchedRules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MatchedDecisionRule]:
        """the decision rules that matched within this decision evaluation"""

    @property
    def evaluatedInputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EvaluatedDecisionInput]:
        """the decision inputs that were evaluated within this decision evaluation"""

    def __init__(
        self,
        *,
        decisionKey: builtins.int = ...,
        decisionId: builtins.str = ...,
        decisionName: builtins.str = ...,
        decisionVersion: builtins.int = ...,
        decisionType: builtins.str = ...,
        decisionOutput: builtins.str = ...,
        matchedRules: collections.abc.Iterable[global___MatchedDecisionRule] | None = ...,
        evaluatedInputs: collections.abc.Iterable[global___EvaluatedDecisionInput] | None = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["decisionId", b"decisionId", "decisionKey", b"decisionKey", "decisionName", b"decisionName", "decisionOutput", b"decisionOutput", "decisionType", b"decisionType", "decisionVersion", b"decisionVersion", "evaluatedInputs", b"evaluatedInputs", "matchedRules", b"matchedRules", "tenantId", b"tenantId"]) -> None: ...

global___EvaluatedDecision = EvaluatedDecision

@typing.final
class EvaluatedDecisionInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTID_FIELD_NUMBER: builtins.int
    INPUTNAME_FIELD_NUMBER: builtins.int
    INPUTVALUE_FIELD_NUMBER: builtins.int
    inputId: builtins.str
    """the id of the evaluated decision input"""
    inputName: builtins.str
    """the name of the evaluated decision input"""
    inputValue: builtins.str
    """the value of the evaluated decision input"""
    def __init__(
        self,
        *,
        inputId: builtins.str = ...,
        inputName: builtins.str = ...,
        inputValue: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["inputId", b"inputId", "inputName", b"inputName", "inputValue", b"inputValue"]) -> None: ...

global___EvaluatedDecisionInput = EvaluatedDecisionInput

@typing.final
class EvaluatedDecisionOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTID_FIELD_NUMBER: builtins.int
    OUTPUTNAME_FIELD_NUMBER: builtins.int
    OUTPUTVALUE_FIELD_NUMBER: builtins.int
    outputId: builtins.str
    """the id of the evaluated decision output"""
    outputName: builtins.str
    """the name of the evaluated decision output"""
    outputValue: builtins.str
    """the value of the evaluated decision output"""
    def __init__(
        self,
        *,
        outputId: builtins.str = ...,
        outputName: builtins.str = ...,
        outputValue: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["outputId", b"outputId", "outputName", b"outputName", "outputValue", b"outputValue"]) -> None: ...

global___EvaluatedDecisionOutput = EvaluatedDecisionOutput

@typing.final
class MatchedDecisionRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULEID_FIELD_NUMBER: builtins.int
    RULEINDEX_FIELD_NUMBER: builtins.int
    EVALUATEDOUTPUTS_FIELD_NUMBER: builtins.int
    ruleId: builtins.str
    """the id of the matched rule"""
    ruleIndex: builtins.int
    """the index of the matched rule"""
    @property
    def evaluatedOutputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EvaluatedDecisionOutput]:
        """the evaluated decision outputs"""

    def __init__(
        self,
        *,
        ruleId: builtins.str = ...,
        ruleIndex: builtins.int = ...,
        evaluatedOutputs: collections.abc.Iterable[global___EvaluatedDecisionOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["evaluatedOutputs", b"evaluatedOutputs", "ruleId", b"ruleId", "ruleIndex", b"ruleIndex"]) -> None: ...

global___MatchedDecisionRule = MatchedDecisionRule

@typing.final
class DeployProcessRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSES_FIELD_NUMBER: builtins.int
    @property
    def processes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcessRequestObject]:
        """List of process resources to deploy"""

    def __init__(
        self,
        *,
        processes: collections.abc.Iterable[global___ProcessRequestObject] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["processes", b"processes"]) -> None: ...

global___DeployProcessRequest = DeployProcessRequest

@typing.final
class ProcessRequestObject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DEFINITION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """the resource basename, e.g. myProcess.bpmn"""
    definition: builtins.bytes
    """the process definition as a UTF8-encoded string"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        definition: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["definition", b"definition", "name", b"name"]) -> None: ...

global___ProcessRequestObject = ProcessRequestObject

@typing.final
class DeployProcessResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    PROCESSES_FIELD_NUMBER: builtins.int
    key: builtins.int
    """the unique key identifying the deployment"""
    @property
    def processes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcessMetadata]:
        """a list of deployed processes"""

    def __init__(
        self,
        *,
        key: builtins.int = ...,
        processes: collections.abc.Iterable[global___ProcessMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "processes", b"processes"]) -> None: ...

global___DeployProcessResponse = DeployProcessResponse

@typing.final
class DeployResourceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    tenantId: builtins.str
    """the tenant id of the resources to deploy"""
    @property
    def resources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Resource]:
        """list of resources to deploy"""

    def __init__(
        self,
        *,
        resources: collections.abc.Iterable[global___Resource] | None = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources", "tenantId", b"tenantId"]) -> None: ...

global___DeployResourceRequest = DeployResourceRequest

@typing.final
class Resource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """the resource name, e.g. myProcess.bpmn or myDecision.dmn"""
    content: builtins.bytes
    """the file content as a UTF8-encoded string"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        content: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "name", b"name"]) -> None: ...

global___Resource = Resource

@typing.final
class DeployResourceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    DEPLOYMENTS_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    key: builtins.int
    """the unique key identifying the deployment"""
    tenantId: builtins.str
    """the tenant id of the deployed resources"""
    @property
    def deployments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Deployment]:
        """a list of deployed resources, e.g. processes"""

    def __init__(
        self,
        *,
        key: builtins.int = ...,
        deployments: collections.abc.Iterable[global___Deployment] | None = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deployments", b"deployments", "key", b"key", "tenantId", b"tenantId"]) -> None: ...

global___DeployResourceResponse = DeployResourceResponse

@typing.final
class Deployment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESS_FIELD_NUMBER: builtins.int
    DECISION_FIELD_NUMBER: builtins.int
    DECISIONREQUIREMENTS_FIELD_NUMBER: builtins.int
    FORM_FIELD_NUMBER: builtins.int
    @property
    def process(self) -> global___ProcessMetadata:
        """metadata of a deployed process"""

    @property
    def decision(self) -> global___DecisionMetadata:
        """metadata of a deployed decision"""

    @property
    def decisionRequirements(self) -> global___DecisionRequirementsMetadata:
        """metadata of a deployed decision requirements"""

    @property
    def form(self) -> global___FormMetadata:
        """metadata of a deployed form"""

    def __init__(
        self,
        *,
        process: global___ProcessMetadata | None = ...,
        decision: global___DecisionMetadata | None = ...,
        decisionRequirements: global___DecisionRequirementsMetadata | None = ...,
        form: global___FormMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Metadata", b"Metadata", "decision", b"decision", "decisionRequirements", b"decisionRequirements", "form", b"form", "process", b"process"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Metadata", b"Metadata", "decision", b"decision", "decisionRequirements", b"decisionRequirements", "form", b"form", "process", b"process"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Metadata", b"Metadata"]) -> typing.Literal["process", "decision", "decisionRequirements", "form"] | None: ...

global___Deployment = Deployment

@typing.final
class ProcessMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BPMNPROCESSID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    PROCESSDEFINITIONKEY_FIELD_NUMBER: builtins.int
    RESOURCENAME_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    bpmnProcessId: builtins.str
    """the bpmn process ID, as parsed during deployment; together with the version forms a
    unique identifier for a specific process definition
    """
    version: builtins.int
    """the assigned process version"""
    processDefinitionKey: builtins.int
    """the assigned key, which acts as a unique identifier for this process"""
    resourceName: builtins.str
    """the resource name (see: ProcessRequestObject.name) from which this process was
    parsed
    """
    tenantId: builtins.str
    """the tenant id of the deployed process"""
    def __init__(
        self,
        *,
        bpmnProcessId: builtins.str = ...,
        version: builtins.int = ...,
        processDefinitionKey: builtins.int = ...,
        resourceName: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bpmnProcessId", b"bpmnProcessId", "processDefinitionKey", b"processDefinitionKey", "resourceName", b"resourceName", "tenantId", b"tenantId", "version", b"version"]) -> None: ...

global___ProcessMetadata = ProcessMetadata

@typing.final
class DecisionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DMNDECISIONID_FIELD_NUMBER: builtins.int
    DMNDECISIONNAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DECISIONKEY_FIELD_NUMBER: builtins.int
    DMNDECISIONREQUIREMENTSID_FIELD_NUMBER: builtins.int
    DECISIONREQUIREMENTSKEY_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    dmnDecisionId: builtins.str
    """the dmn decision ID, as parsed during deployment; together with the
    versions forms a unique identifier for a specific decision
    """
    dmnDecisionName: builtins.str
    """the dmn name of the decision, as parsed during deployment"""
    version: builtins.int
    """the assigned decision version"""
    decisionKey: builtins.int
    """the assigned decision key, which acts as a unique identifier for this
    decision
    """
    dmnDecisionRequirementsId: builtins.str
    """the dmn ID of the decision requirements graph that this decision is part
    of, as parsed during deployment
    """
    decisionRequirementsKey: builtins.int
    """the assigned key of the decision requirements graph that this decision is
    part of
    """
    tenantId: builtins.str
    """the tenant id of the deployed decision"""
    def __init__(
        self,
        *,
        dmnDecisionId: builtins.str = ...,
        dmnDecisionName: builtins.str = ...,
        version: builtins.int = ...,
        decisionKey: builtins.int = ...,
        dmnDecisionRequirementsId: builtins.str = ...,
        decisionRequirementsKey: builtins.int = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["decisionKey", b"decisionKey", "decisionRequirementsKey", b"decisionRequirementsKey", "dmnDecisionId", b"dmnDecisionId", "dmnDecisionName", b"dmnDecisionName", "dmnDecisionRequirementsId", b"dmnDecisionRequirementsId", "tenantId", b"tenantId", "version", b"version"]) -> None: ...

global___DecisionMetadata = DecisionMetadata

@typing.final
class DecisionRequirementsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DMNDECISIONREQUIREMENTSID_FIELD_NUMBER: builtins.int
    DMNDECISIONREQUIREMENTSNAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DECISIONREQUIREMENTSKEY_FIELD_NUMBER: builtins.int
    RESOURCENAME_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    dmnDecisionRequirementsId: builtins.str
    """the dmn decision requirements ID, as parsed during deployment; together
    with the versions forms a unique identifier for a specific decision
    """
    dmnDecisionRequirementsName: builtins.str
    """the dmn name of the decision requirements, as parsed during deployment"""
    version: builtins.int
    """the assigned decision requirements version"""
    decisionRequirementsKey: builtins.int
    """the assigned decision requirements key, which acts as a unique identifier
    for this decision requirements
    """
    resourceName: builtins.str
    """the resource name (see: Resource.name) from which this decision
    requirements was parsed
    """
    tenantId: builtins.str
    """the tenant id of the deployed decision requirements"""
    def __init__(
        self,
        *,
        dmnDecisionRequirementsId: builtins.str = ...,
        dmnDecisionRequirementsName: builtins.str = ...,
        version: builtins.int = ...,
        decisionRequirementsKey: builtins.int = ...,
        resourceName: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["decisionRequirementsKey", b"decisionRequirementsKey", "dmnDecisionRequirementsId", b"dmnDecisionRequirementsId", "dmnDecisionRequirementsName", b"dmnDecisionRequirementsName", "resourceName", b"resourceName", "tenantId", b"tenantId", "version", b"version"]) -> None: ...

global___DecisionRequirementsMetadata = DecisionRequirementsMetadata

@typing.final
class FormMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORMID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    FORMKEY_FIELD_NUMBER: builtins.int
    RESOURCENAME_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    formId: builtins.str
    """the form ID, as parsed during deployment; together with the
    versions forms a unique identifier for a specific form
    """
    version: builtins.int
    """the assigned form version"""
    formKey: builtins.int
    """the assigned key, which acts as a unique identifier for this form"""
    resourceName: builtins.str
    """the resource name"""
    tenantId: builtins.str
    """the tenant id of the deployed form"""
    def __init__(
        self,
        *,
        formId: builtins.str = ...,
        version: builtins.int = ...,
        formKey: builtins.int = ...,
        resourceName: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["formId", b"formId", "formKey", b"formKey", "resourceName", b"resourceName", "tenantId", b"tenantId", "version", b"version"]) -> None: ...

global___FormMetadata = FormMetadata

@typing.final
class FailJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBKEY_FIELD_NUMBER: builtins.int
    RETRIES_FIELD_NUMBER: builtins.int
    ERRORMESSAGE_FIELD_NUMBER: builtins.int
    RETRYBACKOFF_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    jobKey: builtins.int
    """the unique job identifier, as obtained when activating the job"""
    retries: builtins.int
    """the amount of retries the job should have left"""
    errorMessage: builtins.str
    """an optional message describing why the job failed
    this is particularly useful if a job runs out of retries and an incident is raised,
    as it this message can help explain why an incident was raised
    """
    retryBackOff: builtins.int
    """the backoff timeout (in ms) for the next retry"""
    variables: builtins.str
    """JSON document that will instantiate the variables at the local scope of the
    job's associated task; it must be a JSON object, as variables will be mapped in a
    key-value fashion. e.g. { "a": 1, "b": 2 } will create two variables, named "a" and
    "b" respectively, with their associated values. [{ "a": 1, "b": 2 }] would not be a
    valid argument, as the root of the JSON document is an array and not an object.
    """
    def __init__(
        self,
        *,
        jobKey: builtins.int = ...,
        retries: builtins.int = ...,
        errorMessage: builtins.str = ...,
        retryBackOff: builtins.int = ...,
        variables: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["errorMessage", b"errorMessage", "jobKey", b"jobKey", "retries", b"retries", "retryBackOff", b"retryBackOff", "variables", b"variables"]) -> None: ...

global___FailJobRequest = FailJobRequest

@typing.final
class FailJobResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___FailJobResponse = FailJobResponse

@typing.final
class ThrowErrorRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBKEY_FIELD_NUMBER: builtins.int
    ERRORCODE_FIELD_NUMBER: builtins.int
    ERRORMESSAGE_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    jobKey: builtins.int
    """the unique job identifier, as obtained when activating the job"""
    errorCode: builtins.str
    """the error code that will be matched with an error catch event"""
    errorMessage: builtins.str
    """an optional error message that provides additional context"""
    variables: builtins.str
    """JSON document that will instantiate the variables at the local scope of the
    error catch event that catches the thrown error; it must be a JSON object, as variables will be mapped in a
    key-value fashion. e.g. { "a": 1, "b": 2 } will create two variables, named "a" and
    "b" respectively, with their associated values. [{ "a": 1, "b": 2 }] would not be a
    valid argument, as the root of the JSON document is an array and not an object.
    """
    def __init__(
        self,
        *,
        jobKey: builtins.int = ...,
        errorCode: builtins.str = ...,
        errorMessage: builtins.str = ...,
        variables: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["errorCode", b"errorCode", "errorMessage", b"errorMessage", "jobKey", b"jobKey", "variables", b"variables"]) -> None: ...

global___ThrowErrorRequest = ThrowErrorRequest

@typing.final
class ThrowErrorResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ThrowErrorResponse = ThrowErrorResponse

@typing.final
class PublishMessageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CORRELATIONKEY_FIELD_NUMBER: builtins.int
    TIMETOLIVE_FIELD_NUMBER: builtins.int
    MESSAGEID_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """the name of the message"""
    correlationKey: builtins.str
    """the correlation key of the message"""
    timeToLive: builtins.int
    """how long the message should be buffered on the broker, in milliseconds"""
    messageId: builtins.str
    """the unique ID of the message; can be omitted. only useful to ensure only one message
    with the given ID will ever be published (during its lifetime)
    """
    variables: builtins.str
    """the message variables as a JSON document; to be valid, the root of the document must be an
    object, e.g. { "a": "foo" }. [ "foo" ] would not be valid.
    """
    tenantId: builtins.str
    """the tenant id of the message"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        correlationKey: builtins.str = ...,
        timeToLive: builtins.int = ...,
        messageId: builtins.str = ...,
        variables: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["correlationKey", b"correlationKey", "messageId", b"messageId", "name", b"name", "tenantId", b"tenantId", "timeToLive", b"timeToLive", "variables", b"variables"]) -> None: ...

global___PublishMessageRequest = PublishMessageRequest

@typing.final
class PublishMessageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    key: builtins.int
    """the unique ID of the message that was published"""
    tenantId: builtins.str
    """the tenant id of the message"""
    def __init__(
        self,
        *,
        key: builtins.int = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "tenantId", b"tenantId"]) -> None: ...

global___PublishMessageResponse = PublishMessageResponse

@typing.final
class ResolveIncidentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INCIDENTKEY_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    incidentKey: builtins.int
    """the unique ID of the incident to resolve"""
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    def __init__(
        self,
        *,
        incidentKey: builtins.int = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "incidentKey", b"incidentKey", "operationReference", b"operationReference"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___ResolveIncidentRequest = ResolveIncidentRequest

@typing.final
class ResolveIncidentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ResolveIncidentResponse = ResolveIncidentResponse

@typing.final
class TopologyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___TopologyRequest = TopologyRequest

@typing.final
class TopologyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BROKERS_FIELD_NUMBER: builtins.int
    CLUSTERSIZE_FIELD_NUMBER: builtins.int
    PARTITIONSCOUNT_FIELD_NUMBER: builtins.int
    REPLICATIONFACTOR_FIELD_NUMBER: builtins.int
    GATEWAYVERSION_FIELD_NUMBER: builtins.int
    clusterSize: builtins.int
    """how many nodes are in the cluster"""
    partitionsCount: builtins.int
    """how many partitions are spread across the cluster"""
    replicationFactor: builtins.int
    """configured replication factor for this cluster"""
    gatewayVersion: builtins.str
    """gateway version"""
    @property
    def brokers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BrokerInfo]:
        """list of brokers part of this cluster"""

    def __init__(
        self,
        *,
        brokers: collections.abc.Iterable[global___BrokerInfo] | None = ...,
        clusterSize: builtins.int = ...,
        partitionsCount: builtins.int = ...,
        replicationFactor: builtins.int = ...,
        gatewayVersion: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["brokers", b"brokers", "clusterSize", b"clusterSize", "gatewayVersion", b"gatewayVersion", "partitionsCount", b"partitionsCount", "replicationFactor", b"replicationFactor"]) -> None: ...

global___TopologyResponse = TopologyResponse

@typing.final
class BrokerInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODEID_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    PARTITIONS_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    nodeId: builtins.int
    """unique (within a cluster) node ID for the broker"""
    host: builtins.str
    """hostname of the broker"""
    port: builtins.int
    """port for the broker"""
    version: builtins.str
    """broker version"""
    @property
    def partitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Partition]:
        """list of partitions managed or replicated on this broker"""

    def __init__(
        self,
        *,
        nodeId: builtins.int = ...,
        host: builtins.str = ...,
        port: builtins.int = ...,
        partitions: collections.abc.Iterable[global___Partition] | None = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["host", b"host", "nodeId", b"nodeId", "partitions", b"partitions", "port", b"port", "version", b"version"]) -> None: ...

global___BrokerInfo = BrokerInfo

@typing.final
class Partition(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PartitionBrokerRole:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PartitionBrokerRoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Partition._PartitionBrokerRole.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LEADER: Partition._PartitionBrokerRole.ValueType  # 0
        FOLLOWER: Partition._PartitionBrokerRole.ValueType  # 1
        INACTIVE: Partition._PartitionBrokerRole.ValueType  # 2

    class PartitionBrokerRole(_PartitionBrokerRole, metaclass=_PartitionBrokerRoleEnumTypeWrapper):
        """Describes the Raft role of the broker for a given partition"""

    LEADER: Partition.PartitionBrokerRole.ValueType  # 0
    FOLLOWER: Partition.PartitionBrokerRole.ValueType  # 1
    INACTIVE: Partition.PartitionBrokerRole.ValueType  # 2

    class _PartitionBrokerHealth:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PartitionBrokerHealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Partition._PartitionBrokerHealth.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTHY: Partition._PartitionBrokerHealth.ValueType  # 0
        UNHEALTHY: Partition._PartitionBrokerHealth.ValueType  # 1
        DEAD: Partition._PartitionBrokerHealth.ValueType  # 2

    class PartitionBrokerHealth(_PartitionBrokerHealth, metaclass=_PartitionBrokerHealthEnumTypeWrapper):
        """Describes the current health of the partition"""

    HEALTHY: Partition.PartitionBrokerHealth.ValueType  # 0
    UNHEALTHY: Partition.PartitionBrokerHealth.ValueType  # 1
    DEAD: Partition.PartitionBrokerHealth.ValueType  # 2

    PARTITIONID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    partitionId: builtins.int
    """the unique ID of this partition"""
    role: global___Partition.PartitionBrokerRole.ValueType
    """the role of the broker for this partition"""
    health: global___Partition.PartitionBrokerHealth.ValueType
    """the health of this partition"""
    def __init__(
        self,
        *,
        partitionId: builtins.int = ...,
        role: global___Partition.PartitionBrokerRole.ValueType = ...,
        health: global___Partition.PartitionBrokerHealth.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["health", b"health", "partitionId", b"partitionId", "role", b"role"]) -> None: ...

global___Partition = Partition

@typing.final
class UpdateJobRetriesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBKEY_FIELD_NUMBER: builtins.int
    RETRIES_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    jobKey: builtins.int
    """the unique job identifier, as obtained through ActivateJobs"""
    retries: builtins.int
    """the new amount of retries for the job; must be positive"""
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    def __init__(
        self,
        *,
        jobKey: builtins.int = ...,
        retries: builtins.int = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "jobKey", b"jobKey", "operationReference", b"operationReference", "retries", b"retries"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___UpdateJobRetriesRequest = UpdateJobRetriesRequest

@typing.final
class UpdateJobRetriesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateJobRetriesResponse = UpdateJobRetriesResponse

@typing.final
class UpdateJobTimeoutRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBKEY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    jobKey: builtins.int
    """the unique job identifier, as obtained from ActivateJobsResponse"""
    timeout: builtins.int
    """the duration of the new timeout in ms, starting from the current moment"""
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    def __init__(
        self,
        *,
        jobKey: builtins.int = ...,
        timeout: builtins.int = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "jobKey", b"jobKey", "operationReference", b"operationReference", "timeout", b"timeout"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___UpdateJobTimeoutRequest = UpdateJobTimeoutRequest

@typing.final
class UpdateJobTimeoutResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateJobTimeoutResponse = UpdateJobTimeoutResponse

@typing.final
class SetVariablesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENTINSTANCEKEY_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    LOCAL_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    elementInstanceKey: builtins.int
    """the unique identifier of a particular element; can be the process instance key (as
    obtained during instance creation), or a given element, such as a service task (see
    elementInstanceKey on the job message)
    """
    variables: builtins.str
    """a JSON serialized document describing variables as key value pairs; the root of the document
    must be an object
    """
    local: builtins.bool
    """if true, the variables will be merged strictly into the local scope (as indicated by
    elementInstanceKey); this means the variables is not propagated to upper scopes.
    for example, let's say we have two scopes, '1' and '2', with each having effective variables as:
    1 => `{ "foo" : 2 }`, and 2 => `{ "bar" : 1 }`. if we send an update request with
    elementInstanceKey = 2, variables `{ "foo" : 5 }`, and local is true, then scope 1 will
    be unchanged, and scope 2 will now be `{ "bar" : 1, "foo" 5 }`. if local was false, however,
    then scope 1 would be `{ "foo": 5 }`, and scope 2 would be `{ "bar" : 1 }`.
    """
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    def __init__(
        self,
        *,
        elementInstanceKey: builtins.int = ...,
        variables: builtins.str = ...,
        local: builtins.bool = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "elementInstanceKey", b"elementInstanceKey", "local", b"local", "operationReference", b"operationReference", "variables", b"variables"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___SetVariablesRequest = SetVariablesRequest

@typing.final
class SetVariablesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    key: builtins.int
    """the unique key of the set variables command"""
    def __init__(
        self,
        *,
        key: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key"]) -> None: ...

global___SetVariablesResponse = SetVariablesResponse

@typing.final
class ModifyProcessInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ActivateInstruction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ELEMENTID_FIELD_NUMBER: builtins.int
        ANCESTORELEMENTINSTANCEKEY_FIELD_NUMBER: builtins.int
        VARIABLEINSTRUCTIONS_FIELD_NUMBER: builtins.int
        elementId: builtins.str
        """the id of the element that should be activated"""
        ancestorElementInstanceKey: builtins.int
        """the key of the ancestor scope the element instance should be created in;
        set to -1 to create the new element instance within an existing element
        instance of the flow scope
        """
        @property
        def variableInstructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModifyProcessInstanceRequest.VariableInstruction]:
            """instructions describing which variables should be created"""

        def __init__(
            self,
            *,
            elementId: builtins.str = ...,
            ancestorElementInstanceKey: builtins.int = ...,
            variableInstructions: collections.abc.Iterable[global___ModifyProcessInstanceRequest.VariableInstruction] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["ancestorElementInstanceKey", b"ancestorElementInstanceKey", "elementId", b"elementId", "variableInstructions", b"variableInstructions"]) -> None: ...

    @typing.final
    class VariableInstruction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VARIABLES_FIELD_NUMBER: builtins.int
        SCOPEID_FIELD_NUMBER: builtins.int
        variables: builtins.str
        """JSON document that will instantiate the variables for the root variable scope of the
        process instance; it must be a JSON object, as variables will be mapped in a
        key-value fashion. e.g. { "a": 1, "b": 2 } will create two variables, named "a" and
        "b" respectively, with their associated values. [{ "a": 1, "b": 2 }] would not be a
        valid argument, as the root of the JSON document is an array and not an object.
        """
        scopeId: builtins.str
        """the id of the element in which scope the variables should be created;
        leave empty to create the variables in the global scope of the process instance
        """
        def __init__(
            self,
            *,
            variables: builtins.str = ...,
            scopeId: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["scopeId", b"scopeId", "variables", b"variables"]) -> None: ...

    @typing.final
    class TerminateInstruction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ELEMENTINSTANCEKEY_FIELD_NUMBER: builtins.int
        elementInstanceKey: builtins.int
        """the id of the element that should be terminated"""
        def __init__(
            self,
            *,
            elementInstanceKey: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["elementInstanceKey", b"elementInstanceKey"]) -> None: ...

    PROCESSINSTANCEKEY_FIELD_NUMBER: builtins.int
    ACTIVATEINSTRUCTIONS_FIELD_NUMBER: builtins.int
    TERMINATEINSTRUCTIONS_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    processInstanceKey: builtins.int
    """the key of the process instance that should be modified"""
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    @property
    def activateInstructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModifyProcessInstanceRequest.ActivateInstruction]:
        """instructions describing which elements should be activated in which scopes,
        and which variables should be created
        """

    @property
    def terminateInstructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModifyProcessInstanceRequest.TerminateInstruction]:
        """instructions describing which elements should be terminated"""

    def __init__(
        self,
        *,
        processInstanceKey: builtins.int = ...,
        activateInstructions: collections.abc.Iterable[global___ModifyProcessInstanceRequest.ActivateInstruction] | None = ...,
        terminateInstructions: collections.abc.Iterable[global___ModifyProcessInstanceRequest.TerminateInstruction] | None = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "activateInstructions", b"activateInstructions", "operationReference", b"operationReference", "processInstanceKey", b"processInstanceKey", "terminateInstructions", b"terminateInstructions"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___ModifyProcessInstanceRequest = ModifyProcessInstanceRequest

@typing.final
class ModifyProcessInstanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ModifyProcessInstanceResponse = ModifyProcessInstanceResponse

@typing.final
class MigrateProcessInstanceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MigrationPlan(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TARGETPROCESSDEFINITIONKEY_FIELD_NUMBER: builtins.int
        MAPPINGINSTRUCTIONS_FIELD_NUMBER: builtins.int
        targetProcessDefinitionKey: builtins.int
        """the key of process definition to migrate the process instance to"""
        @property
        def mappingInstructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MigrateProcessInstanceRequest.MappingInstruction]:
            """the mapping instructions describe how to map elements from the source process definition to the target process definition"""

        def __init__(
            self,
            *,
            targetProcessDefinitionKey: builtins.int = ...,
            mappingInstructions: collections.abc.Iterable[global___MigrateProcessInstanceRequest.MappingInstruction] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["mappingInstructions", b"mappingInstructions", "targetProcessDefinitionKey", b"targetProcessDefinitionKey"]) -> None: ...

    @typing.final
    class MappingInstruction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SOURCEELEMENTID_FIELD_NUMBER: builtins.int
        TARGETELEMENTID_FIELD_NUMBER: builtins.int
        sourceElementId: builtins.str
        """the element id to migrate from"""
        targetElementId: builtins.str
        """the element id to migrate into"""
        def __init__(
            self,
            *,
            sourceElementId: builtins.str = ...,
            targetElementId: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["sourceElementId", b"sourceElementId", "targetElementId", b"targetElementId"]) -> None: ...

    PROCESSINSTANCEKEY_FIELD_NUMBER: builtins.int
    MIGRATIONPLAN_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    processInstanceKey: builtins.int
    """key of the process instance to migrate"""
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    @property
    def migrationPlan(self) -> global___MigrateProcessInstanceRequest.MigrationPlan:
        """the migration plan that defines target process and element mappings"""

    def __init__(
        self,
        *,
        processInstanceKey: builtins.int = ...,
        migrationPlan: global___MigrateProcessInstanceRequest.MigrationPlan | None = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "migrationPlan", b"migrationPlan", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "migrationPlan", b"migrationPlan", "operationReference", b"operationReference", "processInstanceKey", b"processInstanceKey"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___MigrateProcessInstanceRequest = MigrateProcessInstanceRequest

@typing.final
class MigrateProcessInstanceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___MigrateProcessInstanceResponse = MigrateProcessInstanceResponse

@typing.final
class DeleteResourceRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCEKEY_FIELD_NUMBER: builtins.int
    OPERATIONREFERENCE_FIELD_NUMBER: builtins.int
    resourceKey: builtins.int
    """The key of the resource that should be deleted. This can either be the key
    of a process definition, the key of a decision requirements definition or the key of a form.
    """
    operationReference: builtins.int
    """a reference key chosen by the user and will be part of all records resulted from this operation"""
    def __init__(
        self,
        *,
        resourceKey: builtins.int = ...,
        operationReference: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_operationReference", b"_operationReference", "operationReference", b"operationReference", "resourceKey", b"resourceKey"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_operationReference", b"_operationReference"]) -> typing.Literal["operationReference"] | None: ...

global___DeleteResourceRequest = DeleteResourceRequest

@typing.final
class DeleteResourceResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteResourceResponse = DeleteResourceResponse

@typing.final
class BroadcastSignalRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNALNAME_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    signalName: builtins.str
    """The name of the signal"""
    variables: builtins.str
    """the signal variables as a JSON document; to be valid, the root of the document must be an
    object, e.g. { "a": "foo" }. [ "foo" ] would not be valid.
    """
    tenantId: builtins.str
    """the id of the tenant that owns the signal."""
    def __init__(
        self,
        *,
        signalName: builtins.str = ...,
        variables: builtins.str = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signalName", b"signalName", "tenantId", b"tenantId", "variables", b"variables"]) -> None: ...

global___BroadcastSignalRequest = BroadcastSignalRequest

@typing.final
class BroadcastSignalResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    TENANTID_FIELD_NUMBER: builtins.int
    key: builtins.int
    """the unique ID of the signal that was broadcasted."""
    tenantId: builtins.str
    """the tenant id of the signal that was broadcasted."""
    def __init__(
        self,
        *,
        key: builtins.int = ...,
        tenantId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "tenantId", b"tenantId"]) -> None: ...

global___BroadcastSignalResponse = BroadcastSignalResponse
