"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import pyzeebe.proto.gateway_pb2
import typing

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class GatewayStub:
    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    ActivateJobs: grpc.UnaryStreamMultiCallable[
        pyzeebe.proto.gateway_pb2.ActivateJobsRequest,
        pyzeebe.proto.gateway_pb2.ActivateJobsResponse,
    ]
    """
    Iterates through all known partitions round-robin and activates up to the requested
    maximum and streams them back to the client as they are activated.

    Errors:
    INVALID_ARGUMENT:
    - type is blank (empty string, null)
    - worker is blank (empty string, null)
    - timeout less than 1
    - maxJobsToActivate is less than 1
    """

    StreamActivatedJobs: grpc.UnaryStreamMultiCallable[
        pyzeebe.proto.gateway_pb2.StreamActivatedJobsRequest,
        pyzeebe.proto.gateway_pb2.ActivatedJob,
    ]
    """
    Registers client to a job stream that will stream jobs back to the client as
    they become activatable.

    Errors:
    INVALID_ARGUMENT:
    - type is blank (empty string, null)
    - timeout less than 1
    - If multi-tenancy is enabled, and tenantIds is empty (empty list)
    - If multi-tenancy is enabled, and an invalid tenant ID is provided. A tenant ID is considered invalid if:
    - The tenant ID is blank (empty string, null)
    - The tenant ID is longer than 31 characters
    - The tenant ID contains anything other than alphanumeric characters, dot (.), dash (-), or underscore (_)
    - If multi-tenancy is disabled, and tenantIds is not empty (empty list), or has an ID other than <default>
    """

    CancelProcessInstance: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CancelProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.CancelProcessInstanceResponse,
    ]
    """
    Cancels a running process instance

    Errors:
    NOT_FOUND:
    - no process instance exists with the given key
    """

    CompleteJob: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CompleteJobRequest,
        pyzeebe.proto.gateway_pb2.CompleteJobResponse,
    ]
    """
    Completes a job with the given variables, which allows completing the associated service task.

    Errors:
    NOT_FOUND:
    - no job exists with the given job key. Note that since jobs are removed once completed,
    it could be that this job did exist at some point.

    FAILED_PRECONDITION:
    - the job was marked as failed. In that case, the related incident must be resolved before
    the job can be activated again and completed.
    """

    CreateProcessInstance: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceResponse,
    ]
    """
    Creates and starts an instance of the specified process. The process definition to use to
    create the instance can be specified either using its unique key (as returned by
    DeployProcess), or using the BPMN process ID and a version. Pass -1 as the version to use the
    latest deployed version. Note that only processes with none start events can be started through
    this command.

    Errors:
    NOT_FOUND:
    - no process with the given key exists (if processDefinitionKey was given)
    - no process with the given process ID exists (if bpmnProcessId was given but version was -1)
    - no process with the given process ID and version exists (if both bpmnProcessId and version were given)

    FAILED_PRECONDITION:
    - the process definition does not contain a none start event; only processes with none
    start event can be started manually.

    INVALID_ARGUMENT:
    - the given variables argument is not a valid JSON document; it is expected to be a valid
    JSON document where the root node is an object.
    """

    CreateProcessInstanceWithResult: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultRequest,
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultResponse,
    ]
    """
    Behaves similarly to `rpc CreateProcessInstance`, except that a successful response is received when the process completes successfully.
    """

    EvaluateDecision: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.EvaluateDecisionRequest,
        pyzeebe.proto.gateway_pb2.EvaluateDecisionResponse,
    ]
    """
    Evaluates a decision. The decision to evaluate can be specified either by
    using its unique key (as returned by DeployResource), or using the decision
    ID. When using the decision ID, the latest deployed version of the decision
    is used.

    Errors:
    INVALID_ARGUMENT:
    - no decision with the given key exists (if decisionKey was given)
    - no decision with the given decision ID exists (if decisionId was given)
    - both decision ID and decision KEY were provided, or are missing
    """

    DeployProcess: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.DeployProcessRequest,
        pyzeebe.proto.gateway_pb2.DeployProcessResponse,
    ]
    """
    Deploys one or more processes to Zeebe. Note that this is an atomic call,
    i.e. either all processes are deployed, or none of them are.

    Errors:
    INVALID_ARGUMENT:
    - no resources given.
    - if at least one resource is invalid. A resource is considered invalid if:
    - the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
    - the process is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
    """

    DeployResource: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.DeployResourceRequest,
        pyzeebe.proto.gateway_pb2.DeployResourceResponse,
    ]
    """
    Deploys one or more resources (e.g. processes or decision models) to Zeebe.
    Note that this is an atomic call, i.e. either all resources are deployed, or none of them are.

    Errors:
    PERMISSION_DENIED:
    - if a deployment to an unauthorized tenant is performed
    INVALID_ARGUMENT:
    - no resources given.
    - if at least one resource is invalid. A resource is considered invalid if:
    - the content is not deserializable (e.g. detected as BPMN, but it's broken XML)
    - the content is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
    - if multi-tenancy is enabled, and:
    - a tenant id is not provided
    - a tenant id with an invalid format is provided
    - if multi-tenancy is disabled and a tenant id is provided
    """

    FailJob: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.FailJobRequest,
        pyzeebe.proto.gateway_pb2.FailJobResponse,
    ]
    """
    Marks the job as failed; if the retries argument is positive, then the job will be immediately
    activatable again, and a worker could try again to process it. If it is zero or negative however,
    an incident will be raised, tagged with the given errorMessage, and the job will not be
    activatable until the incident is resolved.

    Errors:
    NOT_FOUND:
    - no job was found with the given key

    FAILED_PRECONDITION:
    - the job was not activated
    - the job is already in a failed state, i.e. ran out of retries
    """

    ThrowError: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.ThrowErrorRequest,
        pyzeebe.proto.gateway_pb2.ThrowErrorResponse,
    ]
    """
    Reports a business error (i.e. non-technical) that occurs while processing a job. The error is handled in the process by an error catch event. If there is no error catch event with the specified errorCode then an incident will be raised instead.

    Errors:
    NOT_FOUND:
    - no job was found with the given key

    FAILED_PRECONDITION:
    - the job is not in an activated state
    """

    PublishMessage: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.PublishMessageRequest,
        pyzeebe.proto.gateway_pb2.PublishMessageResponse,
    ]
    """
    Publishes a single message. Messages are published to specific partitions computed from their
    correlation keys.

    Errors:
    ALREADY_EXISTS:
    - a message with the same ID was previously published (and is still alive)
    """

    ResolveIncident: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.ResolveIncidentRequest,
        pyzeebe.proto.gateway_pb2.ResolveIncidentResponse,
    ]
    """
    Resolves a given incident. This simply marks the incident as resolved; most likely a call to
    UpdateJobRetries or SetVariables will be necessary to actually resolve the
    problem, following by this call.

    Errors:
    NOT_FOUND:
    - no incident with the given key exists
    """

    SetVariables: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.SetVariablesRequest,
        pyzeebe.proto.gateway_pb2.SetVariablesResponse,
    ]
    """
    Updates all the variables of a particular scope (e.g. process instance, flow element instance)
    from the given JSON document.

    Errors:
    NOT_FOUND:
    - no element with the given elementInstanceKey exists
    INVALID_ARGUMENT:
    - the given variables document is not a valid JSON document; valid documents are expected to
    be JSON documents where the root node is an object.
    """

    Topology: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.TopologyRequest,
        pyzeebe.proto.gateway_pb2.TopologyResponse,
    ]
    """
    Obtains the current topology of the cluster the gateway is part of.
    """

    UpdateJobRetries: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.UpdateJobRetriesRequest,
        pyzeebe.proto.gateway_pb2.UpdateJobRetriesResponse,
    ]
    """
    Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
    retries, should the underlying problem be solved.

    Errors:
    NOT_FOUND:
    - no job exists with the given key

    INVALID_ARGUMENT:
    - retries is not greater than 0
    """

    ModifyProcessInstance: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.ModifyProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.ModifyProcessInstanceResponse,
    ]
    """
    Modifies the process instance. This is done by activating and/or terminating specific elements of the instance.

    Errors:
    NOT_FOUND:
    - no process instance exists with the given key

    FAILED_PRECONDITION:
    - trying to activate element inside of a multi-instance

    INVALID_ARGUMENT:
    - activating or terminating unknown element
    - ancestor of element for activation doesn't exist
    - scope of variable is unknown
    """

    MigrateProcessInstance: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.MigrateProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.MigrateProcessInstanceResponse,
    ]
    """
    Migrates the process instance to the specified process definition.
    In simple terms, this is handled by updating the active element's process.

    Errors:
    NOT_FOUND:
    - no process instance exists with the given key, or it is not active
    - no process definition exists with the given target definition key
    - no process instance exists with the given key for the tenants the user is authorized to work with.

    FAILED_PRECONDITION:
    - not all active elements in the given process instance are mapped to the elements in the target process definition
    - a mapping instruction changes the type of an element or event
    - a mapping instruction changes the implementation of a task
    - a mapping instruction detaches a boundary event from an active element
    - a mapping instruction refers to an unsupported element (i.e. some elements will be supported later on)
    - a mapping instruction refers to element in unsupported scenarios.
    (i.e. migration is not supported when process instance or target process elements contains event subscriptions)
    - multiple mapping instructions target the same boundary event

    INVALID_ARGUMENT:
    - A `sourceElementId` does not refer to an element in the process instance's process definition
    - A `targetElementId` does not refer to an element in the target process definition
    - A `sourceElementId` is mapped by multiple mapping instructions.
    For example, the engine cannot determine how to migrate a process instance when the instructions are: [A->B, A->C].
    """

    UpdateJobTimeout: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.UpdateJobTimeoutRequest,
        pyzeebe.proto.gateway_pb2.UpdateJobTimeoutResponse,
    ]
    """
    Updates the deadline of a job using the timeout (in ms) provided. This can be used
    for extending or shortening the job deadline.

    Errors:
    NOT_FOUND:
    - no job exists with the given key

    INVALID_STATE:
    - no deadline exists for the given job key
    """

    DeleteResource: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.DeleteResourceRequest,
        pyzeebe.proto.gateway_pb2.DeleteResourceResponse,
    ]
    """
    Deletes a resource from the state. Once a resource has been deleted it cannot
    be recovered. If the resource needs to be available again, a new deployment
    of the resource is required.

    Deleting a process will cancel any running instances of this process
    definition. New instances of a deleted process are created using
    the lastest version that hasn't been deleted. Creating a new
    process instance is impossible when all versions have been
    deleted.

    Deleting a decision requirement definitions could cause incidents in process
    instances referencing these decisions in a business rule task. A decision
    will be evaluated with the latest version that hasn't been deleted. If all
    versions of a decision have been deleted the evaluation is rejected.

    Errors:
    NOT_FOUND:
    - No resource exists with the given key
    """

    BroadcastSignal: grpc.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.BroadcastSignalRequest,
        pyzeebe.proto.gateway_pb2.BroadcastSignalResponse,
    ]
    """
    Broadcasts a signal.
    """

class GatewayAsyncStub:
    ActivateJobs: grpc.aio.UnaryStreamMultiCallable[
        pyzeebe.proto.gateway_pb2.ActivateJobsRequest,
        pyzeebe.proto.gateway_pb2.ActivateJobsResponse,
    ]
    """
    Iterates through all known partitions round-robin and activates up to the requested
    maximum and streams them back to the client as they are activated.

    Errors:
    INVALID_ARGUMENT:
    - type is blank (empty string, null)
    - worker is blank (empty string, null)
    - timeout less than 1
    - maxJobsToActivate is less than 1
    """

    StreamActivatedJobs: grpc.aio.UnaryStreamMultiCallable[
        pyzeebe.proto.gateway_pb2.StreamActivatedJobsRequest,
        pyzeebe.proto.gateway_pb2.ActivatedJob,
    ]
    """
    Registers client to a job stream that will stream jobs back to the client as
    they become activatable.

    Errors:
    INVALID_ARGUMENT:
    - type is blank (empty string, null)
    - timeout less than 1
    - If multi-tenancy is enabled, and tenantIds is empty (empty list)
    - If multi-tenancy is enabled, and an invalid tenant ID is provided. A tenant ID is considered invalid if:
    - The tenant ID is blank (empty string, null)
    - The tenant ID is longer than 31 characters
    - The tenant ID contains anything other than alphanumeric characters, dot (.), dash (-), or underscore (_)
    - If multi-tenancy is disabled, and tenantIds is not empty (empty list), or has an ID other than <default>
    """

    CancelProcessInstance: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CancelProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.CancelProcessInstanceResponse,
    ]
    """
    Cancels a running process instance

    Errors:
    NOT_FOUND:
    - no process instance exists with the given key
    """

    CompleteJob: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CompleteJobRequest,
        pyzeebe.proto.gateway_pb2.CompleteJobResponse,
    ]
    """
    Completes a job with the given variables, which allows completing the associated service task.

    Errors:
    NOT_FOUND:
    - no job exists with the given job key. Note that since jobs are removed once completed,
    it could be that this job did exist at some point.

    FAILED_PRECONDITION:
    - the job was marked as failed. In that case, the related incident must be resolved before
    the job can be activated again and completed.
    """

    CreateProcessInstance: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceResponse,
    ]
    """
    Creates and starts an instance of the specified process. The process definition to use to
    create the instance can be specified either using its unique key (as returned by
    DeployProcess), or using the BPMN process ID and a version. Pass -1 as the version to use the
    latest deployed version. Note that only processes with none start events can be started through
    this command.

    Errors:
    NOT_FOUND:
    - no process with the given key exists (if processDefinitionKey was given)
    - no process with the given process ID exists (if bpmnProcessId was given but version was -1)
    - no process with the given process ID and version exists (if both bpmnProcessId and version were given)

    FAILED_PRECONDITION:
    - the process definition does not contain a none start event; only processes with none
    start event can be started manually.

    INVALID_ARGUMENT:
    - the given variables argument is not a valid JSON document; it is expected to be a valid
    JSON document where the root node is an object.
    """

    CreateProcessInstanceWithResult: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultRequest,
        pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultResponse,
    ]
    """
    Behaves similarly to `rpc CreateProcessInstance`, except that a successful response is received when the process completes successfully.
    """

    EvaluateDecision: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.EvaluateDecisionRequest,
        pyzeebe.proto.gateway_pb2.EvaluateDecisionResponse,
    ]
    """
    Evaluates a decision. The decision to evaluate can be specified either by
    using its unique key (as returned by DeployResource), or using the decision
    ID. When using the decision ID, the latest deployed version of the decision
    is used.

    Errors:
    INVALID_ARGUMENT:
    - no decision with the given key exists (if decisionKey was given)
    - no decision with the given decision ID exists (if decisionId was given)
    - both decision ID and decision KEY were provided, or are missing
    """

    DeployProcess: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.DeployProcessRequest,
        pyzeebe.proto.gateway_pb2.DeployProcessResponse,
    ]
    """
    Deploys one or more processes to Zeebe. Note that this is an atomic call,
    i.e. either all processes are deployed, or none of them are.

    Errors:
    INVALID_ARGUMENT:
    - no resources given.
    - if at least one resource is invalid. A resource is considered invalid if:
    - the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
    - the process is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
    """

    DeployResource: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.DeployResourceRequest,
        pyzeebe.proto.gateway_pb2.DeployResourceResponse,
    ]
    """
    Deploys one or more resources (e.g. processes or decision models) to Zeebe.
    Note that this is an atomic call, i.e. either all resources are deployed, or none of them are.

    Errors:
    PERMISSION_DENIED:
    - if a deployment to an unauthorized tenant is performed
    INVALID_ARGUMENT:
    - no resources given.
    - if at least one resource is invalid. A resource is considered invalid if:
    - the content is not deserializable (e.g. detected as BPMN, but it's broken XML)
    - the content is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
    - if multi-tenancy is enabled, and:
    - a tenant id is not provided
    - a tenant id with an invalid format is provided
    - if multi-tenancy is disabled and a tenant id is provided
    """

    FailJob: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.FailJobRequest,
        pyzeebe.proto.gateway_pb2.FailJobResponse,
    ]
    """
    Marks the job as failed; if the retries argument is positive, then the job will be immediately
    activatable again, and a worker could try again to process it. If it is zero or negative however,
    an incident will be raised, tagged with the given errorMessage, and the job will not be
    activatable until the incident is resolved.

    Errors:
    NOT_FOUND:
    - no job was found with the given key

    FAILED_PRECONDITION:
    - the job was not activated
    - the job is already in a failed state, i.e. ran out of retries
    """

    ThrowError: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.ThrowErrorRequest,
        pyzeebe.proto.gateway_pb2.ThrowErrorResponse,
    ]
    """
    Reports a business error (i.e. non-technical) that occurs while processing a job. The error is handled in the process by an error catch event. If there is no error catch event with the specified errorCode then an incident will be raised instead.

    Errors:
    NOT_FOUND:
    - no job was found with the given key

    FAILED_PRECONDITION:
    - the job is not in an activated state
    """

    PublishMessage: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.PublishMessageRequest,
        pyzeebe.proto.gateway_pb2.PublishMessageResponse,
    ]
    """
    Publishes a single message. Messages are published to specific partitions computed from their
    correlation keys.

    Errors:
    ALREADY_EXISTS:
    - a message with the same ID was previously published (and is still alive)
    """

    ResolveIncident: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.ResolveIncidentRequest,
        pyzeebe.proto.gateway_pb2.ResolveIncidentResponse,
    ]
    """
    Resolves a given incident. This simply marks the incident as resolved; most likely a call to
    UpdateJobRetries or SetVariables will be necessary to actually resolve the
    problem, following by this call.

    Errors:
    NOT_FOUND:
    - no incident with the given key exists
    """

    SetVariables: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.SetVariablesRequest,
        pyzeebe.proto.gateway_pb2.SetVariablesResponse,
    ]
    """
    Updates all the variables of a particular scope (e.g. process instance, flow element instance)
    from the given JSON document.

    Errors:
    NOT_FOUND:
    - no element with the given elementInstanceKey exists
    INVALID_ARGUMENT:
    - the given variables document is not a valid JSON document; valid documents are expected to
    be JSON documents where the root node is an object.
    """

    Topology: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.TopologyRequest,
        pyzeebe.proto.gateway_pb2.TopologyResponse,
    ]
    """
    Obtains the current topology of the cluster the gateway is part of.
    """

    UpdateJobRetries: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.UpdateJobRetriesRequest,
        pyzeebe.proto.gateway_pb2.UpdateJobRetriesResponse,
    ]
    """
    Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
    retries, should the underlying problem be solved.

    Errors:
    NOT_FOUND:
    - no job exists with the given key

    INVALID_ARGUMENT:
    - retries is not greater than 0
    """

    ModifyProcessInstance: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.ModifyProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.ModifyProcessInstanceResponse,
    ]
    """
    Modifies the process instance. This is done by activating and/or terminating specific elements of the instance.

    Errors:
    NOT_FOUND:
    - no process instance exists with the given key

    FAILED_PRECONDITION:
    - trying to activate element inside of a multi-instance

    INVALID_ARGUMENT:
    - activating or terminating unknown element
    - ancestor of element for activation doesn't exist
    - scope of variable is unknown
    """

    MigrateProcessInstance: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.MigrateProcessInstanceRequest,
        pyzeebe.proto.gateway_pb2.MigrateProcessInstanceResponse,
    ]
    """
    Migrates the process instance to the specified process definition.
    In simple terms, this is handled by updating the active element's process.

    Errors:
    NOT_FOUND:
    - no process instance exists with the given key, or it is not active
    - no process definition exists with the given target definition key
    - no process instance exists with the given key for the tenants the user is authorized to work with.

    FAILED_PRECONDITION:
    - not all active elements in the given process instance are mapped to the elements in the target process definition
    - a mapping instruction changes the type of an element or event
    - a mapping instruction changes the implementation of a task
    - a mapping instruction detaches a boundary event from an active element
    - a mapping instruction refers to an unsupported element (i.e. some elements will be supported later on)
    - a mapping instruction refers to element in unsupported scenarios.
    (i.e. migration is not supported when process instance or target process elements contains event subscriptions)
    - multiple mapping instructions target the same boundary event

    INVALID_ARGUMENT:
    - A `sourceElementId` does not refer to an element in the process instance's process definition
    - A `targetElementId` does not refer to an element in the target process definition
    - A `sourceElementId` is mapped by multiple mapping instructions.
    For example, the engine cannot determine how to migrate a process instance when the instructions are: [A->B, A->C].
    """

    UpdateJobTimeout: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.UpdateJobTimeoutRequest,
        pyzeebe.proto.gateway_pb2.UpdateJobTimeoutResponse,
    ]
    """
    Updates the deadline of a job using the timeout (in ms) provided. This can be used
    for extending or shortening the job deadline.

    Errors:
    NOT_FOUND:
    - no job exists with the given key

    INVALID_STATE:
    - no deadline exists for the given job key
    """

    DeleteResource: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.DeleteResourceRequest,
        pyzeebe.proto.gateway_pb2.DeleteResourceResponse,
    ]
    """
    Deletes a resource from the state. Once a resource has been deleted it cannot
    be recovered. If the resource needs to be available again, a new deployment
    of the resource is required.

    Deleting a process will cancel any running instances of this process
    definition. New instances of a deleted process are created using
    the lastest version that hasn't been deleted. Creating a new
    process instance is impossible when all versions have been
    deleted.

    Deleting a decision requirement definitions could cause incidents in process
    instances referencing these decisions in a business rule task. A decision
    will be evaluated with the latest version that hasn't been deleted. If all
    versions of a decision have been deleted the evaluation is rejected.

    Errors:
    NOT_FOUND:
    - No resource exists with the given key
    """

    BroadcastSignal: grpc.aio.UnaryUnaryMultiCallable[
        pyzeebe.proto.gateway_pb2.BroadcastSignalRequest,
        pyzeebe.proto.gateway_pb2.BroadcastSignalResponse,
    ]
    """
    Broadcasts a signal.
    """

class GatewayServicer(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def ActivateJobs(
        self,
        request: pyzeebe.proto.gateway_pb2.ActivateJobsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[pyzeebe.proto.gateway_pb2.ActivateJobsResponse], collections.abc.AsyncIterator[pyzeebe.proto.gateway_pb2.ActivateJobsResponse]]:
        """
        Iterates through all known partitions round-robin and activates up to the requested
        maximum and streams them back to the client as they are activated.

        Errors:
        INVALID_ARGUMENT:
        - type is blank (empty string, null)
        - worker is blank (empty string, null)
        - timeout less than 1
        - maxJobsToActivate is less than 1
        """

    @abc.abstractmethod
    def StreamActivatedJobs(
        self,
        request: pyzeebe.proto.gateway_pb2.StreamActivatedJobsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[pyzeebe.proto.gateway_pb2.ActivatedJob], collections.abc.AsyncIterator[pyzeebe.proto.gateway_pb2.ActivatedJob]]:
        """
        Registers client to a job stream that will stream jobs back to the client as
        they become activatable.

        Errors:
        INVALID_ARGUMENT:
        - type is blank (empty string, null)
        - timeout less than 1
        - If multi-tenancy is enabled, and tenantIds is empty (empty list)
        - If multi-tenancy is enabled, and an invalid tenant ID is provided. A tenant ID is considered invalid if:
        - The tenant ID is blank (empty string, null)
        - The tenant ID is longer than 31 characters
        - The tenant ID contains anything other than alphanumeric characters, dot (.), dash (-), or underscore (_)
        - If multi-tenancy is disabled, and tenantIds is not empty (empty list), or has an ID other than <default>
        """

    @abc.abstractmethod
    def CancelProcessInstance(
        self,
        request: pyzeebe.proto.gateway_pb2.CancelProcessInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.CancelProcessInstanceResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.CancelProcessInstanceResponse]]:
        """
        Cancels a running process instance

        Errors:
        NOT_FOUND:
        - no process instance exists with the given key
        """

    @abc.abstractmethod
    def CompleteJob(
        self,
        request: pyzeebe.proto.gateway_pb2.CompleteJobRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.CompleteJobResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.CompleteJobResponse]]:
        """
        Completes a job with the given variables, which allows completing the associated service task.

        Errors:
        NOT_FOUND:
        - no job exists with the given job key. Note that since jobs are removed once completed,
        it could be that this job did exist at some point.

        FAILED_PRECONDITION:
        - the job was marked as failed. In that case, the related incident must be resolved before
        the job can be activated again and completed.
        """

    @abc.abstractmethod
    def CreateProcessInstance(
        self,
        request: pyzeebe.proto.gateway_pb2.CreateProcessInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.CreateProcessInstanceResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.CreateProcessInstanceResponse]]:
        """
        Creates and starts an instance of the specified process. The process definition to use to
        create the instance can be specified either using its unique key (as returned by
        DeployProcess), or using the BPMN process ID and a version. Pass -1 as the version to use the
        latest deployed version. Note that only processes with none start events can be started through
        this command.

        Errors:
        NOT_FOUND:
        - no process with the given key exists (if processDefinitionKey was given)
        - no process with the given process ID exists (if bpmnProcessId was given but version was -1)
        - no process with the given process ID and version exists (if both bpmnProcessId and version were given)

        FAILED_PRECONDITION:
        - the process definition does not contain a none start event; only processes with none
        start event can be started manually.

        INVALID_ARGUMENT:
        - the given variables argument is not a valid JSON document; it is expected to be a valid
        JSON document where the root node is an object.
        """

    @abc.abstractmethod
    def CreateProcessInstanceWithResult(
        self,
        request: pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.CreateProcessInstanceWithResultResponse]]:
        """
        Behaves similarly to `rpc CreateProcessInstance`, except that a successful response is received when the process completes successfully.
        """

    @abc.abstractmethod
    def EvaluateDecision(
        self,
        request: pyzeebe.proto.gateway_pb2.EvaluateDecisionRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.EvaluateDecisionResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.EvaluateDecisionResponse]]:
        """
        Evaluates a decision. The decision to evaluate can be specified either by
        using its unique key (as returned by DeployResource), or using the decision
        ID. When using the decision ID, the latest deployed version of the decision
        is used.

        Errors:
        INVALID_ARGUMENT:
        - no decision with the given key exists (if decisionKey was given)
        - no decision with the given decision ID exists (if decisionId was given)
        - both decision ID and decision KEY were provided, or are missing
        """

    @abc.abstractmethod
    def DeployProcess(
        self,
        request: pyzeebe.proto.gateway_pb2.DeployProcessRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.DeployProcessResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.DeployProcessResponse]]:
        """
        Deploys one or more processes to Zeebe. Note that this is an atomic call,
        i.e. either all processes are deployed, or none of them are.

        Errors:
        INVALID_ARGUMENT:
        - no resources given.
        - if at least one resource is invalid. A resource is considered invalid if:
        - the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
        - the process is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
        """

    @abc.abstractmethod
    def DeployResource(
        self,
        request: pyzeebe.proto.gateway_pb2.DeployResourceRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.DeployResourceResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.DeployResourceResponse]]:
        """
        Deploys one or more resources (e.g. processes or decision models) to Zeebe.
        Note that this is an atomic call, i.e. either all resources are deployed, or none of them are.

        Errors:
        PERMISSION_DENIED:
        - if a deployment to an unauthorized tenant is performed
        INVALID_ARGUMENT:
        - no resources given.
        - if at least one resource is invalid. A resource is considered invalid if:
        - the content is not deserializable (e.g. detected as BPMN, but it's broken XML)
        - the content is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
        - if multi-tenancy is enabled, and:
        - a tenant id is not provided
        - a tenant id with an invalid format is provided
        - if multi-tenancy is disabled and a tenant id is provided
        """

    @abc.abstractmethod
    def FailJob(
        self,
        request: pyzeebe.proto.gateway_pb2.FailJobRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.FailJobResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.FailJobResponse]]:
        """
        Marks the job as failed; if the retries argument is positive, then the job will be immediately
        activatable again, and a worker could try again to process it. If it is zero or negative however,
        an incident will be raised, tagged with the given errorMessage, and the job will not be
        activatable until the incident is resolved.

        Errors:
        NOT_FOUND:
        - no job was found with the given key

        FAILED_PRECONDITION:
        - the job was not activated
        - the job is already in a failed state, i.e. ran out of retries
        """

    @abc.abstractmethod
    def ThrowError(
        self,
        request: pyzeebe.proto.gateway_pb2.ThrowErrorRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.ThrowErrorResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.ThrowErrorResponse]]:
        """
        Reports a business error (i.e. non-technical) that occurs while processing a job. The error is handled in the process by an error catch event. If there is no error catch event with the specified errorCode then an incident will be raised instead.

        Errors:
        NOT_FOUND:
        - no job was found with the given key

        FAILED_PRECONDITION:
        - the job is not in an activated state
        """

    @abc.abstractmethod
    def PublishMessage(
        self,
        request: pyzeebe.proto.gateway_pb2.PublishMessageRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.PublishMessageResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.PublishMessageResponse]]:
        """
        Publishes a single message. Messages are published to specific partitions computed from their
        correlation keys.

        Errors:
        ALREADY_EXISTS:
        - a message with the same ID was previously published (and is still alive)
        """

    @abc.abstractmethod
    def ResolveIncident(
        self,
        request: pyzeebe.proto.gateway_pb2.ResolveIncidentRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.ResolveIncidentResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.ResolveIncidentResponse]]:
        """
        Resolves a given incident. This simply marks the incident as resolved; most likely a call to
        UpdateJobRetries or SetVariables will be necessary to actually resolve the
        problem, following by this call.

        Errors:
        NOT_FOUND:
        - no incident with the given key exists
        """

    @abc.abstractmethod
    def SetVariables(
        self,
        request: pyzeebe.proto.gateway_pb2.SetVariablesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.SetVariablesResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.SetVariablesResponse]]:
        """
        Updates all the variables of a particular scope (e.g. process instance, flow element instance)
        from the given JSON document.

        Errors:
        NOT_FOUND:
        - no element with the given elementInstanceKey exists
        INVALID_ARGUMENT:
        - the given variables document is not a valid JSON document; valid documents are expected to
        be JSON documents where the root node is an object.
        """

    @abc.abstractmethod
    def Topology(
        self,
        request: pyzeebe.proto.gateway_pb2.TopologyRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.TopologyResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.TopologyResponse]]:
        """
        Obtains the current topology of the cluster the gateway is part of.
        """

    @abc.abstractmethod
    def UpdateJobRetries(
        self,
        request: pyzeebe.proto.gateway_pb2.UpdateJobRetriesRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.UpdateJobRetriesResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.UpdateJobRetriesResponse]]:
        """
        Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
        retries, should the underlying problem be solved.

        Errors:
        NOT_FOUND:
        - no job exists with the given key

        INVALID_ARGUMENT:
        - retries is not greater than 0
        """

    @abc.abstractmethod
    def ModifyProcessInstance(
        self,
        request: pyzeebe.proto.gateway_pb2.ModifyProcessInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.ModifyProcessInstanceResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.ModifyProcessInstanceResponse]]:
        """
        Modifies the process instance. This is done by activating and/or terminating specific elements of the instance.

        Errors:
        NOT_FOUND:
        - no process instance exists with the given key

        FAILED_PRECONDITION:
        - trying to activate element inside of a multi-instance

        INVALID_ARGUMENT:
        - activating or terminating unknown element
        - ancestor of element for activation doesn't exist
        - scope of variable is unknown
        """

    @abc.abstractmethod
    def MigrateProcessInstance(
        self,
        request: pyzeebe.proto.gateway_pb2.MigrateProcessInstanceRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.MigrateProcessInstanceResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.MigrateProcessInstanceResponse]]:
        """
        Migrates the process instance to the specified process definition.
        In simple terms, this is handled by updating the active element's process.

        Errors:
        NOT_FOUND:
        - no process instance exists with the given key, or it is not active
        - no process definition exists with the given target definition key
        - no process instance exists with the given key for the tenants the user is authorized to work with.

        FAILED_PRECONDITION:
        - not all active elements in the given process instance are mapped to the elements in the target process definition
        - a mapping instruction changes the type of an element or event
        - a mapping instruction changes the implementation of a task
        - a mapping instruction detaches a boundary event from an active element
        - a mapping instruction refers to an unsupported element (i.e. some elements will be supported later on)
        - a mapping instruction refers to element in unsupported scenarios.
        (i.e. migration is not supported when process instance or target process elements contains event subscriptions)
        - multiple mapping instructions target the same boundary event

        INVALID_ARGUMENT:
        - A `sourceElementId` does not refer to an element in the process instance's process definition
        - A `targetElementId` does not refer to an element in the target process definition
        - A `sourceElementId` is mapped by multiple mapping instructions.
        For example, the engine cannot determine how to migrate a process instance when the instructions are: [A->B, A->C].
        """

    @abc.abstractmethod
    def UpdateJobTimeout(
        self,
        request: pyzeebe.proto.gateway_pb2.UpdateJobTimeoutRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.UpdateJobTimeoutResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.UpdateJobTimeoutResponse]]:
        """
        Updates the deadline of a job using the timeout (in ms) provided. This can be used
        for extending or shortening the job deadline.

        Errors:
        NOT_FOUND:
        - no job exists with the given key

        INVALID_STATE:
        - no deadline exists for the given job key
        """

    @abc.abstractmethod
    def DeleteResource(
        self,
        request: pyzeebe.proto.gateway_pb2.DeleteResourceRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.DeleteResourceResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.DeleteResourceResponse]]:
        """
        Deletes a resource from the state. Once a resource has been deleted it cannot
        be recovered. If the resource needs to be available again, a new deployment
        of the resource is required.

        Deleting a process will cancel any running instances of this process
        definition. New instances of a deleted process are created using
        the lastest version that hasn't been deleted. Creating a new
        process instance is impossible when all versions have been
        deleted.

        Deleting a decision requirement definitions could cause incidents in process
        instances referencing these decisions in a business rule task. A decision
        will be evaluated with the latest version that hasn't been deleted. If all
        versions of a decision have been deleted the evaluation is rejected.

        Errors:
        NOT_FOUND:
        - No resource exists with the given key
        """

    @abc.abstractmethod
    def BroadcastSignal(
        self,
        request: pyzeebe.proto.gateway_pb2.BroadcastSignalRequest,
        context: _ServicerContext,
    ) -> typing.Union[pyzeebe.proto.gateway_pb2.BroadcastSignalResponse, collections.abc.Awaitable[pyzeebe.proto.gateway_pb2.BroadcastSignalResponse]]:
        """
        Broadcasts a signal.
        """

def add_GatewayServicer_to_server(servicer: GatewayServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
