# flake8: noqa
# pylint: disable=C0301

# Some common builtin exeptions we might want to watch for
PYTHON_BUILTIN_EXCEPTIONS = [
    "ArithmeticError",
    "AssertionError",
    "AttributeError",
#    "BaseException",
#    "BlockingIOError",
#    "BrokenPipeError",
#    "BufferError",
    "BytesWarning",
#    "ChildProcessError",
#    "ConnectionAbortedError",
#    "ConnectionError",
#    "ConnectionRefusedError",
    "ConnectionResetError",
#    "DeprecationWarning",
#    "EnvironmentError",
    "EOFError",
#    "Exception",
    "FileExistsError",
    "FileNotFoundError",
    "FloatingPointError",
#    "FutureWarning",
#    "GeneratorExit",
    "ImportError",
    "ImportWarning",
#    "IndentationError",
    "IndexError",
    "InterruptedError",
    "IOError",
    "IsADirectoryError",
#    "KeyboardInterrupt",
    "KeyError",
    "LookupError",
    "MemoryError",
    "ModuleNotFoundError",
    "NameError",
#    "NotADirectoryError",
    "NotImplementedError",
    "OSError",
    "OverflowError",
#    "PendingDeprecationWarning",
    "PermissionError",
    "ProcessLookupError",
    "RecursionError",
    "ReferenceError",
    "ResourceWarning",
    "RuntimeError",
#    "RuntimeWarning",
#    "StopAsyncIteration",
#    "StopIteration",
    "SyntaxError",
#    "SyntaxWarning",
    "SystemError",
    "SystemExit",
#    "TabError",
    "TimeoutError",
    "TypeError",
    "UnboundLocalError",
    "UnicodeDecodeError",
    "UnicodeEncodeError",
    "UnicodeError",
    "UnicodeTranslateError",
    "UnicodeWarning",
    "UserWarning",
    "ValueError",
#    "Warning",
#    "WindowsError",
    "ZeroDivisionError",
]

# https://opendev.org/openstack/oslo.db/src/branch/master/oslo_db/exception.py
OSLO_DB_EXCEPTIONS = [
    "DBError",
    "DBDuplicateEntry",
    "DBConstraintError",
    "DBReferenceError",
    "DBNonExistentConstraint",
    "DBNonExistentTable",
    "DBNonExistentDatabase",
    "DBDeadlock",
    "DBInvalidUnicodeParameter",
    "DBMigrationError",
    "DBConnectionError",
    "DBDataError",
    "DBNotSupportedError",
    "InvalidSortKey",
    "ColumnError",
    "BackendNotAvailable",
    "RetryRequest",
    "NoEngineContextEstablished",
    "ContextNotRequestedError",
    "CantStartEngineError",
]

# https://opendev.org/openstack/oslo.messaging/src/branch/master/oslo_messaging/exceptions.py
OSLO_MESSAGING_EXCEPTIONS = [
# oslo_messaging/exceptions.py
    "MessagingException",
    "MessagingTimeout",
    "MessageDeliveryFailure",
    "InvalidTarget",
    "MessageUndeliverable",
    "ConfigurationError",
# oslo_messaging/rpc/client.py
    "RemoteError",
    "RPCVersionCapError",
    "ClientSendError",
]

# Exceptions common to any project should be defined here
EXCEPTIONS_COMMON = [
    r'AMQP server on .+ is unreachable',
    r'amqp.exceptions.ConnectionForced',
    r'OSError: Server unexpectedly closed connection',
] + OSLO_DB_EXCEPTIONS \
  + PYTHON_BUILTIN_EXCEPTIONS
