## iGSTT(Gemini STT)
iGSTT(Gemini STT) 开源免费的语音转文本（STT）的命令行工具。  
iGSTT(Gemini STT) 是通过调用 Gemini STT 的接口，实现语音转文本（STT）的命令行工具。

### 添加 API key
```bash
# 编辑 .zshrc：
vim ~/.zshrc

# 添加信息（导入环境变量）：
export GEMINI_API_KEY=<YOUR_API_KEY_HERE>

# 保存后应用更改：
source ~/.zshrc
```
### 安装 iGSTT
```bash
pip install igstt
```

### 运行 iGSTT
```bash
usage: igstt [-h] [-i INPUT] [-o OUTPUT] [text]

🎧 Gemini 语音转文本（STT）工具

positional arguments:
  text                 提示信息

options:
  -h, --help           show this help message and exit
  -i, --input INPUT    音频文件路径
  -o, --output OUTPUT  输出文件路径（默认与输入同名 .lrc）
```

### 实例
```bash
# 指定语音文本的内容
igstt "Describe this audio clip"

# 指定语音文本的文件 -i "input.mp3"
igstt -i "input.mp3"

# 指定语音文本的文件 -i "input.mp3"
# 指定语音保存的文件 -o "output.lrc"
igstt -i "input.mp3" -o "output.lrc"
```

### 实例转LRC
```bash
igstt -i input.wav
提示信息: Generate LRC, LRC content format: [minutes:seconds.milliseconds] English | Simplified Chinese
音频文件: input.wav
输出文件: input.lrc
🤖 Gemini 返回：
[00:00.060] Hello, |
[00:00.550] | 这是一个 Gemini TTS CLI 工具。
[00:04.650] | 记得关注哦。
####################
✅ 已写入到 input.lrc

```

### 模型
**gemini-2.5-flash**  

### 获取 API key
API key：[https://aistudio.google.com/apikey](https://aistudio.google.com/apikey)

### 额度参数：
每分钟请求数 (RPM)  
每分钟 token 数（输入）(TPM)  
每日请求数 (RPD)  

### 免费额度：
RPM：10	  
TPM：250000	  
RPD：250  

额度详情：[https://ai.google.dev/gemini-api/docs/rate-limits?hl=zh-cn](https://ai.google.dev/gemini-api/docs/rate-limits?hl=zh-cn)

接口详情：[https://ai.google.dev/gemini-api/docs/files?hl=zh-cn](https://ai.google.dev/gemini-api/docs/files?hl=zh-cn)


## 软件信息

### 网站
[https://stt.ichochy.com](https://stt.ichochy.com)

### GitHub 
[https://github.com/ichochy/igstt](https://github.com/ichochy/igstt)

### PyPI
[https://pypi.org/project/igstt](https://pypi.org/project/igstt/)


