"""
PyBird libary auxiliaries
"""

# Resummation bulk coefficients Q^{ll'}_{||N-j}(n, \alpha) of the IR-resummation matrices.
# Q(N-j)(l)(l')(n)(\alpha). see in Resum(object) method Ps(self, bird) for details.
# up to k^{2*8}
Q000 = {
    0: lambda f: (-3 - 2 * f - f**2) / 6.,
    1: lambda f: 0,
    2: lambda f: (15 + 20 * f + 22 * f**2 + 12 * f**3 + 3 * f**4) / 120.,
    3: lambda f: 0,
    4: lambda f: (-35 - 70 * f - 119 * f**2 - 124 * f**3 - 81 * f**4 - 30 * f**5 - 5 * f**6) / 1680.,
    5: lambda f: 0,
    6: lambda f: (0.125 + (f * (2 + f)) / 6. + (3 * f**2 * (2 + f)**2) / 20. + (f**3 * (2 + f)**3) / 14. + (f**4 * (2 + f)**4) / 72.) / 48.,
    7: lambda f: 0,
    8: lambda f: (-0.0625 - (5 * f * (2 + f)) / 48. - (f**2 * (2 + f)**2) / 8. - (5 * f**3 * (2 + f)**3) / 56. - (5 * f**4 * (2 + f)**4) / 144. - (f**5 * (2 + f)**5) / 176.) / 240.,
    9: lambda f: 0,
    10: lambda f: (0.03125 + (f * (2 + f)) / 16. + (3 * f**2 * (2 + f)**2) / 32. + (5 * f**3 * (2 + f)**3) / 56. + (5 * f**4 * (2 + f)**4) / 96. + (3 * f**5 * (2 + f)**5) / 176.) / 1440.,
    11: lambda f: 0,
    12: lambda f: (-495 - 1155 * f * (2 + f) - 2079 * f**2 * (2 + f)**2 - 2475 * f**3 * (2 + f)**3 - 1925 * f**4 * (2 + f)**4 - 945 * f**5 * (2 + f)**5) / 3.193344e8,
    13: lambda f: 0,
    14: lambda f: (0.0078125 + (f * (2 + f)) / 48. + (7 * f**2 * (2 + f)**2) / 160. + (f**3 * (2 + f)**3) / 16. + (35 * f**4 * (2 + f)**4) / 576. + (7 * f**5 * (2 + f)**5) / 176.) / 80640.,
    15: lambda f: 0,
    16: lambda f: (-3 - 2 * f - f**2) / 18.,
    17: lambda f: (15 + 10 * f + 2 * f**2) / 45.,
    18: lambda f: (15 + 20 * f + 22 * f**2 + 12 * f**3 + 3 * f**4) / 180.,
    19: lambda f: (-105 - 140 * f - 133 * f**2 - 66 * f**3 - 12 * f**4) / 630.,
    20: lambda f: (-35 - 70 * f - 119 * f**2 - 124 * f**3 - 81 * f**4 - 30 * f**5 - 5 * f**6) / 1680.,
    21: lambda f: (105 + 210 * f + 336 * f**2 + 336 * f**3 + 205 * f**4 + 70 * f**5 + 10 * f**6) / 2520.,
    22: lambda f: (315 + 840 * f + 1932 * f**2 + 2952 * f**3 + 3098 * f**4 + 2200 * f**5 + 1020 * f**6 + 280 * f**7 + 35 * f**8) / 90720.,
    23: lambda f: (-3465 - 9240 * f - 20559 * f**2 - 30690 * f**3 - 31207 * f**4 - 21380 * f**5 - 9465 * f**6 - 2450 * f**7 - 280 * f**8) / 498960.,
    24: lambda f: (-693 - 2310 * f - 6699 * f**2 - 13464 * f**3 - 19426 * f**4 - 20276 * f**5 - 15270 * f**6 - 8120 * f**7 - 2905 * f**8 - 630 * f**9 - 63 * f**10) / 1.596672e6,
    25: lambda f: (45045 + 150150 * f + 426426 * f**2 + 844272 * f**3 + 1195766 * f**4 + 1222780 * f**5 + 899040 * f**6 + 464800 * f**7 + 160685 * f**8 + 33390 * f**9 + 3150 * f**10) / 5.189184e7,
    26: lambda f: (3003 + 12012 * f + 42042 * f**2 + 104676 * f**3 + 192049 * f**4 + 264056 * f**5 + 274524 * f**6 + 215432 * f**7 + 125965 * f**8 + 53340 * f**9 + 15498 * f**10 + 2772 * f**11 + 231 * f**12) / 6.918912e7,
    27: lambda f: (-15015 - 60060 * f - 207207 * f**2 - 510510 * f**3 - 925210 * f**4 - 1255280 * f**5 - 1285670 * f**6 - 992068 * f**7 - 568995 * f**8 - 235620 * f**9 - 66675 * f**10 - 11550 * f**11 - 924 * f**12) / 1.729728e8,
    28: lambda f: (-6435 - 30030 * f - 123123 * f**2 - 365508 * f**3 - 813527 * f**4 - 1386970 * f**5 - 1805655 * f**6 - 1753240 * f**7 - 1229225 * f**8 - 598050 * f**9 - 190485 * f**10 - 35640 * f**11 - 2970 * f**12) / 1.7791488e9,
    29: lambda f: (45045 + 210210 * f + 852852 * f**2 + 2512224 * f**3 + 5542823 * f**4 + 9361690 * f**5 + 12053010 * f**6 + 11522224 * f**7 + 7904435 * f**8 + 3740310 * f**9 + 1152900 * f**10 + 207900 * f**11 + 16632 * f**12) / 6.2270208e9,
    30: lambda f: (6435 + 34320 * f + 161304 * f**2 + 555984 * f**3 + 1454596 * f**4 + 2958800 * f**5 + 4538760 * f**6 + 5017040 * f**7 + 3855250 * f**8 + 1990800 * f**9 + 656460 * f**10 + 124740 * f**11 + 10395 * f**12) / 2.49080832e10,
    31: lambda f: (-6435 - 34320 * f - 160017 * f**2 - 548262 * f**3 - 1424995 * f**4 - 2878460 * f**5 - 4374825 * f**6 - 4758362 * f**7 - 3568705 * f**8 - 1786680 * f**9 - 568575 * f**10 - 103950 * f**11 - 8316 * f**12) / 1.24540416e10,
}

Q002 = {
    0: lambda f: 0,
    1: lambda f: -(f * (2 + f)) / 15.,
    2: lambda f: 0,
    3: lambda f: (f * (14 + 19 * f + 12 * f**2 + 3 * f**3)) / 210.,
    4: lambda f: 0,
    5: lambda f: -(f * (42 + 93 * f + 112 * f**2 + 78 * f**3 + 30 * f**4 + 5 * f**5)) / 2520.,
    6: lambda f: 0,
    7: lambda f: (f * (462 + 1419 * f + 2508 * f**2 + 2837 * f**3 + 2110 * f**4 + 1005 * f**5 + 280 * f**6 + 35 * f**7)) / 166320.,
    8: lambda f: 0,
    9: lambda f: -(f * (6006 + 23595 * f + 54912 * f**2 + 85748 * f**3 + 94060 * f**4 + 73170 * f**5 + 39760 * f**6 + 14420 * f**7 + 3150 * f**8 + 315 * f**9)) / 1.729728e7,
    10: lambda f: 0,
    11: lambda f: (f * (6006 + 28743 * f + 82940 * f**2 + 165035 * f**3 + 238900 * f**4 + 242350 * f**5 + 162400 * f**6 + 67550 * f**7 + 15750 * f**8 + 1575 * f**9)) / 1.729728e8,
    12: lambda f: 0,
    13: lambda f: -(f * (6006 + 33891 * f + 116688 * f**2 + 282022 * f**3 + 506750 * f**4 + 607125 * f**5 + 450800 * f**6 + 198100 * f**7 + 47250 * f**8 + 4725 * f**9)) / 2.0756736e9,
    14: lambda f: 0,
    15: lambda f: (f * (858 + 5577 * f + 22308 * f**2 + 63427 * f**3 + 136070 * f**4 + 182745 * f**5 + 144200 * f**6 + 65275 * f**7 + 15750 * f**8 + 1575 * f**9)) / 4.1513472e9,
    16: lambda f: (f * (2 + f)) / 45.,
    17: lambda f: -(f * (28 + 11 * f)) / 315.,
    18: lambda f: -(f * (70 + 123 * f + 100 * f**2 + 28 * f**3)) / 4200.,
    19: lambda f: (f * (294 + 357 * f + 200 * f**2 + 44 * f**3)) / 2940.,
    20: lambda f: (f * (70 + 239 * f + 400 * f**2 + 349 * f**3 + 160 * f**4 + 30 * f**5)) / 25200.,
    21: lambda f: -(f * (686 + 1414 * f + 1580 * f**2 + 1017 * f**3 + 360 * f**4 + 55 * f**5)) / 17640.,
    22: lambda f: -(f * (2310 + 15411 * f + 42900 * f**2 + 65446 * f**3 + 60890 * f**4 + 34515 * f**5 + 11060 * f**6 + 1540 * f**7)) / 9.9792e6,
    23: lambda f: (f * (61446 + 179025 * f + 299640 * f**2 + 320318 * f**3 + 224650 * f**4 + 100665 * f**5 + 26320 * f**6 + 3080 * f**7)) / 6.98544e6,
    24: lambda f: (f**2 * (12012 + 57200 * f + 133757 * f**2 + 194470 * f**3 + 187375 * f**4 + 120820 * f**5 + 50435 * f**6 + 12390 * f**7 + 1365 * f**8)) / 8.64864e7,
    25: lambda f: -(f * (168168 + 633633 * f + 1412840 * f**2 + 2111122 * f**3 + 2213020 * f**4 + 1642840 * f**5 + 850640 * f**6 + 293510 * f**7 + 60900 * f**8 + 5775 * f**9)) / 1.2108096e8,
    26: lambda f: -(f * (-6006 + 7293 * f + 128700 * f**2 + 466336 * f**3 + 974660 * f**4 + 1365294 * f**5 + 1346744 * f**6 + 945700 * f**7 + 465570 * f**8 + 153405 * f**9 + 30492 * f**10 + 2772 * f**11)) / 2.0756736e9,
    27: lambda f: (f * (1219218 + 5636631 * f + 15701400 * f**2 + 30135040 * f**3 + 42038900 * f**4 + 43564362 * f**5 + 33692624 * f**6 + 19258540 * f**7 + 7922250 * f**8 + 2224215 * f**9 + 382536 * f**10 + 30492 * f**11)) / 7.2648576e9,
    28: lambda f: (f * (-30030 - 61347 * f + 171600 * f**2 + 1327183 * f**3 + 4003700 * f**4 + 7909560 * f**5 + 10765160 * f**6 + 9846550 * f**7 + 5868450 * f**8 + 2178225 * f**9 + 457380 * f**10 + 41580 * f**11)) / 6.2270208e10,
    29: lambda f: -(f * (714714 + 3915912 * f + 13084500 * f**2 + 30671459 * f**3 + 53418700 * f**4 + 69497811 * f**5 + 66220672 * f**6 + 44968070 * f**7 + 21026250 * f**8 + 6412770 * f**9 + 1147608 * f**10 + 91476 * f**11)) / 4.35891456e10,
    30: lambda f: -(f * (-4290 - 15873 * f - 14300 * f**2 + 97682 * f**3 + 503230 * f**4 + 1471985 * f**5 + 2619820 * f**6 + 2811200 * f**7 + 1832250 * f**8 + 712425 * f**9 + 152460 * f**10 + 13860 * f**11)) / 8.3026944e10,
    31: lambda f: (f * (78078 + 494637 * f + 1927640 * f**2 + 5337306 * f**3 + 11145230 * f**4 + 17062027 * f**5 + 18390624 * f**6 + 13588540 * f**7 + 6704250 * f**8 + 2108715 * f**9 + 382536 * f**10 + 30492 * f**11)) / 5.81188608e10,
}

Q020 = {
    0: lambda f: -(f * (2 + f)) / 3.,
    1: lambda f: 0,
    2: lambda f: (f * (14 + 19 * f + 12 * f**2 + 3 * f**3)) / 42.,
    3: lambda f: 0,
    4: lambda f: -(f * (42 + 93 * f + 112 * f**2 + 78 * f**3 + 30 * f**4 + 5 * f**5)) / 504.,
    5: lambda f: 0,
    6: lambda f: (f * (462 + 1419 * f + 2508 * f**2 + 2837 * f**3 + 2110 * f**4 + 1005 * f**5 + 280 * f**6 + 35 * f**7)) / 33264.,
    7: lambda f: 0,
    8: lambda f: -(f * (6006 + 23595 * f + 54912 * f**2 + 85748 * f**3 + 94060 * f**4 + 73170 * f**5 + 39760 * f**6 + 14420 * f**7 + 3150 * f**8 + 315 * f**9)) / 3.459456e6,
    9: lambda f: 0,
    10: lambda f: (f * (6006 + 28743 * f + 82940 * f**2 + 165035 * f**3 + 238900 * f**4 + 242350 * f**5 + 162400 * f**6 + 67550 * f**7 + 15750 * f**8 + 1575 * f**9)) / 3.459456e7,
    11: lambda f: 0,
    12: lambda f: -(f * (6006 + 33891 * f + 116688 * f**2 + 282022 * f**3 + 506750 * f**4 + 607125 * f**5 + 450800 * f**6 + 198100 * f**7 + 47250 * f**8 + 4725 * f**9)) / 4.1513472e8,
    13: lambda f: 0,
    14: lambda f: (f * (858 + 5577 * f + 22308 * f**2 + 63427 * f**3 + 136070 * f**4 + 182745 * f**5 + 144200 * f**6 + 65275 * f**7 + 15750 * f**8 + 1575 * f**9)) / 8.3026944e8,
    15: lambda f: 0,
    16: lambda f: -(f * (2 + f)) / 9.,
    17: lambda f: (f * (28 + 11 * f)) / 63.,
    18: lambda f: (f * (14 + 19 * f + 12 * f**2 + 3 * f**3)) / 63.,
    19: lambda f: -(f * (56 + 73 * f + 42 * f**2 + 9 * f**3)) / 126.,
    20: lambda f: -(f * (42 + 93 * f + 112 * f**2 + 78 * f**3 + 30 * f**4 + 5 * f**5)) / 504.,
    21: lambda f: (f * (924 + 2013 * f + 2332 * f**2 + 1550 * f**3 + 560 * f**4 + 85 * f**5)) / 5544.,
    22: lambda f: (f * (462 + 1419 * f + 2508 * f**2 + 2837 * f**3 + 2110 * f**4 + 1005 * f**5 + 280 * f**6 + 35 * f**7)) / 24948.,
    23: lambda f: -(f * (48048 + 146289 * f + 253110 * f**2 + 279487 * f**3 + 201860 * f**4 + 92775 * f**5 + 24710 * f**6 + 2905 * f**7)) / 1.297296e6,
    24: lambda f: (-5 * f * (6006 + 23595 * f + 54912 * f**2 + 85748 * f**3 + 94060 * f**4 + 73170 * f**5 + 39760 * f**6 + 14420 * f**7 + 3150 * f**8 + 315 * f**9)) / 1.0378368e7,
    25: lambda f: (f * (60060 + 234663 * f + 538824 * f**2 + 828932 * f**3 + 893680 * f**4 + 681498 * f**5 + 361816 * f**6 + 127652 * f**7 + 26964 * f**8 + 2583 * f**9)) / 1.0378368e7,
    26: lambda f: (f * (6006 + 28743 * f + 82940 * f**2 + 165035 * f**3 + 238900 * f**4 + 257134 * f**5 + 206752 * f**6 + 122990 * f**7 + 52710 * f**8 + 15435 * f**9 + 2772 * f**10 + 231 * f**11)) / 1.729728e7,
    27: lambda f: -(f * (408408 + 1947231 * f + 5566990 * f**2 + 10964915 * f**3 + 15691000 * f**4 + 16673022 * f**5 + 13213844 * f**6 + 7732830 * f**7 + 3252480 * f**8 + 931875 * f**9 + 163086 * f**10 + 13167 * f**11)) / 5.8810752e8,
    28: lambda f: -(f * (6006 + 33891 * f + 116688 * f**2 + 282022 * f**3 + 506750 * f**4 + 683157 * f**5 + 678896 * f**6 + 483220 * f**7 + 237330 * f**8 + 76005 * f**9 + 14256 * f**10 + 1188 * f**11)) / 1.7791488e8,
    29: lambda f: (f * (1429428 + 8044179 * f + 27509196 * f**2 + 65995462 * f**3 + 117612800 * f**4 + 157030581 * f**5 + 153987512 * f**6 + 107627380 * f**7 + 51668820 * f**8 + 16115085 * f**9 + 2935548 * f**10 + 237006 * f**11)) / 2.117187072e10,
    30: lambda f: (f * (3432 + 22308 * f + 89232 * f**2 + 253708 * f**3 + 544280 * f**4 + 864036 * f**5 + 975968 * f**6 + 760060 * f**7 + 395640 * f**8 + 131040 * f**9 + 24948 * f**10 + 2079 * f**11)) / 1.24540416e9,
    31: lambda f: -(f * (1633632 + 10596729 * f + 42168126 * f**2 + 119219555 * f**3 + 254186380 * f**4 + 400287321 * f**5 + 446018482 * f**6 + 340447835 * f**7 + 172819080 * f**8 + 55634355 * f**9 + 10274418 * f**10 + 829521 * f**11)) / 2.9640619008e11,
}

Q022 = {
    0: lambda f: 0,
    1: lambda f: (-21 - 22 * f - 11 * f**2) / 42.,
    2: lambda f: 0,
    3: lambda f: (21 + 44 * f + 58 * f**2 + 36 * f**3 + 9 * f**4) / 168.,
    4: lambda f: 0,
    5: lambda f: (-231 - 726 * f - 1551 * f**2 - 1868 * f**3 - 1317 * f**4 - 510 * f**5 - 85 * f**6) / 11088.,
    6: lambda f: 0,
    7: lambda f: (9009 + 37752 * f + 111540 * f**2 + 198744 * f**3 + 228766 * f**4 + 172520 * f**5 + 82980 * f**6 + 23240 * f**7 + 2905 * f**8) / 3.459456e6,
    8: lambda f: 0,
    9: lambda f: (-9009 - 47190 * f - 178035 * f**2 - 419640 * f**3 - 668810 * f**4 - 746356 * f**5 - 588390 * f**6 - 322840 * f**7 - 117845 * f**8 - 25830 * f**9 - 2583 * f**10) / 3.459456e7,
    10: lambda f: 0,
    11: lambda f: (3003 + 18876 * f + 86658 * f**2 + 254020 * f**3 + 516905 * f**4 + 762712 * f**5 + 783980 * f**6 + 529480 * f**7 + 221165 * f**8 + 51660 * f**9 + 5166 * f**10) / 1.3837824e8,
    12: lambda f: 0,
    13: lambda f: (-1287 - 9438 * f - 51051 * f**2 - 178932 * f**3 - 442883 * f**4 - 812218 * f**5 - 985095 * f**6 - 736120 * f**7 - 324485 * f**8 - 77490 * f**9 - 7749 * f**10) / 8.3026944e8,
    14: lambda f: 0,
    15: lambda f: (9009 + 75504 * f + 470184 * f**2 + 1917552 * f**3 + 5589388 * f**4 + 12249776 * f**5 + 16637880 * f**6 + 13198640 * f**7 + 5989270 * f**8 + 1446480 * f**9 + 144648 * f**10) / 9.299017728e10,
    16: lambda f: -0.041666666666666664 + (29 * f) / 630. + (2 * f**2) / 45.,
    17: lambda f: (-735 - 616 * f - 242 * f**2) / 1764.,
    18: lambda f: (35 - 2 * f - 91 * f**2 - 100 * f**3 - 32 * f**4) / 1680.,
    19: lambda f: (245 + 462 * f + 545 * f**2 + 300 * f**3 + 66 * f**4) / 1176.,
    20: lambda f: (-1155 - 1144 * f + 2794 * f**2 + 8380 * f**3 + 8897 * f**4 + 4460 * f**5 + 880 * f**6) / 221760.,
    21: lambda f: (-8085 - 23716 * f - 47168 * f**2 - 52700 * f**3 - 34341 * f**4 - 12240 * f**5 - 1870 * f**6) / 155232.,
    22: lambda f: (45045 + 91806 * f - 23595 * f**2 - 461760 * f**3 - 952577 * f**4 - 1006450 * f**5 - 611385 * f**6 - 203980 * f**7 - 29120 * f**8) / 5.189184e7,
    23: lambda f: (315315 + 1255254 * f + 3518229 * f**2 + 5935800 * f**3 + 6456811 * f**4 + 4591670 * f**5 + 2077815 * f**6 + 546140 * f**7 + 63910 * f**8) / 3.6324288e7,
    24: lambda f: (-15015 - 46332 * f - 46332 * f**2 + 133640 * f**3 + 553582 * f**4 + 966800 * f**5 + 1020100 * f**6 + 693560 * f**7 + 299425 * f**8 + 75180 * f**9 + 8400 * f**10) / 1.3837824e8,
    25: lambda f: (-105105 - 528528 * f - 1912482 * f**2 - 4318600 * f**3 - 6586006 * f**4 - 7023496 * f**5 - 5283944 * f**6 - 2762648 * f**7 - 959441 * f**8 - 199752 * f**9 - 18942 * f**10) / 9.6864768e7,
    26: lambda f: (765765 + 3165162 * f + 6439719 * f**2 - 198900 * f**3 - 34711790 * f**4 - 97981540 * f**5 - 155370642 * f**6 - 163957024 * f**7 - 120056615 * f**8 - 60772950 * f**9 - 20411685 * f**10 - 4110876 * f**11 - 376992 * f**12) / 7.05729024e10,
    27: lambda f: (5360355 + 32570538 * f + 144452451 * f**2 + 408739500 * f**3 + 802234420 * f**4 + 1140739100 * f**5 + 1200311862 * f**6 + 939355424 * f**7 + 541754395 * f**8 + 224309610 * f**9 + 63248535 * f**10 + 10902276 * f**11 + 869022 * f**12) / 4.940103168e10,
    28: lambda f: (-765765 - 3967392 * f - 11829246 * f**2 - 14254500 * f**3 + 24376793 * f**4 + 146125540 * f**5 + 350966652 * f**6 + 522521944 * f**7 + 501180365 * f**8 + 307125000 * f**9 + 116044110 * f**10 + 24665256 * f**11 + 2261952 * f**12) / 8.468748288e11,
    29: lambda f: (-5360355 - 38186148 * f - 200557500 * f**2 - 682160700 * f**3 - 1637570509 * f**4 - 2910901160 * f**5 - 3847513962 * f**6 - 3708394424 * f**7 - 2538283405 * f**8 - 1193047380 * f**9 - 365000580 * f**10 - 65413656 * f**11 - 5214132 * f**12) / 5.9281238016e11,
    30: lambda f: (255255 + 1589874 * f + 6177171 * f**2 + 12932920 * f**3 + 5992483 * f**4 - 51421090 * f**5 - 221113249 * f**6 - 443730868 * f**7 - 501406955 * f**8 - 335946450 * f**9 - 132885795 * f**10 - 28776132 * f**11 - 2638944 * f**12) / 3.9520825344e12,
    31: lambda f: (1786785 + 14600586 * f + 88617243 * f**2 + 352097200 * f**3 + 999436851 * f**4 + 2132033750 * f**5 + 3315874919 * f**6 + 3612890148 * f**7 + 2688572425 * f**8 + 1332462390 * f**9 + 420198765 * f**10 + 76315932 * f**11 + 6083154 * f**12) / 2.76645777408e12,
}

Q100 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: (-15 - 20 * f - 22 * f**2 - 12 * f**3 - 3 * f**4) / 120.,
    3: lambda f: 0,
    4: lambda f: (35 + 70 * f + 119 * f**2 + 124 * f**3 + 81 * f**4 + 30 * f**5 + 5 * f**6) / 840.,
    5: lambda f: 0,
    6: lambda f: (-315 - 840 * f - 1932 * f**2 - 2952 * f**3 - 3098 * f**4 - 2200 * f**5 - 1020 * f**6 - 280 * f**7 - 35 * f**8) / 40320.,
    7: lambda f: 0,
    8: lambda f: (693 + 2310 * f + 6699 * f**2 + 13464 * f**3 + 19426 * f**4 + 20276 * f**5 + 15270 * f**6 + 8120 * f**7 + 2905 * f**8 + 630 * f**9 + 63 * f**10) / 665280.,
    9: lambda f: 0,
    10: lambda f: (-15015 - 60060 * f - 210210 * f**2 - 523380 * f**3 - 960245 * f**4 - 1320280 * f**5 - 1387404 * f**6 - 1121512 * f**7 - 685265 * f**8 - 303660 * f**9 - 91350 * f**10 - 16632 * f**11 - 1386 * f**12) / 1.3837824e8,
    11: lambda f: 0,
    12: lambda f: (6435 + 30030 * f + 123123 * f**2 + 365508 * f**3 + 813527 * f**4 + 1386970 * f**5 + 1837335 * f**6 + 1848280 * f**7 + 1348025 * f**8 + 677250 * f**9 + 220185 * f**10 + 41580 * f**11 + 3465 * f**12) / 6.918912e8,
    13: lambda f: 0,
    14: lambda f: (-6435 - 34320 * f - 161304 * f**2 - 555984 * f**3 - 1454596 * f**4 - 2958800 * f**5 - 4633800 * f**6 - 5302160 * f**7 - 4211650 * f**8 - 2228400 * f**9 - 745560 * f**10 - 142560 * f**11 - 11880 * f**12) / 9.4887936e9,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (-15 - 20 * f - 22 * f**2 - 12 * f**3 - 3 * f**4) / 180.,
    19: lambda f: (105 + 140 * f + 133 * f**2 + 66 * f**3 + 12 * f**4) / 630.,
    20: lambda f: (35 + 70 * f + 119 * f**2 + 124 * f**3 + 81 * f**4 + 30 * f**5 + 5 * f**6) / 840.,
    21: lambda f: (-105 - 210 * f - 336 * f**2 - 336 * f**3 - 205 * f**4 - 70 * f**5 - 10 * f**6) / 1260.,
    22: lambda f: (-315 - 840 * f - 1932 * f**2 - 2952 * f**3 - 3098 * f**4 - 2200 * f**5 - 1020 * f**6 - 280 * f**7 - 35 * f**8) / 30240.,
    23: lambda f: (3465 + 9240 * f + 20559 * f**2 + 30690 * f**3 + 31207 * f**4 + 21380 * f**5 + 9465 * f**6 + 2450 * f**7 + 280 * f**8) / 166320.,
    24: lambda f: (693 + 2310 * f + 6699 * f**2 + 13464 * f**3 + 19426 * f**4 + 20276 * f**5 + 15270 * f**6 + 8120 * f**7 + 2905 * f**8 + 630 * f**9 + 63 * f**10) / 399168.,
    25: lambda f: (-45045 - 150150 * f - 426426 * f**2 - 844272 * f**3 - 1195766 * f**4 - 1222780 * f**5 - 899040 * f**6 - 464800 * f**7 - 160685 * f**8 - 33390 * f**9 - 3150 * f**10) / 1.297296e7,
    26: lambda f: (-3003 - 12012 * f - 42042 * f**2 - 104676 * f**3 - 192049 * f**4 - 264056 * f**5 - 274524 * f**6 - 215432 * f**7 - 125965 * f**8 - 53340 * f**9 - 15498 * f**10 - 2772 * f**11 - 231 * f**12) / 1.3837824e7,
    27: lambda f: (15015 + 60060 * f + 207207 * f**2 + 510510 * f**3 + 925210 * f**4 + 1255280 * f**5 + 1285670 * f**6 + 992068 * f**7 + 568995 * f**8 + 235620 * f**9 + 66675 * f**10 + 11550 * f**11 + 924 * f**12) / 3.459456e7,
    28: lambda f: (6435 + 30030 * f + 123123 * f**2 + 365508 * f**3 + 813527 * f**4 + 1386970 * f**5 + 1837335 * f**6 + 1903192 * f**7 + 1540217 * f**8 + 965538 * f**9 + 460425 * f**10 + 161700 * f**11 + 39501 * f**12 + 6006 * f**13 + 429 * f**14) / 2.965248e8,
    29: lambda f: (-765765 - 3573570 * f - 14498484 * f**2 - 42707808 * f**3 - 94227991 * f**4 - 159148730 * f**5 - 208671090 * f**6 - 213722096 * f**7 - 170806867 * f**8 - 105586614 * f**9 - 49560000 * f**10 - 17094000 * f**11 - 4089393 * f**12 - 606606 * f**13 - 42042 * f**14) / 1.76432256e10,
    30: lambda f: (-6435 - 34320 * f - 161304 * f**2 - 555984 * f**3 - 1454596 * f**4 - 2958800 * f**5 - 4728840 * f**6 - 5916752 * f**7 - 5721202 * f**8 - 4195728 * f**9 - 2276100 * f**10 - 881100 * f**11 - 229581 * f**12 - 36036 * f**13 - 2574 * f**14) / 3.5582976e9,
    31: lambda f: (109395 + 583440 * f + 2720289 * f**2 + 9320454 * f**3 + 24224915 * f**4 + 48933820 * f**5 + 77603385 * f**6 + 96187258 * f**7 + 91894961 * f**8 + 66374712 * f**9 + 35346375 * f**10 + 13389750 * f**11 + 3404214 * f**12 + 519948 * f**13 + 36036 * f**14) / 3.02455296e10,
}

Q102 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: -(f * (14 + 19 * f + 12 * f**2 + 3 * f**3)) / 210.,
    4: lambda f: 0,
    5: lambda f: (f * (42 + 93 * f + 112 * f**2 + 78 * f**3 + 30 * f**4 + 5 * f**5)) / 1260.,
    6: lambda f: 0,
    7: lambda f: -(f * (462 + 1419 * f + 2508 * f**2 + 2837 * f**3 + 2110 * f**4 + 1005 * f**5 + 280 * f**6 + 35 * f**7)) / 55440.,
    8: lambda f: 0,
    9: lambda f: (f * (6006 + 23595 * f + 54912 * f**2 + 85748 * f**3 + 94060 * f**4 + 73170 * f**5 + 39760 * f**6 + 14420 * f**7 + 3150 * f**8 + 315 * f**9)) / 4.32432e6,
    10: lambda f: 0,
    11: lambda f: -(f * (30030 + 143715 * f + 414700 * f**2 + 825175 * f**3 + 1194500 * f**4 + 1300454 * f**5 + 1078112 * f**6 + 670390 * f**7 + 300510 * f**8 + 91035 * f**9 + 16632 * f**10 + 1386 * f**11)) / 1.729728e8,
    12: lambda f: 0,
    13: lambda f: (f * (6006 + 33891 * f + 116688 * f**2 + 282022 * f**3 + 506750 * f**4 + 695829 * f**5 + 716912 * f**6 + 530740 * f**7 + 269010 * f**8 + 87885 * f**9 + 16632 * f**10 + 1386 * f**11)) / 3.459456e8,
    14: lambda f: 0,
    15: lambda f: -(f * (858 + 5577 * f + 22308 * f**2 + 63427 * f**3 + 136070 * f**4 + 220761 * f**5 + 258248 * f**6 + 207835 * f**7 + 110790 * f**8 + 37215 * f**9 + 7128 * f**10 + 594 * f**11)) / 5.930496e8,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (f * (70 + 123 * f + 100 * f**2 + 28 * f**3)) / 4200.,
    19: lambda f: -(f * (294 + 357 * f + 200 * f**2 + 44 * f**3)) / 2940.,
    20: lambda f: -(f * (70 + 239 * f + 400 * f**2 + 349 * f**3 + 160 * f**4 + 30 * f**5)) / 12600.,
    21: lambda f: (f * (686 + 1414 * f + 1580 * f**2 + 1017 * f**3 + 360 * f**4 + 55 * f**5)) / 8820.,
    22: lambda f: (f * (2310 + 15411 * f + 42900 * f**2 + 65446 * f**3 + 60890 * f**4 + 34515 * f**5 + 11060 * f**6 + 1540 * f**7)) / 3.3264e6,
    23: lambda f: -(f * (61446 + 179025 * f + 299640 * f**2 + 320318 * f**3 + 224650 * f**4 + 100665 * f**5 + 26320 * f**6 + 3080 * f**7)) / 2.32848e6,
    24: lambda f: -(f**2 * (12012 + 57200 * f + 133757 * f**2 + 194470 * f**3 + 187375 * f**4 + 120820 * f**5 + 50435 * f**6 + 12390 * f**7 + 1365 * f**8)) / 2.16216e7,
    25: lambda f: (f * (168168 + 633633 * f + 1412840 * f**2 + 2111122 * f**3 + 2213020 * f**4 + 1642840 * f**5 + 850640 * f**6 + 293510 * f**7 + 60900 * f**8 + 5775 * f**9)) / 3.027024e7,
    26: lambda f: (f * (-6006 + 7293 * f + 128700 * f**2 + 466336 * f**3 + 974660 * f**4 + 1365294 * f**5 + 1346744 * f**6 + 945700 * f**7 + 465570 * f**8 + 153405 * f**9 + 30492 * f**10 + 2772 * f**11)) / 4.1513472e8,
    27: lambda f: -(f * (1219218 + 5636631 * f + 15701400 * f**2 + 30135040 * f**3 + 42038900 * f**4 + 43564362 * f**5 + 33692624 * f**6 + 19258540 * f**7 + 7922250 * f**8 + 2224215 * f**9 + 382536 * f**10 + 30492 * f**11)) / 1.45297152e9,
    28: lambda f: -(f * (-510510 - 1042899 * f + 2917200 * f**2 + 22562111 * f**3 + 68062900 * f**4 + 130692600 * f**5 + 177848104 * f**6 + 178239110 * f**7 + 133005474 * f**8 + 73375365 * f**9 + 29170680 * f**10 + 7927227 * f**11 + 1321320 * f**12 + 102102 * f**13)) / 1.76432256e11,
    29: lambda f: (f * (12150138 + 66570504 * f + 222436500 * f**2 + 521414803 * f**3 + 908117900 * f**4 + 1207852227 * f**5 + 1242589376 * f**6 + 991225270 * f**7 + 609077322 * f**8 + 283426710 * f**9 + 96769596 * f**10 + 22904343 * f**11 + 3363360 * f**12 + 231231 * f**13)) / 1.235025792e11,
    30: lambda f: (f * (-72930 - 269841 * f - 243100 * f**2 + 1660594 * f**3 + 8554910 * f**4 + 22869505 * f**5 + 41588588 * f**6 + 53989120 * f**7 + 50143578 * f**8 + 32880105 * f**9 + 14817660 * f**10 + 4361544 * f**11 + 755040 * f**12 + 58344 * f**13)) / 2.01636864e11,
    31: lambda f: -(f * (1327326 + 8408829 * f + 32769880 * f**2 + 90734202 * f**3 + 189468910 * f**4 + 305134139 * f**5 + 379405152 * f**6 + 360586940 * f**7 + 257761434 * f**8 + 135510795 * f**9 + 50651832 * f**10 + 12717936 * f**11 + 1921920 * f**12 + 132132 * f**13)) / 1.411458048e11,
}

Q120 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: -(f * (14 + 19 * f + 12 * f**2 + 3 * f**3)) / 42.,
    3: lambda f: 0,
    4: lambda f: (f * (42 + 93 * f + 112 * f**2 + 78 * f**3 + 30 * f**4 + 5 * f**5)) / 252.,
    5: lambda f: 0,
    6: lambda f: -(f * (462 + 1419 * f + 2508 * f**2 + 2837 * f**3 + 2110 * f**4 + 1005 * f**5 + 280 * f**6 + 35 * f**7)) / 11088.,
    7: lambda f: 0,
    8: lambda f: (f * (6006 + 23595 * f + 54912 * f**2 + 85748 * f**3 + 94060 * f**4 + 73170 * f**5 + 39760 * f**6 + 14420 * f**7 + 3150 * f**8 + 315 * f**9)) / 864864.,
    9: lambda f: 0,
    10: lambda f: -(f * (30030 + 143715 * f + 414700 * f**2 + 825175 * f**3 + 1194500 * f**4 + 1300454 * f**5 + 1078112 * f**6 + 670390 * f**7 + 300510 * f**8 + 91035 * f**9 + 16632 * f**10 + 1386 * f**11)) / 3.459456e7,
    11: lambda f: 0,
    12: lambda f: (f * (6006 + 33891 * f + 116688 * f**2 + 282022 * f**3 + 506750 * f**4 + 695829 * f**5 + 716912 * f**6 + 530740 * f**7 + 269010 * f**8 + 87885 * f**9 + 16632 * f**10 + 1386 * f**11)) / 6.918912e7,
    13: lambda f: 0,
    14: lambda f: -(f * (858 + 5577 * f + 22308 * f**2 + 63427 * f**3 + 136070 * f**4 + 220761 * f**5 + 258248 * f**6 + 207835 * f**7 + 110790 * f**8 + 37215 * f**9 + 7128 * f**10 + 594 * f**11)) / 1.1860992e8,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: -(f * (14 + 19 * f + 12 * f**2 + 3 * f**3)) / 63.,
    19: lambda f: (f * (56 + 73 * f + 42 * f**2 + 9 * f**3)) / 126.,
    20: lambda f: (f * (42 + 93 * f + 112 * f**2 + 78 * f**3 + 30 * f**4 + 5 * f**5)) / 252.,
    21: lambda f: -(f * (924 + 2013 * f + 2332 * f**2 + 1550 * f**3 + 560 * f**4 + 85 * f**5)) / 2772.,
    22: lambda f: -(f * (462 + 1419 * f + 2508 * f**2 + 2837 * f**3 + 2110 * f**4 + 1005 * f**5 + 280 * f**6 + 35 * f**7)) / 8316.,
    23: lambda f: (f * (48048 + 146289 * f + 253110 * f**2 + 279487 * f**3 + 201860 * f**4 + 92775 * f**5 + 24710 * f**6 + 2905 * f**7)) / 432432.,
    24: lambda f: (5 * f * (6006 + 23595 * f + 54912 * f**2 + 85748 * f**3 + 94060 * f**4 + 73170 * f**5 + 39760 * f**6 + 14420 * f**7 + 3150 * f**8 + 315 * f**9)) / 2.594592e6,
    25: lambda f: -(f * (60060 + 234663 * f + 538824 * f**2 + 828932 * f**3 + 893680 * f**4 + 681498 * f**5 + 361816 * f**6 + 127652 * f**7 + 26964 * f**8 + 2583 * f**9)) / 2.594592e6,
    26: lambda f: -(f * (6006 + 28743 * f + 82940 * f**2 + 165035 * f**3 + 238900 * f**4 + 257134 * f**5 + 206752 * f**6 + 122990 * f**7 + 52710 * f**8 + 15435 * f**9 + 2772 * f**10 + 231 * f**11)) / 3.459456e6,
    27: lambda f: (f * (408408 + 1947231 * f + 5566990 * f**2 + 10964915 * f**3 + 15691000 * f**4 + 16673022 * f**5 + 13213844 * f**6 + 7732830 * f**7 + 3252480 * f**8 + 931875 * f**9 + 163086 * f**10 + 13167 * f**11)) / 1.17621504e8,
    28: lambda f: (f * (102102 + 576147 * f + 1983696 * f**2 + 4794374 * f**3 + 8614750 * f**4 + 11829093 * f**5 + 12571888 * f**6 + 10367924 * f**7 + 6591186 * f**8 + 3175725 * f**9 + 1123584 * f**10 + 275814 * f**11 + 42042 * f**12 + 3003 * f**13)) / 5.0409216e8,
    29: lambda f: -(f * (27159132 + 152839401 * f + 522674724 * f**2 + 1253913778 * f**3 + 2234643200 * f**4 + 3040883823 * f**5 + 3199917224 * f**6 + 2610171676 * f**7 + 1639270332 * f**8 + 779126775 * f**9 + 271444404 * f**10 + 65470482 * f**11 + 9777768 * f**12 + 681681 * f**13)) / 6.704425728e10,
    30: lambda f: -(f * (58344 + 379236 * f + 1516944 * f**2 + 4313036 * f**3 + 9252760 * f**4 + 15334884 * f**5 + 19683424 * f**6 + 19380572 * f**7 + 14395608 * f**8 + 7878600 * f**9 + 3067812 * f**10 + 802197 * f**11 + 126126 * f**12 + 9009 * f**13)) / 3.02455296e9,
    31: lambda f: (f * (31039008 + 201337851 * f + 801194394 * f**2 + 2265171545 * f**3 + 4829541220 * f**4 + 7949275803 * f**5 + 10119278134 * f**6 + 9860017601 * f**7 + 7228939032 * f**8 + 3894693705 * f**9 + 1489227894 * f**10 + 381565107 * f**11 + 58666608 * f**12 + 4090086 * f**13)) / 8.0453108736e11,
}

Q122 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (-21 - 44 * f - 58 * f**2 - 36 * f**3 - 9 * f**4) / 168.,
    4: lambda f: 0,
    5: lambda f: (231 + 726 * f + 1551 * f**2 + 1868 * f**3 + 1317 * f**4 + 510 * f**5 + 85 * f**6) / 5544.,
    6: lambda f: 0,
    7: lambda f: (-9009 - 37752 * f - 111540 * f**2 - 198744 * f**3 - 228766 * f**4 - 172520 * f**5 - 82980 * f**6 - 23240 * f**7 - 2905 * f**8) / 1.153152e6,
    8: lambda f: 0,
    9: lambda f: (9009 + 47190 * f + 178035 * f**2 + 419640 * f**3 + 668810 * f**4 + 746356 * f**5 + 588390 * f**6 + 322840 * f**7 + 117845 * f**8 + 25830 * f**9 + 2583 * f**10) / 8.64864e6,
    10: lambda f: 0,
    11: lambda f: (-255255 - 1604460 * f - 7365930 * f**2 - 21591700 * f**3 - 43936925 * f**4 - 64830520 * f**5 - 71694428 * f**6 - 60174184 * f**7 - 37759505 * f**8 - 17031420 * f**9 - 5179230 * f**10 - 948024 * f**11 - 79002 * f**12) / 2.35243008e9,
    12: lambda f: 0,
    13: lambda f: (21879 + 160446 * f + 867867 * f**2 + 3041844 * f**3 + 7529011 * f**4 + 13807706 * f**5 + 19274679 * f**6 + 20098232 * f**7 + 14996485 * f**8 + 7637490 * f**9 + 2501793 * f**10 + 474012 * f**11 + 39501 * f**12) / 2.35243008e9,
    14: lambda f: 0,
    15: lambda f: (-153153 - 1283568 * f - 7993128 * f**2 - 32598384 * f**3 - 95019596 * f**4 - 208246192 * f**5 - 343517496 * f**6 - 406397488 * f**7 - 329343350 * f**8 - 176274000 * f**9 - 59340456 * f**10 - 11376288 * f**11 - 948024 * f**12) / 2.2583328768e11,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (-35 + 2 * f + 91 * f**2 + 100 * f**3 + 32 * f**4) / 1680.,
    19: lambda f: (-245 - 462 * f - 545 * f**2 - 300 * f**3 - 66 * f**4) / 1176.,
    20: lambda f: (1155 + 1144 * f - 2794 * f**2 - 8380 * f**3 - 8897 * f**4 - 4460 * f**5 - 880 * f**6) / 110880.,
    21: lambda f: (8085 + 23716 * f + 47168 * f**2 + 52700 * f**3 + 34341 * f**4 + 12240 * f**5 + 1870 * f**6) / 77616.,
    22: lambda f: (-45045 - 91806 * f + 23595 * f**2 + 461760 * f**3 + 952577 * f**4 + 1006450 * f**5 + 611385 * f**6 + 203980 * f**7 + 29120 * f**8) / 1.729728e7,
    23: lambda f: (-315315 - 1255254 * f - 3518229 * f**2 - 5935800 * f**3 - 6456811 * f**4 - 4591670 * f**5 - 2077815 * f**6 - 546140 * f**7 - 63910 * f**8) / 1.2108096e7,
    24: lambda f: (15015 + 46332 * f + 46332 * f**2 - 133640 * f**3 - 553582 * f**4 - 966800 * f**5 - 1020100 * f**6 - 693560 * f**7 - 299425 * f**8 - 75180 * f**9 - 8400 * f**10) / 3.459456e7,
    25: lambda f: (105105 + 528528 * f + 1912482 * f**2 + 4318600 * f**3 + 6586006 * f**4 + 7023496 * f**5 + 5283944 * f**6 + 2762648 * f**7 + 959441 * f**8 + 199752 * f**9 + 18942 * f**10) / 2.4216192e7,
    26: lambda f: (-765765 - 3165162 * f - 6439719 * f**2 + 198900 * f**3 + 34711790 * f**4 + 97981540 * f**5 + 155370642 * f**6 + 163957024 * f**7 + 120056615 * f**8 + 60772950 * f**9 + 20411685 * f**10 + 4110876 * f**11 + 376992 * f**12) / 1.411458048e10,
    27: lambda f: (-5360355 - 32570538 * f - 144452451 * f**2 - 408739500 * f**3 - 802234420 * f**4 - 1140739100 * f**5 - 1200311862 * f**6 - 939355424 * f**7 - 541754395 * f**8 - 224309610 * f**9 - 63248535 * f**10 - 10902276 * f**11 - 869022 * f**12) / 9.880206336e9,
    28: lambda f: (14549535 + 75380448 * f + 224755674 * f**2 + 270835500 * f**3 - 463159067 * f**4 - 2776385260 * f**5 - 6428200308 * f**6 - 9561820744 * f**7 - 10093994855 * f**8 - 7790921208 * f**9 - 4399379670 * f**10 - 1778322084 * f**11 - 489097917 * f**12 - 82222140 * f**13 - 6390384 * f**14) / 2.6817702912e12,
    29: lambda f: (101846745 + 725536812 * f + 3810592500 * f**2 + 12961053300 * f**3 + 31113839671 * f**4 + 55307122040 * f**5 + 74783927838 * f**6 + 77946126440 * f**7 + 62820985255 * f**8 + 38912019804 * f**9 + 18218238360 * f**10 + 6248042724 * f**11 + 1483245225 * f**12 + 218137920 * f**13 + 14996982 * f**14) / 1.87723920384e12,
    30: lambda f: (-4849845 - 30207606 * f - 117366249 * f**2 - 245725480 * f**3 - 113857177 * f**4 + 977000710 * f**5 + 3720819571 * f**6 + 7698694108 * f**7 + 10669867985 * f**8 + 10294074966 * f**9 + 6913913265 * f**10 + 3166110948 * f**11 + 942381594 * f**12 + 164444280 * f**13 + 12780768 * f**14) / 1.07270811648e13,
    31: lambda f: (-33948915 - 277411134 * f - 1683727617 * f**2 - 6689846800 * f**3 - 18989300169 * f**4 - 40508641250 * f**5 - 66363948581 * f**6 - 83618177580 * f**7 - 80270077195 * f**8 - 57805024578 * f**9 - 30550231215 * f**10 - 11460369228 * f**11 - 2883933360 * f**12 - 436275840 * f**13 - 29993964 * f**14) / 7.50895681536e12,
}

# up to k^{2*12}
Q100kp2x12 = {
    0: lambda f: (715 + 4290*f + 22737*f**2 + 89232*f**3 + 268268*f**4 + 633880*f**5 + 1125780*f**6 + 1400560*f**7 + 1169210*f**8 + 636300*f**9 + 216090*f**10 + 41580*f**11 + 3465*f**12)/1.66053888e10,
    1: lambda f: 0,
    2: lambda f: (-3003 - 20020*f - 118118*f**2 - 519948*f**3 - 1765907*f**4 - 4752592*f**5 - 9306600*f**6 - 12273520*f**7 - 10583510*f**8 - 5862360*f**9 - 2009196*f**10 - 388080*f**11 - 32340*f**12)/1.2398690304e12,
    3: lambda f: 0,
    4: lambda f: (1365 + 10010*f + 65065*f**2 + 317460*f**3 + 1201915*f**4 + 3629210*f**5 + 7682559*f**6 + 10575152*f**7 + 9328690*f**8 + 5230260*f**9 + 1803690*f**10 + 349272*f**11 + 29106*f**12)/1.11588212736e13,
    5: lambda f: 0,
    6: lambda f: (-455 - 3640*f - 25844*f**2 - 138424*f**3 - 578006*f**4 - 1934920*f**5 - 4364660*f**6 - 6207880*f**7 - 5569025*f**8 - 3150000*f**9 - 1091160*f**10 - 211680*f**11 - 17640*f**12)/8.1155063808e13,
    7: lambda f: 0,
    8: lambda f: (715 + 4290*f + 22737*f**2 + 89232*f**3 + 268268*f**4 + 633880*f**5 + 1175060*f**6 + 1676528*f**7 + 1802458*f**8 + 1432172*f**9 + 822850*f**10 + 331100*f**11 + 88319*f**12 + 14014*f**13 + 1001*f**14)/5.5351296e9,
    9: lambda f: (-255255 - 1531530*f - 8066058*f**2 - 31505760*f**3 - 94235284*f**4 - 221468520*f**5 - 407960560*f**6 - 576889152*f**7 - 612418954*f**8 - 478585548*f**9 - 269451000*f**10 - 105913500*f**11 - 27526191*f**12 - 4246242*f**13 - 294294*f**14)/9.880206336e11,
    10: lambda f: (-1155 - 7700*f - 45430*f**2 - 199980*f**3 - 679195*f**4 - 1827920*f**5 - 3818280*f**6 - 5988976*f**7 - 6897926*f**8 - 5749464*f**9 - 3411380*f**10 - 1401400*f**11 - 378378*f**12 - 60368*f**13 - 4312*f**14)/1.430618112e11,
    11: lambda f: (255255 + 1701700*f + 9988979*f**2 + 43801758*f**3 + 148154864*f**4 + 397022080*f**5 + 824809740*f**6 + 1282240232*f**7 + 1457251474*f**8 + 1193361288*f**9 + 693087850*f**10 + 277854500*f**11 + 73036656*f**12 + 11323312*f**13 + 784784*f**14)/1.58083301376e13,
    12: lambda f: (1365 + 10010*f + 65065*f**2 + 317460*f**3 + 1201915*f**4 + 3629210*f**5 + 8359935*f**6 + 14074928*f**7 + 17005618*f**8 + 14628852*f**9 + 8859690*f**10 + 3686760*f**11 + 1002834*f**12 + 160524*f**13 + 11466*f**14)/3.0433148928e12,
    13: lambda f: (-255255 - 1871870*f - 12116104*f**2 - 58927440*f**3 - 222351415*f**4 - 669048770*f**5 - 1533629670*f**6 - 2558789408*f**7 - 3048748654*f**8 - 2574782028*f**9 - 1525242600*f**10 - 618987600*f**11 - 163837674*f**12 - 25477452*f**13 - 1765764*f**14)/2.845499424768e14,
    14: lambda f: (-455 - 3640*f - 25844*f**2 - 138424*f**3 - 578006*f**4 - 1934920*f**5 - 4835060*f**6 - 8597512*f**7 - 10757537*f**8 - 9462768*f**9 - 5812800*f**10 - 2440200*f**11 - 667086*f**12 - 107016*f**13 - 7644*f**14)/2.0288765952e13,
    15: lambda f: (23205 + 185640*f + 1313403*f**2 + 7015866*f**3 + 29213327*f**4 + 97509620*f**5 + 242564585*f**6 + 427358274*f**7 + 527065098*f**8 + 454912416*f**9 + 273183750*f**10 + 111793500*f**11 + 29728692*f**12 + 4632264*f**13 + 321048*f**14)/5.17363531776e14,
}

Q102kp2x12 = {
    0: lambda f: 0,
    1: lambda f: (f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 3016468*f**5 + 3830624*f**6 + 3235960*f**7 + 1772820*f**8 + 604170*f**9 + 116424*f**10 + 9702*f**11))/5.81188608e10,
    2: lambda f: 0,
    3: lambda f: -(f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1786692*f**5 + 2402176*f**6 + 2094260*f**7 + 1167180*f**8 + 401310*f**9 + 77616*f**10 + 6468*f**11))/3.099672576e11,
    4: lambda f: 0,
    5: lambda f: (f*(10010 + 90805*f + 514800*f**2 + 2120950*f**3 + 6761750*f**4 + 14783193*f**5 + 20724704*f**6 + 18471880*f**7 + 10416420*f**8 + 3602970*f**9 + 698544*f**10 + 58212*f**11))/2.7897053184e13,
    6: lambda f: 0,
    7: lambda f: -(f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1262063*f**5 + 1826664*f**6 + 1654905*f**7 + 941220*f**8 + 326970*f**9 + 63504*f**10 + 5292*f**11))/3.0433148928e13,
    8: lambda f: -(f*(-1021020 - 5061342*f - 11668800*f**2 - 1231412*f**3 + 88140920*f**4 + 376870620*f**5 + 919570064*f**6 + 1455428380*f**7 + 1540741104*f**8 + 1099121940*f**9 + 521870580*f**10 + 158225067*f**11 + 27747720*f**12 + 2144142*f**13))/2.9640619008e13,
    9: lambda f: (f*(15723708 + 113077965*f + 503508720*f**2 + 1607935004*f**3 + 3914743000*f**4 + 7321176072*f**5 + 10358140576*f**6 + 10900056860*f**7 + 8403004512*f**8 + 4659478110*f**9 + 1804552596*f**10 + 462848463*f**11 + 70630560*f**12 + 4855851*f**13))/2.07484333056e13,
    10: lambda f: (f*(-850850 - 5151289*f - 16773900*f**2 - 26901004*f**3 + 22431160*f**4 + 342408900*f**5 + 1158900176*f**6 + 2147918920*f**7 + 2478482916*f**8 + 1857774730*f**9 + 907611320*f**10 + 279456408*f**11 + 49329280*f**12 + 3811808*f**13))/3.16166602752e14,
    11: lambda f: -(f*(11673662 + 93950857*f + 470544360*f**2 + 1702439908*f**3 + 4734575480*f**4 + 9975068988*f**5 + 15470598304*f**6 + 17377608920*f**7 + 14007130788*f**8 + 8000421590*f**9 + 3157513744*f**10 + 818809992*f**11 + 125565440*f**12 + 8632624*f**13))/2.213166219264e14,
    12: lambda f: -(f*(-170170 - 1203345*f - 4862000*f**2 - 12008035*f**3 - 12882600*f**4 + 66651730*f**5 + 337058736*f**6 + 711109140*f**7 + 871972836*f**8 + 675146010*f**9 + 335818560*f**10 + 104383818*f**11 + 18498480*f**12 + 1429428*f**13))/9.48499808256e14,
    13: lambda f: (f*(2144142 + 19093074*f + 106234700*f**2 + 429457145*f**3 + 1343095200*f**4 + 3117373691*f**5 + 5174939840*f**6 + 6079969140*f**7 + 5045975508*f**8 + 2936736600*f**9 + 1172687208*f**10 + 306146610*f**11 + 47087040*f**12 + 3237234*f**13))/6.639498657792e14,
    14: lambda f: (f*(-108290 - 870961*f - 4132700*f**2 - 12956346*f**3 - 25332550*f**4 + 33732675*f**5 + 301634452*f**6 + 709469180*f**7 + 910068012*f**8 + 720939870*f**9 + 363048840*f**10 + 113573376*f**11 + 20180160*f**12 + 1559376*f**13))/1.034727063552e16,
    15: lambda f: -(f*(1277822 + 12473461*f + 76333400*f**2 + 340981342*f**3 + 1184489450*f**4 + 2978232601*f**5 + 5208117488*f**6 + 6322089760*f**7 + 5355880236*f**8 + 3157730730*f**9 + 1271018448*f**10 + 333318384*f**11 + 51367680*f**12 + 3531528*f**13))/7.243089444864e15,
}

Q120kp2x12 = {
    0: lambda f: (f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 3016468*f**5 + 3830624*f**6 + 3235960*f**7 + 1772820*f**8 + 604170*f**9 + 116424*f**10 + 9702*f**11))/1.162377216e10,
    1: lambda f: 0,
    2: lambda f: -(f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1786692*f**5 + 2402176*f**6 + 2094260*f**7 + 1167180*f**8 + 401310*f**9 + 77616*f**10 + 6468*f**11))/6.199345152e10,
    3: lambda f: 0,
    4: lambda f: (f*(10010 + 90805*f + 514800*f**2 + 2120950*f**3 + 6761750*f**4 + 14783193*f**5 + 20724704*f**6 + 18471880*f**7 + 10416420*f**8 + 3602970*f**9 + 698544*f**10 + 58212*f**11))/5.5794106368e12,
    5: lambda f: 0,
    6: lambda f: -(f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1262063*f**5 + 1826664*f**6 + 1654905*f**7 + 941220*f**8 + 326970*f**9 + 63504*f**10 + 5292*f**11))/6.0866297856e12,
    7: lambda f: 0,
    8: lambda f: (f*(102102 + 751179*f + 3422848*f**2 + 11189672*f**3 + 27898360*f**4 + 53625684*f**5 + 78436064*f**6 + 85781752*f**7 + 68963188*f**8 + 39937450*f**9 + 16152752*f**10 + 4321702*f**11 + 686686*f**12 + 49049*f**13))/6.586804224e10,
    9: lambda f: -(f*(11639628 + 85495839*f + 387987600*f**2 + 1262756872*f**3 + 3133203360*f**4 + 5988837316*f**5 + 8691860688*f**6 + 9403370872*f**7 + 7453921944*f**8 + 4243694490*f**9 + 1683206448*f**10 + 440781264*f**11 + 68444376*f**12 + 4771767*f**13))/3.75447840768e12,
    10: lambda f: -(f*(170170 + 1397825*f + 7147140*f**2 + 26406185*f**3 + 75014200*f**4 + 162424596*f**5 + 260965376*f**6 + 305492068*f**7 + 257443452*f**8 + 153877150*f**9 + 63511448*f**10 + 17195178*f**11 + 2746744*f**12 + 196196*f**13))/1.58083301376e12,
    11: lambda f: (f*(12932920 + 106096133*f + 540688434*f**2 + 1990506557*f**3 + 5632784080*f**4 + 12137651364*f**5 + 19352682104*f**6 + 22399575604*f**7 + 18597767328*f**8 + 10918961158*f**9 + 4416249068*f**10 + 1169579334*f**11 + 182518336*f**12 + 12724712*f**13))/6.007165452288e13,
    12: lambda f: (f*(34034 + 308737*f + 1750320*f**2 + 7211230*f**3 + 22989950*f**4 + 54869013*f**5 + 94556000*f**6 + 116034856*f**7 + 100867284*f**8 + 61515090*f**9 + 25712064*f**10 + 7011900*f**11 + 1123668*f**12 + 80262*f**13))/5.17363531776e12,
    13: lambda f: -(f*(14226212 + 128913499*f + 728862420*f**2 + 2994012970*f**3 + 9514934000*f**4 + 22611451239*f**5 + 38667873104*f**6 + 46897281592*f**7 + 40142229624*f**8 + 24033296070*f**9 + 9838953432*f**10 + 2623673052*f**11 + 410666256*f**12 + 28630602*f**13))/1.08128978141184e15,
    14: lambda f: -(f*(9282 + 92157*f + 573716*f**2 + 2607579*f**3 + 9218250*f**4 + 23854111*f**5 + 43387176*f**6 + 55108473*f**7 + 48966372*f**8 + 30280950*f**9 + 12766068*f**10 + 3498453*f**11 + 561834*f**12 + 40131*f**13))/2.58681765888e13,
    15: lambda f: (f*(1410864 + 13995267*f + 86927698*f**2 + 394113941*f**3 + 1389578300*f**4 + 3581753137*f**5 + 6464236506*f**6 + 8111891319*f**7 + 7094305008*f**8 + 4305120750*f**9 + 1777069476*f**10 + 476076258*f**11 + 74666592*f**12 + 5205564*f**13))/1.9659814207488e15,
}

Q122kp2x12 = {
    0: lambda f: 0,
    1: lambda f: (17017 + 160446*f + 1130415*f**2 + 5258032*f**3 + 17636548*f**4 + 44952488*f**5 + 83996108*f**6 + 107800784*f**7 + 91643230*f**8 + 50388660*f**9 + 17205174*f**10 + 3318084*f**11 + 276507*f**12)/3.9520825344e11,
    2: lambda f: 0,
    3: lambda f: (-51051 - 534820*f - 4205630*f**2 - 21971820*f**3 - 83346155*f**4 - 242180368*f**5 - 498279240*f**6 - 676666480*f**7 - 593409110*f**8 - 331826040*f**9 - 114291324*f**10 - 22120560*f**11 - 1843380*f**12)/2.10777735168e13,
    4: lambda f: 0,
    5: lambda f: (23205 + 267410*f + 2321605*f**2 + 13458900*f**3 + 56961475*f**4 + 185829890*f**5 + 412751163*f**6 + 584191664*f**7 + 523590130*f**8 + 296184420*f**9 + 102616290*f**10 + 19908504*f**11 + 1659042*f**12)/1.896999616512e14,
    6: lambda f: 0,
    7: lambda f: (-4641 - 58344*f - 554268*f**2 - 3530696*f**3 - 16492074*f**4 - 59682648*f**5 - 141073852*f**6 - 206066616*f**7 - 187684455*f**8 - 107064720*f**9 - 37251144*f**10 - 7239456*f**11 - 603288*f**12)/8.277816508416e14,
    8: lambda f: (14549535 + 105865188*f + 504383880*f**2 + 1438073520*f**3 + 2118630644*f**4 - 1015098560*f**5 - 15939216888*f**6 - 47767270544*f**7 - 81973506790*f**8 - 90430510968*f**9 - 66094090020*f**10 - 31877298684*f**11 - 9769656897*f**12 - 1726664940*f**13 - 134198064*f**14)/4.505374089216e14,
    9: lambda f: (101846745 + 938929992*f + 6466367622*f**2 + 29391320400*f**3 + 96301996508*f**4 + 239687524720*f**5 + 456111787488*f**6 + 653793691600*f**7 + 694591663430*f**8 + 539144401824*f**9 + 300389707800*f**10 + 116708870124*f**11 + 29992350465*f**12 + 4580896320*f**13 + 314936622*f**14)/3.1537618624512e14,
    10: lambda f: (-4849845 - 40369186*f - 227203691*f**2 - 805452180*f**3 - 1769015444*f**4 - 1658527480*f**5 + 6071725956*f**6 + 29545841248*f**7 + 60364064810*f**8 + 72761640756*f**9 + 55885847990*f**10 + 27727880488*f**11 + 8628428424*f**12 + 1534813280*f**13 + 119287168*f**14)/2.4028661809152e15,
    11: lambda f: (-33948915 - 348542194*f - 2685382271*f**2 - 13742067300*f**3 - 51046314698*f**4 - 145206528568*f**5 - 311310810348*f**6 - 489012007904*f**7 - 554324585458*f**8 - 449704606764*f**9 - 258008968546*f**10 - 102130103768*f**11 - 26531444940*f**12 - 4071907840*f**13 - 279943664*f**14)/1.68200632664064e15,
    12: lambda f: (1616615 + 15149992*f + 98197814*f**2 + 412761700*f**3 + 1157879095*f**4 + 1985849220*f**5 - 1528084424*f**6 - 16869940080*f**7 - 39903225810*f**8 - 51209757312*f**9 - 40632978540*f**10 - 20522537112*f**11 - 6446251350*f**12 - 1151109960*f**13 - 89465376*f**14)/1.44171970854912e16,
    13: lambda f: (11316305 + 128035908*f + 1091168936*f**2 + 6208221500*f**3 + 25780779565*f**4 + 82506086400*f**5 + 194856797974*f**6 + 327513226544*f**7 + 388187526930*f**8 + 324168423096*f**9 + 189472010280*f**10 + 75872576472*f**11 + 19840793742*f**12 + 3053930880*f**13 + 209957748*f**14)/1.009203795984384e16,
    14: lambda f: (-440895 - 4593706*f - 33663383*f**2 - 162921200*f**3 - 546951081*f**4 - 1256621810*f**5 - 113530073*f**6 + 7411328036*f**7 + 19878795370*f**8 + 26727901452*f**9 + 21699449730*f**10 + 11094702696*f**11 + 3507020748*f**12 + 627878160*f**13 + 48799296*f**14)/7.8639256829952e16,
    15: lambda f: (-3086265 - 38152114*f - 356348135*f**2 - 2231348600*f**3 - 10243634597*f**4 - 36426218410*f**5 - 93182919097*f**6 - 164941173460*f**7 - 201934317620*f**8 - 172098779076*f**9 - 101885649390*f**10 - 41121404856*f**11 - 10801236600*f**12 - 1665780480*f**13 - 114522408*f**14)/5.50474797809664e16,
}

Q000kp2x12 = {
    0: lambda f: (-55 - 165*f*(2 + f) - 396*f**2*(2 + f)**2 - 660*f**3*(2 + f)**3 - 770*f**4*(2 + f)**4 - 630*f**5*(2 + f)**5)/1.02187008e10,
    1: lambda f: 0,
    2: lambda f: (231 + 770*f*(2 + f) + 2079*f**2*(2 + f)**2 + 3960*f**3*(2 + f)**3 + 5390*f**4*(2 + f)**4 + 5292*f**5*(2 + f)**5)/8.583708672e11,
    3: lambda f: 0,
    4: lambda f: (-21 - 77*f*(2 + f) - 231*f**2*(2 + f)**2 - 495*f**3*(2 + f)**3 - 770*f**4*(2 + f)**4 - 882*f**5*(2 + f)**5)/1.7167417344e12,
    5: lambda f: 0,
    6: lambda f: (105 + 420*f*(2 + f) + 1386*f**2*(2 + f)**2 + 3300*f**3*(2 + f)**3 + 5775*f**4*(2 + f)**4 + 7560*f**5*(2 + f)**5)/2.06009008128e14,
    7: lambda f: 0,
    8: lambda f: (-715 - 4290*f - 22737*f**2 - 89232*f**3 - 268268*f**4 - 633880*f**5 - 1101140*f**6 - 1326640*f**7 - 1076810*f**8 - 574700*f**9 - 192990*f**10 - 36960*f**11 - 3080*f**12)/4.42810368e10,
    9: lambda f: (15015 + 90090*f + 474474*f**2 + 1853280*f**3 + 5543252*f**4 + 13027560*f**5 + 22445360*f**6 + 26587008*f**7 + 21023450*f**8 + 10857420*f**9 + 3513300*f**10 + 646800*f**11 + 51744*f**12)/4.649508864e11,
    10: lambda f: (3003 + 20020*f + 118118*f**2 + 519948*f**3 + 1765907*f**4 + 4752592*f**5 + 9099624*f**6 + 11652592*f**7 + 9807350*f**8 + 5344920*f**9 + 1815156*f**10 + 349272*f**11 + 29106*f**12)/3.34764638208e12,
    11: lambda f: (-15015 - 100100*f - 587587*f**2 - 2576574*f**3 - 8714992*f**4 - 23354240*f**5 - 44378700*f**6 - 55832168*f**7 - 45717490*f**8 - 24078600*f**9 - 7871850*f**10 - 1455300*f**11 - 116424*f**12)/8.3691159552e12,
    12: lambda f: (-273 - 2002*f - 13013*f**2 - 63492*f**3 - 240383*f**4 - 725842*f**5 - 1502643*f**6 - 2013424*f**7 - 1738730*f**8 - 961380*f**9 - 328986*f**10 - 63504*f**11 - 5292*f**12)/6.0866297856e12,
    13: lambda f: (15015 + 110110*f + 712712*f**2 + 3466320*f**3 + 13079495*f**4 + 39355810*f**5 + 80899590*f**6 + 106431136*f**7 + 89330990*f**8 + 47689740*f**9 + 15699600*f**10 + 2910600*f**11 + 232848*f**12)/1.67382319104e14,
    14: lambda f: (455 + 3640*f + 25844*f**2 + 138424*f**3 + 578006*f**4 + 1934920*f**5 + 4270580*f**6 + 5925640*f**7 + 5216225*f**8 + 2914800*f**9 + 1002960*f**10 + 194040*f**11 + 16170*f**12)/2.23176425472e14,
    15: lambda f: (-1365 - 10920*f - 77259*f**2 - 412698*f**3 - 1718431*f**4 - 5735860*f**5 - 12575065*f**6 - 17123106*f**7 - 14638890*f**8 - 7892640*f**9 - 2611350*f**10 - 485100*f**11 - 38808*f**12)/3.34764638208e14,
}

Q002kp2x12 = {
    0: lambda f: 0,
    1: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2395540*f**5 + 1967840*f**6 + 907480*f**7 + 220500*f**8 + 22050*f**9))/4.649508864e11,
    2: lambda f: 0,
    3: lambda f: (f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1372740*f**5 + 1160320*f**6 + 541940*f**7 + 132300*f**8 + 13230*f**9))/2.7897053184e12,
    4: lambda f: 0,
    5: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2211525*f**5 + 1909600*f**6 + 900200*f**7 + 220500*f**8 + 22050*f**9))/5.5794106368e13,
    6: lambda f: 0,
    7: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 923375*f**5 + 810600*f**6 + 384825*f**7 + 94500*f**8 + 9450*f**9))/3.34764638208e14,
    8: lambda f: (f*(-30030 - 148863*f - 343200*f**2 - 36218*f**3 + 2592380*f**4 + 13412910*f**5 + 30233000*f**6 + 36106630*f**7 + 24784200*f**8 + 9878400*f**9 + 2134440*f**10 + 194040*f**11))/6.974263296e12,
    9: lambda f: -(f*(924924 + 6651645*f + 29618160*f**2 + 94584412*f**3 + 230279000*f**4 + 398058696*f**5 + 464973152*f**6 + 361054540*f**7 + 183456000*f**8 + 58639770*f**9 + 10711008*f**10 + 853776*f**11))/9.7639686144e12,
    10: lambda f: -(f*(-50050 - 303017*f - 986700*f**2 - 1582412*f**3 + 1319480*f**4 + 28420740*f**5 + 79501520*f**6 + 102525640*f**7 + 72791460*f**8 + 29463210*f**9 + 6403320*f**10 + 582120*f**11))/1.67382319104e14,
    11: lambda f: (f*(686686 + 5526521*f + 27679080*f**2 + 100143524*f**3 + 278504440*f**4 + 528815484*f**5 + 653449888*f**6 + 524211800*f**7 + 271347300*f**8 + 87595830*f**9 + 16066512*f**10 + 1280664*f**11))/1.171676233728e14,
    12: lambda f: (f*(-2002 - 14157*f - 57200*f**2 - 141271*f**3 - 151560*f**4 + 1405066*f**5 + 4815216*f**6 + 6579300*f**7 + 4783380*f**8 + 1956570*f**9 + 426888*f**10 + 38808*f**11))/1.11588212736e14,
    13: lambda f: -(f*(126126 + 1123122*f + 6249100*f**2 + 25262185*f**3 + 79005600*f**4 + 161642443*f**5 + 208188736*f**6 + 170895060*f**7 + 89596500*f**8 + 29117760*f**9 + 5355504*f**10 + 426888*f**11))/3.90558744576e14,
    14: lambda f: -(f*(-6370 - 51233*f - 243100*f**2 - 762138*f**3 - 1490150*f**4 + 5371155*f**5 + 22378580*f**6 + 31987900*f**7 + 23669100*f**8 + 9755550*f**9 + 2134440*f**10 + 194040*f**11))/6.69529276416e15,
    15: lambda f: (f*(75166 + 733733*f + 4490200*f**2 + 20057726*f**3 + 69675850*f**4 + 151481993*f**5 + 201393136*f**6 + 168160160*f**7 + 88987500*f**8 + 29060010*f**9 + 5355504*f**10 + 426888*f**11))/4.686704934912e15,
}

Q020kp2x12 = {
    0: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2395540*f**5 + 1967840*f**6 + 907480*f**7 + 220500*f**8 + 22050*f**9))/9.299017728e10,
    1: lambda f: 0,
    2: lambda f: (f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1372740*f**5 + 1160320*f**6 + 541940*f**7 + 132300*f**8 + 13230*f**9))/5.5794106368e11,
    3: lambda f: 0,
    4: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2211525*f**5 + 1909600*f**6 + 900200*f**7 + 220500*f**8 + 22050*f**9))/1.11588212736e13,
    5: lambda f: 0,
    6: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 923375*f**5 + 810600*f**6 + 384825*f**7 + 94500*f**8 + 9450*f**9))/6.69529276416e13,
    7: lambda f: 0,
    8: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2947476*f**5 + 3623648*f**6 + 2977240*f**7 + 1600340*f**8 + 539490*f**9 + 103488*f**10 + 8624*f**11))/3.099672576e10,
    9: lambda f: (f*(612612 + 4499781*f + 20420400*f**2 + 66460888*f**3 + 164905440*f**4 + 294090412*f**5 + 356462064*f**6 + 286663720*f**7 + 150051720*f**8 + 49111230*f**9 + 9132816*f**10 + 737352*f**11))/1.58083301376e12,
    10: lambda f: (f*(10010 + 82225*f + 420420*f**2 + 1553305*f**3 + 4412600*f**4 + 8726484*f**5 + 11389952*f**6 + 9695140*f**7 + 5318460*f**8 + 1812510*f**9 + 349272*f**10 + 29106*f**11))/8.3691159552e11,
    11: lambda f: -(f*(680680 + 5584007*f + 28457286*f**2 + 104763503*f**3 + 296462320*f**4 + 582526284*f**5 + 749217448*f**6 + 623590268*f**7 + 332803296*f**8 + 110039202*f**9 + 20548836*f**10 + 1659042*f**11))/2.845499424768e13,
    12: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2888901*f**5 + 3941728*f**6 + 3440360*f**7 + 1913940*f**8 + 657090*f**9 + 127008*f**10 + 10584*f**11))/3.0433148928e12,
    13: lambda f: (f*(748748 + 6784921*f + 38361180*f**2 + 157579630*f**3 + 500786000*f**4 + 1063407069*f**5 + 1429125488*f**6 + 1218774760*f**7 + 659189160*f**8 + 219463650*f**9 + 41097672*f**10 + 3318084*f**11))/5.690998849536e14,
    14: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1233839*f**5 + 1741992*f**6 + 1549065*f**7 + 870660*f**8 + 300510*f**9 + 58212*f**10 + 4851*f**11))/1.67382319104e13,
    15: lambda f: -(f*(74256 + 736593*f + 4575142*f**2 + 20742839*f**3 + 73135700*f**4 + 165482539*f**5 + 230036478*f**6 + 199759245*f**7 + 109100880*f**8 + 36504090*f**9 + 6849612*f**10 + 553014*f**11))/1.1381997699072e15,
}

Q022kp2x12 = {
    0: lambda f: 0,
    1: lambda f: (-1001 - 9438*f - 66495*f**2 - 309296*f**3 - 1037444*f**4 - 2644264*f**5 - 3899980*f**6 - 3218320*f**7 - 1487150*f**8 - 361620*f**9 - 36162*f**10)/1.8598035456e11,
    2: lambda f: 0,
    3: lambda f: (3003 + 31460*f + 247390*f**2 + 1292460*f**3 + 4902715*f**4 + 14245904*f**5 + 22370760*f**6 + 18984560*f**7 + 8882230*f**8 + 2169720*f**9 + 216972*f**10)/1.11588212736e13,
    4: lambda f: 0,
    5: lambda f: (-273 - 3146*f - 27313*f**2 - 158340*f**3 - 670135*f**4 - 2186234*f**5 - 3606735*f**6 - 3125360*f**7 - 1475530*f**8 - 361620*f**9 - 36162*f**10)/2.23176425472e13,
    6: lambda f: 0,
    7: lambda f: (273 + 3432*f + 32604*f**2 + 207688*f**3 + 970122*f**4 + 3510744*f**5 + 6027260*f**6 + 5307960*f**7 + 2523255*f**8 + 619920*f**9 + 61992*f**10)/5.356234211328e14,
    8: lambda f: (-765765 - 5571852*f - 26546520*f**2 - 75688080*f**3 - 111506876*f**4 + 53426240*f**5 + 1104352872*f**6 + 2918699504*f**7 + 3682662130*f**8 + 2598107400*f**9 + 1053090360*f**10 + 230209056*f**11 + 21111552*f**12)/1.896999616512e14,
    9: lambda f: (-5360355 - 49417368*f - 340335138*f**2 - 1546911600*f**3 - 5068526132*f**4 - 12615132880*f**5 - 22147756512*f**6 - 26135495344*f**7 - 20427686930*f**8 - 10421994240*f**9 - 3339049140*f**10 - 610527456*f**11 - 48665232*f**12)/1.3278997315584e14,
    10: lambda f: (255255 + 2124694*f + 11958089*f**2 + 42392220*f**3 + 93106076*f**4 + 87290920*f**5 - 555517164*f**6 - 1914717728*f**7 - 2615515630*f**8 - 1908321660*f**9 - 785319570*f**10 - 172656792*f**11 - 15833664*f**12)/1.1381997699072e15,
    11: lambda f: (1786785 + 18344326*f + 141335909*f**2 + 723266700*f**3 + 2686648142*f**4 + 7642448872*f**5 + 14733111012*f**6 + 18382186144*f**7 + 14837405702*f**8 + 7709528484*f**9 + 2494143414*f**10 + 457895592*f**11 + 36498924*f**12)/7.9673983893504e14,
    12: lambda f: (-85085 - 797368*f - 5168306*f**2 - 21724300*f**3 - 60941005*f**4 - 104518380*f**5 + 257389976*f**6 + 1157646672*f**7 + 1679014470*f**8 + 1254321600*f**9 + 521547180*f**10 + 115104528*f**11 + 10555776*f**12)/7.587998466048e15,
    13: lambda f: (-595595 - 6738732*f - 57429944*f**2 - 326748500*f**3 - 1356883135*f**4 - 4342425600*f**5 - 9016869586*f**6 - 11721072272*f**7 - 9677743110*f**8 - 5092144680*f**9 - 1658254080*f**10 - 305263728*f**11 - 24332616*f**12)/5.3115989262336e15,
    14: lambda f: (23205 + 241774*f + 1771757*f**2 + 8574800*f**3 + 28786899*f**4 + 66137990*f**5 - 90550813*f**6 - 537209036*f**7 - 816531310*f**8 - 620770500*f**9 - 260059590*f**10 - 57552264*f**11 - 5277888*f**12)/4.5527990796288e16,
    15: lambda f: (162435 + 2008006*f + 18755165*f**2 + 117439400*f**3 + 539138663*f**4 + 1917169390*f**5 + 4228681603*f**6 + 5672132956*f**7 + 4762751420*f**8 + 2529093420*f**9 + 827516970*f**10 + 152631864*f**11 + 12166308*f**12)/3.18695935574016e16,
}

# up to k^{2*16}
Q100kp2x16 = {
    0: lambda f: (315 + 2730*f + 21021*f**2 + 122616*f**3 + 559754*f**4 + 2057380*f**5 + 4892430*f**6 + 7140280*f**7 + 6488825*f**8 + 3694950*f**9 + 1284255*f**10 + 249480*f**11 + 20790*f**12)/1.339058552832e15,
    1: lambda f: 0,
    2: lambda f: (-585 - 5460*f - 45318*f**2 - 285948*f**3 - 1416727*f**4 - 5671640*f**5 - 14101260*f**6 - 21013160*f**7 - 19292665*f**8 - 11043900*f**9 - 3848670*f**10 - 748440*f**11 - 62370*f**12)/6.4274810535936e16,
    3: lambda f: 0,
    4: lambda f: (3 + 30*f + 267*f**2 + 1812*f**3 + 9683*f**4 + 41938*f**5 + 108315*f**6 + 164200*f**7 + 152015*f**8 + 87390*f**9 + 30519*f**10 + 5940*f**11 + 495*f**12)/9.182115790848e15,
    5: lambda f: 0,
    6: lambda f: (-495 - 5280*f - 50160*f**2 - 364320*f**3 - 2088680*f**4 - 9730720*f**5 - 25972752*f**6 - 39943456*f**7 - 37234820*f**8 - 21480480*f**9 - 7514640*f**10 - 1463616*f**11 - 121968*f**12)/4.524946661729894e19,
    7: lambda f: 0,
    8: lambda f: (4095 + 35490*f + 273273*f**2 + 1594008*f**3 + 7276802*f**4 + 26745940*f**5 + 71584950*f**6 + 132917848*f**7 + 170796773*f**8 + 152749422*f**9 + 94810275*f**10 + 40055400*f**11 + 10989594*f**12 + 1765764*f**13 + 126126*f**14)/4.017175658496e15,
    9: lambda f: (-69615 - 603330*f - 4631718*f**2 - 26954928*f**3 - 122758870*f**4 - 450093020*f**5 - 1199589360*f**6 - 2206541792*f**7 - 2793656089*f**8 - 2450449638*f**9 - 1486311750*f**10 - 611919000*f**11 - 163272186*f**12 - 25477452*f**13 - 1765764*f**14)/3.4145993097216e16,
    10: lambda f: (-585 - 5460*f - 45318*f**2 - 285948*f**3 - 1416727*f**4 - 5671640*f**5 - 16097100*f**6 - 30954344*f**7 - 40614889*f**8 - 36790236*f**9 - 23017050*f**10 - 9771300*f**11 - 2688147*f**12 - 432432*f**13 - 30888*f**14)/1.3773173686272e16,
    11: lambda f: (69615 + 649740*f + 5378919*f**2 + 33872670*f**3 + 167478662*f**4 + 669064240*f**5 + 1891348770*f**6 + 3602423692*f**7 + 4655723429*f**8 + 4134873708*f**9 + 2527174125*f**10 + 1045217250*f**11 + 279592236*f**12 + 43675632*f**13 + 3027024*f**14)/8.19503834333184e17,
    12: lambda f: (15 + 150*f + 1335*f**2 + 9060*f**3 + 48415*f**4 + 209690*f**5 + 626055*f**6 + 1239176*f**7 + 1653451*f**8 + 1513014*f**9 + 952515*f**10 + 405900*f**11 + 111903*f**12 + 18018*f**13 + 1287*f**14)/9.182115790848e15,
    13: lambda f: (-2805 - 28050*f - 249084*f**2 - 1687488*f**3 - 9001619*f**4 - 38915890*f**5 - 115746370*f**6 - 226890704*f**7 - 298121013*f**8 - 267396426*f**9 - 164412600*f**10 - 68244000*f**11 - 18291207*f**12 - 2859714*f**13 - 198198*f**14)/8.58527826444288e17,
    14: lambda f: (-495 - 5280*f - 50160*f**2 - 364320*f**3 - 2088680*f**4 - 9730720*f**5 - 30363600*f**6 - 61572448*f**7 - 83298068*f**8 - 76853952*f**9 - 48628020*f**10 - 20785380*f**11 - 5740119*f**12 - 924924*f**13 - 66066*f**14)/8.484274990743552e18,
    15: lambda f: (58905 + 628320*f + 5957259*f**2 + 43202610*f**3 + 247299085*f**4 + 1150280180*f**5 + 3576238575*f**6 + 7181184710*f**7 + 9564668533*f**8 + 8648034696*f**9 + 5343218475*f**10 + 2224264350*f**11 + 597109590*f**12 + 93417324*f**13 + 6474468*f**14)/5.0481436194924134e20,
}

Q102kp2x16 = {
    0: lambda f: 0,
    1: lambda f: (f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1888914*f**5 + 2803472*f**6 + 2571940*f**7 + 1472310*f**8 + 513135*f**9 + 99792*f**10 + 8316*f**11))/6.69529276416e14,
    2: lambda f: 0,
    3: lambda f: -(f*(546 + 6357*f + 46644*f**2 + 251641*f**3 + 1064180*f**4 + 2725326*f**5 + 4127648*f**6 + 3824590*f**7 + 2200590*f**8 + 768915*f**9 + 149688*f**10 + 12474*f**11))/1.6068702633984e16,
    4: lambda f: 0,
    5: lambda f: (f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 460987*f**5 + 709936*f**6 + 663140*f**7 + 383130*f**8 + 134145*f**9 + 26136*f**10 + 2178*f**11))/5.0501636849664e16,
    6: lambda f: 0,
    7: lambda f: -(f*(2310 + 30855*f + 260700*f**2 + 1627925*f**3 + 8013250*f**4 + 22000083*f**5 + 34357624*f**6 + 32307905*f**7 + 18729270*f**8 + 6568695*f**9 + 1280664*f**10 + 106722*f**11))/4.949160411267072e19,
    8: lambda f: -(f*(-92820 - 834054*f - 4508400*f**2 - 16731689*f**3 - 43047910*f**4 + 12311145*f**5 + 353389484*f**6 + 912133285*f**7 + 1211355054*f**8 + 976037265*f**9 + 495952380*f**10 + 155868867*f**11 + 27747720*f**12 + 2144142*f**13))/1.7072996548608e17,
    9: lambda f: (f*(2079168 + 22077237*f + 147371640*f**2 + 720859126*f**3 + 2753740580*f**4 + 7404509664*f**5 + 13490229872*f**6 + 16785838090*f**7 + 14438563524*f**8 + 8593648245*f**9 + 3479042952*f**10 + 915329646*f**11 + 141261120*f**12 + 9711702*f**13))/2.39021951680512e17,
    10: lambda f: (f*(-139230 - 1379703*f - 8331700*f**2 - 35326408*f**3 - 108913220*f**4 - 24821870*f**5 + 707208712*f**6 + 1978492460*f**7 + 2700861702*f**8 + 2204857095*f**9 + 1128051540*f**10 + 355766796*f**11 + 63423360*f**12 + 4900896*f**13))/5.46335889555456e18,
    11: lambda f: -(f*(1494402 + 17148495*f + 123998680*f**2 + 659158136*f**3 + 2746300700*f**4 + 7817965406*f**5 + 14721932848*f**6 + 18676395220*f**7 + 16254031206*f**8 + 9744214305*f**9 + 3962113848*f**10 + 1044980244*f**11 + 161441280*f**12 + 11099088*f**13))/3.824351226888192e18,
    12: lambda f: -(f*(-28050 - 303501*f - 2019600*f**2 - 9574111*f**3 - 33884060*f**4 - 18477300*f**5 + 186176968*f**6 + 558985790*f**7 + 780328098*f**8 + 643679685*f**9 + 331099560*f**10 + 104708439*f**11 + 18687240*f**12 + 1444014*f**13))/2.575583479332864e19,
    13: lambda f: (f*(290598 + 3583668*f + 27904140*f**2 + 160176397*f**3 + 722820620*f**4 + 2161101489*f**5 + 4181566592*f**6 + 5387824750*f**7 + 4732758954*f**8 + 2853420570*f**9 + 1164215052*f**10 + 307641411*f**11 + 47567520*f**12 + 3270267*f**13))/1.8029084355330048e19,
    14: lambda f: (f*(-431970 - 5063025*f - 36745500*f**2 - 191924390*f**3 - 760808650*f**4 - 583314795*f**5 + 3679713212*f**6 + 11761907080*f**7 + 16726010742*f**8 + 13914150495*f**9 + 7188438180*f**10 + 2278301256*f**11 + 406966560*f**12 + 31447416*f**13))/1.0096287238984827e22,
    15: lambda f: -(f*(4343262 + 57283149*f + 477859800*f**2 + 2945819330*f**3 + 14313492550*f**4 + 44656939719*f**5 + 88390665664*f**6 + 115348243220*f**7 + 102090655926*f**8 + 61834152765*f**9 + 25298378952*f**10 + 6695311392*f**11 + 1035914880*f**12 + 71219148*f**13))/7.067401067289379e21,
}

Q120kp2x16 = {
    0: lambda f: (f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1888914*f**5 + 2803472*f**6 + 2571940*f**7 + 1472310*f**8 + 513135*f**9 + 99792*f**10 + 8316*f**11))/1.339058552832e14,
    1: lambda f: 0,
    2: lambda f: -(f*(546 + 6357*f + 46644*f**2 + 251641*f**3 + 1064180*f**4 + 2725326*f**5 + 4127648*f**6 + 3824590*f**7 + 2200590*f**8 + 768915*f**9 + 149688*f**10 + 12474*f**11))/3.2137405267968e15,
    3: lambda f: 0,
    4: lambda f: (f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 460987*f**5 + 709936*f**6 + 663140*f**7 + 383130*f**8 + 134145*f**9 + 26136*f**10 + 2178*f**11))/1.01003273699328e16,
    5: lambda f: 0,
    6: lambda f: -(f*(2310 + 30855*f + 260700*f**2 + 1627925*f**3 + 8013250*f**4 + 22000083*f**5 + 34357624*f**6 + 32307905*f**7 + 18729270*f**8 + 6568695*f**9 + 1280664*f**10 + 106722*f**11))/9.898320822534144e18,
    7: lambda f: 0,
    8: lambda f: (f*(120666 + 1301469*f + 8825856*f**2 + 43864964*f**3 + 170289340*f**4 + 471736842*f**5 + 895436752*f**6 + 1167505556*f**7 + 1054394334*f**8 + 658710675*f**9 + 279439776*f**10 + 76848156*f**11 + 12360348*f**12 + 882882*f**13))/6.8291986194432e15,
    9: lambda f: -(f*(4585308 + 49418031*f + 334475544*f**2 + 1658856940*f**3 + 6425451920*f**4 + 17735271726*f**5 + 33400680488*f**6 + 43013599132*f**7 + 38222361324*f**8 + 23425094385*f**9 + 9727402608*f**10 + 2614666824*f**11 + 410666256*f**12 + 28630602*f**13))/1.297547737694208e17,
    10: lambda f: -(f*(9282 + 108069*f + 792948*f**2 + 4277897*f**3 + 18091060*f**4 + 53116398*f**5 + 104365408*f**6 + 138897374*f**7 + 127023246*f**8 + 79973775*f**9 + 34087284*f**10 + 9399159*f**11 + 1513512*f**12 + 108108*f**13))/1.17071976333312e16,
    11: lambda f: (f*(54318264 + 632004087*f + 4629523470*f**2 + 24930592531*f**3 + 105227443880*f**4 + 307902689946*f**5 + 600183747548*f**6 + 788767991242*f**7 + 709570772064*f**8 + 438157777365*f**9 + 182773667538*f**10 + 49252073409*f**11 + 7743992256*f**12 + 539891352*f**13))/3.425526027512709e19,
    12: lambda f: (f*(5610 + 70125*f + 553520*f**2 + 3221330*f**3 + 14739850*f**4 + 45502999*f**5 + 91986544*f**6 + 124459892*f**7 + 114958338*f**8 + 72821925*f**9 + 31154112*f**10 + 8608182*f**11 + 1387386*f**12 + 99099*f**13))/1.717055652888576e17,
    13: lambda f: -(f*(1492260 + 18642591*f + 146937868*f**2 + 853785254*f**3 + 3900134560*f**4 + 12001263645*f**5 + 24066787304*f**6 + 32149152252*f**7 + 29204462364*f**8 + 18140966151*f**9 + 7594266372*f**10 + 2050449786*f**11 + 322666344*f**12 + 22495473*f**13))/2.283684018341806e19,
    14: lambda f: -(f*(62832 + 839256*f + 7091040*f**2 + 44279560*f**3 + 217960400*f**4 + 702904440*f**5 + 1455216896*f**6 + 1995798616*f**7 + 1858402224*f**8 + 1183064820*f**9 + 507640980*f**10 + 140499513*f**11 + 22660638*f**12 + 1618617*f**13))/5.0481436194924134e19,
    15: lambda f: (f*(4775232 + 63751479*f + 537959730*f**2 + 3354592405*f**3 + 16488342500*f**4 + 53010806835*f**5 + 108860640182*f**6 + 147379977409*f**7 + 134945227368*f**8 + 84226758315*f**9 + 35360378130*f**10 + 9562344561*f**11 + 1505776272*f**12 + 104978874*f**13))/1.918294575407117e21,
}

Q122kp2x16 = {
    0: lambda f: 0,
    1: lambda f: (1071 + 14586*f + 150501*f**2 + 1044888*f**3 + 5339122*f**4 + 21224228*f**5 + 52823214*f**6 + 79096472*f**7 + 72936325*f**8 + 41872950*f**9 + 14615559*f**10 + 2844072*f**11 + 237006*f**12)/4.5527990796288e15,
    2: lambda f: 0,
    3: lambda f: (-21879 - 320892*f - 3573570*f**2 - 26856804*f**3 - 149011681*f**4 - 645441992*f**5 - 1677660132*f**6 - 2562850136*f**7 - 2386491415*f**8 - 1376977140*f**9 - 481830426*f**10 - 93854376*f**11 - 7821198*f**12)/2.4038779140440064e18,
    4: lambda f: 0,
    5: lambda f: (3927 + 61710*f + 737715*f**2 + 5966660*f**3 + 35722015*f**4 + 167452754*f**5 + 451676155*f**6 + 701450120*f**7 + 658387555*f**8 + 381420270*f**9 + 133734447*f**10 + 26070660*f**11 + 2172555*f**12)/1.2019389570220032e19,
    6: lambda f: 0,
    7: lambda f: (-58905 - 987360*f - 12611280*f**2 - 109221600*f**3 - 701797400*f**4 - 3539707360*f**5 - 9858019248*f**6 - 15521918944*f**7 - 14665044380*f**8 - 8524141920*f**9 - 2993684400*f**10 - 583982784*f**11 - 48665232*f**12)/5.384686527458574e21,
    8: lambda f: (1322685 + 15166788*f + 123904092*f**2 + 676710840*f**3 + 2623335586*f**4 + 7331815760*f**5 + 3909863244*f**6 - 34114284568*f**7 - 102115537685*f**8 - 142322769036*f**9 - 117529957440*f**10 - 60630331608*f**11 - 19252799874*f**12 - 3453329880*f**13 - 268396128*f**14)/5.190190950776832e18,
    9: lambda f: (9258795 + 124156032*f + 1261186446*f**2 + 8618867400*f**3 + 43343355142*f**4 + 169545167720*f**5 + 463753564536*f**6 + 855005721080*f**7 + 1072756303045*f**8 + 928137267288*f**9 + 554637782790*f**10 + 225132010488*f**11 + 59324244210*f**12 + 9161792640*f**13 + 629873244*f**14)/3.6331336655437824e18,
    10: lambda f: (-4849845 - 60692346*f - 546646815*f**2 - 3319981340*f**3 - 14527372678*f**4 - 47177192660*f**5 - 38517739018*f**6 + 184489767616*f**7 + 608550315065*f**8 + 872724953562*f**9 + 730215117555*f**10 + 379263856356*f**11 + 120848760648*f**12 + 21706644960*f**13 + 1687061376*f**14)/4.567368036683612e20,
    11: lambda f: (-33948915 - 490804314*f - 5387069259*f**2 - 39897638300*f**3 - 218120850896*f**4 - 930801315860*f**5 - 2695002118402*f**6 - 5134414922560*f**7 - 6566772343285*f**8 - 5747741396166*f**9 - 3459314345025*f**10 - 1410232832316*f**11 - 372506051610*f**12 - 57588410880*f**13 - 3959203248*f**14)/3.1971576256785285e20,
    12: lambda f: (1119195 + 15178416*f + 149375226*f**2 + 997507980*f**3 + 4849232269*f**4 + 17814554660*f**5 + 18158558628*f**6 - 60773179096*f**7 - 218653159445*f**8 - 320936078232*f**9 - 271343463930*f**10 - 141686962956*f**11 - 45269040663*f**12 - 8139991860*f**13 - 632648016*f**14)/2.7404208220101673e21,
    13: lambda f: (7834365 + 121469964*f + 1432612236*f**2 + 11430033300*f**3 + 67495921423*f**4 + 312037191368*f**5 + 948710896854*f**6 + 1856833536824*f**7 + 2411668965013*f**8 + 2130360893892*f**9 + 1289384845056*f**10 + 527413202316*f**11 + 139576253355*f**12 + 21595654080*f**13 + 1484701218*f**14)/1.918294575407117e21,
    14: lambda f: (-1119195 - 16350906*f - 174519807*f**2 - 1269971400*f**3 - 6778447315*f**4 - 27676426190*f**5 - 32518497207*f**6 + 84395607268*f**7 + 328406064665*f**8 + 491394702582*f**9 + 418999708785*f**10 + 219733696644*f**11 + 70357225554*f**12 + 12662209560*f**13 + 984119136*f**14)/7.673178301628468e22,
    15: lambda f: (-7834365 - 129677394*f - 1635484983*f**2 - 13984608000*f**3 - 88708133755*f**4 - 441654582950*f**5 - 1400994502383*f**6 - 2804492333972*f**7 - 3688728920695*f**8 - 3282851621826*f**9 - 1995942292575*f**10 - 818648311404*f**11 - 216977351976*f**12 - 33593239680*f**13 - 2309535228*f**14)/5.371224811139928e22,
}

Q000kp2x16 = {
    0: lambda f: (-315 - 1365*f*(2 + f) - 4914*f**2*(2 + f)**2 - 12870*f**3*(2 + f)**3 - 25025*f**4*(2 + f)**4 - 36855*f**5*(2 + f)**5)/1.6068702633984e16,
    1: lambda f: 0,
    2: lambda f: (45 + 210*f*(2 + f) + 819*f**2*(2 + f)**2 + 2340*f**3*(2 + f)**3 + 5005*f**4*(2 + f)**4 + 8190*f**5*(2 + f)**5)/6.4274810535936e16,
    3: lambda f: 0,
    4: lambda f: (-3 - 30*f - 267*f**2 - 1812*f**3 - 9683*f**4 - 41938*f**5 - 76635*f**6 - 69160*f**7 - 33215*f**8 - 8190*f**9 - 819*f**10)/1.28549621071872e17,
    5: lambda f: 0,
    6: lambda f: (99 + 528*f*(2 + f) + 2376*f**2*(2 + f)**2 + 7920*f**3*(2 + f)**3 + 20020*f**4*(2 + f)**4 + 39312*f**5*(2 + f)**5)/1.3574839985189683e20,
    7: lambda f: 0,
    8: lambda f: (-4095 - 35490*f - 273273*f**2 - 1594008*f**3 - 7276802*f**4 - 26745940*f**5 - 62271030*f**6 - 88831960*f**7 - 79365125*f**8 - 44707950*f**9 - 15447915*f**10 - 2993760*f**11 - 249480*f**12)/4.8206107901952e16,
    9: lambda f: (4095 + 35490*f + 272454*f**2 + 1585584*f**3 + 7221110*f**4 + 26476060*f**5 + 61250160*f**6 + 85710688*f**7 + 74325545*f**8 + 40376070*f**9 + 13409550*f**10 + 2494800*f**11 + 199584*f**12)/2.4103053950976e16,
    10: lambda f: (45 + 420*f + 3486*f**2 + 21996*f**3 + 108979*f**4 + 436280*f**5 + 1062780*f**6 + 1550600*f**7 + 1401805*f**8 + 794700*f**9 + 275490*f**10 + 53460*f**11 + 4455*f**12)/1.3773173686272e16,
    11: lambda f: (-315 - 2940*f - 24339*f**2 - 153270*f**3 - 757822*f**4 - 3027440*f**5 - 7329930*f**6 - 10487036*f**7 - 9197545*f**8 - 5026140*f**9 - 1674225*f**10 - 311850*f**11 - 24948*f**12)/4.8206107901952e16,
    12: lambda f: (-3 - 30*f - 267*f**2 - 1812*f**3 - 9683*f**4 - 41938*f**5 - 106203*f**6 - 157864*f**7 - 144095*f**8 - 82110*f**9 - 28539*f**10 - 5544*f**11 - 462*f**12)/2.57099242143744e16,
    13: lambda f: (165 + 1650*f + 14652*f**2 + 99264*f**3 + 529507*f**4 + 2289170*f**5 + 5763170*f**6 + 8398096*f**7 + 7433685*f**8 + 4081770*f**9 + 1362900*f**10 + 254100*f**11 + 20328*f**12)/7.07022915895296e17,
    14: lambda f: (99 + 1056*f + 10032*f**2 + 72864*f**3 + 417736*f**4 + 1946144*f**5 + 5096976*f**6 + 7695968*f**7 + 7081060*f**8 + 4052160*f**9 + 1411452*f**10 + 274428*f**11 + 22869*f**12)/2.5452824972230656e19,
    15: lambda f: (-3465 - 36960*f - 350427*f**2 - 2541330*f**3 - 14547005*f**4 - 67663540*f**5 - 176215935*f**6 - 260774374*f**7 - 232601285*f**8 - 128225160*f**9 - 42898275*f**10 - 8004150*f**11 - 640332*f**12)/4.454244370140365e20,
}

Q002kp2x16 = {
    0: lambda f: 0,
    1: lambda f: -(f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1356690*f**5 + 1206800*f**6 + 576100*f**7 + 141750*f**8 + 14175*f**9))/8.034351316992e15,
    2: lambda f: 0,
    3: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 148230*f**5 + 133280*f**6 + 63910*f**7 + 15750*f**8 + 1575*f**9))/1.6068702633984e16,
    4: lambda f: 0,
    5: lambda f: -(f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 321595*f**5 + 291760*f**6 + 140420*f**7 + 34650*f**8 + 3465*f**9))/7.07022915895296e17,
    6: lambda f: 0,
    7: lambda f: (f*(462 + 6171*f + 52140*f**2 + 325585*f**3 + 1602650*f**4 + 3033975*f**5 + 2773400*f**6 + 1338925*f**7 + 330750*f**8 + 33075*f**9))/1.4847481233801216e20,
    8: lambda f: (f*(-5460 - 49062*f - 265200*f**2 - 984217*f**3 - 2532230*f**4 + 5381145*f**5 + 27161260*f**6 + 40254725*f**7 + 30192750*f**8 + 12516525*f**9 + 2744280*f**10 + 249480*f**11))/1.2051526975488e17,
    9: lambda f: -(f*(122304 + 1298661*f + 8668920*f**2 + 42403478*f**3 + 161984740*f**4 + 370361952*f**5 + 504884464*f**6 + 427151690*f**7 + 227650500*f**8 + 74614365*f**9 + 13771296*f**10 + 1097712*f**11))/1.68721377656832e17,
    10: lambda f: -(f*(-630 - 6243*f - 37700*f**2 - 159848*f**3 - 492820*f**4 + 706490*f**5 + 4320680*f**6 + 6596380*f**7 + 5001150*f**8 + 2082675*f**9 + 457380*f**10 + 41580*f**11))/3.2137405267968e17,
    11: lambda f: (f*(6762 + 77595*f + 561080*f**2 + 2982616*f**3 + 12426700*f**4 + 29643766*f**5 + 41238512*f**6 + 35255780*f**7 + 18894750*f**8 + 6210645*f**9 + 1147608*f**10 + 91476*f**11))/2.24961836875776e17,
    12: lambda f: (f*(-1650 - 17853*f - 118800*f**2 - 563183*f**3 - 1993180*f**4 + 2049420*f**5 + 15244040*f**6 + 23856910*f**7 + 18246690*f**8 + 7626465*f**9 + 1677060*f**10 + 152460*f**11))/2.121068747685888e19,
    13: lambda f: -(f*(17094 + 210804*f + 1641420*f**2 + 9422141*f**3 + 42518860*f**4 + 105169377*f**5 + 148773184*f**6 + 128275070*f**7 + 69057450*f**8 + 22751190*f**9 + 4207896*f**10 + 335412*f**11))/1.4847481233801216e19,
    14: lambda f: -(f*(-5082 - 59565*f - 432300*f**2 - 2257934*f**3 - 8950690*f**4 + 6797889*f**5 + 61986764*f**6 + 99068200*f**7 + 76323870*f**8 + 31996755*f**9 + 7043652*f**10 + 640332*f**11))/1.781697748056146e21,
    15: lambda f: (f*(255486 + 3369597*f + 28109400*f**2 + 173283490*f**3 + 841970150*f**4 + 2148764247*f**5 + 3082622144*f**6 + 2676686740*f**7 + 1446369750*f**8 + 477411165*f**9 + 88365816*f**10 + 7043652*f**11))/6.235942118196511e21,
}

Q020kp2x16 = {
    0: lambda f: -(f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1356690*f**5 + 1206800*f**6 + 576100*f**7 + 141750*f**8 + 14175*f**9))/1.6068702633984e15,
    1: lambda f: 0,
    2: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 148230*f**5 + 133280*f**6 + 63910*f**7 + 15750*f**8 + 1575*f**9))/3.2137405267968e15,
    3: lambda f: 0,
    4: lambda f: -(f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 321595*f**5 + 291760*f**6 + 140420*f**7 + 34650*f**8 + 3465*f**9))/1.414045831790592e17,
    5: lambda f: 0,
    6: lambda f: (f*(462 + 6171*f + 52140*f**2 + 325585*f**3 + 1602650*f**4 + 3033975*f**5 + 2773400*f**6 + 1338925*f**7 + 330750*f**8 + 33075*f**9))/2.969496246760243e19,
    7: lambda f: 0,
    8: lambda f: -(f*(7098 + 76557*f + 519168*f**2 + 2580292*f**3 + 10017020*f**4 + 24023658*f**5 + 34848464*f**6 + 31439380*f**7 + 17809470*f**8 + 6171795*f**9 + 1197504*f**10 + 99792*f**11))/4.8206107901952e15,
    9: lambda f: (f*(241332 + 2600949*f + 17603976*f**2 + 87308260*f**3 + 338181680*f**4 + 806766042*f**5 + 1151904824*f**6 + 1014370420*f**7 + 558143460*f**8 + 187453035*f**9 + 35226576*f**10 + 2844072*f**11))/8.19503834333184e16,
    10: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 205254*f**5 + 304352*f**6 + 277750*f**7 + 158310*f**8 + 55035*f**9 + 10692*f**10 + 891*f**11))/6.886586843136e14,
    11: lambda f: -(f*(219912 + 2558721*f + 18743010*f**2 + 100933573*f**3 + 426022040*f**4 + 1062829494*f**5 + 1550823428*f**6 + 1380926470*f**7 + 764295840*f**8 + 257446035*f**9 + 48436542*f**10 + 3910599*f**11))/1.8029084355330048e18,
    12: lambda f: -(f*(330 + 4125*f + 32560*f**2 + 189490*f**3 + 867050*f**4 + 2258471*f**5 + 3410288*f**6 + 3141460*f**7 + 1799490*f**8 + 627165*f**9 + 121968*f**10 + 10164*f**11))/1.414045831790592e17,
    13: lambda f: (f*(78540 + 981189*f + 7733572*f**2 + 44936066*f**3 + 205270240*f**4 + 532119567*f**5 + 790509944*f**6 + 710308116*f**7 + 394994292*f**8 + 133365309*f**9 + 25115244*f**10 + 2027718*f**11))/1.6827145398308045e19,
    14: lambda f: (f*(3696 + 49368*f + 417120*f**2 + 2604680*f**3 + 12821200*f**4 + 34517112*f**5 + 52923136*f**6 + 49131320*f**7 + 28259280*f**8 + 9869580*f**9 + 1920996*f**10 + 160083*f**11))/4.454244370140365e19,
    15: lambda f: -(f*(251328 + 3355341*f + 28313670*f**2 + 176557495*f**3 + 867807500*f**4 + 2325588321*f**5 + 3507413042*f**6 + 3175329115*f**7 + 1772661240*f**8 + 599682825*f**9 + 113018598*f**10 + 9124731*f**11))/1.514443085847724e21,
}

Q022kp2x16 = {
    0: lambda f: 0,
    1: lambda f: (-63 - 858*f - 8853*f**2 - 61464*f**3 - 314066*f**4 - 1248484*f**5 - 2214990*f**6 - 1975960*f**7 - 944405*f**8 - 232470*f**9 - 23247*f**10)/3.2137405267968e15,
    2: lambda f: 0,
    3: lambda f: (99 + 1452*f + 16170*f**2 + 121524*f**3 + 674261*f**4 + 2920552*f**5 + 5326260*f**6 + 4801720*f**7 + 2304995*f**8 + 568260*f**9 + 56826*f**10)/1.414045831790592e17,
    4: lambda f: 0,
    5: lambda f: (-231 - 3630*f - 43395*f**2 - 350980*f**3 - 2101295*f**4 - 9850162*f**5 - 18390155*f**6 - 16724680*f**7 - 8057315*f**8 - 1988910*f**9 - 198891*f**10)/9.898320822534144e18,
    6: lambda f: 0,
    7: lambda f: (693 + 11616*f + 148368*f**2 + 1284960*f**3 + 8256440*f**4 + 41643616*f**5 + 79334640*f**6 + 72684640*f**7 + 35122220*f**8 + 8678880*f**9 + 867888*f**10)/9.502387989632778e20,
    8: lambda f: (-69615 - 798252*f - 6521268*f**2 - 35616360*f**3 - 138070294*f**4 - 385885040*f**5 + 325111164*f**6 + 2604753928*f**7 + 4111036055*f**8 + 3167885700*f**9 + 1334695320*f**10 + 295983072*f**11 + 27143424*f**12)/3.278015337332736e18,
    9: lambda f: (-487305 - 6534528*f - 66378234*f**2 - 453624600*f**3 - 2281229218*f**4 - 8923429880*f**5 - 20691828264*f**6 - 28450903208*f**7 - 24201319975*f**8 - 12941276040*f**9 - 4249591290*f**10 - 784963872*f**11 - 62569584*f**12)/2.2946107361329152e18,
    10: lambda f: (19635 + 245718*f + 2213145*f**2 + 13441220*f**3 + 58815274*f**4 + 191000780*f**5 - 100753466*f**6 - 1138215232*f**7 - 1852859855*f**8 - 1443160950*f**9 - 610753605*f**10 - 135658908*f**11 - 12440736*f**12)/2.4038779140440064e19,
    11: lambda f: (137445 + 1987062*f + 21809997*f**2 + 161528900*f**3 + 883080368*f**4 + 3768426380*f**5 + 9114069646*f**6 + 12785198272*f**7 + 10988104435*f**8 + 5908072170*f**9 + 1945515495*f**10 + 359775108*f**11 + 28677726*f**12)/1.6827145398308045e19,
    12: lambda f: (-58905 - 798864*f - 7861854*f**2 - 52500420*f**3 - 255222751*f**4 - 937608140*f**5 + 295678068*f**6 + 5106142216*f**7 + 8529891335*f**8 + 6701947560*f**9 + 2846518290*f**10 + 633074904*f**11 + 58056768*f**12)/2.0192574477969654e21,
    13: lambda f: (-412335 - 6393156*f - 75400644*f**2 - 601580700*f**3 - 3552416917*f**4 - 16423010072*f**5 - 41172410706*f**6 - 58718785832*f**7 - 50889605767*f**8 - 27483845004*f**9 - 9070807284*f**10 - 1678950504*f**11 - 133829388*f**12)/1.4134802134578758e21,
    14: lambda f: (58905 + 860574*f + 9185253*f**2 + 66840600*f**3 + 356760385*f**4 + 1456654010*f**5 - 235109427*f**6 - 7409180044*f**7 - 12651821315*f**8 - 10012662450*f**9 - 4265279235*f**10 - 949612356*f**11 - 87085152*f**12)/6.057772343390896e22,
    15: lambda f: (412335 + 6825126*f + 86078157*f**2 + 736032000*f**3 + 4668849145*f**4 + 23244978050*f**5 + 60110287797*f**6 + 86923734044*f**7 + 75858654445*f**8 + 41118800310*f**9 + 13596067485*f**10 + 2518425756*f**11 + 200744082*f**12)/4.240440640373627e22,
}

Q100withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (-15 - 20*f - 22*f**2 - 12*f**3 - 3*f**4)/120.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (35 + 70*f + 119*f**2 + 124*f**3 + 81*f**4 + 30*f**5 + 5*f**6)/840.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (-315 - 840*f - 1932*f**2 - 2952*f**3 - 3098*f**4 - 2200*f**5 - 1020*f**6 - 280*f**7 - 35*f**8)/40320.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (693 + 2310*f + 6699*f**2 + 13464*f**3 + 19426*f**4 + 20276*f**5 + 15270*f**6 + 8120*f**7 + 2905*f**8 + 630*f**9 + 63*f**10)/665280.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (-15015 - 60060*f - 210210*f**2 - 523380*f**3 - 960245*f**4 - 1320280*f**5 - 1387404*f**6 - 1121512*f**7 - 685265*f**8 - 303660*f**9 - 91350*f**10 - 16632*f**11 - 1386*f**12)/1.3837824e8,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (6435 + 30030*f + 123123*f**2 + 365508*f**3 + 813527*f**4 + 1386970*f**5 + 1837335*f**6 + 1848280*f**7 + 1348025*f**8 + 677250*f**9 + 220185*f**10 + 41580*f**11 + 3465*f**12)/6.918912e8,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (-6435 - 34320*f - 161304*f**2 - 555984*f**3 - 1454596*f**4 - 2958800*f**5 - 4633800*f**6 - 5302160*f**7 - 4211650*f**8 - 2228400*f**9 - 745560*f**10 - 142560*f**11 - 11880*f**12)/9.4887936e9,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (715 + 4290*f + 22737*f**2 + 89232*f**3 + 268268*f**4 + 633880*f**5 + 1125780*f**6 + 1400560*f**7 + 1169210*f**8 + 636300*f**9 + 216090*f**10 + 41580*f**11 + 3465*f**12)/1.66053888e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (-3003 - 20020*f - 118118*f**2 - 519948*f**3 - 1765907*f**4 - 4752592*f**5 - 9306600*f**6 - 12273520*f**7 - 10583510*f**8 - 5862360*f**9 - 2009196*f**10 - 388080*f**11 - 32340*f**12)/1.2398690304e12,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (1365 + 10010*f + 65065*f**2 + 317460*f**3 + 1201915*f**4 + 3629210*f**5 + 7682559*f**6 + 10575152*f**7 + 9328690*f**8 + 5230260*f**9 + 1803690*f**10 + 349272*f**11 + 29106*f**12)/1.11588212736e13,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (-455 - 3640*f - 25844*f**2 - 138424*f**3 - 578006*f**4 - 1934920*f**5 - 4364660*f**6 - 6207880*f**7 - 5569025*f**8 - 3150000*f**9 - 1091160*f**10 - 211680*f**11 - 17640*f**12)/8.1155063808e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (315 + 2730*f + 21021*f**2 + 122616*f**3 + 559754*f**4 + 2057380*f**5 + 4892430*f**6 + 7140280*f**7 + 6488825*f**8 + 3694950*f**9 + 1284255*f**10 + 249480*f**11 + 20790*f**12)/1.339058552832e15,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (-585 - 5460*f - 45318*f**2 - 285948*f**3 - 1416727*f**4 - 5671640*f**5 - 14101260*f**6 - 21013160*f**7 - 19292665*f**8 - 11043900*f**9 - 3848670*f**10 - 748440*f**11 - 62370*f**12)/6.4274810535936e16,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (3 + 30*f + 267*f**2 + 1812*f**3 + 9683*f**4 + 41938*f**5 + 108315*f**6 + 164200*f**7 + 152015*f**8 + 87390*f**9 + 30519*f**10 + 5940*f**11 + 495*f**12)/9.182115790848e15,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (-495 - 5280*f - 50160*f**2 - 364320*f**3 - 2088680*f**4 - 9730720*f**5 - 25972752*f**6 - 39943456*f**7 - 37234820*f**8 - 21480480*f**9 - 7514640*f**10 - 1463616*f**11 - 121968*f**12)/4.524946661729894e19,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (-15 - 20*f - 22*f**2 - 12*f**3 - 3*f**4)/180.,
    52: lambda f: (105 + 140*f + 133*f**2 + 66*f**3 + 12*f**4)/630.,
    53: lambda f: 0,
    54: lambda f: (35 + 70*f + 119*f**2 + 124*f**3 + 81*f**4 + 30*f**5 + 5*f**6)/840.,
    55: lambda f: (-105 - 210*f - 336*f**2 - 336*f**3 - 205*f**4 - 70*f**5 - 10*f**6)/1260.,
    56: lambda f: 0,
    57: lambda f: (-315 - 840*f - 1932*f**2 - 2952*f**3 - 3098*f**4 - 2200*f**5 - 1020*f**6 - 280*f**7 - 35*f**8)/30240.,
    58: lambda f: (3465 + 9240*f + 20559*f**2 + 30690*f**3 + 31207*f**4 + 21380*f**5 + 9465*f**6 + 2450*f**7 + 280*f**8)/166320.,
    59: lambda f: 0,
    60: lambda f: (693 + 2310*f + 6699*f**2 + 13464*f**3 + 19426*f**4 + 20276*f**5 + 15270*f**6 + 8120*f**7 + 2905*f**8 + 630*f**9 + 63*f**10)/399168.,
    61: lambda f: (-45045 - 150150*f - 426426*f**2 - 844272*f**3 - 1195766*f**4 - 1222780*f**5 - 899040*f**6 - 464800*f**7 - 160685*f**8 - 33390*f**9 - 3150*f**10)/1.297296e7,
    62: lambda f: 0,
    63: lambda f: (-3003 - 12012*f - 42042*f**2 - 104676*f**3 - 192049*f**4 - 264056*f**5 - 274524*f**6 - 215432*f**7 - 125965*f**8 - 53340*f**9 - 15498*f**10 - 2772*f**11 - 231*f**12)/1.3837824e7,
    64: lambda f: (15015 + 60060*f + 207207*f**2 + 510510*f**3 + 925210*f**4 + 1255280*f**5 + 1285670*f**6 + 992068*f**7 + 568995*f**8 + 235620*f**9 + 66675*f**10 + 11550*f**11 + 924*f**12)/3.459456e7,
    65: lambda f: 0,
    66: lambda f: (6435 + 30030*f + 123123*f**2 + 365508*f**3 + 813527*f**4 + 1386970*f**5 + 1837335*f**6 + 1903192*f**7 + 1540217*f**8 + 965538*f**9 + 460425*f**10 + 161700*f**11 + 39501*f**12 + 6006*f**13 + 429*f**14)/2.965248e8,
    67: lambda f: (-765765 - 3573570*f - 14498484*f**2 - 42707808*f**3 - 94227991*f**4 - 159148730*f**5 - 208671090*f**6 - 213722096*f**7 - 170806867*f**8 - 105586614*f**9 - 49560000*f**10 - 17094000*f**11 - 4089393*f**12 - 606606*f**13 - 42042*f**14)/1.76432256e10,
    68: lambda f: 0,
    69: lambda f: (-6435 - 34320*f - 161304*f**2 - 555984*f**3 - 1454596*f**4 - 2958800*f**5 - 4728840*f**6 - 5916752*f**7 - 5721202*f**8 - 4195728*f**9 - 2276100*f**10 - 881100*f**11 - 229581*f**12 - 36036*f**13 - 2574*f**14)/3.5582976e9,
    70: lambda f: (109395 + 583440*f + 2720289*f**2 + 9320454*f**3 + 24224915*f**4 + 48933820*f**5 + 77603385*f**6 + 96187258*f**7 + 91894961*f**8 + 66374712*f**9 + 35346375*f**10 + 13389750*f**11 + 3404214*f**12 + 519948*f**13 + 36036*f**14)/3.02455296e10,
    71: lambda f: 0,
    72: lambda f: (715 + 4290*f + 22737*f**2 + 89232*f**3 + 268268*f**4 + 633880*f**5 + 1175060*f**6 + 1676528*f**7 + 1802458*f**8 + 1432172*f**9 + 822850*f**10 + 331100*f**11 + 88319*f**12 + 14014*f**13 + 1001*f**14)/5.5351296e9,
    73: lambda f: (-255255 - 1531530*f - 8066058*f**2 - 31505760*f**3 - 94235284*f**4 - 221468520*f**5 - 407960560*f**6 - 576889152*f**7 - 612418954*f**8 - 478585548*f**9 - 269451000*f**10 - 105913500*f**11 - 27526191*f**12 - 4246242*f**13 - 294294*f**14)/9.880206336e11,
    74: lambda f: 0,
    75: lambda f: (-1155 - 7700*f - 45430*f**2 - 199980*f**3 - 679195*f**4 - 1827920*f**5 - 3818280*f**6 - 5988976*f**7 - 6897926*f**8 - 5749464*f**9 - 3411380*f**10 - 1401400*f**11 - 378378*f**12 - 60368*f**13 - 4312*f**14)/1.430618112e11,
    76: lambda f: (255255 + 1701700*f + 9988979*f**2 + 43801758*f**3 + 148154864*f**4 + 397022080*f**5 + 824809740*f**6 + 1282240232*f**7 + 1457251474*f**8 + 1193361288*f**9 + 693087850*f**10 + 277854500*f**11 + 73036656*f**12 + 11323312*f**13 + 784784*f**14)/1.58083301376e13,
    77: lambda f: 0,
    78: lambda f: (1365 + 10010*f + 65065*f**2 + 317460*f**3 + 1201915*f**4 + 3629210*f**5 + 8359935*f**6 + 14074928*f**7 + 17005618*f**8 + 14628852*f**9 + 8859690*f**10 + 3686760*f**11 + 1002834*f**12 + 160524*f**13 + 11466*f**14)/3.0433148928e12,
    79: lambda f: (-255255 - 1871870*f - 12116104*f**2 - 58927440*f**3 - 222351415*f**4 - 669048770*f**5 - 1533629670*f**6 - 2558789408*f**7 - 3048748654*f**8 - 2574782028*f**9 - 1525242600*f**10 - 618987600*f**11 - 163837674*f**12 - 25477452*f**13 - 1765764*f**14)/2.845499424768e14,
    80: lambda f: 0,
    81: lambda f: (-455 - 3640*f - 25844*f**2 - 138424*f**3 - 578006*f**4 - 1934920*f**5 - 4835060*f**6 - 8597512*f**7 - 10757537*f**8 - 9462768*f**9 - 5812800*f**10 - 2440200*f**11 - 667086*f**12 - 107016*f**13 - 7644*f**14)/2.0288765952e13,
    82: lambda f: (23205 + 185640*f + 1313403*f**2 + 7015866*f**3 + 29213327*f**4 + 97509620*f**5 + 242564585*f**6 + 427358274*f**7 + 527065098*f**8 + 454912416*f**9 + 273183750*f**10 + 111793500*f**11 + 29728692*f**12 + 4632264*f**13 + 321048*f**14)/5.17363531776e14,
    83: lambda f: 0,
    84: lambda f: (4095 + 35490*f + 273273*f**2 + 1594008*f**3 + 7276802*f**4 + 26745940*f**5 + 71584950*f**6 + 132917848*f**7 + 170796773*f**8 + 152749422*f**9 + 94810275*f**10 + 40055400*f**11 + 10989594*f**12 + 1765764*f**13 + 126126*f**14)/4.017175658496e15,
    85: lambda f: (-69615 - 603330*f - 4631718*f**2 - 26954928*f**3 - 122758870*f**4 - 450093020*f**5 - 1199589360*f**6 - 2206541792*f**7 - 2793656089*f**8 - 2450449638*f**9 - 1486311750*f**10 - 611919000*f**11 - 163272186*f**12 - 25477452*f**13 - 1765764*f**14)/3.4145993097216e16,
    86: lambda f: 0,
    87: lambda f: (-585 - 5460*f - 45318*f**2 - 285948*f**3 - 1416727*f**4 - 5671640*f**5 - 16097100*f**6 - 30954344*f**7 - 40614889*f**8 - 36790236*f**9 - 23017050*f**10 - 9771300*f**11 - 2688147*f**12 - 432432*f**13 - 30888*f**14)/1.3773173686272e16,
    88: lambda f: (69615 + 649740*f + 5378919*f**2 + 33872670*f**3 + 167478662*f**4 + 669064240*f**5 + 1891348770*f**6 + 3602423692*f**7 + 4655723429*f**8 + 4134873708*f**9 + 2527174125*f**10 + 1045217250*f**11 + 279592236*f**12 + 43675632*f**13 + 3027024*f**14)/8.19503834333184e17,
    89: lambda f: 0,
    90: lambda f: (15 + 150*f + 1335*f**2 + 9060*f**3 + 48415*f**4 + 209690*f**5 + 626055*f**6 + 1239176*f**7 + 1653451*f**8 + 1513014*f**9 + 952515*f**10 + 405900*f**11 + 111903*f**12 + 18018*f**13 + 1287*f**14)/9.182115790848e15,
    91: lambda f: (-2805 - 28050*f - 249084*f**2 - 1687488*f**3 - 9001619*f**4 - 38915890*f**5 - 115746370*f**6 - 226890704*f**7 - 298121013*f**8 - 267396426*f**9 - 164412600*f**10 - 68244000*f**11 - 18291207*f**12 - 2859714*f**13 - 198198*f**14)/8.58527826444288e17,
    92: lambda f: 0,
    93: lambda f: (-495 - 5280*f - 50160*f**2 - 364320*f**3 - 2088680*f**4 - 9730720*f**5 - 30363600*f**6 - 61572448*f**7 - 83298068*f**8 - 76853952*f**9 - 48628020*f**10 - 20785380*f**11 - 5740119*f**12 - 924924*f**13 - 66066*f**14)/8.484274990743552e18,
    94: lambda f: (58905 + 628320*f + 5957259*f**2 + 43202610*f**3 + 247299085*f**4 + 1150280180*f**5 + 3576238575*f**6 + 7181184710*f**7 + 9564668533*f**8 + 8648034696*f**9 + 5343218475*f**10 + 2224264350*f**11 + 597109590*f**12 + 93417324*f**13 + 6474468*f**14)/5.0481436194924134e20,
    95: lambda f: 0,
}

Q102withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: -(f*(14 + 19*f + 12*f**2 + 3*f**3))/210.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/1260.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: -(f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/55440.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/4.32432e6,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: -(f*(30030 + 143715*f + 414700*f**2 + 825175*f**3 + 1194500*f**4 + 1300454*f**5 + 1078112*f**6 + 670390*f**7 + 300510*f**8 + 91035*f**9 + 16632*f**10 + 1386*f**11))/1.729728e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 695829*f**5 + 716912*f**6 + 530740*f**7 + 269010*f**8 + 87885*f**9 + 16632*f**10 + 1386*f**11))/3.459456e8,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: -(f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 220761*f**5 + 258248*f**6 + 207835*f**7 + 110790*f**8 + 37215*f**9 + 7128*f**10 + 594*f**11))/5.930496e8,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 3016468*f**5 + 3830624*f**6 + 3235960*f**7 + 1772820*f**8 + 604170*f**9 + 116424*f**10 + 9702*f**11))/5.81188608e10,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: -(f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1786692*f**5 + 2402176*f**6 + 2094260*f**7 + 1167180*f**8 + 401310*f**9 + 77616*f**10 + 6468*f**11))/3.099672576e11,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (f*(10010 + 90805*f + 514800*f**2 + 2120950*f**3 + 6761750*f**4 + 14783193*f**5 + 20724704*f**6 + 18471880*f**7 + 10416420*f**8 + 3602970*f**9 + 698544*f**10 + 58212*f**11))/2.7897053184e13,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: -(f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1262063*f**5 + 1826664*f**6 + 1654905*f**7 + 941220*f**8 + 326970*f**9 + 63504*f**10 + 5292*f**11))/3.0433148928e13,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1888914*f**5 + 2803472*f**6 + 2571940*f**7 + 1472310*f**8 + 513135*f**9 + 99792*f**10 + 8316*f**11))/6.69529276416e14,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: -(f*(546 + 6357*f + 46644*f**2 + 251641*f**3 + 1064180*f**4 + 2725326*f**5 + 4127648*f**6 + 3824590*f**7 + 2200590*f**8 + 768915*f**9 + 149688*f**10 + 12474*f**11))/1.6068702633984e16,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 460987*f**5 + 709936*f**6 + 663140*f**7 + 383130*f**8 + 134145*f**9 + 26136*f**10 + 2178*f**11))/5.0501636849664e16,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: -(f*(2310 + 30855*f + 260700*f**2 + 1627925*f**3 + 8013250*f**4 + 22000083*f**5 + 34357624*f**6 + 32307905*f**7 + 18729270*f**8 + 6568695*f**9 + 1280664*f**10 + 106722*f**11))/4.949160411267072e19,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (f*(70 + 123*f + 100*f**2 + 28*f**3))/4200.,
    52: lambda f: -(f*(294 + 357*f + 200*f**2 + 44*f**3))/2940.,
    53: lambda f: (f*(490 + 749*f + 380*f**2 + 64*f**3))/29400.,
    54: lambda f: -(f*(70 + 239*f + 400*f**2 + 349*f**3 + 160*f**4 + 30*f**5))/12600.,
    55: lambda f: (f*(686 + 1414*f + 1580*f**2 + 1017*f**3 + 360*f**4 + 55*f**5))/8820.,
    56: lambda f: -(f*(5390 + 12859*f + 14960*f**2 + 9939*f**3 + 3460*f**4 + 480*f**5))/323400.,
    57: lambda f: (f*(2310 + 15411*f + 42900*f**2 + 65446*f**3 + 60890*f**4 + 34515*f**5 + 11060*f**6 + 1540*f**7))/3.3264e6,
    58: lambda f: -(f*(61446 + 179025*f + 299640*f**2 + 320318*f**3 + 224650*f**4 + 100665*f**5 + 26320*f**6 + 3080*f**7))/2.32848e6,
    59: lambda f: (f*(210210 + 681681*f + 1204060*f**2 + 1353846*f**3 + 986190*f**4 + 453065*f**5 + 118860*f**6 + 13440*f**7))/3.36336e7,
    60: lambda f: -(f**2*(12012 + 57200*f + 133757*f**2 + 194470*f**3 + 187375*f**4 + 120820*f**5 + 50435*f**6 + 12390*f**7 + 1365*f**8))/2.16216e7,
    61: lambda f: (f*(168168 + 633633*f + 1412840*f**2 + 2111122*f**3 + 2213020*f**4 + 1642840*f**5 + 850640*f**6 + 293510*f**7 + 60900*f**8 + 5775*f**9))/3.027024e7,
    62: lambda f: -(f*(210210 + 861861*f + 2024880*f**2 + 3180931*f**3 + 3486710*f**4 + 2693235*f**5 + 1441580*f**6 + 509845*f**7 + 107100*f**8 + 10080*f**9))/1.513512e8,
    63: lambda f: (f*(-6006 + 7293*f + 128700*f**2 + 466336*f**3 + 974660*f**4 + 1365294*f**5 + 1346744*f**6 + 945700*f**7 + 465570*f**8 + 153405*f**9 + 30492*f**10 + 2772*f**11))/4.1513472e8,
    64: lambda f: -(f*(1219218 + 5636631*f + 15701400*f**2 + 30135040*f**3 + 42038900*f**4 + 43564362*f**5 + 33692624*f**6 + 19258540*f**7 + 7922250*f**8 + 2224215*f**9 + 382536*f**10 + 30492*f**11))/1.45297152e9,
    65: lambda f: (f*(3573570 + 17714697*f + 51780300*f**2 + 104102492*f**3 + 151678420*f**4 + 163750086*f**5 + 131544952*f**6 + 77829500*f**7 + 32996250*f**8 + 9493785*f**9 + 1660428*f**10 + 133056*f**11))/1.646701056e10,
    66: lambda f: -(f*(-510510 - 1042899*f + 2917200*f**2 + 22562111*f**3 + 68062900*f**4 + 130692600*f**5 + 177848104*f**6 + 178239110*f**7 + 133005474*f**8 + 73375365*f**9 + 29170680*f**10 + 7927227*f**11 + 1321320*f**12 + 102102*f**13))/1.76432256e11,
    67: lambda f: (f*(12150138 + 66570504*f + 222436500*f**2 + 521414803*f**3 + 908117900*f**4 + 1207852227*f**5 + 1242589376*f**6 + 991225270*f**7 + 609077322*f**8 + 283426710*f**9 + 96769596*f**10 + 22904343*f**11 + 3363360*f**12 + 231231*f**13))/1.235025792e11,
    68: lambda f: -(f*(67897830 + 394777383*f + 1378279760*f**2 + 3371112563*f**3 + 6114842200*f**4 + 8457409390*f**5 + 9032522632*f**6 + 7466531870*f**7 + 4744271742*f**8 + 2277208395*f**9 + 799527960*f**10 + 193846191*f**11 + 29008980*f**12 + 2018016*f**13))/2.607276672e12,
    69: lambda f: (f*(-72930 - 269841*f - 243100*f**2 + 1660594*f**3 + 8554910*f**4 + 22869505*f**5 + 41588588*f**6 + 53989120*f**7 + 50143578*f**8 + 32880105*f**9 + 14817660*f**10 + 4361544*f**11 + 755040*f**12 + 58344*f**13))/2.01636864e11,
    70: lambda f: -(f*(1327326 + 8408829*f + 32769880*f**2 + 90734202*f**3 + 189468910*f**4 + 305134139*f**5 + 379405152*f**6 + 360586940*f**7 + 257761434*f**8 + 135510795*f**9 + 50651832*f**10 + 12717936*f**11 + 1921920*f**12 + 132132*f**13))/1.411458048e11,
    71: lambda f: (f*(67897830 + 452975523*f + 1837398420*f**2 + 5289236758*f**3 + 11468273270*f**4 + 19171902405*f**5 + 24748865036*f**6 + 24409593460*f**7 + 18077370066*f**8 + 9815903685*f**9 + 3773842380*f**10 + 969836868*f**11 + 149189040*f**12 + 10378368*f**13))/2.6817702912e13,
    72: lambda f: -(f*(-1021020 - 5061342*f - 11668800*f**2 - 1231412*f**3 + 88140920*f**4 + 376870620*f**5 + 919570064*f**6 + 1455428380*f**7 + 1540741104*f**8 + 1099121940*f**9 + 521870580*f**10 + 158225067*f**11 + 27747720*f**12 + 2144142*f**13))/2.9640619008e13,
    73: lambda f: (f*(15723708 + 113077965*f + 503508720*f**2 + 1607935004*f**3 + 3914743000*f**4 + 7321176072*f**5 + 10358140576*f**6 + 10900056860*f**7 + 8403004512*f**8 + 4659478110*f**9 + 1804552596*f**10 + 462848463*f**11 + 70630560*f**12 + 4855851*f**13))/2.07484333056e13,
    74: lambda f: -(f*(271591320 + 2044694652*f + 9444726720*f**2 + 31258481332*f**3 + 78797387480*f**4 + 152802675900*f**5 + 224606967536*f**6 + 245644225540*f**7 + 196441181496*f**8 + 112581020160*f**9 + 44849338380*f**10 + 11769898833*f**11 + 1827565740*f**12 + 127135008*f**13))/1.314067442688e15,
    75: lambda f: (f*(-850850 - 5151289*f - 16773900*f**2 - 26901004*f**3 + 22431160*f**4 + 342408900*f**5 + 1158900176*f**6 + 2147918920*f**7 + 2478482916*f**8 + 1857774730*f**9 + 907611320*f**10 + 279456408*f**11 + 49329280*f**12 + 3811808*f**13))/3.16166602752e14,
    76: lambda f: -(f*(11673662 + 93950857*f + 470544360*f**2 + 1702439908*f**3 + 4734575480*f**4 + 9975068988*f**5 + 15470598304*f**6 + 17377608920*f**7 + 14007130788*f**8 + 8000421590*f**9 + 3157513744*f**10 + 818809992*f**11 + 125565440*f**12 + 8632624*f**13))/2.213166219264e14,
    77: lambda f: (f*(67897830 + 569371803*f + 2949629540*f**2 + 11029563688*f**3 + 31679181080*f**4 + 69174061140*f**5 + 111573765968*f**6 + 130415497240*f**7 + 109143723668*f**8 + 64457428770*f**9 + 26168428440*f**10 + 6941983664*f**11 + 1083001920*f**12 + 75339264*f**13))/4.672239796224e15,
    78: lambda f: -(f*(-170170 - 1203345*f - 4862000*f**2 - 12008035*f**3 - 12882600*f**4 + 66651730*f**5 + 337058736*f**6 + 711109140*f**7 + 871972836*f**8 + 675146010*f**9 + 335818560*f**10 + 104383818*f**11 + 18498480*f**12 + 1429428*f**13))/9.48499808256e14,
    79: lambda f: (f*(2144142 + 19093074*f + 106234700*f**2 + 429457145*f**3 + 1343095200*f**4 + 3117373691*f**5 + 5174939840*f**6 + 6079969140*f**7 + 5045975508*f**8 + 2936736600*f**9 + 1172687208*f**10 + 306146610*f**11 + 47087040*f**12 + 3237234*f**13))/6.639498657792e14,
    80: lambda f: -(f*(113163050 + 1045949905*f + 6004570000*f**2 + 25027278705*f**3 + 80654747300*f**4 + 194012734260*f**5 + 335301084272*f**6 + 410361566020*f**7 + 353840412492*f**8 + 212991123870*f**9 + 87490307520*f**10 + 23362833186*f**11 + 3655131480*f**12 + 254270016*f**13))/1.26150474498048e17,
    81: lambda f: (f*(-108290 - 870961*f - 4132700*f**2 - 12956346*f**3 - 25332550*f**4 + 33732675*f**5 + 301634452*f**6 + 709469180*f**7 + 910068012*f**8 + 720939870*f**9 + 363048840*f**10 + 113573376*f**11 + 20180160*f**12 + 1559376*f**13))/1.034727063552e16,
    82: lambda f: -(f*(1277822 + 12473461*f + 76333400*f**2 + 340981342*f**3 + 1184489450*f**4 + 2978232601*f**5 + 5208117488*f**6 + 6322089760*f**7 + 5355880236*f**8 + 3157730730*f**9 + 1271018448*f**10 + 333318384*f**11 + 51367680*f**12 + 3531528*f**13))/7.243089444864e15,
    83: lambda f: (f*(22632610 + 228589361*f + 1440173020*f**2 + 6619110446*f**3 + 23646458550*f**4 + 61634180085*f**5 + 112324319548*f**6 + 142154160680*f**7 + 125182869588*f**8 + 76350790530*f**9 + 31613896440*f**10 + 8479488024*f**11 + 1329138720*f**12 + 92461824*f**13))/4.5872899817472e17,
    84: lambda f: -(f*(-92820 - 834054*f - 4508400*f**2 - 16731689*f**3 - 43047910*f**4 + 12311145*f**5 + 353389484*f**6 + 912133285*f**7 + 1211355054*f**8 + 976037265*f**9 + 495952380*f**10 + 155868867*f**11 + 27747720*f**12 + 2144142*f**13))/1.7072996548608e17,
    85: lambda f: (f*(2079168 + 22077237*f + 147371640*f**2 + 720859126*f**3 + 2753740580*f**4 + 7404509664*f**5 + 13490229872*f**6 + 16785838090*f**7 + 14438563524*f**8 + 8593648245*f**9 + 3479042952*f**10 + 915329646*f**11 + 141261120*f**12 + 9711702*f**13))/2.39021951680512e17,
    86: lambda f: -(f*(6172530 + 67633293*f + 463905520*f**2 + 2330432403*f**3 + 9139249470*f**4 + 25485967775*f**5 + 48435179772*f**6 + 62877646545*f**7 + 56242346832*f**8 + 34634595870*f**9 + 14423977260*f**10 + 3881165211*f**11 + 609188580*f**12 + 42378336*f**13))/2.52300948996096e18,
    87: lambda f: (f*(-139230 - 1379703*f - 8331700*f**2 - 35326408*f**3 - 108913220*f**4 - 24821870*f**5 + 707208712*f**6 + 1978492460*f**7 + 2700861702*f**8 + 2204857095*f**9 + 1128051540*f**10 + 355766796*f**11 + 63423360*f**12 + 4900896*f**13))/5.46335889555456e18,
    88: lambda f: -(f*(1494402 + 17148495*f + 123998680*f**2 + 659158136*f**3 + 2746300700*f**4 + 7817965406*f**5 + 14721932848*f**6 + 18676395220*f**7 + 16254031206*f**8 + 9744214305*f**9 + 3962113848*f**10 + 1044980244*f**11 + 161441280*f**12 + 11099088*f**13))/3.824351226888192e18,
    89: lambda f: (f*(882671790 + 10428136719*f + 77350870740*f**2 + 421602257804*f**3 + 1800459565060*f**4 + 5318425986990*f**5 + 10455837465304*f**6 + 13846945874300*f**7 + 12535617636234*f**8 + 7776401513265*f**9 + 3252785479020*f**10 + 877358390832*f**11 + 137850672960*f**12 + 9589612032*f**13))/7.992894064196321e21,
    90: lambda f: -(f*(-28050 - 303501*f - 2019600*f**2 - 9574111*f**3 - 33884060*f**4 - 18477300*f**5 + 186176968*f**6 + 558985790*f**7 + 780328098*f**8 + 643679685*f**9 + 331099560*f**10 + 104708439*f**11 + 18687240*f**12 + 1444014*f**13))/2.575583479332864e19,
    91: lambda f: (f*(290598 + 3583668*f + 27904140*f**2 + 160176397*f**3 + 722820620*f**4 + 2161101489*f**5 + 4181566592*f**6 + 5387824750*f**7 + 4732758954*f**8 + 2853420570*f**9 + 1164215052*f**10 + 307641411*f**11 + 47567520*f**12 + 3270267*f**13))/1.8029084355330048e19,
    92: lambda f: -(f*(5222910 + 66181731*f + 527833680*f**2 + 3102168551*f**3 + 14328900160*f**4 + 44481024450*f**5 + 89923580152*f**6 + 121012574690*f**7 + 110603267082*f**8 + 69009719625*f**9 + 28965265560*f**10 + 7827349761*f**11 + 1230809580*f**12 + 85621536*f**13))/1.141842009170903e21,
    93: lambda f: (f*(-431970 - 5063025*f - 36745500*f**2 - 191924390*f**3 - 760808650*f**4 - 583314795*f**5 + 3679713212*f**6 + 11761907080*f**7 + 16726010742*f**8 + 13914150495*f**9 + 7188438180*f**10 + 2278301256*f**11 + 406966560*f**12 + 31447416*f**13))/1.0096287238984827e22,
    94: lambda f: -(f*(4343262 + 57283149*f + 477859800*f**2 + 2945819330*f**3 + 14313492550*f**4 + 44656939719*f**5 + 88390665664*f**6 + 115348243220*f**7 + 102090655926*f**8 + 61834152765*f**9 + 25298378952*f**10 + 6695311392*f**11 + 1035914880*f**12 + 71219148*f**13))/7.067401067289379e21,
    95: lambda f: (f*(26114550 + 353292555*f + 3014720500*f**2 + 19003385230*f**3 + 94393471550*f**4 + 305969655425*f**5 + 633179464316*f**6 + 863371735660*f**7 + 795249734286*f**8 + 498508885035*f**9 + 209816519220*f**10 + 56784712908*f**11 + 8934765840*f**12 + 621548928*f**13))/1.4920068919833133e23,
}

Q104withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: -(f**2*(2 + f)**2)/315.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/3465.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: -(f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/120120.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/540540.,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: -(f**2*(2 + f)**2*(12155 + 44200*f + 93500*f**2 + 128520*f**3 + 125706*f**4 + 87192*f**5 + 40404*f**6 + 11088*f**7 + 1386*f**8))/2.9405376e8,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (f**2*(2 + f)**2*(2431 + 11050*f + 29325*f**2 + 52360*f**3 + 67270*f**4 + 58380*f**5 + 31290*f**6 + 9240*f**7 + 1155*f**8))/4.900896e8,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: -(f**2*(2 + f)**2*(2431 + 13260*f + 42330*f**2 + 92820*f**3 + 142125*f**4 + 137880*f**5 + 78420*f**6 + 23760*f**7 + 2970*f**8))/5.0409216e9,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (f**2*(2 + f)**2*(9724 + 61880*f + 230860*f**2 + 599760*f**3 + 1037820*f**4 + 1076040*f**5 + 632100*f**6 + 194040*f**7 + 24255*f**8))/2.470051584e11,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: -(f**2*(2 + f)**2*(2431 + 17680*f + 75480*f**2 + 226576*f**3 + 429044*f**4 + 464912*f**5 + 278712*f**6 + 86240*f**7 + 10780*f**8))/8.782405632e11,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (f**2*(2 + f)**2*(12155 + 99450*f + 478125*f**2 + 1627920*f**3 + 3303468*f**4 + 3693816*f**5 + 2245572*f**6 + 698544*f**7 + 87318*f**8))/7.11374856192e13,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: -(f**2*(2 + f)**2*(2431 + 22100*f + 118150*f**2 + 449820*f**3 + 964215*f**4 + 1103760*f**5 + 677880*f**6 + 211680*f**7 + 26460*f**8))/2.58681765888e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (f**2*(2 + f)**2*(221 + 2210*f + 13005*f**2 + 54740*f**3 + 122675*f**4 + 143010*f**5 + 88515*f**6 + 27720*f**7 + 3465*f**8))/4.74249904128e14,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: -(f**2*(2 + f)**2*(31603 + 344760*f + 2214420*f**2 + 10210200*f**3 + 23739870*f**4 + 28080360*f**5 + 17486700*f**6 + 5488560*f**7 + 686070*f**8))/1.502423696277504e18,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (f**2*(2 + f)**2*(187 + 2210*f + 15385*f**2 + 77112*f**3 + 184938*f**4 + 221364*f**5 + 138534*f**6 + 43560*f**7 + 5445*f**8))/2.14631956611072e17,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: -(f**2*(2 + f)**2*(935 + 11900*f + 89250*f**2 + 483140*f**3 + 1189769*f**4 + 1438248*f**5 + 903756*f**6 + 284592*f**7 + 35574*f**8))/2.804524233051341e19,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (2*f**2*(2 + f))/945.,
    52: lambda f: (2*f**2*(77 + 64*f + 18*f**2))/6615.,
    53: lambda f: (-2*f**2*(154 + 155*f + 39*f**2))/24255.,
    54: lambda f: -(f**2*(132 + 170*f + 82*f**2 + 15*f**3))/10395.,
    55: lambda f: -(f**2*(6237 + 10412*f + 7970*f**2 + 3065*f**3 + 495*f**4))/218295.,
    56: lambda f: (f**2*(6776 + 11418*f + 8665*f**2 + 3495*f**3 + 585*f**4))/266805.,
    57: lambda f: (f**2*(1430 + 3107*f + 3186*f**2 + 1815*f**3 + 550*f**4 + 70*f**5))/180180.,
    58: lambda f: (f**2*(51051 + 129740*f + 165888*f**2 + 126645*f**3 + 58935*f**4 + 15575*f**5 + 1820*f**6))/3.78378e6,
    59: lambda f: -(f**2*(66066 + 166309*f + 210248*f**2 + 161985*f**3 + 77710*f**4 + 21770*f**5 + 2730*f**6))/4.62462e6,
    60: lambda f: -(f**2*(4004 + 12298*f + 19278*f**2 + 18705*f**3 + 11700*f**4 + 4620*f**5 + 1050*f**6 + 105*f**7))/1.62162e6,
    61: lambda f: -(f**2*(83083 + 284856*f + 513668*f**2 + 591530*f**3 + 459750*f**4 + 242060*f**5 + 83300*f**6 + 17010*f**7 + 1575*f**8))/2.270268e7,
    62: lambda f: (f**2*(176176 + 596882*f + 1064067*f**2 + 1223685*f**3 + 961725*f**4 + 520380*f**5 + 187425*f**6 + 40845*f**7 + 4095*f**8))/4.162158e7,
    63: lambda f: (f**2*(43758 + 173927*f + 366724*f**2 + 503166*f**3 + 478116*f**4 + 319620*f**5 + 148260*f**6 + 45570*f**7 + 8358*f**8 + 693*f**9))/8.8216128e7,
    64: lambda f: (f**2*(6279273 + 27147640*f + 63339790*f**2 + 97822930*f**3 + 106995270*f**4 + 84856002*f**5 + 48782580*f**6 + 19900230*f**7 + 5481105*f**8 + 917070*f**9 + 70686*f**10))/9.26269344e9,
    65: lambda f: -(f**2*(1871870 + 8000421*f + 18468103*f**2 + 28386906*f**3 + 31136592*f**4 + 25004364*f**5 + 14724150*f**6 + 6235110*f**7 + 1808898*f**8 + 323631*f**9 + 27027*f**10))/2.264213952e9,
    66: lambda f: -(f**2*(2032316 + 9918038*f + 26269590*f**2 + 46594365*f**3 + 59413000*f**4 + 56029624*f**5 + 39347532*f**6 + 20386590*f**7 + 7584780*f**8 + 1919610*f**9 + 296142*f**10 + 21021*f**11))/2.79351072e10,
    67: lambda f: -(f**2*(55288233 + 288740036*f + 827485302*f**2 + 1605085515*f**3 + 2267647245*f**4 + 2408701652*f**5 + 1946799764*f**6 + 1195607658*f**7 + 550246515*f**8 + 184227120*f**9 + 42454566*f**10 + 6033027*f**11 + 399399*f**12))/5.866372512e11,
    68: lambda f: (f**2*(85357272 + 441104950*f + 1251886307*f**2 + 2414055165*f**3 + 3407450215*f**4 + 3638662328*f**5 + 2978628030*f**6 + 1868977278*f**7 + 887584950*f**8 + 310055130*f**9 + 75437439*f**10 + 11456445*f**11 + 819819*f**12))/7.170010848e11,
    69: lambda f: (f**2*(1200914 + 6949345*f + 22157154*f**2 + 48193215*f**3 + 75898350*f**4 + 87392526*f**5 + 72935868*f**6 + 43339710*f**7 + 17802270*f**8 + 4795065*f**9 + 761508*f**10 + 54054*f**11))/1.436662656e11,
    70: lambda f: (f**2*(10484903 + 64211108*f + 218328620*f**2 + 510109055*f**3 + 875704965*f**4 + 1125590921*f**5 + 1082250512*f**6 + 770429814*f**7 + 398706945*f**8 + 145463010*f**9 + 35430318*f**10 + 5171166*f**11 + 342342*f**12))/1.0056638592e12,
    71: lambda f: -(f**2*(49791742 + 302029871*f + 1017886050*f**2 + 2363609025*f**3 + 4039310130*f**4 + 5181655122*f**5 + 5002177320*f**6 + 3612039522*f**7 + 1921679550*f**8 + 731402595*f**9 + 188480061*f**10 + 29459430*f**11 + 2108106*f**12))/3.6874341504e12,
    72: lambda f: -(f**2*(11085360 + 74204728*f + 276619784*f**2 + 712621980*f**3 + 1312390800*f**4 + 1712070192*f**5 + 1564187016*f**6 + 988436820*f**7 + 422260440*f**8 + 116326980*f**9 + 18656946*f**10 + 1324323*f**11))/1.40792940288e13,
    73: lambda f: -(f**2*(282260979 + 1983607600*f + 7806530152*f**2 + 21343161700*f**3 + 42611005500*f**4 + 62250373416*f**5 + 66094771512*f**6 + 50586659004*f**7 + 27535909170*f**8 + 10386605460*f**9 + 2580625278*f**10 + 380080701*f**11 + 25162137*f**12))/2.956651746048e14,
    74: lambda f: (f**2*(455238784 + 3171521496*f + 12380914292*f**2 + 33643815660*f**3 + 66605524860*f**4 + 96482090544*f**5 + 102228795060*f**6 + 79052603364*f**7 + 44166444000*f**8 + 17381327040*f**9 + 4572829107*f**10 + 721756035*f**11 + 51648597*f**12))/3.613685467392e14,
    75: lambda f: (f**2*(1570426 + 11937757*f + 50938392*f**2 + 151648500*f**3 + 314811000*f**4 + 446707128*f**5 + 431167464*f**6 + 282068500*f**7 + 123055660*f**8 + 34296570*f**9 + 5527984*f**10 + 392392*f**11))/2.50298560512e13,
    76: lambda f: (f**2*(39122083 + 310322896*f + 1387629318*f**2 + 4346294460*f**3 + 9777781140*f**4 + 15630164844*f**5 + 17671912328*f**6 + 14110928076*f**7 + 7898288930*f**8 + 3032338540*f**9 + 761147772*f**10 + 112616504*f**11 + 7455448*f**12))/5.256269770752e14,
    77: lambda f: -(f**2*(64017954 + 503783423*f + 2236019503*f**2 + 6962439420*f**3 + 15470588880*f**4 + 24389241576*f**5 + 27400414860*f**6 + 22051487836*f**7 + 12657288980*f**8 + 5070313710*f**9 + 1348255678*f**10 + 213853640*f**11 + 15303288*f**12))/6.424329719808e14,
    78: lambda f: -(f**2*(17551820 + 149358430*f + 717825510*f**2 + 2424714165*f**3 + 5531083920*f**4 + 8333951472*f**5 + 8344450296*f**6 + 5581216620*f**7 + 2466865800*f**8 + 692431740*f**9 + 111941676*f**10 + 7945938*f**11))/4.0548366802944e15,
    79: lambda f: -(f**2*(143232089 + 1265830540*f + 6339401490*f**2 + 22382683905*f**3 + 55446340455*f**4 + 94689646968*f**5 + 111760471704*f**6 + 91740183948*f**7 + 52262702730*f**8 + 20285329680*f**9 + 5123645604*f**10 + 760161402*f**11 + 50324274*f**12))/2.83838567620608e16,
    80: lambda f: (f**2*(711310600 + 6240595790*f + 31039933395*f**2 + 108977310765*f**3 + 265623668235*f**4 + 445395921264*f**5 + 520728728940*f**6 + 430100475084*f**7 + 251119185660*f**8 + 101705386860*f**9 + 27221299182*f**10 + 4330536210*f**11 + 309891582*f**12))/1.040741414608896e17,
    81: lambda f: (f**2*(1939938 + 18269849*f + 97652590*f**2 + 368980665*f**3 + 908138250*f**4 + 1431054954*f**5 + 1470794472*f**6 + 998977140*f**7 + 445489380*f**8 + 125645310*f**9 + 20353032*f**10 + 1444716*f**11))/7.372430327808e15,
    82: lambda f: (f**2*(46823049 + 456229748*f + 2529785096*f**2 + 9940940315*f**3 + 26653769145*f**4 + 47866553217*f**5 + 58280215644*f**6 + 48776240268*f**7 + 28125948690*f**8 + 10998196020*f**9 + 2789587836*f**10 + 414633492*f**11 + 27449604*f**12))/1.54821036883968e17,
    83: lambda f: -(f**2*(78244166 + 757268655*f + 4172427436*f**2 + 16308013215*f**3 + 42870142890*f**4 + 75319676838*f**5 + 90625469130*f**6 + 76226287788*f**7 + 45030755700*f**8 + 18374498730*f**9 + 4939523694*f**10 + 787370220*f**11 + 56343924*f**12))/1.89225711747072e17,
    84: lambda f: -(f**2*(386308 + 3989050*f + 23471118*f**2 + 98087025*f**3 + 256976900*f**4 + 419227004*f**5 + 439367922*f**6 + 301804965*f**7 + 135460080*f**8 + 38336760*f**9 + 6218982*f**10 + 441441*f**11))/2.7032244535296e16,
    85: lambda f: -(f**2*(18429411 + 196278056*f + 1193788620*f**2 + 5167434750*f**3 + 14801056050*f**4 + 27649418804*f**5 + 34464206588*f**6 + 29259941886*f**7 + 17022142305*f**8 + 6692079240*f**9 + 1702509732*f**10 + 253387134*f**11 + 16774758*f**12))/1.135354270482432e18,
    86: lambda f: (f**2*(15519504 + 164256482*f + 993129715*f**2 + 4276977045*f**3 + 11971609205*f**4 + 21813719788*f**5 + 26820429405*f**6 + 22863717513*f**7 + 13622806575*f**8 + 5588809380*f**9 + 1507159269*f**10 + 240585345*f**11 + 17216199*f**12))/6.93827609739264e17,
    87: lambda f: (f**2*(30022850 + 337293073*f + 2166331284*f**2 + 9920767350*f**3 + 27385290900*f**4 + 45924066804*f**5 + 48864578532*f**6 + 33855865890*f**7 + 15270192630*f**8 + 4332875085*f**9 + 703633392*f**10 + 49945896*f**11))/4.281907534390886e19,
    88: lambda f: (f**2*(236349113 + 2731533480*f + 18081339094*f**2 + 85484963590*f**3 + 258931130370*f**4 + 499258345894*f**5 + 633812943148*f**6 + 544055174586*f**7 + 318646136655*f**8 + 125782777890*f**9 + 32072812002*f**10 + 4778157384*f**11 + 316324008*f**12))/2.9973352740736205e20,
    89: lambda f: -(f**2*(1202114914 + 13812312371*f + 90925158597*f**2 + 427795253730*f**3 + 1262485512480*f**4 + 2368478127708*f**5 + 2961563739750*f**6 + 2550784637478*f**7 + 1529753321250*f**8 + 630159754455*f**9 + 170342742339*f**10 + 27220513320*f**11 + 1947889944*f**12))/1.0990229338269942e21,
    90: lambda f: -(f**2*(383724 + 4659598*f + 32437598*f**2 + 161537145*f**3 + 466111800*f**4 + 799369224*f**5 + 860880372*f**6 + 600530370*f**7 + 271902180*f**8 + 77308110*f**9 + 12564882*f**10 + 891891*f**11))/1.2234021526831104e19,
    91: lambda f: -(f**2*(8985537 + 111999604*f + 801580702*f**2 + 4109801935*f**3 + 13059018345*f**4 + 25841472972*f**5 + 33290828844*f**6 + 28826263158*f**7 + 16972843965*f**8 + 6721249920*f**9 + 1716867306*f**10 + 255972717*f**11 + 16945929*f**12))/2.569144520634532e20,
    92: lambda f: (f**2*(15320536 + 189922062*f + 1352216567*f**2 + 6901048425*f**3 + 21306622515*f**4 + 40936408968*f**5 + 51881573730*f**6 + 45050894658*f**7 + 27156560970*f**8 + 11222656830*f**9 + 3039312969*f**10 + 486080595*f**11 + 34783749*f**12))/3.1400655252199834e20,
    93: lambda f: (f**2*(1030370 + 13448105*f + 100863210*f**2 + 542673915*f**3 + 1626604630*f**4 + 2841885046*f**5 + 3090840228*f**6 + 2167989810*f**7 + 984639810*f**8 + 280412055*f**9 + 45605868*f**10 + 3237234*f**11))/7.992894064196321e20,
    94: lambda f: (f**2*(23950773 + 320267420*f + 2464341420*f**2 + 13619280465*f**3 + 45107239275*f**4 + 91210153055*f**5 + 118922875736*f**6 + 103704199662*f**7 + 61322386965*f**8 + 24345956250*f**9 + 6227762310*f**10 + 929086158*f**11 + 61507446*f**12))/1.6785077534812275e22,
    95: lambda f: -(f**2*(41037150 + 545936215*f + 4180230470*f**2 + 23000847765*f**3 + 73835653570*f**4 + 144701107082*f**5 + 185420928420*f**6 + 162075077262*f**7 + 98102871090*f**8 + 40646407725*f**9 + 11024258091*f**10 + 1764292530*f**11 + 126252126*f**12))/2.051509476477056e22,
}

Q120withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: -(f*(14 + 19*f + 12*f**2 + 3*f**3))/42.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/252.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: -(f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/11088.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/864864.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: -(f*(30030 + 143715*f + 414700*f**2 + 825175*f**3 + 1194500*f**4 + 1300454*f**5 + 1078112*f**6 + 670390*f**7 + 300510*f**8 + 91035*f**9 + 16632*f**10 + 1386*f**11))/3.459456e7,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 695829*f**5 + 716912*f**6 + 530740*f**7 + 269010*f**8 + 87885*f**9 + 16632*f**10 + 1386*f**11))/6.918912e7,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: -(f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 220761*f**5 + 258248*f**6 + 207835*f**7 + 110790*f**8 + 37215*f**9 + 7128*f**10 + 594*f**11))/1.1860992e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 3016468*f**5 + 3830624*f**6 + 3235960*f**7 + 1772820*f**8 + 604170*f**9 + 116424*f**10 + 9702*f**11))/1.162377216e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: -(f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1786692*f**5 + 2402176*f**6 + 2094260*f**7 + 1167180*f**8 + 401310*f**9 + 77616*f**10 + 6468*f**11))/6.199345152e10,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (f*(10010 + 90805*f + 514800*f**2 + 2120950*f**3 + 6761750*f**4 + 14783193*f**5 + 20724704*f**6 + 18471880*f**7 + 10416420*f**8 + 3602970*f**9 + 698544*f**10 + 58212*f**11))/5.5794106368e12,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: -(f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1262063*f**5 + 1826664*f**6 + 1654905*f**7 + 941220*f**8 + 326970*f**9 + 63504*f**10 + 5292*f**11))/6.0866297856e12,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1888914*f**5 + 2803472*f**6 + 2571940*f**7 + 1472310*f**8 + 513135*f**9 + 99792*f**10 + 8316*f**11))/1.339058552832e14,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: -(f*(546 + 6357*f + 46644*f**2 + 251641*f**3 + 1064180*f**4 + 2725326*f**5 + 4127648*f**6 + 3824590*f**7 + 2200590*f**8 + 768915*f**9 + 149688*f**10 + 12474*f**11))/3.2137405267968e15,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 460987*f**5 + 709936*f**6 + 663140*f**7 + 383130*f**8 + 134145*f**9 + 26136*f**10 + 2178*f**11))/1.01003273699328e16,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: -(f*(2310 + 30855*f + 260700*f**2 + 1627925*f**3 + 8013250*f**4 + 22000083*f**5 + 34357624*f**6 + 32307905*f**7 + 18729270*f**8 + 6568695*f**9 + 1280664*f**10 + 106722*f**11))/9.898320822534144e18,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: -(f*(14 + 19*f + 12*f**2 + 3*f**3))/63.,
    52: lambda f: (f*(56 + 73*f + 42*f**2 + 9*f**3))/126.,
    53: lambda f: 0,
    54: lambda f: (f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/252.,
    55: lambda f: -(f*(924 + 2013*f + 2332*f**2 + 1550*f**3 + 560*f**4 + 85*f**5))/2772.,
    56: lambda f: 0,
    57: lambda f: -(f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/8316.,
    58: lambda f: (f*(48048 + 146289*f + 253110*f**2 + 279487*f**3 + 201860*f**4 + 92775*f**5 + 24710*f**6 + 2905*f**7))/432432.,
    59: lambda f: 0,
    60: lambda f: (5*f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/2.594592e6,
    61: lambda f: -(f*(60060 + 234663*f + 538824*f**2 + 828932*f**3 + 893680*f**4 + 681498*f**5 + 361816*f**6 + 127652*f**7 + 26964*f**8 + 2583*f**9))/2.594592e6,
    62: lambda f: 0,
    63: lambda f: -(f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 257134*f**5 + 206752*f**6 + 122990*f**7 + 52710*f**8 + 15435*f**9 + 2772*f**10 + 231*f**11))/3.459456e6,
    64: lambda f: (f*(408408 + 1947231*f + 5566990*f**2 + 10964915*f**3 + 15691000*f**4 + 16673022*f**5 + 13213844*f**6 + 7732830*f**7 + 3252480*f**8 + 931875*f**9 + 163086*f**10 + 13167*f**11))/1.17621504e8,
    65: lambda f: 0,
    66: lambda f: (f*(102102 + 576147*f + 1983696*f**2 + 4794374*f**3 + 8614750*f**4 + 11829093*f**5 + 12571888*f**6 + 10367924*f**7 + 6591186*f**8 + 3175725*f**9 + 1123584*f**10 + 275814*f**11 + 42042*f**12 + 3003*f**13))/5.0409216e8,
    67: lambda f: -(f*(27159132 + 152839401*f + 522674724*f**2 + 1253913778*f**3 + 2234643200*f**4 + 3040883823*f**5 + 3199917224*f**6 + 2610171676*f**7 + 1639270332*f**8 + 779126775*f**9 + 271444404*f**10 + 65470482*f**11 + 9777768*f**12 + 681681*f**13))/6.704425728e10,
    68: lambda f: 0,
    69: lambda f: -(f*(58344 + 379236*f + 1516944*f**2 + 4313036*f**3 + 9252760*f**4 + 15334884*f**5 + 19683424*f**6 + 19380572*f**7 + 14395608*f**8 + 7878600*f**9 + 3067812*f**10 + 802197*f**11 + 126126*f**12 + 9009*f**13))/3.02455296e9,
    70: lambda f: (f*(31039008 + 201337851*f + 801194394*f**2 + 2265171545*f**3 + 4829541220*f**4 + 7949275803*f**5 + 10119278134*f**6 + 9860017601*f**7 + 7228939032*f**8 + 3894693705*f**9 + 1489227894*f**10 + 381565107*f**11 + 58666608*f**12 + 4090086*f**13))/8.0453108736e11,
    71: lambda f: 0,
    72: lambda f: (f*(102102 + 751179*f + 3422848*f**2 + 11189672*f**3 + 27898360*f**4 + 53625684*f**5 + 78436064*f**6 + 85781752*f**7 + 68963188*f**8 + 39937450*f**9 + 16152752*f**10 + 4321702*f**11 + 686686*f**12 + 49049*f**13))/6.586804224e10,
    73: lambda f: -(f*(11639628 + 85495839*f + 387987600*f**2 + 1262756872*f**3 + 3133203360*f**4 + 5988837316*f**5 + 8691860688*f**6 + 9403370872*f**7 + 7453921944*f**8 + 4243694490*f**9 + 1683206448*f**10 + 440781264*f**11 + 68444376*f**12 + 4771767*f**13))/3.75447840768e12,
    74: lambda f: 0,
    75: lambda f: -(f*(170170 + 1397825*f + 7147140*f**2 + 26406185*f**3 + 75014200*f**4 + 162424596*f**5 + 260965376*f**6 + 305492068*f**7 + 257443452*f**8 + 153877150*f**9 + 63511448*f**10 + 17195178*f**11 + 2746744*f**12 + 196196*f**13))/1.58083301376e12,
    76: lambda f: (f*(12932920 + 106096133*f + 540688434*f**2 + 1990506557*f**3 + 5632784080*f**4 + 12137651364*f**5 + 19352682104*f**6 + 22399575604*f**7 + 18597767328*f**8 + 10918961158*f**9 + 4416249068*f**10 + 1169579334*f**11 + 182518336*f**12 + 12724712*f**13))/6.007165452288e13,
    77: lambda f: 0,
    78: lambda f: (f*(34034 + 308737*f + 1750320*f**2 + 7211230*f**3 + 22989950*f**4 + 54869013*f**5 + 94556000*f**6 + 116034856*f**7 + 100867284*f**8 + 61515090*f**9 + 25712064*f**10 + 7011900*f**11 + 1123668*f**12 + 80262*f**13))/5.17363531776e12,
    79: lambda f: -(f*(14226212 + 128913499*f + 728862420*f**2 + 2994012970*f**3 + 9514934000*f**4 + 22611451239*f**5 + 38667873104*f**6 + 46897281592*f**7 + 40142229624*f**8 + 24033296070*f**9 + 9838953432*f**10 + 2623673052*f**11 + 410666256*f**12 + 28630602*f**13))/1.08128978141184e15,
    80: lambda f: 0,
    81: lambda f: -(f*(9282 + 92157*f + 573716*f**2 + 2607579*f**3 + 9218250*f**4 + 23854111*f**5 + 43387176*f**6 + 55108473*f**7 + 48966372*f**8 + 30280950*f**9 + 12766068*f**10 + 3498453*f**11 + 561834*f**12 + 40131*f**13))/2.58681765888e13,
    82: lambda f: (f*(1410864 + 13995267*f + 86927698*f**2 + 394113941*f**3 + 1389578300*f**4 + 3581753137*f**5 + 6464236506*f**6 + 8111891319*f**7 + 7094305008*f**8 + 4305120750*f**9 + 1777069476*f**10 + 476076258*f**11 + 74666592*f**12 + 5205564*f**13))/1.9659814207488e15,
    83: lambda f: 0,
    84: lambda f: (f*(120666 + 1301469*f + 8825856*f**2 + 43864964*f**3 + 170289340*f**4 + 471736842*f**5 + 895436752*f**6 + 1167505556*f**7 + 1054394334*f**8 + 658710675*f**9 + 279439776*f**10 + 76848156*f**11 + 12360348*f**12 + 882882*f**13))/6.8291986194432e15,
    85: lambda f: -(f*(4585308 + 49418031*f + 334475544*f**2 + 1658856940*f**3 + 6425451920*f**4 + 17735271726*f**5 + 33400680488*f**6 + 43013599132*f**7 + 38222361324*f**8 + 23425094385*f**9 + 9727402608*f**10 + 2614666824*f**11 + 410666256*f**12 + 28630602*f**13))/1.297547737694208e17,
    86: lambda f: 0,
    87: lambda f: -(f*(9282 + 108069*f + 792948*f**2 + 4277897*f**3 + 18091060*f**4 + 53116398*f**5 + 104365408*f**6 + 138897374*f**7 + 127023246*f**8 + 79973775*f**9 + 34087284*f**10 + 9399159*f**11 + 1513512*f**12 + 108108*f**13))/1.17071976333312e16,
    88: lambda f: (f*(54318264 + 632004087*f + 4629523470*f**2 + 24930592531*f**3 + 105227443880*f**4 + 307902689946*f**5 + 600183747548*f**6 + 788767991242*f**7 + 709570772064*f**8 + 438157777365*f**9 + 182773667538*f**10 + 49252073409*f**11 + 7743992256*f**12 + 539891352*f**13))/3.425526027512709e19,
    89: lambda f: 0,
    90: lambda f: (f*(5610 + 70125*f + 553520*f**2 + 3221330*f**3 + 14739850*f**4 + 45502999*f**5 + 91986544*f**6 + 124459892*f**7 + 114958338*f**8 + 72821925*f**9 + 31154112*f**10 + 8608182*f**11 + 1387386*f**12 + 99099*f**13))/1.717055652888576e17,
    91: lambda f: -(f*(1492260 + 18642591*f + 146937868*f**2 + 853785254*f**3 + 3900134560*f**4 + 12001263645*f**5 + 24066787304*f**6 + 32149152252*f**7 + 29204462364*f**8 + 18140966151*f**9 + 7594266372*f**10 + 2050449786*f**11 + 322666344*f**12 + 22495473*f**13))/2.283684018341806e19,
    92: lambda f: 0,
    93: lambda f: -(f*(62832 + 839256*f + 7091040*f**2 + 44279560*f**3 + 217960400*f**4 + 702904440*f**5 + 1455216896*f**6 + 1995798616*f**7 + 1858402224*f**8 + 1183064820*f**9 + 507640980*f**10 + 140499513*f**11 + 22660638*f**12 + 1618617*f**13))/5.0481436194924134e19,
    94: lambda f: (f*(4775232 + 63751479*f + 537959730*f**2 + 3354592405*f**3 + 16488342500*f**4 + 53010806835*f**5 + 108860640182*f**6 + 147379977409*f**7 + 134945227368*f**8 + 84226758315*f**9 + 35360378130*f**10 + 9562344561*f**11 + 1505776272*f**12 + 104978874*f**13))/1.918294575407117e21,
    95: lambda f: 0,
}

Q122withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (-21 - 44*f - 58*f**2 - 36*f**3 - 9*f**4)/168.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (231 + 726*f + 1551*f**2 + 1868*f**3 + 1317*f**4 + 510*f**5 + 85*f**6)/5544.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (-9009 - 37752*f - 111540*f**2 - 198744*f**3 - 228766*f**4 - 172520*f**5 - 82980*f**6 - 23240*f**7 - 2905*f**8)/1.153152e6,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (9009 + 47190*f + 178035*f**2 + 419640*f**3 + 668810*f**4 + 746356*f**5 + 588390*f**6 + 322840*f**7 + 117845*f**8 + 25830*f**9 + 2583*f**10)/8.64864e6,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (-255255 - 1604460*f - 7365930*f**2 - 21591700*f**3 - 43936925*f**4 - 64830520*f**5 - 71694428*f**6 - 60174184*f**7 - 37759505*f**8 - 17031420*f**9 - 5179230*f**10 - 948024*f**11 - 79002*f**12)/2.35243008e9,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (21879 + 160446*f + 867867*f**2 + 3041844*f**3 + 7529011*f**4 + 13807706*f**5 + 19274679*f**6 + 20098232*f**7 + 14996485*f**8 + 7637490*f**9 + 2501793*f**10 + 474012*f**11 + 39501*f**12)/2.35243008e9,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (-153153 - 1283568*f - 7993128*f**2 - 32598384*f**3 - 95019596*f**4 - 208246192*f**5 - 343517496*f**6 - 406397488*f**7 - 329343350*f**8 - 176274000*f**9 - 59340456*f**10 - 11376288*f**11 - 948024*f**12)/2.2583328768e11,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (17017 + 160446*f + 1130415*f**2 + 5258032*f**3 + 17636548*f**4 + 44952488*f**5 + 83996108*f**6 + 107800784*f**7 + 91643230*f**8 + 50388660*f**9 + 17205174*f**10 + 3318084*f**11 + 276507*f**12)/3.9520825344e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (-51051 - 534820*f - 4205630*f**2 - 21971820*f**3 - 83346155*f**4 - 242180368*f**5 - 498279240*f**6 - 676666480*f**7 - 593409110*f**8 - 331826040*f**9 - 114291324*f**10 - 22120560*f**11 - 1843380*f**12)/2.10777735168e13,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (23205 + 267410*f + 2321605*f**2 + 13458900*f**3 + 56961475*f**4 + 185829890*f**5 + 412751163*f**6 + 584191664*f**7 + 523590130*f**8 + 296184420*f**9 + 102616290*f**10 + 19908504*f**11 + 1659042*f**12)/1.896999616512e14,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (-4641 - 58344*f - 554268*f**2 - 3530696*f**3 - 16492074*f**4 - 59682648*f**5 - 141073852*f**6 - 206066616*f**7 - 187684455*f**8 - 107064720*f**9 - 37251144*f**10 - 7239456*f**11 - 603288*f**12)/8.277816508416e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (1071 + 14586*f + 150501*f**2 + 1044888*f**3 + 5339122*f**4 + 21224228*f**5 + 52823214*f**6 + 79096472*f**7 + 72936325*f**8 + 41872950*f**9 + 14615559*f**10 + 2844072*f**11 + 237006*f**12)/4.5527990796288e15,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (-21879 - 320892*f - 3573570*f**2 - 26856804*f**3 - 149011681*f**4 - 645441992*f**5 - 1677660132*f**6 - 2562850136*f**7 - 2386491415*f**8 - 1376977140*f**9 - 481830426*f**10 - 93854376*f**11 - 7821198*f**12)/2.4038779140440064e18,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (3927 + 61710*f + 737715*f**2 + 5966660*f**3 + 35722015*f**4 + 167452754*f**5 + 451676155*f**6 + 701450120*f**7 + 658387555*f**8 + 381420270*f**9 + 133734447*f**10 + 26070660*f**11 + 2172555*f**12)/1.2019389570220032e19,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (-58905 - 987360*f - 12611280*f**2 - 109221600*f**3 - 701797400*f**4 - 3539707360*f**5 - 9858019248*f**6 - 15521918944*f**7 - 14665044380*f**8 - 8524141920*f**9 - 2993684400*f**10 - 583982784*f**11 - 48665232*f**12)/5.384686527458574e21,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (-35 + 2*f + 91*f**2 + 100*f**3 + 32*f**4)/1680.,
    52: lambda f: (-245 - 462*f - 545*f**2 - 300*f**3 - 66*f**4)/1176.,
    53: lambda f: (8085 + 16786*f + 19283*f**2 + 10820*f**3 + 2176*f**4)/129360.,
    54: lambda f: (1155 + 1144*f - 2794*f**2 - 8380*f**3 - 8897*f**4 - 4460*f**5 - 880*f**6)/110880.,
    55: lambda f: (8085 + 23716*f + 47168*f**2 + 52700*f**3 + 34341*f**4 + 12240*f**5 + 1870*f**6)/77616.,
    56: lambda f: (-105105 - 328328*f - 654082*f**2 - 759980*f**3 - 511461*f**4 - 185980*f**5 - 27840*f**6)/3.36336e6,
    57: lambda f: (-45045 - 91806*f + 23595*f**2 + 461760*f**3 + 952577*f**4 + 1006450*f**5 + 611385*f**6 + 203980*f**7 + 29120*f**8)/1.729728e7,
    58: lambda f: (-315315 - 1255254*f - 3518229*f**2 - 5935800*f**3 - 6456811*f**4 - 4591670*f**5 - 2077815*f**6 - 546140*f**7 - 63910*f**8)/1.2108096e7,
    59: lambda f: (105105 + 438438*f + 1237665*f**2 + 2167360*f**3 + 2454579*f**4 + 1816470*f**5 + 850475*f**6 + 228900*f**7 + 26880*f**8)/1.345344e7,
    60: lambda f: (15015 + 46332*f + 46332*f**2 - 133640*f**3 - 553582*f**4 - 966800*f**5 - 1020100*f**6 - 693560*f**7 - 299425*f**8 - 75180*f**9 - 8400*f**10)/3.459456e7,
    61: lambda f: (105105 + 528528*f + 1912482*f**2 + 4318600*f**3 + 6586006*f**4 + 7023496*f**5 + 5283944*f**6 + 2762648*f**7 + 959441*f**8 + 199752*f**9 + 18942*f**10)/2.4216192e7,
    62: lambda f: (-5360355 - 27975948*f - 102072828*f**2 - 238282200*f**3 - 377653402*f**4 - 419341040*f**5 - 328187340*f**6 - 178025960*f**7 - 63851515*f**8 - 13631940*f**9 - 1310400*f**10)/4.11675264e9,
    63: lambda f: (-765765 - 3165162*f - 6439719*f**2 + 198900*f**3 + 34711790*f**4 + 97981540*f**5 + 155370642*f**6 + 163957024*f**7 + 120056615*f**8 + 60772950*f**9 + 20411685*f**10 + 4110876*f**11 + 376992*f**12)/1.411458048e10,
    64: lambda f: (-5360355 - 32570538*f - 144452451*f**2 - 408739500*f**3 - 802234420*f**4 - 1140739100*f**5 - 1200311862*f**6 - 939355424*f**7 - 541754395*f**8 - 224309610*f**9 - 63248535*f**10 - 10902276*f**11 - 869022*f**12)/9.880206336e9,
    65: lambda f: (101846745 + 638239602*f + 2854064499*f**2 + 8317799100*f**3 + 16911204410*f**4 + 24972376780*f**5 + 27300376518*f**6 + 22182995296*f**7 + 13262794685*f**8 + 5679068850*f**9 + 1650374775*f**10 + 291772404*f**11 + 23683968*f**12)/6.2574640128e11,
    66: lambda f: (14549535 + 75380448*f + 224755674*f**2 + 270835500*f**3 - 463159067*f**4 - 2776385260*f**5 - 6428200308*f**6 - 9561820744*f**7 - 10093994855*f**8 - 7790921208*f**9 - 4399379670*f**10 - 1778322084*f**11 - 489097917*f**12 - 82222140*f**13 - 6390384*f**14)/2.6817702912e12,
    67: lambda f: (101846745 + 725536812*f + 3810592500*f**2 + 12961053300*f**3 + 31113839671*f**4 + 55307122040*f**5 + 74783927838*f**6 + 77946126440*f**7 + 62820985255*f**8 + 38912019804*f**9 + 18218238360*f**10 + 6248042724*f**11 + 1483245225*f**12 + 218137920*f**13 + 14996982*f**14)/1.87723920384e12,
    68: lambda f: (-33948915 - 248312064*f - 1314446562*f**2 - 4590430780*f**3 - 11378709569*f**4 - 20940677860*f**5 - 29342526956*f**6 - 31695037528*f**7 - 26459474405*f**8 - 16959418056*f**9 - 8204683410*f**10 - 2901948588*f**11 - 708663879*f**12 - 106846740*f**13 - 7495488*f**14)/2.0858213376e12,
    69: lambda f: (-4849845 - 30207606*f - 117366249*f**2 - 245725480*f**3 - 113857177*f**4 + 977000710*f**5 + 3720819571*f**6 + 7698694108*f**7 + 10669867985*f**8 + 10294074966*f**9 + 6913913265*f**10 + 3166110948*f**11 + 942381594*f**12 + 164444280*f**13 + 12780768*f**14)/1.07270811648e13,
    70: lambda f: (-33948915 - 277411134*f - 1683727617*f**2 - 6689846800*f**3 - 18989300169*f**4 - 40508641250*f**5 - 66363948581*f**6 - 83618177580*f**7 - 80270077195*f**8 - 57805024578*f**9 - 30550231215*f**10 - 11460369228*f**11 - 2883933360*f**12 - 436275840*f**13 - 29993964*f**14)/7.50895681536e12,
    71: lambda f: (101846745 + 851632782*f + 5207209293*f**2 + 21187650120*f**3 + 61925916269*f**4 + 136375041250*f**5 + 231171234273*f**6 + 302088549364*f**7 + 301201493915*f**8 + 225263629458*f**9 + 123426631755*f**10 + 47858488524*f**11 + 12400690302*f**12 + 1923241320*f**13 + 134918784*f**14)/7.50895681536e13,
    72: lambda f: (14549535 + 105865188*f + 504383880*f**2 + 1438073520*f**3 + 2118630644*f**4 - 1015098560*f**5 - 15939216888*f**6 - 47767270544*f**7 - 81973506790*f**8 - 90430510968*f**9 - 66094090020*f**10 - 31877298684*f**11 - 9769656897*f**12 - 1726664940*f**13 - 134198064*f**14)/4.505374089216e14,
    73: lambda f: (101846745 + 938929992*f + 6466367622*f**2 + 29391320400*f**3 + 96301996508*f**4 + 239687524720*f**5 + 456111787488*f**6 + 653793691600*f**7 + 694591663430*f**8 + 539144401824*f**9 + 300389707800*f**10 + 116708870124*f**11 + 29992350465*f**12 + 4580896320*f**13 + 314936622*f**14)/3.1537618624512e14,
    74: lambda f: (-101846745 - 958329372*f - 6645673320*f**2 - 30866681040*f**3 - 103881752236*f**4 - 266235824960*f**5 - 524005515768*f**6 - 780507939344*f**7 - 863747107510*f**8 - 698104238328*f**9 - 403983068580*f**10 - 162398692764*f**11 - 42987946617*f**12 - 6731344620*f**13 - 472215744*f**14)/1.0512539541504e15,
    75: lambda f: (-4849845 - 40369186*f - 227203691*f**2 - 805452180*f**3 - 1769015444*f**4 - 1658527480*f**5 + 6071725956*f**6 + 29545841248*f**7 + 60364064810*f**8 + 72761640756*f**9 + 55885847990*f**10 + 27727880488*f**11 + 8628428424*f**12 + 1534813280*f**13 + 119287168*f**14)/2.4028661809152e15,
    76: lambda f: (-33948915 - 348542194*f - 2685382271*f**2 - 13742067300*f**3 - 51046314698*f**4 - 145206528568*f**5 - 311310810348*f**6 - 489012007904*f**7 - 554324585458*f**8 - 449704606764*f**9 - 258008968546*f**10 - 102130103768*f**11 - 26531444940*f**12 - 4071907840*f**13 - 279943664*f**14)/1.68200632664064e15,
    77: lambda f: (11316305 + 118336218*f + 917636863*f**2 + 4789799300*f**3 + 18236697572*f**4 + 53298785560*f**5 + 118233310732*f**6 + 193416652576*f**7 + 228926645150*f**8 + 193733786652*f**9 + 115574855970*f**10 + 47361684216*f**11 + 12675766488*f**12 + 1994472480*f**13 + 139915776*f**14)/1.8688959184896e15,
    78: lambda f: (1616615 + 15149992*f + 98197814*f**2 + 412761700*f**3 + 1157879095*f**4 + 1985849220*f**5 - 1528084424*f**6 - 16869940080*f**7 - 39903225810*f**8 - 51209757312*f**9 - 40632978540*f**10 - 20522537112*f**11 - 6446251350*f**12 - 1151109960*f**13 - 89465376*f**14)/1.44171970854912e16,
    79: lambda f: (11316305 + 128035908*f + 1091168936*f**2 + 6208221500*f**3 + 25780779565*f**4 + 82506086400*f**5 + 194856797974*f**6 + 327513226544*f**7 + 388187526930*f**8 + 324168423096*f**9 + 189472010280*f**10 + 75872576472*f**11 + 19840793742*f**12 + 3053930880*f**13 + 209957748*f**14)/1.009203795984384e16,
    80: lambda f: (-33948915 - 390574184*f - 3348794878*f**2 - 19403998900*f**3 - 82441197315*f**4 - 270544716020*f**5 - 661697905032*f**6 - 1160696642000*f**7 - 1439183114950*f**8 - 1255325029056*f**9 - 763498475460*f**10 - 316627758216*f**11 - 85312742130*f**12 - 13462689240*f**13 - 944431488*f**14)/1.009203795984384e17,
    81: lambda f: (-440895 - 4593706*f - 33663383*f**2 - 162921200*f**3 - 546951081*f**4 - 1256621810*f**5 - 113530073*f**6 + 7411328036*f**7 + 19878795370*f**8 + 26727901452*f**9 + 21699449730*f**10 + 11094702696*f**11 + 3507020748*f**12 + 627878160*f**13 + 48799296*f**14)/7.8639256829952e16,
    82: lambda f: (-3086265 - 38152114*f - 356348135*f**2 - 2231348600*f**3 - 10243634597*f**4 - 36426218410*f**5 - 93182919097*f**6 - 164941173460*f**7 - 201934317620*f**8 - 172098779076*f**9 - 101885649390*f**10 - 41121404856*f**11 - 10801236600*f**12 - 1665780480*f**13 - 114522408*f**14)/5.50474797809664e16,
    83: lambda f: (3086265 + 38739974*f + 363897937*f**2 + 2317512080*f**3 + 10867855999*f**4 + 39561198270*f**5 + 104923401567*f**6 + 194195444996*f**7 + 249094741210*f**8 + 221954851692*f**9 + 136807964370*f**10 + 57197336616*f**11 + 15481264428*f**12 + 2447761680*f**13 + 171714816*f**14)/1.83491599269888e17,
    84: lambda f: (1322685 + 15166788*f + 123904092*f**2 + 676710840*f**3 + 2623335586*f**4 + 7331815760*f**5 + 3909863244*f**6 - 34114284568*f**7 - 102115537685*f**8 - 142322769036*f**9 - 117529957440*f**10 - 60630331608*f**11 - 19252799874*f**12 - 3453329880*f**13 - 268396128*f**14)/5.190190950776832e18,
    85: lambda f: (9258795 + 124156032*f + 1261186446*f**2 + 8618867400*f**3 + 43343355142*f**4 + 169545167720*f**5 + 463753564536*f**6 + 855005721080*f**7 + 1072756303045*f**8 + 928137267288*f**9 + 554637782790*f**10 + 225132010488*f**11 + 59324244210*f**12 + 9161792640*f**13 + 629873244*f**14)/3.6331336655437824e18,
    86: lambda f: (-33948915 - 461705244*f - 4715157876*f**2 - 32735236040*f**3 - 167926752318*f**4 - 671425758960*f**5 - 1906446934612*f**6 - 3681391258776*f**7 - 4845312880485*f**8 - 4386218624172*f**9 - 2730073111920*f**10 - 1148130461016*f**11 - 311771293218*f**12 - 49363193880*f**13 - 3462915456*f**14)/4.44049670233129e19,
    87: lambda f: (-4849845 - 60692346*f - 546646815*f**2 - 3319981340*f**3 - 14527372678*f**4 - 47177192660*f**5 - 38517739018*f**6 + 184489767616*f**7 + 608550315065*f**8 + 872724953562*f**9 + 730215117555*f**10 + 379263856356*f**11 + 120848760648*f**12 + 21706644960*f**13 + 1687061376*f**14)/4.567368036683612e20,
    88: lambda f: (-33948915 - 490804314*f - 5387069259*f**2 - 39897638300*f**3 - 218120850896*f**4 - 930801315860*f**5 - 2695002118402*f**6 - 5134414922560*f**7 - 6566772343285*f**8 - 5747741396166*f**9 - 3459314345025*f**10 - 1410232832316*f**11 - 372506051610*f**12 - 57588410880*f**13 - 3959203248*f**14)/3.1971576256785285e20,
    89: lambda f: (101846745 + 1491812322*f + 16456909755*f**2 + 123695233740*f**3 + 688975086046*f**4 + 3001257336740*f**5 + 9032200260786*f**6 + 18049806893888*f**7 + 24240905902675*f**8 + 22213085993406*f**9 + 13929148402785*f**10 + 5884038465228*f**11 + 1601720427384*f**12 + 253867854240*f**13 + 17809279488*f**14)/3.1971576256785285e21,
    90: lambda f: (1119195 + 15178416*f + 149375226*f**2 + 997507980*f**3 + 4849232269*f**4 + 17814554660*f**5 + 18158558628*f**6 - 60773179096*f**7 - 218653159445*f**8 - 320936078232*f**9 - 271343463930*f**10 - 141686962956*f**11 - 45269040663*f**12 - 8139991860*f**13 - 632648016*f**14)/2.7404208220101673e21,
    91: lambda f: (7834365 + 121469964*f + 1432612236*f**2 + 11430033300*f**3 + 67495921423*f**4 + 312037191368*f**5 + 948710896854*f**6 + 1856833536824*f**7 + 2411668965013*f**8 + 2130360893892*f**9 + 1289384845056*f**10 + 527413202316*f**11 + 139576253355*f**12 + 21595654080*f**13 + 1484701218*f**14)/1.918294575407117e21,
    92: lambda f: (-7834365 - 122962224*f - 1457149254*f**2 - 11788175700*f**3 - 70844435291*f**4 - 333935546140*f**5 - 1056670929132*f**6 - 2172143909656*f**7 - 2964918196205*f**8 - 2743290301752*f**9 - 1730344970970*f**10 - 733498872876*f**11 - 200052226143*f**12 - 31733481780*f**13 - 2226159936*f**14)/6.394315251357057e21,
    93: lambda f: (-1119195 - 16350906*f - 174519807*f**2 - 1269971400*f**3 - 6778447315*f**4 - 27676426190*f**5 - 32518497207*f**6 + 84395607268*f**7 + 328406064665*f**8 + 491394702582*f**9 + 418999708785*f**10 + 219733696644*f**11 + 70357225554*f**12 + 12662209560*f**13 + 984119136*f**14)/7.673178301628468e22,
    94: lambda f: (-7834365 - 129677394*f - 1635484983*f**2 - 13984608000*f**3 - 88708133755*f**4 - 441654582950*f**5 - 1400994502383*f**6 - 2804492333972*f**7 - 3688728920695*f**8 - 3282851621826*f**9 - 1995942292575*f**10 - 818648311404*f**11 - 216977351976*f**12 - 33593239680*f**13 - 2309535228*f**14)/5.371224811139928e22,
    95: lambda f: (33948915 + 568401834*f + 7201188423*f**2 + 62386222600*f**3 + 402355785035*f**4 + 2040326920030*f**5 + 6744507785183*f**6 + 14196213827068*f**7 + 19637287652255*f**8 + 18312688647162*f**9 + 11605641633495*f**10 + 4933508543964*f**11 + 1347622129854*f**12 + 213907173480*f**13 + 15005966976*f**14)/7.758435838313229e23,
}

Q124withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: -(f*(66 + 101*f + 68*f**2 + 17*f**3))/693.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/18018.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: -(f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/24024.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/7.351344e6,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: -(f*(1385670 + 7831135*f + 25872300*f**2 + 57017575*f**3 + 89062500*f**4 + 102804406*f**5 + 89119968*f**6 + 57235710*f**7 + 26220390*f**8 + 8049615*f**9 + 1480248*f**10 + 123354*f**11))/5.58702144e9,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (f*(92378 + 617253*f + 2444464*f**2 + 6570466*f**3 + 12789850*f**4 + 18666127*f**5 + 20077456*f**6 + 15281420*f**7 + 7875630*f**8 + 2596755*f**9 + 493416*f**10 + 41118*f**11))/3.72468096e9,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: -(f*(277134 + 2137291*f + 9867004*f**2 + 31294501*f**3 + 72933210*f**4 + 125774103*f**5 + 153166104*f**6 + 126310905*f**7 + 68287170*f**8 + 23111445*f**9 + 4440744*f**10 + 370062*f**11))/1.3408851456e11,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (f*(277134 + 2422823*f + 12775296*f**2 + 46695464*f**3 + 126738360*f**4 + 247391732*f**5 + 326217696*f**6 + 281751960*f**7 + 156310980*f**8 + 53624130*f**9 + 10361736*f**10 + 863478*f**11))/1.87723920384e12,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: -(f*(92378 + 902785*f + 5352756*f**2 + 22152309*f**3 + 68616600*f**4 + 147336228*f**5 + 205263744*f**6 + 182676900*f**7 + 102997020*f**8 + 35628390*f**9 + 6907824*f**10 + 575652*f**11))/1.001194242048e13,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (f*(1385670 + 14969435*f + 98579600*f**2 + 455607650*f**3 + 1585811250*f**4 + 3672180531*f**5 + 5325511968*f**6 + 4839843960*f**7 + 2759134140*f**8 + 959787990*f**9 + 186511248*f**10 + 15542604*f**11))/2.7032244535296e15,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: -(f*(25194 + 298129*f + 2158932*f**2 + 11021083*f**3 + 42581850*f**4 + 104830807*f**5 + 156743496*f**6 + 144667845*f**7 + 83138580*f**8 + 29037330*f**9 + 5651856*f**10 + 470988*f**11))/9.829907103744e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (f*(92378 + 1188317*f + 9385088*f**2 + 52443572*f**3 + 222706220*f**4 + 576745202*f**5 + 883286096*f**6 + 824967220*f**7 + 476998830*f**8 + 167106555*f**9 + 32565456*f**10 + 2713788*f**11))/7.92945839702016e16,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: -(f*(277134 + 3850483*f + 32936956*f**2 + 199960579*f**3 + 925701660*f**4 + 2501498634*f**5 + 3905792352*f**6 + 3682331730*f**7 + 2139362610*f**8 + 751266285*f**9 + 146544552*f**10 + 12212046*f**11))/5.709210045854515e18,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (f*(21318 + 318155*f + 2930256*f**2 + 19204934*f**3 + 96258750*f**4 + 269719541*f**5 + 427880208*f**6 + 406483980*f**7 + 237072990*f**8 + 83410635*f**9 + 16282728*f**10 + 1356894*f**11))/1.141842009170903e19,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: -(f*(461890 + 7369245*f + 72707300*f**2 + 511640075*f**3 + 2760248750*f**4 + 7979802677*f**5 + 12828471656*f**6 + 12263992195*f**7 + 7175480130*f**8 + 2528549205*f**9 + 493909416*f**10 + 41159118*f**11))/6.927174855636812e21,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (f*(165 + 134*f + 34*f**2))/2079.,
    52: lambda f: (f*(616 + 793*f + 457*f**2 + 99*f**3))/4851.,
    53: lambda f: -(f*(7623 + 9064*f + 5270*f**2 + 1326*f**3))/53361.,
    54: lambda f: -(f*(3861 + 7020*f + 6160*f**2 + 2624*f**3 + 435*f**4))/54054.,
    55: lambda f: -(f*(108108 + 245661*f + 292354*f**2 + 192670*f**3 + 67570*f**4 + 9945*f**5))/1.135134e6,
    56: lambda f: (f*(165165 + 355069*f + 407136*f**2 + 270350*f**3 + 101355*f**4 + 16965*f**5))/1.387386e6,
    57: lambda f: (f*(1859 + 5278*f + 8038*f**2 + 7224*f**3 + 3855*f**4 + 1130*f**5 + 140*f**6))/72072.,
    58: lambda f: (f*(48048 + 157599*f + 287605*f**2 + 322767*f**3 + 230250*f**4 + 102345*f**5 + 26005*f**6 + 2905*f**7))/1.513512e6,
    59: lambda f: -(f*(77077 + 242814*f + 427946*f**2 + 473332*f**3 + 341385*f**4 + 158330*f**5 + 43540*f**6 + 5460*f**7))/1.849848e6,
    60: lambda f: -(f*(123981 + 479128*f + 1041488*f**2 + 1434528*f**3 + 1308210*f**4 + 791640*f**5 + 306600*f**6 + 68880*f**7 + 6825*f**8))/2.2054032e7,
    61: lambda f: -(f*(1021020 + 4387071*f + 10829068*f**2 + 17259284*f**3 + 18722180*f**4 + 14050626*f**5 + 7218932*f**6 + 2433284*f**7 + 486528*f**8 + 43911*f**9))/1.54378224e8,
    62: lambda f: (f*(5054049 + 21045167*f + 50431792*f**2 + 78952692*f**3 + 85305690*f**4 + 64839210*f**5 + 34410600*f**6 + 12256020*f**7 + 2654925*f**8 + 266175*f**9))/5.66053488e8,
    63: lambda f: (f*(2909907 + 14234610*f + 40236110*f**2 + 74755120*f**3 + 96629250*f**4 + 88951428*f**5 + 58386720*f**6 + 26785920*f**7 + 8176035*f**8 + 1492890*f**9 + 123354*f**10))/3.352212864e9,
    64: lambda f: (f*(69837768 + 371397351*f + 1157342915*f**2 + 2394901265*f**3 + 3497233100*f**4 + 3709916862*f**5 + 2886617874*f**6 + 1636767930*f**7 + 659974980*f**8 + 179704875*f**9 + 29683731*f**10 + 2251557*f**11))/7.0396470144e10,
    65: lambda f: -(f*(117366249 + 608401508*f + 1848629130*f**2 + 3759309790*f**3 + 5442915750*f**4 + 5783046456*f**5 + 4559708832*f**6 + 2655538620*f**7 + 1116862425*f**8 + 322686420*f**9 + 57606318*f**10 + 4810806*f**11))/8.6040130176e10,
    66: lambda f: -(f*(1154725 + 6835972*f + 23793472*f**2 + 55659360*f**3 + 93179325*f**4 + 115259960*f**5 + 106838648*f**6 + 74260368*f**7 + 38230815*f**8 + 14166180*f**9 + 3575880*f**10 + 550704*f**11 + 39039*f**12))/1.117404288e10,
    67: lambda f: -(f*(27159132 + 172238781*f + 648719014*f**2 + 1652301978*f**3 + 3036934350*f**4 + 4171018023*f**5 + 4358014444*f**6 + 3484732636*f**7 + 2123259432*f**8 + 970632075*f**9 + 322853454*f**10 + 73869642*f**11 + 10408398*f**12 + 681681*f**13))/2.3465490048e11,
    68: lambda f: (f*(46235189 + 286972257*f + 1057502000*f**2 + 2650359058*f**3 + 4823449725*f**4 + 6604410791*f**5 + 6931951768*f**6 + 5616481500*f**7 + 3501845487*f**8 + 1656416895*f**9 + 577169208*f**10 + 140210994*f**11 + 21276255*f**12 + 1522521*f**13))/2.8680043392e11,
    69: lambda f: (f*(4018443 + 27923350*f + 115469270*f**2 + 325746792*f**3 + 669719505*f**4 + 1024806510*f**5 + 1161767964*f**6 + 961072224*f**7 + 568107645*f**8 + 232597890*f**9 + 62515530*f**10 + 9912672*f**11 + 702702*f**12))/4.0226554368e11,
    70: lambda f: (f*(31039008 + 228673341*f + 1010302979*f**2 + 3057245065*f**3 + 6777957970*f**4 + 11326324653*f**5 + 14332197229*f**6 + 13635129361*f**7 + 9624562332*f**8 + 4941954255*f**9 + 1788702069*f**10 + 431960067*f**11 + 62450388*f**12 + 4090086*f**13))/2.81585880576e12,
    71: lambda f: -(f*(160044885 + 1157403962*f + 5016385738*f**2 + 14957328960*f**3 + 32828916015*f**4 + 54504148818*f**5 + 68822673444*f**6 + 65841514200*f**7 + 47289153891*f**8 + 25076354310*f**9 + 9524950974*f**10 + 2451635802*f**11 + 382972590*f**12 + 27405378*f**13))/1.032481562112e13,
    72: lambda f: -(f*(4572711 + 36480912*f + 174750752*f**2 + 577224256*f**3 + 1407265020*f**4 + 2522121840*f**5 + 3244035984*f**6 + 2940804384*f**7 + 1849834770*f**8 + 787967040*f**9 + 216645660*f**10 + 34694352*f**11 + 2459457*f**12))/5.63171761152e12,
    73: lambda f: -(f*(104756652 + 879308391*f + 4458808280*f**2 + 15632494568*f**3 + 40595244200*f**4 + 78954906324*f**5 + 113580263832*f**6 + 119291150328*f**7 + 90478965696*f**8 + 48833286810*f**9 + 18261906432*f**10 + 4496178456*f**11 + 655729074*f**12 + 42945903*f**13))/1.1826606984192e14,
    74: lambda f: (f*(181384203 + 1497863081*f + 7466819424*f**2 + 25827123928*f**3 + 66416526540*f**4 + 127923212508*f**5 + 182638508304*f**6 + 191956968840*f**7 + 147732471306*f**8 + 82297234110*f**9 + 32329217844*f**10 + 8496536202*f**11 + 1340404065*f**12 + 95918823*f**13))/1.4454741869568e14,
    75: lambda f: (f*(1708993 + 15393534*f + 83824314*f**2 + 317304864*f**3 + 894839580*f**4 + 1810370520*f**5 + 2535677088*f**6 + 2430142848*f**7 + 1583126790*f**8 + 688803780*f**9 + 191614500*f**10 + 30839424*f**11 + 2186184*f**12))/3.003582726144e13,
    76: lambda f: (f*(12932920 + 121842383*f + 697451639*f**2 + 2780383677*f**3 + 8277866040*f**4 + 18151477644*f**5 + 28573109124*f**6 + 31947543124*f**7 + 25270091448*f**8 + 14018794258*f**9 + 5333977418*f**10 + 1326363654*f**11 + 194290096*f**12 + 12724712*f**13))/2.1025079083008e14,
    77: lambda f: -(f*(67574507 + 627431376*f + 3536786046*f**2 + 13925551326*f**3 + 41074237620*f**4 + 88911413856*f**5 + 138297679968*f**6 + 154222268760*f**7 + 123572657922*f**8 + 70737717120*f**9 + 28289033388*f**10 + 7515059244*f**11 + 1191470280*f**12 + 85261176*f**13))/7.7091956637696e14,
    78: lambda f: -(f*(5681247 + 57022420*f + 347883920*f**2 + 1484663040*f**3 + 4754377125*f**4 + 10582941168*f**5 + 15753762864*f**6 + 15669640224*f**7 + 10439453430*f**8 + 4602399480*f**9 + 1289512224*f**10 + 208166112*f**11 + 14756742*f**12))/1.62193467211776e15,
    79: lambda f: -(f*(14226212 + 148648799*f + 948098670*f**2 + 4235560370*f**3 + 14223085550*f**4 + 34355386839*f**5 + 57774816344*f**6 + 67419641912*f**7 + 54806626224*f**8 + 30936680670*f**9 + 11897556132*f**10 + 2976437772*f**11 + 437152716*f**12 + 28630602*f**13))/3.78451423494144e15,
    80: lambda f: (f*(224062839 + 2310697103*f + 14533552960*f**2 + 64189244130*f**3 + 213648148125*f**4 + 507908086299*f**5 + 841000705776*f**6 + 976435288920*f**7 + 803171534886*f**8 + 467739783630*f**9 + 189136376352*f**10 + 50575109508*f**11 + 8042424390*f**12 + 575512938*f**13))/4.162965658435584e16,
    81: lambda f: (f*(566865 + 6273306*f + 42384706*f**2 + 201332360*f**3 + 721689825*f**4 + 1735185510*f**5 + 2703274308*f**6 + 2761028928*f**7 + 1868279490*f**8 + 831099780*f**9 + 233985780*f**10 + 37848384*f**11 + 2683044*f**12))/2.9489721311232e15,
    82: lambda f: (f*(12697776 + 145734693*f + 1024862527*f**2 + 5071714669*f**3 + 18963551350*f**4 + 49593030183*f**5 + 87698581299*f**6 + 105552086031*f**7 + 87466197672*f**8 + 49964818050*f**9 + 19355390334*f**10 + 4861937682*f**11 + 715340808*f**12 + 46850076*f**13))/6.19284147535872e16,
    83: lambda f: -(f*(22309287 + 253006546*f + 1756632270*f**2 + 8601395684*f**3 + 31893105975*f**4 + 81857569086*f**5 + 142114011228*f**6 + 169869766500*f**7 + 142317097902*f**8 + 83866692420*f**9 + 34168480668*f**10 + 9177105924*f**11 + 1462258980*f**12 + 104638716*f**13))/7.56902846988288e16,
    84: lambda f: -(f*(2263261 + 27377480*f + 202921520*f**2 + 1061806944*f**3 + 4212016710*f**4 + 10790529640*f**5 + 17413279576*f**6 + 18141154416*f**7 + 12416228055*f**8 + 5559467760*f**9 + 1570642920*f**10 + 254425248*f**11 + 18036018*f**12))/2.378837519106048e17,
    85: lambda f: -(f*(50438388 + 630769581*f + 4848691244*f**2 + 26329222260*f**3 + 108485834820*f**4 + 303155313186*f**5 + 557622450308*f**6 + 686984885972*f**7 + 577392941664*f**8 + 332717681835*f**9 + 129567033288*f**10 + 32641746984*f**11 + 4808679876*f**12 + 314936622*f**13))/4.995558790122701e18,
    86: lambda f: (f*(88913825 + 1099806279*f + 8355038416*f**2 + 44924190140*f**3 + 183644092830*f**4 + 502342189822*f**5 + 904979171096*f**6 + 1105685496300*f**7 + 938985743619*f**8 + 558132778665*f**9 + 228632004216*f**10 + 61602347268*f**11 + 9829629810*f**12 + 703404702*f**13))/6.105682965705523e18,
    87: lambda f: (f*(7344051 + 96400642*f + 777730382*f**2 + 4444826256*f**3 + 19331111670*f**4 + 52223998860*f**5 + 86671007808*f**6 + 91691136768*f**7 + 63305253165*f**8 + 28485979830*f**9 + 8068869270*f**10 + 1308472704*f**11 + 92756664*f**12))/1.7127630137563546e19,
    88: lambda f: (f*(54318264 + 735173517*f + 6132618505*f**2 + 36255127571*f**3 + 163213376300*f**4 + 482405423406*f**5 + 915840130898*f**6 + 1149030829562*f**7 + 976293605364*f**8 + 566320816215*f**9 + 221415226263*f**10 + 55904208129*f**11 + 8243451216*f**12 + 539891352*f**13))/1.1989341096294482e20,
    89: lambda f: -(f*(288080793 + 3859737596*f + 31846584874*f**2 + 186545622198*f**3 + 833523697890*f**4 + 2405843746296*f**5 + 4464440120448*f**6 + 5548431443940*f**7 + 4761188996487*f**8 + 2848691219220*f**9 + 1171748146338*f**10 + 316471878954*f**11 + 50552381880*f**12 + 3617509896*f**13))/4.396091735307977e20,
    90: lambda f: -(f*(607563 + 8600844*f + 75029024*f**2 + 465006304*f**3 + 2200143855*f**4 + 6217800120*f**5 + 10556963256*f**6 + 11306030736*f**7 + 7859799255*f**8 + 3550483860*f**9 + 1007760600*f**10 + 163559088*f**11 + 11594583*f**12))/3.425526027512709e19,
    91: lambda f: -(f*(13430340 + 195593619*f + 1759695602*f**2 + 11250930446*f**3 + 54942498170*f**4 + 170386371645*f**5 + 331966723116*f**6 + 422609116188*f**7 + 362182880136*f**8 + 211189899459*f**9 + 82826634198*f**10 + 20948598594*f**11 + 3091294206*f**12 + 202459257*f**13))/7.193604657776689e20,
    92: lambda f: (f*(23801547 + 343386791*f + 3057993456*f**2 + 19383566566*f**3 + 93987604095*f**4 + 284014621317*f**5 + 539951510616*f**6 + 680277268860*f**7 + 588579954039*f**8 + 353979194415*f**9 + 146072474856*f**10 + 39525910578*f**11 + 6319047735*f**12 + 452188737*f**13))/8.792183470615953e20,
    93: lambda f: (f*(2817529 + 42787810*f + 401317810*f**2 + 2680912920*f**3 + 13709490375*f**4 + 40273710386*f**5 + 69683358836*f**6 + 75376750176*f**7 + 52693484025*f**8 + 23877543690*f**9 + 6788479698*f**10 + 1102509408*f**11 + 78156078*f**12))/4.156304913382087e21,
    94: lambda f: (f*(62078016 + 967966077*f + 9342615115*f**2 + 64236352065*f**3 + 338207621850*f**4 + 1093396445505*f**5 + 2176787239081*f**6 + 2804418490237*f**7 + 2420277762084*f**8 + 1417217655945*f**9 + 557212370715*f**10 + 141125597613*f**11 + 20837612796*f**12 + 1364725362*f**13))/8.728240318102383e22,
    95: lambda f: -(f*(110253143 + 1704096966*f + 16291218830*f**2 + 111104596840*f**3 + 581042303625*f**4 + 1826743678214*f**5 + 3543555209740*f**6 + 4514572848240*f**7 + 3932178722199*f**8 + 2374732299030*f**9 + 982500981462*f**10 + 266255559570*f**11 + 42595062510*f**12 + 3048087042*f**13))/1.066784927768069e23,
}

Q140withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: -(f**2*(2 + f)**2)/35.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/385.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (-3*f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/40040.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/60060.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: -(f**2*(2 + f)**2*(12155 + 44200*f + 93500*f**2 + 128520*f**3 + 125706*f**4 + 87192*f**5 + 40404*f**6 + 11088*f**7 + 1386*f**8))/3.267264e7,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (f**2*(2 + f)**2*(2431 + 11050*f + 29325*f**2 + 52360*f**3 + 67270*f**4 + 58380*f**5 + 31290*f**6 + 9240*f**7 + 1155*f**8))/5.44544e7,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: -(f**2*(2 + f)**2*(2431 + 13260*f + 42330*f**2 + 92820*f**3 + 142125*f**4 + 137880*f**5 + 78420*f**6 + 23760*f**7 + 2970*f**8))/5.601024e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (f**2*(2 + f)**2*(9724 + 61880*f + 230860*f**2 + 599760*f**3 + 1037820*f**4 + 1076040*f**5 + 632100*f**6 + 194040*f**7 + 24255*f**8))/2.74450176e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: -(f**2*(2 + f)**2*(2431 + 17680*f + 75480*f**2 + 226576*f**3 + 429044*f**4 + 464912*f**5 + 278712*f**6 + 86240*f**7 + 10780*f**8))/9.75822848e10,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (f**2*(2 + f)**2*(12155 + 99450*f + 478125*f**2 + 1627920*f**3 + 3303468*f**4 + 3693816*f**5 + 2245572*f**6 + 698544*f**7 + 87318*f**8))/7.9041650688e12,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: -(f**2*(2 + f)**2*(2431 + 22100*f + 118150*f**2 + 449820*f**3 + 964215*f**4 + 1103760*f**5 + 677880*f**6 + 211680*f**7 + 26460*f**8))/2.8742418432e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (f**2*(2 + f)**2*(221 + 2210*f + 13005*f**2 + 54740*f**3 + 122675*f**4 + 143010*f**5 + 88515*f**6 + 27720*f**7 + 3465*f**8))/5.2694433792e13,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: -(f**2*(2 + f)**2*(31603 + 344760*f + 2214420*f**2 + 10210200*f**3 + 23739870*f**4 + 28080360*f**5 + 17486700*f**6 + 5488560*f**7 + 686070*f**8))/1.66935966253056e17,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (f**2*(2 + f)**2*(187 + 2210*f + 15385*f**2 + 77112*f**3 + 184938*f**4 + 221364*f**5 + 138534*f**6 + 43560*f**7 + 5445*f**8))/2.3847995179008e16,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: -(f**2*(2 + f)**2*(935 + 11900*f + 89250*f**2 + 483140*f**3 + 1189769*f**4 + 1438248*f**5 + 903756*f**6 + 284592*f**7 + 35574*f**8))/3.116138036723712e18,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (-2*f**2*(2 + f)**2)/105.,
    52: lambda f: (2*f**2*(121 + 112*f + 34*f**2))/1155.,
    53: lambda f: 0,
    54: lambda f: (f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/385.,
    55: lambda f: -(f**2*(1287 + 2392*f + 2010*f**2 + 840*f**3 + 145*f**4))/5005.,
    56: lambda f: 0,
    57: lambda f: -(f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/10010.,
    58: lambda f: (f**2*(2431 + 6760*f + 9388*f**2 + 7780*f**3 + 3925*f**4 + 1120*f**5 + 140*f**6))/20020.,
    59: lambda f: 0,
    60: lambda f: (f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/36036.,
    61: lambda f: -(f**2*(201773 + 746096*f + 1444388*f**2 + 1787040*f**3 + 1493850*f**4 + 846720*f**5 + 313740*f**6 + 68880*f**7 + 6825*f**8))/6.12612e6,
    62: lambda f: 0,
    63: lambda f: -(f**2*(2 + f)**2*(2431 + 8840*f + 18700*f**2 + 25704*f**3 + 24402*f**4 + 15960*f**5 + 6972*f**6 + 1848*f**7 + 231*f**8))/3.267264e6,
    64: lambda f: (f**2*(1893749 + 8733920*f + 21670070*f**2 + 35620440*f**3 + 41522410*f**4 + 35150976*f**5 + 21603540*f**6 + 9434040*f**7 + 2783865*f**8 + 498960*f**9 + 41118*f**10))/3.1039008e8,
    65: lambda f: 0,
    66: lambda f: (f**2*(2 + f)**2*(46189 + 209950*f + 557175*f**2 + 994840*f**3 + 1278130*f**4 + 1205316*f**5 + 834750*f**6 + 415800*f**7 + 142065*f**8 + 30030*f**9 + 3003*f**10))/4.434144e8,
    67: lambda f: -(f**2*(2632773 + 14545336*f + 43997122*f**2 + 90142840*f**3 + 134680645*f**4 + 151510912*f**5 + 129896564*f**6 + 84758688*f**7 + 41511015*f**8 + 14811720*f**9 + 3641946*f**10 + 552552*f**11 + 39039*f**12))/3.1039008e9,
    68: lambda f: 0,
    69: lambda f: -(f**2*(2 + f)**2*(184756 + 1007760*f + 3217080*f**2 + 7054320*f**3 + 11252940*f**4 + 13111488*f**5 + 10961400*f**6 + 6355800*f**7 + 2416095*f**8 + 540540*f**9 + 54054*f**10))/1.59629184e10,
    70: lambda f: (f**2*(10484903 + 67486328*f + 240751280*f**2 + 590527980*f**3 + 1067199315*f**4 + 1450876896*f**5 + 1483165152*f**6 + 1127298984*f**7 + 624517845*f**8 + 244157760*f**9 + 63704718*f**10 + 9945936*f**11 + 702702*f**12))/1.117404288e11,
    71: lambda f: 0,
    72: lambda f: (f**2*(2 + f)**2*(184756 + 1175720*f + 4386340*f**2 + 11395440*f**3 + 21357140*f**4 + 28430584*f**5 + 26239500*f**6 + 16277800*f**7 + 6449135*f**8 + 1471470*f**9 + 147147*f**10))/1.738184448e11,
    73: lambda f: -(f**2*(4480333 + 32920160*f + 135274984*f**2 + 386359680*f**3 + 810281220*f**4 + 1253841792*f**5 + 1420418664*f**6 + 1165354848*f**7 + 681399390*f**8 + 276118920*f**9 + 73602606*f**10 + 11603592*f**11 + 819819*f**12))/5.214553344e11,
    74: lambda f: 0,
    75: lambda f: -(f**2*(2 + f)**2*(230945 + 1679600*f + 7170600*f**2 + 21524720*f**3 + 45674860*f**4 + 66554544*f**5 + 65242520*f**6 + 42042000*f**7 + 17027010*f**8 + 3923920*f**9 + 392392*f**10))/2.7810951168e12,
    76: lambda f: (f**2*(5588869 + 46155408*f + 214639314*f**2 + 699462960*f**3 + 1651966020*f**4 + 2803433472*f**5 + 3392441304*f**6 + 2911914768*f**7 + 1754528790*f**8 + 724674720*f**9 + 195314196*f**10 + 30942912*f**11 + 2186184*f**12))/8.3432853504e12,
    77: lambda f: 0,
    78: lambda f: (f**2*(2 + f)**2*(230945 + 1889550*f + 9084375*f**2 + 30930480*f**3 + 72418500*f**4 + 112603176*f**5 + 114933420*f**6 + 75887280*f**7 + 31156650*f**8 + 7223580*f**9 + 722358*f**10))/4.09579462656e13,
    79: lambda f: -(f**2*(20461727 + 187611320*f + 973906370*f**2 + 3565493640*f**3 + 9275110965*f**4 + 16855098624*f**5 + 21345963912*f**6 + 18873840384*f**7 + 11590886790*f**8 + 4844402640*f**9 + 1314485172*f**10 + 208864656*f**11 + 14756742*f**12))/4.505374089216e14,
    80: lambda f: 0,
    81: lambda f: -(f**2*(2 + f)**2*(46189 + 419900*f + 2244850*f**2 + 8546580*f**3 + 21671685*f**4 + 35379792*f**5 + 37170000*f**6 + 24960600*f**7 + 10343655*f**8 + 2407860*f**9 + 240786*f**10))/1.36526487552e14,
    82: lambda f: (f**2*(743223 + 7491016*f + 42934452*f**2 + 174439380*f**3 + 491538265*f**4 + 941369184*f**5 + 1232330148*f**6 + 1112607216*f**7 + 692320230*f**8 + 291695040*f**9 + 79508772*f**10 + 12658464*f**11 + 894348*f**12))/2.73052975104e14,
    83: lambda f: 0,
    84: lambda f: (f**2*(2 + f)**2*(54587 + 545870*f + 3212235*f**2 + 13520780*f**3 + 36620885*f**4 + 62089902*f**5 + 66658725*f**6 + 45322200*f**7 + 18908505*f**8 + 4414410*f**9 + 441441*f**10))/3.003582726144e15,
    85: lambda f: -(f**2*(9653501 + 106083536*f + 665308940*f**2 + 2970308000*f**3 + 8950790750*f**4 + 17866158464*f**5 + 23982950068*f**6 + 21990686256*f**7 + 13815810855*f**8 + 5855073840*f**9 + 1601165412*f**10 + 255279024*f**11 + 18036018*f**12))/6.6078819975168e16,
    86: lambda f: 0,
    87: lambda f: -(f**2*(2 + f)**2*(600457 + 6550440*f + 42073980*f**2 + 193993800*f**3 + 555340170*f**4 + 970416216*f**5 + 1059481500*f**6 + 727234200*f**7 + 304958115*f**8 + 71351280*f**9 + 7135128*f**10))/6.79667862601728e17,
    88: lambda f: (f**2*(33764159 + 401760320*f + 2736563882*f**2 + 13316036760*f**3 + 42484403370*f**4 + 87678847872*f**5 + 120033468324*f**6 + 111381512088*f**7 + 70490692965*f**8 + 30005957520*f**9 + 8225842086*f**10 + 1312863552*f**11 + 92756664*f**12))/4.757675038212096e18,
    89: lambda f: 0,
    90: lambda f: (f**2*(2 + f)**2*(17765 + 209950*f + 1461575*f**2 + 7325640*f**3 + 21983190*f**4 + 39371244*f**5 + 43565610*f**6 + 30129000*f**7 + 12685035*f**8 + 2972970*f**9 + 297297*f**10))/4.53111908401152e17,
    91: lambda f: -(f**2*(998393 + 12788216*f + 94007858*f**2 + 495159000*f**3 + 1659332605*f**4 + 3519831168*f**5 + 4895363676*f**6 + 4585634592*f**7 + 2918924085*f**8 + 1246817880*f**9 + 342460734*f**10 + 54702648*f**11 + 3864861*f**12))/3.171783358808064e18,
    92: lambda f: 0,
    93: lambda f: -(f**2*(2 + f)**2*(142120 + 1808800*f + 13566000*f**2 + 73437280*f**3 + 229510120*f**4 + 419535648*f**5 + 469347480*f**6 + 326569320*f**7 + 137938185*f**8 + 32372340*f**9 + 3237234*f**10))/8.88099340466258e19,
    94: lambda f: (f**2*(14826669 + 203399560*f + 1604961160*f**2 + 9097404820*f**3 + 31816183525*f**4 + 69056609440*f**5 + 97295038568*f**6 + 91841238216*f**7 + 58733237745*f**8 + 25157932800*f**9 + 6920743830*f**10 + 1106209104*f**11 + 78156078*f**12))/1.1545291426061353e21,
    95: lambda f: 0,
}

Q142withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: -(f*(66 + 101*f + 68*f**2 + 17*f**3))/385.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/10010.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (-3*f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/40040.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/4.08408e6,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: -(f*(1385670 + 7831135*f + 25872300*f**2 + 57017575*f**3 + 89062500*f**4 + 102804406*f**5 + 89119968*f**6 + 57235710*f**7 + 26220390*f**8 + 8049615*f**9 + 1480248*f**10 + 123354*f**11))/3.1039008e9,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (f*(92378 + 617253*f + 2444464*f**2 + 6570466*f**3 + 12789850*f**4 + 18666127*f**5 + 20077456*f**6 + 15281420*f**7 + 7875630*f**8 + 2596755*f**9 + 493416*f**10 + 41118*f**11))/2.0692672e9,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: -(f*(277134 + 2137291*f + 9867004*f**2 + 31294501*f**3 + 72933210*f**4 + 125774103*f**5 + 153166104*f**6 + 126310905*f**7 + 68287170*f**8 + 23111445*f**9 + 4440744*f**10 + 370062*f**11))/7.44936192e10,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (f*(277134 + 2422823*f + 12775296*f**2 + 46695464*f**3 + 126738360*f**4 + 247391732*f**5 + 326217696*f**6 + 281751960*f**7 + 156310980*f**8 + 53624130*f**9 + 10361736*f**10 + 863478*f**11))/1.0429106688e12,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: -(f*(92378 + 902785*f + 5352756*f**2 + 22152309*f**3 + 68616600*f**4 + 147336228*f**5 + 205263744*f**6 + 182676900*f**7 + 102997020*f**8 + 35628390*f**9 + 6907824*f**10 + 575652*f**11))/5.5621902336e12,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (f*(1385670 + 14969435*f + 98579600*f**2 + 455607650*f**3 + 1585811250*f**4 + 3672180531*f**5 + 5325511968*f**6 + 4839843960*f**7 + 2759134140*f**8 + 959787990*f**9 + 186511248*f**10 + 15542604*f**11))/1.501791363072e15,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: -(f*(25194 + 298129*f + 2158932*f**2 + 11021083*f**3 + 42581850*f**4 + 104830807*f**5 + 156743496*f**6 + 144667845*f**7 + 83138580*f**8 + 29037330*f**9 + 5651856*f**10 + 470988*f**11))/5.46105950208e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (f*(92378 + 1188317*f + 9385088*f**2 + 52443572*f**3 + 222706220*f**4 + 576745202*f**5 + 883286096*f**6 + 824967220*f**7 + 476998830*f**8 + 167106555*f**9 + 32565456*f**10 + 2713788*f**11))/4.4052546650112e16,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: -(f*(277134 + 3850483*f + 32936956*f**2 + 199960579*f**3 + 925701660*f**4 + 2501498634*f**5 + 3905792352*f**6 + 3682331730*f**7 + 2139362610*f**8 + 751266285*f**9 + 146544552*f**10 + 12212046*f**11))/3.171783358808064e18,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (f*(21318 + 318155*f + 2930256*f**2 + 19204934*f**3 + 96258750*f**4 + 269719541*f**5 + 427880208*f**6 + 406483980*f**7 + 237072990*f**8 + 83410635*f**9 + 16282728*f**10 + 1356894*f**11))/6.343566717616128e18,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: -(f*(461890 + 7369245*f + 72707300*f**2 + 511640075*f**3 + 2760248750*f**4 + 7979802677*f**5 + 12828471656*f**6 + 12263992195*f**7 + 7175480130*f**8 + 2528549205*f**9 + 493909416*f**10 + 41159118*f**11))/3.8484304753537843e21,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (f*(-990 - 469*f + 200*f**2 + 176*f**3))/23100.,
    52: lambda f: -(f*(4158 + 5689*f + 3400*f**2 + 748*f**3))/16170.,
    53: lambda f: (3*f*(30030 + 45721*f + 30720*f**2 + 7716*f**3))/700700.,
    54: lambda f: (f*(8580 + 10517*f + 500*f**2 - 8743*f**3 - 6570*f**4 - 1560*f**5))/300300.,
    55: lambda f: (f*(42042 + 100178*f + 123860*f**2 + 85319*f**3 + 31320*f**4 + 4785*f**5))/210210.,
    56: lambda f: -(f*(60060 + 152893*f + 201220*f**2 + 148243*f**3 + 58770*f**4 + 9810*f**5))/700700.,
    57: lambda f: (f*(-7150 - 14937*f - 9400*f**2 + 10978*f**3 + 24470*f**4 + 19195*f**5 + 7280*f**6 + 1120*f**7))/800800.,
    58: lambda f: -(f*(38038 + 129545*f + 244120*f**2 + 284534*f**3 + 211810*f**4 + 98645*f**5 + 26320*f**6 + 3080*f**7))/560560.,
    59: lambda f: (3*f*(850850 + 3038971*f + 5964960*f**2 + 7281406*f**3 + 5711190*f**4 + 2813815*f**5 + 797160*f**6 + 99540*f**7))/9.52952e7,
    60: lambda f: -(f*(-109395 - 329069*f - 409700*f**2 + 10081*f**3 + 766740*f**4 + 1192545*f**5 + 966000*f**6 + 460635*f**7 + 122955*f**8 + 14280*f**9))/6.12612e7,
    61: lambda f: (f*(1225224 + 5429749*f + 13769320*f**2 + 22649746*f**3 + 25465980*f**4 + 19888920*f**5 + 10673040*f**6 + 3769710*f**7 + 791700*f**8 + 75075*f**9))/8.576568e7,
    62: lambda f: -(f*(4849845 + 22305088*f + 58262740*f**2 + 99287293*f**3 + 116268220*f**4 + 94913815*f**5 + 53367160*f**6 + 19780775*f**7 + 4364955*f**8 + 435645*f**9))/9.053044e8,
    63: lambda f: (f*(-1939938 - 7679971*f - 14405800*f**2 - 9952276*f**3 + 15188220*f**4 + 49510230*f**5 + 66762864*f**6 + 55592460*f**7 + 30445590*f**8 + 10768485*f**9 + 2245320*f**10 + 210672*f**11))/7.44936192e9,
    64: lambda f: -(f*(56258202 + 307119059*f + 979400600*f**2 + 2081773760*f**3 + 3133660500*f**4 + 3438076218*f**5 + 2775393936*f**6 + 1637673660*f**7 + 689225250*f**8 + 196432635*f**9 + 34045704*f**10 + 2713788*f**11))/2.607276672e10,
    65: lambda f: (f*(13579566 + 76417601*f + 249356000*f**2 + 545420384*f**3 + 849121020*f**4 + 966818046*f**5 + 811796832*f**6 + 498948660*f**7 + 218906310*f**8 + 65068185*f**9 + 11764368*f**10 + 978516*f**11))/1.738184448e10,
    66: lambda f: -(f*(-1847560 - 9107631*f - 22900700*f**2 - 29598751*f**3 - 1311950*f**4 + 73869170*f**5 + 161355376*f**6 + 202061090*f**7 + 172094916*f**8 + 103580085*f**9 + 43746780*f**10 + 12410013*f**11 + 2132130*f**12 + 168168*f**13))/6.2078016e10,
    67: lambda f: (f*(10992982 + 71315816*f + 274065500*f**2 + 714443377*f**3 + 1347956900*f**4 + 1905576553*f**5 + 2054583104*f**6 + 1699552330*f**7 + 1073936598*f**8 + 510432090*f**9 + 176974644*f**10 + 42316197*f**11 + 6246240*f**12 + 429429*f**13))/4.34546112e10,
    68: lambda f: -(f*(297457160 + 1979925077*f + 7751864340*f**2 + 20700336467*f**3 + 40198734150*f**4 + 58684721720*f**5 + 65484259008*f**6 + 56140224630*f**7 + 36797709228*f**8 + 18150491205*f**9 + 6532037820*f**10 + 1621113879*f**11 + 248318070*f**12 + 17711694*f**13))/3.331520192e12,
    69: lambda f: (f*(-12471030 - 73747037*f - 232883000*f**2 - 430227602*f**3 - 351108030*f**4 + 485738505*f**5 + 2164083936*f**6 + 3788650740*f**7 + 4098889326*f**8 + 2942952285*f**9 + 1406485080*f**10 + 430960068*f**11 + 76756680*f**12 + 6054048*f**13))/4.469617152e12,
    70: lambda f: -(f*(75657582 + 568657973*f + 2557552760*f**2 + 7899016034*f**3 + 17918423670*f**4 + 30729933423*f**5 + 40063031904*f**6 + 39438990780*f**7 + 28925030778*f**8 + 15486122715*f**9 + 5860401624*f**10 + 1482676272*f**11 + 224864640*f**12 + 15459444*f**13))/3.1287320064e12,
    71: lambda f: (f*(669278610 + 5143594443*f + 23497035520*f**2 + 74094186418*f**3 + 172383306970*f**4 + 304784660425*f**5 + 411998120296*f**6 + 422531357360*f**7 + 323732899686*f**8 + 181193274885*f**9 + 71619942240*f**10 + 18890719848*f**11 + 2979816840*f**12 + 212540328*f**13))/7.9956484608e13,
    72: lambda f: -(f*(-6928350 - 47851804*f - 182042800*f**2 - 433009924*f**3 - 602904960*f**4 - 15840300*f**5 + 2039946048*f**6 + 4793520060*f**7 + 6004591908*f**8 + 4698037680*f**9 + 2363116140*f**10 + 744963219*f**11 + 134324190*f**12 + 10594584*f**13))/3.1287320064e13,
    73: lambda f: (f*(42678636 + 364704145*f + 1879110640*f**2 + 6709238428*f**3 + 17781626520*f**4 + 35436490824*f**5 + 52521491232*f**6 + 57148440300*f**7 + 45114563424*f**8 + 25431854070*f**9 + 9957802932*f**10 + 2570937831*f**11 + 393513120*f**12 + 27054027*f**13))/2.19011240448e13,
    74: lambda f: -(f*(1115464350 + 9720861358*f + 50760276880*f**2 + 184577754388*f**3 + 500346191520*f**4 + 1028612478180*f**5 + 1587422993184*f**6 + 1809708353460*f**7 + 1500405981564*f**8 + 887893997340*f**9 + 364166801460*f**10 + 98191647477*f**11 + 15644038410*f**12 + 1115836722*f**13))/1.679086176768e15,
    75: lambda f: (f*(-5080790 - 40171833*f - 178877400*f**2 - 518058408*f**3 - 979622520*f**4 - 599975820*f**5 + 2268988512*f**6 + 6993113400*f**7 + 9665267052*f**8 + 7953551130*f**9 + 4113777360*f**10 + 1316186256*f**11 + 238798560*f**12 + 18834816*f**13))/3.33731414016e14,
    76: lambda f: -(f*(31685654 + 303381949*f + 1761913320*f**2 + 7140216036*f**3 + 21651361080*f**4 + 48608672796*f**5 + 78879809568*f**6 + 91478035320*f**7 + 75404606676*f**8 + 43737628830*f**9 + 17437960848*f**10 + 4549448904*f**11 + 699578880*f**12 + 48096048*f**13))/2.336119898112e14,
    77: lambda f: (f*(818007190 + 7970789541*f + 46834793280*f**2 + 192919570476*f**3 + 597024208440*f**4 + 1385311287420*f**5 + 2351417663616*f**6 + 2870452047960*f**7 + 2494077126996*f**8 + 1522522783950*f**9 + 636885073440*f**10 + 173687700648*f**11 + 27811623840*f**12 + 1983709728*f**13))/1.7910252552192e16,
    78: lambda f: -(f*(-8314020 - 74091355*f - 378071500*f**2 - 1287376255*f**3 - 3026383650*f**4 - 2931568740*f**5 + 5166288288*f**6 + 20645360820*f**7 + 30615158448*f**8 + 26040798630*f**9 + 13707179640*f**10 + 4425538194*f**11 + 805945140*f**12 + 63567504*f**13))/9.010748178432e15,
    79: lambda f: (f*(52378326 + 555435322*f + 3589725100*f**2 + 16278552385*f**3 + 55581156000*f**4 + 137415421323*f**5 + 238393391040*f**6 + 288827162820*f**7 + 244898803044*f**8 + 144640503000*f**9 + 58316898024*f**10 + 15311647890*f**11 + 2361078720*f**12 + 162324162*f**13))/6.3075237249024e15,
    80: lambda f: -(f*(446185740 + 4807120175*f + 31391239500*f**2 + 144462885345*f**3 + 502494304350*f**4 + 1287265289610*f**5 + 2345757089088*f**6 + 3002493760980*f**7 + 2690538269328*f**8 + 1675236547530*f**9 + 709392970440*f**10 + 194807884194*f**11 + 31288076820*f**12 + 2231673444*f**13))/1.61192272969728e17,
    81: lambda f: (f*(-1637610 - 16245931*f - 93476200*f**2 - 365333026*f**3 - 1018758150*f**4 - 1244351235*f**5 + 1318412592*f**6 + 6814682280*f**7 + 10653491772*f**8 + 9275640570*f**9 + 4941563760*f**10 + 1605264696*f**11 + 293070960*f**12 + 23115456*f**13))/3.276635701248e16,
    82: lambda f: -(f*(10405122 + 121052971*f + 861699400*f**2 + 4323217402*f**3 + 16413101550*f**4 + 43933462851*f**5 + 80203002768*f**6 + 100301211360*f**7 + 86750718516*f**8 + 51877653030*f**9 + 21076152048*f**10 + 5557510224*f**11 + 858574080*f**12 + 59026968*f**13))/2.2936449908736e16,
    83: lambda f: (f*(2900207310 + 34232779997*f + 245954577440*f**2 + 1250643756362*f**3 + 4829809936050*f**4 + 13433197806765*f**5 + 25854541347096*f**6 + 34257525285060*f**7 + 31373709064236*f**8 + 19802987799210*f**9 + 8455893747840*f**10 + 2332968378048*f**11 + 375456921840*f**12 + 26780081328*f**13))/1.934307275636736e19,
    84: lambda f: -(f*(-1616615 - 17673591*f - 113211500*f**2 - 498972661*f**3 - 1602958940*f**4 - 2269353625*f**5 + 1581990256*f**6 + 10642412165*f**7 + 17334561321*f**8 + 15356374110*f**9 + 8253117180*f**10 + 2692908603*f**11 + 492522030*f**12 + 38846808*f**13))/6.6078819975168e17,
    85: lambda f: (f*(20692672 + 262046993*f + 2037135160*f**2 + 11203170374*f**3 + 46814282020*f**4 + 133919615456*f**5 + 254465163568*f**6 + 325955101010*f**7 + 286088232276*f**8 + 172644376905*f**9 + 70527203208*f**10 + 18654532974*f**11 + 2885762880*f**12 + 198396198*f**13))/9.25103479652352e17,
    86: lambda f: -(f*(260275015 + 3340212122*f + 26185887780*f**2 + 145794815897*f**3 + 618928842180*f**4 + 1844969102735*f**5 + 3707878391448*f**6 + 5043775715055*f**7 + 4694388688143*f**8 + 2992813386255*f**9 + 1285671853620*f**10 + 355909964949*f**11 + 57361474170*f**12 + 4091401314*f**13))/3.546230005334016e19,
    87: lambda f: (f*(-20785050 - 248316263*f - 1752662600*f**2 - 8594395628*f**3 - 31174033020*f**4 - 49015167030*f**5 + 23227537872*f**6 + 206689019460*f**7 + 347887806882*f**8 + 312333886095*f**9 + 168984529560*f**10 + 55322489376*f**11 + 10131881760*f**12 + 799134336*f**13))/1.9030700152848384e20,
    88: lambda f: -(f*(133855722 + 1832968475*f + 15451144280*f**2 + 92427481016*f**3 + 421548482940*f**4 + 1275819319566*f**5 + 2503589505648*f**6 + 3267600978180*f**7 + 2900502358446*f**8 + 1762507767405*f**9 + 723015143928*f**10 + 191683292724*f**11 + 29682132480*f**12 + 2040646608*f**13))/1.3321490106993869e20,
    89: lambda f: (f*(1115464350 + 15464005817*f + 131360172320*f**2 + 794795487512*f**3 + 3678653038580*f**4 + 11633876957210*f**5 + 24213087120992*f**6 + 33622262512300*f**7 + 31685048089002*f**8 + 20354585130495*f**9 + 8784145727280*f**10 + 2437872996636*f**11 + 393335822880*f**12 + 28055323296*f**13))/3.4043808051206554e21,
    90: lambda f: -(f*(-852720 - 11054029*f - 85239700*f**2 - 460088629*f**3 - 1856702610*f**4 - 3160978590*f**5 + 1016577072*f**6 + 12333007890*f**7 + 21322494732*f**8 + 19347722625*f**9 + 10522941660*f**10 + 3454034661*f**11 + 633242610*f**12 + 49945896*f**13))/1.9030700152848384e20,
    91: lambda f: (f*(5521362 + 81293932*f + 738578260*f**2 + 4774470043*f**3 + 23600554740*f**4 + 74966647791*f**5 + 151050953088*f**6 + 200131005690*f**7 + 179243116206*f**8 + 109512879630*f**9 + 45071414388*f**10 + 11970877149*f**11 + 1855133280*f**12 + 127540413*f**13))/1.3321490106993869e20,
    92: lambda f: -(f*(1784742960 + 26580597979*f + 243204510220*f**2 + 1588932059869*f**3 + 7963008900210*f**4 + 26501902512540*f**5 + 56770409299968*f**6 + 80147941940430*f**7 + 76279607552148*f**8 + 49297105822965*f**9 + 21350897387820*f**10 + 5937286774419*f**11 + 958756068270*f**12 + 68384850534*f**13))/1.3277085139970556e23,
    93: lambda f: (f*(-7852130 - 109782855*f - 918289000*f**2 - 5408573630*f**3 - 24009299650*f**4 - 43530322745*f**5 + 9167010944*f**6 + 160045090660*f**7 + 282948916614*f**8 + 258971486865*f**9 + 141448627320*f**10 + 46526451972*f**11 + 8537048520*f**12 + 673344672*f**13))/4.618116570424541e22,
    94: lambda f: -(f*(51085034 + 804767743*f + 7839274600*f**2 + 54458888510*f**3 + 290010390250*f**4 + 960666261233*f**5 + 1978837177408*f**6 + 2654275436540*f**7 + 2394560628642*f**8 + 1469459446455*f**9 + 606367225464*f**10 + 161284547424*f**11 + 25009944960*f**12 + 1719433716*f**13))/3.232681599297179e22,
    95: lambda f: (f*(1264192930 + 20130026995*f + 197373672000*f**2 + 1384797470410*f**3 + 7470405160050*f**4 + 25992867064885*f**5 + 57040562370792*f**6 + 81631733940120*f**7 + 78317640708762*f**8 + 50860094025195*f**9 + 22091513764320*f**10 + 6153014363496*f**11 + 994265552280*f**12 + 70917622776*f**13))/2.478389226127837e24,
}

Q144withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (-5005 - 10140*f - 12786*f**2 - 7716*f**3 - 1929*f**4)/40040.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (5005 + 15210*f + 30753*f**2 + 36228*f**3 + 25407*f**4 + 9810*f**5 + 1635*f**6)/120120.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (-85085 - 344760*f - 959412*f**2 - 1676472*f**3 - 1929078*f**4 - 1463400*f**5 - 708420*f**6 - 199080*f**7 - 24885*f**8)/1.089088e7,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (323323 + 1637610*f + 5803341*f**2 + 13434216*f**3 + 21485694*f**4 + 24255468*f**5 + 19374090*f**6 + 10752840*f**7 + 3957975*f**8 + 871290*f**9 + 87129*f**10)/3.1039008e8,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (-1616615 - 9825660*f - 42296850*f**2 - 121880820*f**3 - 249566805*f**4 - 373967640*f**5 - 421197612*f**6 - 359784936*f**7 - 229068945*f**8 - 104419980*f**9 - 31969350*f**10 - 5871096*f**11 - 489258*f**12)/1.489872384e10,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (230945 + 1637610*f + 8295609*f**2 + 28601004*f**3 + 71380701*f**4 + 133315470*f**5 + 190026885*f**6 + 201748680*f**7 + 152493075*f**8 + 78303750*f**9 + 25769835*f**10 + 4892580*f**11 + 407715*f**12)/2.48312064e10,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (-1616615 - 13100880*f - 76333944*f**2 - 306374544*f**3 - 901885236*f**4 - 2017224720*f**5 - 3401842920*f**6 - 4095216720*f**7 - 3357380250*f**8 - 1809586800*f**9 - 611505720*f**10 - 117421920*f**11 - 9785160*f**12)/2.3837958144e12,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (1616615 + 14738490*f + 97090893*f**2 + 444608208*f**3 + 1507955292*f**4 + 3929075640*f**5 + 7509361860*f**6 + 9799619760*f**7 + 8419876290*f**8 + 4658679900*f**9 + 1596053970*f**10 + 308232540*f**11 + 25686045*f**12)/3.75447840768e13,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (-323323 - 3275220*f - 24068022*f**2 - 123826572*f**3 - 475433523*f**4 - 1414118736*f**5 - 2976417960*f**6 - 4107262320*f**7 - 3637963350*f**8 - 2046128280*f**9 - 706917708*f**10 - 136992240*f**11 - 11416020*f**12)/1.334925656064e14,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (146965 + 1637610*f + 13280145*f**2 + 75833940*f**3 + 325125435*f**4 + 1086938730*f**5 + 2469678327*f**6 + 3549931056*f**7 + 3211928370*f**8 + 1826877780*f**9 + 634762170*f**10 + 123293016*f**11 + 10274418*f**12)/1.2014330904576e15,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (-1616615 - 19651320*f - 174315348*f**2 - 1093954488*f**3 - 5180014422*f**4 - 19227475080*f**5 - 46486947540*f**6 - 68928579720*f**7 - 63352483425*f**8 - 36328446000*f**9 - 12674332440*f**10 - 2465860320*f**11 - 205488360*f**12)/2.88343941709824e17,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (124355 + 1637610*f + 15772413*f**2 + 107900088*f**3 + 559235322*f**4 + 2281987620*f**5 + 5808230670*f**6 + 8824911480*f**7 + 8209364625*f**8 + 4736758950*f**9 + 1657680255*f**10 + 322910280*f**11 + 26909190*f**12)/5.28630559801344e17,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (-230945 - 3275220*f - 34037094*f**2 - 252091164*f**3 - 1419438111*f**4 - 6315393240*f**5 - 16784284620*f**6 - 26008151400*f**7 - 24426008145*f**8 - 14162355900*f**9 - 4968248670*f**10 - 968730840*f**11 - 80727570*f**12)/2.537426687046451e19,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (323323 + 4912830*f + 54794043*f**2 + 436798068*f**3 + 2655030987*f**4 + 12791605554*f**5 + 35272035435*f**6 + 55547168040*f**7 + 52573350375*f**8 + 30602041470*f**9 + 10756232487*f**10 + 2098916820*f**11 + 174909735*f**12)/9.89596407948116e20,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (-1616615 - 26201760*f - 312173040*f**2 - 2664982560*f**3 - 17392006440*f**4 - 90203893920*f**5 - 256763618832*f**6 - 409866571296*f**7 - 390414662820*f**8 - 227987803680*f**9 - 80262458640*f**10 - 15671912256*f**11 - 1305992688*f**12)/1.4777973025358532e23,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (10010 + 12675*f + 8928*f**2 + 1929*f**3)/60060.,
    52: lambda f: (210210 + 346255*f + 330384*f**2 + 144093*f**3 + 21216*f**4)/1.26126e6,
    53: lambda f: (-385385 - 585585*f - 591126*f**2 - 298995*f**3 - 75231*f**4)/1.54154e6,
    54: lambda f: (-10010 - 22815*f - 33288*f**2 - 25830*f**3 - 10398*f**4 - 1635*f**5)/120120.,
    55: lambda f: (-210210 - 559195*f - 964248*f**2 - 957918*f**3 - 552630*f**4 - 169935*f**5 - 20880*f**6)/2.52252e6,
    56: lambda f: (385385 + 975975*f + 1677519*f**2 + 1695702*f**3 + 1057635*f**4 + 380955*f**5 + 63765*f**6)/3.08308e6,
    57: lambda f: (170170 + 560235*f + 1242360*f**2 + 1663671*f**3 + 1396458*f**4 + 715545*f**5 + 204900*f**6 + 24885*f**7)/8.16816e6,
    58: lambda f: (3573570 + 13126295*f + 32677128*f**2 + 50844195*f**3 + 51688914*f**4 + 34279965*f**5 + 14278500*f**6 + 3378585*f**7 + 342720*f**8)/1.7153136e8,
    59: lambda f: (-6551545 - 23228205*f - 57086748*f**2 - 88353777*f**3 - 91114344*f**4 - 63027855*f**5 - 28535280*f**6 - 7739235*f**7 - 970515*f**8)/2.0964944e8,
    60: lambda f: (-3233230 - 13919685*f - 41442192*f**2 - 78872724*f**3 - 101109564*f**4 - 88443270*f**5 - 52208160*f**6 - 19911780*f**7 - 4430790*f**8 - 435645*f**9)/9.3117024e8,
    61: lambda f: (-67897830 - 318179225*f - 1034954016*f**2 - 2193881892*f**3 - 3202503276*f**4 - 3283010910*f**5 - 2364096960*f**6 - 1172225460*f**7 - 381092670*f**8 - 73020465*f**9 - 6224400*f**10)/1.955457504e10,
    62: lambda f: (124479355 + 567431865*f + 1819362423*f**2 + 3814918116*f**3 + 5554700046*f**4 + 5753556990*f**5 + 4264138590*f**6 + 2228192820*f**7 + 786286935*f**8 + 169465905*f**9 + 16990155*f**10)/2.390003616e10,
    63: lambda f: (646646 + 3438981*f + 12852816*f**2 + 31716339*f**3 + 54761268*f**4 + 67885026*f**5 + 60971976*f**6 + 39430230*f**7 + 17924550*f**8 + 5439945*f**9 + 989688*f**10 + 81543*f**11)/1.489872384e9,
    64: lambda f: (67897830 + 386958845*f + 1553717856*f**2 + 4170377355*f**3 + 7942353780*f**4 + 11036258130*f**5 + 11334994920*f**6 + 8612973894*f**7 + 4786448310*f**8 + 1892021985*f**9 + 503826120*f**10 + 80966655*f**11 + 5920992*f**12)/1.5643660032e11,
    65: lambda f: (-24895871 - 138705567*f - 549196254*f**2 - 1456322697*f**3 - 2751287571*f**4 - 3819281286*f**5 - 3958626732*f**6 - 3074887074*f**7 - 1774483725*f**8 - 742121835*f**9 - 213694278*f**10 - 38080581*f**11 - 3180177*f**12)/3.8240057856e10,
    66: lambda f: (-74364290 - 470812875*f - 2117621592*f**2 - 6421285866*f**3 - 13948817130*f**4 - 22399406865*f**5 - 27049987200*f**6 - 24722502588*f**7 - 17040813174*f**8 - 8729450205*f**9 - 3225113640*f**10 - 812674170*f**11 - 125025054*f**12 - 8855847*f**13)/1.7133532416e12,
    67: lambda f: (-1561650090 - 10481984695*f - 50074609896*f**2 - 162678295602*f**3 - 382305657714*f**4 - 671035045365*f**5 - 896289747120*f**6 - 919541625324*f**7 - 725509319598*f**8 - 437075193681*f**9 - 197594223960*f**10 - 64918860930*f**11 - 14635116342*f**12 - 2023760739*f**13 - 129297168*f**14)/3.59804180736e13,
    68: lambda f: (2863025165 + 18851347515*f + 88883609319*f**2 + 285294772650*f**3 + 663852065049*f**4 + 1158738658065*f**5 + 1548829374915*f**6 + 1602864232956*f**7 + 1287931298535*f**8 + 799097086221*f**9 + 376906007205*f**10 + 131114858490*f**11 + 31821870003*f**12 + 4826436615*f**13 + 345378033*f**14)/4.39760665344e13,
    69: lambda f: (74364290 + 546142935*f + 2871813672*f**2 + 10330135935*f**3 + 27049813182*f**4 + 53361156555*f**5 + 79795898700*f**6 + 89314166403*f**7 + 73363193694*f**8 + 43193192805*f**9 + 17643470040*f**10 + 4735383345*f**11 + 750150324*f**12 + 53135082*f**13)/2.05602388992e13,
    70: lambda f: (1561650090 + 12063915955*f + 66821239992*f**2 + 254819328267*f**3 + 712527883830*f**4 + 1511755748055*f**5 + 2461984974540*f**6 + 3062850845439*f**7 + 2874787349238*f**8 + 2003292991161*f**9 + 1014608556360*f**10 + 361579669605*f**11 + 85767955812*f**12 + 12142564434*f**13 + 775783008*f**14)/4.317650168832e14,
    71: lambda f: (-2863025165 - 21751554825*f - 119023456056*f**2 - 448678295793*f**3 - 1241632957950*f**4 - 2614641044085*f**5 - 4241642388900*f**6 - 5287243206861*f**7 - 5021933629860*f**8 - 3592376668251*f**9 - 1900628884980*f**10 - 721000148715*f**11 - 185445414693*f**12 - 28958619690*f**13 - 2072268198*f**14)/5.277127984128e14,
    72: lambda f: (-74364290 - 621472995*f - 3740650080*f**2 - 15568271832*f**3 - 47719005096*f**4 - 111662480580*f**5 - 195786561600*f**6 - 248932672968*f**7 - 224264807004*f**8 - 140578979730*f**9 - 59760398040*f**10 - 16409736420*f**11 - 2625526134*f**12 - 185972787*f**13)/2.878433445888e14,
    73: lambda f: (-1561650090 - 13645847215*f - 85975400976*f**2 - 376422972600*f**3 - 1220624390088*f**4 - 3037668404820*f**5 - 5763330961920*f**6 - 8150389550184*f**7 - 8437272164748*f**8 - 6308768094426*f**9 - 3353350575960*f**10 - 1232939764980*f**11 - 297804646062*f**12 - 42498975519*f**13 - 2715240528*f**14)/6.0447102363648e15,
    74: lambda f: (2863025165 + 24651762135*f + 153577109421*f**2 + 665109871224*f**3 + 2134651308948*f**4 + 5268565110900*f**5 + 9925473173700*f**6 + 14004301768296*f**7 + 14625220566390*f**8 + 11216218199466*f**9 + 6235818437730*f**10 + 2446863351240*f**11 + 642658845213*f**12 + 101355168915*f**13 + 7252938693*f**14)/7.3879791777792e15,
    75: lambda f: (74364290 + 696803055*f + 4724130816*f**2 + 22330036197*f**3 + 78422855832*f**4 + 212336480700*f**5 + 420719159280*f**6 + 583053397668*f**7 + 555648800364*f**8 + 360841204290*f**9 + 156705398640*f**10 + 43540490070*f**11 + 7001403024*f**12 + 495927432*f**13)/4.6054935134208e15,
    76: lambda f: (1561650090 + 15227778475*f + 107537092848*f**2 + 531570424041*f**3 + 1961186579928*f**4 + 5600941221420*f**5 + 11985438524400*f**6 + 18539221804404*f**7 + 20413125494748*f**8 + 15902046812106*f**9 + 8679898545360*f**10 + 3244387268430*f**11 + 790968123792*f**12 + 113330601384*f**13 + 7240641408*f**14)/9.67153637818368e16,
    77: lambda f: (-2863025165 - 27551969445*f - 192544569414*f**2 - 942071690583*f**3 - 3441215363463*f**4 - 9744735639060*f**5 - 20652140802360*f**6 - 31774375526796*f**7 - 35228043977490*f**8 - 28136827026966*f**9 - 16077319507620*f**10 - 6422786044290*f**11 - 1705223445618*f**12 - 270280450440*f**13 - 19341169848*f**14)/1.182076668444672e17,
    78: lambda f: (-74364290 - 772133115*f - 5822255880*f**2 - 30809771670*f**3 - 121975820190*f**4 - 375120176355*f**5 - 818554573440*f**6 - 1206524968488*f**7 - 1193838404724*f**8 - 793028175030*f**9 - 349002002160*f**10 - 97670713140*f**11 - 15753156804*f**12 - 1115836722*f**13)/8.28988832415744e16,
    79: lambda f: (-1561650090 - 16809709735*f - 131506315608*f**2 - 724342878030*f**3 - 2996113685430*f**4 - 9657704907855*f**5 - 22767875070480*f**6 - 37605009314376*f**7 - 43184542423428*f**8 - 34549910937486*f**9 - 19176775243920*f**10 - 7241211012420*f**11 - 1775388519828*f**12 - 254993853114*f**13 - 16291443168*f**14)/1.7408765480730624e18,
    80: lambda f: (2863025165 + 30452176755*f + 235925836035*f**2 + 1287045945510*f**3 + 5273031052755*f**4 + 16854650458155*f**5 + 39264531620445*f**6 + 64354050925416*f**7 + 74315967659010*f**8 + 60946932591846*f**9 + 35432686349550*f**10 + 14313321694980*f**11 + 3825232561458*f**12 + 608131013490*f**13 + 43517632158*f**14)/2.1277380032004096e18,
    81: lambda f: (74364290 + 847463175*f + 7035025272*f**2 + 41201820891*f**3 + 181540344810*f**4 + 625095774105*f**5 + 1474620948900*f**6 + 2276090348301*f**7 + 2313330213348*f**8 + 1560983795910*f**9 + 693223811280*f**10 + 194947573590*f**11 + 31506313608*f**12 + 2231673444*f**13)/1.657977664831488e18,
    82: lambda f: (1561650090 + 18391640995*f + 157883069256*f**2 + 958821530007*f**3 + 4394612767314*f**4 + 15781519336605*f**5 + 40279550776740*f**6 + 69925908494673*f**7 + 82776972782196*f**8 + 67473665120862*f**9 + 37884033799920*f**10 + 14404208236110*f**11 + 3545057361384*f**12 + 509987706228*f**13 + 32582886336*f**14)/3.481753096146125e19,
    83: lambda f: (-2863025165 - 33352384065*f - 283720909284*f**2 - 1707514827645*f**3 - 7755201993924*f**4 - 27621769320255*f**5 - 69527639503080*f**6 - 119549633297787*f**7 - 142174075334445*f**8 - 118777142618442*f**9 - 69880122164160*f**10 - 28442714183730*f**11 - 7635104868006*f**12 - 1216262026980*f**13 - 87035264316*f**14)/4.255476006400819e19,
    84: lambda f: (-74364290 - 922793235*f - 8362438992*f**2 - 53700526500*f**3 - 260626868172*f**4 - 993331937070*f**5 - 2498717258400*f**6 - 3996907917156*f**7 - 4144547460438*f**8 - 2829049246485*f**9 - 1264650544080*f**10 - 356888125440*f**11 - 57761574948*f**12 - 4091401314*f**13)/3.6475508626292736e19,
    85: lambda f: (-1561650090 - 19973572255*f - 186667353792*f**2 - 1239087575412*f**3 - 6233198714940*f**4 - 24676840200870*f**5 - 67293604762560*f**6 - 121466467535028*f**7 - 147120342541326*f**8 - 121585424241897*f**9 - 68840343522720*f**10 - 26305292280960*f**11 - 6491781774324*f**12 - 934977461418*f**13 - 59735291616*f**14)/7.659856811521475e20,
    86: lambda f: (2863025165 + 36252591375*f + 335929789161*f**2 + 2210960528628*f**3 + 11026229489910*f**4 + 43306202773350*f**5 + 116259606111990*f**6 + 207530614925172*f**7 + 252331178656095*f**8 + 213707297303577*f**9 + 126826418630835*f**10 + 51904116328680*f**11 + 13977577638486*f**12 + 2229813716130*f**13 + 159564651246*f**14)/9.362047214081802e20,
    87: lambda f: (74364290 + 998123295*f + 9804497040*f**2 + 68500231137*f**3 + 363093820596*f**4 + 1517525054370*f**5 + 4028216867400*f**6 + 6629072554566*f**7 + 6981593299758*f**8 + 4807764662085*f**9 + 2159924077080*f**10 + 611145095715*f**11 + 99019842768*f**12 + 7013830824*f**13)/8.754122070310257e20,
    88: lambda f: (1561650090 + 21555503515*f + 217859169216*f**2 + 1569222209685*f**3 + 8595694246308*f**4 + 37192485672810*f**5 + 107262291264840*f**6 + 199761523467198*f**7 + 246310275201606*f**8 + 205724400781977*f**9 + 117224075734920*f**10 + 44963100286335*f**11 + 11119138685424*f**12 + 1602818505288*f**13 + 102403357056*f**14)/1.8383656347651539e22,
    89: lambda f: (-2863025165 - 39152798685*f - 392552475666*f**2 - 2804865240099*f**3 - 15238012529493*f**4 - 65429401034790*f**5 - 185462761152540*f**6 - 341143143093522*f**7 - 422004025206225*f**8 - 361177823505807*f**9 - 215764895440710*f**10 - 88668808410105*f**11 - 23935700012301*f**12 - 3822537799080*f**13 - 273539402136*f**14)/2.2468913313796325e22,
    90: lambda f: (-74364290 - 1073453355*f - 11361199416*f**2 - 85795277442*f**3 - 493147624242*f**4 - 2242640510565*f**5 - 6231171098880*f**6 - 10494136721796*f**7 - 11190004083258*f**8 - 7759570813995*f**9 - 3499704488280*f**10 - 992272671390*f**11 - 160907244498*f**12 - 11397475089*f**13)/2.2760717382806667e22,
    91: lambda f: (-1561650090 - 23137434775*f - 251458515528*f**2 - 1953306628266*f**3 - 11573229908058*f**4 - 54335103061785*f**5 - 164391865812720*f**6 - 314100099231828*f**7 - 392869313185986*f**8 - 330893192196567*f**9 - 189494389604520*f**10 - 72898600885110*f**11 - 18056429024634*f**12 - 2604580071093*f**13 - 166405455216*f**14)/4.7797506503894e23,
    92: lambda f: (2863025165 + 42053005995*f + 453588968799*f**2 + 3496711153698*f**3 + 20555847787293*f**4 + 95798842864725*f**5 + 284454662630775*f**6 + 536223488150532*f**7 + 672541506498225*f**8 + 580401088934667*f**9 + 348533339829675*f**10 + 143695416694830*f**11 + 38862826263261*f**12 + 6211623923505*f**13 + 444501528471*f**14)/5.841917461587045e23,
    93: lambda f: (74364290 + 1148783415*f + 13032546120*f**2 + 105780008055*f**3 + 655342693110*f**4 + 3221553955095*f**5 + 9309412798140*f**6 + 15981631544151*f**7 + 17214502639698*f**8 + 12004510789635*f**9 + 5431326100200*f**10 + 1542492286335*f**11 + 250300158108*f**12 + 17729405694*f**13)/6.373000867185867e23,
    94: lambda f: (1561650090 + 24719366035*f + 287465392728*f**2 + 2395422026595*f**3 + 15264244075470*f**4 + 77282635472595*f**5 + 243717471402300*f**6 + 475709300745315*f**7 + 602008139231226*f**8 + 510494068287567*f**9 + 293532317977080*f**10 + 113190701899275*f**11 + 28072631927340*f**12 + 4051568999478*f**13 + 258852930336*f**14)/1.338330182109032e25,
    95: lambda f: (-2863025165 - 44953213305*f - 519039268560*f**2 - 4293980461065*f**3 - 27158429623770*f**4 - 136532724439545*f**5 - 421999137110460*f**6 - 811911511562697*f**7 - 1029868865977770*f**8 - 894772756339917*f**9 - 539571946111380*f**10 - 223039131960645*f**11 - 60412609067811*f**12 - 9662526103230*f**13 - 691446822066*f**14)/1.6357368892443725e25,
}

Q000withhex = {
    0: lambda f: (-3 - 2*f - f**2)/6.,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (15 + 20*f + 22*f**2 + 12*f**3 + 3*f**4)/120.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (-35 - 70*f - 119*f**2 - 124*f**3 - 81*f**4 - 30*f**5 - 5*f**6)/1680.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (0.125 + (f*(2 + f))/6. + (3*f**2*(2 + f)**2)/20. + (f**3*(2 + f)**3)/14. + (f**4*(2 + f)**4)/72.)/48.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (-0.0625 - (5*f*(2 + f))/48. - (f**2*(2 + f)**2)/8. - (5*f**3*(2 + f)**3)/56. - (5*f**4*(2 + f)**4)/144. - (f**5*(2 + f)**5)/176.)/240.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (0.03125 + (f*(2 + f))/16. + (3*f**2*(2 + f)**2)/32. + (5*f**3*(2 + f)**3)/56. + (5*f**4*(2 + f)**4)/96. + (3*f**5*(2 + f)**5)/176.)/1440.,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (-495 - 1155*f*(2 + f) - 2079*f**2*(2 + f)**2 - 2475*f**3*(2 + f)**3 - 1925*f**4*(2 + f)**4 - 945*f**5*(2 + f)**5)/3.193344e8,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (0.0078125 + (f*(2 + f))/48. + (7*f**2*(2 + f)**2)/160. + (f**3*(2 + f)**3)/16. + (35*f**4*(2 + f)**4)/576. + (7*f**5*(2 + f)**5)/176.)/80640.,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (-55 - 165*f*(2 + f) - 396*f**2*(2 + f)**2 - 660*f**3*(2 + f)**3 - 770*f**4*(2 + f)**4 - 630*f**5*(2 + f)**5)/1.02187008e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (231 + 770*f*(2 + f) + 2079*f**2*(2 + f)**2 + 3960*f**3*(2 + f)**3 + 5390*f**4*(2 + f)**4 + 5292*f**5*(2 + f)**5)/8.583708672e11,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (-21 - 77*f*(2 + f) - 231*f**2*(2 + f)**2 - 495*f**3*(2 + f)**3 - 770*f**4*(2 + f)**4 - 882*f**5*(2 + f)**5)/1.7167417344e12,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (105 + 420*f*(2 + f) + 1386*f**2*(2 + f)**2 + 3300*f**3*(2 + f)**3 + 5775*f**4*(2 + f)**4 + 7560*f**5*(2 + f)**5)/2.06009008128e14,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (-315 - 1365*f*(2 + f) - 4914*f**2*(2 + f)**2 - 12870*f**3*(2 + f)**3 - 25025*f**4*(2 + f)**4 - 36855*f**5*(2 + f)**5)/1.6068702633984e16,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (45 + 210*f*(2 + f) + 819*f**2*(2 + f)**2 + 2340*f**3*(2 + f)**3 + 5005*f**4*(2 + f)**4 + 8190*f**5*(2 + f)**5)/6.4274810535936e16,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (-3 - 30*f - 267*f**2 - 1812*f**3 - 9683*f**4 - 41938*f**5 - 76635*f**6 - 69160*f**7 - 33215*f**8 - 8190*f**9 - 819*f**10)/1.28549621071872e17,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (99 + 528*f*(2 + f) + 2376*f**2*(2 + f)**2 + 7920*f**3*(2 + f)**3 + 20020*f**4*(2 + f)**4 + 39312*f**5*(2 + f)**5)/1.3574839985189683e20,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: (-3 - 2*f - f**2)/18.,
    49: lambda f: (15 + 10*f + 2*f**2)/45.,
    50: lambda f: 0,
    51: lambda f: (15 + 20*f + 22*f**2 + 12*f**3 + 3*f**4)/180.,
    52: lambda f: (-105 - 140*f - 133*f**2 - 66*f**3 - 12*f**4)/630.,
    53: lambda f: 0,
    54: lambda f: (-35 - 70*f - 119*f**2 - 124*f**3 - 81*f**4 - 30*f**5 - 5*f**6)/1680.,
    55: lambda f: (105 + 210*f + 336*f**2 + 336*f**3 + 205*f**4 + 70*f**5 + 10*f**6)/2520.,
    56: lambda f: 0,
    57: lambda f: (315 + 840*f + 1932*f**2 + 2952*f**3 + 3098*f**4 + 2200*f**5 + 1020*f**6 + 280*f**7 + 35*f**8)/90720.,
    58: lambda f: (-3465 - 9240*f - 20559*f**2 - 30690*f**3 - 31207*f**4 - 21380*f**5 - 9465*f**6 - 2450*f**7 - 280*f**8)/498960.,
    59: lambda f: 0,
    60: lambda f: (-693 - 2310*f - 6699*f**2 - 13464*f**3 - 19426*f**4 - 20276*f**5 - 15270*f**6 - 8120*f**7 - 2905*f**8 - 630*f**9 - 63*f**10)/1.596672e6,
    61: lambda f: (45045 + 150150*f + 426426*f**2 + 844272*f**3 + 1195766*f**4 + 1222780*f**5 + 899040*f**6 + 464800*f**7 + 160685*f**8 + 33390*f**9 + 3150*f**10)/5.189184e7,
    62: lambda f: 0,
    63: lambda f: (3003 + 12012*f + 42042*f**2 + 104676*f**3 + 192049*f**4 + 264056*f**5 + 274524*f**6 + 215432*f**7 + 125965*f**8 + 53340*f**9 + 15498*f**10 + 2772*f**11 + 231*f**12)/6.918912e7,
    64: lambda f: (-15015 - 60060*f - 207207*f**2 - 510510*f**3 - 925210*f**4 - 1255280*f**5 - 1285670*f**6 - 992068*f**7 - 568995*f**8 - 235620*f**9 - 66675*f**10 - 11550*f**11 - 924*f**12)/1.729728e8,
    65: lambda f: 0,
    66: lambda f: (-6435 - 30030*f - 123123*f**2 - 365508*f**3 - 813527*f**4 - 1386970*f**5 - 1805655*f**6 - 1753240*f**7 - 1229225*f**8 - 598050*f**9 - 190485*f**10 - 35640*f**11 - 2970*f**12)/1.7791488e9,
    67: lambda f: (45045 + 210210*f + 852852*f**2 + 2512224*f**3 + 5542823*f**4 + 9361690*f**5 + 12053010*f**6 + 11522224*f**7 + 7904435*f**8 + 3740310*f**9 + 1152900*f**10 + 207900*f**11 + 16632*f**12)/6.2270208e9,
    68: lambda f: 0,
    69: lambda f: (6435 + 34320*f + 161304*f**2 + 555984*f**3 + 1454596*f**4 + 2958800*f**5 + 4538760*f**6 + 5017040*f**7 + 3855250*f**8 + 1990800*f**9 + 656460*f**10 + 124740*f**11 + 10395*f**12)/2.49080832e10,
    70: lambda f: (-6435 - 34320*f - 160017*f**2 - 548262*f**3 - 1424995*f**4 - 2878460*f**5 - 4374825*f**6 - 4758362*f**7 - 3568705*f**8 - 1786680*f**9 - 568575*f**10 - 103950*f**11 - 8316*f**12)/1.24540416e10,
    71: lambda f: 0,
    72: lambda f: (-715 - 4290*f - 22737*f**2 - 89232*f**3 - 268268*f**4 - 633880*f**5 - 1101140*f**6 - 1326640*f**7 - 1076810*f**8 - 574700*f**9 - 192990*f**10 - 36960*f**11 - 3080*f**12)/4.42810368e10,
    73: lambda f: (15015 + 90090*f + 474474*f**2 + 1853280*f**3 + 5543252*f**4 + 13027560*f**5 + 22445360*f**6 + 26587008*f**7 + 21023450*f**8 + 10857420*f**9 + 3513300*f**10 + 646800*f**11 + 51744*f**12)/4.649508864e11,
    74: lambda f: 0,
    75: lambda f: (3003 + 20020*f + 118118*f**2 + 519948*f**3 + 1765907*f**4 + 4752592*f**5 + 9099624*f**6 + 11652592*f**7 + 9807350*f**8 + 5344920*f**9 + 1815156*f**10 + 349272*f**11 + 29106*f**12)/3.34764638208e12,
    76: lambda f: (-15015 - 100100*f - 587587*f**2 - 2576574*f**3 - 8714992*f**4 - 23354240*f**5 - 44378700*f**6 - 55832168*f**7 - 45717490*f**8 - 24078600*f**9 - 7871850*f**10 - 1455300*f**11 - 116424*f**12)/8.3691159552e12,
    77: lambda f: 0,
    78: lambda f: (-273 - 2002*f - 13013*f**2 - 63492*f**3 - 240383*f**4 - 725842*f**5 - 1502643*f**6 - 2013424*f**7 - 1738730*f**8 - 961380*f**9 - 328986*f**10 - 63504*f**11 - 5292*f**12)/6.0866297856e12,
    79: lambda f: (15015 + 110110*f + 712712*f**2 + 3466320*f**3 + 13079495*f**4 + 39355810*f**5 + 80899590*f**6 + 106431136*f**7 + 89330990*f**8 + 47689740*f**9 + 15699600*f**10 + 2910600*f**11 + 232848*f**12)/1.67382319104e14,
    80: lambda f: 0,
    81: lambda f: (455 + 3640*f + 25844*f**2 + 138424*f**3 + 578006*f**4 + 1934920*f**5 + 4270580*f**6 + 5925640*f**7 + 5216225*f**8 + 2914800*f**9 + 1002960*f**10 + 194040*f**11 + 16170*f**12)/2.23176425472e14,
    82: lambda f: (-1365 - 10920*f - 77259*f**2 - 412698*f**3 - 1718431*f**4 - 5735860*f**5 - 12575065*f**6 - 17123106*f**7 - 14638890*f**8 - 7892640*f**9 - 2611350*f**10 - 485100*f**11 - 38808*f**12)/3.34764638208e14,
    83: lambda f: 0,
    84: lambda f: (-4095 - 35490*f - 273273*f**2 - 1594008*f**3 - 7276802*f**4 - 26745940*f**5 - 62271030*f**6 - 88831960*f**7 - 79365125*f**8 - 44707950*f**9 - 15447915*f**10 - 2993760*f**11 - 249480*f**12)/4.8206107901952e16,
    85: lambda f: (4095 + 35490*f + 272454*f**2 + 1585584*f**3 + 7221110*f**4 + 26476060*f**5 + 61250160*f**6 + 85710688*f**7 + 74325545*f**8 + 40376070*f**9 + 13409550*f**10 + 2494800*f**11 + 199584*f**12)/2.4103053950976e16,
    86: lambda f: 0,
    87: lambda f: (45 + 420*f + 3486*f**2 + 21996*f**3 + 108979*f**4 + 436280*f**5 + 1062780*f**6 + 1550600*f**7 + 1401805*f**8 + 794700*f**9 + 275490*f**10 + 53460*f**11 + 4455*f**12)/1.3773173686272e16,
    88: lambda f: (-315 - 2940*f - 24339*f**2 - 153270*f**3 - 757822*f**4 - 3027440*f**5 - 7329930*f**6 - 10487036*f**7 - 9197545*f**8 - 5026140*f**9 - 1674225*f**10 - 311850*f**11 - 24948*f**12)/4.8206107901952e16,
    89: lambda f: 0,
    90: lambda f: (-3 - 30*f - 267*f**2 - 1812*f**3 - 9683*f**4 - 41938*f**5 - 106203*f**6 - 157864*f**7 - 144095*f**8 - 82110*f**9 - 28539*f**10 - 5544*f**11 - 462*f**12)/2.57099242143744e16,
    91: lambda f: (165 + 1650*f + 14652*f**2 + 99264*f**3 + 529507*f**4 + 2289170*f**5 + 5763170*f**6 + 8398096*f**7 + 7433685*f**8 + 4081770*f**9 + 1362900*f**10 + 254100*f**11 + 20328*f**12)/7.07022915895296e17,
    92: lambda f: 0,
    93: lambda f: (99 + 1056*f + 10032*f**2 + 72864*f**3 + 417736*f**4 + 1946144*f**5 + 5096976*f**6 + 7695968*f**7 + 7081060*f**8 + 4052160*f**9 + 1411452*f**10 + 274428*f**11 + 22869*f**12)/2.5452824972230656e19,
    94: lambda f: (-3465 - 36960*f - 350427*f**2 - 2541330*f**3 - 14547005*f**4 - 67663540*f**5 - 176215935*f**6 - 260774374*f**7 - 232601285*f**8 - 128225160*f**9 - 42898275*f**10 - 8004150*f**11 - 640332*f**12)/4.454244370140365e20,
    95: lambda f: 0,
}

Q002withhex = {
    0: lambda f: 0,
    1: lambda f: -(f*(2 + f))/15.,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (f*(14 + 19*f + 12*f**2 + 3*f**3))/210.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: -(f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/2520.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/166320.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: -(f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/1.729728e7,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 242350*f**5 + 162400*f**6 + 67550*f**7 + 15750*f**8 + 1575*f**9))/1.729728e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: -(f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 607125*f**5 + 450800*f**6 + 198100*f**7 + 47250*f**8 + 4725*f**9))/2.0756736e9,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 182745*f**5 + 144200*f**6 + 65275*f**7 + 15750*f**8 + 1575*f**9))/4.1513472e9,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2395540*f**5 + 1967840*f**6 + 907480*f**7 + 220500*f**8 + 22050*f**9))/4.649508864e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1372740*f**5 + 1160320*f**6 + 541940*f**7 + 132300*f**8 + 13230*f**9))/2.7897053184e12,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2211525*f**5 + 1909600*f**6 + 900200*f**7 + 220500*f**8 + 22050*f**9))/5.5794106368e13,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 923375*f**5 + 810600*f**6 + 384825*f**7 + 94500*f**8 + 9450*f**9))/3.34764638208e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: -(f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1356690*f**5 + 1206800*f**6 + 576100*f**7 + 141750*f**8 + 14175*f**9))/8.034351316992e15,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 148230*f**5 + 133280*f**6 + 63910*f**7 + 15750*f**8 + 1575*f**9))/1.6068702633984e16,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: -(f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 321595*f**5 + 291760*f**6 + 140420*f**7 + 34650*f**8 + 3465*f**9))/7.07022915895296e17,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (f*(462 + 6171*f + 52140*f**2 + 325585*f**3 + 1602650*f**4 + 3033975*f**5 + 2773400*f**6 + 1338925*f**7 + 330750*f**8 + 33075*f**9))/1.4847481233801216e20,
    47: lambda f: 0,
    48: lambda f: (f*(2 + f))/45.,
    49: lambda f: -(f*(28 + 11*f))/315.,
    50: lambda f: 0,
    51: lambda f: -(f*(70 + 123*f + 100*f**2 + 28*f**3))/4200.,
    52: lambda f: (f*(294 + 357*f + 200*f**2 + 44*f**3))/2940.,
    53: lambda f: -(f*(490 + 749*f + 380*f**2 + 64*f**3))/29400.,
    54: lambda f: (f*(70 + 239*f + 400*f**2 + 349*f**3 + 160*f**4 + 30*f**5))/25200.,
    55: lambda f: -(f*(686 + 1414*f + 1580*f**2 + 1017*f**3 + 360*f**4 + 55*f**5))/17640.,
    56: lambda f: (f*(5390 + 12859*f + 14960*f**2 + 9939*f**3 + 3460*f**4 + 480*f**5))/646800.,
    57: lambda f: -(f*(2310 + 15411*f + 42900*f**2 + 65446*f**3 + 60890*f**4 + 34515*f**5 + 11060*f**6 + 1540*f**7))/9.9792e6,
    58: lambda f: (f*(61446 + 179025*f + 299640*f**2 + 320318*f**3 + 224650*f**4 + 100665*f**5 + 26320*f**6 + 3080*f**7))/6.98544e6,
    59: lambda f: -(f*(210210 + 681681*f + 1204060*f**2 + 1353846*f**3 + 986190*f**4 + 453065*f**5 + 118860*f**6 + 13440*f**7))/1.009008e8,
    60: lambda f: (f**2*(12012 + 57200*f + 133757*f**2 + 194470*f**3 + 187375*f**4 + 120820*f**5 + 50435*f**6 + 12390*f**7 + 1365*f**8))/8.64864e7,
    61: lambda f: -(f*(168168 + 633633*f + 1412840*f**2 + 2111122*f**3 + 2213020*f**4 + 1642840*f**5 + 850640*f**6 + 293510*f**7 + 60900*f**8 + 5775*f**9))/1.2108096e8,
    62: lambda f: (f*(210210 + 861861*f + 2024880*f**2 + 3180931*f**3 + 3486710*f**4 + 2693235*f**5 + 1441580*f**6 + 509845*f**7 + 107100*f**8 + 10080*f**9))/6.054048e8,
    63: lambda f: -(f*(-6006 + 7293*f + 128700*f**2 + 466336*f**3 + 974660*f**4 + 1365294*f**5 + 1346744*f**6 + 945700*f**7 + 465570*f**8 + 153405*f**9 + 30492*f**10 + 2772*f**11))/2.0756736e9,
    64: lambda f: (f*(1219218 + 5636631*f + 15701400*f**2 + 30135040*f**3 + 42038900*f**4 + 43564362*f**5 + 33692624*f**6 + 19258540*f**7 + 7922250*f**8 + 2224215*f**9 + 382536*f**10 + 30492*f**11))/7.2648576e9,
    65: lambda f: -(f*(3573570 + 17714697*f + 51780300*f**2 + 104102492*f**3 + 151678420*f**4 + 163750086*f**5 + 131544952*f**6 + 77829500*f**7 + 32996250*f**8 + 9493785*f**9 + 1660428*f**10 + 133056*f**11))/8.23350528e10,
    66: lambda f: (f*(-30030 - 61347*f + 171600*f**2 + 1327183*f**3 + 4003700*f**4 + 7909560*f**5 + 10765160*f**6 + 9846550*f**7 + 5868450*f**8 + 2178225*f**9 + 457380*f**10 + 41580*f**11))/6.2270208e10,
    67: lambda f: -(f*(714714 + 3915912*f + 13084500*f**2 + 30671459*f**3 + 53418700*f**4 + 69497811*f**5 + 66220672*f**6 + 44968070*f**7 + 21026250*f**8 + 6412770*f**9 + 1147608*f**10 + 91476*f**11))/4.35891456e10,
    68: lambda f: (f*(3573570 + 20777757*f + 72541040*f**2 + 177426977*f**3 + 321833800*f**4 + 436330330*f**5 + 432862360*f**6 + 304758650*f**7 + 146774250*f**8 + 45755325*f**9 + 8302140*f**10 + 665280*f**11))/8.23350528e11,
    69: lambda f: -(f*(-4290 - 15873*f - 14300*f**2 + 97682*f**3 + 503230*f**4 + 1471985*f**5 + 2619820*f**6 + 2811200*f**7 + 1832250*f**8 + 712425*f**9 + 152460*f**10 + 13860*f**11))/8.3026944e10,
    70: lambda f: (f*(78078 + 494637*f + 1927640*f**2 + 5337306*f**3 + 11145230*f**4 + 17062027*f**5 + 18390624*f**6 + 13588540*f**7 + 6704250*f**8 + 2108715*f**9 + 382536*f**10 + 30492*f**11))/5.81188608e10,
    71: lambda f: -(f*(3573570 + 23840817*f + 96705180*f**2 + 278380882*f**3 + 603593330*f**4 + 963808455*f**5 + 1083827780*f**6 + 831029500*f**7 + 422115750*f**8 + 135552375*f**9 + 24906420*f**10 + 1995840*f**11))/9.880206336e12,
    72: lambda f: (f*(-30030 - 148863*f - 343200*f**2 - 36218*f**3 + 2592380*f**4 + 13412910*f**5 + 30233000*f**6 + 36106630*f**7 + 24784200*f**8 + 9878400*f**9 + 2134440*f**10 + 194040*f**11))/6.974263296e12,
    73: lambda f: -(f*(924924 + 6651645*f + 29618160*f**2 + 94584412*f**3 + 230279000*f**4 + 398058696*f**5 + 464973152*f**6 + 361054540*f**7 + 183456000*f**8 + 58639770*f**9 + 10711008*f**10 + 853776*f**11))/9.7639686144e12,
    74: lambda f: (f*(3573570 + 26903877*f + 124272720*f**2 + 411295807*f**3 + 1036807730*f**4 + 1872016965*f**5 + 2285451140*f**6 + 1842747655*f**7 + 963695250*f**8 + 314289675*f**9 + 58114980*f**10 + 4656960*f**11))/1.38322888704e14,
    75: lambda f: -(f*(-50050 - 303017*f - 986700*f**2 - 1582412*f**3 + 1319480*f**4 + 28420740*f**5 + 79501520*f**6 + 102525640*f**7 + 72791460*f**8 + 29463210*f**9 + 6403320*f**10 + 582120*f**11))/1.67382319104e14,
    76: lambda f: (f*(686686 + 5526521*f + 27679080*f**2 + 100143524*f**3 + 278504440*f**4 + 528815484*f**5 + 653449888*f**6 + 524211800*f**7 + 271347300*f**8 + 87595830*f**9 + 16066512*f**10 + 1280664*f**11))/1.171676233728e14,
    77: lambda f: -(f*(3573570 + 29966937*f + 155243660*f**2 + 580503352*f**3 + 1667325320*f**4 + 3312338140*f**5 + 4284383600*f**6 + 3570549640*f**7 + 1901900700*f**8 + 626180310*f**9 + 116229960*f**10 + 9313920*f**11))/2.213166219264e15,
    78: lambda f: (f*(-2002 - 14157*f - 57200*f**2 - 141271*f**3 - 151560*f**4 + 1405066*f**5 + 4815216*f**6 + 6579300*f**7 + 4783380*f**8 + 1956570*f**9 + 426888*f**10 + 38808*f**11))/1.11588212736e14,
    79: lambda f: -(f*(126126 + 1123122*f + 6249100*f**2 + 25262185*f**3 + 79005600*f**4 + 161642443*f**5 + 208188736*f**6 + 170895060*f**7 + 89596500*f**8 + 29117760*f**9 + 5355504*f**10 + 426888*f**11))/3.90558744576e14,
    80: lambda f: (f*(1191190 + 11009999*f + 63206000*f**2 + 263445039*f**3 + 848997340*f**4 + 1820568012*f**5 + 2457639184*f**6 + 2096534300*f**7 + 1130944500*f**8 + 374748570*f**9 + 69737976*f**10 + 5588352*f**11))/1.3278997315584e16,
    81: lambda f: -(f*(-6370 - 51233*f - 243100*f**2 - 762138*f**3 - 1490150*f**4 + 5371155*f**5 + 22378580*f**6 + 31987900*f**7 + 23669100*f**8 + 9755550*f**9 + 2134440*f**10 + 194040*f**11))/6.69529276416e15,
    82: lambda f: (f*(75166 + 733733*f + 4490200*f**2 + 20057726*f**3 + 69675850*f**4 + 151481993*f**5 + 201393136*f**6 + 168160160*f**7 + 88987500*f**8 + 29060010*f**9 + 5355504*f**10 + 426888*f**11))/4.686704934912e15,
    83: lambda f: -(f*(1191190 + 12031019*f + 75798580*f**2 + 348374234*f**3 + 1244550450*f**4 + 2840865495*f**5 + 3962995540*f**6 + 3439868600*f**7 + 1872769500*f**8 + 623438550*f**9 + 116229960*f**10 + 9313920*f**11))/2.6557994631168e17,
    84: lambda f: (f*(-5460 - 49062*f - 265200*f**2 - 984217*f**3 - 2532230*f**4 + 5381145*f**5 + 27161260*f**6 + 40254725*f**7 + 30192750*f**8 + 12516525*f**9 + 2744280*f**10 + 249480*f**11))/1.2051526975488e17,
    85: lambda f: -(f*(122304 + 1298661*f + 8668920*f**2 + 42403478*f**3 + 161984740*f**4 + 370361952*f**5 + 504884464*f**6 + 427151690*f**7 + 227650500*f**8 + 74614365*f**9 + 13771296*f**10 + 1097712*f**11))/1.68721377656832e17,
    86: lambda f: (f*(324870 + 3559647*f + 24416080*f**2 + 122654337*f**3 + 481013130*f**4 + 1156640645*f**5 + 1656015060*f**6 + 1456798875*f**7 + 798714000*f**8 + 266820750*f**9 + 49812840*f**10 + 3991680*f**11))/1.59347967787008e18,
    87: lambda f: -(f*(-630 - 6243*f - 37700*f**2 - 159848*f**3 - 492820*f**4 + 706490*f**5 + 4320680*f**6 + 6596380*f**7 + 5001150*f**8 + 2082675*f**9 + 457380*f**10 + 41580*f**11))/3.2137405267968e17,
    88: lambda f: (f*(6762 + 77595*f + 561080*f**2 + 2982616*f**3 + 12426700*f**4 + 29643766*f**5 + 41238512*f**6 + 35255780*f**7 + 18894750*f**8 + 6210645*f**9 + 1147608*f**10 + 91476*f**11))/2.24961836875776e17,
    89: lambda f: -(f*(3573570 + 42219177*f + 313161420*f**2 + 1706891732*f**3 + 7289309980*f**4 + 18316637250*f**5 + 26783670760*f**6 + 23813908580*f**7 + 13128711750*f**8 + 4397829975*f**9 + 821911860*f**10 + 65862720*f**11))/4.206786349577011e20,
    90: lambda f: (f*(-1650 - 17853*f - 118800*f**2 - 563183*f**3 - 1993180*f**4 + 2049420*f**5 + 15244040*f**6 + 23856910*f**7 + 18246690*f**8 + 7626465*f**9 + 1677060*f**10 + 152460*f**11))/2.121068747685888e19,
    91: lambda f: -(f*(17094 + 210804*f + 1641420*f**2 + 9422141*f**3 + 42518860*f**4 + 105169377*f**5 + 148773184*f**6 + 128275070*f**7 + 69057450*f**8 + 22751190*f**9 + 4207896*f**10 + 335412*f**11))/1.4847481233801216e19,
    92: lambda f: (f*(274890 + 3483249*f + 27780720*f**2 + 163272029*f**3 + 754152640*f**4 + 1967884470*f**5 + 2928181480*f**6 + 2626173830*f**7 + 1454295150*f**8 + 488228895*f**9 + 91323540*f**10 + 7318080*f**11))/8.413572699154022e20,
    93: lambda f: -(f*(-5082 - 59565*f - 432300*f**2 - 2257934*f**3 - 8950690*f**4 + 6797889*f**5 + 61986764*f**6 + 99068200*f**7 + 76323870*f**8 + 31996755*f**9 + 7043652*f**10 + 640332*f**11))/1.781697748056146e21,
    94: lambda f: (f*(255486 + 3369597*f + 28109400*f**2 + 173283490*f**3 + 841970150*f**4 + 2148764247*f**5 + 3082622144*f**6 + 2676686740*f**7 + 1446369750*f**8 + 477411165*f**9 + 88365816*f**10 + 7043652*f**11))/6.235942118196511e21,
    95: lambda f: -(f*(274890 + 3718869*f + 31733900*f**2 + 200035634*f**3 + 993615490*f**4 + 2678870047*f**5 + 4044979204*f**6 + 3653974100*f**7 + 2030915250*f**8 + 683040645*f**9 + 127852956*f**10 + 10245312*f**11))/2.3558003557631263e22,
}

Q004withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (f**2*(2 + f)**2)/315.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: -(f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/6930.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/360360.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: -(f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/2.16216e6,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (f**2*(2 + f)**2*(143 + 520*f + 1100*f**2 + 1512*f**3 + 1218*f**4 + 504*f**5 + 84*f**6))/1.729728e7,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: -(f**2*(2 + f)**2*(143 + 650*f + 1725*f**2 + 3080*f**3 + 2870*f**4 + 1260*f**5 + 210*f**6))/1.729728e8,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (f**2*(2 + f)**2*(143 + 780*f + 2490*f**2 + 5460*f**3 + 5565*f**4 + 2520*f**5 + 420*f**6))/2.0756736e9,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: -(f**2*(2 + f)**2*(143 + 910*f + 3395*f**2 + 8820*f**3 + 9555*f**4 + 4410*f**5 + 735*f**6))/2.90594304e10,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (f**2*(2 + f)**2*(143 + 1040*f + 4440*f**2 + 13328*f**3 + 15092*f**4 + 7056*f**5 + 1176*f**6))/4.649508864e11,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: -(f**2*(2 + f)**2*(143 + 1170*f + 5625*f**2 + 19152*f**3 + 22428*f**4 + 10584*f**5 + 1764*f**6))/8.3691159552e12,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (f**2*(2 + f)**2*(143 + 1300*f + 6950*f**2 + 26460*f**3 + 31815*f**4 + 15120*f**5 + 2520*f**6))/1.67382319104e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: -(f**2*(2 + f)**2*(13 + 130*f + 765*f**2 + 3220*f**3 + 3955*f**4 + 1890*f**5 + 315*f**6))/3.34764638208e14,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (f**2*(2 + f)**2*(143 + 1560*f + 10020*f**2 + 46200*f**3 + 57750*f**4 + 27720*f**5 + 4620*f**6))/8.8377864486912e16,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: -(f**2*(2 + f)**2*(11 + 130*f + 905*f**2 + 4536*f**3 + 5754*f**4 + 2772*f**5 + 462*f**6))/1.76755728973824e17,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (f**2*(2 + f)**2*(11 + 140*f + 1050*f**2 + 5684*f**3 + 7301*f**4 + 3528*f**5 + 588*f**6))/4.949160411267072e18,
    48: lambda f: 0,
    49: lambda f: (4*f**2)/315.,
    50: lambda f: 0,
    51: lambda f: (-2*f**2*(2 + f))/945.,
    52: lambda f: (-2*f**2*(77 + 64*f + 18*f**2))/6615.,
    53: lambda f: (2*f**2*(154 + 155*f + 39*f**2))/24255.,
    54: lambda f: (f**2*(132 + 170*f + 82*f**2 + 15*f**3))/20790.,
    55: lambda f: (f**2*(6237 + 10412*f + 7970*f**2 + 3065*f**3 + 495*f**4))/436590.,
    56: lambda f: -(f**2*(6776 + 11418*f + 8665*f**2 + 3495*f**3 + 585*f**4))/533610.,
    57: lambda f: -(f**2*(1430 + 3107*f + 3186*f**2 + 1815*f**3 + 550*f**4 + 70*f**5))/540540.,
    58: lambda f: -(f**2*(51051 + 129740*f + 165888*f**2 + 126645*f**3 + 58935*f**4 + 15575*f**5 + 1820*f**6))/1.135134e7,
    59: lambda f: (f**2*(66066 + 166309*f + 210248*f**2 + 161985*f**3 + 77710*f**4 + 21770*f**5 + 2730*f**6))/1.387386e7,
    60: lambda f: (f**2*(4004 + 12298*f + 19278*f**2 + 18705*f**3 + 11700*f**4 + 4620*f**5 + 1050*f**6 + 105*f**7))/6.48648e6,
    61: lambda f: (f**2*(83083 + 284856*f + 513668*f**2 + 591530*f**3 + 459750*f**4 + 242060*f**5 + 83300*f**6 + 17010*f**7 + 1575*f**8))/9.081072e7,
    62: lambda f: -(f**2*(176176 + 596882*f + 1064067*f**2 + 1223685*f**3 + 961725*f**4 + 520380*f**5 + 187425*f**6 + 40845*f**7 + 4095*f**8))/1.6648632e8,
    63: lambda f: -(f**2*(43758 + 173927*f + 366724*f**2 + 503166*f**3 + 478116*f**4 + 319620*f**5 + 148260*f**6 + 45570*f**7 + 8358*f**8 + 693*f**9))/4.4108064e8,
    64: lambda f: -(f**2*(6279273 + 27147640*f + 63339790*f**2 + 97822930*f**3 + 106995270*f**4 + 84856002*f**5 + 48782580*f**6 + 19900230*f**7 + 5481105*f**8 + 917070*f**9 + 70686*f**10))/4.63134672e10,
    65: lambda f: (f**2*(1871870 + 8000421*f + 18468103*f**2 + 28386906*f**3 + 31136592*f**4 + 25004364*f**5 + 14724150*f**6 + 6235110*f**7 + 1808898*f**8 + 323631*f**9 + 27027*f**10))/1.132106976e10,
    66: lambda f: (f**2*(106964 + 522002*f + 1382610*f**2 + 2452335*f**3 + 2979160*f**4 + 2434600*f**5 + 1304100*f**6 + 437850*f**7 + 83580*f**8 + 6930*f**9))/8.8216128e9,
    67: lambda f: (f**2*(2909907 + 15196844*f + 43551858*f**2 + 84478185*f**3 + 116245215*f**4 + 113282204*f**5 + 76942460*f**6 + 35462910*f**7 + 10560585*f**8 + 1834140*f**9 + 141372*f**10))/1.852538688e11,
    68: lambda f: -(f**2*(4492488 + 23216050*f + 65888753*f**2 + 127055535*f**3 + 173647645*f**4 + 168980840*f**5 + 116307450*f**6 + 55407450*f**7 + 17392830*f**8 + 3236310*f**9 + 270270*f**10))/2.264213952e11,
    69: lambda f: -(f**2*(63206 + 365755*f + 1166166*f**2 + 2536485*f**3 + 3614490*f**4 + 3277050*f**5 + 1866900*f**6 + 647850*f**7 + 125370*f**8 + 10395*f**9))/5.29296768e10,
    70: lambda f: -(f**2*(551837 + 3379532*f + 11490980*f**2 + 26847845*f**3 + 43428615*f**4 + 47677427*f**5 + 35085680*f**6 + 17008530*f**7 + 5213355*f**8 + 917070*f**9 + 70686*f**10))/3.705077376e11,
    71: lambda f: (f**2*(2620618 + 15896309*f + 53572950*f**2 + 124400475*f**3 + 197959110*f**4 + 214790310*f**5 + 159226200*f**6 + 79639350*f**7 + 25741170*f**8 + 4854465*f**9 + 405405*f**10))/1.3585283712e12,
    72: lambda f: (f**2*(145860 + 976378*f + 3639734*f**2 + 9376605*f**3 + 14939820*f**4 + 14426580*f**5 + 8503950*f**6 + 3002475*f**7 + 585060*f**8 + 48510*f**9))/1.4820309504e12,
    73: lambda f: (f**2*(14855841 + 104400400*f + 410870008*f**2 + 1123324300*f**3 + 2047092180*f**4 + 2426366712*f**5 + 1870869000*f**6 + 932235780*f**7 + 290073630*f**8 + 51355920*f**9 + 3958416*f**10))/1.244905998336e14,
    74: lambda f: -(f**2*(5989984 + 41730546*f + 162906767*f**2 + 442681785*f**3 + 786742005*f**4 + 914689860*f**5 + 707832195*f**6 + 363549375*f**7 + 119313285*f**8 + 22654170*f**9 + 1891890*f**10))/3.80387943936e13,
    75: lambda f: -(f**2*(82654 + 628303*f + 2680968*f**2 + 7981500*f**3 + 13809320*f**4 + 13910120*f**5 + 8379000*f**6 + 2989980*f**7 + 585060*f**8 + 48510*f**9))/1.18562476032e13,
    76: lambda f: -(f**2*(2059057 + 16332784*f + 73033122*f**2 + 228752340*f**3 + 456666780*f**4 + 570797668*f**5 + 453714520*f**6 + 230022660*f**7 + 72237270*f**8 + 12838980*f**9 + 989604*f**10))/2.489811996672e14,
    77: lambda f: (f**2*(3369366 + 26514917*f + 117685237*f**2 + 366444180*f**3 + 707993840*f**4 + 863127160*f**5 + 686828100*f**6 + 358688820*f**7 + 118825980*f**8 + 22654170*f**9 + 1891890*f**10))/3.043103551488e14,
    78: lambda f: (f**2*(184756 + 1572194*f + 7556058*f**2 + 25523307*f**3 + 47045232*f**4 + 48842640*f**5 + 29864520*f**6 + 10733940*f**7 + 2106216*f**8 + 174636*f**9))/4.268249137152e14,
    79: lambda f: (f**2*(7538531 + 66622660*f + 333652710*f**2 + 1178035995*f**3 + 2527043805*f**4 + 3283728168*f**5 + 2666523720*f**6 + 1367990820*f**7 + 432299070*f**8 + 77033880*f**9 + 5937624*f**10))/1.4938871980032e16,
    80: lambda f: -(f**2*(7487480 + 65690482*f + 326736141*f**2 + 1147129587*f**3 + 2365735509*f**4 + 2985283728*f**5 + 2422394100*f**6 + 1279614420*f**7 + 426603996*f**8 + 81555012*f**9 + 6810804*f**10))/1.09551727853568e16,
    81: lambda f: -(f**2*(102102 + 961571*f + 5139610*f**2 + 19420035*f**3 + 37636110*f**4 + 39970350*f**5 + 24708600*f**6 + 8927100*f**7 + 1755180*f**8 + 145530*f**9))/4.268249137152e15,
    82: lambda f: -(f**2*(2464371 + 24012092*f + 133146584*f**2 + 523207385*f**3 + 1189456515*f**4 + 1592053659*f**5 + 1313412660*f**6 + 679657860*f**7 + 215747910*f**8 + 38516940*f**9 + 2968812*f**10))/8.9633231880192e16,
    83: lambda f: (f**2*(4118114 + 39856245*f + 219601444*f**2 + 858316485*f**3 + 1865138670*f**4 + 2415925890*f**5 + 1988887950*f**6 + 1059401700*f**7 + 354807180*f**8 + 67962510*f**9 + 5675670*f**10))/1.09551727853568e17,
    84: lambda f: (f**2*(20332 + 209950*f + 1235322*f**2 + 5162475*f**3 + 10420460*f**4 + 11263700*f**5 + 7021350*f**6 + 2546775*f**7 + 501480*f**8 + 41580*f**9))/1.7072996548608e16,
    85: lambda f: (f**2*(969969 + 10330424*f + 62830980*f**2 + 271970250*f**3 + 648608070*f**4 + 888586748*f**5 + 742036820*f**6 + 386516970*f**7 + 123112395*f**8 + 22009680*f**9 + 1696464*f**10))/7.17065855041536e17,
    86: lambda f: -(f**2*(816816 + 8645078*f + 52269985*f**2 + 225104055*f**3 + 510556055*f**4 + 675008740*f**5 + 561890175*f**6 + 301198275*f**7 + 101224305*f**8 + 19417860*f**9 + 1621620*f**10))/4.38206911414272e17,
    87: lambda f: -(f**2*(121550 + 1365559*f + 8770572*f**2 + 40165050*f**3 + 83851020*f**4 + 91924140*f**5 + 57680700*f**6 + 20986350*f**7 + 4137210*f**8 + 343035*f**9))/2.253635544416256e18,
    88: lambda f: -(f**2*(956879 + 11058840*f + 73203802*f**2 + 346092970*f**3 + 859159950*f**4 + 1199341066*f**5 + 1011245620*f**6 + 529472790*f**7 + 169095465*f**8 + 30263310*f**9 + 2332638*f**10))/1.5775448810913792e19,
    89: lambda f: (f**2*(4866862 + 55920293*f + 368118051*f**2 + 1731964590*f**3 + 4070984160*f**4 + 5471609220*f**5 + 4594846410*f**6 + 2475338250*f**7 + 834143310*f**8 + 160197345*f**9 + 13378365*f**10))/5.78433123066839e19,
    90: lambda f: (f**2*(20196 + 245242*f + 1707242*f**2 + 8501955*f**3 + 18259560*f**4 + 20249880*f**5 + 12774300*f**6 + 4659270*f**7 + 919380*f**8 + 76230*f**9))/9.014542177665024e18,
    91: lambda f: (f**2*(472923 + 5894716*f + 42188458*f**2 + 216305365*f**3 + 555591315*f**4 + 787649604*f**5 + 669342660*f**6 + 351921570*f**7 + 112632135*f**8 + 20175540*f**9 + 1555092*f**10))/1.893053857309655e20,
    92: lambda f: -(f**2*(806344 + 9995898*f + 71169293*f**2 + 363213075*f**3 + 879904545*f**4 + 1198729560*f**5 + 1013845350*f**6 + 548377830*f**7 + 185195010*f**8 + 35599410*f**9 + 2972970*f**10))/2.313732492267356e20,
    93: lambda f: -(f**2*(10846 + 141559*f + 1061718*f**2 + 5712357*f**3 + 12568682*f**4 + 14073290*f**5 + 8917020*f**6 + 3258990*f**7 + 643566*f**8 + 53361*f**9))/1.2620359048731034e20,
    94: lambda f: -(f**2*(1260567 + 16856180*f + 129702180*f**2 + 716804235*f**3 + 1895950665*f**4 + 2722833029*f**5 + 2328913160*f**6 + 1228689210*f**7 + 393931335*f**8 + 70614390*f**9 + 5442822*f**10))/1.3251377001167585e22,
    95: lambda f: (f**2*(431970 + 5746697*f + 44002426*f**2 + 242114187*f**3 + 601908734*f**4 + 829316278*f**5 + 705555900*f**6 + 382892370*f**7 + 129539046*f**8 + 24919587*f**9 + 2081079*f**10))/3.2392254891742986e21,
}

Q020withhex = {
    0: lambda f: -(f*(2 + f))/3.,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (f*(14 + 19*f + 12*f**2 + 3*f**3))/42.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: -(f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/504.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/33264.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: -(f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/3.459456e6,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 242350*f**5 + 162400*f**6 + 67550*f**7 + 15750*f**8 + 1575*f**9))/3.459456e7,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: -(f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 607125*f**5 + 450800*f**6 + 198100*f**7 + 47250*f**8 + 4725*f**9))/4.1513472e8,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 182745*f**5 + 144200*f**6 + 65275*f**7 + 15750*f**8 + 1575*f**9))/8.3026944e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2395540*f**5 + 1967840*f**6 + 907480*f**7 + 220500*f**8 + 22050*f**9))/9.299017728e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1372740*f**5 + 1160320*f**6 + 541940*f**7 + 132300*f**8 + 13230*f**9))/5.5794106368e11,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2211525*f**5 + 1909600*f**6 + 900200*f**7 + 220500*f**8 + 22050*f**9))/1.11588212736e13,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 923375*f**5 + 810600*f**6 + 384825*f**7 + 94500*f**8 + 9450*f**9))/6.69529276416e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: -(f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1356690*f**5 + 1206800*f**6 + 576100*f**7 + 141750*f**8 + 14175*f**9))/1.6068702633984e15,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 148230*f**5 + 133280*f**6 + 63910*f**7 + 15750*f**8 + 1575*f**9))/3.2137405267968e15,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: -(f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 321595*f**5 + 291760*f**6 + 140420*f**7 + 34650*f**8 + 3465*f**9))/1.414045831790592e17,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (f*(462 + 6171*f + 52140*f**2 + 325585*f**3 + 1602650*f**4 + 3033975*f**5 + 2773400*f**6 + 1338925*f**7 + 330750*f**8 + 33075*f**9))/2.969496246760243e19,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: -(f*(2 + f))/9.,
    49: lambda f: (f*(28 + 11*f))/63.,
    50: lambda f: 0,
    51: lambda f: (f*(14 + 19*f + 12*f**2 + 3*f**3))/63.,
    52: lambda f: -(f*(56 + 73*f + 42*f**2 + 9*f**3))/126.,
    53: lambda f: 0,
    54: lambda f: -(f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/504.,
    55: lambda f: (f*(924 + 2013*f + 2332*f**2 + 1550*f**3 + 560*f**4 + 85*f**5))/5544.,
    56: lambda f: 0,
    57: lambda f: (f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/24948.,
    58: lambda f: -(f*(48048 + 146289*f + 253110*f**2 + 279487*f**3 + 201860*f**4 + 92775*f**5 + 24710*f**6 + 2905*f**7))/1.297296e6,
    59: lambda f: 0,
    60: lambda f: (-5*f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/1.0378368e7,
    61: lambda f: (f*(60060 + 234663*f + 538824*f**2 + 828932*f**3 + 893680*f**4 + 681498*f**5 + 361816*f**6 + 127652*f**7 + 26964*f**8 + 2583*f**9))/1.0378368e7,
    62: lambda f: 0,
    63: lambda f: (f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 257134*f**5 + 206752*f**6 + 122990*f**7 + 52710*f**8 + 15435*f**9 + 2772*f**10 + 231*f**11))/1.729728e7,
    64: lambda f: -(f*(408408 + 1947231*f + 5566990*f**2 + 10964915*f**3 + 15691000*f**4 + 16673022*f**5 + 13213844*f**6 + 7732830*f**7 + 3252480*f**8 + 931875*f**9 + 163086*f**10 + 13167*f**11))/5.8810752e8,
    65: lambda f: 0,
    66: lambda f: -(f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 683157*f**5 + 678896*f**6 + 483220*f**7 + 237330*f**8 + 76005*f**9 + 14256*f**10 + 1188*f**11))/1.7791488e8,
    67: lambda f: (f*(1429428 + 8044179*f + 27509196*f**2 + 65995462*f**3 + 117612800*f**4 + 157030581*f**5 + 153987512*f**6 + 107627380*f**7 + 51668820*f**8 + 16115085*f**9 + 2935548*f**10 + 237006*f**11))/2.117187072e10,
    68: lambda f: 0,
    69: lambda f: (f*(3432 + 22308*f + 89232*f**2 + 253708*f**3 + 544280*f**4 + 864036*f**5 + 975968*f**6 + 760060*f**7 + 395640*f**8 + 131040*f**9 + 24948*f**10 + 2079*f**11))/1.24540416e9,
    70: lambda f: -(f*(1633632 + 10596729*f + 42168126*f**2 + 119219555*f**3 + 254186380*f**4 + 400287321*f**5 + 446018482*f**6 + 340447835*f**7 + 172819080*f**8 + 55634355*f**9 + 10274418*f**10 + 829521*f**11))/2.9640619008e11,
    71: lambda f: 0,
    72: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2947476*f**5 + 3623648*f**6 + 2977240*f**7 + 1600340*f**8 + 539490*f**9 + 103488*f**10 + 8624*f**11))/3.099672576e10,
    73: lambda f: (f*(612612 + 4499781*f + 20420400*f**2 + 66460888*f**3 + 164905440*f**4 + 294090412*f**5 + 356462064*f**6 + 286663720*f**7 + 150051720*f**8 + 49111230*f**9 + 9132816*f**10 + 737352*f**11))/1.58083301376e12,
    74: lambda f: 0,
    75: lambda f: (f*(10010 + 82225*f + 420420*f**2 + 1553305*f**3 + 4412600*f**4 + 8726484*f**5 + 11389952*f**6 + 9695140*f**7 + 5318460*f**8 + 1812510*f**9 + 349272*f**10 + 29106*f**11))/8.3691159552e11,
    76: lambda f: -(f*(680680 + 5584007*f + 28457286*f**2 + 104763503*f**3 + 296462320*f**4 + 582526284*f**5 + 749217448*f**6 + 623590268*f**7 + 332803296*f**8 + 110039202*f**9 + 20548836*f**10 + 1659042*f**11))/2.845499424768e13,
    77: lambda f: 0,
    78: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2888901*f**5 + 3941728*f**6 + 3440360*f**7 + 1913940*f**8 + 657090*f**9 + 127008*f**10 + 10584*f**11))/3.0433148928e12,
    79: lambda f: (f*(748748 + 6784921*f + 38361180*f**2 + 157579630*f**3 + 500786000*f**4 + 1063407069*f**5 + 1429125488*f**6 + 1218774760*f**7 + 659189160*f**8 + 219463650*f**9 + 41097672*f**10 + 3318084*f**11))/5.690998849536e14,
    80: lambda f: 0,
    81: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1233839*f**5 + 1741992*f**6 + 1549065*f**7 + 870660*f**8 + 300510*f**9 + 58212*f**10 + 4851*f**11))/1.67382319104e13,
    82: lambda f: -(f*(74256 + 736593*f + 4575142*f**2 + 20742839*f**3 + 73135700*f**4 + 165482539*f**5 + 230036478*f**6 + 199759245*f**7 + 109100880*f**8 + 36504090*f**9 + 6849612*f**10 + 553014*f**11))/1.1381997699072e15,
    83: lambda f: 0,
    84: lambda f: -(f*(7098 + 76557*f + 519168*f**2 + 2580292*f**3 + 10017020*f**4 + 24023658*f**5 + 34848464*f**6 + 31439380*f**7 + 17809470*f**8 + 6171795*f**9 + 1197504*f**10 + 99792*f**11))/4.8206107901952e15,
    85: lambda f: (f*(241332 + 2600949*f + 17603976*f**2 + 87308260*f**3 + 338181680*f**4 + 806766042*f**5 + 1151904824*f**6 + 1014370420*f**7 + 558143460*f**8 + 187453035*f**9 + 35226576*f**10 + 2844072*f**11))/8.19503834333184e16,
    86: lambda f: 0,
    87: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 205254*f**5 + 304352*f**6 + 277750*f**7 + 158310*f**8 + 55035*f**9 + 10692*f**10 + 891*f**11))/6.886586843136e14,
    88: lambda f: -(f*(219912 + 2558721*f + 18743010*f**2 + 100933573*f**3 + 426022040*f**4 + 1062829494*f**5 + 1550823428*f**6 + 1380926470*f**7 + 764295840*f**8 + 257446035*f**9 + 48436542*f**10 + 3910599*f**11))/1.8029084355330048e18,
    89: lambda f: 0,
    90: lambda f: -(f*(330 + 4125*f + 32560*f**2 + 189490*f**3 + 867050*f**4 + 2258471*f**5 + 3410288*f**6 + 3141460*f**7 + 1799490*f**8 + 627165*f**9 + 121968*f**10 + 10164*f**11))/1.414045831790592e17,
    91: lambda f: (f*(78540 + 981189*f + 7733572*f**2 + 44936066*f**3 + 205270240*f**4 + 532119567*f**5 + 790509944*f**6 + 710308116*f**7 + 394994292*f**8 + 133365309*f**9 + 25115244*f**10 + 2027718*f**11))/1.6827145398308045e19,
    92: lambda f: 0,
    93: lambda f: (f*(3696 + 49368*f + 417120*f**2 + 2604680*f**3 + 12821200*f**4 + 34517112*f**5 + 52923136*f**6 + 49131320*f**7 + 28259280*f**8 + 9869580*f**9 + 1920996*f**10 + 160083*f**11))/4.454244370140365e19,
    94: lambda f: -(f*(251328 + 3355341*f + 28313670*f**2 + 176557495*f**3 + 867807500*f**4 + 2325588321*f**5 + 3507413042*f**6 + 3175329115*f**7 + 1772661240*f**8 + 599682825*f**9 + 113018598*f**10 + 9124731*f**11))/1.514443085847724e21,
    95: lambda f: 0,
}

Q022withhex = {
    0: lambda f: 0,
    1: lambda f: (-21 - 22*f - 11*f**2)/42.,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (21 + 44*f + 58*f**2 + 36*f**3 + 9*f**4)/168.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (-231 - 726*f - 1551*f**2 - 1868*f**3 - 1317*f**4 - 510*f**5 - 85*f**6)/11088.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (9009 + 37752*f + 111540*f**2 + 198744*f**3 + 228766*f**4 + 172520*f**5 + 82980*f**6 + 23240*f**7 + 2905*f**8)/3.459456e6,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (-9009 - 47190*f - 178035*f**2 - 419640*f**3 - 668810*f**4 - 746356*f**5 - 588390*f**6 - 322840*f**7 - 117845*f**8 - 25830*f**9 - 2583*f**10)/3.459456e7,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (3003 + 18876*f + 86658*f**2 + 254020*f**3 + 516905*f**4 + 762712*f**5 + 783980*f**6 + 529480*f**7 + 221165*f**8 + 51660*f**9 + 5166*f**10)/1.3837824e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (-1287 - 9438*f - 51051*f**2 - 178932*f**3 - 442883*f**4 - 812218*f**5 - 985095*f**6 - 736120*f**7 - 324485*f**8 - 77490*f**9 - 7749*f**10)/8.3026944e8,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (9009 + 75504*f + 470184*f**2 + 1917552*f**3 + 5589388*f**4 + 12249776*f**5 + 16637880*f**6 + 13198640*f**7 + 5989270*f**8 + 1446480*f**9 + 144648*f**10)/9.299017728e10,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (-1001 - 9438*f - 66495*f**2 - 309296*f**3 - 1037444*f**4 - 2644264*f**5 - 3899980*f**6 - 3218320*f**7 - 1487150*f**8 - 361620*f**9 - 36162*f**10)/1.8598035456e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (3003 + 31460*f + 247390*f**2 + 1292460*f**3 + 4902715*f**4 + 14245904*f**5 + 22370760*f**6 + 18984560*f**7 + 8882230*f**8 + 2169720*f**9 + 216972*f**10)/1.11588212736e13,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (-273 - 3146*f - 27313*f**2 - 158340*f**3 - 670135*f**4 - 2186234*f**5 - 3606735*f**6 - 3125360*f**7 - 1475530*f**8 - 361620*f**9 - 36162*f**10)/2.23176425472e13,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (273 + 3432*f + 32604*f**2 + 207688*f**3 + 970122*f**4 + 3510744*f**5 + 6027260*f**6 + 5307960*f**7 + 2523255*f**8 + 619920*f**9 + 61992*f**10)/5.356234211328e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (-63 - 858*f - 8853*f**2 - 61464*f**3 - 314066*f**4 - 1248484*f**5 - 2214990*f**6 - 1975960*f**7 - 944405*f**8 - 232470*f**9 - 23247*f**10)/3.2137405267968e15,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (99 + 1452*f + 16170*f**2 + 121524*f**3 + 674261*f**4 + 2920552*f**5 + 5326260*f**6 + 4801720*f**7 + 2304995*f**8 + 568260*f**9 + 56826*f**10)/1.414045831790592e17,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (-231 - 3630*f - 43395*f**2 - 350980*f**3 - 2101295*f**4 - 9850162*f**5 - 18390155*f**6 - 16724680*f**7 - 8057315*f**8 - 1988910*f**9 - 198891*f**10)/9.898320822534144e18,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (693 + 11616*f + 148368*f**2 + 1284960*f**3 + 8256440*f**4 + 41643616*f**5 + 79334640*f**6 + 72684640*f**7 + 35122220*f**8 + 8678880*f**9 + 867888*f**10)/9.502387989632778e20,
    47: lambda f: 0,
    48: lambda f: -0.041666666666666664 + (29*f)/630. + (2*f**2)/45.,
    49: lambda f: (-735 - 616*f - 242*f**2)/1764.,
    50: lambda f: 0.125 + (9*f)/70. + (8*f**2)/245.,
    51: lambda f: (35 - 2*f - 91*f**2 - 100*f**3 - 32*f**4)/1680.,
    52: lambda f: (245 + 462*f + 545*f**2 + 300*f**3 + 66*f**4)/1176.,
    53: lambda f: (-8085 - 16786*f - 19283*f**2 - 10820*f**3 - 2176*f**4)/129360.,
    54: lambda f: (-1155 - 1144*f + 2794*f**2 + 8380*f**3 + 8897*f**4 + 4460*f**5 + 880*f**6)/221760.,
    55: lambda f: (-8085 - 23716*f - 47168*f**2 - 52700*f**3 - 34341*f**4 - 12240*f**5 - 1870*f**6)/155232.,
    56: lambda f: (105105 + 328328*f + 654082*f**2 + 759980*f**3 + 511461*f**4 + 185980*f**5 + 27840*f**6)/6.72672e6,
    57: lambda f: (45045 + 91806*f - 23595*f**2 - 461760*f**3 - 952577*f**4 - 1006450*f**5 - 611385*f**6 - 203980*f**7 - 29120*f**8)/5.189184e7,
    58: lambda f: (315315 + 1255254*f + 3518229*f**2 + 5935800*f**3 + 6456811*f**4 + 4591670*f**5 + 2077815*f**6 + 546140*f**7 + 63910*f**8)/3.6324288e7,
    59: lambda f: (-105105 - 438438*f - 1237665*f**2 - 2167360*f**3 - 2454579*f**4 - 1816470*f**5 - 850475*f**6 - 228900*f**7 - 26880*f**8)/4.036032e7,
    60: lambda f: (-15015 - 46332*f - 46332*f**2 + 133640*f**3 + 553582*f**4 + 966800*f**5 + 1020100*f**6 + 693560*f**7 + 299425*f**8 + 75180*f**9 + 8400*f**10)/1.3837824e8,
    61: lambda f: (-105105 - 528528*f - 1912482*f**2 - 4318600*f**3 - 6586006*f**4 - 7023496*f**5 - 5283944*f**6 - 2762648*f**7 - 959441*f**8 - 199752*f**9 - 18942*f**10)/9.6864768e7,
    62: lambda f: (5360355 + 27975948*f + 102072828*f**2 + 238282200*f**3 + 377653402*f**4 + 419341040*f**5 + 328187340*f**6 + 178025960*f**7 + 63851515*f**8 + 13631940*f**9 + 1310400*f**10)/1.646701056e10,
    63: lambda f: (765765 + 3165162*f + 6439719*f**2 - 198900*f**3 - 34711790*f**4 - 97981540*f**5 - 155370642*f**6 - 163957024*f**7 - 120056615*f**8 - 60772950*f**9 - 20411685*f**10 - 4110876*f**11 - 376992*f**12)/7.05729024e10,
    64: lambda f: (5360355 + 32570538*f + 144452451*f**2 + 408739500*f**3 + 802234420*f**4 + 1140739100*f**5 + 1200311862*f**6 + 939355424*f**7 + 541754395*f**8 + 224309610*f**9 + 63248535*f**10 + 10902276*f**11 + 869022*f**12)/4.940103168e10,
    65: lambda f: (-101846745 - 638239602*f - 2854064499*f**2 - 8317799100*f**3 - 16911204410*f**4 - 24972376780*f**5 - 27300376518*f**6 - 22182995296*f**7 - 13262794685*f**8 - 5679068850*f**9 - 1650374775*f**10 - 291772404*f**11 - 23683968*f**12)/3.1287320064e12,
    66: lambda f: (-765765 - 3967392*f - 11829246*f**2 - 14254500*f**3 + 24376793*f**4 + 146125540*f**5 + 350966652*f**6 + 522521944*f**7 + 501180365*f**8 + 307125000*f**9 + 116044110*f**10 + 24665256*f**11 + 2261952*f**12)/8.468748288e11,
    67: lambda f: (-5360355 - 38186148*f - 200557500*f**2 - 682160700*f**3 - 1637570509*f**4 - 2910901160*f**5 - 3847513962*f**6 - 3708394424*f**7 - 2538283405*f**8 - 1193047380*f**9 - 365000580*f**10 - 65413656*f**11 - 5214132*f**12)/5.9281238016e11,
    68: lambda f: (33948915 + 248312064*f + 1314446562*f**2 + 4590430780*f**3 + 11378709569*f**4 + 20940677860*f**5 + 28782139436*f**6 + 28932218392*f**7 + 20633340245*f**8 + 10063103400*f**9 + 3176261550*f**10 + 583544808*f**11 + 47367936*f**12)/1.25149280256e13,
    69: lambda f: (255255 + 1589874*f + 6177171*f**2 + 12932920*f**3 + 5992483*f**4 - 51421090*f**5 - 221113249*f**6 - 443730868*f**7 - 501406955*f**8 - 335946450*f**9 - 132885795*f**10 - 28776132*f**11 - 2638944*f**12)/3.9520825344e12,
    70: lambda f: (1786785 + 14600586*f + 88617243*f**2 + 352097200*f**3 + 999436851*f**4 + 2132033750*f**5 + 3315874919*f**6 + 3612890148*f**7 + 2688572425*f**8 + 1332462390*f**9 + 420198765*f**10 + 76315932*f**11 + 6083154*f**12)/2.76645777408e12,
    71: lambda f: (-101846745 - 851632782*f - 5207209293*f**2 - 21187650120*f**3 - 61925916269*f**4 - 136375041250*f**5 - 221084258913*f**6 - 252357804916*f**7 - 196331079035*f**8 - 101129965650*f**9 - 32915038275*f**10 - 6127220484*f**11 - 497363328*f**12)/5.256269770752e14,
    72: lambda f: (-765765 - 5571852*f - 26546520*f**2 - 75688080*f**3 - 111506876*f**4 + 53426240*f**5 + 1104352872*f**6 + 2918699504*f**7 + 3682662130*f**8 + 2598107400*f**9 + 1053090360*f**10 + 230209056*f**11 + 21111552*f**12)/1.896999616512e14,
    73: lambda f: (-5360355 - 49417368*f - 340335138*f**2 - 1546911600*f**3 - 5068526132*f**4 - 12615132880*f**5 - 22147756512*f**6 - 26135495344*f**7 - 20427686930*f**8 - 10421994240*f**9 - 3339049140*f**10 - 610527456*f**11 - 48665232*f**12)/1.3278997315584e14,
    74: lambda f: (101846745 + 958329372*f + 6645673320*f**2 + 30866681040*f**3 + 103881752236*f**4 + 266235824960*f**5 + 488701102008*f**6 + 606450333776*f**7 + 496700655430*f**8 + 263636415000*f**9 + 87192491400*f**10 + 16339254624*f**11 + 1326302208*f**12)/8.4100316332032e15,
    75: lambda f: (255255 + 2124694*f + 11958089*f**2 + 42392220*f**3 + 93106076*f**4 + 87290920*f**5 - 555517164*f**6 - 1914717728*f**7 - 2615515630*f**8 - 1908321660*f**9 - 785319570*f**10 - 172656792*f**11 - 15833664*f**12)/1.1381997699072e15,
    76: lambda f: (1786785 + 18344326*f + 141335909*f**2 + 723266700*f**3 + 2686648142*f**4 + 7642448872*f**5 + 14733111012*f**6 + 18382186144*f**7 + 14837405702*f**8 + 7709528484*f**9 + 2494143414*f**10 + 457895592*f**11 + 36498924*f**12)/7.9673983893504e14,
    77: lambda f: (-11316305 - 118336218*f - 917636863*f**2 - 4789799300*f**3 - 18236697572*f**4 - 53298785560*f**5 - 107772743692*f**6 - 141844028704*f**7 - 120172140830*f**8 - 65002579740*f**9 - 21710981250*f**10 - 4084813656*f**11 - 331575552*f**12)/1.68200632664064e16,
    78: lambda f: (-85085 - 797368*f - 5168306*f**2 - 21724300*f**3 - 60941005*f**4 - 104518380*f**5 + 257389976*f**6 + 1157646672*f**7 + 1679014470*f**8 + 1254321600*f**9 + 521547180*f**10 + 115104528*f**11 + 10555776*f**12)/7.587998466048e15,
    79: lambda f: (-595595 - 6738732*f - 57429944*f**2 - 326748500*f**3 - 1356883135*f**4 - 4342425600*f**5 - 9016869586*f**6 - 11721072272*f**7 - 9677743110*f**8 - 5092144680*f**9 - 1658254080*f**10 - 305263728*f**11 - 24332616*f**12)/5.3115989262336e15,
    80: lambda f: (33948915 + 390574184*f + 3348794878*f**2 + 19403998900*f**3 + 82441197315*f**4 + 270544716020*f**5 + 591089077512*f**6 + 812581430864*f**7 + 705090210790*f**8 + 386389382400*f**9 + 129917321100*f**10 + 24508881936*f**11 + 1989453312*f**12)/1.009203795984384e18,
    81: lambda f: (23205 + 241774*f + 1771757*f**2 + 8574800*f**3 + 28786899*f**4 + 66137990*f**5 - 90550813*f**6 - 537209036*f**7 - 816531310*f**8 - 620770500*f**9 - 260059590*f**10 - 57552264*f**11 - 5277888*f**12)/4.5527990796288e16,
    82: lambda f: (162435 + 2008006*f + 18755165*f**2 + 117439400*f**3 + 539138663*f**4 + 1917169390*f**5 + 4228681603*f**6 + 5672132956*f**7 + 4762751420*f**8 + 2529093420*f**9 + 827516970*f**10 + 152631864*f**11 + 12166308*f**12)/3.18695935574016e16,
    83: lambda f: (-3086265 - 38739974*f - 363897937*f**2 - 2317512080*f**3 - 10867855999*f**4 - 39561198270*f**5 - 92085432927*f**6 - 130901770244*f**7 - 115623304090*f**8 - 63966552300*f**9 - 21611390850*f**10 - 4084813656*f**11 - 331575552*f**12)/2.018407591968768e18,
    84: lambda f: (-69615 - 798252*f - 6521268*f**2 - 35616360*f**3 - 138070294*f**4 - 385885040*f**5 + 325111164*f**6 + 2604753928*f**7 + 4111036055*f**8 + 3167885700*f**9 + 1334695320*f**10 + 295983072*f**11 + 27143424*f**12)/3.278015337332736e18,
    85: lambda f: (-487305 - 6534528*f - 66378234*f**2 - 453624600*f**3 - 2281229218*f**4 - 8923429880*f**5 - 20691828264*f**6 - 28450903208*f**7 - 24201319975*f**8 - 12941276040*f**9 - 4249591290*f**10 - 784963872*f**11 - 62569584*f**12)/2.2946107361329152e18,
    86: lambda f: (33948915 + 461705244*f + 4715157876*f**2 + 32735236040*f**3 + 167926752318*f**4 + 671425758960*f**5 + 1647547900372*f**6 + 2404968817944*f**7 + 2153638898565*f**8 + 1200121253100*f**9 + 406942212600*f**10 + 77027914656*f**11 + 6252567552*f**12)/5.3285960427975475e20,
    87: lambda f: (19635 + 245718*f + 2213145*f**2 + 13441220*f**3 + 58815274*f**4 + 191000780*f**5 - 100753466*f**6 - 1138215232*f**7 - 1852859855*f**8 - 1443160950*f**9 - 610753605*f**10 - 135658908*f**11 - 12440736*f**12)/2.4038779140440064e19,
    88: lambda f: (137445 + 1987062*f + 21809997*f**2 + 161528900*f**3 + 883080368*f**4 + 3768426380*f**5 + 9114069646*f**6 + 12785198272*f**7 + 10988104435*f**8 + 5908072170*f**9 + 1945515495*f**10 + 359775108*f**11 + 28677726*f**12)/1.6827145398308045e19,
    89: lambda f: (-7834365 - 114754794*f - 1265916135*f**2 - 9515017980*f**3 - 52998083542*f**4 - 230865948980*f**5 - 592363039482*f**6 - 883488355904*f**7 - 799847010655*f**8 - 448264797750*f**9 - 152432158725*f**10 - 28885467996*f**11 - 2344712832*f**12)/3.1971576256785285e21,
    90: lambda f: (-58905 - 798864*f - 7861854*f**2 - 52500420*f**3 - 255222751*f**4 - 937608140*f**5 + 295678068*f**6 + 5106142216*f**7 + 8529891335*f**8 + 6701947560*f**9 + 2846518290*f**10 + 633074904*f**11 + 58056768*f**12)/2.0192574477969654e21,
    91: lambda f: (-412335 - 6393156*f - 75400644*f**2 - 601580700*f**3 - 3552416917*f**4 - 16423010072*f**5 - 41172410706*f**6 - 58718785832*f**7 - 50889605767*f**8 - 27483845004*f**9 - 9070807284*f**10 - 1678950504*f**11 - 133829388*f**12)/1.4134802134578758e21,
    92: lambda f: (7834365 + 122962224*f + 1457149254*f**2 + 11788175700*f**3 + 70844435291*f**4 + 333935546140*f**5 + 890235835692*f**6 + 1351586626264*f**7 + 1234556350685*f**8 + 695084848920*f**9 + 236903678550*f**10 + 44932950216*f**11 + 3647331072*f**12)/8.95204135189988e22,
    93: lambda f: (58905 + 860574*f + 9185253*f**2 + 66840600*f**3 + 356760385*f**4 + 1456654010*f**5 - 235109427*f**6 - 7409180044*f**7 - 12651821315*f**8 - 10012662450*f**9 - 4265279235*f**10 - 949612356*f**11 - 87085152*f**12)/6.057772343390896e22,
    94: lambda f: (412335 + 6825126*f + 86078157*f**2 + 736032000*f**3 + 4668849145*f**4 + 23244978050*f**5 + 60110287797*f**6 + 86923734044*f**7 + 75858654445*f**8 + 41118800310*f**9 + 13596067485*f**10 + 2518425756*f**11 + 200744082*f**12)/4.240440640373627e22,
    95: lambda f: (-33948915 - 568401834*f - 7201188423*f**2 - 62386222600*f**3 - 402355785035*f**4 - 2040326920030*f**5 - 5622611970143*f**6 - 8665049916796*f**7 - 7973367063935*f**8 - 4506266705850*f**9 - 1538741069775*f**10 - 292064176404*f**11 - 23707651968*f**12)/1.1637653757469843e25,
}

Q024withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: (-2*f*(2 + f))/21.,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (f*(66 + 101*f + 68*f**2 + 17*f**3))/693.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: -(f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/36036.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/72072.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: -(f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/2.9405376e7,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (f*(14586 + 82433*f + 272340*f**2 + 600185*f**3 + 937500*f**4 + 999050*f**5 + 688800*f**6 + 290850*f**7 + 68250*f**8 + 6825*f**9))/2.9405376e8,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: -(f*(4862 + 32487*f + 128656*f**2 + 345814*f**3 + 673150*f**4 + 843925*f**5 + 641200*f**6 + 284900*f**7 + 68250*f**8 + 6825*f**9))/1.17621504e9,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (f*(14586 + 112489*f + 519316*f**2 + 1647079*f**3 + 3838590*f**4 + 5373165*f**5 + 4321800*f**6 + 1973475*f**7 + 477750*f**8 + 47775*f**9))/4.940103168e10,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: -(f*(14586 + 127517*f + 672384*f**2 + 2457656*f**3 + 6670440*f**4 + 10112060*f**5 + 8443680*f**6 + 3921960*f**7 + 955500*f**8 + 95550*f**9))/7.9041650688e11,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (f*(4862 + 47515*f + 281724*f**2 + 1165911*f**3 + 3611400*f**4 + 5815500*f**5 + 4986240*f**6 + 2343180*f**7 + 573300*f**8 + 57330*f**9))/4.74249904128e12,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: -(f*(14586 + 157573*f + 1037680*f**2 + 4795870*f**3 + 16692750*f**4 + 28183725*f**5 + 24645600*f**6 + 11680200*f**7 + 2866500*f**8 + 286650*f**9))/2.845499424768e14,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (f*(1326 + 15691*f + 113628*f**2 + 580057*f**3 + 2241150*f**4 + 3930925*f**5 + 3490200*f**6 + 1664775*f**7 + 409500*f**8 + 40950*f**9))/5.690998849536e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: -(f*(4862 + 62543*f + 493952*f**2 + 2760188*f**3 + 11721380*f**4 + 21213830*f**5 + 19065200*f**6 + 9139900*f**7 + 2252250*f**8 + 225225*f**9))/5.00807898759168e16,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (f*(1122 + 15589*f + 133348*f**2 + 809557*f**3 + 3747780*f**4 + 6963270*f**5 + 6320160*f**6 + 3042270*f**7 + 750750*f**8 + 75075*f**9))/3.004847392555008e17,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: -(f*(1122 + 16745*f + 154224*f**2 + 1010786*f**3 + 5066250*f**4 + 9625175*f**5 + 8808240*f**6 + 4254180*f**7 + 1051050*f**8 + 105105*f**9))/8.413572699154022e18,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (f*(4862 + 77571*f + 765340*f**2 + 5385685*f**3 + 29055250*f**4 + 56269675*f**5 + 51851800*f**6 + 25113725*f**7 + 6210750*f**8 + 621075*f**9))/1.0937644508900229e21,
    48: lambda f: (2*f)/63.,
    49: lambda f: (2*f*(28 + 11*f))/441.,
    50: lambda f: (-2*f*(77 + 39*f))/1617.,
    51: lambda f: -(f*(165 + 134*f + 34*f**2))/2079.,
    52: lambda f: -(f*(616 + 793*f + 457*f**2 + 99*f**3))/4851.,
    53: lambda f: (f*(7623 + 9064*f + 5270*f**2 + 1326*f**3))/53361.,
    54: lambda f: (f*(3861 + 7020*f + 6160*f**2 + 2624*f**3 + 435*f**4))/108108.,
    55: lambda f: (f*(108108 + 245661*f + 292354*f**2 + 192670*f**3 + 67570*f**4 + 9945*f**5))/2.270268e6,
    56: lambda f: -(f*(165165 + 355069*f + 407136*f**2 + 270350*f**3 + 101355*f**4 + 16965*f**5))/2.774772e6,
    57: lambda f: -(f*(1859 + 5278*f + 8038*f**2 + 7224*f**3 + 3855*f**4 + 1130*f**5 + 140*f**6))/216216.,
    58: lambda f: -(f*(48048 + 157599*f + 287605*f**2 + 322767*f**3 + 230250*f**4 + 102345*f**5 + 26005*f**6 + 2905*f**7))/4.540536e6,
    59: lambda f: (f*(77077 + 242814*f + 427946*f**2 + 473332*f**3 + 341385*f**4 + 158330*f**5 + 43540*f**6 + 5460*f**7))/5.549544e6,
    60: lambda f: (f*(123981 + 479128*f + 1041488*f**2 + 1434528*f**3 + 1308210*f**4 + 791640*f**5 + 306600*f**6 + 68880*f**7 + 6825*f**8))/8.8216128e7,
    61: lambda f: (f*(1021020 + 4387071*f + 10829068*f**2 + 17259284*f**3 + 18722180*f**4 + 14050626*f**5 + 7218932*f**6 + 2433284*f**7 + 486528*f**8 + 43911*f**9))/6.17512896e8,
    62: lambda f: -(f*(5054049 + 21045167*f + 50431792*f**2 + 78952692*f**3 + 85305690*f**4 + 64839210*f**5 + 34410600*f**6 + 12256020*f**7 + 2654925*f**8 + 266175*f**9))/2.264213952e9,
    63: lambda f: -(f*(2909907 + 14234610*f + 40236110*f**2 + 74755120*f**3 + 96629250*f**4 + 88951428*f**5 + 58386720*f**6 + 26785920*f**7 + 8176035*f**8 + 1492890*f**9 + 123354*f**10))/1.676106432e10,
    64: lambda f: -(f*(69837768 + 371397351*f + 1157342915*f**2 + 2394901265*f**3 + 3497233100*f**4 + 3709916862*f**5 + 2886617874*f**6 + 1636767930*f**7 + 659974980*f**8 + 179704875*f**9 + 29683731*f**10 + 2251557*f**11))/3.5198235072e11,
    65: lambda f: (f*(117366249 + 608401508*f + 1848629130*f**2 + 3759309790*f**3 + 5442915750*f**4 + 5783046456*f**5 + 4559708832*f**6 + 2655538620*f**7 + 1116862425*f**8 + 322686420*f**9 + 57606318*f**10 + 4810806*f**11))/4.3020065088e11,
    66: lambda f: (f*(1154725 + 6835972*f + 23793472*f**2 + 55659360*f**3 + 93179325*f**4 + 109996856*f**5 + 88550840*f**6 + 47028240*f**7 + 15703695*f**8 + 2985780*f**9 + 246708*f**10))/6.704425728e10,
    67: lambda f: (f*(27159132 + 172238781*f + 648719014*f**2 + 1652301978*f**3 + 3036934350*f**4 + 4060492839*f**5 + 3883832428*f**6 + 2598816220*f**7 + 1181289480*f**8 + 346895115*f**9 + 59367462*f**10 + 4503114*f**11))/1.40792940288e12,
    68: lambda f: -(f*(46235189 + 286972257*f + 1057502000*f**2 + 2650359058*f**3 + 4823449725*f**4 + 6401781287*f**5 + 6131679064*f**6 + 4182026940*f**7 + 1981506975*f**8 + 620086215*f**9 + 115212636*f**10 + 9621612*f**11))/1.72080260352e12,
    69: lambda f: -(f*(4018443 + 27923350*f + 115469270*f**2 + 325746792*f**3 + 669719505*f**4 + 930070638*f**5 + 832587420*f**6 + 470893920*f**7 + 162619485*f**8 + 31350690*f**9 + 2590434*f**10))/2.81585880576e12,
    70: lambda f: -(f*(31039008 + 228673341*f + 1010302979*f**2 + 3057245065*f**3 + 6777957970*f**4 + 10663173549*f**5 + 11487105133*f**6 + 8319630865*f**7 + 3972742620*f**8 + 1199532495*f**9 + 207786117*f**10 + 15760899*f**11))/1.971101164032e13,
    71: lambda f: (f*(160044885 + 1157403962*f + 5016385738*f**2 + 14957328960*f**3 + 32828916015*f**4 + 50856817746*f**5 + 54417764772*f**6 + 40021332120*f**7 + 19923060675*f**8 + 6422402070*f**9 + 1209732678*f**10 + 101026926*f**11))/7.227370934784e13,
    72: lambda f: (f*(4572711 + 36480912*f + 174750752*f**2 + 577224256*f**3 + 1407265020*f**4 + 2190546288*f**5 + 2091904080*f**6 + 1225180320*f**7 + 430626210*f**8 + 83601840*f**9 + 6907824*f**10))/4.505374089216e13,
    73: lambda f: (f*(104756652 + 879308391*f + 4458808280*f**2 + 15632494568*f**3 + 40595244200*f**4 + 71991819732*f**5 + 83706796824*f**6 + 63478416120*f**7 + 31134858720*f**8 + 9537858330*f**9 + 1662288936*f**10 + 126087192*f**11))/9.4612855873536e14,
    74: lambda f: -(f*(181384203 + 1497863081*f + 7466819424*f**2 + 25827123928*f**3 + 66416526540*f**4 + 115157553756*f**5 + 132221327952*f**6 + 101586331560*f**7 + 51951145050*f**8 + 17008401270*f**9 + 3225953808*f**10 + 269405136*f**11))/1.15637934956544e15,
    75: lambda f: -(f*(1708993 + 15393534*f + 83824314*f**2 + 317304864*f**3 + 894839580*f**4 + 1515636696*f**5 + 1511559840*f**6 + 905143680*f**7 + 321608070*f**8 + 62701380*f**9 + 5180868*f**10))/2.7032244535296e14,
    76: lambda f: -(f*(12932920 + 121842383*f + 697451639*f**2 + 2780383677*f**3 + 8277866040*f**4 + 16088340876*f**5 + 19721711492*f**6 + 15410436692*f**7 + 7686652344*f**8 + 2375704338*f**9 + 415572234*f**10 + 31521798*f**11))/1.89225711747072e15,
    77: lambda f: (f*(67574507 + 627431376*f + 3536786046*f**2 + 13925551326*f**3 + 41074237620*f**4 + 77564161632*f**5 + 93482408544*f**6 + 73892813400*f**7 + 38433701250*f**8 + 12703199040*f**9 + 2419465356*f**10 + 202053852*f**11))/6.93827609739264e15,
    78: lambda f: (f*(5681247 + 57022420*f + 347883920*f**2 + 1484663040*f**3 + 4754377125*f**4 + 8593487856*f**5 + 8840971440*f**6 + 5375895840*f**7 + 1924202070*f**8 + 376208280*f**9 + 31085208*f**10))/1.62193467211776e16,
    79: lambda f: (f*(14226212 + 148648799*f + 948098670*f**2 + 4235560370*f**3 + 14223085550*f**4 + 29713329111*f**5 + 37859171672*f**6 + 30211152440*f**7 + 15243888240*f**8 + 4739728350*f**9 + 831144468*f**10 + 63043596*f**11))/3.78451423494144e16,
    80: lambda f: -(f*(224062839 + 2310697103*f + 14533552960*f**2 + 64189244130*f**3 + 213648148125*f**4 + 431314133787*f**5 + 538497623664*f**6 + 434211465240*f**7 + 228483577350*f**8 + 76006786590*f**9 + 14516792136*f**10 + 1212323112*f**11))/4.162965658435584e17,
    81: lambda f: -(f*(566865 + 6273306*f + 42384706*f**2 + 201332360*f**3 + 721689825*f**4 + 1373466726*f**5 + 1446403140*f**6 + 889439040*f**7 + 320051970*f**8 + 62701380*f**9 + 5180868*f**10))/3.24386934423552e16,
    82: lambda f: -(f*(12697776 + 145734693*f + 1024862527*f**2 + 5071714669*f**3 + 18963551350*f**4 + 41996935719*f**5 + 55109344563*f**6 + 44665466895*f**7 + 22727171880*f**8 + 7097077890*f**9 + 1246716702*f**10 + 94565394*f**11))/6.812125622894592e17,
    83: lambda f: (f*(22309287 + 253006546*f + 1756632270*f**2 + 8601395684*f**3 + 31893105975*f**4 + 67931395902*f**5 + 87113450844*f**6 + 71283616740*f**7 + 37828378350*f**8 + 12642511140*f**9 + 2419465356*f**10 + 202053852*f**11))/8.325931316871168e17,
    84: lambda f: (f*(2263261 + 27377480*f + 202921520*f**2 + 1061806944*f**3 + 4212016710*f**4 + 8358975592*f**5 + 8964312280*f**6 + 5559911280*f**7 + 2008698615*f**8 + 394122960*f**9 + 32565456*f**10))/2.8546050229272576e18,
    85: lambda f: (f*(50438388 + 630769581*f + 4848691244*f**2 + 26329222260*f**3 + 108485834820*f**4 + 252092678178*f**5 + 338550358916*f**6 + 277691501780*f**7 + 142202823840*f**8 + 44551206315*f**9 + 7836504984*f**10 + 594411048*f**11))/5.994670548147241e19,
    86: lambda f: -(f*(88913825 + 1099806279*f + 8355038416*f**2 + 44924190140*f**3 + 183644092830*f**4 + 408727358974*f**5 + 535253181848*f**6 + 442967489580*f**7 + 236589351075*f**8 + 79348004505*f**9 + 15208067952*f**10 + 1270052784*f**11))/7.326819558846628e19,
    87: lambda f: -(f*(564927 + 7415434*f + 59825414*f**2 + 341909712*f**3 + 1487008590*f**4 + 3055297212*f**5 + 3324552000*f**6 + 2075969280*f**7 + 752370465*f**8 + 147796110*f**9 + 12212046*f**10))/1.7127630137563546e19,
    88: lambda f: -(f*(4178328 + 56551809*f + 471739885*f**2 + 2788855967*f**3 + 12554875100*f**4 + 30374575206*f**5 + 41560613402*f**6 + 34414232930*f**7 + 17711800260*f**8 + 5563164915*f**9 + 979563123*f**10 + 74301381*f**11))/1.1989341096294482e20,
    89: lambda f: (f*(22160061 + 296902892*f + 2449737298*f**2 + 14349663246*f**3 + 64117207530*f**4 + 148030464984*f**5 + 197153244288*f**6 + 164628262260*f**7 + 88374207075*f**8 + 29720732580*f**9 + 5703025482*f**10 + 476269794*f**11))/4.396091735307977e20,
    90: lambda f: (f*(607563 + 8600844*f + 75029024*f**2 + 465006304*f**3 + 2200143855*f**4 + 4654658232*f**5 + 5125484280*f**6 + 3218088720*f**7 + 1169244615*f**8 + 229905060*f**9 + 18996516*f**10))/4.795736438517793e20,
    91: lambda f: (f*(13430340 + 195593619*f + 1759695602*f**2 + 11250930446*f**3 + 54942498170*f**4 + 137560391997*f**5 + 191134664364*f**6 + 159491940636*f**7 + 82417804392*f**8 + 25940022339*f**9 + 4571294574*f**10 + 346739778*f**11))/1.0071046520887365e22,
    92: lambda f: -(f*(23801547 + 343386791*f + 3057993456*f**2 + 19383566566*f**3 + 93987604095*f**4 + 223833658629*f**5 + 302270517528*f**6 + 254244264540*f**7 + 137039415975*f**8 + 46188982455*f**9 + 8871372972*f**10 + 740864124*f**11))/1.2309056858862335e22,
    93: lambda f: -(f*(2817529 + 42787810*f + 401317810*f**2 + 2680912920*f**3 + 13709490375*f**4 + 29736976178*f**5 + 33071167220*f**6 + 20858029920*f**7 + 7594189785*f**8 + 1494382890*f**9 + 123477354*f**10))/6.234457370073131e22,
    94: lambda f: -(f*(62078016 + 967966077*f + 9342615115*f**2 + 64236352065*f**3 + 338207621850*f**4 + 872125027137*f**5 + 1227474843049*f**6 + 1030813825405*f**7 + 534453918180*f**8 + 168496262025*f**9 + 29713414731*f**10 + 2253808557*f**11))/1.3092360477153575e24,
    95: lambda f: (f*(110253143 + 1704096966*f + 16291218830*f**2 + 111104596840*f**3 + 581042303625*f**4 + 1421079411206*f**5 + 1941409256332*f**6 + 1642794819120*f**7 + 888461021175*f**8 + 299998277670*f**9 + 57663924318*f**10 + 4815616806*f**11))/1.6001773916521036e24,
}

Q040withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (f**2*(2 + f)**2)/35.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: -(f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/770.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/40040.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: -(f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/240240.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (f**2*(2 + f)**2*(143 + 520*f + 1100*f**2 + 1512*f**3 + 1218*f**4 + 504*f**5 + 84*f**6))/1.92192e6,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: -(f**2*(2 + f)**2*(143 + 650*f + 1725*f**2 + 3080*f**3 + 2870*f**4 + 1260*f**5 + 210*f**6))/1.92192e7,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (f**2*(2 + f)**2*(143 + 780*f + 2490*f**2 + 5460*f**3 + 5565*f**4 + 2520*f**5 + 420*f**6))/2.306304e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: -(f**2*(2 + f)**2*(143 + 910*f + 3395*f**2 + 8820*f**3 + 9555*f**4 + 4410*f**5 + 735*f**6))/3.2288256e9,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (f**2*(2 + f)**2*(143 + 1040*f + 4440*f**2 + 13328*f**3 + 15092*f**4 + 7056*f**5 + 1176*f**6))/5.16612096e10,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: -(f**2*(2 + f)**2*(143 + 1170*f + 5625*f**2 + 19152*f**3 + 22428*f**4 + 10584*f**5 + 1764*f**6))/9.299017728e11,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (f**2*(2 + f)**2*(143 + 1300*f + 6950*f**2 + 26460*f**3 + 31815*f**4 + 15120*f**5 + 2520*f**6))/1.8598035456e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: -(f**2*(2 + f)**2*(13 + 130*f + 765*f**2 + 3220*f**3 + 3955*f**4 + 1890*f**5 + 315*f**6))/3.7196070912e13,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (f**2*(2 + f)**2*(143 + 1560*f + 10020*f**2 + 46200*f**3 + 57750*f**4 + 27720*f**5 + 4620*f**6))/9.819762720768e15,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: -(f**2*(2 + f)**2*(11 + 130*f + 905*f**2 + 4536*f**3 + 5754*f**4 + 2772*f**5 + 462*f**6))/1.9639525441536e16,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (f**2*(2 + f)**2*(11 + 140*f + 1050*f**2 + 5684*f**3 + 7301*f**4 + 3528*f**5 + 588*f**6))/5.49906712363008e17,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: (4*f**2)/35.,
    50: lambda f: 0,
    51: lambda f: (2*f**2*(2 + f)**2)/105.,
    52: lambda f: (-2*f**2*(121 + 112*f + 34*f**2))/1155.,
    53: lambda f: 0,
    54: lambda f: -(f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/770.,
    55: lambda f: (f**2*(1287 + 2392*f + 2010*f**2 + 840*f**3 + 145*f**4))/10010.,
    56: lambda f: 0,
    57: lambda f: (f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/30030.,
    58: lambda f: -(f**2*(2431 + 6760*f + 9388*f**2 + 7780*f**3 + 3925*f**4 + 1120*f**5 + 140*f**6))/60060.,
    59: lambda f: 0,
    60: lambda f: -(f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/144144.,
    61: lambda f: (f**2*(201773 + 746096*f + 1444388*f**2 + 1787040*f**3 + 1493850*f**4 + 846720*f**5 + 313740*f**6 + 68880*f**7 + 6825*f**8))/2.450448e7,
    62: lambda f: 0,
    63: lambda f: (f**2*(2 + f)**2*(2431 + 8840*f + 18700*f**2 + 25704*f**3 + 24402*f**4 + 15960*f**5 + 6972*f**6 + 1848*f**7 + 231*f**8))/1.633632e7,
    64: lambda f: -(f**2*(1893749 + 8733920*f + 21670070*f**2 + 35620440*f**3 + 41522410*f**4 + 35150976*f**5 + 21603540*f**6 + 9434040*f**7 + 2783865*f**8 + 498960*f**9 + 41118*f**10))/1.5519504e9,
    65: lambda f: 0,
    66: lambda f: -(f**2*(2 + f)**2*(2431 + 11050*f + 29325*f**2 + 52360*f**3 + 64630*f**4 + 53100*f**5 + 27330*f**6 + 7920*f**7 + 990*f**8))/1.400256e8,
    67: lambda f: (f**2*(2632773 + 14545336*f + 43997122*f**2 + 90142840*f**3 + 131871685*f**4 + 137702656*f**5 + 100720340*f**6 + 50060640*f**7 + 16054815*f**8 + 2993760*f**9 + 246708*f**10))/1.86234048e10,
    68: lambda f: 0,
    69: lambda f: (f**2*(2 + f)**2*(9724 + 53040*f + 169320*f**2 + 371280*f**3 + 544740*f**4 + 504000*f**5 + 278040*f**6 + 83160*f**7 + 10395*f**8))/5.8810752e9,
    70: lambda f: -(f**2*(10484903 + 67486328*f + 240751280*f**2 + 590527980*f**3 + 1016638035*f**4 + 1202328288*f**5 + 957993120*f**6 + 502734120*f**7 + 166306245*f**8 + 31434480*f**9 + 2590434*f**10))/7.821830016e11,
    71: lambda f: 0,
    72: lambda f: -(f**2*(2 + f)**2*(2431 + 15470*f + 57715*f**2 + 149940*f**3 + 248675*f**4 + 247450*f**5 + 141855*f**6 + 43120*f**7 + 5390*f**8))/1.82966784e10,
    73: lambda f: (f**2*(4480333 + 32920160*f + 135274984*f**2 + 386359680*f**3 + 751293060*f**4 + 963868416*f**5 + 807717960*f**6 + 436695840*f**7 + 146819190*f**8 + 27941760*f**9 + 2302608*f**10))/4.1716426752e12,
    74: lambda f: 0,
    75: lambda f: (f**2*(2 + f)**2*(2431 + 17680*f + 75480*f**2 + 226576*f**3 + 411796*f**4 + 430416*f**5 + 252840*f**6 + 77616*f**7 + 9702*f**8))/2.6347216896e11,
    76: lambda f: -(f**2*(5588869 + 46155408*f + 214639314*f**2 + 699462960*f**3 + 1494664260*f**4 + 2030171136*f**5 + 1758572760*f**6 + 968824080*f**7 + 328981590*f**8 + 62868960*f**9 + 5180868*f**10))/7.50895681536e13,
    77: lambda f: 0,
    78: lambda f: -(f**2*(2 + f)**2*(2431 + 19890*f + 95625*f**2 + 325584*f**3 + 635292*f**4 + 687960*f**5 + 411012*f**6 + 127008*f**7 + 15876*f**8))/4.3113627648e12,
    79: lambda f: (f**2*(20461727 + 187611320*f + 973906370*f**2 + 3565493640*f**3 + 8213324085*f**4 + 11635577856*f**5 + 10317351240*f**6 + 5757978240*f**7 + 1968443190*f**8 + 377213760*f**9 + 31085208*f**10))/4.505374089216e15,
    80: lambda f: 0,
    81: lambda f: (f**2*(2 + f)**2*(2431 + 22100*f + 118150*f**2 + 449820*f**3 + 928935*f**4 + 1033200*f**5 + 624960*f**6 + 194040*f**7 + 24255*f**8))/7.9041650688e13,
    82: lambda f: -(f**2*(743223 + 7491016*f + 42934452*f**2 + 174439380*f**3 + 427187545*f**4 + 625034592*f**5 + 563929380*f**6 + 317706480*f**7 + 109141830*f**8 + 20956320*f**9 + 1726956*f**10))/3.003582726144e15,
    83: lambda f: 0,
    84: lambda f: -(f**2*(2 + f)**2*(2873 + 28730*f + 169065*f**2 + 711620*f**3 + 1539335*f**4 + 1748250*f**5 + 1067535*f**6 + 332640*f**7 + 41580*f**8))/1.896999616512e15,
    85: lambda f: (f**2*(9653501 + 106083536*f + 665308940*f**2 + 2970308000*f**3 + 7653051230*f**4 + 11486744192*f**5 + 10503534580*f**6 + 5960188080*f**7 + 2055046455*f**8 + 395176320*f**9 + 32565456*f**10))/7.92945839702016e17,
    86: lambda f: 0,
    87: lambda f: (f**2*(2 + f)**2*(2431 + 26520*f + 170340*f**2 + 785400*f**3 + 1765830*f**4 + 2039400*f**5 + 1254660*f**6 + 392040*f**7 + 49005*f**8))/3.5771992768512e16,
    88: lambda f: -(f**2*(2597243 + 30904640*f + 210504914*f**2 + 1024310520*f**3 + 2754639570*f**4 + 4220802432*f**5 + 3900827700*f**6 + 2226073080*f**7 + 769750905*f**8 + 148191120*f**9 + 12212046*f**10))/4.757675038212096e18,
    89: lambda f: 0,
    90: lambda f: -(f**2*(2 + f)**2*(187 + 2210*f + 15385*f**2 + 77112*f**3 + 179130*f**4 + 209748*f**5 + 129822*f**6 + 40656*f**7 + 5082*f**8))/6.67743865012224e16,
    91: lambda f: (f**2*(998393 + 12788216*f + 94007858*f**2 + 495159000*f**3 + 1381245565*f**4 + 2152813824*f**5 + 2006917500*f**6 + 1150527840*f**7 + 398760285*f**8 + 76839840*f**9 + 6332172*f**10))/4.44049670233129e19,
    92: lambda f: 0,
    93: lambda f: (f**2*(2 + f)**2*(1496 + 19040*f + 142800*f**2 + 773024*f**3 + 1846712*f**4 + 2187360*f**5 + 1360632*f**6 + 426888*f**7 + 53361*f**8))/1.4022621165256704e19,
    94: lambda f: -(f**2*(14826669 + 203399560*f + 1604961160*f**2 + 9097404820*f**3 + 26192645605*f**4 + 41412480928*f**5 + 38884238120*f**6 + 22375746120*f**7 + 7769925345*f**8 + 1498376880*f**9 + 123477354*f**10))/1.731793713909203e22,
    95: lambda f: 0,
}

Q042withhex = {
    0: lambda f: 0,
    1: lambda f: (-6*f*(2 + f))/35.,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (f*(66 + 101*f + 68*f**2 + 17*f**3))/385.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: -(f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/20020.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/40040.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: -(f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/1.633632e7,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (f*(14586 + 82433*f + 272340*f**2 + 600185*f**3 + 937500*f**4 + 999050*f**5 + 688800*f**6 + 290850*f**7 + 68250*f**8 + 6825*f**9))/1.633632e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: -(f*(4862 + 32487*f + 128656*f**2 + 345814*f**3 + 673150*f**4 + 843925*f**5 + 641200*f**6 + 284900*f**7 + 68250*f**8 + 6825*f**9))/6.534528e8,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (f*(14586 + 112489*f + 519316*f**2 + 1647079*f**3 + 3838590*f**4 + 5373165*f**5 + 4321800*f**6 + 1973475*f**7 + 477750*f**8 + 47775*f**9))/2.74450176e10,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: -(f*(14586 + 127517*f + 672384*f**2 + 2457656*f**3 + 6670440*f**4 + 10112060*f**5 + 8443680*f**6 + 3921960*f**7 + 955500*f**8 + 95550*f**9))/4.391202816e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (f*(4862 + 47515*f + 281724*f**2 + 1165911*f**3 + 3611400*f**4 + 5815500*f**5 + 4986240*f**6 + 2343180*f**7 + 573300*f**8 + 57330*f**9))/2.6347216896e12,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: -(f*(14586 + 157573*f + 1037680*f**2 + 4795870*f**3 + 16692750*f**4 + 28183725*f**5 + 24645600*f**6 + 11680200*f**7 + 2866500*f**8 + 286650*f**9))/1.58083301376e14,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (f*(1326 + 15691*f + 113628*f**2 + 580057*f**3 + 2241150*f**4 + 3930925*f**5 + 3490200*f**6 + 1664775*f**7 + 409500*f**8 + 40950*f**9))/3.16166602752e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: -(f*(4862 + 62543*f + 493952*f**2 + 2760188*f**3 + 11721380*f**4 + 21213830*f**5 + 19065200*f**6 + 9139900*f**7 + 2252250*f**8 + 225225*f**9))/2.7822661042176e16,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (f*(1122 + 15589*f + 133348*f**2 + 809557*f**3 + 3747780*f**4 + 6963270*f**5 + 6320160*f**6 + 3042270*f**7 + 750750*f**8 + 75075*f**9))/1.66935966253056e17,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: -(f*(1122 + 16745*f + 154224*f**2 + 1010786*f**3 + 5066250*f**4 + 9625175*f**5 + 8808240*f**6 + 4254180*f**7 + 1051050*f**8 + 105105*f**9))/4.674207055085568e18,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (f*(4862 + 77571*f + 765340*f**2 + 5385685*f**3 + 29055250*f**4 + 56269675*f**5 + 51851800*f**6 + 25113725*f**7 + 6210750*f**8 + 621075*f**9))/6.076469171611238e20,
    47: lambda f: 0,
    48: lambda f: (-2*f)/35.,
    49: lambda f: (-2*f*(28 + 11*f))/245.,
    50: lambda f: (6*f*(77 + 39*f))/2695.,
    51: lambda f: (f*(990 + 469*f - 200*f**2 - 176*f**3))/23100.,
    52: lambda f: (f*(4158 + 5689*f + 3400*f**2 + 748*f**3))/16170.,
    53: lambda f: (-3*f*(30030 + 45721*f + 30720*f**2 + 7716*f**3))/700700.,
    54: lambda f: (f*(-8580 - 10517*f - 500*f**2 + 8743*f**3 + 6570*f**4 + 1560*f**5))/600600.,
    55: lambda f: -(f*(42042 + 100178*f + 123860*f**2 + 85319*f**3 + 31320*f**4 + 4785*f**5))/420420.,
    56: lambda f: (f*(60060 + 152893*f + 201220*f**2 + 148243*f**3 + 58770*f**4 + 9810*f**5))/1.4014e6,
    57: lambda f: -(f*(-7150 - 14937*f - 9400*f**2 + 10978*f**3 + 24470*f**4 + 19195*f**5 + 7280*f**6 + 1120*f**7))/2.4024e6,
    58: lambda f: (f*(38038 + 129545*f + 244120*f**2 + 284534*f**3 + 211810*f**4 + 98645*f**5 + 26320*f**6 + 3080*f**7))/1.68168e6,
    59: lambda f: -(f*(850850 + 3038971*f + 5964960*f**2 + 7281406*f**3 + 5711190*f**4 + 2813815*f**5 + 797160*f**6 + 99540*f**7))/9.52952e7,
    60: lambda f: (f*(-109395 - 329069*f - 409700*f**2 + 10081*f**3 + 766740*f**4 + 1192545*f**5 + 966000*f**6 + 460635*f**7 + 122955*f**8 + 14280*f**9))/2.450448e8,
    61: lambda f: -(f*(1225224 + 5429749*f + 13769320*f**2 + 22649746*f**3 + 25465980*f**4 + 19888920*f**5 + 10673040*f**6 + 3769710*f**7 + 791700*f**8 + 75075*f**9))/3.4306272e8,
    62: lambda f: (f*(4849845 + 22305088*f + 58262740*f**2 + 99287293*f**3 + 116268220*f**4 + 94913815*f**5 + 53367160*f**6 + 19780775*f**7 + 4364955*f**8 + 435645*f**9))/3.6212176e9,
    63: lambda f: -(f*(-1939938 - 7679971*f - 14405800*f**2 - 9952276*f**3 + 15188220*f**4 + 49510230*f**5 + 66762864*f**6 + 55592460*f**7 + 30445590*f**8 + 10768485*f**9 + 2245320*f**10 + 210672*f**11))/3.72468096e10,
    64: lambda f: (f*(56258202 + 307119059*f + 979400600*f**2 + 2081773760*f**3 + 3133660500*f**4 + 3438076218*f**5 + 2775393936*f**6 + 1637673660*f**7 + 689225250*f**8 + 196432635*f**9 + 34045704*f**10 + 2713788*f**11))/1.303638336e11,
    65: lambda f: -(f*(13579566 + 76417601*f + 249356000*f**2 + 545420384*f**3 + 849121020*f**4 + 966818046*f**5 + 811796832*f**6 + 498948660*f**7 + 218906310*f**8 + 65068185*f**9 + 11764368*f**10 + 978516*f**11))/8.69092224e10,
    66: lambda f: (f*(-1847560 - 9107631*f - 22900700*f**2 - 29598751*f**3 - 1311950*f**4 + 80448050*f**5 + 173788720*f**6 + 194059250*f**7 + 128866500*f**8 + 51129225*f**9 + 11226600*f**10 + 1053360*f**11))/3.72468096e11,
    67: lambda f: -(f*(10992982 + 71315816*f + 274065500*f**2 + 714443377*f**3 + 1347956900*f**4 + 1859524393*f**5 + 1846468736*f**6 + 1289499610*f**7 + 614013750*f**8 + 189300510*f**9 + 34045704*f**10 + 2713788*f**11))/2.607276672e11,
    68: lambda f: (f*(12932920 + 86083699*f + 337037580*f**2 + 900014629*f**3 + 1747771050*f**4 + 2505457480*f**5 + 2609429760*f**6 + 1920232650*f**7 + 963582900*f**8 + 312271575*f**9 + 58821840*f**10 + 4892580*f**11))/8.69092224e11,
    69: lambda f: -(f*(-12471030 - 73747037*f - 232883000*f**2 - 430227602*f**3 - 351108030*f**4 + 722578185*f**5 + 2611684320*f**6 + 3500584500*f**7 + 2542666350*f**8 + 1054721325*f**9 + 235758600*f**10 + 22120560*f**11))/3.1287320064e13,
    70: lambda f: (f*(75657582 + 568657973*f + 2557552760*f**2 + 7899016034*f**3 + 17918423670*f**4 + 29072055663*f**5 + 32570914656*f**6 + 24677092860*f**7 + 12367808250*f**8 + 3925385835*f**9 + 714959784*f**10 + 56989548*f**11))/2.19011240448e13,
    71: lambda f: -(f*(29099070 + 223634541*f + 1021610240*f**2 + 3221486366*f**3 + 7494926390*f**4 + 12698881055*f**5 + 15060418520*f**6 + 12123168400*f**7 + 6439533450*f**8 + 2155405875*f**9 + 411752880*f**10 + 34248060*f**11))/2.4334582272e13,
    72: lambda f: (f*(-3464175 - 23925902*f - 91021400*f**2 - 216504962*f**3 - 301452480*f**4 + 199314570*f**5 + 1411623360*f**6 + 2144702070*f**7 + 1640600850*f**8 + 696816750*f**9 + 157172400*f**10 + 14747040*f**11))/1.25149280256e14,
    73: lambda f: -(f*(42678636 + 364704145*f + 1879110640*f**2 + 6709238428*f**3 + 17781626520*f**4 + 32535204744*f**5 + 39410286048*f**6 + 31315118940*f**7 + 16139424000*f**8 + 5200564530*f**9 + 953279712*f**10 + 75986064*f**11))/1.752089923584e14,
    74: lambda f: (f*(24249225 + 211323073*f + 1103484280*f**2 + 4012559878*f**3 + 10877091120*f**4 + 20910497790*f**5 + 27021269520*f**6 + 22941115470*f**7 + 12573520050*f**8 + 4280316600*f**9 + 823505760*f**10 + 68496120*f**11))/2.92014987264e14,
    75: lambda f: -(f*(-5080790 - 40171833*f - 178877400*f**2 - 518058408*f**3 - 979622520*f**4 + 136858740*f**5 + 3661523040*f**6 + 6096907320*f**7 + 4823684460*f**8 + 2079054810*f**9 + 471517200*f**10 + 44241120*f**11))/3.003582726144e15,
    76: lambda f: (f*(31685654 + 303381949*f + 1761913320*f**2 + 7140216036*f**3 + 21651361080*f**4 + 43450830876*f**5 + 55571000352*f**6 + 45552130680*f**7 + 23893247700*f**8 + 7770891870*f**9 + 1429919568*f**10 + 113979096*f**11))/2.1025079083008e15,
    77: lambda f: -(f*(35565530 + 346556067*f + 2036295360*f**2 + 8387807412*f**3 + 25957574280*f**4 + 55073083620*f**5 + 75611813760*f**6 + 66489834600*f**7 + 37170575820*f**8 + 12786058530*f**9 + 2470517280*f**10 + 205488360*f**11))/7.008359694336e15,
    78: lambda f: (f*(-1662804 - 14818271*f - 75614300*f**2 - 257475251*f**3 - 605276730*f**4 - 88950420*f**5 + 1973218464*f**6 + 3524133060*f**7 + 2854963440*f**8 + 1242874710*f**9 + 282910320*f**10 + 26544672*f**11))/1.8021496356864e16,
    79: lambda f: -(f*(52378326 + 555435322*f + 3589725100*f**2 + 16278552385*f**3 + 55581156000*f**4 + 120007704843*f**5 + 159726159936*f**6 + 133827234660*f**7 + 71047966500*f**8 + 23252765760*f**9 + 4289758704*f**10 + 341937288*f**11))/6.3075237249024e16,
    80: lambda f: (f*(3879876 + 41801045*f + 272967300*f**2 + 1256199003*f**3 + 4369515690*f**4 + 10033096782*f**5 + 14407546944*f**6 + 12988345020*f**7 + 7360783920*f**8 + 2549892870*f**9 + 494103456*f**10 + 41097672*f**11))/1.4016719388672e16,
    81: lambda f: (f*(1637610 + 16245931*f + 93476200*f**2 + 365333026*f**3 + 1018758150*f**4 + 340054275*f**5 - 3027432240*f**6 - 5714793000*f**7 - 4711549500*f**8 - 2066031450*f**9 - 471517200*f**10 - 44241120*f**11))/3.6042992713728e17,
    82: lambda f: (f*(10405122 + 121052971*f + 861699400*f**2 + 4323217402*f**3 + 16413101550*f**4 + 37603384131*f**5 + 51596736912*f**6 + 43937601120*f**7 + 23532232500*f**8 + 7736657670*f**9 + 1429919568*f**10 + 113979096*f**11))/2.52300948996096e17,
    83: lambda f: -(f*(126095970 + 1488381739*f + 10693677280*f**2 + 54375815494*f**3 + 209991736350*f**4 + 514421212635*f**5 + 764690046120*f**6 + 702239838300*f**7 + 401962245300*f**8 + 139956582150*f**9 + 27175690080*f**10 + 2260371960*f**11))/9.25103479652352e18,
    84: lambda f: (f*(-1616615 - 17673591*f - 113211500*f**2 - 498972661*f**3 - 1602958940*f**4 - 749632345*f**5 + 4454092720*f**6 + 8793987125*f**7 + 7348797225*f**8 + 3240225450*f**9 + 740955600*f**10 + 69521760*f**11))/7.92945839702016e18,
    85: lambda f: -(f*(20692672 + 262046993*f + 2037135160*f**2 + 11203170374*f**3 + 46814282020*f**4 + 112643517536*f**5 + 158316325552*f**6 + 136510744370*f**7 + 73603876500*f**8 + 24281586945*f**9 + 4494032928*f**10 + 358220016*f**11))/1.1101241755828224e19,
    86: lambda f: (f*(11316305 + 145226614*f + 1138516860*f**2 + 6338905039*f**3 + 26909949660*f**4 + 69577998985*f**5 + 106300646760*f**6 + 99025212825*f**7 + 57114513225*f**8 + 19962991125*f**9 + 3882241440*f**10 + 322910280*f**11))/1.850206959304704e19,
    87: lambda f: (f*(1598850 + 19101251*f + 134820200*f**2 + 661107356*f**3 + 2398002540*f**4 + 1365563790*f**5 - 6331599120*f**6 - 12974175060*f**7 - 10958951850*f**8 - 4852876875*f**9 - 1111433400*f**10 - 104282640*f**11))/1.9030700152848384e20,
    88: lambda f: (f*(10296594 + 140997575*f + 1188549560*f**2 + 7109806232*f**3 + 32426806380*f**4 + 81306111942*f**5 + 116510002224*f**6 + 101463880980*f**7 + 54996075750*f**8 + 18191576865*f**9 + 3370524696*f**10 + 268665012*f**11))/1.3321490106993869e20,
    89: lambda f: -(f*(3730650 + 51719083*f + 439331680*f**2 + 2658178888*f**3 + 12303187420*f**4 + 33298008910*f**5 + 52015939360*f**6 + 49010242820*f**7 + 28437220350*f**8 + 9969515325*f**9 + 1941120720*f**10 + 161455140*f**11))/1.4801655674437632e20,
    90: lambda f: (f*(-852720 - 11054029*f - 85239700*f**2 - 460088629*f**3 - 1856702610*f**4 - 1207051230*f**5 + 4709280240*f**6 + 9956461410*f**7 + 8483655180*f**8 + 3769817205*f**9 + 864448200*f**10 + 81108720*f**11))/2.664298021398774e21,
    91: lambda f: -(f*(5521362 + 81293932*f + 738578260*f**2 + 4774470043*f**3 + 23600554740*f**4 + 61289156271*f**5 + 89240985792*f**6 + 78345347850*f**7 + 42646030350*f**8 + 14136800370*f**9 + 2621519208*f**10 + 208961676*f**11))/1.8650086149791416e21,
    92: lambda f: (f*(77597520 + 1155678173*f + 10574109140*f**2 + 69084002603*f**3 + 346217778270*f**4 + 974449241220*f**5 + 1550472880320*f**6 + 1474476289650*f**7 + 859682803980*f**8 + 302117911095*f**9 + 58880661840*f**10 + 4897472580*f**11))/8.081703998242947e22,
    93: lambda f: (f*(1570426 + 21956571*f + 183657800*f**2 + 1081714726*f**3 + 4801859930*f**4 + 3437697445*f**5 - 11790024064*f**6 - 25601144660*f**7 - 21972467790*f**8 - 9791648685*f**9 - 2247565320*f**10 - 210882672*f**11))/1.3854349711273624e23,
    94: lambda f: (f*(51085034 + 804767743*f + 7839274600*f**2 + 54458888510*f**3 + 290010390250*f**4 + 776273412593*f**5 + 1145547247936*f**6 + 1012424345660*f**7 + 553029545250*f**8 + 183648600135*f**9 + 34079749704*f**10 + 2716501788*f**11))/4.849022398945768e23,
    95: lambda f: -(f*(10992982 + 175043713*f + 1716292800*f**2 + 12041717134*f**3 + 64960044870*f**4 + 189146361271*f**5 + 305645171832*f**6 + 292907301960*f**7 + 171459907710*f**8 + 60376009785*f**9 + 11776132368*f**10 + 979494516*f**11))/3.232681599297179e23,
}

Q044withhex = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: (-77 - 78*f - 39*f**2)/154.,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (5005 + 10140*f + 12786*f**2 + 7716*f**3 + 1929*f**4)/40040.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (-5005 - 15210*f - 30753*f**2 - 36228*f**3 - 25407*f**4 - 9810*f**5 - 1635*f**6)/240240.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (85085 + 344760*f + 959412*f**2 + 1676472*f**3 + 1929078*f**4 + 1463400*f**5 + 708420*f**6 + 199080*f**7 + 24885*f**8)/3.267264e7,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (-323323 - 1637610*f - 5803341*f**2 - 13434216*f**3 - 21485694*f**4 - 24255468*f**5 - 19374090*f**6 - 10752840*f**7 - 3957975*f**8 - 871290*f**9 - 87129*f**10)/1.24156032e9,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (323323 + 1965132*f + 8459370*f**2 + 24376164*f**3 + 49913361*f**4 + 74793528*f**5 + 77977020*f**6 + 53169480*f**7 + 22329405*f**8 + 5227740*f**9 + 522774*f**10)/1.489872384e10,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (-230945 - 1637610*f - 8295609*f**2 - 28601004*f**3 - 71380701*f**4 - 133315470*f**5 - 163933125*f**6 - 123467400*f**7 - 54641475*f**8 - 13069350*f**9 - 1306935*f**10)/1.489872384e11,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (1616615 + 13100880*f + 76333944*f**2 + 306374544*f**3 + 901885236*f**4 + 2017224720*f**5 + 2775592680*f**6 + 2216466000*f**7 + 1008941850*f**8 + 243961200*f**9 + 24396120*f**10)/1.66865707008e13,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (-1616615 - 14738490*f - 97090893*f**2 - 444608208*f**3 - 1507955292*f**4 - 3929075640*f**5 - 5865454980*f**6 - 4867899120*f**7 - 2255225490*f**8 - 548912700*f**9 - 54891270*f**10)/3.003582726144e14,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (323323 + 3275220*f + 24068022*f**2 + 123826572*f**3 + 475433523*f**4 + 1414118736*f**5 + 2245792680*f**6 + 1915386480*f**7 + 898118550*f**8 + 219565080*f**9 + 21956508*f**10)/1.2014330904576e15,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (-29393 - 327522*f - 2656029*f**2 - 15166788*f**3 - 65025087*f**4 - 217387746*f**5 - 362423115*f**6 - 315448560*f**7 - 149213610*f**8 - 36594180*f**9 - 3659418*f**10)/2.4028661809152e15,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (1616615 + 19651320*f + 174315348*f**2 + 1093954488*f**3 + 5180014422*f**4 + 19227475080*f**5 + 33335692500*f**6 + 29474814600*f**7 + 14035277025*f**8 + 3450308400*f**9 + 345030840*f**10)/3.171783358808064e18,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (-124355 - 1637610*f - 15772413*f**2 - 107900088*f**3 - 559235322*f**4 - 2281987620*f**5 - 4086042510*f**6 - 3658347000*f**7 - 1751159025*f**8 - 431288550*f**9 - 43128855*f**10)/6.343566717616128e18,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (17765 + 251940*f + 2618238*f**2 + 19391628*f**3 + 109187547*f**4 + 485799480*f**5 + 893670780*f**6 + 808342920*f**7 + 388568565*f**8 + 95841900*f**9 + 9584190*f**10)/2.537426687046451e19,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (-323323 - 4912830*f - 54794043*f**2 - 436798068*f**3 - 2655030987*f**4 - 12791605554*f**5 - 24077812395*f**6 - 21964498920*f**7 - 10595013975*f**8 - 2616483870*f**9 - 261648387*f**10)/1.3854349711273624e22,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (323323 + 5240352*f + 62434608*f**2 + 532996512*f**3 + 3478401288*f**4 + 18040778784*f**5 + 34636017360*f**6 + 31823195040*f**7 + 15395283540*f**8 + 3805794720*f**9 + 380579472*f**10)/4.4333919076075595e23,
    48: lambda f: 0.3333333333333333 + (13*f)/154.,
    49: lambda f: 0.3333333333333333 + (293*f)/1386. + (8*f**2)/245.,
    50: lambda f: -0.5 - (39*f)/154. - (1521*f**2)/11858.,
    51: lambda f: (-10010 - 12675*f - 8928*f**2 - 1929*f**3)/60060.,
    52: lambda f: (-210210 - 346255*f - 330384*f**2 - 144093*f**3 - 21216*f**4)/1.26126e6,
    53: lambda f: (385385 + 585585*f + 591126*f**2 + 298995*f**3 + 75231*f**4)/1.54154e6,
    54: lambda f: (10010 + 22815*f + 33288*f**2 + 25830*f**3 + 10398*f**4 + 1635*f**5)/240240.,
    55: lambda f: (210210 + 559195*f + 964248*f**2 + 957918*f**3 + 552630*f**4 + 169935*f**5 + 20880*f**6)/5.04504e6,
    56: lambda f: (-385385 - 975975*f - 1677519*f**2 - 1695702*f**3 - 1057635*f**4 - 380955*f**5 - 63765*f**6)/6.16616e6,
    57: lambda f: (-170170 - 560235*f - 1242360*f**2 - 1663671*f**3 - 1396458*f**4 - 715545*f**5 - 204900*f**6 - 24885*f**7)/2.450448e7,
    58: lambda f: (-3573570 - 13126295*f - 32677128*f**2 - 50844195*f**3 - 51688914*f**4 - 34279965*f**5 - 14278500*f**6 - 3378585*f**7 - 342720*f**8)/5.1459408e8,
    59: lambda f: (6551545 + 23228205*f + 57086748*f**2 + 88353777*f**3 + 91114344*f**4 + 63027855*f**5 + 28535280*f**6 + 7739235*f**7 + 970515*f**8)/6.2894832e8,
    60: lambda f: (3233230 + 13919685*f + 41442192*f**2 + 78872724*f**3 + 101109564*f**4 + 88443270*f**5 + 52208160*f**6 + 19911780*f**7 + 4430790*f**8 + 435645*f**9)/3.72468096e9,
    61: lambda f: (67897830 + 318179225*f + 1034954016*f**2 + 2193881892*f**3 + 3202503276*f**4 + 3283010910*f**5 + 2364096960*f**6 + 1172225460*f**7 + 381092670*f**8 + 73020465*f**9 + 6224400*f**10)/7.821830016e10,
    62: lambda f: (-124479355 - 567431865*f - 1819362423*f**2 - 3814918116*f**3 - 5554700046*f**4 - 5753556990*f**5 - 4264138590*f**6 - 2228192820*f**7 - 786286935*f**8 - 169465905*f**9 - 16990155*f**10)/9.560014464e10,
    63: lambda f: (-646646 - 3438981*f - 12852816*f**2 - 31716339*f**3 - 54761268*f**4 - 67885026*f**5 - 60971976*f**6 - 39430230*f**7 - 17924550*f**8 - 5439945*f**9 - 989688*f**10 - 81543*f**11)/7.44936192e9,
    64: lambda f: (-67897830 - 386958845*f - 1553717856*f**2 - 4170377355*f**3 - 7942353780*f**4 - 11036258130*f**5 - 11334994920*f**6 - 8612973894*f**7 - 4786448310*f**8 - 1892021985*f**9 - 503826120*f**10 - 80966655*f**11 - 5920992*f**12)/7.821830016e11,
    65: lambda f: (24895871 + 138705567*f + 549196254*f**2 + 1456322697*f**3 + 2751287571*f**4 + 3819281286*f**5 + 3958626732*f**6 + 3074887074*f**7 + 1774483725*f**8 + 742121835*f**9 + 213694278*f**10 + 38080581*f**11 + 3180177*f**12)/1.9120028928e11,
    66: lambda f: (3233230 + 20470125*f + 92070504*f**2 + 279186342*f**3 + 606470310*f**4 + 973887255*f**5 + 1123898880*f**6 + 893686500*f**7 + 471274650*f**8 + 156663675*f**9 + 29690640*f**10 + 2446290*f**11)/4.469617152e11,
    67: lambda f: (67897830 + 455738465*f + 2177156952*f**2 + 7072969374*f**3 + 16621985118*f**4 + 29175436755*f**5 + 37873181520*f**6 + 35378323764*f**7 + 23132533410*f**8 + 10256824935*f**9 + 2929590720*f**10 + 485799930*f**11 + 35525952*f**12)/9.3861960192e12,
    68: lambda f: (-124479355 - 819623805*f - 3864504753*f**2 - 12404120550*f**3 - 28863133263*f**4 - 50379941655*f**5 - 65331188085*f**6 - 61764629220*f**7 - 41809003425*f**8 - 19721666475*f**9 - 6155976015*f**10 - 1142417430*f**11 - 95405310*f**12)/1.14720173568e13,
    69: lambda f: (-3233230 - 23745345*f - 124861464*f**2 - 449136345*f**3 - 1176078834*f**4 - 2320050285*f**5 - 3156261780*f**6 - 2795995125*f**7 - 1571922450*f**8 - 540699075*f**9 - 103917240*f**10 - 8562015*f**11)/6.2574640128e12,
    70: lambda f: (-67897830 - 524518085*f - 2905271304*f**2 - 11079101229*f**3 - 30979473210*f**4 - 65728510785*f**5 - 100467197460*f**6 - 105556946649*f**7 - 74522654010*f**8 - 34621029135*f**9 - 10144640520*f**10 - 1700299755*f**11 - 124340832*f**12)/1.314067442688e14,
    71: lambda f: (124479355 + 945719775*f + 5174932872*f**2 + 19507751991*f**3 + 53984041650*f**4 + 113680045395*f**5 + 172363917180*f**6 + 182329419195*f**7 + 133216883100*f**8 + 66060179325*f**9 + 21248588340*f**10 + 3998461005*f**11 + 333918585*f**12)/1.606082429952e14,
    72: lambda f: (3233230 + 27020565*f + 162636960*f**2 + 676881384*f**3 + 2074739352*f**4 + 4854890460*f**5 + 7416521280*f**6 + 7017856440*f**7 + 4088408100*f**8 + 1431699150*f**9 + 277112640*f**10 + 22832040*f**11)/1.001194242048e14,
    73: lambda f: (67897830 + 593297705*f + 3738060912*f**2 + 16366216200*f**3 + 53070625656*f**4 + 132072539340*f**5 + 227564910720*f**6 + 257728078104*f**7 + 190199569140*f**8 + 90618933510*f**9 + 26907138720*f**10 + 4534132680*f**11 + 331575552*f**12)/2.1025079083008e15,
    74: lambda f: (-124479355 - 1071815745*f - 6677265627*f**2 - 28917820488*f**3 - 92810926476*f**4 - 229068048300*f**5 - 389348701980*f**6 - 442455164760*f**7 - 337930954410*f**8 - 172206273750*f**9 - 56266465290*f**10 - 10662562680*f**11 - 890449560*f**12)/2.5697318879232e15,
    75: lambda f: (-3233230 - 30295785*f - 205396992*f**2 - 970871139*f**3 - 3409689384*f**4 - 9232020900*f**5 - 15369636240*f**6 - 15202672380*f**7 - 9059348340*f**8 - 3207600270*f**9 - 623503440*f**10 - 51372090*f**11)/1.8021496356864e15,
    76: lambda f: (-67897830 - 662077325*f - 4675525776*f**2 - 23111757567*f**3 - 85268981736*f**4 - 243519183540*f**5 - 459733499280*f**6 - 548355295404*f**7 - 416491592580*f**8 - 201592455750*f**9 - 60344993520*f**10 - 10201798530*f**11 - 746044992*f**12)/3.78451423494144e16,
    77: lambda f: (124479355 + 1197911715*f + 8371503018*f**2 + 40959638721*f**3 + 149618059281*f**4 + 423684158220*f**5 + 785402872200*f**6 + 937687865940*f**7 + 737125550910*f**8 + 382125939930*f**9 + 126064357020*f**10 + 23990766030*f**11 + 2003511510*f**12)/4.62551739826176e16,
    78: lambda f: (646646 + 6714201*f + 50628312*f**2 + 267911058*f**3 + 1060659306*f**4 + 3261914577*f**5 + 5802740352*f**6 + 5925157560*f**7 + 3586520700*f**8 + 1279380690*f**9 + 249401376*f**10 + 20548836*f**11)/7.2085985427456e15,
    79: lambda f: (67897830 + 730856945*f + 5717665896*f**2 + 31493168610*f**3 + 130265812410*f**4 + 419900213385*f**5 + 851819433840*f**6 + 1055180295288*f**7 + 817758694620*f**8 + 400118051970*f**9 + 120428562240*f**10 + 20403597060*f**11 + 1492089984*f**12)/7.56902846988288e17,
    80: lambda f: (-24895871 - 264801537*f - 2051529009*f**2 - 11191703874*f**3 - 45852443937*f**4 - 146562177897*f**5 - 290798377839*f**6 - 359887417848*f**7 - 288687964950*f**8 - 151426862370*f**9 - 50283025506*f**10 - 9596306412*f**11 - 801404604*f**12)/1.850206959304704e17,
    81: lambda f: (-3233230 - 36846225*f - 305870664*f**2 - 1791383517*f**3 - 7893058470*f**4 - 27178077135*f**5 - 50962699260*f**6 - 53296810875*f**7 - 32632746300*f**8 - 11703695850*f**9 - 2286179280*f**10 - 188364330*f**11)/7.92945839702016e17,
    82: lambda f: (-67897830 - 799636565*f - 6864481272*f**2 - 41687892609*f**3 - 191070120318*f**4 - 686153014635*f**5 - 1475108460540*f**6 - 1880616671703*f**7 - 1479338603820*f**8 - 729533636370*f**9 - 220443355440*f**10 - 37406594610*f**11 - 2735498304*f**12)/1.6651862633742336e19,
    83: lambda f: (124479355 + 1450103655*f + 12335691708*f**2 + 74239775115*f**3 + 337182695388*f**4 + 1200946492185*f**5 + 2516617528920*f**6 + 3200679893565*f**7 + 2606103128475*f**8 + 1378758946950*f**9 + 459993275280*f**10 + 87966142110*f**11 + 7346208870*f**12)/2.0352276552351744e19,
    84: lambda f: (3233230 + 40121445*f + 363584304*f**2 + 2334805500*f**3 + 11331602964*f**4 + 43188345090*f**5 + 84529246560*f**6 + 90061933500*f**7 + 55628530650*f**8 + 20032672275*f**9 + 3919164480*f**10 + 322910280*f**11)/1.9030700152848384e19,
    85: lambda f: (67897830 + 868416185*f + 8115971904*f**2 + 53873372844*f**3 + 271008639780*f**4 + 1072906095690*f**5 + 2419485583680*f**6 + 3155143693548*f**7 + 2510492908770*f**8 + 1245465500895*f**9 + 377462741040*f**10 + 64125590760*f**11 + 4689425664*f**12)/3.9964470320981606e20,
    86: lambda f: (-124479355 - 1576199625*f - 14605643007*f**2 - 96128718636*f**3 - 479401282170*f**4 - 1882878381450*f**5 - 4126506064890*f**6 - 5361664756140*f**7 - 4416060396825*f**8 - 2351603105775*f**9 - 787358453805*f**10 - 150799100760*f**11 - 12593500920*f**12)/4.8845463725644186e20,
    87: lambda f: (-248710 - 3338205*f - 32790960*f**2 - 229097763*f**3 - 1214360604*f**4 - 5075334630*f**5 - 10292872920*f**6 - 11131250130*f**7 - 6923104650*f**8 - 2501088975*f**9 - 489895560*f**10 - 40363785*f**11)/3.806140030569677e19,
    88: lambda f: (-5222910 - 72091985*f - 728625984*f**2 - 5248234815*f**3 - 28748141292*f**4 - 124389584190*f**5 - 291968849880*f**6 - 387746160186*f**7 - 311334858450*f**8 - 155181171915*f**9 - 47140049880*f**10 - 8015698845*f**11 - 586178208*f**12)/7.992894064196321e20,
    89: lambda f: (9575335 + 130945815*f + 1312884534*f**2 + 9380820201*f**3 + 50963252607*f**4 + 218827428210*f**5 + 497868957780*f**6 + 658124269110*f**7 + 547007502195*f**8 + 292785310125*f**9 + 98302999410*f**10 + 18849887595*f**11 + 1574187615*f**12)/9.769092745128837e20,
    90: lambda f: (3233230 + 46671885*f + 493965192*f**2 + 3730229454*f**3 + 21441201054*f**4 + 97506109155*f**5 + 203755144320*f**6 + 223056085980*f**7 + 139507758390*f**8 + 50529123645*f**9 + 9906776880*f**10 + 816245430*f**11)/1.3854349711273624e22,
    91: lambda f: (67897830 + 1005975425*f + 10932978936*f**2 + 84926375142*f**3 + 503183909046*f**4 + 2362395785295*f**5 + 5737000323600*f**6 + 7734077790348*f**7 + 6255866970990*f**8 + 3129986644785*f**9 + 952584272640*f**10 + 162095243310*f**11 + 11853825984*f**12)/2.909413439367461e23,
    92: lambda f: (-124479355 - 1828391565*f - 19721259513*f**2 - 152030919726*f**3 - 893732512491*f**4 - 4165167081075*f**5 - 9781728505185*f**6 - 13114435212060*f**7 - 10980966768135*f**8 - 5901921230205*f**9 - 1986015416385*f**10 - 381186615810*f**11 - 31833571770*f**12)/3.555949759226897e23,
    93: lambda f: (-646646 - 9989421*f - 113326488*f**2 - 919826157*f**3 - 5698632114*f**4 - 28013512653*f**5 - 60055532628*f**6 - 66416260365*f**7 - 41731366950*f**8 - 15146843985*f**9 - 2972033064*f**10 - 244873629*f**11)/8.312609826764174e22,
    94: lambda f: (-67897830 - 1074755045*f - 12498495336*f**2 - 104148783765*f**3 - 663662785890*f**4 - 3360114585765*f**5 - 8402344084260*f**6 - 11470315777557*f**7 - 9334744121430*f**8 - 4685012673705*f**9 - 1428026778360*f**10 - 243142864965*f**11 - 17780738976*f**12)/8.728240318102382e24,
    95: lambda f: (24895871 + 390897507*f + 4513384944*f**2 + 37338960531*f**3 + 236160257598*f**4 + 1187241082083*f**5 + 2865066218196*f**6 + 3886882036947*f**7 + 3274502417550*f**8 + 1765949949855*f**9 + 595340793684*f**10 + 114355984743*f**11 + 9550071531*f**12)/2.133569855536138e24,
}

###################

Q100withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (-15 - 20*f - 22*f**2 - 12*f**3 - 3*f**4)/120.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (35 + 70*f + 119*f**2 + 124*f**3 + 81*f**4 + 30*f**5 + 5*f**6)/840.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (-315 - 840*f - 1932*f**2 - 2952*f**3 - 3098*f**4 - 2200*f**5 - 1020*f**6 - 280*f**7 - 35*f**8)/40320.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (693 + 2310*f + 6699*f**2 + 13464*f**3 + 19426*f**4 + 20276*f**5 + 15270*f**6 + 8120*f**7 + 2905*f**8 + 630*f**9 + 63*f**10)/665280.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (-15015 - 60060*f - 210210*f**2 - 523380*f**3 - 960245*f**4 - 1320280*f**5 - 1387404*f**6 - 1121512*f**7 - 685265*f**8 - 303660*f**9 - 91350*f**10 - 16632*f**11 - 1386*f**12)/1.3837824e8,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (6435 + 30030*f + 123123*f**2 + 365508*f**3 + 813527*f**4 + 1386970*f**5 + 1837335*f**6 + 1848280*f**7 + 1348025*f**8 + 677250*f**9 + 220185*f**10 + 41580*f**11 + 3465*f**12)/6.918912e8,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (-6435 - 34320*f - 161304*f**2 - 555984*f**3 - 1454596*f**4 - 2958800*f**5 - 4633800*f**6 - 5302160*f**7 - 4211650*f**8 - 2228400*f**9 - 745560*f**10 - 142560*f**11 - 11880*f**12)/9.4887936e9,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (715 + 4290*f + 22737*f**2 + 89232*f**3 + 268268*f**4 + 633880*f**5 + 1125780*f**6 + 1400560*f**7 + 1169210*f**8 + 636300*f**9 + 216090*f**10 + 41580*f**11 + 3465*f**12)/1.66053888e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (-3003 - 20020*f - 118118*f**2 - 519948*f**3 - 1765907*f**4 - 4752592*f**5 - 9306600*f**6 - 12273520*f**7 - 10583510*f**8 - 5862360*f**9 - 2009196*f**10 - 388080*f**11 - 32340*f**12)/1.2398690304e12,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (1365 + 10010*f + 65065*f**2 + 317460*f**3 + 1201915*f**4 + 3629210*f**5 + 7682559*f**6 + 10575152*f**7 + 9328690*f**8 + 5230260*f**9 + 1803690*f**10 + 349272*f**11 + 29106*f**12)/1.11588212736e13,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (-455 - 3640*f - 25844*f**2 - 138424*f**3 - 578006*f**4 - 1934920*f**5 - 4364660*f**6 - 6207880*f**7 - 5569025*f**8 - 3150000*f**9 - 1091160*f**10 - 211680*f**11 - 17640*f**12)/8.1155063808e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (315 + 2730*f + 21021*f**2 + 122616*f**3 + 559754*f**4 + 2057380*f**5 + 4892430*f**6 + 7140280*f**7 + 6488825*f**8 + 3694950*f**9 + 1284255*f**10 + 249480*f**11 + 20790*f**12)/1.339058552832e15,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (-585 - 5460*f - 45318*f**2 - 285948*f**3 - 1416727*f**4 - 5671640*f**5 - 14101260*f**6 - 21013160*f**7 - 19292665*f**8 - 11043900*f**9 - 3848670*f**10 - 748440*f**11 - 62370*f**12)/6.4274810535936e16,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (3 + 30*f + 267*f**2 + 1812*f**3 + 9683*f**4 + 41938*f**5 + 108315*f**6 + 164200*f**7 + 152015*f**8 + 87390*f**9 + 30519*f**10 + 5940*f**11 + 495*f**12)/9.182115790848e15,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (-495 - 5280*f - 50160*f**2 - 364320*f**3 - 2088680*f**4 - 9730720*f**5 - 25972752*f**6 - 39943456*f**7 - 37234820*f**8 - 21480480*f**9 - 7514640*f**10 - 1463616*f**11 - 121968*f**12)/4.524946661729894e19,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: (3465 + 39270*f + 396627*f**2 + 3069792*f**3 + 18794248*f**4 + 93716240*f**5 + 257433720*f**6 + 400772960*f**7 + 375766300*f**8 + 217413000*f**9 + 76169520*f**10 + 14844060*f**11 + 1237005*f**12)/1.0096287238984827e22,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (-385 - 4620*f - 49434*f**2 - 406164*f**3 - 2644741*f**4 - 14054240*f**5 - 39595440*f**6 - 62293280*f**7 - 58695700*f**8 - 34045200*f**9 - 11942280*f**10 - 2328480*f**11 - 194040*f**12)/3.800955195853111e22,
    52: lambda f: 0,
    53: lambda f: 0,
    54: lambda f: (15015 + 190190*f + 2149147*f**2 + 18682092*f**3 + 128918933*f**4 + 727308790*f**5 + 2095583625*f**6 + 3327106720*f**7 + 3148352060*f**8 + 1830053400*f**9 + 642621420*f**10 + 125349840*f**11 + 10445820*f**12)/5.3200702891290714e25,
    55: lambda f: 0,
    56: lambda f: 0,
    57: lambda f: (-3003 - 40040*f - 476476*f**2 - 4368936*f**3 - 31848674*f**4 - 190108984*f**5 - 558851340*f**6 - 894408760*f**7 - 849505895*f**8 - 494716320*f**9 - 173878992*f**10 - 33929280*f**11 - 2827440*f**12)/4.0320532717609805e26,
    58: lambda f: 0,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (-15 - 20*f - 22*f**2 - 12*f**3 - 3*f**4)/180.,
    64: lambda f: (105 + 140*f + 133*f**2 + 66*f**3 + 12*f**4)/630.,
    65: lambda f: 0,
    66: lambda f: (35 + 70*f + 119*f**2 + 124*f**3 + 81*f**4 + 30*f**5 + 5*f**6)/840.,
    67: lambda f: (-105 - 210*f - 336*f**2 - 336*f**3 - 205*f**4 - 70*f**5 - 10*f**6)/1260.,
    68: lambda f: 0,
    69: lambda f: (-315 - 840*f - 1932*f**2 - 2952*f**3 - 3098*f**4 - 2200*f**5 - 1020*f**6 - 280*f**7 - 35*f**8)/30240.,
    70: lambda f: (3465 + 9240*f + 20559*f**2 + 30690*f**3 + 31207*f**4 + 21380*f**5 + 9465*f**6 + 2450*f**7 + 280*f**8)/166320.,
    71: lambda f: 0,
    72: lambda f: (693 + 2310*f + 6699*f**2 + 13464*f**3 + 19426*f**4 + 20276*f**5 + 15270*f**6 + 8120*f**7 + 2905*f**8 + 630*f**9 + 63*f**10)/399168.,
    73: lambda f: (-45045 - 150150*f - 426426*f**2 - 844272*f**3 - 1195766*f**4 - 1222780*f**5 - 899040*f**6 - 464800*f**7 - 160685*f**8 - 33390*f**9 - 3150*f**10)/1.297296e7,
    74: lambda f: 0,
    75: lambda f: (-3003 - 12012*f - 42042*f**2 - 104676*f**3 - 192049*f**4 - 264056*f**5 - 274524*f**6 - 215432*f**7 - 125965*f**8 - 53340*f**9 - 15498*f**10 - 2772*f**11 - 231*f**12)/1.3837824e7,
    76: lambda f: (15015 + 60060*f + 207207*f**2 + 510510*f**3 + 925210*f**4 + 1255280*f**5 + 1285670*f**6 + 992068*f**7 + 568995*f**8 + 235620*f**9 + 66675*f**10 + 11550*f**11 + 924*f**12)/3.459456e7,
    77: lambda f: 0,
    78: lambda f: (6435 + 30030*f + 123123*f**2 + 365508*f**3 + 813527*f**4 + 1386970*f**5 + 1837335*f**6 + 1903192*f**7 + 1540217*f**8 + 965538*f**9 + 460425*f**10 + 161700*f**11 + 39501*f**12 + 6006*f**13 + 429*f**14)/2.965248e8,
    79: lambda f: (-765765 - 3573570*f - 14498484*f**2 - 42707808*f**3 - 94227991*f**4 - 159148730*f**5 - 208671090*f**6 - 213722096*f**7 - 170806867*f**8 - 105586614*f**9 - 49560000*f**10 - 17094000*f**11 - 4089393*f**12 - 606606*f**13 - 42042*f**14)/1.76432256e10,
    80: lambda f: 0,
    81: lambda f: (-6435 - 34320*f - 161304*f**2 - 555984*f**3 - 1454596*f**4 - 2958800*f**5 - 4728840*f**6 - 5916752*f**7 - 5721202*f**8 - 4195728*f**9 - 2276100*f**10 - 881100*f**11 - 229581*f**12 - 36036*f**13 - 2574*f**14)/3.5582976e9,
    82: lambda f: (109395 + 583440*f + 2720289*f**2 + 9320454*f**3 + 24224915*f**4 + 48933820*f**5 + 77603385*f**6 + 96187258*f**7 + 91894961*f**8 + 66374712*f**9 + 35346375*f**10 + 13389750*f**11 + 3404214*f**12 + 519948*f**13 + 36036*f**14)/3.02455296e10,
    83: lambda f: 0,
    84: lambda f: (715 + 4290*f + 22737*f**2 + 89232*f**3 + 268268*f**4 + 633880*f**5 + 1175060*f**6 + 1676528*f**7 + 1802458*f**8 + 1432172*f**9 + 822850*f**10 + 331100*f**11 + 88319*f**12 + 14014*f**13 + 1001*f**14)/5.5351296e9,
    85: lambda f: (-255255 - 1531530*f - 8066058*f**2 - 31505760*f**3 - 94235284*f**4 - 221468520*f**5 - 407960560*f**6 - 576889152*f**7 - 612418954*f**8 - 478585548*f**9 - 269451000*f**10 - 105913500*f**11 - 27526191*f**12 - 4246242*f**13 - 294294*f**14)/9.880206336e11,
    86: lambda f: 0,
    87: lambda f: (-1155 - 7700*f - 45430*f**2 - 199980*f**3 - 679195*f**4 - 1827920*f**5 - 3818280*f**6 - 5988976*f**7 - 6897926*f**8 - 5749464*f**9 - 3411380*f**10 - 1401400*f**11 - 378378*f**12 - 60368*f**13 - 4312*f**14)/1.430618112e11,
    88: lambda f: (255255 + 1701700*f + 9988979*f**2 + 43801758*f**3 + 148154864*f**4 + 397022080*f**5 + 824809740*f**6 + 1282240232*f**7 + 1457251474*f**8 + 1193361288*f**9 + 693087850*f**10 + 277854500*f**11 + 73036656*f**12 + 11323312*f**13 + 784784*f**14)/1.58083301376e13,
    89: lambda f: 0,
    90: lambda f: (1365 + 10010*f + 65065*f**2 + 317460*f**3 + 1201915*f**4 + 3629210*f**5 + 8359935*f**6 + 14074928*f**7 + 17005618*f**8 + 14628852*f**9 + 8859690*f**10 + 3686760*f**11 + 1002834*f**12 + 160524*f**13 + 11466*f**14)/3.0433148928e12,
    91: lambda f: (-255255 - 1871870*f - 12116104*f**2 - 58927440*f**3 - 222351415*f**4 - 669048770*f**5 - 1533629670*f**6 - 2558789408*f**7 - 3048748654*f**8 - 2574782028*f**9 - 1525242600*f**10 - 618987600*f**11 - 163837674*f**12 - 25477452*f**13 - 1765764*f**14)/2.845499424768e14,
    92: lambda f: 0,
    93: lambda f: (-455 - 3640*f - 25844*f**2 - 138424*f**3 - 578006*f**4 - 1934920*f**5 - 4835060*f**6 - 8597512*f**7 - 10757537*f**8 - 9462768*f**9 - 5812800*f**10 - 2440200*f**11 - 667086*f**12 - 107016*f**13 - 7644*f**14)/2.0288765952e13,
    94: lambda f: (23205 + 185640*f + 1313403*f**2 + 7015866*f**3 + 29213327*f**4 + 97509620*f**5 + 242564585*f**6 + 427358274*f**7 + 527065098*f**8 + 454912416*f**9 + 273183750*f**10 + 111793500*f**11 + 29728692*f**12 + 4632264*f**13 + 321048*f**14)/5.17363531776e14,
    95: lambda f: 0,
    96: lambda f: (4095 + 35490*f + 273273*f**2 + 1594008*f**3 + 7276802*f**4 + 26745940*f**5 + 71584950*f**6 + 132917848*f**7 + 170796773*f**8 + 152749422*f**9 + 94810275*f**10 + 40055400*f**11 + 10989594*f**12 + 1765764*f**13 + 126126*f**14)/4.017175658496e15,
    97: lambda f: (-69615 - 603330*f - 4631718*f**2 - 26954928*f**3 - 122758870*f**4 - 450093020*f**5 - 1199589360*f**6 - 2206541792*f**7 - 2793656089*f**8 - 2450449638*f**9 - 1486311750*f**10 - 611919000*f**11 - 163272186*f**12 - 25477452*f**13 - 1765764*f**14)/3.4145993097216e16,
    98: lambda f: 0,
    99: lambda f: (-585 - 5460*f - 45318*f**2 - 285948*f**3 - 1416727*f**4 - 5671640*f**5 - 16097100*f**6 - 30954344*f**7 - 40614889*f**8 - 36790236*f**9 - 23017050*f**10 - 9771300*f**11 - 2688147*f**12 - 432432*f**13 - 30888*f**14)/1.3773173686272e16,
    100: lambda f: (69615 + 649740*f + 5378919*f**2 + 33872670*f**3 + 167478662*f**4 + 669064240*f**5 + 1891348770*f**6 + 3602423692*f**7 + 4655723429*f**8 + 4134873708*f**9 + 2527174125*f**10 + 1045217250*f**11 + 279592236*f**12 + 43675632*f**13 + 3027024*f**14)/8.19503834333184e17,
    101: lambda f: 0,
    102: lambda f: (15 + 150*f + 1335*f**2 + 9060*f**3 + 48415*f**4 + 209690*f**5 + 626055*f**6 + 1239176*f**7 + 1653451*f**8 + 1513014*f**9 + 952515*f**10 + 405900*f**11 + 111903*f**12 + 18018*f**13 + 1287*f**14)/9.182115790848e15,
    103: lambda f: (-2805 - 28050*f - 249084*f**2 - 1687488*f**3 - 9001619*f**4 - 38915890*f**5 - 115746370*f**6 - 226890704*f**7 - 298121013*f**8 - 267396426*f**9 - 164412600*f**10 - 68244000*f**11 - 18291207*f**12 - 2859714*f**13 - 198198*f**14)/8.58527826444288e17,
    104: lambda f: 0,
    105: lambda f: (-495 - 5280*f - 50160*f**2 - 364320*f**3 - 2088680*f**4 - 9730720*f**5 - 30363600*f**6 - 61572448*f**7 - 83298068*f**8 - 76853952*f**9 - 48628020*f**10 - 20785380*f**11 - 5740119*f**12 - 924924*f**13 - 66066*f**14)/8.484274990743552e18,
    106: lambda f: (58905 + 628320*f + 5957259*f**2 + 43202610*f**3 + 247299085*f**4 + 1150280180*f**5 + 3576238575*f**6 + 7181184710*f**7 + 9564668533*f**8 + 8648034696*f**9 + 5343218475*f**10 + 2224264350*f**11 + 597109590*f**12 + 93417324*f**13 + 6474468*f**14)/5.0481436194924134e20,
    107: lambda f: 0,
    108: lambda f: (3465 + 39270*f + 396627*f**2 + 3069792*f**3 + 18794248*f**4 + 93716240*f**5 + 304003320*f**6 + 629274464*f**7 + 861176764*f**8 + 799998696*f**9 + 508296600*f**10 + 217809900*f**11 + 60234867*f**12 + 9711702*f**13 + 693693*f**14)/1.781697748056146e21,
    109: lambda f: (-58905 - 667590*f - 6730878*f**2 - 52024896*f**3 - 318075032*f**4 - 1583832880*f**5 - 5119739040*f**6 - 10493027776*f**7 - 14135164652*f**8 - 12865744584*f**9 - 7980997500*f**10 - 3330211500*f**11 - 895169583*f**12 - 140125986*f**13 - 9711702*f**14)/1.514443085847724e22,
    110: lambda f: 0,
    111: lambda f: (-385 - 4620*f - 49434*f**2 - 406164*f**3 - 2644741*f**4 - 14054240*f**5 - 47184560*f**6 - 99410976*f**7 - 137381076*f**8 - 128357264*f**9 - 81839800*f**10 - 35142800*f**11 - 9730028*f**12 - 1569568*f**13 - 112112*f**14)/6.334925326421852e21,
    112: lambda f: (255255 + 3063060*f + 32723691*f**2 + 268542846*f**3 + 1746479020*f**4 + 9269270400*f**5 + 31014674200*f**6 + 64692472656*f**7 + 87988999252*f**8 + 80536400784*f**9 + 50126926500*f**10 + 20957937000*f**11 + 5639682048*f**12 + 883218336*f**13 + 61213152*f**14)/2.100027745708844e24,
    113: lambda f: 0,
    114: lambda f: (15015 + 190190*f + 2149147*f**2 + 18682092*f**3 + 128918933*f**4 + 727308790*f**5 + 2517814665*f**6 + 5386655904*f**7 + 7506714684*f**8 + 7048125336*f**9 + 4507208300*f**10 + 1938890800*f**11 + 537354972*f**12 + 86718632*f**13 + 6194188*f**14)/8.400110982835376e24,
    115: lambda f: (-15015 - 190190*f - 2146144*f**2 - 18635760*f**3 - 128458187*f**4 - 723900970*f**5 - 2497827510*f**6 - 5290248768*f**7 - 7254915276*f**8 - 6672203832*f**9 - 4164734000*f**10 - 1744204000*f**11 - 469790244*f**12 - 73601528*f**13 - 5101096*f**14)/4.200055491417688e24,
    116: lambda f: 0,
    117: lambda f: (-15015 - 200200*f - 2382380*f**2 - 21844680*f**3 - 159243370*f**4 - 950544920*f**5 - 3382364220*f**6 - 7334167064*f**7 - 10295235139*f**8 - 9707304096*f**9 - 6223623840*f**10 - 2681355600*f**11 - 743758092*f**12 - 120071952*f**13 - 8576568*f**14)/3.0240399538207353e26,
    118: lambda f: (15015 + 200200*f + 2379377*f**2 + 21795774*f**3 + 158729857*f**4 + 946528700*f**5 + 3357416175*f**6 + 7206497438*f**7 + 9953741476*f**8 + 9192056832*f**9 + 5751717300*f**10 + 2412333000*f**11 + 650261304*f**12 + 101909808*f**13 + 7063056*f**14)/1.5120199769103677e26,
    119: lambda f: 0,
}

Q102withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: -(f*(14 + 19*f + 12*f**2 + 3*f**3))/210.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/1260.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: -(f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/55440.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/4.32432e6,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: -(f*(30030 + 143715*f + 414700*f**2 + 825175*f**3 + 1194500*f**4 + 1300454*f**5 + 1078112*f**6 + 670390*f**7 + 300510*f**8 + 91035*f**9 + 16632*f**10 + 1386*f**11))/1.729728e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 695829*f**5 + 716912*f**6 + 530740*f**7 + 269010*f**8 + 87885*f**9 + 16632*f**10 + 1386*f**11))/3.459456e8,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: -(f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 220761*f**5 + 258248*f**6 + 207835*f**7 + 110790*f**8 + 37215*f**9 + 7128*f**10 + 594*f**11))/5.930496e8,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 3016468*f**5 + 3830624*f**6 + 3235960*f**7 + 1772820*f**8 + 604170*f**9 + 116424*f**10 + 9702*f**11))/5.81188608e10,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: -(f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1786692*f**5 + 2402176*f**6 + 2094260*f**7 + 1167180*f**8 + 401310*f**9 + 77616*f**10 + 6468*f**11))/3.099672576e11,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (f*(10010 + 90805*f + 514800*f**2 + 2120950*f**3 + 6761750*f**4 + 14783193*f**5 + 20724704*f**6 + 18471880*f**7 + 10416420*f**8 + 3602970*f**9 + 698544*f**10 + 58212*f**11))/2.7897053184e13,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: -(f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1262063*f**5 + 1826664*f**6 + 1654905*f**7 + 941220*f**8 + 326970*f**9 + 63504*f**10 + 5292*f**11))/3.0433148928e13,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1888914*f**5 + 2803472*f**6 + 2571940*f**7 + 1472310*f**8 + 513135*f**9 + 99792*f**10 + 8316*f**11))/6.69529276416e14,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: -(f*(546 + 6357*f + 46644*f**2 + 251641*f**3 + 1064180*f**4 + 2725326*f**5 + 4127648*f**6 + 3824590*f**7 + 2200590*f**8 + 768915*f**9 + 149688*f**10 + 12474*f**11))/1.6068702633984e16,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 460987*f**5 + 709936*f**6 + 663140*f**7 + 383130*f**8 + 134145*f**9 + 26136*f**10 + 2178*f**11))/5.0501636849664e16,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: -(f*(2310 + 30855*f + 260700*f**2 + 1627925*f**3 + 8013250*f**4 + 22000083*f**5 + 34357624*f**6 + 32307905*f**7 + 18729270*f**8 + 6568695*f**9 + 1280664*f**10 + 106722*f**11))/4.949160411267072e19,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: (f*(462 + 6567*f + 59136*f**2 + 394384*f**3 + 2078000*f**4 + 5867784*f**5 + 9273152*f**6 + 8769040*f**7 + 5097960*f**8 + 1790460*f**9 + 349272*f**10 + 29106*f**11))/2.969496246760243e20,
    50: lambda f: 0,
    51: lambda f: 0,
    52: lambda f: -(f*(6006 + 90519*f + 865436*f**2 + 6139159*f**3 + 34474640*f**4 + 99787096*f**5 + 159315968*f**6 + 151378360*f**7 + 88217640*f**8 + 31019940*f**9 + 6054048*f**10 + 504504*f**11))/1.2353104386522612e23,
    53: lambda f: 0,
    54: lambda f: 0,
    55: lambda f: (f*(2002 + 31889*f + 322608*f**2 + 2425462*f**3 + 14460710*f**4 + 42785073*f**5 + 68917184*f**6 + 65754640*f**7 + 38398920*f**8 + 13516020*f**9 + 2638944*f**10 + 219912*f**11))/1.4000184971392293e24,
    56: lambda f: 0,
    57: lambda f: 0,
    58: lambda f: -(f*(2002 + 33605*f + 358644*f**2 + 2848651*f**3 + 17970770*f**4 + 54221931*f**5 + 88020968*f**6 + 84284725*f**7 + 49308840*f**8 + 17371620*f**9 + 3392928*f**10 + 282744*f**11))/5.040066589701226e25,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (f*(70 + 123*f + 100*f**2 + 28*f**3))/4200.,
    64: lambda f: -(f*(294 + 357*f + 200*f**2 + 44*f**3))/2940.,
    65: lambda f: (f*(490 + 749*f + 380*f**2 + 64*f**3))/29400.,
    66: lambda f: -(f*(70 + 239*f + 400*f**2 + 349*f**3 + 160*f**4 + 30*f**5))/12600.,
    67: lambda f: (f*(686 + 1414*f + 1580*f**2 + 1017*f**3 + 360*f**4 + 55*f**5))/8820.,
    68: lambda f: -(f*(5390 + 12859*f + 14960*f**2 + 9939*f**3 + 3460*f**4 + 480*f**5))/323400.,
    69: lambda f: (f*(2310 + 15411*f + 42900*f**2 + 65446*f**3 + 60890*f**4 + 34515*f**5 + 11060*f**6 + 1540*f**7))/3.3264e6,
    70: lambda f: -(f*(61446 + 179025*f + 299640*f**2 + 320318*f**3 + 224650*f**4 + 100665*f**5 + 26320*f**6 + 3080*f**7))/2.32848e6,
    71: lambda f: (f*(210210 + 681681*f + 1204060*f**2 + 1353846*f**3 + 986190*f**4 + 453065*f**5 + 118860*f**6 + 13440*f**7))/3.36336e7,
    72: lambda f: -(f**2*(12012 + 57200*f + 133757*f**2 + 194470*f**3 + 187375*f**4 + 120820*f**5 + 50435*f**6 + 12390*f**7 + 1365*f**8))/2.16216e7,
    73: lambda f: (f*(168168 + 633633*f + 1412840*f**2 + 2111122*f**3 + 2213020*f**4 + 1642840*f**5 + 850640*f**6 + 293510*f**7 + 60900*f**8 + 5775*f**9))/3.027024e7,
    74: lambda f: -(f*(210210 + 861861*f + 2024880*f**2 + 3180931*f**3 + 3486710*f**4 + 2693235*f**5 + 1441580*f**6 + 509845*f**7 + 107100*f**8 + 10080*f**9))/1.513512e8,
    75: lambda f: (f*(-6006 + 7293*f + 128700*f**2 + 466336*f**3 + 974660*f**4 + 1365294*f**5 + 1346744*f**6 + 945700*f**7 + 465570*f**8 + 153405*f**9 + 30492*f**10 + 2772*f**11))/4.1513472e8,
    76: lambda f: -(f*(1219218 + 5636631*f + 15701400*f**2 + 30135040*f**3 + 42038900*f**4 + 43564362*f**5 + 33692624*f**6 + 19258540*f**7 + 7922250*f**8 + 2224215*f**9 + 382536*f**10 + 30492*f**11))/1.45297152e9,
    77: lambda f: (f*(3573570 + 17714697*f + 51780300*f**2 + 104102492*f**3 + 151678420*f**4 + 163750086*f**5 + 131544952*f**6 + 77829500*f**7 + 32996250*f**8 + 9493785*f**9 + 1660428*f**10 + 133056*f**11))/1.646701056e10,
    78: lambda f: -(f*(-510510 - 1042899*f + 2917200*f**2 + 22562111*f**3 + 68062900*f**4 + 130692600*f**5 + 177848104*f**6 + 178239110*f**7 + 133005474*f**8 + 73375365*f**9 + 29170680*f**10 + 7927227*f**11 + 1321320*f**12 + 102102*f**13))/1.76432256e11,
    79: lambda f: (f*(12150138 + 66570504*f + 222436500*f**2 + 521414803*f**3 + 908117900*f**4 + 1207852227*f**5 + 1242589376*f**6 + 991225270*f**7 + 609077322*f**8 + 283426710*f**9 + 96769596*f**10 + 22904343*f**11 + 3363360*f**12 + 231231*f**13))/1.235025792e11,
    80: lambda f: -(f*(67897830 + 394777383*f + 1378279760*f**2 + 3371112563*f**3 + 6114842200*f**4 + 8457409390*f**5 + 9032522632*f**6 + 7466531870*f**7 + 4744271742*f**8 + 2277208395*f**9 + 799527960*f**10 + 193846191*f**11 + 29008980*f**12 + 2018016*f**13))/2.607276672e12,
    81: lambda f: (f*(-72930 - 269841*f - 243100*f**2 + 1660594*f**3 + 8554910*f**4 + 22869505*f**5 + 41588588*f**6 + 53989120*f**7 + 50143578*f**8 + 32880105*f**9 + 14817660*f**10 + 4361544*f**11 + 755040*f**12 + 58344*f**13))/2.01636864e11,
    82: lambda f: -(f*(1327326 + 8408829*f + 32769880*f**2 + 90734202*f**3 + 189468910*f**4 + 305134139*f**5 + 379405152*f**6 + 360586940*f**7 + 257761434*f**8 + 135510795*f**9 + 50651832*f**10 + 12717936*f**11 + 1921920*f**12 + 132132*f**13))/1.411458048e11,
    83: lambda f: (f*(67897830 + 452975523*f + 1837398420*f**2 + 5289236758*f**3 + 11468273270*f**4 + 19171902405*f**5 + 24748865036*f**6 + 24409593460*f**7 + 18077370066*f**8 + 9815903685*f**9 + 3773842380*f**10 + 969836868*f**11 + 149189040*f**12 + 10378368*f**13))/2.6817702912e13,
    84: lambda f: -(f*(-1021020 - 5061342*f - 11668800*f**2 - 1231412*f**3 + 88140920*f**4 + 376870620*f**5 + 919570064*f**6 + 1455428380*f**7 + 1540741104*f**8 + 1099121940*f**9 + 521870580*f**10 + 158225067*f**11 + 27747720*f**12 + 2144142*f**13))/2.9640619008e13,
    85: lambda f: (f*(15723708 + 113077965*f + 503508720*f**2 + 1607935004*f**3 + 3914743000*f**4 + 7321176072*f**5 + 10358140576*f**6 + 10900056860*f**7 + 8403004512*f**8 + 4659478110*f**9 + 1804552596*f**10 + 462848463*f**11 + 70630560*f**12 + 4855851*f**13))/2.07484333056e13,
    86: lambda f: -(f*(271591320 + 2044694652*f + 9444726720*f**2 + 31258481332*f**3 + 78797387480*f**4 + 152802675900*f**5 + 224606967536*f**6 + 245644225540*f**7 + 196441181496*f**8 + 112581020160*f**9 + 44849338380*f**10 + 11769898833*f**11 + 1827565740*f**12 + 127135008*f**13))/1.314067442688e15,
    87: lambda f: (f*(-850850 - 5151289*f - 16773900*f**2 - 26901004*f**3 + 22431160*f**4 + 342408900*f**5 + 1158900176*f**6 + 2147918920*f**7 + 2478482916*f**8 + 1857774730*f**9 + 907611320*f**10 + 279456408*f**11 + 49329280*f**12 + 3811808*f**13))/3.16166602752e14,
    88: lambda f: -(f*(11673662 + 93950857*f + 470544360*f**2 + 1702439908*f**3 + 4734575480*f**4 + 9975068988*f**5 + 15470598304*f**6 + 17377608920*f**7 + 14007130788*f**8 + 8000421590*f**9 + 3157513744*f**10 + 818809992*f**11 + 125565440*f**12 + 8632624*f**13))/2.213166219264e14,
    89: lambda f: (f*(67897830 + 569371803*f + 2949629540*f**2 + 11029563688*f**3 + 31679181080*f**4 + 69174061140*f**5 + 111573765968*f**6 + 130415497240*f**7 + 109143723668*f**8 + 64457428770*f**9 + 26168428440*f**10 + 6941983664*f**11 + 1083001920*f**12 + 75339264*f**13))/4.672239796224e15,
    90: lambda f: -(f*(-170170 - 1203345*f - 4862000*f**2 - 12008035*f**3 - 12882600*f**4 + 66651730*f**5 + 337058736*f**6 + 711109140*f**7 + 871972836*f**8 + 675146010*f**9 + 335818560*f**10 + 104383818*f**11 + 18498480*f**12 + 1429428*f**13))/9.48499808256e14,
    91: lambda f: (f*(2144142 + 19093074*f + 106234700*f**2 + 429457145*f**3 + 1343095200*f**4 + 3117373691*f**5 + 5174939840*f**6 + 6079969140*f**7 + 5045975508*f**8 + 2936736600*f**9 + 1172687208*f**10 + 306146610*f**11 + 47087040*f**12 + 3237234*f**13))/6.639498657792e14,
    92: lambda f: -(f*(113163050 + 1045949905*f + 6004570000*f**2 + 25027278705*f**3 + 80654747300*f**4 + 194012734260*f**5 + 335301084272*f**6 + 410361566020*f**7 + 353840412492*f**8 + 212991123870*f**9 + 87490307520*f**10 + 23362833186*f**11 + 3655131480*f**12 + 254270016*f**13))/1.26150474498048e17,
    93: lambda f: (f*(-108290 - 870961*f - 4132700*f**2 - 12956346*f**3 - 25332550*f**4 + 33732675*f**5 + 301634452*f**6 + 709469180*f**7 + 910068012*f**8 + 720939870*f**9 + 363048840*f**10 + 113573376*f**11 + 20180160*f**12 + 1559376*f**13))/1.034727063552e16,
    94: lambda f: -(f*(1277822 + 12473461*f + 76333400*f**2 + 340981342*f**3 + 1184489450*f**4 + 2978232601*f**5 + 5208117488*f**6 + 6322089760*f**7 + 5355880236*f**8 + 3157730730*f**9 + 1271018448*f**10 + 333318384*f**11 + 51367680*f**12 + 3531528*f**13))/7.243089444864e15,
    95: lambda f: (f*(22632610 + 228589361*f + 1440173020*f**2 + 6619110446*f**3 + 23646458550*f**4 + 61634180085*f**5 + 112324319548*f**6 + 142154160680*f**7 + 125182869588*f**8 + 76350790530*f**9 + 31613896440*f**10 + 8479488024*f**11 + 1329138720*f**12 + 92461824*f**13))/4.5872899817472e17,
    96: lambda f: -(f*(-92820 - 834054*f - 4508400*f**2 - 16731689*f**3 - 43047910*f**4 + 12311145*f**5 + 353389484*f**6 + 912133285*f**7 + 1211355054*f**8 + 976037265*f**9 + 495952380*f**10 + 155868867*f**11 + 27747720*f**12 + 2144142*f**13))/1.7072996548608e17,
    97: lambda f: (f*(2079168 + 22077237*f + 147371640*f**2 + 720859126*f**3 + 2753740580*f**4 + 7404509664*f**5 + 13490229872*f**6 + 16785838090*f**7 + 14438563524*f**8 + 8593648245*f**9 + 3479042952*f**10 + 915329646*f**11 + 141261120*f**12 + 9711702*f**13))/2.39021951680512e17,
    98: lambda f: -(f*(6172530 + 67633293*f + 463905520*f**2 + 2330432403*f**3 + 9139249470*f**4 + 25485967775*f**5 + 48435179772*f**6 + 62877646545*f**7 + 56242346832*f**8 + 34634595870*f**9 + 14423977260*f**10 + 3881165211*f**11 + 609188580*f**12 + 42378336*f**13))/2.52300948996096e18,
    99: lambda f: (f*(-139230 - 1379703*f - 8331700*f**2 - 35326408*f**3 - 108913220*f**4 - 24821870*f**5 + 707208712*f**6 + 1978492460*f**7 + 2700861702*f**8 + 2204857095*f**9 + 1128051540*f**10 + 355766796*f**11 + 63423360*f**12 + 4900896*f**13))/5.46335889555456e18,
    100: lambda f: -(f*(1494402 + 17148495*f + 123998680*f**2 + 659158136*f**3 + 2746300700*f**4 + 7817965406*f**5 + 14721932848*f**6 + 18676395220*f**7 + 16254031206*f**8 + 9744214305*f**9 + 3962113848*f**10 + 1044980244*f**11 + 161441280*f**12 + 11099088*f**13))/3.824351226888192e18,
    101: lambda f: (f*(882671790 + 10428136719*f + 77350870740*f**2 + 421602257804*f**3 + 1800459565060*f**4 + 5318425986990*f**5 + 10455837465304*f**6 + 13846945874300*f**7 + 12535617636234*f**8 + 7776401513265*f**9 + 3252785479020*f**10 + 877358390832*f**11 + 137850672960*f**12 + 9589612032*f**13))/7.992894064196321e21,
    102: lambda f: -(f*(-28050 - 303501*f - 2019600*f**2 - 9574111*f**3 - 33884060*f**4 - 18477300*f**5 + 186176968*f**6 + 558985790*f**7 + 780328098*f**8 + 643679685*f**9 + 331099560*f**10 + 104708439*f**11 + 18687240*f**12 + 1444014*f**13))/2.575583479332864e19,
    103: lambda f: (f*(290598 + 3583668*f + 27904140*f**2 + 160176397*f**3 + 722820620*f**4 + 2161101489*f**5 + 4181566592*f**6 + 5387824750*f**7 + 4732758954*f**8 + 2853420570*f**9 + 1164215052*f**10 + 307641411*f**11 + 47567520*f**12 + 3270267*f**13))/1.8029084355330048e19,
    104: lambda f: -(f*(5222910 + 66181731*f + 527833680*f**2 + 3102168551*f**3 + 14328900160*f**4 + 44481024450*f**5 + 89923580152*f**6 + 121012574690*f**7 + 110603267082*f**8 + 69009719625*f**9 + 28965265560*f**10 + 7827349761*f**11 + 1230809580*f**12 + 85621536*f**13))/1.141842009170903e21,
    105: lambda f: (f*(-431970 - 5063025*f - 36745500*f**2 - 191924390*f**3 - 760808650*f**4 - 583314795*f**5 + 3679713212*f**6 + 11761907080*f**7 + 16726010742*f**8 + 13914150495*f**9 + 7188438180*f**10 + 2278301256*f**11 + 406966560*f**12 + 31447416*f**13))/1.0096287238984827e22,
    106: lambda f: -(f*(4343262 + 57283149*f + 477859800*f**2 + 2945819330*f**3 + 14313492550*f**4 + 44656939719*f**5 + 88390665664*f**6 + 115348243220*f**7 + 102090655926*f**8 + 61834152765*f**9 + 25298378952*f**10 + 6695311392*f**11 + 1035914880*f**12 + 71219148*f**13))/7.067401067289379e21,
    107: lambda f: (f*(26114550 + 353292555*f + 3014720500*f**2 + 19003385230*f**3 + 94393471550*f**4 + 305969655425*f**5 + 633179464316*f**6 + 863371735660*f**7 + 795249734286*f**8 + 498508885035*f**9 + 209816519220*f**10 + 56784712908*f**11 + 8934765840*f**12 + 621548928*f**13))/1.4920068919833133e23,
    108: lambda f: -(f*(-78540 - 990726*f - 7779200*f**2 - 44288536*f**3 - 193521200*f**4 - 180563800*f**5 + 845279008*f**6 + 2857301720*f**7 + 4126993248*f**8 + 3457342980*f**9 + 1792573860*f**10 + 569162979*f**11 + 101741640*f**12 + 7861854*f**13))/5.0481436194924134e22,
    109: lambda f: (f*(769692 + 10811031*f + 96192800*f**2 + 633811272*f**3 + 3299094800*f**4 + 10684365904*f**5 + 21558375552*f**6 + 28433718040*f**7 + 25323212544*f**8 + 15395803920*f**9 + 6313214292*f**10 + 1672920711*f**11 + 258978720*f**12 + 17804787*f**13))/3.5337005336446894e22,
    110: lambda f: -(f*(543182640 + 7814070264*f + 71034986880*f**2 + 478040596904*f**3 + 2540861282800*f**4 + 8554748708760*f**5 + 18058061478688*f**6 + 24895094493080*f**7 + 23078595194928*f**8 + 14522792373180*f**9 + 6126367387140*f**10 + 1660090150719*f**11 + 261341900820*f**12 + 18180306144*f**13))/8.728240318102383e25,
    111: lambda f: (f*(-6636630 - 89609091*f - 756284100*f**2 - 4654577356*f**3 - 22164843440*f**4 - 23591055720*f**5 + 89003237344*f**6 + 316390536560*f**7 + 463093969464*f**8 + 390249781740*f**9 + 202946824080*f**10 + 64535142672*f**11 + 11543051520*f**12 + 891963072*f**13))/1.2600166474253064e26,
    112: lambda f: -(f*(63609546 + 947966019*f + 8961346680*f**2 + 62848734052*f**3 + 348899134160*f**4 + 1167810141672*f**5 + 2395528054976*f**6 + 3188040736720*f**7 + 2854229047992*f**8 + 1740797693460*f**9 + 715186888416*f**10 + 189714693168*f**11 + 29382312960*f**12 + 2020034016*f**13))/8.820116531977146e25,
    113: lambda f: (f*(1154263110 + 17594267691*f + 169747346340*f**2 + 1214638280336*f**3 + 6878410091440*f**4 + 23950233809640*f**5 + 51424980727456*f**6 + 71558261074160*f**7 + 66696579411336*f**8 + 42106191310260*f**9 + 17796060762480*f**10 + 4827261767328*f**11 + 760267347840*f**12 + 52888163328*f**13))/5.586073803585525e27,
    114: lambda f: -(f*(-70070 - 1008007*f - 9094800*f**2 - 60111077*f**3 - 309281680*f**4 - 362371830*f**5 + 1156700832*f**6 + 4303651800*f**7 + 6371762712*f**8 + 5396637820*f**9 + 2813666240*f**10 + 895863276*f**11 + 160320160*f**12 + 12388376*f**13))/4.200055491417688e25,
    115: lambda f: (f*(658658 + 10380370*f + 103895220*f**2 + 772736159*f**3 + 4557322600*f**4 + 15707921001*f**5 + 32685518208*f**6 + 43835429400*f**7 + 39421607736*f**8 + 24108150080*f**9 + 9920506288*f**10 + 2633918364*f**11 + 408087680*f**12 + 28056028*f**13))/2.9400388439923816e25,
    116: lambda f: -(f*(3993990 + 64303239*f + 656209840*f**2 + 4974929999*f**3 + 29901989860*f**4 + 107282628280*f**5 + 233785063456*f**6 + 327922164920*f**7 + 307056242696*f**8 + 194380440660*f**9 + 82286930880*f**10 + 22340241308*f**11 + 3519756240*f**12 + 244852608*f**13))/6.206748670650584e26,
    117: lambda f: (f*(-50050 - 764049*f - 7335900*f**2 - 51786514*f**3 - 285950190*f**4 - 360764425*f**5 + 1005953508*f**6 + 3901424100*f**7 + 5834225208*f**8 + 4962936300*f**9 + 2593242960*f**10 + 826588224*f**11 + 147987840*f**12 + 11435424*f**13))/1.0080133179402451e27,
    118: lambda f: -(f*(462462 + 7684677*f + 81183960*f**2 + 638266278*f**3 + 3985251330*f**4 + 14101523269*f**5 + 29712086992*f**6 + 40114693080*f**7 + 36215108664*f**8 + 22198646820*f**9 + 9147385632*f**10 + 2430511776*f**11 + 376696320*f**12 + 25897872*f**13))/7.056093225581716e26,
    119: lambda f: (f*(25295270 + 428935507*f + 4616128660*f**2 + 36960913522*f**3 + 234997487770*f**4 + 866077470915*f**5 + 1911918630916*f**6 + 2700417230000*f**7 + 2538675170136*f**8 + 1610898605820*f**9 + 682886468880*f**10 + 185537510928*f**11 + 29241051840*f**12 + 2034160128*f**13))/1.340657712860526e29,
}

Q104withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: -(f**2*(2 + f)**2)/315.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/3465.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: -(f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/120120.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/540540.,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: -(f**2*(2 + f)**2*(12155 + 44200*f + 93500*f**2 + 128520*f**3 + 125706*f**4 + 87192*f**5 + 40404*f**6 + 11088*f**7 + 1386*f**8))/2.9405376e8,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (f**2*(2 + f)**2*(2431 + 11050*f + 29325*f**2 + 52360*f**3 + 67270*f**4 + 58380*f**5 + 31290*f**6 + 9240*f**7 + 1155*f**8))/4.900896e8,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: -(f**2*(2 + f)**2*(2431 + 13260*f + 42330*f**2 + 92820*f**3 + 142125*f**4 + 137880*f**5 + 78420*f**6 + 23760*f**7 + 2970*f**8))/5.0409216e9,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (f**2*(2 + f)**2*(9724 + 61880*f + 230860*f**2 + 599760*f**3 + 1037820*f**4 + 1076040*f**5 + 632100*f**6 + 194040*f**7 + 24255*f**8))/2.470051584e11,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: -(f**2*(2 + f)**2*(2431 + 17680*f + 75480*f**2 + 226576*f**3 + 429044*f**4 + 464912*f**5 + 278712*f**6 + 86240*f**7 + 10780*f**8))/8.782405632e11,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (f**2*(2 + f)**2*(12155 + 99450*f + 478125*f**2 + 1627920*f**3 + 3303468*f**4 + 3693816*f**5 + 2245572*f**6 + 698544*f**7 + 87318*f**8))/7.11374856192e13,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: -(f**2*(2 + f)**2*(2431 + 22100*f + 118150*f**2 + 449820*f**3 + 964215*f**4 + 1103760*f**5 + 677880*f**6 + 211680*f**7 + 26460*f**8))/2.58681765888e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (f**2*(2 + f)**2*(221 + 2210*f + 13005*f**2 + 54740*f**3 + 122675*f**4 + 143010*f**5 + 88515*f**6 + 27720*f**7 + 3465*f**8))/4.74249904128e14,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: -(f**2*(2 + f)**2*(31603 + 344760*f + 2214420*f**2 + 10210200*f**3 + 23739870*f**4 + 28080360*f**5 + 17486700*f**6 + 5488560*f**7 + 686070*f**8))/1.502423696277504e18,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (f**2*(2 + f)**2*(187 + 2210*f + 15385*f**2 + 77112*f**3 + 184938*f**4 + 221364*f**5 + 138534*f**6 + 43560*f**7 + 5445*f**8))/2.14631956611072e17,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: -(f**2*(2 + f)**2*(935 + 11900*f + 89250*f**2 + 483140*f**3 + 1189769*f**4 + 1438248*f**5 + 903756*f**6 + 284592*f**7 + 35574*f**8))/2.804524233051341e19,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: (f**2*(2 + f)**2*(19448 + 265200*f + 2131800*f**2 + 12395040*f**3 + 31228680*f**4 + 38067120*f**5 + 24002160*f**6 + 7567560*f**7 + 945945*f**8))/1.6406466763350344e22,
    51: lambda f: 0,
    52: lambda f: 0,
    53: lambda f: -(f**2*(2 + f)**2*(41327 + 601120*f + 5155760*f**2 + 32044320*f**3 + 82357800*f**4 + 101112480*f**5 + 63939120*f**6 + 20180160*f**7 + 2522520*f**8))/1.050013872854422e24,
    54: lambda f: 0,
    55: lambda f: 0,
    56: lambda f: (f**2*(2 + f)**2*(143 + 2210*f + 20145*f**2 + 133280*f**3 + 348600*f**4 + 430640*f**5 + 273000*f**6 + 86240*f**7 + 10780*f**8))/1.1666820809493578e23,
    57: lambda f: 0,
    58: lambda f: 0,
    59: lambda f: -(f**2*(2 + f)**2*(2717 + 44460*f + 429210*f**2 + 3011652*f**3 + 8000433*f**4 + 9936864*f**5 + 6313104*f**6 + 1995840*f**7 + 249480*f**8))/7.560099884551838e25,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (2*f**2*(2 + f))/945.,
    64: lambda f: (2*f**2*(77 + 64*f + 18*f**2))/6615.,
    65: lambda f: (-2*f**2*(154 + 155*f + 39*f**2))/24255.,
    66: lambda f: -(f**2*(132 + 170*f + 82*f**2 + 15*f**3))/10395.,
    67: lambda f: -(f**2*(6237 + 10412*f + 7970*f**2 + 3065*f**3 + 495*f**4))/218295.,
    68: lambda f: (f**2*(6776 + 11418*f + 8665*f**2 + 3495*f**3 + 585*f**4))/266805.,
    69: lambda f: (f**2*(1430 + 3107*f + 3186*f**2 + 1815*f**3 + 550*f**4 + 70*f**5))/180180.,
    70: lambda f: (f**2*(51051 + 129740*f + 165888*f**2 + 126645*f**3 + 58935*f**4 + 15575*f**5 + 1820*f**6))/3.78378e6,
    71: lambda f: -(f**2*(66066 + 166309*f + 210248*f**2 + 161985*f**3 + 77710*f**4 + 21770*f**5 + 2730*f**6))/4.62462e6,
    72: lambda f: -(f**2*(4004 + 12298*f + 19278*f**2 + 18705*f**3 + 11700*f**4 + 4620*f**5 + 1050*f**6 + 105*f**7))/1.62162e6,
    73: lambda f: -(f**2*(83083 + 284856*f + 513668*f**2 + 591530*f**3 + 459750*f**4 + 242060*f**5 + 83300*f**6 + 17010*f**7 + 1575*f**8))/2.270268e7,
    74: lambda f: (f**2*(176176 + 596882*f + 1064067*f**2 + 1223685*f**3 + 961725*f**4 + 520380*f**5 + 187425*f**6 + 40845*f**7 + 4095*f**8))/4.162158e7,
    75: lambda f: (f**2*(43758 + 173927*f + 366724*f**2 + 503166*f**3 + 478116*f**4 + 319620*f**5 + 148260*f**6 + 45570*f**7 + 8358*f**8 + 693*f**9))/8.8216128e7,
    76: lambda f: (f**2*(6279273 + 27147640*f + 63339790*f**2 + 97822930*f**3 + 106995270*f**4 + 84856002*f**5 + 48782580*f**6 + 19900230*f**7 + 5481105*f**8 + 917070*f**9 + 70686*f**10))/9.26269344e9,
    77: lambda f: -(f**2*(1871870 + 8000421*f + 18468103*f**2 + 28386906*f**3 + 31136592*f**4 + 25004364*f**5 + 14724150*f**6 + 6235110*f**7 + 1808898*f**8 + 323631*f**9 + 27027*f**10))/2.264213952e9,
    78: lambda f: -(f**2*(2032316 + 9918038*f + 26269590*f**2 + 46594365*f**3 + 59413000*f**4 + 56029624*f**5 + 39347532*f**6 + 20386590*f**7 + 7584780*f**8 + 1919610*f**9 + 296142*f**10 + 21021*f**11))/2.79351072e10,
    79: lambda f: -(f**2*(55288233 + 288740036*f + 827485302*f**2 + 1605085515*f**3 + 2267647245*f**4 + 2408701652*f**5 + 1946799764*f**6 + 1195607658*f**7 + 550246515*f**8 + 184227120*f**9 + 42454566*f**10 + 6033027*f**11 + 399399*f**12))/5.866372512e11,
    80: lambda f: (f**2*(85357272 + 441104950*f + 1251886307*f**2 + 2414055165*f**3 + 3407450215*f**4 + 3638662328*f**5 + 2978628030*f**6 + 1868977278*f**7 + 887584950*f**8 + 310055130*f**9 + 75437439*f**10 + 11456445*f**11 + 819819*f**12))/7.170010848e11,
    81: lambda f: (f**2*(1200914 + 6949345*f + 22157154*f**2 + 48193215*f**3 + 75898350*f**4 + 87392526*f**5 + 72935868*f**6 + 43339710*f**7 + 17802270*f**8 + 4795065*f**9 + 761508*f**10 + 54054*f**11))/1.436662656e11,
    82: lambda f: (f**2*(10484903 + 64211108*f + 218328620*f**2 + 510109055*f**3 + 875704965*f**4 + 1125590921*f**5 + 1082250512*f**6 + 770429814*f**7 + 398706945*f**8 + 145463010*f**9 + 35430318*f**10 + 5171166*f**11 + 342342*f**12))/1.0056638592e12,
    83: lambda f: -(f**2*(49791742 + 302029871*f + 1017886050*f**2 + 2363609025*f**3 + 4039310130*f**4 + 5181655122*f**5 + 5002177320*f**6 + 3612039522*f**7 + 1921679550*f**8 + 731402595*f**9 + 188480061*f**10 + 29459430*f**11 + 2108106*f**12))/3.6874341504e12,
    84: lambda f: -(f**2*(11085360 + 74204728*f + 276619784*f**2 + 712621980*f**3 + 1312390800*f**4 + 1712070192*f**5 + 1564187016*f**6 + 988436820*f**7 + 422260440*f**8 + 116326980*f**9 + 18656946*f**10 + 1324323*f**11))/1.40792940288e13,
    85: lambda f: -(f**2*(282260979 + 1983607600*f + 7806530152*f**2 + 21343161700*f**3 + 42611005500*f**4 + 62250373416*f**5 + 66094771512*f**6 + 50586659004*f**7 + 27535909170*f**8 + 10386605460*f**9 + 2580625278*f**10 + 380080701*f**11 + 25162137*f**12))/2.956651746048e14,
    86: lambda f: (f**2*(455238784 + 3171521496*f + 12380914292*f**2 + 33643815660*f**3 + 66605524860*f**4 + 96482090544*f**5 + 102228795060*f**6 + 79052603364*f**7 + 44166444000*f**8 + 17381327040*f**9 + 4572829107*f**10 + 721756035*f**11 + 51648597*f**12))/3.613685467392e14,
    87: lambda f: (f**2*(1570426 + 11937757*f + 50938392*f**2 + 151648500*f**3 + 314811000*f**4 + 446707128*f**5 + 431167464*f**6 + 282068500*f**7 + 123055660*f**8 + 34296570*f**9 + 5527984*f**10 + 392392*f**11))/2.50298560512e13,
    88: lambda f: (f**2*(39122083 + 310322896*f + 1387629318*f**2 + 4346294460*f**3 + 9777781140*f**4 + 15630164844*f**5 + 17671912328*f**6 + 14110928076*f**7 + 7898288930*f**8 + 3032338540*f**9 + 761147772*f**10 + 112616504*f**11 + 7455448*f**12))/5.256269770752e14,
    89: lambda f: -(f**2*(64017954 + 503783423*f + 2236019503*f**2 + 6962439420*f**3 + 15470588880*f**4 + 24389241576*f**5 + 27400414860*f**6 + 22051487836*f**7 + 12657288980*f**8 + 5070313710*f**9 + 1348255678*f**10 + 213853640*f**11 + 15303288*f**12))/6.424329719808e14,
    90: lambda f: -(f**2*(17551820 + 149358430*f + 717825510*f**2 + 2424714165*f**3 + 5531083920*f**4 + 8333951472*f**5 + 8344450296*f**6 + 5581216620*f**7 + 2466865800*f**8 + 692431740*f**9 + 111941676*f**10 + 7945938*f**11))/4.0548366802944e15,
    91: lambda f: -(f**2*(143232089 + 1265830540*f + 6339401490*f**2 + 22382683905*f**3 + 55446340455*f**4 + 94689646968*f**5 + 111760471704*f**6 + 91740183948*f**7 + 52262702730*f**8 + 20285329680*f**9 + 5123645604*f**10 + 760161402*f**11 + 50324274*f**12))/2.83838567620608e16,
    92: lambda f: (f**2*(711310600 + 6240595790*f + 31039933395*f**2 + 108977310765*f**3 + 265623668235*f**4 + 445395921264*f**5 + 520728728940*f**6 + 430100475084*f**7 + 251119185660*f**8 + 101705386860*f**9 + 27221299182*f**10 + 4330536210*f**11 + 309891582*f**12))/1.040741414608896e17,
    93: lambda f: (f**2*(1939938 + 18269849*f + 97652590*f**2 + 368980665*f**3 + 908138250*f**4 + 1431054954*f**5 + 1470794472*f**6 + 998977140*f**7 + 445489380*f**8 + 125645310*f**9 + 20353032*f**10 + 1444716*f**11))/7.372430327808e15,
    94: lambda f: (f**2*(46823049 + 456229748*f + 2529785096*f**2 + 9940940315*f**3 + 26653769145*f**4 + 47866553217*f**5 + 58280215644*f**6 + 48776240268*f**7 + 28125948690*f**8 + 10998196020*f**9 + 2789587836*f**10 + 414633492*f**11 + 27449604*f**12))/1.54821036883968e17,
    95: lambda f: -(f**2*(78244166 + 757268655*f + 4172427436*f**2 + 16308013215*f**3 + 42870142890*f**4 + 75319676838*f**5 + 90625469130*f**6 + 76226287788*f**7 + 45030755700*f**8 + 18374498730*f**9 + 4939523694*f**10 + 787370220*f**11 + 56343924*f**12))/1.89225711747072e17,
    96: lambda f: -(f**2*(386308 + 3989050*f + 23471118*f**2 + 98087025*f**3 + 256976900*f**4 + 419227004*f**5 + 439367922*f**6 + 301804965*f**7 + 135460080*f**8 + 38336760*f**9 + 6218982*f**10 + 441441*f**11))/2.7032244535296e16,
    97: lambda f: -(f**2*(18429411 + 196278056*f + 1193788620*f**2 + 5167434750*f**3 + 14801056050*f**4 + 27649418804*f**5 + 34464206588*f**6 + 29259941886*f**7 + 17022142305*f**8 + 6692079240*f**9 + 1702509732*f**10 + 253387134*f**11 + 16774758*f**12))/1.135354270482432e18,
    98: lambda f: (f**2*(15519504 + 164256482*f + 993129715*f**2 + 4276977045*f**3 + 11971609205*f**4 + 21813719788*f**5 + 26820429405*f**6 + 22863717513*f**7 + 13622806575*f**8 + 5588809380*f**9 + 1507159269*f**10 + 240585345*f**11 + 17216199*f**12))/6.93827609739264e17,
    99: lambda f: (f**2*(30022850 + 337293073*f + 2166331284*f**2 + 9920767350*f**3 + 27385290900*f**4 + 45924066804*f**5 + 48864578532*f**6 + 33855865890*f**7 + 15270192630*f**8 + 4332875085*f**9 + 703633392*f**10 + 49945896*f**11))/4.281907534390886e19,
    100: lambda f: (f**2*(236349113 + 2731533480*f + 18081339094*f**2 + 85484963590*f**3 + 258931130370*f**4 + 499258345894*f**5 + 633812943148*f**6 + 544055174586*f**7 + 318646136655*f**8 + 125782777890*f**9 + 32072812002*f**10 + 4778157384*f**11 + 316324008*f**12))/2.9973352740736205e20,
    101: lambda f: -(f**2*(1202114914 + 13812312371*f + 90925158597*f**2 + 427795253730*f**3 + 1262485512480*f**4 + 2368478127708*f**5 + 2961563739750*f**6 + 2550784637478*f**7 + 1529753321250*f**8 + 630159754455*f**9 + 170342742339*f**10 + 27220513320*f**11 + 1947889944*f**12))/1.0990229338269942e21,
    102: lambda f: -(f**2*(383724 + 4659598*f + 32437598*f**2 + 161537145*f**3 + 466111800*f**4 + 799369224*f**5 + 860880372*f**6 + 600530370*f**7 + 271902180*f**8 + 77308110*f**9 + 12564882*f**10 + 891891*f**11))/1.2234021526831104e19,
    103: lambda f: -(f**2*(8985537 + 111999604*f + 801580702*f**2 + 4109801935*f**3 + 13059018345*f**4 + 25841472972*f**5 + 33290828844*f**6 + 28826263158*f**7 + 16972843965*f**8 + 6721249920*f**9 + 1716867306*f**10 + 255972717*f**11 + 16945929*f**12))/2.569144520634532e20,
    104: lambda f: (f**2*(15320536 + 189922062*f + 1352216567*f**2 + 6901048425*f**3 + 21306622515*f**4 + 40936408968*f**5 + 51881573730*f**6 + 45050894658*f**7 + 27156560970*f**8 + 11222656830*f**9 + 3039312969*f**10 + 486080595*f**11 + 34783749*f**12))/3.1400655252199834e20,
    105: lambda f: (f**2*(1030370 + 13448105*f + 100863210*f**2 + 542673915*f**3 + 1626604630*f**4 + 2841885046*f**5 + 3090840228*f**6 + 2167989810*f**7 + 984639810*f**8 + 280412055*f**9 + 45605868*f**10 + 3237234*f**11))/7.992894064196321e20,
    106: lambda f: (f**2*(23950773 + 320267420*f + 2464341420*f**2 + 13619280465*f**3 + 45107239275*f**4 + 91210153055*f**5 + 118922875736*f**6 + 103704199662*f**7 + 61322386965*f**8 + 24345956250*f**9 + 6227762310*f**10 + 929086158*f**11 + 61507446*f**12))/1.6785077534812275e22,
    107: lambda f: -(f**2*(41037150 + 545936215*f + 4180230470*f**2 + 23000847765*f**3 + 73835653570*f**4 + 144701107082*f**5 + 185420928420*f**6 + 162075077262*f**7 + 98102871090*f**8 + 40646407725*f**9 + 11024258091*f**10 + 1764292530*f**11 + 126252126*f**12))/2.051509476477056e22,
    108: lambda f: -(f**2*(45819488 + 639658864*f + 5142134160*f**2 + 29724695160*f**3 + 92087604000*f**4 + 163424387616*f**5 + 179200218288*f**6 + 126267337560*f**7 + 57493046520*f**8 + 16395118740*f**9 + 2667943278*f**10 + 189378189*f**11))/9.351686055109696e23,
    109: lambda f: -(f**2*(352745393 + 5037053216*f + 41466941552*f**2 + 245734536920*f**3 + 843896256360*f**4 + 1737909075056*f**5 + 2288726231792*f**6 + 2007528019224*f**7 + 1191279600420*f**8 + 473953339860*f**9 + 121380256998*f**10 + 18117180081*f**11 + 1199395197*f**12))/6.546180238576787e24,
    110: lambda f: (f**2*(1820955136 + 25876925360*f + 212043347496*f**2 + 1251316638360*f**3 + 4155626101560*f**4 + 8281543529952*f**5 + 10709751026520*f**6 + 9412543801752*f**7 + 5716764717300*f**8 + 2373618166920*f**9 + 644568625701*f**10 + 103211113005*f**11 + 7385749371*f**12))/2.400266087478155e25,
    111: lambda f: (f**2*(51824058 + 770579485*f + 6609670448*f**2 + 40853698920*f**3 + 130279359600*f**4 + 234306848496*f**5 + 258704333328*f**6 + 182983289160*f**7 + 83494876920*f**8 + 23836552740*f**9 + 3880644768*f**10 + 275459184*f**11))/2.992539537635103e25,
    112: lambda f: (f**2*(1190151963 + 18075317728*f + 158524346350*f**2 + 1002760489720*f**3 + 3555327797160*f**4 + 7437331895448*f**5 + 9877746453456*f**6 + 8706793485432*f**7 + 5181935040660*f**8 + 2065277093880*f**9 + 529437092184*f**10 + 79056785808*f**11 + 5233724496*f**12))/6.284333029033716e26,
    113: lambda f: -(f**2*(2055687634 + 31077945327*f + 271364698355*f**2 + 1709677979640*f**3 + 5849855234400*f**4 + 11825922533712*f**5 + 15412281009720*f**6 + 13607744297112*f**7 + 8288342953800*f**8 + 3447448624620*f**9 + 937129549356*f**10 + 150125255280*f**11 + 10742908176*f**12))/7.680851479930096e26,
    114: lambda f: -(f**2*(380380 + 6001606*f + 54711678*f**2 + 360065865*f**3 + 1177924000*f**4 + 2143019872*f**5 + 2380167216*f**6 + 1688979320*f**7 + 772071440*f**8 + 220623480*f**9 + 35931896*f**10 + 2550548*f**11))/6.650087861411339e24,
    115: lambda f: -(f**2*(8691683 + 139895860*f + 1302166254*f**2 + 8757332655*f**3 + 31941485865*f**4 + 67729484816*f**5 + 90607674192*f**6 + 80201579304*f**7 + 47852665420*f**8 + 19100348960*f**9 + 4900454328*f**10 + 732007276*f**11 + 48460412*f**12))/1.3965184508963812e26,
    116: lambda f: (f**2*(15063048 + 241394582*f + 2237558959*f**2 + 14990454225*f**3 + 52665338575*f**4 + 107792227424*f**5 + 141415887480*f**6 + 125347060664*f**7 + 76532911000*f**8 + 31880966040*f**9 + 8673797132*f**10 + 1390048660*f**11 + 99471372*f**12))/1.7068558844289106e26,
    117: lambda f: (f**2*(3820102 + 63745019*f + 615445074*f**2 + 4296656295*f**3 + 14379056550*f**4 + 26423884998*f**5 + 29498084784*f**6 + 20990594520*f**7 + 9610203960*f**8 + 2748396420*f**9 + 447766704*f**10 + 31783752*f**11))/2.154628467097274e27,
    118: lambda f: (f**2*(28965937 + 492520964*f + 4849396752*f**2 + 34551257655*f**3 + 129251727405*f**4 + 277332603933*f**5 + 373346929956*f**6 + 331663647672*f**7 + 198316378260*f**8 + 79259491080*f**9 + 20349534744*f**10 + 3040645608*f**11 + 201297096*f**12))/1.5082399269680917e28,
    119: lambda f: -(f**2*(151048898 + 2557764781*f + 25083874176*f**2 + 178063605585*f**3 + 640502786430*f**4 + 1325173582026*f**5 + 1748536616610*f**6 + 1555082171496*f**7 + 951465395160*f**8 + 396860185260*f**9 + 108053305668*f**10 + 17322144840*f**11 + 1239566328*f**12))/5.53021306554967e28,
}

Q120withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: -(f*(14 + 19*f + 12*f**2 + 3*f**3))/42.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/252.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: -(f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/11088.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/864864.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: -(f*(30030 + 143715*f + 414700*f**2 + 825175*f**3 + 1194500*f**4 + 1300454*f**5 + 1078112*f**6 + 670390*f**7 + 300510*f**8 + 91035*f**9 + 16632*f**10 + 1386*f**11))/3.459456e7,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 695829*f**5 + 716912*f**6 + 530740*f**7 + 269010*f**8 + 87885*f**9 + 16632*f**10 + 1386*f**11))/6.918912e7,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: -(f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 220761*f**5 + 258248*f**6 + 207835*f**7 + 110790*f**8 + 37215*f**9 + 7128*f**10 + 594*f**11))/1.1860992e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 3016468*f**5 + 3830624*f**6 + 3235960*f**7 + 1772820*f**8 + 604170*f**9 + 116424*f**10 + 9702*f**11))/1.162377216e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: -(f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1786692*f**5 + 2402176*f**6 + 2094260*f**7 + 1167180*f**8 + 401310*f**9 + 77616*f**10 + 6468*f**11))/6.199345152e10,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (f*(10010 + 90805*f + 514800*f**2 + 2120950*f**3 + 6761750*f**4 + 14783193*f**5 + 20724704*f**6 + 18471880*f**7 + 10416420*f**8 + 3602970*f**9 + 698544*f**10 + 58212*f**11))/5.5794106368e12,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: -(f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1262063*f**5 + 1826664*f**6 + 1654905*f**7 + 941220*f**8 + 326970*f**9 + 63504*f**10 + 5292*f**11))/6.0866297856e12,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1888914*f**5 + 2803472*f**6 + 2571940*f**7 + 1472310*f**8 + 513135*f**9 + 99792*f**10 + 8316*f**11))/1.339058552832e14,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: -(f*(546 + 6357*f + 46644*f**2 + 251641*f**3 + 1064180*f**4 + 2725326*f**5 + 4127648*f**6 + 3824590*f**7 + 2200590*f**8 + 768915*f**9 + 149688*f**10 + 12474*f**11))/3.2137405267968e15,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 460987*f**5 + 709936*f**6 + 663140*f**7 + 383130*f**8 + 134145*f**9 + 26136*f**10 + 2178*f**11))/1.01003273699328e16,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: -(f*(2310 + 30855*f + 260700*f**2 + 1627925*f**3 + 8013250*f**4 + 22000083*f**5 + 34357624*f**6 + 32307905*f**7 + 18729270*f**8 + 6568695*f**9 + 1280664*f**10 + 106722*f**11))/9.898320822534144e18,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: (f*(462 + 6567*f + 59136*f**2 + 394384*f**3 + 2078000*f**4 + 5867784*f**5 + 9273152*f**6 + 8769040*f**7 + 5097960*f**8 + 1790460*f**9 + 349272*f**10 + 29106*f**11))/5.938992493520486e19,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: -(f*(6006 + 90519*f + 865436*f**2 + 6139159*f**3 + 34474640*f**4 + 99787096*f**5 + 159315968*f**6 + 151378360*f**7 + 88217640*f**8 + 31019940*f**9 + 6054048*f**10 + 504504*f**11))/2.4706208773045223e22,
    52: lambda f: 0,
    53: lambda f: 0,
    54: lambda f: (f*(2002 + 31889*f + 322608*f**2 + 2425462*f**3 + 14460710*f**4 + 42785073*f**5 + 68917184*f**6 + 65754640*f**7 + 38398920*f**8 + 13516020*f**9 + 2638944*f**10 + 219912*f**11))/2.8000369942784587e23,
    55: lambda f: 0,
    56: lambda f: 0,
    57: lambda f: -(f*(2002 + 33605*f + 358644*f**2 + 2848651*f**3 + 17970770*f**4 + 54221931*f**5 + 88020968*f**6 + 84284725*f**7 + 49308840*f**8 + 17371620*f**9 + 3392928*f**10 + 282744*f**11))/1.0080133179402451e25,
    58: lambda f: 0,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: -(f*(14 + 19*f + 12*f**2 + 3*f**3))/63.,
    64: lambda f: (f*(56 + 73*f + 42*f**2 + 9*f**3))/126.,
    65: lambda f: 0,
    66: lambda f: (f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/252.,
    67: lambda f: -(f*(924 + 2013*f + 2332*f**2 + 1550*f**3 + 560*f**4 + 85*f**5))/2772.,
    68: lambda f: 0,
    69: lambda f: -(f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/8316.,
    70: lambda f: (f*(48048 + 146289*f + 253110*f**2 + 279487*f**3 + 201860*f**4 + 92775*f**5 + 24710*f**6 + 2905*f**7))/432432.,
    71: lambda f: 0,
    72: lambda f: (5*f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/2.594592e6,
    73: lambda f: -(f*(60060 + 234663*f + 538824*f**2 + 828932*f**3 + 893680*f**4 + 681498*f**5 + 361816*f**6 + 127652*f**7 + 26964*f**8 + 2583*f**9))/2.594592e6,
    74: lambda f: 0,
    75: lambda f: -(f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 257134*f**5 + 206752*f**6 + 122990*f**7 + 52710*f**8 + 15435*f**9 + 2772*f**10 + 231*f**11))/3.459456e6,
    76: lambda f: (f*(408408 + 1947231*f + 5566990*f**2 + 10964915*f**3 + 15691000*f**4 + 16673022*f**5 + 13213844*f**6 + 7732830*f**7 + 3252480*f**8 + 931875*f**9 + 163086*f**10 + 13167*f**11))/1.17621504e8,
    77: lambda f: 0,
    78: lambda f: (f*(102102 + 576147*f + 1983696*f**2 + 4794374*f**3 + 8614750*f**4 + 11829093*f**5 + 12571888*f**6 + 10367924*f**7 + 6591186*f**8 + 3175725*f**9 + 1123584*f**10 + 275814*f**11 + 42042*f**12 + 3003*f**13))/5.0409216e8,
    79: lambda f: -(f*(27159132 + 152839401*f + 522674724*f**2 + 1253913778*f**3 + 2234643200*f**4 + 3040883823*f**5 + 3199917224*f**6 + 2610171676*f**7 + 1639270332*f**8 + 779126775*f**9 + 271444404*f**10 + 65470482*f**11 + 9777768*f**12 + 681681*f**13))/6.704425728e10,
    80: lambda f: 0,
    81: lambda f: -(f*(58344 + 379236*f + 1516944*f**2 + 4313036*f**3 + 9252760*f**4 + 15334884*f**5 + 19683424*f**6 + 19380572*f**7 + 14395608*f**8 + 7878600*f**9 + 3067812*f**10 + 802197*f**11 + 126126*f**12 + 9009*f**13))/3.02455296e9,
    82: lambda f: (f*(31039008 + 201337851*f + 801194394*f**2 + 2265171545*f**3 + 4829541220*f**4 + 7949275803*f**5 + 10119278134*f**6 + 9860017601*f**7 + 7228939032*f**8 + 3894693705*f**9 + 1489227894*f**10 + 381565107*f**11 + 58666608*f**12 + 4090086*f**13))/8.0453108736e11,
    83: lambda f: 0,
    84: lambda f: (f*(102102 + 751179*f + 3422848*f**2 + 11189672*f**3 + 27898360*f**4 + 53625684*f**5 + 78436064*f**6 + 85781752*f**7 + 68963188*f**8 + 39937450*f**9 + 16152752*f**10 + 4321702*f**11 + 686686*f**12 + 49049*f**13))/6.586804224e10,
    85: lambda f: -(f*(11639628 + 85495839*f + 387987600*f**2 + 1262756872*f**3 + 3133203360*f**4 + 5988837316*f**5 + 8691860688*f**6 + 9403370872*f**7 + 7453921944*f**8 + 4243694490*f**9 + 1683206448*f**10 + 440781264*f**11 + 68444376*f**12 + 4771767*f**13))/3.75447840768e12,
    86: lambda f: 0,
    87: lambda f: -(f*(170170 + 1397825*f + 7147140*f**2 + 26406185*f**3 + 75014200*f**4 + 162424596*f**5 + 260965376*f**6 + 305492068*f**7 + 257443452*f**8 + 153877150*f**9 + 63511448*f**10 + 17195178*f**11 + 2746744*f**12 + 196196*f**13))/1.58083301376e12,
    88: lambda f: (f*(12932920 + 106096133*f + 540688434*f**2 + 1990506557*f**3 + 5632784080*f**4 + 12137651364*f**5 + 19352682104*f**6 + 22399575604*f**7 + 18597767328*f**8 + 10918961158*f**9 + 4416249068*f**10 + 1169579334*f**11 + 182518336*f**12 + 12724712*f**13))/6.007165452288e13,
    89: lambda f: 0,
    90: lambda f: (f*(34034 + 308737*f + 1750320*f**2 + 7211230*f**3 + 22989950*f**4 + 54869013*f**5 + 94556000*f**6 + 116034856*f**7 + 100867284*f**8 + 61515090*f**9 + 25712064*f**10 + 7011900*f**11 + 1123668*f**12 + 80262*f**13))/5.17363531776e12,
    91: lambda f: -(f*(14226212 + 128913499*f + 728862420*f**2 + 2994012970*f**3 + 9514934000*f**4 + 22611451239*f**5 + 38667873104*f**6 + 46897281592*f**7 + 40142229624*f**8 + 24033296070*f**9 + 9838953432*f**10 + 2623673052*f**11 + 410666256*f**12 + 28630602*f**13))/1.08128978141184e15,
    92: lambda f: 0,
    93: lambda f: -(f*(9282 + 92157*f + 573716*f**2 + 2607579*f**3 + 9218250*f**4 + 23854111*f**5 + 43387176*f**6 + 55108473*f**7 + 48966372*f**8 + 30280950*f**9 + 12766068*f**10 + 3498453*f**11 + 561834*f**12 + 40131*f**13))/2.58681765888e13,
    94: lambda f: (f*(1410864 + 13995267*f + 86927698*f**2 + 394113941*f**3 + 1389578300*f**4 + 3581753137*f**5 + 6464236506*f**6 + 8111891319*f**7 + 7094305008*f**8 + 4305120750*f**9 + 1777069476*f**10 + 476076258*f**11 + 74666592*f**12 + 5205564*f**13))/1.9659814207488e15,
    95: lambda f: 0,
    96: lambda f: (f*(120666 + 1301469*f + 8825856*f**2 + 43864964*f**3 + 170289340*f**4 + 471736842*f**5 + 895436752*f**6 + 1167505556*f**7 + 1054394334*f**8 + 658710675*f**9 + 279439776*f**10 + 76848156*f**11 + 12360348*f**12 + 882882*f**13))/6.8291986194432e15,
    97: lambda f: -(f*(4585308 + 49418031*f + 334475544*f**2 + 1658856940*f**3 + 6425451920*f**4 + 17735271726*f**5 + 33400680488*f**6 + 43013599132*f**7 + 38222361324*f**8 + 23425094385*f**9 + 9727402608*f**10 + 2614666824*f**11 + 410666256*f**12 + 28630602*f**13))/1.297547737694208e17,
    98: lambda f: 0,
    99: lambda f: -(f*(9282 + 108069*f + 792948*f**2 + 4277897*f**3 + 18091060*f**4 + 53116398*f**5 + 104365408*f**6 + 138897374*f**7 + 127023246*f**8 + 79973775*f**9 + 34087284*f**10 + 9399159*f**11 + 1513512*f**12 + 108108*f**13))/1.17071976333312e16,
    100: lambda f: (f*(54318264 + 632004087*f + 4629523470*f**2 + 24930592531*f**3 + 105227443880*f**4 + 307902689946*f**5 + 600183747548*f**6 + 788767991242*f**7 + 709570772064*f**8 + 438157777365*f**9 + 182773667538*f**10 + 49252073409*f**11 + 7743992256*f**12 + 539891352*f**13))/3.425526027512709e19,
    101: lambda f: 0,
    102: lambda f: (f*(5610 + 70125*f + 553520*f**2 + 3221330*f**3 + 14739850*f**4 + 45502999*f**5 + 91986544*f**6 + 124459892*f**7 + 114958338*f**8 + 72821925*f**9 + 31154112*f**10 + 8608182*f**11 + 1387386*f**12 + 99099*f**13))/1.717055652888576e17,
    103: lambda f: -(f*(1492260 + 18642591*f + 146937868*f**2 + 853785254*f**3 + 3900134560*f**4 + 12001263645*f**5 + 24066787304*f**6 + 32149152252*f**7 + 29204462364*f**8 + 18140966151*f**9 + 7594266372*f**10 + 2050449786*f**11 + 322666344*f**12 + 22495473*f**13))/2.283684018341806e19,
    104: lambda f: 0,
    105: lambda f: -(f*(62832 + 839256*f + 7091040*f**2 + 44279560*f**3 + 217960400*f**4 + 702904440*f**5 + 1455216896*f**6 + 1995798616*f**7 + 1858402224*f**8 + 1183064820*f**9 + 507640980*f**10 + 140499513*f**11 + 22660638*f**12 + 1618617*f**13))/5.0481436194924134e19,
    106: lambda f: (f*(4775232 + 63751479*f + 537959730*f**2 + 3354592405*f**3 + 16488342500*f**4 + 53010806835*f**5 + 108860640182*f**6 + 147379977409*f**7 + 134945227368*f**8 + 84226758315*f**9 + 35360378130*f**10 + 9562344561*f**11 + 1505776272*f**12 + 104978874*f**13))/1.918294575407117e21,
    107: lambda f: 0,
    108: lambda f: (f*(133518 + 1897863*f + 17090304*f**2 + 113976976*f**3 + 600542000*f**4 + 2012462856*f**5 + 4251509696*f**6 + 5897198608*f**7 + 5528125512*f**8 + 3533600700*f**9 + 1519954128*f**10 + 421251138*f**11 + 67981914*f**12 + 4855851*f**13))/3.028886171695448e21,
    109: lambda f: -(f*(65957892 + 937128621*f + 8429307744*f**2 + 56146810928*f**3 + 295453009600*f**4 + 987190432344*f**5 + 2068537240672*f**6 + 2831962774928*f**7 + 2610088777296*f**8 + 1635550944300*f**9 + 688258482912*f**10 + 186363273096*f**11 + 29362637304*f**12 + 2047088043*f**13))/7.481348844087757e23,
    110: lambda f: 0,
    111: lambda f: -(f*(102102 + 1538823*f + 14712412*f**2 + 104365703*f**3 + 586068880*f**4 + 2031819736*f**5 + 4367629056*f**6 + 6116619768*f**7 + 5766234152*f**8 + 3698426900*f**9 + 1594120528*f**10 + 442309868*f**11 + 71415344*f**12 + 5101096*f**13))/7.000092485696147e22,
    112: lambda f: (f*(23279256 + 350713077*f + 3349718658*f**2 + 23735918245*f**3 + 133136103840*f**4 + 460270211848*f**5 + 981287199984*f**6 + 1356235023976*f**7 + 1256898724032*f**8 + 790220658780*f**9 + 333188399544*f**10 + 90316558332*f**11 + 14236430208*f**12 + 992527536*f**13))/7.980105433693607e24,
    113: lambda f: 0,
    114: lambda f: (f*(38038 + 605891*f + 6129552*f**2 + 46083778*f**3 + 274753490*f**4 + 981808803*f**5 + 2142573888*f**6 + 3025330224*f**7 + 2865778776*f**8 + 1843447900*f**9 + 795960704*f**10 + 221063304*f**11 + 35707672*f**12 + 2550548*f**13))/8.400110982835376e23,
    115: lambda f: -(f*(1445444 + 23015707*f + 232629540*f**2 + 1747257746*f**3 + 10406465680*f**4 + 37086392619*f**5 + 80264742432*f**6 + 111838965168*f**7 + 104136718896*f**8 + 65656280060*f**9 + 27729549232*f**10 + 7523461176*f**11 + 1186369184*f**12 + 82710628*f**13))/1.5960210867387214e25,
    116: lambda f: 0,
    117: lambda f: -(f*(10010 + 168025*f + 1793220*f**2 + 14243255*f**3 + 89853850*f**4 + 329920407*f**5 + 729545992*f**6 + 1037495081*f**7 + 986867784*f**8 + 636407100*f**9 + 275198616*f**10 + 76494726*f**11 + 12360348*f**12 + 882882*f**13))/7.560099884551838e24,
    118: lambda f: (f*(1521520 + 25531649*f + 272259702*f**2 + 2160596191*f**3 + 13617475940*f**4 + 49870018143*f**5 + 109361796950*f**6 + 153459623569*f**7 + 143473000608*f**8 + 90676889604*f**9 + 38351856312*f**10 + 10413636156*f**11 + 1642665024*f**12 + 114522408*f**13))/5.745675912259397e26,
    119: lambda f: 0,
}

Q122withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (-21 - 44*f - 58*f**2 - 36*f**3 - 9*f**4)/168.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (231 + 726*f + 1551*f**2 + 1868*f**3 + 1317*f**4 + 510*f**5 + 85*f**6)/5544.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (-9009 - 37752*f - 111540*f**2 - 198744*f**3 - 228766*f**4 - 172520*f**5 - 82980*f**6 - 23240*f**7 - 2905*f**8)/1.153152e6,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (9009 + 47190*f + 178035*f**2 + 419640*f**3 + 668810*f**4 + 746356*f**5 + 588390*f**6 + 322840*f**7 + 117845*f**8 + 25830*f**9 + 2583*f**10)/8.64864e6,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (-255255 - 1604460*f - 7365930*f**2 - 21591700*f**3 - 43936925*f**4 - 64830520*f**5 - 71694428*f**6 - 60174184*f**7 - 37759505*f**8 - 17031420*f**9 - 5179230*f**10 - 948024*f**11 - 79002*f**12)/2.35243008e9,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (21879 + 160446*f + 867867*f**2 + 3041844*f**3 + 7529011*f**4 + 13807706*f**5 + 19274679*f**6 + 20098232*f**7 + 14996485*f**8 + 7637490*f**9 + 2501793*f**10 + 474012*f**11 + 39501*f**12)/2.35243008e9,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (-153153 - 1283568*f - 7993128*f**2 - 32598384*f**3 - 95019596*f**4 - 208246192*f**5 - 343517496*f**6 - 406397488*f**7 - 329343350*f**8 - 176274000*f**9 - 59340456*f**10 - 11376288*f**11 - 948024*f**12)/2.2583328768e11,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (17017 + 160446*f + 1130415*f**2 + 5258032*f**3 + 17636548*f**4 + 44952488*f**5 + 83996108*f**6 + 107800784*f**7 + 91643230*f**8 + 50388660*f**9 + 17205174*f**10 + 3318084*f**11 + 276507*f**12)/3.9520825344e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (-51051 - 534820*f - 4205630*f**2 - 21971820*f**3 - 83346155*f**4 - 242180368*f**5 - 498279240*f**6 - 676666480*f**7 - 593409110*f**8 - 331826040*f**9 - 114291324*f**10 - 22120560*f**11 - 1843380*f**12)/2.10777735168e13,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (23205 + 267410*f + 2321605*f**2 + 13458900*f**3 + 56961475*f**4 + 185829890*f**5 + 412751163*f**6 + 584191664*f**7 + 523590130*f**8 + 296184420*f**9 + 102616290*f**10 + 19908504*f**11 + 1659042*f**12)/1.896999616512e14,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (-4641 - 58344*f - 554268*f**2 - 3530696*f**3 - 16492074*f**4 - 59682648*f**5 - 141073852*f**6 - 206066616*f**7 - 187684455*f**8 - 107064720*f**9 - 37251144*f**10 - 7239456*f**11 - 603288*f**12)/8.277816508416e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (1071 + 14586*f + 150501*f**2 + 1044888*f**3 + 5339122*f**4 + 21224228*f**5 + 52823214*f**6 + 79096472*f**7 + 72936325*f**8 + 41872950*f**9 + 14615559*f**10 + 2844072*f**11 + 237006*f**12)/4.5527990796288e15,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (-21879 - 320892*f - 3573570*f**2 - 26856804*f**3 - 149011681*f**4 - 645441992*f**5 - 1677660132*f**6 - 2562850136*f**7 - 2386491415*f**8 - 1376977140*f**9 - 481830426*f**10 - 93854376*f**11 - 7821198*f**12)/2.4038779140440064e18,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (3927 + 61710*f + 737715*f**2 + 5966660*f**3 + 35722015*f**4 + 167452754*f**5 + 451676155*f**6 + 701450120*f**7 + 658387555*f**8 + 381420270*f**9 + 133734447*f**10 + 26070660*f**11 + 2172555*f**12)/1.2019389570220032e19,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (-58905 - 987360*f - 12611280*f**2 - 109221600*f**3 - 701797400*f**4 - 3539707360*f**5 - 9858019248*f**6 - 15521918944*f**7 - 14665044380*f**8 - 8524141920*f**9 - 2993684400*f**10 - 583982784*f**11 - 48665232*f**12)/5.384686527458574e21,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: (9009 + 160446*f + 2180607*f**2 + 20133984*f**3 + 138197896*f**4 + 746245328*f**5 + 2137037592*f**6 + 3404483936*f**7 + 3234363580*f**8 + 1885239720*f**9 + 663009984*f**10 + 129405276*f**11 + 10783773*f**12)/2.625034682136055e22,
    50: lambda f: 0,
    51: lambda f: 0,
    52: lambda f: (-17017 - 320892*f - 4623762*f**2 - 45339476*f**3 - 331084469*f**4 - 1905670624*f**5 - 5592783472*f**6 - 8999880736*f**7 - 8590536500*f**8 - 5019109200*f**9 - 1767206952*f**10 - 345080736*f**11 - 28756728*f**12)/1.6800221965670752e24,
    53: lambda f: 0,
    54: lambda f: 0,
    55: lambda f: (3003 + 59774*f + 910195*f**2 + 9446268*f**3 + 73121177*f**4 + 446903446*f**5 + 1340395641*f**6 + 2175892768*f**7 + 2085384140*f**8 + 1220892120*f**9 + 430302348*f**10 + 84058128*f**11 + 7004844*f**12)/1.0640140578258143e25,
    56: lambda f: 0,
    57: lambda f: 0,
    58: lambda f: (-3003 - 62920*f - 1009580*f**2 - 11055720*f**3 - 90426130*f**4 - 584854808*f**5 - 1788508380*f**6 - 2925654200*f**7 - 2813906935*f**8 - 1650327840*f**9 - 582163344*f**10 - 113762880*f**11 - 9480240*f**12)/4.0320532717609805e26,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (-35 + 2*f + 91*f**2 + 100*f**3 + 32*f**4)/1680.,
    64: lambda f: (-245 - 462*f - 545*f**2 - 300*f**3 - 66*f**4)/1176.,
    65: lambda f: (8085 + 16786*f + 19283*f**2 + 10820*f**3 + 2176*f**4)/129360.,
    66: lambda f: (1155 + 1144*f - 2794*f**2 - 8380*f**3 - 8897*f**4 - 4460*f**5 - 880*f**6)/110880.,
    67: lambda f: (8085 + 23716*f + 47168*f**2 + 52700*f**3 + 34341*f**4 + 12240*f**5 + 1870*f**6)/77616.,
    68: lambda f: (-105105 - 328328*f - 654082*f**2 - 759980*f**3 - 511461*f**4 - 185980*f**5 - 27840*f**6)/3.36336e6,
    69: lambda f: (-45045 - 91806*f + 23595*f**2 + 461760*f**3 + 952577*f**4 + 1006450*f**5 + 611385*f**6 + 203980*f**7 + 29120*f**8)/1.729728e7,
    70: lambda f: (-315315 - 1255254*f - 3518229*f**2 - 5935800*f**3 - 6456811*f**4 - 4591670*f**5 - 2077815*f**6 - 546140*f**7 - 63910*f**8)/1.2108096e7,
    71: lambda f: (105105 + 438438*f + 1237665*f**2 + 2167360*f**3 + 2454579*f**4 + 1816470*f**5 + 850475*f**6 + 228900*f**7 + 26880*f**8)/1.345344e7,
    72: lambda f: (15015 + 46332*f + 46332*f**2 - 133640*f**3 - 553582*f**4 - 966800*f**5 - 1020100*f**6 - 693560*f**7 - 299425*f**8 - 75180*f**9 - 8400*f**10)/3.459456e7,
    73: lambda f: (105105 + 528528*f + 1912482*f**2 + 4318600*f**3 + 6586006*f**4 + 7023496*f**5 + 5283944*f**6 + 2762648*f**7 + 959441*f**8 + 199752*f**9 + 18942*f**10)/2.4216192e7,
    74: lambda f: (-5360355 - 27975948*f - 102072828*f**2 - 238282200*f**3 - 377653402*f**4 - 419341040*f**5 - 328187340*f**6 - 178025960*f**7 - 63851515*f**8 - 13631940*f**9 - 1310400*f**10)/4.11675264e9,
    75: lambda f: (-765765 - 3165162*f - 6439719*f**2 + 198900*f**3 + 34711790*f**4 + 97981540*f**5 + 155370642*f**6 + 163957024*f**7 + 120056615*f**8 + 60772950*f**9 + 20411685*f**10 + 4110876*f**11 + 376992*f**12)/1.411458048e10,
    76: lambda f: (-5360355 - 32570538*f - 144452451*f**2 - 408739500*f**3 - 802234420*f**4 - 1140739100*f**5 - 1200311862*f**6 - 939355424*f**7 - 541754395*f**8 - 224309610*f**9 - 63248535*f**10 - 10902276*f**11 - 869022*f**12)/9.880206336e9,
    77: lambda f: (101846745 + 638239602*f + 2854064499*f**2 + 8317799100*f**3 + 16911204410*f**4 + 24972376780*f**5 + 27300376518*f**6 + 22182995296*f**7 + 13262794685*f**8 + 5679068850*f**9 + 1650374775*f**10 + 291772404*f**11 + 23683968*f**12)/6.2574640128e11,
    78: lambda f: (14549535 + 75380448*f + 224755674*f**2 + 270835500*f**3 - 463159067*f**4 - 2776385260*f**5 - 6428200308*f**6 - 9561820744*f**7 - 10093994855*f**8 - 7790921208*f**9 - 4399379670*f**10 - 1778322084*f**11 - 489097917*f**12 - 82222140*f**13 - 6390384*f**14)/2.6817702912e12,
    79: lambda f: (101846745 + 725536812*f + 3810592500*f**2 + 12961053300*f**3 + 31113839671*f**4 + 55307122040*f**5 + 74783927838*f**6 + 77946126440*f**7 + 62820985255*f**8 + 38912019804*f**9 + 18218238360*f**10 + 6248042724*f**11 + 1483245225*f**12 + 218137920*f**13 + 14996982*f**14)/1.87723920384e12,
    80: lambda f: (-33948915 - 248312064*f - 1314446562*f**2 - 4590430780*f**3 - 11378709569*f**4 - 20940677860*f**5 - 29342526956*f**6 - 31695037528*f**7 - 26459474405*f**8 - 16959418056*f**9 - 8204683410*f**10 - 2901948588*f**11 - 708663879*f**12 - 106846740*f**13 - 7495488*f**14)/2.0858213376e12,
    81: lambda f: (-4849845 - 30207606*f - 117366249*f**2 - 245725480*f**3 - 113857177*f**4 + 977000710*f**5 + 3720819571*f**6 + 7698694108*f**7 + 10669867985*f**8 + 10294074966*f**9 + 6913913265*f**10 + 3166110948*f**11 + 942381594*f**12 + 164444280*f**13 + 12780768*f**14)/1.07270811648e13,
    82: lambda f: (-33948915 - 277411134*f - 1683727617*f**2 - 6689846800*f**3 - 18989300169*f**4 - 40508641250*f**5 - 66363948581*f**6 - 83618177580*f**7 - 80270077195*f**8 - 57805024578*f**9 - 30550231215*f**10 - 11460369228*f**11 - 2883933360*f**12 - 436275840*f**13 - 29993964*f**14)/7.50895681536e12,
    83: lambda f: (101846745 + 851632782*f + 5207209293*f**2 + 21187650120*f**3 + 61925916269*f**4 + 136375041250*f**5 + 231171234273*f**6 + 302088549364*f**7 + 301201493915*f**8 + 225263629458*f**9 + 123426631755*f**10 + 47858488524*f**11 + 12400690302*f**12 + 1923241320*f**13 + 134918784*f**14)/7.50895681536e13,
    84: lambda f: (14549535 + 105865188*f + 504383880*f**2 + 1438073520*f**3 + 2118630644*f**4 - 1015098560*f**5 - 15939216888*f**6 - 47767270544*f**7 - 81973506790*f**8 - 90430510968*f**9 - 66094090020*f**10 - 31877298684*f**11 - 9769656897*f**12 - 1726664940*f**13 - 134198064*f**14)/4.505374089216e14,
    85: lambda f: (101846745 + 938929992*f + 6466367622*f**2 + 29391320400*f**3 + 96301996508*f**4 + 239687524720*f**5 + 456111787488*f**6 + 653793691600*f**7 + 694591663430*f**8 + 539144401824*f**9 + 300389707800*f**10 + 116708870124*f**11 + 29992350465*f**12 + 4580896320*f**13 + 314936622*f**14)/3.1537618624512e14,
    86: lambda f: (-101846745 - 958329372*f - 6645673320*f**2 - 30866681040*f**3 - 103881752236*f**4 - 266235824960*f**5 - 524005515768*f**6 - 780507939344*f**7 - 863747107510*f**8 - 698104238328*f**9 - 403983068580*f**10 - 162398692764*f**11 - 42987946617*f**12 - 6731344620*f**13 - 472215744*f**14)/1.0512539541504e15,
    87: lambda f: (-4849845 - 40369186*f - 227203691*f**2 - 805452180*f**3 - 1769015444*f**4 - 1658527480*f**5 + 6071725956*f**6 + 29545841248*f**7 + 60364064810*f**8 + 72761640756*f**9 + 55885847990*f**10 + 27727880488*f**11 + 8628428424*f**12 + 1534813280*f**13 + 119287168*f**14)/2.4028661809152e15,
    88: lambda f: (-33948915 - 348542194*f - 2685382271*f**2 - 13742067300*f**3 - 51046314698*f**4 - 145206528568*f**5 - 311310810348*f**6 - 489012007904*f**7 - 554324585458*f**8 - 449704606764*f**9 - 258008968546*f**10 - 102130103768*f**11 - 26531444940*f**12 - 4071907840*f**13 - 279943664*f**14)/1.68200632664064e15,
    89: lambda f: (11316305 + 118336218*f + 917636863*f**2 + 4789799300*f**3 + 18236697572*f**4 + 53298785560*f**5 + 118233310732*f**6 + 193416652576*f**7 + 228926645150*f**8 + 193733786652*f**9 + 115574855970*f**10 + 47361684216*f**11 + 12675766488*f**12 + 1994472480*f**13 + 139915776*f**14)/1.8688959184896e15,
    90: lambda f: (1616615 + 15149992*f + 98197814*f**2 + 412761700*f**3 + 1157879095*f**4 + 1985849220*f**5 - 1528084424*f**6 - 16869940080*f**7 - 39903225810*f**8 - 51209757312*f**9 - 40632978540*f**10 - 20522537112*f**11 - 6446251350*f**12 - 1151109960*f**13 - 89465376*f**14)/1.44171970854912e16,
    91: lambda f: (11316305 + 128035908*f + 1091168936*f**2 + 6208221500*f**3 + 25780779565*f**4 + 82506086400*f**5 + 194856797974*f**6 + 327513226544*f**7 + 388187526930*f**8 + 324168423096*f**9 + 189472010280*f**10 + 75872576472*f**11 + 19840793742*f**12 + 3053930880*f**13 + 209957748*f**14)/1.009203795984384e16,
    92: lambda f: (-33948915 - 390574184*f - 3348794878*f**2 - 19403998900*f**3 - 82441197315*f**4 - 270544716020*f**5 - 661697905032*f**6 - 1160696642000*f**7 - 1439183114950*f**8 - 1255325029056*f**9 - 763498475460*f**10 - 316627758216*f**11 - 85312742130*f**12 - 13462689240*f**13 - 944431488*f**14)/1.009203795984384e17,
    93: lambda f: (-440895 - 4593706*f - 33663383*f**2 - 162921200*f**3 - 546951081*f**4 - 1256621810*f**5 - 113530073*f**6 + 7411328036*f**7 + 19878795370*f**8 + 26727901452*f**9 + 21699449730*f**10 + 11094702696*f**11 + 3507020748*f**12 + 627878160*f**13 + 48799296*f**14)/7.8639256829952e16,
    94: lambda f: (-3086265 - 38152114*f - 356348135*f**2 - 2231348600*f**3 - 10243634597*f**4 - 36426218410*f**5 - 93182919097*f**6 - 164941173460*f**7 - 201934317620*f**8 - 172098779076*f**9 - 101885649390*f**10 - 41121404856*f**11 - 10801236600*f**12 - 1665780480*f**13 - 114522408*f**14)/5.50474797809664e16,
    95: lambda f: (3086265 + 38739974*f + 363897937*f**2 + 2317512080*f**3 + 10867855999*f**4 + 39561198270*f**5 + 104923401567*f**6 + 194195444996*f**7 + 249094741210*f**8 + 221954851692*f**9 + 136807964370*f**10 + 57197336616*f**11 + 15481264428*f**12 + 2447761680*f**13 + 171714816*f**14)/1.83491599269888e17,
    96: lambda f: (1322685 + 15166788*f + 123904092*f**2 + 676710840*f**3 + 2623335586*f**4 + 7331815760*f**5 + 3909863244*f**6 - 34114284568*f**7 - 102115537685*f**8 - 142322769036*f**9 - 117529957440*f**10 - 60630331608*f**11 - 19252799874*f**12 - 3453329880*f**13 - 268396128*f**14)/5.190190950776832e18,
    97: lambda f: (9258795 + 124156032*f + 1261186446*f**2 + 8618867400*f**3 + 43343355142*f**4 + 169545167720*f**5 + 463753564536*f**6 + 855005721080*f**7 + 1072756303045*f**8 + 928137267288*f**9 + 554637782790*f**10 + 225132010488*f**11 + 59324244210*f**12 + 9161792640*f**13 + 629873244*f**14)/3.6331336655437824e18,
    98: lambda f: (-33948915 - 461705244*f - 4715157876*f**2 - 32735236040*f**3 - 167926752318*f**4 - 671425758960*f**5 - 1906446934612*f**6 - 3681391258776*f**7 - 4845312880485*f**8 - 4386218624172*f**9 - 2730073111920*f**10 - 1148130461016*f**11 - 311771293218*f**12 - 49363193880*f**13 - 3462915456*f**14)/4.44049670233129e19,
    99: lambda f: (-4849845 - 60692346*f - 546646815*f**2 - 3319981340*f**3 - 14527372678*f**4 - 47177192660*f**5 - 38517739018*f**6 + 184489767616*f**7 + 608550315065*f**8 + 872724953562*f**9 + 730215117555*f**10 + 379263856356*f**11 + 120848760648*f**12 + 21706644960*f**13 + 1687061376*f**14)/4.567368036683612e20,
    100: lambda f: (-33948915 - 490804314*f - 5387069259*f**2 - 39897638300*f**3 - 218120850896*f**4 - 930801315860*f**5 - 2695002118402*f**6 - 5134414922560*f**7 - 6566772343285*f**8 - 5747741396166*f**9 - 3459314345025*f**10 - 1410232832316*f**11 - 372506051610*f**12 - 57588410880*f**13 - 3959203248*f**14)/3.1971576256785285e20,
    101: lambda f: (101846745 + 1491812322*f + 16456909755*f**2 + 123695233740*f**3 + 688975086046*f**4 + 3001257336740*f**5 + 9032200260786*f**6 + 18049806893888*f**7 + 24240905902675*f**8 + 22213085993406*f**9 + 13929148402785*f**10 + 5884038465228*f**11 + 1601720427384*f**12 + 253867854240*f**13 + 17809279488*f**14)/3.1971576256785285e21,
    102: lambda f: (1119195 + 15178416*f + 149375226*f**2 + 997507980*f**3 + 4849232269*f**4 + 17814554660*f**5 + 18158558628*f**6 - 60773179096*f**7 - 218653159445*f**8 - 320936078232*f**9 - 271343463930*f**10 - 141686962956*f**11 - 45269040663*f**12 - 8139991860*f**13 - 632648016*f**14)/2.7404208220101673e21,
    103: lambda f: (7834365 + 121469964*f + 1432612236*f**2 + 11430033300*f**3 + 67495921423*f**4 + 312037191368*f**5 + 948710896854*f**6 + 1856833536824*f**7 + 2411668965013*f**8 + 2130360893892*f**9 + 1289384845056*f**10 + 527413202316*f**11 + 139576253355*f**12 + 21595654080*f**13 + 1484701218*f**14)/1.918294575407117e21,
    104: lambda f: (-7834365 - 122962224*f - 1457149254*f**2 - 11788175700*f**3 - 70844435291*f**4 - 333935546140*f**5 - 1056670929132*f**6 - 2172143909656*f**7 - 2964918196205*f**8 - 2743290301752*f**9 - 1730344970970*f**10 - 733498872876*f**11 - 200052226143*f**12 - 31733481780*f**13 - 2226159936*f**14)/6.394315251357057e21,
    105: lambda f: (-1119195 - 16350906*f - 174519807*f**2 - 1269971400*f**3 - 6778447315*f**4 - 27676426190*f**5 - 32518497207*f**6 + 84395607268*f**7 + 328406064665*f**8 + 491394702582*f**9 + 418999708785*f**10 + 219733696644*f**11 + 70357225554*f**12 + 12662209560*f**13 + 984119136*f**14)/7.673178301628468e22,
    106: lambda f: (-7834365 - 129677394*f - 1635484983*f**2 - 13984608000*f**3 - 88708133755*f**4 - 441654582950*f**5 - 1400994502383*f**6 - 2804492333972*f**7 - 3688728920695*f**8 - 3282851621826*f**9 - 1995942292575*f**10 - 818648311404*f**11 - 216977351976*f**12 - 33593239680*f**13 - 2309535228*f**14)/5.371224811139928e22,
    107: lambda f: (33948915 + 568401834*f + 7201188423*f**2 + 62386222600*f**3 + 402355785035*f**4 + 2040326920030*f**5 + 6744507785183*f**6 + 14196213827068*f**7 + 19637287652255*f**8 + 18312688647162*f**9 + 11605641633495*f**10 + 4933508543964*f**11 + 1347622129854*f**12 + 213907173480*f**13 + 15005966976*f**14)/7.758435838313229e23,
    108: lambda f: (4849845 + 75934716*f + 873526368*f**2 + 6876282400*f**3 + 39928663096*f**4 + 178914506240*f**5 + 232564156592*f**6 - 496076678944*f**7 - 2073044862980*f**8 - 3152576180208*f**9 - 2707086711420*f**10 - 1424715175884*f**11 - 456996056517*f**12 - 82304362140*f**13 - 6396774384*f**14)/9.975131792117008e24,
    109: lambda f: (33948915 + 597500904*f + 8024414970*f**2 + 73207045600*f**3 + 496446614952*f**4 + 2648255966240*f**5 + 8718747351488*f**6 + 17789182350240*f**7 + 23645421792580*f**8 + 21173976436704*f**9 + 12921730354260*f**10 + 5311789006524*f**11 + 1409601518325*f**12 + 218356057920*f**13 + 15011978982*f**14)/6.982592254481907e24,
    110: lambda f: (-101846745 - 1811902092*f - 24438784656*f**2 - 225732193440*f**3 - 1555049011352*f**4 - 8440923754240*f**5 - 28993941905904*f**6 - 62265925920352*f**7 - 87094377327020*f**8 - 81749754135504*f**9 - 52011439601940*f**10 - 22160961514692*f**11 - 6061066722711*f**12 - 962582280660*f**13 - 67526851392*f**14)/6.982592254481906e25,
    111: lambda f: (-14549535 - 243046518*f - 2997342777*f**2 - 25368090540*f**3 - 159078091736*f**4 - 774799867600*f**5 - 1087279332456*f**6 + 1978192782272*f**7 + 8824307441740*f**8 + 13606443678744*f**9 + 11753133274260*f**10 + 6204015850032*f**11 + 1992979484496*f**12 + 359146307520*f**13 + 27913197312*f**14)/9.576126520432329e26,
    112: lambda f: (-101846745 - 1899199302*f - 27059779461*f**2 - 262353939900*f**3 - 1894075764242*f**4 - 10777490121040*f**5 - 36665961145224*f**6 - 76044644105920*f**7 - 101982711705980*f**8 - 91798779120552*f**9 - 56197180747260*f**10 - 23144442873552*f**11 - 6148256554440*f**12 - 952826434560*f**13 - 65506817376*f**14)/6.70328856430263e26,
    113: lambda f: (101846745 + 1918598682*f + 27448598463*f**2 + 269266669620*f**3 + 1973252920264*f**4 + 11415357187760*f**5 + 40565811336024*f**6 + 88632839379392*f**7 + 125148967472620*f**8 + 118114149374424*f**9 + 75393883705140*f**10 + 32185850769072*f**11 + 8812178431056*f**12 + 1400119680960*f**13 + 98220874752*f**14)/2.23442952143421e27,
    114: lambda f: (285285 + 5064488*f + 66648010*f**2 + 603337020*f**3 + 4060994849*f**4 + 21337619020*f**5 + 31813531296*f**6 - 50653976352*f**7 - 239954339100*f**8 - 374437648704*f**9 - 325076255560*f**10 - 172030025552*f**11 - 55332685716*f**12 - 9976286320*f**13 - 775366592*f**14)/6.384084346954885e26,
    115: lambda f: (1996995 + 39331292*f + 592566832*f**2 + 6084276900*f**3 + 46591478843*f**4 + 281682124240*f**5 + 986682955074*f**6 + 2075579052960*f**7 + 2804861639580*f**8 + 2535972894672*f**9 + 1556604165200*f**10 + 642095633872*f**11 + 170720693220*f**12 + 26467400960*f**13 + 1819633816*f**14)/4.4688590428684204e26,
    116: lambda f: (-665665 - 13237224*f - 200215730*f**2 - 2078835980*f**3 - 16147286477*f**4 - 99174753340*f**5 - 363262981168*f**6 - 805670472544*f**7 - 1146835637780*f**8 - 1087438916928*f**9 - 696062797080*f**10 - 297638913264*f**11 - 81563543292*f**12 - 12964071120*f**13 - 909452544*f**14)/4.965398936520467e26,
    117: lambda f: (-95095 - 1787786*f - 25004551*f**2 - 241032480*f**3 - 1732507229*f**4 - 9760028490*f**5 - 15289590757*f**6 + 21709287684*f**7 + 108720397380*f**8 + 171429466488*f**9 + 149481956820*f**10 + 79278309264*f**11 + 25527142872*f**12 + 4604439840*f**13 + 357861504*f**14)/7.660901216345863e27,
    118: lambda f: (-665665 - 13807794*f - 219324391*f**2 - 2377473800*f**3 - 19247622193*f**4 - 123213003138*f**5 - 443012573845*f**6 - 943544023604*f**7 - 1283529518838*f**8 - 1164924604200*f**9 - 716681780556*f**10 - 296033149104*f**11 - 78768763920*f**12 - 12215723520*f**13 - 839830992*f**14)/5.362630851442104e27,
    119: lambda f: (1996995 + 41803762*f + 666509987*f**2 + 7302308000*f**3 + 59926979393*f**4 + 389442052850*f**5 + 1465732679769*f**6 + 3293710144172*f**7 + 4721429783980*f**8 + 4494986985384*f**9 + 2884119019740*f**10 + 1234999613232*f**11 + 338693099976*f**12 + 53850756960*f**13 + 3777725952*f**14)/5.362630851442104e28,
}

Q124withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: -(f*(66 + 101*f + 68*f**2 + 17*f**3))/693.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/18018.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: -(f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/24024.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/7.351344e6,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: -(f*(1385670 + 7831135*f + 25872300*f**2 + 57017575*f**3 + 89062500*f**4 + 102804406*f**5 + 89119968*f**6 + 57235710*f**7 + 26220390*f**8 + 8049615*f**9 + 1480248*f**10 + 123354*f**11))/5.58702144e9,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (f*(92378 + 617253*f + 2444464*f**2 + 6570466*f**3 + 12789850*f**4 + 18666127*f**5 + 20077456*f**6 + 15281420*f**7 + 7875630*f**8 + 2596755*f**9 + 493416*f**10 + 41118*f**11))/3.72468096e9,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: -(f*(277134 + 2137291*f + 9867004*f**2 + 31294501*f**3 + 72933210*f**4 + 125774103*f**5 + 153166104*f**6 + 126310905*f**7 + 68287170*f**8 + 23111445*f**9 + 4440744*f**10 + 370062*f**11))/1.3408851456e11,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (f*(277134 + 2422823*f + 12775296*f**2 + 46695464*f**3 + 126738360*f**4 + 247391732*f**5 + 326217696*f**6 + 281751960*f**7 + 156310980*f**8 + 53624130*f**9 + 10361736*f**10 + 863478*f**11))/1.87723920384e12,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: -(f*(92378 + 902785*f + 5352756*f**2 + 22152309*f**3 + 68616600*f**4 + 147336228*f**5 + 205263744*f**6 + 182676900*f**7 + 102997020*f**8 + 35628390*f**9 + 6907824*f**10 + 575652*f**11))/1.001194242048e13,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (f*(1385670 + 14969435*f + 98579600*f**2 + 455607650*f**3 + 1585811250*f**4 + 3672180531*f**5 + 5325511968*f**6 + 4839843960*f**7 + 2759134140*f**8 + 959787990*f**9 + 186511248*f**10 + 15542604*f**11))/2.7032244535296e15,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: -(f*(25194 + 298129*f + 2158932*f**2 + 11021083*f**3 + 42581850*f**4 + 104830807*f**5 + 156743496*f**6 + 144667845*f**7 + 83138580*f**8 + 29037330*f**9 + 5651856*f**10 + 470988*f**11))/9.829907103744e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (f*(92378 + 1188317*f + 9385088*f**2 + 52443572*f**3 + 222706220*f**4 + 576745202*f**5 + 883286096*f**6 + 824967220*f**7 + 476998830*f**8 + 167106555*f**9 + 32565456*f**10 + 2713788*f**11))/7.92945839702016e16,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: -(f*(277134 + 3850483*f + 32936956*f**2 + 199960579*f**3 + 925701660*f**4 + 2501498634*f**5 + 3905792352*f**6 + 3682331730*f**7 + 2139362610*f**8 + 751266285*f**9 + 146544552*f**10 + 12212046*f**11))/5.709210045854515e18,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (f*(21318 + 318155*f + 2930256*f**2 + 19204934*f**3 + 96258750*f**4 + 269719541*f**5 + 427880208*f**6 + 406483980*f**7 + 237072990*f**8 + 83410635*f**9 + 16282728*f**10 + 1356894*f**11))/1.141842009170903e19,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: -(f*(461890 + 7369245*f + 72707300*f**2 + 511640075*f**3 + 2760248750*f**4 + 7979802677*f**5 + 12828471656*f**6 + 12263992195*f**7 + 7175480130*f**8 + 2528549205*f**9 + 493909416*f**10 + 41159118*f**11))/6.927174855636812e21,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: (f*(277134 + 4707079*f + 49530112*f**2 + 372462928*f**3 + 2151932400*f**4 + 6392814888*f**5 + 10393798464*f**6 + 9989214480*f**7 + 5860119720*f**8 + 2067740220*f**9 + 404107704*f**10 + 33675642*f**11))/1.2468914740146261e23,
    51: lambda f: 0,
    52: lambda f: 0,
    53: lambda f: -(f*(277134 + 4992611*f + 55810524*f**2 + 446643431*f**3 + 2751417360*f**4 + 8371541144*f**5 + 13743485952*f**6 + 13268279640*f**7 + 7801389960*f**8 + 2755776660*f**9 + 538810272*f**10 + 44900856*f**11))/3.9900527168468036e24,
    54: lambda f: 0,
    55: lambda f: 0,
    56: lambda f: (f*(5434 + 103493*f + 1224816*f**2 + 10393494*f**3 + 68002710*f**4 + 211335321*f**5 + 349879488*f**6 + 339099600*f**7 + 199769640*f**8 + 70634340*f**9 + 13815648*f**10 + 1151304*f**11))/2.6600351445645357e24,
    57: lambda f: 0,
    58: lambda f: 0,
    59: lambda f: -(f*(16302 + 327275*f + 4087964*f**2 + 36663521*f**3 + 253909350*f**4 + 804128841*f**5 + 1341142488*f**6 + 1304238915*f**7 + 769650840*f**8 + 272357820*f**9 + 53288928*f**10 + 4440744*f**11))/2.8728379561296984e26,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (f*(165 + 134*f + 34*f**2))/2079.,
    64: lambda f: (f*(616 + 793*f + 457*f**2 + 99*f**3))/4851.,
    65: lambda f: -(f*(7623 + 9064*f + 5270*f**2 + 1326*f**3))/53361.,
    66: lambda f: -(f*(3861 + 7020*f + 6160*f**2 + 2624*f**3 + 435*f**4))/54054.,
    67: lambda f: -(f*(108108 + 245661*f + 292354*f**2 + 192670*f**3 + 67570*f**4 + 9945*f**5))/1.135134e6,
    68: lambda f: (f*(165165 + 355069*f + 407136*f**2 + 270350*f**3 + 101355*f**4 + 16965*f**5))/1.387386e6,
    69: lambda f: (f*(1859 + 5278*f + 8038*f**2 + 7224*f**3 + 3855*f**4 + 1130*f**5 + 140*f**6))/72072.,
    70: lambda f: (f*(48048 + 157599*f + 287605*f**2 + 322767*f**3 + 230250*f**4 + 102345*f**5 + 26005*f**6 + 2905*f**7))/1.513512e6,
    71: lambda f: -(f*(77077 + 242814*f + 427946*f**2 + 473332*f**3 + 341385*f**4 + 158330*f**5 + 43540*f**6 + 5460*f**7))/1.849848e6,
    72: lambda f: -(f*(123981 + 479128*f + 1041488*f**2 + 1434528*f**3 + 1308210*f**4 + 791640*f**5 + 306600*f**6 + 68880*f**7 + 6825*f**8))/2.2054032e7,
    73: lambda f: -(f*(1021020 + 4387071*f + 10829068*f**2 + 17259284*f**3 + 18722180*f**4 + 14050626*f**5 + 7218932*f**6 + 2433284*f**7 + 486528*f**8 + 43911*f**9))/1.54378224e8,
    74: lambda f: (f*(5054049 + 21045167*f + 50431792*f**2 + 78952692*f**3 + 85305690*f**4 + 64839210*f**5 + 34410600*f**6 + 12256020*f**7 + 2654925*f**8 + 266175*f**9))/5.66053488e8,
    75: lambda f: (f*(2909907 + 14234610*f + 40236110*f**2 + 74755120*f**3 + 96629250*f**4 + 88951428*f**5 + 58386720*f**6 + 26785920*f**7 + 8176035*f**8 + 1492890*f**9 + 123354*f**10))/3.352212864e9,
    76: lambda f: (f*(69837768 + 371397351*f + 1157342915*f**2 + 2394901265*f**3 + 3497233100*f**4 + 3709916862*f**5 + 2886617874*f**6 + 1636767930*f**7 + 659974980*f**8 + 179704875*f**9 + 29683731*f**10 + 2251557*f**11))/7.0396470144e10,
    77: lambda f: -(f*(117366249 + 608401508*f + 1848629130*f**2 + 3759309790*f**3 + 5442915750*f**4 + 5783046456*f**5 + 4559708832*f**6 + 2655538620*f**7 + 1116862425*f**8 + 322686420*f**9 + 57606318*f**10 + 4810806*f**11))/8.6040130176e10,
    78: lambda f: -(f*(1154725 + 6835972*f + 23793472*f**2 + 55659360*f**3 + 93179325*f**4 + 115259960*f**5 + 106838648*f**6 + 74260368*f**7 + 38230815*f**8 + 14166180*f**9 + 3575880*f**10 + 550704*f**11 + 39039*f**12))/1.117404288e10,
    79: lambda f: -(f*(27159132 + 172238781*f + 648719014*f**2 + 1652301978*f**3 + 3036934350*f**4 + 4171018023*f**5 + 4358014444*f**6 + 3484732636*f**7 + 2123259432*f**8 + 970632075*f**9 + 322853454*f**10 + 73869642*f**11 + 10408398*f**12 + 681681*f**13))/2.3465490048e11,
    80: lambda f: (f*(46235189 + 286972257*f + 1057502000*f**2 + 2650359058*f**3 + 4823449725*f**4 + 6604410791*f**5 + 6931951768*f**6 + 5616481500*f**7 + 3501845487*f**8 + 1656416895*f**9 + 577169208*f**10 + 140210994*f**11 + 21276255*f**12 + 1522521*f**13))/2.8680043392e11,
    81: lambda f: (f*(4018443 + 27923350*f + 115469270*f**2 + 325746792*f**3 + 669719505*f**4 + 1024806510*f**5 + 1161767964*f**6 + 961072224*f**7 + 568107645*f**8 + 232597890*f**9 + 62515530*f**10 + 9912672*f**11 + 702702*f**12))/4.0226554368e11,
    82: lambda f: (f*(31039008 + 228673341*f + 1010302979*f**2 + 3057245065*f**3 + 6777957970*f**4 + 11326324653*f**5 + 14332197229*f**6 + 13635129361*f**7 + 9624562332*f**8 + 4941954255*f**9 + 1788702069*f**10 + 431960067*f**11 + 62450388*f**12 + 4090086*f**13))/2.81585880576e12,
    83: lambda f: -(f*(160044885 + 1157403962*f + 5016385738*f**2 + 14957328960*f**3 + 32828916015*f**4 + 54504148818*f**5 + 68822673444*f**6 + 65841514200*f**7 + 47289153891*f**8 + 25076354310*f**9 + 9524950974*f**10 + 2451635802*f**11 + 382972590*f**12 + 27405378*f**13))/1.032481562112e13,
    84: lambda f: -(f*(4572711 + 36480912*f + 174750752*f**2 + 577224256*f**3 + 1407265020*f**4 + 2522121840*f**5 + 3244035984*f**6 + 2940804384*f**7 + 1849834770*f**8 + 787967040*f**9 + 216645660*f**10 + 34694352*f**11 + 2459457*f**12))/5.63171761152e12,
    85: lambda f: -(f*(104756652 + 879308391*f + 4458808280*f**2 + 15632494568*f**3 + 40595244200*f**4 + 78954906324*f**5 + 113580263832*f**6 + 119291150328*f**7 + 90478965696*f**8 + 48833286810*f**9 + 18261906432*f**10 + 4496178456*f**11 + 655729074*f**12 + 42945903*f**13))/1.1826606984192e14,
    86: lambda f: (f*(181384203 + 1497863081*f + 7466819424*f**2 + 25827123928*f**3 + 66416526540*f**4 + 127923212508*f**5 + 182638508304*f**6 + 191956968840*f**7 + 147732471306*f**8 + 82297234110*f**9 + 32329217844*f**10 + 8496536202*f**11 + 1340404065*f**12 + 95918823*f**13))/1.4454741869568e14,
    87: lambda f: (f*(1708993 + 15393534*f + 83824314*f**2 + 317304864*f**3 + 894839580*f**4 + 1810370520*f**5 + 2535677088*f**6 + 2430142848*f**7 + 1583126790*f**8 + 688803780*f**9 + 191614500*f**10 + 30839424*f**11 + 2186184*f**12))/3.003582726144e13,
    88: lambda f: (f*(12932920 + 121842383*f + 697451639*f**2 + 2780383677*f**3 + 8277866040*f**4 + 18151477644*f**5 + 28573109124*f**6 + 31947543124*f**7 + 25270091448*f**8 + 14018794258*f**9 + 5333977418*f**10 + 1326363654*f**11 + 194290096*f**12 + 12724712*f**13))/2.1025079083008e14,
    89: lambda f: -(f*(67574507 + 627431376*f + 3536786046*f**2 + 13925551326*f**3 + 41074237620*f**4 + 88911413856*f**5 + 138297679968*f**6 + 154222268760*f**7 + 123572657922*f**8 + 70737717120*f**9 + 28289033388*f**10 + 7515059244*f**11 + 1191470280*f**12 + 85261176*f**13))/7.7091956637696e14,
    90: lambda f: -(f*(5681247 + 57022420*f + 347883920*f**2 + 1484663040*f**3 + 4754377125*f**4 + 10582941168*f**5 + 15753762864*f**6 + 15669640224*f**7 + 10439453430*f**8 + 4602399480*f**9 + 1289512224*f**10 + 208166112*f**11 + 14756742*f**12))/1.62193467211776e15,
    91: lambda f: -(f*(14226212 + 148648799*f + 948098670*f**2 + 4235560370*f**3 + 14223085550*f**4 + 34355386839*f**5 + 57774816344*f**6 + 67419641912*f**7 + 54806626224*f**8 + 30936680670*f**9 + 11897556132*f**10 + 2976437772*f**11 + 437152716*f**12 + 28630602*f**13))/3.78451423494144e15,
    92: lambda f: (f*(224062839 + 2310697103*f + 14533552960*f**2 + 64189244130*f**3 + 213648148125*f**4 + 507908086299*f**5 + 841000705776*f**6 + 976435288920*f**7 + 803171534886*f**8 + 467739783630*f**9 + 189136376352*f**10 + 50575109508*f**11 + 8042424390*f**12 + 575512938*f**13))/4.162965658435584e16,
    93: lambda f: (f*(566865 + 6273306*f + 42384706*f**2 + 201332360*f**3 + 721689825*f**4 + 1735185510*f**5 + 2703274308*f**6 + 2761028928*f**7 + 1868279490*f**8 + 831099780*f**9 + 233985780*f**10 + 37848384*f**11 + 2683044*f**12))/2.9489721311232e15,
    94: lambda f: (f*(12697776 + 145734693*f + 1024862527*f**2 + 5071714669*f**3 + 18963551350*f**4 + 49593030183*f**5 + 87698581299*f**6 + 105552086031*f**7 + 87466197672*f**8 + 49964818050*f**9 + 19355390334*f**10 + 4861937682*f**11 + 715340808*f**12 + 46850076*f**13))/6.19284147535872e16,
    95: lambda f: -(f*(22309287 + 253006546*f + 1756632270*f**2 + 8601395684*f**3 + 31893105975*f**4 + 81857569086*f**5 + 142114011228*f**6 + 169869766500*f**7 + 142317097902*f**8 + 83866692420*f**9 + 34168480668*f**10 + 9177105924*f**11 + 1462258980*f**12 + 104638716*f**13))/7.56902846988288e16,
    96: lambda f: -(f*(2263261 + 27377480*f + 202921520*f**2 + 1061806944*f**3 + 4212016710*f**4 + 10790529640*f**5 + 17413279576*f**6 + 18141154416*f**7 + 12416228055*f**8 + 5559467760*f**9 + 1570642920*f**10 + 254425248*f**11 + 18036018*f**12))/2.378837519106048e17,
    97: lambda f: -(f*(50438388 + 630769581*f + 4848691244*f**2 + 26329222260*f**3 + 108485834820*f**4 + 303155313186*f**5 + 557622450308*f**6 + 686984885972*f**7 + 577392941664*f**8 + 332717681835*f**9 + 129567033288*f**10 + 32641746984*f**11 + 4808679876*f**12 + 314936622*f**13))/4.995558790122701e18,
    98: lambda f: (f*(88913825 + 1099806279*f + 8355038416*f**2 + 44924190140*f**3 + 183644092830*f**4 + 502342189822*f**5 + 904979171096*f**6 + 1105685496300*f**7 + 938985743619*f**8 + 558132778665*f**9 + 228632004216*f**10 + 61602347268*f**11 + 9829629810*f**12 + 703404702*f**13))/6.105682965705523e18,
    99: lambda f: (f*(7344051 + 96400642*f + 777730382*f**2 + 4444826256*f**3 + 19331111670*f**4 + 52223998860*f**5 + 86671007808*f**6 + 91691136768*f**7 + 63305253165*f**8 + 28485979830*f**9 + 8068869270*f**10 + 1308472704*f**11 + 92756664*f**12))/1.7127630137563546e19,
    100: lambda f: (f*(54318264 + 735173517*f + 6132618505*f**2 + 36255127571*f**3 + 163213376300*f**4 + 482405423406*f**5 + 915840130898*f**6 + 1149030829562*f**7 + 976293605364*f**8 + 566320816215*f**9 + 221415226263*f**10 + 55904208129*f**11 + 8243451216*f**12 + 539891352*f**13))/1.1989341096294482e20,
    101: lambda f: -(f*(288080793 + 3859737596*f + 31846584874*f**2 + 186545622198*f**3 + 833523697890*f**4 + 2405843746296*f**5 + 4464440120448*f**6 + 5548431443940*f**7 + 4761188996487*f**8 + 2848691219220*f**9 + 1171748146338*f**10 + 316471878954*f**11 + 50552381880*f**12 + 3617509896*f**13))/4.396091735307977e20,
    102: lambda f: -(f*(607563 + 8600844*f + 75029024*f**2 + 465006304*f**3 + 2200143855*f**4 + 6217800120*f**5 + 10556963256*f**6 + 11306030736*f**7 + 7859799255*f**8 + 3550483860*f**9 + 1007760600*f**10 + 163559088*f**11 + 11594583*f**12))/3.425526027512709e19,
    103: lambda f: -(f*(13430340 + 195593619*f + 1759695602*f**2 + 11250930446*f**3 + 54942498170*f**4 + 170386371645*f**5 + 331966723116*f**6 + 422609116188*f**7 + 362182880136*f**8 + 211189899459*f**9 + 82826634198*f**10 + 20948598594*f**11 + 3091294206*f**12 + 202459257*f**13))/7.193604657776689e20,
    104: lambda f: (f*(23801547 + 343386791*f + 3057993456*f**2 + 19383566566*f**3 + 93987604095*f**4 + 284014621317*f**5 + 539951510616*f**6 + 680277268860*f**7 + 588579954039*f**8 + 353979194415*f**9 + 146072474856*f**10 + 39525910578*f**11 + 6319047735*f**12 + 452188737*f**13))/8.792183470615953e20,
    105: lambda f: (f*(2817529 + 42787810*f + 401317810*f**2 + 2680912920*f**3 + 13709490375*f**4 + 40273710386*f**5 + 69683358836*f**6 + 75376750176*f**7 + 52693484025*f**8 + 23877543690*f**9 + 6788479698*f**10 + 1102509408*f**11 + 78156078*f**12))/4.156304913382087e21,
    106: lambda f: (f*(62078016 + 967966077*f + 9342615115*f**2 + 64236352065*f**3 + 338207621850*f**4 + 1093396445505*f**5 + 2176787239081*f**6 + 2804418490237*f**7 + 2420277762084*f**8 + 1417217655945*f**9 + 557212370715*f**10 + 141125597613*f**11 + 20837612796*f**12 + 1364725362*f**13))/8.728240318102383e22,
    107: lambda f: -(f*(110253143 + 1704096966*f + 16291218830*f**2 + 111104596840*f**3 + 581042303625*f**4 + 1826743678214*f**5 + 3543555209740*f**6 + 4514572848240*f**7 + 3932178722199*f**8 + 2374732299030*f**9 + 982500981462*f**10 + 266255559570*f**11 + 42595062510*f**12 + 3048087042*f**13))/1.066784927768069e23,
    108: lambda f: -(f*(9006855 + 146058016*f + 1465706816*f**2 + 10498688640*f**3 + 57701407800*f**4 + 175301209440*f**5 + 308177540832*f**6 + 336134565312*f**7 + 236063651460*f**8 + 107245167120*f**9 + 30531320820*f**10 + 4961292336*f**11 + 351702351*f**12))/3.7406744220438784e23,
    109: lambda f: -(f*(65957892 + 1096354701*f + 11300157584*f**2 + 83142892528*f**3 + 469492226800*f**4 + 1574023789944*f**5 + 3191396634832*f**6 + 4152648657808*f**7 + 3604593816096*f**8 + 2118029522700*f**9 + 834467946312*f**10 + 211585950576*f**11 + 31256419194*f**12 + 2047088043*f**13))/2.618472095430715e24,
    110: lambda f: (f*(352098747 + 5804525441*f + 59292360640*f**2 + 432914021424*f**3 + 2428965293400*f**4 + 7904702908344*f**5 + 15596712950112*f**6 + 20055994686000*f**7 + 17565304355508*f**8 + 10644549732180*f**9 + 4413391154172*f**10 + 1197493343046*f**11 + 191677781295*f**12 + 13716391689*f**13))/9.601064349912621e24,
    111: lambda f: (f*(9561123 + 164894730*f + 1762885550*f**2 + 13478164672*f**3 + 79229819880*f**4 + 247900830480*f**5 + 441762441792*f**6 + 485224035072*f**7 + 342085167060*f**8 + 155745964920*f**9 + 44388784440*f**10 + 7216425216*f**11 + 511567056*f**12))/1.197015815054041e25,
    112: lambda f: (f*(209513304 + 3698214663*f + 40541134727*f**2 + 317834537165*f**3 + 1916110651760*f**4 + 6633073051032*f**5 + 13660775499336*f**6 + 17925481659624*f**7 + 15635470765488*f**8 + 9213979295220*f**9 + 3636403366596*f**10 + 922911617628*f**11 + 136391647392*f**12 + 8932747824*f**13))/2.5137332116134863e26,
    113: lambda f: -(f*(373438065 + 6540731912*f + 71096578458*f**2 + 553340314930*f**3 + 3315579198840*f**4 + 11122623435264*f**5 + 22267455172032*f**6 + 28859579691600*f**7 + 25392992045148*f**8 + 15432423595680*f**9 + 6409946815272*f**10 + 1741012529256*f**11 + 278804045520*f**12 + 19951115184*f**13))/3.0723405919720388e26,
    114: lambda f: -(f*(198341 + 3624972*f + 41132112*f**2 + 334328256*f**3 + 2093133195*f**4 + 6721781280*f**5 + 12119440032*f**6 + 13391727552*f**7 + 9472299060*f**8 + 4320471120*f**9 + 1232542080*f**10 + 200456256*f**11 + 14210196*f**12))/7.980105433693607e24,
    115: lambda f: -(f*(1445444 + 27002287*f + 313706150*f**2 + 2610662586*f**3 + 16735732950*f**4 + 59605514379*f**5 + 124429952752*f**6 + 164455113648*f**7 + 144040608096*f**8 + 85092796460*f**9 + 33631922632*f**10 + 8542559256*f**11 + 1262885624*f**12 + 82710628*f**13))/5.5860738035855254e25,
    116: lambda f: (f*(7740733 + 143547261*f + 1654369824*f**2 + 13672805118*f**3 + 87140414115*f**4 + 300294165309*f**5 + 608794274592*f**6 + 794341049040*f**7 + 701690117268*f**8 + 427490972580*f**9 + 177830053632*f**10 + 48342750456*f**11 + 7744556820*f**12 + 554197644*f**13))/2.0482270613146925e26,
    117: lambda f: (f*(627627 + 12117326*f + 145441846*f**2 + 1252372536*f**3 + 8319568095*f**4 + 27342602730*f**5 + 49804930476*f**6 + 55319112576*f**7 + 39239490780*f**8 + 17925901560*f**9 + 5118082200*f**10 + 832664448*f**11 + 59026968*f**12))/8.618513868389095e26,
    118: lambda f: (f*(1521520 + 29989999*f + 368074517*f**2 + 3240621551*f**3 + 22011819770*f**4 + 80413558833*f**5 + 169864839725*f**6 + 225908989649*f**7 + 198573400368*f**8 + 117557675004*f**9 + 46521610212*f**10 + 11824695036*f**11 + 1748610864*f**12 + 114522408*f**13))/2.010986569290789e27,
    119: lambda f: -(f*(24477453 + 479121214*f + 5835750554*f**2 + 51042340164*f**3 + 344775903705*f**4 + 1216973671722*f**5 + 2494427806836*f**6 + 3273645688740*f**7 + 2901669837444*f**8 + 1771506518040*f**9 + 737881058376*f**10 + 200741736888*f**11 + 32169697560*f**12 + 2302051752*f**13))/2.212085226219868e28,
}

Q140withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: -(f**2*(2 + f)**2)/35.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/385.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (-3*f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/40040.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/60060.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: -(f**2*(2 + f)**2*(12155 + 44200*f + 93500*f**2 + 128520*f**3 + 125706*f**4 + 87192*f**5 + 40404*f**6 + 11088*f**7 + 1386*f**8))/3.267264e7,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (f**2*(2 + f)**2*(2431 + 11050*f + 29325*f**2 + 52360*f**3 + 67270*f**4 + 58380*f**5 + 31290*f**6 + 9240*f**7 + 1155*f**8))/5.44544e7,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: -(f**2*(2 + f)**2*(2431 + 13260*f + 42330*f**2 + 92820*f**3 + 142125*f**4 + 137880*f**5 + 78420*f**6 + 23760*f**7 + 2970*f**8))/5.601024e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (f**2*(2 + f)**2*(9724 + 61880*f + 230860*f**2 + 599760*f**3 + 1037820*f**4 + 1076040*f**5 + 632100*f**6 + 194040*f**7 + 24255*f**8))/2.74450176e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: -(f**2*(2 + f)**2*(2431 + 17680*f + 75480*f**2 + 226576*f**3 + 429044*f**4 + 464912*f**5 + 278712*f**6 + 86240*f**7 + 10780*f**8))/9.75822848e10,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (f**2*(2 + f)**2*(12155 + 99450*f + 478125*f**2 + 1627920*f**3 + 3303468*f**4 + 3693816*f**5 + 2245572*f**6 + 698544*f**7 + 87318*f**8))/7.9041650688e12,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: -(f**2*(2 + f)**2*(2431 + 22100*f + 118150*f**2 + 449820*f**3 + 964215*f**4 + 1103760*f**5 + 677880*f**6 + 211680*f**7 + 26460*f**8))/2.8742418432e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (f**2*(2 + f)**2*(221 + 2210*f + 13005*f**2 + 54740*f**3 + 122675*f**4 + 143010*f**5 + 88515*f**6 + 27720*f**7 + 3465*f**8))/5.2694433792e13,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: -(f**2*(2 + f)**2*(31603 + 344760*f + 2214420*f**2 + 10210200*f**3 + 23739870*f**4 + 28080360*f**5 + 17486700*f**6 + 5488560*f**7 + 686070*f**8))/1.66935966253056e17,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (f**2*(2 + f)**2*(187 + 2210*f + 15385*f**2 + 77112*f**3 + 184938*f**4 + 221364*f**5 + 138534*f**6 + 43560*f**7 + 5445*f**8))/2.3847995179008e16,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: -(f**2*(2 + f)**2*(935 + 11900*f + 89250*f**2 + 483140*f**3 + 1189769*f**4 + 1438248*f**5 + 903756*f**6 + 284592*f**7 + 35574*f**8))/3.116138036723712e18,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: (f**2*(2 + f)**2*(19448 + 265200*f + 2131800*f**2 + 12395040*f**3 + 31228680*f**4 + 38067120*f**5 + 24002160*f**6 + 7567560*f**7 + 945945*f**8))/1.8229407514833715e21,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: -(f**2*(2 + f)**2*(41327 + 601120*f + 5155760*f**2 + 32044320*f**3 + 82357800*f**4 + 101112480*f**5 + 63939120*f**6 + 20180160*f**7 + 2522520*f**8))/1.1666820809493578e23,
    52: lambda f: 0,
    53: lambda f: 0,
    54: lambda f: (f**2*(2 + f)**2*(143 + 2210*f + 20145*f**2 + 133280*f**3 + 348600*f**4 + 430640*f**5 + 273000*f**6 + 86240*f**7 + 10780*f**8))/1.2963134232770642e22,
    55: lambda f: 0,
    56: lambda f: 0,
    57: lambda f: -(f**2*(2 + f)**2*(2717 + 44460*f + 429210*f**2 + 3011652*f**3 + 8000433*f**4 + 9936864*f**5 + 6313104*f**6 + 1995840*f**7 + 249480*f**8))/8.400110982835376e24,
    58: lambda f: 0,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (-2*f**2*(2 + f)**2)/105.,
    64: lambda f: (2*f**2*(121 + 112*f + 34*f**2))/1155.,
    65: lambda f: 0,
    66: lambda f: (f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/385.,
    67: lambda f: -(f**2*(1287 + 2392*f + 2010*f**2 + 840*f**3 + 145*f**4))/5005.,
    68: lambda f: 0,
    69: lambda f: -(f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/10010.,
    70: lambda f: (f**2*(2431 + 6760*f + 9388*f**2 + 7780*f**3 + 3925*f**4 + 1120*f**5 + 140*f**6))/20020.,
    71: lambda f: 0,
    72: lambda f: (f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/36036.,
    73: lambda f: -(f**2*(201773 + 746096*f + 1444388*f**2 + 1787040*f**3 + 1493850*f**4 + 846720*f**5 + 313740*f**6 + 68880*f**7 + 6825*f**8))/6.12612e6,
    74: lambda f: 0,
    75: lambda f: -(f**2*(2 + f)**2*(2431 + 8840*f + 18700*f**2 + 25704*f**3 + 24402*f**4 + 15960*f**5 + 6972*f**6 + 1848*f**7 + 231*f**8))/3.267264e6,
    76: lambda f: (f**2*(1893749 + 8733920*f + 21670070*f**2 + 35620440*f**3 + 41522410*f**4 + 35150976*f**5 + 21603540*f**6 + 9434040*f**7 + 2783865*f**8 + 498960*f**9 + 41118*f**10))/3.1039008e8,
    77: lambda f: 0,
    78: lambda f: (f**2*(2 + f)**2*(46189 + 209950*f + 557175*f**2 + 994840*f**3 + 1278130*f**4 + 1205316*f**5 + 834750*f**6 + 415800*f**7 + 142065*f**8 + 30030*f**9 + 3003*f**10))/4.434144e8,
    79: lambda f: -(f**2*(2632773 + 14545336*f + 43997122*f**2 + 90142840*f**3 + 134680645*f**4 + 151510912*f**5 + 129896564*f**6 + 84758688*f**7 + 41511015*f**8 + 14811720*f**9 + 3641946*f**10 + 552552*f**11 + 39039*f**12))/3.1039008e9,
    80: lambda f: 0,
    81: lambda f: -(f**2*(2 + f)**2*(184756 + 1007760*f + 3217080*f**2 + 7054320*f**3 + 11252940*f**4 + 13111488*f**5 + 10961400*f**6 + 6355800*f**7 + 2416095*f**8 + 540540*f**9 + 54054*f**10))/1.59629184e10,
    82: lambda f: (f**2*(10484903 + 67486328*f + 240751280*f**2 + 590527980*f**3 + 1067199315*f**4 + 1450876896*f**5 + 1483165152*f**6 + 1127298984*f**7 + 624517845*f**8 + 244157760*f**9 + 63704718*f**10 + 9945936*f**11 + 702702*f**12))/1.117404288e11,
    83: lambda f: 0,
    84: lambda f: (f**2*(2 + f)**2*(184756 + 1175720*f + 4386340*f**2 + 11395440*f**3 + 21357140*f**4 + 28430584*f**5 + 26239500*f**6 + 16277800*f**7 + 6449135*f**8 + 1471470*f**9 + 147147*f**10))/1.738184448e11,
    85: lambda f: -(f**2*(4480333 + 32920160*f + 135274984*f**2 + 386359680*f**3 + 810281220*f**4 + 1253841792*f**5 + 1420418664*f**6 + 1165354848*f**7 + 681399390*f**8 + 276118920*f**9 + 73602606*f**10 + 11603592*f**11 + 819819*f**12))/5.214553344e11,
    86: lambda f: 0,
    87: lambda f: -(f**2*(2 + f)**2*(230945 + 1679600*f + 7170600*f**2 + 21524720*f**3 + 45674860*f**4 + 66554544*f**5 + 65242520*f**6 + 42042000*f**7 + 17027010*f**8 + 3923920*f**9 + 392392*f**10))/2.7810951168e12,
    88: lambda f: (f**2*(5588869 + 46155408*f + 214639314*f**2 + 699462960*f**3 + 1651966020*f**4 + 2803433472*f**5 + 3392441304*f**6 + 2911914768*f**7 + 1754528790*f**8 + 724674720*f**9 + 195314196*f**10 + 30942912*f**11 + 2186184*f**12))/8.3432853504e12,
    89: lambda f: 0,
    90: lambda f: (f**2*(2 + f)**2*(230945 + 1889550*f + 9084375*f**2 + 30930480*f**3 + 72418500*f**4 + 112603176*f**5 + 114933420*f**6 + 75887280*f**7 + 31156650*f**8 + 7223580*f**9 + 722358*f**10))/4.09579462656e13,
    91: lambda f: -(f**2*(20461727 + 187611320*f + 973906370*f**2 + 3565493640*f**3 + 9275110965*f**4 + 16855098624*f**5 + 21345963912*f**6 + 18873840384*f**7 + 11590886790*f**8 + 4844402640*f**9 + 1314485172*f**10 + 208864656*f**11 + 14756742*f**12))/4.505374089216e14,
    92: lambda f: 0,
    93: lambda f: -(f**2*(2 + f)**2*(46189 + 419900*f + 2244850*f**2 + 8546580*f**3 + 21671685*f**4 + 35379792*f**5 + 37170000*f**6 + 24960600*f**7 + 10343655*f**8 + 2407860*f**9 + 240786*f**10))/1.36526487552e14,
    94: lambda f: (f**2*(743223 + 7491016*f + 42934452*f**2 + 174439380*f**3 + 491538265*f**4 + 941369184*f**5 + 1232330148*f**6 + 1112607216*f**7 + 692320230*f**8 + 291695040*f**9 + 79508772*f**10 + 12658464*f**11 + 894348*f**12))/2.73052975104e14,
    95: lambda f: 0,
    96: lambda f: (f**2*(2 + f)**2*(54587 + 545870*f + 3212235*f**2 + 13520780*f**3 + 36620885*f**4 + 62089902*f**5 + 66658725*f**6 + 45322200*f**7 + 18908505*f**8 + 4414410*f**9 + 441441*f**10))/3.003582726144e15,
    97: lambda f: -(f**2*(9653501 + 106083536*f + 665308940*f**2 + 2970308000*f**3 + 8950790750*f**4 + 17866158464*f**5 + 23982950068*f**6 + 21990686256*f**7 + 13815810855*f**8 + 5855073840*f**9 + 1601165412*f**10 + 255279024*f**11 + 18036018*f**12))/6.6078819975168e16,
    98: lambda f: 0,
    99: lambda f: -(f**2*(2 + f)**2*(600457 + 6550440*f + 42073980*f**2 + 193993800*f**3 + 555340170*f**4 + 970416216*f**5 + 1059481500*f**6 + 727234200*f**7 + 304958115*f**8 + 71351280*f**9 + 7135128*f**10))/6.79667862601728e17,
    100: lambda f: (f**2*(33764159 + 401760320*f + 2736563882*f**2 + 13316036760*f**3 + 42484403370*f**4 + 87678847872*f**5 + 120033468324*f**6 + 111381512088*f**7 + 70490692965*f**8 + 30005957520*f**9 + 8225842086*f**10 + 1312863552*f**11 + 92756664*f**12))/4.757675038212096e18,
    101: lambda f: 0,
    102: lambda f: (f**2*(2 + f)**2*(17765 + 209950*f + 1461575*f**2 + 7325640*f**3 + 21983190*f**4 + 39371244*f**5 + 43565610*f**6 + 30129000*f**7 + 12685035*f**8 + 2972970*f**9 + 297297*f**10))/4.53111908401152e17,
    103: lambda f: -(f**2*(998393 + 12788216*f + 94007858*f**2 + 495159000*f**3 + 1659332605*f**4 + 3519831168*f**5 + 4895363676*f**6 + 4585634592*f**7 + 2918924085*f**8 + 1246817880*f**9 + 342460734*f**10 + 54702648*f**11 + 3864861*f**12))/3.171783358808064e18,
    104: lambda f: 0,
    105: lambda f: -(f**2*(2 + f)**2*(142120 + 1808800*f + 13566000*f**2 + 73437280*f**3 + 229510120*f**4 + 419535648*f**5 + 469347480*f**6 + 326569320*f**7 + 137938185*f**8 + 32372340*f**9 + 3237234*f**10))/8.88099340466258e19,
    106: lambda f: (f**2*(14826669 + 203399560*f + 1604961160*f**2 + 9097404820*f**3 + 31816183525*f**4 + 69056609440*f**5 + 97295038568*f**6 + 91841238216*f**7 + 58733237745*f**8 + 25157932800*f**9 + 6920743830*f**10 + 1106209104*f**11 + 78156078*f**12))/1.1545291426061353e21,
    107: lambda f: 0,
    108: lambda f: (f**2*(2 + f)**2*(6281704 + 85659600*f + 688571400*f**2 + 4003597920*f**3 + 12962536440*f**4 + 24107127408*f**5 + 27216462000*f**6 + 19032413400*f**7 + 8060397345*f**8 + 1893781890*f**9 + 189378189*f**10))/1.0390762283455218e23,
    109: lambda f: -(f**2*(50392199 + 737142848*f + 6214194416*f**2 + 37715650560*f**3 + 136933678680*f**4 + 303053563008*f**5 + 431614962576*f**6 + 410017800192*f**7 + 263218579260*f**8 + 113006373480*f**9 + 31126509414*f**10 + 4977940968*f**11 + 351702351*f**12))/1.0390762283455218e23,
    110: lambda f: 0,
    111: lambda f: -(f**2*(2 + f)**2*(785213 + 11421280*f + 97959440*f**2 + 608842080*f**3 + 2033426360*f**4 + 3837803872*f**5 + 4366311600*f**6 + 3066263200*f**7 + 1301480180*f**8 + 306065760*f**9 + 30606576*f**10))/3.694493256339633e23,
    112: lambda f: (f**2*(18891301 + 293526896*f + 2632769770*f**2 + 17034399840*f**3 + 63926888520*f**4 + 143861738496*f**5 + 206773629552*f**6 + 197479898784*f**7 + 127184732220*f**8 + 54708413760*f**9 + 15084837768*f**10 + 2413547136*f**11 + 170522352*f**12))/1.1083479769018899e24,
    113: lambda f: 0,
    114: lambda f: (f**2*(2 + f)**2*(51623 + 797810*f + 7272345*f**2 + 48114080*f**3 + 165170040*f**4 + 315729456*f**5 + 361585000*f**6 + 254839200*f**7 + 108371340*f**8 + 25505480*f**9 + 2550548*f**10))/7.388986512679266e23,
    115: lambda f: -(f**2*(1241669 + 20421960*f + 194185662*f**2 + 1334235480*f**3 + 5156750955*f**4 + 11774074368*f**5 + 17056223856*f**6 + 16364044032*f**7 + 10567978260*f**8 + 4553213280*f**9 + 1256590104*f**10 + 201128928*f**11 + 14210196*f**12))/2.2166959538037798e24,
    116: lambda f: 0,
    117: lambda f: -(f**2*(2 + f)**2*(258115 + 4223700*f + 40774950*f**2 + 286106940*f**3 + 1006527375*f**4 + 1945514592*f**5 + 2240824320*f**6 + 1584198000*f**7 + 674781030*f**8 + 158918760*f**9 + 15891876*f**10))/1.1970158150540411e26,
    118: lambda f: (f**2*(4137991 + 71821672*f + 721651996*f**2 + 5247589860*f**3 + 20823561765*f**4 + 48151412064*f**5 + 70229136348*f**6 + 67644664416*f**7 + 43788342780*f**8 + 18892621440*f**9 + 5217973992*f**10 + 835458624*f**11 + 59026968*f**12))/2.3940316301080822e26,
    119: lambda f: 0,
}

Q142withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: -(f*(66 + 101*f + 68*f**2 + 17*f**3))/385.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/10010.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (-3*f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/40040.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/4.08408e6,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: -(f*(1385670 + 7831135*f + 25872300*f**2 + 57017575*f**3 + 89062500*f**4 + 102804406*f**5 + 89119968*f**6 + 57235710*f**7 + 26220390*f**8 + 8049615*f**9 + 1480248*f**10 + 123354*f**11))/3.1039008e9,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (f*(92378 + 617253*f + 2444464*f**2 + 6570466*f**3 + 12789850*f**4 + 18666127*f**5 + 20077456*f**6 + 15281420*f**7 + 7875630*f**8 + 2596755*f**9 + 493416*f**10 + 41118*f**11))/2.0692672e9,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: -(f*(277134 + 2137291*f + 9867004*f**2 + 31294501*f**3 + 72933210*f**4 + 125774103*f**5 + 153166104*f**6 + 126310905*f**7 + 68287170*f**8 + 23111445*f**9 + 4440744*f**10 + 370062*f**11))/7.44936192e10,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (f*(277134 + 2422823*f + 12775296*f**2 + 46695464*f**3 + 126738360*f**4 + 247391732*f**5 + 326217696*f**6 + 281751960*f**7 + 156310980*f**8 + 53624130*f**9 + 10361736*f**10 + 863478*f**11))/1.0429106688e12,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: -(f*(92378 + 902785*f + 5352756*f**2 + 22152309*f**3 + 68616600*f**4 + 147336228*f**5 + 205263744*f**6 + 182676900*f**7 + 102997020*f**8 + 35628390*f**9 + 6907824*f**10 + 575652*f**11))/5.5621902336e12,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (f*(1385670 + 14969435*f + 98579600*f**2 + 455607650*f**3 + 1585811250*f**4 + 3672180531*f**5 + 5325511968*f**6 + 4839843960*f**7 + 2759134140*f**8 + 959787990*f**9 + 186511248*f**10 + 15542604*f**11))/1.501791363072e15,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: -(f*(25194 + 298129*f + 2158932*f**2 + 11021083*f**3 + 42581850*f**4 + 104830807*f**5 + 156743496*f**6 + 144667845*f**7 + 83138580*f**8 + 29037330*f**9 + 5651856*f**10 + 470988*f**11))/5.46105950208e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (f*(92378 + 1188317*f + 9385088*f**2 + 52443572*f**3 + 222706220*f**4 + 576745202*f**5 + 883286096*f**6 + 824967220*f**7 + 476998830*f**8 + 167106555*f**9 + 32565456*f**10 + 2713788*f**11))/4.4052546650112e16,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: -(f*(277134 + 3850483*f + 32936956*f**2 + 199960579*f**3 + 925701660*f**4 + 2501498634*f**5 + 3905792352*f**6 + 3682331730*f**7 + 2139362610*f**8 + 751266285*f**9 + 146544552*f**10 + 12212046*f**11))/3.171783358808064e18,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (f*(21318 + 318155*f + 2930256*f**2 + 19204934*f**3 + 96258750*f**4 + 269719541*f**5 + 427880208*f**6 + 406483980*f**7 + 237072990*f**8 + 83410635*f**9 + 16282728*f**10 + 1356894*f**11))/6.343566717616128e18,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: -(f*(461890 + 7369245*f + 72707300*f**2 + 511640075*f**3 + 2760248750*f**4 + 7979802677*f**5 + 12828471656*f**6 + 12263992195*f**7 + 7175480130*f**8 + 2528549205*f**9 + 493909416*f**10 + 41159118*f**11))/3.8484304753537843e21,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: (f*(277134 + 4707079*f + 49530112*f**2 + 372462928*f**3 + 2151932400*f**4 + 6392814888*f**5 + 10393798464*f**6 + 9989214480*f**7 + 5860119720*f**8 + 2067740220*f**9 + 404107704*f**10 + 33675642*f**11))/6.927174855636812e22,
    50: lambda f: 0,
    51: lambda f: 0,
    52: lambda f: -(f*(277134 + 4992611*f + 55810524*f**2 + 446643431*f**3 + 2751417360*f**4 + 8371541144*f**5 + 13743485952*f**6 + 13268279640*f**7 + 7801389960*f**8 + 2755776660*f**9 + 538810272*f**10 + 44900856*f**11))/2.2166959538037798e24,
    53: lambda f: 0,
    54: lambda f: 0,
    55: lambda f: (f*(5434 + 103493*f + 1224816*f**2 + 10393494*f**3 + 68002710*f**4 + 211335321*f**5 + 349879488*f**6 + 339099600*f**7 + 199769640*f**8 + 70634340*f**9 + 13815648*f**10 + 1151304*f**11))/1.4777973025358532e24,
    56: lambda f: 0,
    57: lambda f: 0,
    58: lambda f: -(f*(16302 + 327275*f + 4087964*f**2 + 36663521*f**3 + 253909350*f**4 + 804128841*f**5 + 1341142488*f**6 + 1304238915*f**7 + 769650840*f**8 + 272357820*f**9 + 53288928*f**10 + 4440744*f**11))/1.5960210867387213e26,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (f*(-990 - 469*f + 200*f**2 + 176*f**3))/23100.,
    64: lambda f: -(f*(4158 + 5689*f + 3400*f**2 + 748*f**3))/16170.,
    65: lambda f: (3*f*(30030 + 45721*f + 30720*f**2 + 7716*f**3))/700700.,
    66: lambda f: (f*(8580 + 10517*f + 500*f**2 - 8743*f**3 - 6570*f**4 - 1560*f**5))/300300.,
    67: lambda f: (f*(42042 + 100178*f + 123860*f**2 + 85319*f**3 + 31320*f**4 + 4785*f**5))/210210.,
    68: lambda f: -(f*(60060 + 152893*f + 201220*f**2 + 148243*f**3 + 58770*f**4 + 9810*f**5))/700700.,
    69: lambda f: (f*(-7150 - 14937*f - 9400*f**2 + 10978*f**3 + 24470*f**4 + 19195*f**5 + 7280*f**6 + 1120*f**7))/800800.,
    70: lambda f: -(f*(38038 + 129545*f + 244120*f**2 + 284534*f**3 + 211810*f**4 + 98645*f**5 + 26320*f**6 + 3080*f**7))/560560.,
    71: lambda f: (3*f*(850850 + 3038971*f + 5964960*f**2 + 7281406*f**3 + 5711190*f**4 + 2813815*f**5 + 797160*f**6 + 99540*f**7))/9.52952e7,
    72: lambda f: -(f*(-109395 - 329069*f - 409700*f**2 + 10081*f**3 + 766740*f**4 + 1192545*f**5 + 966000*f**6 + 460635*f**7 + 122955*f**8 + 14280*f**9))/6.12612e7,
    73: lambda f: (f*(1225224 + 5429749*f + 13769320*f**2 + 22649746*f**3 + 25465980*f**4 + 19888920*f**5 + 10673040*f**6 + 3769710*f**7 + 791700*f**8 + 75075*f**9))/8.576568e7,
    74: lambda f: -(f*(4849845 + 22305088*f + 58262740*f**2 + 99287293*f**3 + 116268220*f**4 + 94913815*f**5 + 53367160*f**6 + 19780775*f**7 + 4364955*f**8 + 435645*f**9))/9.053044e8,
    75: lambda f: (f*(-1939938 - 7679971*f - 14405800*f**2 - 9952276*f**3 + 15188220*f**4 + 49510230*f**5 + 66762864*f**6 + 55592460*f**7 + 30445590*f**8 + 10768485*f**9 + 2245320*f**10 + 210672*f**11))/7.44936192e9,
    76: lambda f: -(f*(56258202 + 307119059*f + 979400600*f**2 + 2081773760*f**3 + 3133660500*f**4 + 3438076218*f**5 + 2775393936*f**6 + 1637673660*f**7 + 689225250*f**8 + 196432635*f**9 + 34045704*f**10 + 2713788*f**11))/2.607276672e10,
    77: lambda f: (f*(13579566 + 76417601*f + 249356000*f**2 + 545420384*f**3 + 849121020*f**4 + 966818046*f**5 + 811796832*f**6 + 498948660*f**7 + 218906310*f**8 + 65068185*f**9 + 11764368*f**10 + 978516*f**11))/1.738184448e10,
    78: lambda f: -(f*(-1847560 - 9107631*f - 22900700*f**2 - 29598751*f**3 - 1311950*f**4 + 73869170*f**5 + 161355376*f**6 + 202061090*f**7 + 172094916*f**8 + 103580085*f**9 + 43746780*f**10 + 12410013*f**11 + 2132130*f**12 + 168168*f**13))/6.2078016e10,
    79: lambda f: (f*(10992982 + 71315816*f + 274065500*f**2 + 714443377*f**3 + 1347956900*f**4 + 1905576553*f**5 + 2054583104*f**6 + 1699552330*f**7 + 1073936598*f**8 + 510432090*f**9 + 176974644*f**10 + 42316197*f**11 + 6246240*f**12 + 429429*f**13))/4.34546112e10,
    80: lambda f: -(f*(297457160 + 1979925077*f + 7751864340*f**2 + 20700336467*f**3 + 40198734150*f**4 + 58684721720*f**5 + 65484259008*f**6 + 56140224630*f**7 + 36797709228*f**8 + 18150491205*f**9 + 6532037820*f**10 + 1621113879*f**11 + 248318070*f**12 + 17711694*f**13))/3.331520192e12,
    81: lambda f: (f*(-12471030 - 73747037*f - 232883000*f**2 - 430227602*f**3 - 351108030*f**4 + 485738505*f**5 + 2164083936*f**6 + 3788650740*f**7 + 4098889326*f**8 + 2942952285*f**9 + 1406485080*f**10 + 430960068*f**11 + 76756680*f**12 + 6054048*f**13))/4.469617152e12,
    82: lambda f: -(f*(75657582 + 568657973*f + 2557552760*f**2 + 7899016034*f**3 + 17918423670*f**4 + 30729933423*f**5 + 40063031904*f**6 + 39438990780*f**7 + 28925030778*f**8 + 15486122715*f**9 + 5860401624*f**10 + 1482676272*f**11 + 224864640*f**12 + 15459444*f**13))/3.1287320064e12,
    83: lambda f: (f*(669278610 + 5143594443*f + 23497035520*f**2 + 74094186418*f**3 + 172383306970*f**4 + 304784660425*f**5 + 411998120296*f**6 + 422531357360*f**7 + 323732899686*f**8 + 181193274885*f**9 + 71619942240*f**10 + 18890719848*f**11 + 2979816840*f**12 + 212540328*f**13))/7.9956484608e13,
    84: lambda f: -(f*(-6928350 - 47851804*f - 182042800*f**2 - 433009924*f**3 - 602904960*f**4 - 15840300*f**5 + 2039946048*f**6 + 4793520060*f**7 + 6004591908*f**8 + 4698037680*f**9 + 2363116140*f**10 + 744963219*f**11 + 134324190*f**12 + 10594584*f**13))/3.1287320064e13,
    85: lambda f: (f*(42678636 + 364704145*f + 1879110640*f**2 + 6709238428*f**3 + 17781626520*f**4 + 35436490824*f**5 + 52521491232*f**6 + 57148440300*f**7 + 45114563424*f**8 + 25431854070*f**9 + 9957802932*f**10 + 2570937831*f**11 + 393513120*f**12 + 27054027*f**13))/2.19011240448e13,
    86: lambda f: -(f*(1115464350 + 9720861358*f + 50760276880*f**2 + 184577754388*f**3 + 500346191520*f**4 + 1028612478180*f**5 + 1587422993184*f**6 + 1809708353460*f**7 + 1500405981564*f**8 + 887893997340*f**9 + 364166801460*f**10 + 98191647477*f**11 + 15644038410*f**12 + 1115836722*f**13))/1.679086176768e15,
    87: lambda f: (f*(-5080790 - 40171833*f - 178877400*f**2 - 518058408*f**3 - 979622520*f**4 - 599975820*f**5 + 2268988512*f**6 + 6993113400*f**7 + 9665267052*f**8 + 7953551130*f**9 + 4113777360*f**10 + 1316186256*f**11 + 238798560*f**12 + 18834816*f**13))/3.33731414016e14,
    88: lambda f: -(f*(31685654 + 303381949*f + 1761913320*f**2 + 7140216036*f**3 + 21651361080*f**4 + 48608672796*f**5 + 78879809568*f**6 + 91478035320*f**7 + 75404606676*f**8 + 43737628830*f**9 + 17437960848*f**10 + 4549448904*f**11 + 699578880*f**12 + 48096048*f**13))/2.336119898112e14,
    89: lambda f: (f*(818007190 + 7970789541*f + 46834793280*f**2 + 192919570476*f**3 + 597024208440*f**4 + 1385311287420*f**5 + 2351417663616*f**6 + 2870452047960*f**7 + 2494077126996*f**8 + 1522522783950*f**9 + 636885073440*f**10 + 173687700648*f**11 + 27811623840*f**12 + 1983709728*f**13))/1.7910252552192e16,
    90: lambda f: -(f*(-8314020 - 74091355*f - 378071500*f**2 - 1287376255*f**3 - 3026383650*f**4 - 2931568740*f**5 + 5166288288*f**6 + 20645360820*f**7 + 30615158448*f**8 + 26040798630*f**9 + 13707179640*f**10 + 4425538194*f**11 + 805945140*f**12 + 63567504*f**13))/9.010748178432e15,
    91: lambda f: (f*(52378326 + 555435322*f + 3589725100*f**2 + 16278552385*f**3 + 55581156000*f**4 + 137415421323*f**5 + 238393391040*f**6 + 288827162820*f**7 + 244898803044*f**8 + 144640503000*f**9 + 58316898024*f**10 + 15311647890*f**11 + 2361078720*f**12 + 162324162*f**13))/6.3075237249024e15,
    92: lambda f: -(f*(446185740 + 4807120175*f + 31391239500*f**2 + 144462885345*f**3 + 502494304350*f**4 + 1287265289610*f**5 + 2345757089088*f**6 + 3002493760980*f**7 + 2690538269328*f**8 + 1675236547530*f**9 + 709392970440*f**10 + 194807884194*f**11 + 31288076820*f**12 + 2231673444*f**13))/1.61192272969728e17,
    93: lambda f: (f*(-1637610 - 16245931*f - 93476200*f**2 - 365333026*f**3 - 1018758150*f**4 - 1244351235*f**5 + 1318412592*f**6 + 6814682280*f**7 + 10653491772*f**8 + 9275640570*f**9 + 4941563760*f**10 + 1605264696*f**11 + 293070960*f**12 + 23115456*f**13))/3.276635701248e16,
    94: lambda f: -(f*(10405122 + 121052971*f + 861699400*f**2 + 4323217402*f**3 + 16413101550*f**4 + 43933462851*f**5 + 80203002768*f**6 + 100301211360*f**7 + 86750718516*f**8 + 51877653030*f**9 + 21076152048*f**10 + 5557510224*f**11 + 858574080*f**12 + 59026968*f**13))/2.2936449908736e16,
    95: lambda f: (f*(2900207310 + 34232779997*f + 245954577440*f**2 + 1250643756362*f**3 + 4829809936050*f**4 + 13433197806765*f**5 + 25854541347096*f**6 + 34257525285060*f**7 + 31373709064236*f**8 + 19802987799210*f**9 + 8455893747840*f**10 + 2332968378048*f**11 + 375456921840*f**12 + 26780081328*f**13))/1.934307275636736e19,
    96: lambda f: -(f*(-1616615 - 17673591*f - 113211500*f**2 - 498972661*f**3 - 1602958940*f**4 - 2269353625*f**5 + 1581990256*f**6 + 10642412165*f**7 + 17334561321*f**8 + 15356374110*f**9 + 8253117180*f**10 + 2692908603*f**11 + 492522030*f**12 + 38846808*f**13))/6.6078819975168e17,
    97: lambda f: (f*(20692672 + 262046993*f + 2037135160*f**2 + 11203170374*f**3 + 46814282020*f**4 + 133919615456*f**5 + 254465163568*f**6 + 325955101010*f**7 + 286088232276*f**8 + 172644376905*f**9 + 70527203208*f**10 + 18654532974*f**11 + 2885762880*f**12 + 198396198*f**13))/9.25103479652352e17,
    98: lambda f: -(f*(260275015 + 3340212122*f + 26185887780*f**2 + 145794815897*f**3 + 618928842180*f**4 + 1844969102735*f**5 + 3707878391448*f**6 + 5043775715055*f**7 + 4694388688143*f**8 + 2992813386255*f**9 + 1285671853620*f**10 + 355909964949*f**11 + 57361474170*f**12 + 4091401314*f**13))/3.546230005334016e19,
    99: lambda f: (f*(-20785050 - 248316263*f - 1752662600*f**2 - 8594395628*f**3 - 31174033020*f**4 - 49015167030*f**5 + 23227537872*f**6 + 206689019460*f**7 + 347887806882*f**8 + 312333886095*f**9 + 168984529560*f**10 + 55322489376*f**11 + 10131881760*f**12 + 799134336*f**13))/1.9030700152848384e20,
    100: lambda f: -(f*(133855722 + 1832968475*f + 15451144280*f**2 + 92427481016*f**3 + 421548482940*f**4 + 1275819319566*f**5 + 2503589505648*f**6 + 3267600978180*f**7 + 2900502358446*f**8 + 1762507767405*f**9 + 723015143928*f**10 + 191683292724*f**11 + 29682132480*f**12 + 2040646608*f**13))/1.3321490106993869e20,
    101: lambda f: (f*(1115464350 + 15464005817*f + 131360172320*f**2 + 794795487512*f**3 + 3678653038580*f**4 + 11633876957210*f**5 + 24213087120992*f**6 + 33622262512300*f**7 + 31685048089002*f**8 + 20354585130495*f**9 + 8784145727280*f**10 + 2437872996636*f**11 + 393335822880*f**12 + 28055323296*f**13))/3.4043808051206554e21,
    102: lambda f: -(f*(-852720 - 11054029*f - 85239700*f**2 - 460088629*f**3 - 1856702610*f**4 - 3160978590*f**5 + 1016577072*f**6 + 12333007890*f**7 + 21322494732*f**8 + 19347722625*f**9 + 10522941660*f**10 + 3454034661*f**11 + 633242610*f**12 + 49945896*f**13))/1.9030700152848384e20,
    103: lambda f: (f*(5521362 + 81293932*f + 738578260*f**2 + 4774470043*f**3 + 23600554740*f**4 + 74966647791*f**5 + 151050953088*f**6 + 200131005690*f**7 + 179243116206*f**8 + 109512879630*f**9 + 45071414388*f**10 + 11970877149*f**11 + 1855133280*f**12 + 127540413*f**13))/1.3321490106993869e20,
    104: lambda f: -(f*(1784742960 + 26580597979*f + 243204510220*f**2 + 1588932059869*f**3 + 7963008900210*f**4 + 26501902512540*f**5 + 56770409299968*f**6 + 80147941940430*f**7 + 76279607552148*f**8 + 49297105822965*f**9 + 21350897387820*f**10 + 5937286774419*f**11 + 958756068270*f**12 + 68384850534*f**13))/1.3277085139970556e23,
    105: lambda f: (f*(-7852130 - 109782855*f - 918289000*f**2 - 5408573630*f**3 - 24009299650*f**4 - 43530322745*f**5 + 9167010944*f**6 + 160045090660*f**7 + 282948916614*f**8 + 258971486865*f**9 + 141448627320*f**10 + 46526451972*f**11 + 8537048520*f**12 + 673344672*f**13))/4.618116570424541e22,
    106: lambda f: -(f*(51085034 + 804767743*f + 7839274600*f**2 + 54458888510*f**3 + 290010390250*f**4 + 960666261233*f**5 + 1978837177408*f**6 + 2654275436540*f**7 + 2394560628642*f**8 + 1469459446455*f**9 + 606367225464*f**10 + 161284547424*f**11 + 25009944960*f**12 + 1719433716*f**13))/3.232681599297179e22,
    107: lambda f: (f*(1264192930 + 20130026995*f + 197373672000*f**2 + 1384797470410*f**3 + 7470405160050*f**4 + 25992867064885*f**5 + 57040562370792*f**6 + 81631733940120*f**7 + 78317640708762*f**8 + 50860094025195*f**9 + 22091513764320*f**10 + 6153014363496*f**11 + 994265552280*f**12 + 70917622776*f**13))/2.478389226127837e24,
    108: lambda f: -(f*(-12471030 - 187073848*f - 1687093600*f**2 - 10764910408*f**3 - 52093348800*f**4 - 99423945720*f**5 + 12508152384*f**6 + 348781531560*f**7 + 628371396744*f**8 + 579258001140*f**9 + 317493196020*f**10 + 104612625117*f**11 + 19208359170*f**12 + 1515025512*f**13))/2.0781524566910437e24,
    109: lambda f: (f*(81477396 + 1367475733*f + 14217426400*f**2 + 105628103416*f**3 + 602878671600*f**4 + 2071699384752*f**5 + 4347867140736*f**6 + 5892075867720*f**7 + 5347566037632*f**8 + 3293526250560*f**9 + 1362002637996*f**10 + 362705015673*f**11 + 56272376160*f**12 + 3868725861*f**13))/1.4547067196837304e24,
    110: lambda f: -(f*(669278610 + 11346445422*f + 118686892640*f**2 + 890023381112*f**3 + 5142151731200*f**4 + 18604717639160*f**5 + 41672944337024*f**6 + 60319877313640*f**7 + 58256875406184*f**8 + 37983953929740*f**9 + 16537856795460*f**10 + 4612200730137*f**11 + 745699164210*f**12 + 53188217082*f**13))/3.7175838391917555e25,
    111: lambda f: (f*(-26327730 - 421802147*f - 4079813000*f**2 - 28030632512*f**3 - 146783267280*f**4 - 292409783880*f**5 + 17190105408*f**6 + 987470280720*f**7 + 1808035676328*f**8 + 1676813467980*f**9 + 921759078240*f**10 + 304153353504*f**11 + 55878863040*f**12 + 4407346944*f**13))/1.330017572282268e26,
    112: lambda f: -(f*(172654482 + 3075586943*f + 33993463160*f**2 + 268958207204*f**3 + 1637907754320*f**4 + 5813615984424*f**5 + 12397898584512*f**6 + 16947694365840*f**7 + 15459367671384*f**8 + 9550264198020*f**9 + 3956556475872*f**10 + 1054692855216*f**11 + 163701457920*f**12 + 11254475232*f**13))/9.310123005975875e25,
    113: lambda f: (f*(4238764530 + 76226970599*f + 847314892160*f**2 + 6763023996524*f**3 + 41663266094160*f**4 + 156047032107240*f**5 + 355740843838464*f**6 + 519897746748240*f**7 + 504933097291224*f**8 + 330325588394340*f**9 + 144106542740160*f**10 + 40233315154032*f**11 + 6507919978560*f**12 + 464188076352*f**13))/7.137760971248171e27,
    114: lambda f: -(f*(-271700 - 4630509*f - 47817300*f**2 - 351912129*f**3 - 1981880310*f**4 - 4094478480*f**5 + 17970624*f**6 + 13398365400*f**7 + 24877905024*f**8 + 23191617540*f**9 + 12780379920*f**10 + 4222303932*f**11 + 776095320*f**12 + 61213152*f**13))/4.4333919076075595e25,
    115: lambda f: (f*(1787786 + 33688330*f + 394441140*f**2 + 3311196063*f**3 + 21430378920*f**4 + 78285251217*f**5 + 169279238016*f**6 + 233129405880*f**7 + 213573843672*f**8 + 132279624960*f**9 + 54885973296*f**10 + 14643235068*f**11 + 2273631360*f**12 + 156312156*f**13))/3.1033743353252917e25,
    116: lambda f: -(f*(43743700 + 831715443*f + 9790259580*f**2 + 82869677373*f**3 + 542241097470*f**4 + 2094536368950*f**5 + 4848456504192*f**6 + 7144497226440*f**7 + 6972041318592*f**8 + 4574107012020*f**9 + 1998849116880*f**10 + 558577236756*f**11 + 90387777480*f**12 + 6447056616*f**13))/2.3792536570827235e27,
    117: lambda f: (f*(-1711710 - 30922177*f - 339556600*f**2 - 2664751102*f**3 - 16055810730*f**4 - 34227345285*f**5 - 1393204176*f**6 + 109072812240*f**7 + 205018748424*f**8 + 191975405580*f**9 + 106020018720*f**10 + 35063016912*f**11 + 6447561120*f**12 + 508540032*f**13))/9.576126520432329e27,
    118: lambda f: -(f*(11297286 + 224518801*f + 2776046680*f**2 + 24643698934*f**3 + 168917231970*f**4 + 633135608757*f**5 + 1385752160016*f**6 + 1920779816760*f**7 + 1766206720152*f**8 + 1096355523060*f**9 + 455504376096*f**10 + 121613915808*f**11 + 18888629760*f**12 + 1298593296*f**13))/6.70328856430263e27,
    119: lambda f: (f*(91861770 + 1841229143*f + 22880411040*f**2 + 204717655398*f**3 + 1417895754270*f**4 + 5630570083275*f**5 + 13209340921224*f**6 + 19604546420340*f**7 + 19210278251304*f**8 + 12634145497260*f**9 + 5529030312960*f**10 + 1546309904832*f**11 + 250304614560*f**12 + 17853387552*f**13))/1.713062633099561e29,
}

Q144withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (-5005 - 10140*f - 12786*f**2 - 7716*f**3 - 1929*f**4)/40040.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (5005 + 15210*f + 30753*f**2 + 36228*f**3 + 25407*f**4 + 9810*f**5 + 1635*f**6)/120120.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (-85085 - 344760*f - 959412*f**2 - 1676472*f**3 - 1929078*f**4 - 1463400*f**5 - 708420*f**6 - 199080*f**7 - 24885*f**8)/1.089088e7,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (323323 + 1637610*f + 5803341*f**2 + 13434216*f**3 + 21485694*f**4 + 24255468*f**5 + 19374090*f**6 + 10752840*f**7 + 3957975*f**8 + 871290*f**9 + 87129*f**10)/3.1039008e8,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (-1616615 - 9825660*f - 42296850*f**2 - 121880820*f**3 - 249566805*f**4 - 373967640*f**5 - 421197612*f**6 - 359784936*f**7 - 229068945*f**8 - 104419980*f**9 - 31969350*f**10 - 5871096*f**11 - 489258*f**12)/1.489872384e10,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (230945 + 1637610*f + 8295609*f**2 + 28601004*f**3 + 71380701*f**4 + 133315470*f**5 + 190026885*f**6 + 201748680*f**7 + 152493075*f**8 + 78303750*f**9 + 25769835*f**10 + 4892580*f**11 + 407715*f**12)/2.48312064e10,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (-1616615 - 13100880*f - 76333944*f**2 - 306374544*f**3 - 901885236*f**4 - 2017224720*f**5 - 3401842920*f**6 - 4095216720*f**7 - 3357380250*f**8 - 1809586800*f**9 - 611505720*f**10 - 117421920*f**11 - 9785160*f**12)/2.3837958144e12,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (1616615 + 14738490*f + 97090893*f**2 + 444608208*f**3 + 1507955292*f**4 + 3929075640*f**5 + 7509361860*f**6 + 9799619760*f**7 + 8419876290*f**8 + 4658679900*f**9 + 1596053970*f**10 + 308232540*f**11 + 25686045*f**12)/3.75447840768e13,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (-323323 - 3275220*f - 24068022*f**2 - 123826572*f**3 - 475433523*f**4 - 1414118736*f**5 - 2976417960*f**6 - 4107262320*f**7 - 3637963350*f**8 - 2046128280*f**9 - 706917708*f**10 - 136992240*f**11 - 11416020*f**12)/1.334925656064e14,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (146965 + 1637610*f + 13280145*f**2 + 75833940*f**3 + 325125435*f**4 + 1086938730*f**5 + 2469678327*f**6 + 3549931056*f**7 + 3211928370*f**8 + 1826877780*f**9 + 634762170*f**10 + 123293016*f**11 + 10274418*f**12)/1.2014330904576e15,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (-1616615 - 19651320*f - 174315348*f**2 - 1093954488*f**3 - 5180014422*f**4 - 19227475080*f**5 - 46486947540*f**6 - 68928579720*f**7 - 63352483425*f**8 - 36328446000*f**9 - 12674332440*f**10 - 2465860320*f**11 - 205488360*f**12)/2.88343941709824e17,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (124355 + 1637610*f + 15772413*f**2 + 107900088*f**3 + 559235322*f**4 + 2281987620*f**5 + 5808230670*f**6 + 8824911480*f**7 + 8209364625*f**8 + 4736758950*f**9 + 1657680255*f**10 + 322910280*f**11 + 26909190*f**12)/5.28630559801344e17,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (-230945 - 3275220*f - 34037094*f**2 - 252091164*f**3 - 1419438111*f**4 - 6315393240*f**5 - 16784284620*f**6 - 26008151400*f**7 - 24426008145*f**8 - 14162355900*f**9 - 4968248670*f**10 - 968730840*f**11 - 80727570*f**12)/2.537426687046451e19,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (323323 + 4912830*f + 54794043*f**2 + 436798068*f**3 + 2655030987*f**4 + 12791605554*f**5 + 35272035435*f**6 + 55547168040*f**7 + 52573350375*f**8 + 30602041470*f**9 + 10756232487*f**10 + 2098916820*f**11 + 174909735*f**12)/9.89596407948116e20,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (-1616615 - 26201760*f - 312173040*f**2 - 2664982560*f**3 - 17392006440*f**4 - 90203893920*f**5 - 256763618832*f**6 - 409866571296*f**7 - 390414662820*f**8 - 227987803680*f**9 - 80262458640*f**10 - 15671912256*f**11 - 1305992688*f**12)/1.4777973025358532e23,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: (95095 + 1637610*f + 20756949*f**2 + 188931744*f**3 + 1317580536*f**4 + 7319349360*f**5 + 21419361480*f**6 + 34586324640*f**7 + 33122672100*f**8 + 19394739000*f**9 + 6836946480*f**10 + 1335674340*f**11 + 111306195*f**12)/2.7708699422547247e23,
    51: lambda f: 0,
    52: lambda f: 0,
    53: lambda f: (-1616615 - 29476980*f - 396055494*f**2 - 3828786444*f**3 - 28415555811*f**4 - 168327050400*f**5 - 504729291600*f**6 - 823081966560*f**7 - 791874751500*f**8 - 464741852400*f**9 - 164013527160*f**10 - 32056184160*f**11 - 2671348680*f**12)/1.5960210867387213e26,
    54: lambda f: 0,
    55: lambda f: 0,
    56: lambda f: (5005 + 96330*f + 1367601*f**2 + 13993956*f**3 + 110122119*f**4 + 692929890*f**5 + 2123037915*f**6 + 3491923680*f**7 + 3372847380*f**8 + 1983395400*f**9 + 700644420*f**10 + 136992240*f**11 + 11416020*f**12)/1.7733567630430238e25,
    57: lambda f: 0,
    58: lambda f: 0,
    59: lambda f: (-19019 - 385320*f - 5763612*f**2 - 62233512*f**3 - 517593858*f**4 - 3447684216*f**5 - 10768327020*f**6 - 17845039800*f**7 - 17296046775*f**8 - 10188370080*f**9 - 3602119248*f**10 - 704531520*f**11 - 58710960*f**12)/2.553633738781954e27,
    60: lambda f: 0,
    61: lambda f: 0,
    62: lambda f: 0,
    63: lambda f: (10010 + 12675*f + 8928*f**2 + 1929*f**3)/60060.,
    64: lambda f: (210210 + 346255*f + 330384*f**2 + 144093*f**3 + 21216*f**4)/1.26126e6,
    65: lambda f: (-385385 - 585585*f - 591126*f**2 - 298995*f**3 - 75231*f**4)/1.54154e6,
    66: lambda f: (-10010 - 22815*f - 33288*f**2 - 25830*f**3 - 10398*f**4 - 1635*f**5)/120120.,
    67: lambda f: (-210210 - 559195*f - 964248*f**2 - 957918*f**3 - 552630*f**4 - 169935*f**5 - 20880*f**6)/2.52252e6,
    68: lambda f: (385385 + 975975*f + 1677519*f**2 + 1695702*f**3 + 1057635*f**4 + 380955*f**5 + 63765*f**6)/3.08308e6,
    69: lambda f: (170170 + 560235*f + 1242360*f**2 + 1663671*f**3 + 1396458*f**4 + 715545*f**5 + 204900*f**6 + 24885*f**7)/8.16816e6,
    70: lambda f: (3573570 + 13126295*f + 32677128*f**2 + 50844195*f**3 + 51688914*f**4 + 34279965*f**5 + 14278500*f**6 + 3378585*f**7 + 342720*f**8)/1.7153136e8,
    71: lambda f: (-6551545 - 23228205*f - 57086748*f**2 - 88353777*f**3 - 91114344*f**4 - 63027855*f**5 - 28535280*f**6 - 7739235*f**7 - 970515*f**8)/2.0964944e8,
    72: lambda f: (-3233230 - 13919685*f - 41442192*f**2 - 78872724*f**3 - 101109564*f**4 - 88443270*f**5 - 52208160*f**6 - 19911780*f**7 - 4430790*f**8 - 435645*f**9)/9.3117024e8,
    73: lambda f: (-67897830 - 318179225*f - 1034954016*f**2 - 2193881892*f**3 - 3202503276*f**4 - 3283010910*f**5 - 2364096960*f**6 - 1172225460*f**7 - 381092670*f**8 - 73020465*f**9 - 6224400*f**10)/1.955457504e10,
    74: lambda f: (124479355 + 567431865*f + 1819362423*f**2 + 3814918116*f**3 + 5554700046*f**4 + 5753556990*f**5 + 4264138590*f**6 + 2228192820*f**7 + 786286935*f**8 + 169465905*f**9 + 16990155*f**10)/2.390003616e10,
    75: lambda f: (646646 + 3438981*f + 12852816*f**2 + 31716339*f**3 + 54761268*f**4 + 67885026*f**5 + 60971976*f**6 + 39430230*f**7 + 17924550*f**8 + 5439945*f**9 + 989688*f**10 + 81543*f**11)/1.489872384e9,
    76: lambda f: (67897830 + 386958845*f + 1553717856*f**2 + 4170377355*f**3 + 7942353780*f**4 + 11036258130*f**5 + 11334994920*f**6 + 8612973894*f**7 + 4786448310*f**8 + 1892021985*f**9 + 503826120*f**10 + 80966655*f**11 + 5920992*f**12)/1.5643660032e11,
    77: lambda f: (-24895871 - 138705567*f - 549196254*f**2 - 1456322697*f**3 - 2751287571*f**4 - 3819281286*f**5 - 3958626732*f**6 - 3074887074*f**7 - 1774483725*f**8 - 742121835*f**9 - 213694278*f**10 - 38080581*f**11 - 3180177*f**12)/3.8240057856e10,
    78: lambda f: (-74364290 - 470812875*f - 2117621592*f**2 - 6421285866*f**3 - 13948817130*f**4 - 22399406865*f**5 - 27049987200*f**6 - 24722502588*f**7 - 17040813174*f**8 - 8729450205*f**9 - 3225113640*f**10 - 812674170*f**11 - 125025054*f**12 - 8855847*f**13)/1.7133532416e12,
    79: lambda f: (-1561650090 - 10481984695*f - 50074609896*f**2 - 162678295602*f**3 - 382305657714*f**4 - 671035045365*f**5 - 896289747120*f**6 - 919541625324*f**7 - 725509319598*f**8 - 437075193681*f**9 - 197594223960*f**10 - 64918860930*f**11 - 14635116342*f**12 - 2023760739*f**13 - 129297168*f**14)/3.59804180736e13,
    80: lambda f: (2863025165 + 18851347515*f + 88883609319*f**2 + 285294772650*f**3 + 663852065049*f**4 + 1158738658065*f**5 + 1548829374915*f**6 + 1602864232956*f**7 + 1287931298535*f**8 + 799097086221*f**9 + 376906007205*f**10 + 131114858490*f**11 + 31821870003*f**12 + 4826436615*f**13 + 345378033*f**14)/4.39760665344e13,
    81: lambda f: (74364290 + 546142935*f + 2871813672*f**2 + 10330135935*f**3 + 27049813182*f**4 + 53361156555*f**5 + 79795898700*f**6 + 89314166403*f**7 + 73363193694*f**8 + 43193192805*f**9 + 17643470040*f**10 + 4735383345*f**11 + 750150324*f**12 + 53135082*f**13)/2.05602388992e13,
    82: lambda f: (1561650090 + 12063915955*f + 66821239992*f**2 + 254819328267*f**3 + 712527883830*f**4 + 1511755748055*f**5 + 2461984974540*f**6 + 3062850845439*f**7 + 2874787349238*f**8 + 2003292991161*f**9 + 1014608556360*f**10 + 361579669605*f**11 + 85767955812*f**12 + 12142564434*f**13 + 775783008*f**14)/4.317650168832e14,
    83: lambda f: (-2863025165 - 21751554825*f - 119023456056*f**2 - 448678295793*f**3 - 1241632957950*f**4 - 2614641044085*f**5 - 4241642388900*f**6 - 5287243206861*f**7 - 5021933629860*f**8 - 3592376668251*f**9 - 1900628884980*f**10 - 721000148715*f**11 - 185445414693*f**12 - 28958619690*f**13 - 2072268198*f**14)/5.277127984128e14,
    84: lambda f: (-74364290 - 621472995*f - 3740650080*f**2 - 15568271832*f**3 - 47719005096*f**4 - 111662480580*f**5 - 195786561600*f**6 - 248932672968*f**7 - 224264807004*f**8 - 140578979730*f**9 - 59760398040*f**10 - 16409736420*f**11 - 2625526134*f**12 - 185972787*f**13)/2.878433445888e14,
    85: lambda f: (-1561650090 - 13645847215*f - 85975400976*f**2 - 376422972600*f**3 - 1220624390088*f**4 - 3037668404820*f**5 - 5763330961920*f**6 - 8150389550184*f**7 - 8437272164748*f**8 - 6308768094426*f**9 - 3353350575960*f**10 - 1232939764980*f**11 - 297804646062*f**12 - 42498975519*f**13 - 2715240528*f**14)/6.0447102363648e15,
    86: lambda f: (2863025165 + 24651762135*f + 153577109421*f**2 + 665109871224*f**3 + 2134651308948*f**4 + 5268565110900*f**5 + 9925473173700*f**6 + 14004301768296*f**7 + 14625220566390*f**8 + 11216218199466*f**9 + 6235818437730*f**10 + 2446863351240*f**11 + 642658845213*f**12 + 101355168915*f**13 + 7252938693*f**14)/7.3879791777792e15,
    87: lambda f: (74364290 + 696803055*f + 4724130816*f**2 + 22330036197*f**3 + 78422855832*f**4 + 212336480700*f**5 + 420719159280*f**6 + 583053397668*f**7 + 555648800364*f**8 + 360841204290*f**9 + 156705398640*f**10 + 43540490070*f**11 + 7001403024*f**12 + 495927432*f**13)/4.6054935134208e15,
    88: lambda f: (1561650090 + 15227778475*f + 107537092848*f**2 + 531570424041*f**3 + 1961186579928*f**4 + 5600941221420*f**5 + 11985438524400*f**6 + 18539221804404*f**7 + 20413125494748*f**8 + 15902046812106*f**9 + 8679898545360*f**10 + 3244387268430*f**11 + 790968123792*f**12 + 113330601384*f**13 + 7240641408*f**14)/9.67153637818368e16,
    89: lambda f: (-2863025165 - 27551969445*f - 192544569414*f**2 - 942071690583*f**3 - 3441215363463*f**4 - 9744735639060*f**5 - 20652140802360*f**6 - 31774375526796*f**7 - 35228043977490*f**8 - 28136827026966*f**9 - 16077319507620*f**10 - 6422786044290*f**11 - 1705223445618*f**12 - 270280450440*f**13 - 19341169848*f**14)/1.182076668444672e17,
    90: lambda f: (-74364290 - 772133115*f - 5822255880*f**2 - 30809771670*f**3 - 121975820190*f**4 - 375120176355*f**5 - 818554573440*f**6 - 1206524968488*f**7 - 1193838404724*f**8 - 793028175030*f**9 - 349002002160*f**10 - 97670713140*f**11 - 15753156804*f**12 - 1115836722*f**13)/8.28988832415744e16,
    91: lambda f: (-1561650090 - 16809709735*f - 131506315608*f**2 - 724342878030*f**3 - 2996113685430*f**4 - 9657704907855*f**5 - 22767875070480*f**6 - 37605009314376*f**7 - 43184542423428*f**8 - 34549910937486*f**9 - 19176775243920*f**10 - 7241211012420*f**11 - 1775388519828*f**12 - 254993853114*f**13 - 16291443168*f**14)/1.7408765480730624e18,
    92: lambda f: (2863025165 + 30452176755*f + 235925836035*f**2 + 1287045945510*f**3 + 5273031052755*f**4 + 16854650458155*f**5 + 39264531620445*f**6 + 64354050925416*f**7 + 74315967659010*f**8 + 60946932591846*f**9 + 35432686349550*f**10 + 14313321694980*f**11 + 3825232561458*f**12 + 608131013490*f**13 + 43517632158*f**14)/2.1277380032004096e18,
    93: lambda f: (74364290 + 847463175*f + 7035025272*f**2 + 41201820891*f**3 + 181540344810*f**4 + 625095774105*f**5 + 1474620948900*f**6 + 2276090348301*f**7 + 2313330213348*f**8 + 1560983795910*f**9 + 693223811280*f**10 + 194947573590*f**11 + 31506313608*f**12 + 2231673444*f**13)/1.657977664831488e18,
    94: lambda f: (1561650090 + 18391640995*f + 157883069256*f**2 + 958821530007*f**3 + 4394612767314*f**4 + 15781519336605*f**5 + 40279550776740*f**6 + 69925908494673*f**7 + 82776972782196*f**8 + 67473665120862*f**9 + 37884033799920*f**10 + 14404208236110*f**11 + 3545057361384*f**12 + 509987706228*f**13 + 32582886336*f**14)/3.481753096146125e19,
    95: lambda f: (-2863025165 - 33352384065*f - 283720909284*f**2 - 1707514827645*f**3 - 7755201993924*f**4 - 27621769320255*f**5 - 69527639503080*f**6 - 119549633297787*f**7 - 142174075334445*f**8 - 118777142618442*f**9 - 69880122164160*f**10 - 28442714183730*f**11 - 7635104868006*f**12 - 1216262026980*f**13 - 87035264316*f**14)/4.255476006400819e19,
    96: lambda f: (-74364290 - 922793235*f - 8362438992*f**2 - 53700526500*f**3 - 260626868172*f**4 - 993331937070*f**5 - 2498717258400*f**6 - 3996907917156*f**7 - 4144547460438*f**8 - 2829049246485*f**9 - 1264650544080*f**10 - 356888125440*f**11 - 57761574948*f**12 - 4091401314*f**13)/3.6475508626292736e19,
    97: lambda f: (-1561650090 - 19973572255*f - 186667353792*f**2 - 1239087575412*f**3 - 6233198714940*f**4 - 24676840200870*f**5 - 67293604762560*f**6 - 121466467535028*f**7 - 147120342541326*f**8 - 121585424241897*f**9 - 68840343522720*f**10 - 26305292280960*f**11 - 6491781774324*f**12 - 934977461418*f**13 - 59735291616*f**14)/7.659856811521475e20,
    98: lambda f: (2863025165 + 36252591375*f + 335929789161*f**2 + 2210960528628*f**3 + 11026229489910*f**4 + 43306202773350*f**5 + 116259606111990*f**6 + 207530614925172*f**7 + 252331178656095*f**8 + 213707297303577*f**9 + 126826418630835*f**10 + 51904116328680*f**11 + 13977577638486*f**12 + 2229813716130*f**13 + 159564651246*f**14)/9.362047214081802e20,
    99: lambda f: (74364290 + 998123295*f + 9804497040*f**2 + 68500231137*f**3 + 363093820596*f**4 + 1517525054370*f**5 + 4028216867400*f**6 + 6629072554566*f**7 + 6981593299758*f**8 + 4807764662085*f**9 + 2159924077080*f**10 + 611145095715*f**11 + 99019842768*f**12 + 7013830824*f**13)/8.754122070310257e20,
    100: lambda f: (1561650090 + 21555503515*f + 217859169216*f**2 + 1569222209685*f**3 + 8595694246308*f**4 + 37192485672810*f**5 + 107262291264840*f**6 + 199761523467198*f**7 + 246310275201606*f**8 + 205724400781977*f**9 + 117224075734920*f**10 + 44963100286335*f**11 + 11119138685424*f**12 + 1602818505288*f**13 + 102403357056*f**14)/1.8383656347651539e22,
    101: lambda f: (-2863025165 - 39152798685*f - 392552475666*f**2 - 2804865240099*f**3 - 15238012529493*f**4 - 65429401034790*f**5 - 185462761152540*f**6 - 341143143093522*f**7 - 422004025206225*f**8 - 361177823505807*f**9 - 215764895440710*f**10 - 88668808410105*f**11 - 23935700012301*f**12 - 3822537799080*f**13 - 273539402136*f**14)/2.2468913313796325e22,
    102: lambda f: (-74364290 - 1073453355*f - 11361199416*f**2 - 85795277442*f**3 - 493147624242*f**4 - 2242640510565*f**5 - 6231171098880*f**6 - 10494136721796*f**7 - 11190004083258*f**8 - 7759570813995*f**9 - 3499704488280*f**10 - 992272671390*f**11 - 160907244498*f**12 - 11397475089*f**13)/2.2760717382806667e22,
    103: lambda f: (-1561650090 - 23137434775*f - 251458515528*f**2 - 1953306628266*f**3 - 11573229908058*f**4 - 54335103061785*f**5 - 164391865812720*f**6 - 314100099231828*f**7 - 392869313185986*f**8 - 330893192196567*f**9 - 189494389604520*f**10 - 72898600885110*f**11 - 18056429024634*f**12 - 2604580071093*f**13 - 166405455216*f**14)/4.7797506503894e23,
    104: lambda f: (2863025165 + 42053005995*f + 453588968799*f**2 + 3496711153698*f**3 + 20555847787293*f**4 + 95798842864725*f**5 + 284454662630775*f**6 + 536223488150532*f**7 + 672541506498225*f**8 + 580401088934667*f**9 + 348533339829675*f**10 + 143695416694830*f**11 + 38862826263261*f**12 + 6211623923505*f**13 + 444501528471*f**14)/5.841917461587045e23,
    105: lambda f: (74364290 + 1148783415*f + 13032546120*f**2 + 105780008055*f**3 + 655342693110*f**4 + 3221553955095*f**5 + 9309412798140*f**6 + 15981631544151*f**7 + 17214502639698*f**8 + 12004510789635*f**9 + 5431326100200*f**10 + 1542492286335*f**11 + 250300158108*f**12 + 17729405694*f**13)/6.373000867185867e23,
    106: lambda f: (1561650090 + 24719366035*f + 287465392728*f**2 + 2395422026595*f**3 + 15264244075470*f**4 + 77282635472595*f**5 + 243717471402300*f**6 + 475709300745315*f**7 + 602008139231226*f**8 + 510494068287567*f**9 + 293532317977080*f**10 + 113190701899275*f**11 + 28072631927340*f**12 + 4051568999478*f**13 + 258852930336*f**14)/1.338330182109032e25,
    107: lambda f: (-2863025165 - 44953213305*f - 519039268560*f**2 - 4293980461065*f**3 - 27158429623770*f**4 - 136532724439545*f**5 - 421999137110460*f**6 - 811911511562697*f**7 - 1029868865977770*f**8 - 894772756339917*f**9 - 539571946111380*f**10 - 223039131960645*f**11 - 60412609067811*f**12 - 9662526103230*f**13 - 691446822066*f**14)/1.6357368892443725e25,
    108: lambda f: (-74364290 - 1224113475*f - 14818537152*f**2 - 128648765616*f**3 - 854581433040*f**4 - 4515692571720*f**5 - 13501659897600*f**6 - 23555587893264*f**7 - 25586751553272*f**8 - 17925931672740*f**9 - 8131453522920*f**10 - 2312458408260*f**11 - 375450237162*f**12 - 26594108541*f**13)/1.91190026015576e25,
    109: lambda f: (-1561650090 - 26301297295*f - 325879800816*f**2 - 2899649600112*f**3 - 19774482952464*f**4 - 107397788463720*f**5 - 351178024671360*f**6 - 697938213966672*f**7 - 891886797779544*f**8 - 760565258575668*f**9 - 438781853207880*f**10 - 169531858035540*f**11 - 42090358936626*f**12 - 6077353499217*f**13 - 388279395504*f**14)/4.0149905463270964e26,
    110: lambda f: (2863025165 + 47853420615*f + 588903374949*f**2 + 5204155353840*f**3 + 35237850085224*f**4 + 190084648225320*f**5 + 608437319970120*f**6 + 1190964133972368*f**7 + 1524931907023980*f**8 + 1332283137700788*f**9 + 806181255210240*f**10 + 333960928020720*f**11 + 90568992773259*f**12 + 14493789154845*f**13 + 1037170233099*f**14)/4.9072106677331175e26,
    111: lambda f: (74364290 + 1299443535*f + 16719172512*f**2 + 154595892765*f**3 + 1096114241712*f**4 + 6195676347960*f**5 + 19086618981600*f**6 + 33761057469384*f**7 + 36933106442232*f**8 + 25976186223540*f**9 + 11808737697120*f**10 + 3362024325660*f**11 + 546109435872*f**12 + 38682339696*f**13)/6.118080832498432e26,
    112: lambda f: (1561650090 + 27883228555*f + 366701739792*f**2 + 3470070544257*f**3 + 25217000571600*f**4 + 146241496705560*f**5 + 493691102074080*f**6 + 996441801964392*f**7 + 1283875916370264*f**8 + 1100017239672708*f**9 + 636391032994080*f**10 + 246283678580940*f**11 + 61199808205536*f**12 + 8839786907952*f**13 + 564770029824*f**14)/1.2847969748246708e28,
    113: lambda f: (-2863025165 - 50753627925*f - 663181287966*f**2 - 6234718023663*f**3 - 44999598903795*f**4 - 259268311851240*f**5 - 855818695660080*f**6 - 1700068803254808*f**7 - 2194141200950580*f**8 - 1925928548415228*f**9 - 1168780094194440*f**10 - 485036780248020*f**11 - 131676206666004*f**12 - 21081875134320*f**13 - 1508611248144*f**14)/1.5703074136745976e28,
    114: lambda f: (-4374370 - 80869035*f - 1102026600*f**2 - 10812690126*f**3 - 81502324038*f**4 - 490703490855*f**5 - 1552122873600*f**6 - 2778272581392*f**7 - 3057786425736*f**8 - 2157784385820*f**9 - 982733643360*f**10 - 280059290280*f**11 - 45509119656*f**12 - 3223528308*f**13)/1.2236161664996864e27,
    115: lambda f: (-91861770 - 1733244695*f - 24113600568*f**2 - 241809767910*f**3 - 1865421105534*f**4 - 11505081802275*f**5 - 39954578003280*f**6 - 81727341293136*f**7 - 106048113354792*f**8 - 91227589567884*f**9 - 52903119188640*f**10 - 20501913829320*f**11 - 5098395217608*f**12 - 736648908996*f**13 - 47064169152*f**14)/2.5695939496493417e28,
    116: lambda f: (168413245 + 3156107955*f + 43639588683*f**2 + 434891215422*f**3 + 3333091970439*f**4 + 20428364528415*f**5 + 69296008115265*f**6 + 139420997798544*f**7 + 181165664412180*f**8 + 159654274205244*f**9 + 97127265635820*f**10 + 40368640241160*f**11 + 10968750484692*f**12 + 1756822927860*f**13 + 125717604012*f**14)/3.140614827349195e28,
    117: lambda f: (4374370 + 85300215*f + 1227316248*f**2 + 12735448611*f**3 + 101694330306*f**4 + 649733586165*f**5 + 2104003769940*f**6 + 3805351396497*f**7 + 4210208321256*f**8 + 2979520343100*f**9 + 1359132233760*f**10 + 387644560380*f**11 + 63012627216*f**12 + 4463346888*f**13)/4.405018199398871e28,
    118: lambda f: (91861770 + 1826299475*f + 26798130024*f**2 + 283871607423*f**3 + 2316919253514*f**4 + 15142956654825*f**5 + 53934573601620*f**6 + 111619154265381*f**7 + 145722840451272*f**8 + 125793202378284*f**9 + 73096895219040*f**10 + 28361480536620*f**11 + 7057430846928*f**12 + 1019975412456*f**13 + 65165772672*f**14)/9.250538218737629e29,
    119: lambda f: (-168413245 - 3326708385*f - 48528149052*f**2 - 510996203589*f**3 - 4144648762944*f**4 - 26925544599795*f**5 - 93584526484320*f**6 - 190395148143879*f**7 - 248860583551755*f**8 - 220065168336804*f**9 - 134162396353440*f**10 - 55834404331860*f**11 - 15182436850812*f**12 - 2432524053960*f**13 - 174070528632*f**14)/1.1306213378457103e30,
}

Q000withhex20 = {
    0: lambda f: (-3 - 2*f - f**2)/6.,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (15 + 20*f + 22*f**2 + 12*f**3 + 3*f**4)/120.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: (-35 - 70*f - 119*f**2 - 124*f**3 - 81*f**4 - 30*f**5 - 5*f**6)/1680.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (0.125 + (f*(2 + f))/6. + (3*f**2*(2 + f)**2)/20. + (f**3*(2 + f)**3)/14. + (f**4*(2 + f)**4)/72.)/48.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: (-0.0625 - (5*f*(2 + f))/48. - (f**2*(2 + f)**2)/8. - (5*f**3*(2 + f)**3)/56. - (5*f**4*(2 + f)**4)/144. - (f**5*(2 + f)**5)/176.)/240.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (0.03125 + (f*(2 + f))/16. + (3*f**2*(2 + f)**2)/32. + (5*f**3*(2 + f)**3)/56. + (5*f**4*(2 + f)**4)/96. + (3*f**5*(2 + f)**5)/176.)/1440.,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: (-495 - 1155*f*(2 + f) - 2079*f**2*(2 + f)**2 - 2475*f**3*(2 + f)**3 - 1925*f**4*(2 + f)**4 - 945*f**5*(2 + f)**5)/3.193344e8,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (0.0078125 + (f*(2 + f))/48. + (7*f**2*(2 + f)**2)/160. + (f**3*(2 + f)**3)/16. + (35*f**4*(2 + f)**4)/576. + (7*f**5*(2 + f)**5)/176.)/80640.,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: (-55 - 165*f*(2 + f) - 396*f**2*(2 + f)**2 - 660*f**3*(2 + f)**3 - 770*f**4*(2 + f)**4 - 630*f**5*(2 + f)**5)/1.02187008e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (231 + 770*f*(2 + f) + 2079*f**2*(2 + f)**2 + 3960*f**3*(2 + f)**3 + 5390*f**4*(2 + f)**4 + 5292*f**5*(2 + f)**5)/8.583708672e11,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: (-21 - 77*f*(2 + f) - 231*f**2*(2 + f)**2 - 495*f**3*(2 + f)**3 - 770*f**4*(2 + f)**4 - 882*f**5*(2 + f)**5)/1.7167417344e12,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (105 + 420*f*(2 + f) + 1386*f**2*(2 + f)**2 + 3300*f**3*(2 + f)**3 + 5775*f**4*(2 + f)**4 + 7560*f**5*(2 + f)**5)/2.06009008128e14,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: (-315 - 1365*f*(2 + f) - 4914*f**2*(2 + f)**2 - 12870*f**3*(2 + f)**3 - 25025*f**4*(2 + f)**4 - 36855*f**5*(2 + f)**5)/1.6068702633984e16,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (45 + 210*f*(2 + f) + 819*f**2*(2 + f)**2 + 2340*f**3*(2 + f)**3 + 5005*f**4*(2 + f)**4 + 8190*f**5*(2 + f)**5)/6.4274810535936e16,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: (-3 - 30*f - 267*f**2 - 1812*f**3 - 9683*f**4 - 41938*f**5 - 76635*f**6 - 69160*f**7 - 33215*f**8 - 8190*f**9 - 819*f**10)/1.28549621071872e17,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (99 + 528*f*(2 + f) + 2376*f**2*(2 + f)**2 + 7920*f**3*(2 + f)**3 + 20020*f**4*(2 + f)**4 + 39312*f**5*(2 + f)**5)/1.3574839985189683e20,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: (-3465 - 19635*f*(2 + f) - 94248*f**2*(2 + f)**2 - 336600*f**3*(2 + f)**3 - 916300*f**4*(2 + f)**4 - 1949220*f**5*(2 + f)**5)/1.6154059582375723e23,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (385 + 2310*f*(2 + f) + 11781*f**2*(2 + f)**2 + 44880*f**3*(2 + f)**3 + 130900*f**4*(2 + f)**4 + 299880*f**5*(2 + f)**5)/6.461623832950289e23,
    52: lambda f: 0,
    53: lambda f: 0,
    54: lambda f: (-1155 - 7315*f*(2 + f) - 39501*f**2*(2 + f)**2 - 159885*f**3*(2 + f)**3 - 497420*f**4*(2 + f)**4 - 1220940*f**5*(2 + f)**5)/7.36625116956333e25,
    55: lambda f: 0,
    56: lambda f: 0,
    57: lambda f: (693 + 4620*f*(2 + f) + 26334*f**2*(2 + f)**2 + 112860*f**3*(2 + f)**3 + 373065*f**4*(2 + f)**4 + 976752*f**5*(2 + f)**5)/1.767900280695199e27,
    58: lambda f: 0,
    59: lambda f: 0,
    60: lambda f: (-3 - 2*f - f**2)/18.,
    61: lambda f: (15 + 10*f + 2*f**2)/45.,
    62: lambda f: 0,
    63: lambda f: (15 + 20*f + 22*f**2 + 12*f**3 + 3*f**4)/180.,
    64: lambda f: (-105 - 140*f - 133*f**2 - 66*f**3 - 12*f**4)/630.,
    65: lambda f: 0,
    66: lambda f: (-35 - 70*f - 119*f**2 - 124*f**3 - 81*f**4 - 30*f**5 - 5*f**6)/1680.,
    67: lambda f: (105 + 210*f + 336*f**2 + 336*f**3 + 205*f**4 + 70*f**5 + 10*f**6)/2520.,
    68: lambda f: 0,
    69: lambda f: (315 + 840*f + 1932*f**2 + 2952*f**3 + 3098*f**4 + 2200*f**5 + 1020*f**6 + 280*f**7 + 35*f**8)/90720.,
    70: lambda f: (-3465 - 9240*f - 20559*f**2 - 30690*f**3 - 31207*f**4 - 21380*f**5 - 9465*f**6 - 2450*f**7 - 280*f**8)/498960.,
    71: lambda f: 0,
    72: lambda f: (-693 - 2310*f - 6699*f**2 - 13464*f**3 - 19426*f**4 - 20276*f**5 - 15270*f**6 - 8120*f**7 - 2905*f**8 - 630*f**9 - 63*f**10)/1.596672e6,
    73: lambda f: (45045 + 150150*f + 426426*f**2 + 844272*f**3 + 1195766*f**4 + 1222780*f**5 + 899040*f**6 + 464800*f**7 + 160685*f**8 + 33390*f**9 + 3150*f**10)/5.189184e7,
    74: lambda f: 0,
    75: lambda f: (3003 + 12012*f + 42042*f**2 + 104676*f**3 + 192049*f**4 + 264056*f**5 + 274524*f**6 + 215432*f**7 + 125965*f**8 + 53340*f**9 + 15498*f**10 + 2772*f**11 + 231*f**12)/6.918912e7,
    76: lambda f: (-15015 - 60060*f - 207207*f**2 - 510510*f**3 - 925210*f**4 - 1255280*f**5 - 1285670*f**6 - 992068*f**7 - 568995*f**8 - 235620*f**9 - 66675*f**10 - 11550*f**11 - 924*f**12)/1.729728e8,
    77: lambda f: 0,
    78: lambda f: (-6435 - 30030*f - 123123*f**2 - 365508*f**3 - 813527*f**4 - 1386970*f**5 - 1805655*f**6 - 1753240*f**7 - 1229225*f**8 - 598050*f**9 - 190485*f**10 - 35640*f**11 - 2970*f**12)/1.7791488e9,
    79: lambda f: (45045 + 210210*f + 852852*f**2 + 2512224*f**3 + 5542823*f**4 + 9361690*f**5 + 12053010*f**6 + 11522224*f**7 + 7904435*f**8 + 3740310*f**9 + 1152900*f**10 + 207900*f**11 + 16632*f**12)/6.2270208e9,
    80: lambda f: 0,
    81: lambda f: (6435 + 34320*f + 161304*f**2 + 555984*f**3 + 1454596*f**4 + 2958800*f**5 + 4538760*f**6 + 5017040*f**7 + 3855250*f**8 + 1990800*f**9 + 656460*f**10 + 124740*f**11 + 10395*f**12)/2.49080832e10,
    82: lambda f: (-6435 - 34320*f - 160017*f**2 - 548262*f**3 - 1424995*f**4 - 2878460*f**5 - 4374825*f**6 - 4758362*f**7 - 3568705*f**8 - 1786680*f**9 - 568575*f**10 - 103950*f**11 - 8316*f**12)/1.24540416e10,
    83: lambda f: 0,
    84: lambda f: (-715 - 4290*f - 22737*f**2 - 89232*f**3 - 268268*f**4 - 633880*f**5 - 1101140*f**6 - 1326640*f**7 - 1076810*f**8 - 574700*f**9 - 192990*f**10 - 36960*f**11 - 3080*f**12)/4.42810368e10,
    85: lambda f: (15015 + 90090*f + 474474*f**2 + 1853280*f**3 + 5543252*f**4 + 13027560*f**5 + 22445360*f**6 + 26587008*f**7 + 21023450*f**8 + 10857420*f**9 + 3513300*f**10 + 646800*f**11 + 51744*f**12)/4.649508864e11,
    86: lambda f: 0,
    87: lambda f: (3003 + 20020*f + 118118*f**2 + 519948*f**3 + 1765907*f**4 + 4752592*f**5 + 9099624*f**6 + 11652592*f**7 + 9807350*f**8 + 5344920*f**9 + 1815156*f**10 + 349272*f**11 + 29106*f**12)/3.34764638208e12,
    88: lambda f: (-15015 - 100100*f - 587587*f**2 - 2576574*f**3 - 8714992*f**4 - 23354240*f**5 - 44378700*f**6 - 55832168*f**7 - 45717490*f**8 - 24078600*f**9 - 7871850*f**10 - 1455300*f**11 - 116424*f**12)/8.3691159552e12,
    89: lambda f: 0,
    90: lambda f: (-273 - 2002*f - 13013*f**2 - 63492*f**3 - 240383*f**4 - 725842*f**5 - 1502643*f**6 - 2013424*f**7 - 1738730*f**8 - 961380*f**9 - 328986*f**10 - 63504*f**11 - 5292*f**12)/6.0866297856e12,
    91: lambda f: (15015 + 110110*f + 712712*f**2 + 3466320*f**3 + 13079495*f**4 + 39355810*f**5 + 80899590*f**6 + 106431136*f**7 + 89330990*f**8 + 47689740*f**9 + 15699600*f**10 + 2910600*f**11 + 232848*f**12)/1.67382319104e14,
    92: lambda f: 0,
    93: lambda f: (455 + 3640*f + 25844*f**2 + 138424*f**3 + 578006*f**4 + 1934920*f**5 + 4270580*f**6 + 5925640*f**7 + 5216225*f**8 + 2914800*f**9 + 1002960*f**10 + 194040*f**11 + 16170*f**12)/2.23176425472e14,
    94: lambda f: (-1365 - 10920*f - 77259*f**2 - 412698*f**3 - 1718431*f**4 - 5735860*f**5 - 12575065*f**6 - 17123106*f**7 - 14638890*f**8 - 7892640*f**9 - 2611350*f**10 - 485100*f**11 - 38808*f**12)/3.34764638208e14,
    95: lambda f: 0,
    96: lambda f: (-4095 - 35490*f - 273273*f**2 - 1594008*f**3 - 7276802*f**4 - 26745940*f**5 - 62271030*f**6 - 88831960*f**7 - 79365125*f**8 - 44707950*f**9 - 15447915*f**10 - 2993760*f**11 - 249480*f**12)/4.8206107901952e16,
    97: lambda f: (4095 + 35490*f + 272454*f**2 + 1585584*f**3 + 7221110*f**4 + 26476060*f**5 + 61250160*f**6 + 85710688*f**7 + 74325545*f**8 + 40376070*f**9 + 13409550*f**10 + 2494800*f**11 + 199584*f**12)/2.4103053950976e16,
    98: lambda f: 0,
    99: lambda f: (45 + 420*f + 3486*f**2 + 21996*f**3 + 108979*f**4 + 436280*f**5 + 1062780*f**6 + 1550600*f**7 + 1401805*f**8 + 794700*f**9 + 275490*f**10 + 53460*f**11 + 4455*f**12)/1.3773173686272e16,
    100: lambda f: (-315 - 2940*f - 24339*f**2 - 153270*f**3 - 757822*f**4 - 3027440*f**5 - 7329930*f**6 - 10487036*f**7 - 9197545*f**8 - 5026140*f**9 - 1674225*f**10 - 311850*f**11 - 24948*f**12)/4.8206107901952e16,
    101: lambda f: 0,
    102: lambda f: (-3 - 30*f - 267*f**2 - 1812*f**3 - 9683*f**4 - 41938*f**5 - 106203*f**6 - 157864*f**7 - 144095*f**8 - 82110*f**9 - 28539*f**10 - 5544*f**11 - 462*f**12)/2.57099242143744e16,
    103: lambda f: (165 + 1650*f + 14652*f**2 + 99264*f**3 + 529507*f**4 + 2289170*f**5 + 5763170*f**6 + 8398096*f**7 + 7433685*f**8 + 4081770*f**9 + 1362900*f**10 + 254100*f**11 + 20328*f**12)/7.07022915895296e17,
    104: lambda f: 0,
    105: lambda f: (99 + 1056*f + 10032*f**2 + 72864*f**3 + 417736*f**4 + 1946144*f**5 + 5096976*f**6 + 7695968*f**7 + 7081060*f**8 + 4052160*f**9 + 1411452*f**10 + 274428*f**11 + 22869*f**12)/2.5452824972230656e19,
    106: lambda f: (-3465 - 36960*f - 350427*f**2 - 2541330*f**3 - 14547005*f**4 - 67663540*f**5 - 176215935*f**6 - 260774374*f**7 - 232601285*f**8 - 128225160*f**9 - 42898275*f**10 - 8004150*f**11 - 640332*f**12)/4.454244370140365e20,
    107: lambda f: 0,
    108: lambda f: (-3465 - 39270*f - 396627*f**2 - 3069792*f**3 - 18794248*f**4 - 93716240*f**5 - 252776760*f**6 - 386802080*f**7 - 358302700*f**8 - 205770600*f**9 - 71803620*f**10 - 13970880*f**11 - 1164240*f**12)/2.8507163968898335e22,
    109: lambda f: (3465 + 39270*f + 395934*f**2 + 3060288*f**3 + 18710296*f**4 + 93166640*f**5 + 249934560*f**6 + 374764544*f**7 + 336440860*f**8 + 186084360*f**9 + 62357400*f**10 + 11642400*f**11 + 931392*f**12)/1.4253581984449167e22,
    110: lambda f: 0,
    111: lambda f: (385 + 4620*f + 49434*f**2 + 406164*f**3 + 2644741*f**4 + 14054240*f**5 + 38905520*f**6 + 60223520*f**7 + 56108500*f**8 + 32320400*f**9 + 11295480*f**10 + 2199120*f**11 + 183260*f**12)/1.0769373054917149e23,
    112: lambda f: (-15015 - 180180*f - 1924923*f**2 - 15796638*f**3 - 102734060*f**4 - 545251200*f**5 - 1501510040*f**6 - 2277128784*f**7 - 2055575060*f**8 - 1140143760*f**9 - 382596900*f**10 - 71471400*f**11 - 5717712*f**12)/2.100027745708844e24,
    113: lambda f: 0,
    114: lambda f: (-15015 - 190190*f - 2149147*f**2 - 18682092*f**3 - 128918933*f**4 - 727308790*f**5 - 2060397705*f**6 - 3221548960*f**7 - 3016404860*f**8 - 1742088600*f**9 - 609634620*f**10 - 118752480*f**11 - 9896040*f**12)/1.5120199769103677e26,
    115: lambda f: (15015 + 190190*f + 2146144*f**2 + 18635760*f**3 + 128458187*f**4 + 723900970*f**5 + 2040410550*f**6 + 3125141824*f**7 + 2834563340*f**8 + 1576040760*f**9 + 529502400*f**10 + 98960400*f**11 + 7916832*f**12)/7.560099884551838e25,
    116: lambda f: 0,
    117: lambda f: (3003 + 40040*f + 476476*f**2 + 4368936*f**3 + 31848674*f**4 + 190108984*f**5 + 549803532*f**6 + 867265336*f**7 + 815576615*f**8 + 472096800*f**9 + 165396672*f**10 + 32232816*f**11 + 2686068*f**12)/1.1491351824518794e27,
    118: lambda f: (-15015 - 200200*f - 2379377*f**2 - 21795774*f**3 - 158729857*f**4 - 946528700*f**5 - 2724069615*f**6 - 4208657054*f**7 - 3833254180*f**8 - 2135831040*f**9 - 718319700*f**10 - 134303400*f**11 - 10744272*f**12)/2.8728379561296987e27,
    119: lambda f: 0,
}

Q002withhex20 = {
    0: lambda f: 0,
    1: lambda f: -(f*(2 + f))/15.,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (f*(14 + 19*f + 12*f**2 + 3*f**3))/210.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: -(f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/2520.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/166320.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: -(f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/1.729728e7,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 242350*f**5 + 162400*f**6 + 67550*f**7 + 15750*f**8 + 1575*f**9))/1.729728e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: -(f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 607125*f**5 + 450800*f**6 + 198100*f**7 + 47250*f**8 + 4725*f**9))/2.0756736e9,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 182745*f**5 + 144200*f**6 + 65275*f**7 + 15750*f**8 + 1575*f**9))/4.1513472e9,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2395540*f**5 + 1967840*f**6 + 907480*f**7 + 220500*f**8 + 22050*f**9))/4.649508864e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1372740*f**5 + 1160320*f**6 + 541940*f**7 + 132300*f**8 + 13230*f**9))/2.7897053184e12,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2211525*f**5 + 1909600*f**6 + 900200*f**7 + 220500*f**8 + 22050*f**9))/5.5794106368e13,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 923375*f**5 + 810600*f**6 + 384825*f**7 + 94500*f**8 + 9450*f**9))/3.34764638208e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: -(f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1356690*f**5 + 1206800*f**6 + 576100*f**7 + 141750*f**8 + 14175*f**9))/8.034351316992e15,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 148230*f**5 + 133280*f**6 + 63910*f**7 + 15750*f**8 + 1575*f**9))/1.6068702633984e16,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: -(f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 321595*f**5 + 291760*f**6 + 140420*f**7 + 34650*f**8 + 3465*f**9))/7.07022915895296e17,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (f*(462 + 6171*f + 52140*f**2 + 325585*f**3 + 1602650*f**4 + 3033975*f**5 + 2773400*f**6 + 1338925*f**7 + 330750*f**8 + 33075*f**9))/1.4847481233801216e20,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: -(f*(462 + 6567*f + 59136*f**2 + 394384*f**3 + 2078000*f**4 + 4005000*f**5 + 3684800*f**6 + 1783600*f**7 + 441000*f**8 + 44100*f**9))/4.751193994816389e21,
    50: lambda f: 0,
    51: lambda f: 0,
    52: lambda f: (f*(6006 + 90519*f + 865436*f**2 + 6139159*f**3 + 34474640*f**4 + 67498840*f**5 + 62451200*f**6 + 30297400*f**7 + 7497000*f**8 + 749700*f**9))/2.100027745708844e24,
    53: lambda f: 0,
    54: lambda f: 0,
    55: lambda f: -(f*(2002 + 31889*f + 322608*f**2 + 2425462*f**3 + 14460710*f**4 + 28710705*f**5 + 26694080*f**6 + 12975760*f**7 + 3213000*f**8 + 321300*f**9))/2.520033294850613e25,
    56: lambda f: 0,
    57: lambda f: 0,
    58: lambda f: (f*(2002 + 33605*f + 358644*f**2 + 2848651*f**3 + 17970770*f**4 + 36126315*f**5 + 33734120*f**6 + 16426165*f**7 + 4069800*f**8 + 406980*f**9))/9.576126520432329e26,
    59: lambda f: 0,
    60: lambda f: (f*(2 + f))/45.,
    61: lambda f: -(f*(28 + 11*f))/315.,
    62: lambda f: 0,
    63: lambda f: -(f*(70 + 123*f + 100*f**2 + 28*f**3))/4200.,
    64: lambda f: (f*(294 + 357*f + 200*f**2 + 44*f**3))/2940.,
    65: lambda f: -(f*(490 + 749*f + 380*f**2 + 64*f**3))/29400.,
    66: lambda f: (f*(70 + 239*f + 400*f**2 + 349*f**3 + 160*f**4 + 30*f**5))/25200.,
    67: lambda f: -(f*(686 + 1414*f + 1580*f**2 + 1017*f**3 + 360*f**4 + 55*f**5))/17640.,
    68: lambda f: (f*(5390 + 12859*f + 14960*f**2 + 9939*f**3 + 3460*f**4 + 480*f**5))/646800.,
    69: lambda f: -(f*(2310 + 15411*f + 42900*f**2 + 65446*f**3 + 60890*f**4 + 34515*f**5 + 11060*f**6 + 1540*f**7))/9.9792e6,
    70: lambda f: (f*(61446 + 179025*f + 299640*f**2 + 320318*f**3 + 224650*f**4 + 100665*f**5 + 26320*f**6 + 3080*f**7))/6.98544e6,
    71: lambda f: -(f*(210210 + 681681*f + 1204060*f**2 + 1353846*f**3 + 986190*f**4 + 453065*f**5 + 118860*f**6 + 13440*f**7))/1.009008e8,
    72: lambda f: (f**2*(12012 + 57200*f + 133757*f**2 + 194470*f**3 + 187375*f**4 + 120820*f**5 + 50435*f**6 + 12390*f**7 + 1365*f**8))/8.64864e7,
    73: lambda f: -(f*(168168 + 633633*f + 1412840*f**2 + 2111122*f**3 + 2213020*f**4 + 1642840*f**5 + 850640*f**6 + 293510*f**7 + 60900*f**8 + 5775*f**9))/1.2108096e8,
    74: lambda f: (f*(210210 + 861861*f + 2024880*f**2 + 3180931*f**3 + 3486710*f**4 + 2693235*f**5 + 1441580*f**6 + 509845*f**7 + 107100*f**8 + 10080*f**9))/6.054048e8,
    75: lambda f: -(f*(-6006 + 7293*f + 128700*f**2 + 466336*f**3 + 974660*f**4 + 1365294*f**5 + 1346744*f**6 + 945700*f**7 + 465570*f**8 + 153405*f**9 + 30492*f**10 + 2772*f**11))/2.0756736e9,
    76: lambda f: (f*(1219218 + 5636631*f + 15701400*f**2 + 30135040*f**3 + 42038900*f**4 + 43564362*f**5 + 33692624*f**6 + 19258540*f**7 + 7922250*f**8 + 2224215*f**9 + 382536*f**10 + 30492*f**11))/7.2648576e9,
    77: lambda f: -(f*(3573570 + 17714697*f + 51780300*f**2 + 104102492*f**3 + 151678420*f**4 + 163750086*f**5 + 131544952*f**6 + 77829500*f**7 + 32996250*f**8 + 9493785*f**9 + 1660428*f**10 + 133056*f**11))/8.23350528e10,
    78: lambda f: (f*(-30030 - 61347*f + 171600*f**2 + 1327183*f**3 + 4003700*f**4 + 7909560*f**5 + 10765160*f**6 + 9846550*f**7 + 5868450*f**8 + 2178225*f**9 + 457380*f**10 + 41580*f**11))/6.2270208e10,
    79: lambda f: -(f*(714714 + 3915912*f + 13084500*f**2 + 30671459*f**3 + 53418700*f**4 + 69497811*f**5 + 66220672*f**6 + 44968070*f**7 + 21026250*f**8 + 6412770*f**9 + 1147608*f**10 + 91476*f**11))/4.35891456e10,
    80: lambda f: (f*(3573570 + 20777757*f + 72541040*f**2 + 177426977*f**3 + 321833800*f**4 + 436330330*f**5 + 432862360*f**6 + 304758650*f**7 + 146774250*f**8 + 45755325*f**9 + 8302140*f**10 + 665280*f**11))/8.23350528e11,
    81: lambda f: -(f*(-4290 - 15873*f - 14300*f**2 + 97682*f**3 + 503230*f**4 + 1471985*f**5 + 2619820*f**6 + 2811200*f**7 + 1832250*f**8 + 712425*f**9 + 152460*f**10 + 13860*f**11))/8.3026944e10,
    82: lambda f: (f*(78078 + 494637*f + 1927640*f**2 + 5337306*f**3 + 11145230*f**4 + 17062027*f**5 + 18390624*f**6 + 13588540*f**7 + 6704250*f**8 + 2108715*f**9 + 382536*f**10 + 30492*f**11))/5.81188608e10,
    83: lambda f: -(f*(3573570 + 23840817*f + 96705180*f**2 + 278380882*f**3 + 603593330*f**4 + 963808455*f**5 + 1083827780*f**6 + 831029500*f**7 + 422115750*f**8 + 135552375*f**9 + 24906420*f**10 + 1995840*f**11))/9.880206336e12,
    84: lambda f: (f*(-30030 - 148863*f - 343200*f**2 - 36218*f**3 + 2592380*f**4 + 13412910*f**5 + 30233000*f**6 + 36106630*f**7 + 24784200*f**8 + 9878400*f**9 + 2134440*f**10 + 194040*f**11))/6.974263296e12,
    85: lambda f: -(f*(924924 + 6651645*f + 29618160*f**2 + 94584412*f**3 + 230279000*f**4 + 398058696*f**5 + 464973152*f**6 + 361054540*f**7 + 183456000*f**8 + 58639770*f**9 + 10711008*f**10 + 853776*f**11))/9.7639686144e12,
    86: lambda f: (f*(3573570 + 26903877*f + 124272720*f**2 + 411295807*f**3 + 1036807730*f**4 + 1872016965*f**5 + 2285451140*f**6 + 1842747655*f**7 + 963695250*f**8 + 314289675*f**9 + 58114980*f**10 + 4656960*f**11))/1.38322888704e14,
    87: lambda f: -(f*(-50050 - 303017*f - 986700*f**2 - 1582412*f**3 + 1319480*f**4 + 28420740*f**5 + 79501520*f**6 + 102525640*f**7 + 72791460*f**8 + 29463210*f**9 + 6403320*f**10 + 582120*f**11))/1.67382319104e14,
    88: lambda f: (f*(686686 + 5526521*f + 27679080*f**2 + 100143524*f**3 + 278504440*f**4 + 528815484*f**5 + 653449888*f**6 + 524211800*f**7 + 271347300*f**8 + 87595830*f**9 + 16066512*f**10 + 1280664*f**11))/1.171676233728e14,
    89: lambda f: -(f*(3573570 + 29966937*f + 155243660*f**2 + 580503352*f**3 + 1667325320*f**4 + 3312338140*f**5 + 4284383600*f**6 + 3570549640*f**7 + 1901900700*f**8 + 626180310*f**9 + 116229960*f**10 + 9313920*f**11))/2.213166219264e15,
    90: lambda f: (f*(-2002 - 14157*f - 57200*f**2 - 141271*f**3 - 151560*f**4 + 1405066*f**5 + 4815216*f**6 + 6579300*f**7 + 4783380*f**8 + 1956570*f**9 + 426888*f**10 + 38808*f**11))/1.11588212736e14,
    91: lambda f: -(f*(126126 + 1123122*f + 6249100*f**2 + 25262185*f**3 + 79005600*f**4 + 161642443*f**5 + 208188736*f**6 + 170895060*f**7 + 89596500*f**8 + 29117760*f**9 + 5355504*f**10 + 426888*f**11))/3.90558744576e14,
    92: lambda f: (f*(1191190 + 11009999*f + 63206000*f**2 + 263445039*f**3 + 848997340*f**4 + 1820568012*f**5 + 2457639184*f**6 + 2096534300*f**7 + 1130944500*f**8 + 374748570*f**9 + 69737976*f**10 + 5588352*f**11))/1.3278997315584e16,
    93: lambda f: -(f*(-6370 - 51233*f - 243100*f**2 - 762138*f**3 - 1490150*f**4 + 5371155*f**5 + 22378580*f**6 + 31987900*f**7 + 23669100*f**8 + 9755550*f**9 + 2134440*f**10 + 194040*f**11))/6.69529276416e15,
    94: lambda f: (f*(75166 + 733733*f + 4490200*f**2 + 20057726*f**3 + 69675850*f**4 + 151481993*f**5 + 201393136*f**6 + 168160160*f**7 + 88987500*f**8 + 29060010*f**9 + 5355504*f**10 + 426888*f**11))/4.686704934912e15,
    95: lambda f: -(f*(1191190 + 12031019*f + 75798580*f**2 + 348374234*f**3 + 1244550450*f**4 + 2840865495*f**5 + 3962995540*f**6 + 3439868600*f**7 + 1872769500*f**8 + 623438550*f**9 + 116229960*f**10 + 9313920*f**11))/2.6557994631168e17,
    96: lambda f: (f*(-5460 - 49062*f - 265200*f**2 - 984217*f**3 - 2532230*f**4 + 5381145*f**5 + 27161260*f**6 + 40254725*f**7 + 30192750*f**8 + 12516525*f**9 + 2744280*f**10 + 249480*f**11))/1.2051526975488e17,
    97: lambda f: -(f*(122304 + 1298661*f + 8668920*f**2 + 42403478*f**3 + 161984740*f**4 + 370361952*f**5 + 504884464*f**6 + 427151690*f**7 + 227650500*f**8 + 74614365*f**9 + 13771296*f**10 + 1097712*f**11))/1.68721377656832e17,
    98: lambda f: (f*(324870 + 3559647*f + 24416080*f**2 + 122654337*f**3 + 481013130*f**4 + 1156640645*f**5 + 1656015060*f**6 + 1456798875*f**7 + 798714000*f**8 + 266820750*f**9 + 49812840*f**10 + 3991680*f**11))/1.59347967787008e18,
    99: lambda f: -(f*(-630 - 6243*f - 37700*f**2 - 159848*f**3 - 492820*f**4 + 706490*f**5 + 4320680*f**6 + 6596380*f**7 + 5001150*f**8 + 2082675*f**9 + 457380*f**10 + 41580*f**11))/3.2137405267968e17,
    100: lambda f: (f*(6762 + 77595*f + 561080*f**2 + 2982616*f**3 + 12426700*f**4 + 29643766*f**5 + 41238512*f**6 + 35255780*f**7 + 18894750*f**8 + 6210645*f**9 + 1147608*f**10 + 91476*f**11))/2.24961836875776e17,
    101: lambda f: -(f*(3573570 + 42219177*f + 313161420*f**2 + 1706891732*f**3 + 7289309980*f**4 + 18316637250*f**5 + 26783670760*f**6 + 23813908580*f**7 + 13128711750*f**8 + 4397829975*f**9 + 821911860*f**10 + 65862720*f**11))/4.206786349577011e20,
    102: lambda f: (f*(-1650 - 17853*f - 118800*f**2 - 563183*f**3 - 1993180*f**4 + 2049420*f**5 + 15244040*f**6 + 23856910*f**7 + 18246690*f**8 + 7626465*f**9 + 1677060*f**10 + 152460*f**11))/2.121068747685888e19,
    103: lambda f: -(f*(17094 + 210804*f + 1641420*f**2 + 9422141*f**3 + 42518860*f**4 + 105169377*f**5 + 148773184*f**6 + 128275070*f**7 + 69057450*f**8 + 22751190*f**9 + 4207896*f**10 + 335412*f**11))/1.4847481233801216e19,
    104: lambda f: (f*(274890 + 3483249*f + 27780720*f**2 + 163272029*f**3 + 754152640*f**4 + 1967884470*f**5 + 2928181480*f**6 + 2626173830*f**7 + 1454295150*f**8 + 488228895*f**9 + 91323540*f**10 + 7318080*f**11))/8.413572699154022e20,
    105: lambda f: -(f*(-5082 - 59565*f - 432300*f**2 - 2257934*f**3 - 8950690*f**4 + 6797889*f**5 + 61986764*f**6 + 99068200*f**7 + 76323870*f**8 + 31996755*f**9 + 7043652*f**10 + 640332*f**11))/1.781697748056146e21,
    106: lambda f: (f*(255486 + 3369597*f + 28109400*f**2 + 173283490*f**3 + 841970150*f**4 + 2148764247*f**5 + 3082622144*f**6 + 2676686740*f**7 + 1446369750*f**8 + 477411165*f**9 + 88365816*f**10 + 7043652*f**11))/6.235942118196511e21,
    107: lambda f: -(f*(274890 + 3718869*f + 31733900*f**2 + 200035634*f**3 + 993615490*f**4 + 2678870047*f**5 + 4044979204*f**6 + 3653974100*f**7 + 2030915250*f**8 + 683040645*f**9 + 127852956*f**10 + 10245312*f**11))/2.3558003557631263e22,
    108: lambda f: (f*(-2310 - 29139*f - 228800*f**2 - 1302604*f**3 - 5691800*f**4 + 3227060*f**5 + 36546160*f**6 + 59471300*f**7 + 46099200*f**8 + 19374600*f**9 + 4268880*f**10 + 388080*f**11))/2.3755969974081946e22,
    109: lambda f: -(f*(45276 + 635943*f + 5658400*f**2 + 37283016*f**3 + 194064400*f**4 + 508963472*f**5 + 738932544*f**6 + 645445640*f**7 + 349860000*f**8 + 115662540*f**9 + 21422016*f**10 + 1707552*f**11))/3.3258357963714724e22,
    110: lambda f: (f*(3573570 + 51408357*f + 467335440*f**2 + 3145003927*f**3 + 16716192650*f**4 + 46375305465*f**5 + 70904921780*f**6 + 64440472075*f**7 + 35927277750*f**8 + 12101359725*f**9 + 2266484220*f**10 + 181621440*f**11))/9.187621387476192e24,
    111: lambda f: -(f*(-390390 - 5271123*f - 44487300*f**2 - 273798668*f**3 - 1303814320*f**4 + 549586200*f**5 + 7886920160*f**6 + 13036735600*f**7 + 10158435000*f**8 + 4278537900*f**9 + 943422480*f**10 + 85765680*f**11))/1.2600166474253064e26,
    112: lambda f: (f*(3741738 + 55762707*f + 527138040*f**2 + 3696984356*f**3 + 20523478480*f**4 + 55133646696*f**5 + 80872453312*f**6 + 70999693520*f**7 + 38587059000*f**8 + 12773838420*f**9 + 2367132768*f**10 + 188684496*f**11))/8.820116531977146e25,
    113: lambda f: -(f*(3573570 + 54471417*f + 525533580*f**2 + 3760490032*f**3 + 21295387280*f**4 + 60588263160*f**5 + 93638716640*f**6 + 85543570000*f**7 + 47818071000*f**8 + 16127149500*f**9 + 3021978960*f**10 + 242161920*f**11))/2.9400388439923814e26,
    114: lambda f: (f*(-70070 - 1008007*f - 9094800*f**2 - 60111077*f**3 - 309281680*f**4 + 95045130*f**5 + 1782734240*f**6 + 2987456920*f**7 + 2338421400*f**8 + 986712300*f**9 + 217712880*f**10 + 19792080*f**11))/7.560099884551839e26,
    115: lambda f: -(f*(658658 + 10380370*f + 103895220*f**2 + 772736159*f**3 + 4557322600*f**4 + 12506002281*f**5 + 18509180032*f**6 + 16320902360*f**7 + 8890371000*f**8 + 2946449520*f**9 + 546261408*f**10 + 43542576*f**11))/5.292069919186287e26,
    116: lambda f: (f*(210210 + 3384381*f + 34537360*f**2 + 261838421*f**3 + 1573788940*f**4 + 4579147880*f**5 + 7143737440*f**6 + 6555433640*f**7 + 3672711000*f**8 + 1240022700*f**9 + 232459920*f**10 + 18627840*f**11))/5.880077687984763e26,
    117: lambda f: -(f*(-50050 - 764049*f - 7335900*f**2 - 51786514*f**3 - 285950190*f**4 + 61466615*f**5 + 1583830500*f**6 + 2686474980*f**7 + 2111140920*f**8 + 892235820*f**9 + 196978320*f**10 + 17907120*f**11))/1.9152253040864658e28,
    118: lambda f: (f*(462462 + 7684677*f + 81183960*f**2 + 638266278*f**3 + 3985251330*f**4 + 11145905989*f**5 + 16626236368*f**6 + 14716668120*f**7 + 8032428600*f**8 + 2664769380*f**9 + 494236512*f**10 + 39395664*f**11))/1.340657712860526e28,
    119: lambda f: -(f*(70070 + 1188187*f + 12787060*f**2 + 102384802*f**3 + 650962570*f**4 + 1932430155*f**5 + 3039655780*f**6 + 2800251440*f**7 + 1571938200*f**8 + 531242460*f**9 + 99625680*f**10 + 7983360*f**11))/7.056093225581716e27,
}

Q004withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (f**2*(2 + f)**2)/315.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: -(f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/6930.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/360360.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: -(f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/2.16216e6,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (f**2*(2 + f)**2*(143 + 520*f + 1100*f**2 + 1512*f**3 + 1218*f**4 + 504*f**5 + 84*f**6))/1.729728e7,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: -(f**2*(2 + f)**2*(143 + 650*f + 1725*f**2 + 3080*f**3 + 2870*f**4 + 1260*f**5 + 210*f**6))/1.729728e8,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (f**2*(2 + f)**2*(143 + 780*f + 2490*f**2 + 5460*f**3 + 5565*f**4 + 2520*f**5 + 420*f**6))/2.0756736e9,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: -(f**2*(2 + f)**2*(143 + 910*f + 3395*f**2 + 8820*f**3 + 9555*f**4 + 4410*f**5 + 735*f**6))/2.90594304e10,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (f**2*(2 + f)**2*(143 + 1040*f + 4440*f**2 + 13328*f**3 + 15092*f**4 + 7056*f**5 + 1176*f**6))/4.649508864e11,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: -(f**2*(2 + f)**2*(143 + 1170*f + 5625*f**2 + 19152*f**3 + 22428*f**4 + 10584*f**5 + 1764*f**6))/8.3691159552e12,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (f**2*(2 + f)**2*(143 + 1300*f + 6950*f**2 + 26460*f**3 + 31815*f**4 + 15120*f**5 + 2520*f**6))/1.67382319104e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: -(f**2*(2 + f)**2*(13 + 130*f + 765*f**2 + 3220*f**3 + 3955*f**4 + 1890*f**5 + 315*f**6))/3.34764638208e14,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (f**2*(2 + f)**2*(143 + 1560*f + 10020*f**2 + 46200*f**3 + 57750*f**4 + 27720*f**5 + 4620*f**6))/8.8377864486912e16,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: -(f**2*(2 + f)**2*(11 + 130*f + 905*f**2 + 4536*f**3 + 5754*f**4 + 2772*f**5 + 462*f**6))/1.76755728973824e17,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (f**2*(2 + f)**2*(11 + 140*f + 1050*f**2 + 5684*f**3 + 7301*f**4 + 3528*f**5 + 588*f**6))/4.949160411267072e18,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: -(f**2*(2 + f)**2*(143 + 1950*f + 15675*f**2 + 91140*f**3 + 118335*f**4 + 57330*f**5 + 9555*f**6))/1.930172560394158e21,
    51: lambda f: 0,
    52: lambda f: 0,
    53: lambda f: (f**2*(2 + f)**2*(143 + 2080*f + 17840*f**2 + 110880*f**3 + 145320*f**4 + 70560*f**5 + 11760*f**6))/6.176552193261306e22,
    54: lambda f: 0,
    55: lambda f: 0,
    56: lambda f: -(f**2*(2 + f)**2*(143 + 2210*f + 20145*f**2 + 133280*f**3 + 176120*f**4 + 85680*f**5 + 14280*f**6))/2.100027745708844e24,
    57: lambda f: 0,
    58: lambda f: 0,
    59: lambda f: (f**2*(2 + f)**2*(143 + 2340*f + 22590*f**2 + 158508*f**3 + 210987*f**4 + 102816*f**5 + 17136*f**6))/7.560099884551838e25,
    60: lambda f: 0,
    61: lambda f: (4*f**2)/315.,
    62: lambda f: 0,
    63: lambda f: (-2*f**2*(2 + f))/945.,
    64: lambda f: (-2*f**2*(77 + 64*f + 18*f**2))/6615.,
    65: lambda f: (2*f**2*(154 + 155*f + 39*f**2))/24255.,
    66: lambda f: (f**2*(132 + 170*f + 82*f**2 + 15*f**3))/20790.,
    67: lambda f: (f**2*(6237 + 10412*f + 7970*f**2 + 3065*f**3 + 495*f**4))/436590.,
    68: lambda f: -(f**2*(6776 + 11418*f + 8665*f**2 + 3495*f**3 + 585*f**4))/533610.,
    69: lambda f: -(f**2*(1430 + 3107*f + 3186*f**2 + 1815*f**3 + 550*f**4 + 70*f**5))/540540.,
    70: lambda f: -(f**2*(51051 + 129740*f + 165888*f**2 + 126645*f**3 + 58935*f**4 + 15575*f**5 + 1820*f**6))/1.135134e7,
    71: lambda f: (f**2*(66066 + 166309*f + 210248*f**2 + 161985*f**3 + 77710*f**4 + 21770*f**5 + 2730*f**6))/1.387386e7,
    72: lambda f: (f**2*(4004 + 12298*f + 19278*f**2 + 18705*f**3 + 11700*f**4 + 4620*f**5 + 1050*f**6 + 105*f**7))/6.48648e6,
    73: lambda f: (f**2*(83083 + 284856*f + 513668*f**2 + 591530*f**3 + 459750*f**4 + 242060*f**5 + 83300*f**6 + 17010*f**7 + 1575*f**8))/9.081072e7,
    74: lambda f: -(f**2*(176176 + 596882*f + 1064067*f**2 + 1223685*f**3 + 961725*f**4 + 520380*f**5 + 187425*f**6 + 40845*f**7 + 4095*f**8))/1.6648632e8,
    75: lambda f: -(f**2*(43758 + 173927*f + 366724*f**2 + 503166*f**3 + 478116*f**4 + 319620*f**5 + 148260*f**6 + 45570*f**7 + 8358*f**8 + 693*f**9))/4.4108064e8,
    76: lambda f: -(f**2*(6279273 + 27147640*f + 63339790*f**2 + 97822930*f**3 + 106995270*f**4 + 84856002*f**5 + 48782580*f**6 + 19900230*f**7 + 5481105*f**8 + 917070*f**9 + 70686*f**10))/4.63134672e10,
    77: lambda f: (f**2*(1871870 + 8000421*f + 18468103*f**2 + 28386906*f**3 + 31136592*f**4 + 25004364*f**5 + 14724150*f**6 + 6235110*f**7 + 1808898*f**8 + 323631*f**9 + 27027*f**10))/1.132106976e10,
    78: lambda f: (f**2*(106964 + 522002*f + 1382610*f**2 + 2452335*f**3 + 2979160*f**4 + 2434600*f**5 + 1304100*f**6 + 437850*f**7 + 83580*f**8 + 6930*f**9))/8.8216128e9,
    79: lambda f: (f**2*(2909907 + 15196844*f + 43551858*f**2 + 84478185*f**3 + 116245215*f**4 + 113282204*f**5 + 76942460*f**6 + 35462910*f**7 + 10560585*f**8 + 1834140*f**9 + 141372*f**10))/1.852538688e11,
    80: lambda f: -(f**2*(4492488 + 23216050*f + 65888753*f**2 + 127055535*f**3 + 173647645*f**4 + 168980840*f**5 + 116307450*f**6 + 55407450*f**7 + 17392830*f**8 + 3236310*f**9 + 270270*f**10))/2.264213952e11,
    81: lambda f: -(f**2*(63206 + 365755*f + 1166166*f**2 + 2536485*f**3 + 3614490*f**4 + 3277050*f**5 + 1866900*f**6 + 647850*f**7 + 125370*f**8 + 10395*f**9))/5.29296768e10,
    82: lambda f: -(f**2*(551837 + 3379532*f + 11490980*f**2 + 26847845*f**3 + 43428615*f**4 + 47677427*f**5 + 35085680*f**6 + 17008530*f**7 + 5213355*f**8 + 917070*f**9 + 70686*f**10))/3.705077376e11,
    83: lambda f: (f**2*(2620618 + 15896309*f + 53572950*f**2 + 124400475*f**3 + 197959110*f**4 + 214790310*f**5 + 159226200*f**6 + 79639350*f**7 + 25741170*f**8 + 4854465*f**9 + 405405*f**10))/1.3585283712e12,
    84: lambda f: (f**2*(145860 + 976378*f + 3639734*f**2 + 9376605*f**3 + 14939820*f**4 + 14426580*f**5 + 8503950*f**6 + 3002475*f**7 + 585060*f**8 + 48510*f**9))/1.4820309504e12,
    85: lambda f: (f**2*(14855841 + 104400400*f + 410870008*f**2 + 1123324300*f**3 + 2047092180*f**4 + 2426366712*f**5 + 1870869000*f**6 + 932235780*f**7 + 290073630*f**8 + 51355920*f**9 + 3958416*f**10))/1.244905998336e14,
    86: lambda f: -(f**2*(5989984 + 41730546*f + 162906767*f**2 + 442681785*f**3 + 786742005*f**4 + 914689860*f**5 + 707832195*f**6 + 363549375*f**7 + 119313285*f**8 + 22654170*f**9 + 1891890*f**10))/3.80387943936e13,
    87: lambda f: -(f**2*(82654 + 628303*f + 2680968*f**2 + 7981500*f**3 + 13809320*f**4 + 13910120*f**5 + 8379000*f**6 + 2989980*f**7 + 585060*f**8 + 48510*f**9))/1.18562476032e13,
    88: lambda f: -(f**2*(2059057 + 16332784*f + 73033122*f**2 + 228752340*f**3 + 456666780*f**4 + 570797668*f**5 + 453714520*f**6 + 230022660*f**7 + 72237270*f**8 + 12838980*f**9 + 989604*f**10))/2.489811996672e14,
    89: lambda f: (f**2*(3369366 + 26514917*f + 117685237*f**2 + 366444180*f**3 + 707993840*f**4 + 863127160*f**5 + 686828100*f**6 + 358688820*f**7 + 118825980*f**8 + 22654170*f**9 + 1891890*f**10))/3.043103551488e14,
    90: lambda f: (f**2*(184756 + 1572194*f + 7556058*f**2 + 25523307*f**3 + 47045232*f**4 + 48842640*f**5 + 29864520*f**6 + 10733940*f**7 + 2106216*f**8 + 174636*f**9))/4.268249137152e14,
    91: lambda f: (f**2*(7538531 + 66622660*f + 333652710*f**2 + 1178035995*f**3 + 2527043805*f**4 + 3283728168*f**5 + 2666523720*f**6 + 1367990820*f**7 + 432299070*f**8 + 77033880*f**9 + 5937624*f**10))/1.4938871980032e16,
    92: lambda f: -(f**2*(7487480 + 65690482*f + 326736141*f**2 + 1147129587*f**3 + 2365735509*f**4 + 2985283728*f**5 + 2422394100*f**6 + 1279614420*f**7 + 426603996*f**8 + 81555012*f**9 + 6810804*f**10))/1.09551727853568e16,
    93: lambda f: -(f**2*(102102 + 961571*f + 5139610*f**2 + 19420035*f**3 + 37636110*f**4 + 39970350*f**5 + 24708600*f**6 + 8927100*f**7 + 1755180*f**8 + 145530*f**9))/4.268249137152e15,
    94: lambda f: -(f**2*(2464371 + 24012092*f + 133146584*f**2 + 523207385*f**3 + 1189456515*f**4 + 1592053659*f**5 + 1313412660*f**6 + 679657860*f**7 + 215747910*f**8 + 38516940*f**9 + 2968812*f**10))/8.9633231880192e16,
    95: lambda f: (f**2*(4118114 + 39856245*f + 219601444*f**2 + 858316485*f**3 + 1865138670*f**4 + 2415925890*f**5 + 1988887950*f**6 + 1059401700*f**7 + 354807180*f**8 + 67962510*f**9 + 5675670*f**10))/1.09551727853568e17,
    96: lambda f: (f**2*(20332 + 209950*f + 1235322*f**2 + 5162475*f**3 + 10420460*f**4 + 11263700*f**5 + 7021350*f**6 + 2546775*f**7 + 501480*f**8 + 41580*f**9))/1.7072996548608e16,
    97: lambda f: (f**2*(969969 + 10330424*f + 62830980*f**2 + 271970250*f**3 + 648608070*f**4 + 888586748*f**5 + 742036820*f**6 + 386516970*f**7 + 123112395*f**8 + 22009680*f**9 + 1696464*f**10))/7.17065855041536e17,
    98: lambda f: -(f**2*(816816 + 8645078*f + 52269985*f**2 + 225104055*f**3 + 510556055*f**4 + 675008740*f**5 + 561890175*f**6 + 301198275*f**7 + 101224305*f**8 + 19417860*f**9 + 1621620*f**10))/4.38206911414272e17,
    99: lambda f: -(f**2*(121550 + 1365559*f + 8770572*f**2 + 40165050*f**3 + 83851020*f**4 + 91924140*f**5 + 57680700*f**6 + 20986350*f**7 + 4137210*f**8 + 343035*f**9))/2.253635544416256e18,
    100: lambda f: -(f**2*(956879 + 11058840*f + 73203802*f**2 + 346092970*f**3 + 859159950*f**4 + 1199341066*f**5 + 1011245620*f**6 + 529472790*f**7 + 169095465*f**8 + 30263310*f**9 + 2332638*f**10))/1.5775448810913792e19,
    101: lambda f: (f**2*(4866862 + 55920293*f + 368118051*f**2 + 1731964590*f**3 + 4070984160*f**4 + 5471609220*f**5 + 4594846410*f**6 + 2475338250*f**7 + 834143310*f**8 + 160197345*f**9 + 13378365*f**10))/5.78433123066839e19,
    102: lambda f: (f**2*(20196 + 245242*f + 1707242*f**2 + 8501955*f**3 + 18259560*f**4 + 20249880*f**5 + 12774300*f**6 + 4659270*f**7 + 919380*f**8 + 76230*f**9))/9.014542177665024e18,
    103: lambda f: (f**2*(472923 + 5894716*f + 42188458*f**2 + 216305365*f**3 + 555591315*f**4 + 787649604*f**5 + 669342660*f**6 + 351921570*f**7 + 112632135*f**8 + 20175540*f**9 + 1555092*f**10))/1.893053857309655e20,
    104: lambda f: -(f**2*(806344 + 9995898*f + 71169293*f**2 + 363213075*f**3 + 879904545*f**4 + 1198729560*f**5 + 1013845350*f**6 + 548377830*f**7 + 185195010*f**8 + 35599410*f**9 + 2972970*f**10))/2.313732492267356e20,
    105: lambda f: -(f**2*(10846 + 141559*f + 1061718*f**2 + 5712357*f**3 + 12568682*f**4 + 14073290*f**5 + 8917020*f**6 + 3258990*f**7 + 643566*f**8 + 53361*f**9))/1.2620359048731034e20,
    106: lambda f: -(f**2*(1260567 + 16856180*f + 129702180*f**2 + 716804235*f**3 + 1895950665*f**4 + 2722833029*f**5 + 2328913160*f**6 + 1228689210*f**7 + 393931335*f**8 + 70614390*f**9 + 5442822*f**10))/1.3251377001167585e22,
    107: lambda f: (f**2*(431970 + 5746697*f + 44002426*f**2 + 242114187*f**3 + 601908734*f**4 + 829316278*f**5 + 705555900*f**6 + 382892370*f**7 + 129539046*f**8 + 24919587*f**9 + 2081079*f**10))/3.2392254891742986e21,
    108: lambda f: (f**2*(301444 + 4208282*f + 33829830*f**2 + 195557205*f**3 + 439353180*f**4 + 495963300*f**5 + 315410550*f**6 + 115472175*f**7 + 22817340*f**8 + 1891890*f**9))/9.843880058010206e22,
    109: lambda f: (f**2*(18565547 + 265108064*f + 2182470608*f**2 + 12933396680*f**3 + 35092358520*f**4 + 50953722512*f**5 + 43820656880*f**6 + 23185551480*f**7 + 7444453380*f**8 + 1335253920*f**9 + 102918816*f**10))/5.512572832485716e24,
    110: lambda f: -(f**2*(11979968 + 170242930*f + 1395022023*f**2 + 8232346305*f**3 + 20929922085*f**4 + 29114828820*f**5 + 24893115975*f**6 + 13546553475*f**7 + 4589868465*f**8 + 883512630*f**9 + 73783710*f**10))/2.5265958815559527e24,
    111: lambda f: -(f**2*(160446 + 2385695*f + 20463376*f**2 + 126482040*f**3 + 289383120*f**4 + 328952400*f**5 + 209857200*f**6 + 76939800*f**7 + 15211560*f**8 + 1261260*f**9))/1.575020809281633e24,
    112: lambda f: -(f**2*(3684681 + 55960736*f + 490787450*f**2 + 3104521640*f**3 + 8614077240*f**4 + 12626177928*f**5 + 10909313520*f**6 + 5786266920*f**7 + 1860176220*f**8 + 333813480*f**9 + 25729704*f**10))/3.307543699491429e25,
    113: lambda f: (f**2*(6364358 + 96216549*f + 840138385*f**2 + 5293120680*f**3 + 13723602720*f**4 + 19247879280*f**5 + 16526634600*f**6 + 9014833800*f**7 + 3058287960*f**8 + 589008420*f**9 + 49189140*f**10))/4.042553410489524e25,
    114: lambda f: (f**2*(20020 + 315874*f + 2879562*f**2 + 18950835*f**3 + 44058080*f**4 + 50385440*f**5 + 32230800*f**6 + 11831400*f**7 + 2340240*f**8 + 194040*f**9))/6.300083237126532e24,
    115: lambda f: (f**2*(457457 + 7362940*f + 68535066*f**2 + 460912245*f**3 + 1304434515*f**4 + 1927732912*f**5 + 1672315120*f**6 + 888860280*f**7 + 286057380*f**8 + 51355920*f**9 + 3958416*f**10))/1.3230174797965717e26,
    116: lambda f: -(f**2*(792792 + 12704978*f + 117766261*f**2 + 788971275*f**3 + 2081250005*f**4 + 2939913760*f**5 + 2533497960*f**6 + 1384761000*f**7 + 470291640*f**8 + 90616680*f**9 + 7567560*f**10))/1.6170213641958097e26,
    117: lambda f: -(f**2*(10582 + 176579*f + 1704834*f**2 + 11902095*f**3 + 28066230*f**4 + 32266710*f**5 + 20689200*f**6 + 7602840*f**7 + 1504440*f**8 + 124740*f**9))/1.1340149826827757e26,
    118: lambda f: -(f**2*(1524523 + 25922156*f + 255231408*f**2 + 1818487245*f**3 + 5237983935*f**4 + 7796702991*f**5 + 6787412940*f**6 + 3614221800*f**7 + 1164226140*f**8 + 209091960*f**9 + 16116408*f**10))/1.5082399269680917e28,
    119: lambda f: (f**2*(418418 + 7085221*f + 69484416*f**2 + 493250985*f**3 + 1321295310*f**4 + 1878110010*f**5 + 1623632850*f**6 + 889013160*f**7 + 302211000*f**8 + 58253580*f**9 + 4864860*f**10))/2.910638455552458e27,
}

Q020withhex20 = {
    0: lambda f: -(f*(2 + f))/3.,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (f*(14 + 19*f + 12*f**2 + 3*f**3))/42.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: -(f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/504.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/33264.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: -(f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/3.459456e6,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 242350*f**5 + 162400*f**6 + 67550*f**7 + 15750*f**8 + 1575*f**9))/3.459456e7,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: -(f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 607125*f**5 + 450800*f**6 + 198100*f**7 + 47250*f**8 + 4725*f**9))/4.1513472e8,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (f*(858 + 5577*f + 22308*f**2 + 63427*f**3 + 136070*f**4 + 182745*f**5 + 144200*f**6 + 65275*f**7 + 15750*f**8 + 1575*f**9))/8.3026944e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2395540*f**5 + 1967840*f**6 + 907480*f**7 + 220500*f**8 + 22050*f**9))/9.299017728e10,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (f*(2002 + 16445*f + 84084*f**2 + 310661*f**3 + 882520*f**4 + 1372740*f**5 + 1160320*f**6 + 541940*f**7 + 132300*f**8 + 13230*f**9))/5.5794106368e11,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2211525*f**5 + 1909600*f**6 + 900200*f**7 + 220500*f**8 + 22050*f**9))/1.11588212736e13,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 923375*f**5 + 810600*f**6 + 384825*f**7 + 94500*f**8 + 9450*f**9))/6.69529276416e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: -(f*(546 + 5889*f + 39936*f**2 + 198484*f**3 + 770540*f**4 + 1356690*f**5 + 1206800*f**6 + 576100*f**7 + 141750*f**8 + 14175*f**9))/1.6068702633984e15,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 148230*f**5 + 133280*f**6 + 63910*f**7 + 15750*f**8 + 1575*f**9))/3.2137405267968e15,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: -(f*(66 + 825*f + 6512*f**2 + 37898*f**3 + 173410*f**4 + 321595*f**5 + 291760*f**6 + 140420*f**7 + 34650*f**8 + 3465*f**9))/1.414045831790592e17,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (f*(462 + 6171*f + 52140*f**2 + 325585*f**3 + 1602650*f**4 + 3033975*f**5 + 2773400*f**6 + 1338925*f**7 + 330750*f**8 + 33075*f**9))/2.969496246760243e19,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: -(f*(462 + 6567*f + 59136*f**2 + 394384*f**3 + 2078000*f**4 + 4005000*f**5 + 3684800*f**6 + 1783600*f**7 + 441000*f**8 + 44100*f**9))/9.502387989632778e20,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (f*(6006 + 90519*f + 865436*f**2 + 6139159*f**3 + 34474640*f**4 + 67498840*f**5 + 62451200*f**6 + 30297400*f**7 + 7497000*f**8 + 749700*f**9))/4.200055491417688e23,
    52: lambda f: 0,
    53: lambda f: 0,
    54: lambda f: -(f*(2002 + 31889*f + 322608*f**2 + 2425462*f**3 + 14460710*f**4 + 28710705*f**5 + 26694080*f**6 + 12975760*f**7 + 3213000*f**8 + 321300*f**9))/5.040066589701226e24,
    55: lambda f: 0,
    56: lambda f: 0,
    57: lambda f: (f*(2002 + 33605*f + 358644*f**2 + 2848651*f**3 + 17970770*f**4 + 36126315*f**5 + 33734120*f**6 + 16426165*f**7 + 4069800*f**8 + 406980*f**9))/1.9152253040864657e26,
    58: lambda f: 0,
    59: lambda f: 0,
    60: lambda f: -(f*(2 + f))/9.,
    61: lambda f: (f*(28 + 11*f))/63.,
    62: lambda f: 0,
    63: lambda f: (f*(14 + 19*f + 12*f**2 + 3*f**3))/63.,
    64: lambda f: -(f*(56 + 73*f + 42*f**2 + 9*f**3))/126.,
    65: lambda f: 0,
    66: lambda f: -(f*(42 + 93*f + 112*f**2 + 78*f**3 + 30*f**4 + 5*f**5))/504.,
    67: lambda f: (f*(924 + 2013*f + 2332*f**2 + 1550*f**3 + 560*f**4 + 85*f**5))/5544.,
    68: lambda f: 0,
    69: lambda f: (f*(462 + 1419*f + 2508*f**2 + 2837*f**3 + 2110*f**4 + 1005*f**5 + 280*f**6 + 35*f**7))/24948.,
    70: lambda f: -(f*(48048 + 146289*f + 253110*f**2 + 279487*f**3 + 201860*f**4 + 92775*f**5 + 24710*f**6 + 2905*f**7))/1.297296e6,
    71: lambda f: 0,
    72: lambda f: (-5*f*(6006 + 23595*f + 54912*f**2 + 85748*f**3 + 94060*f**4 + 73170*f**5 + 39760*f**6 + 14420*f**7 + 3150*f**8 + 315*f**9))/1.0378368e7,
    73: lambda f: (f*(60060 + 234663*f + 538824*f**2 + 828932*f**3 + 893680*f**4 + 681498*f**5 + 361816*f**6 + 127652*f**7 + 26964*f**8 + 2583*f**9))/1.0378368e7,
    74: lambda f: 0,
    75: lambda f: (f*(6006 + 28743*f + 82940*f**2 + 165035*f**3 + 238900*f**4 + 257134*f**5 + 206752*f**6 + 122990*f**7 + 52710*f**8 + 15435*f**9 + 2772*f**10 + 231*f**11))/1.729728e7,
    76: lambda f: -(f*(408408 + 1947231*f + 5566990*f**2 + 10964915*f**3 + 15691000*f**4 + 16673022*f**5 + 13213844*f**6 + 7732830*f**7 + 3252480*f**8 + 931875*f**9 + 163086*f**10 + 13167*f**11))/5.8810752e8,
    77: lambda f: 0,
    78: lambda f: -(f*(6006 + 33891*f + 116688*f**2 + 282022*f**3 + 506750*f**4 + 683157*f**5 + 678896*f**6 + 483220*f**7 + 237330*f**8 + 76005*f**9 + 14256*f**10 + 1188*f**11))/1.7791488e8,
    79: lambda f: (f*(1429428 + 8044179*f + 27509196*f**2 + 65995462*f**3 + 117612800*f**4 + 157030581*f**5 + 153987512*f**6 + 107627380*f**7 + 51668820*f**8 + 16115085*f**9 + 2935548*f**10 + 237006*f**11))/2.117187072e10,
    80: lambda f: 0,
    81: lambda f: (f*(3432 + 22308*f + 89232*f**2 + 253708*f**3 + 544280*f**4 + 864036*f**5 + 975968*f**6 + 760060*f**7 + 395640*f**8 + 131040*f**9 + 24948*f**10 + 2079*f**11))/1.24540416e9,
    82: lambda f: -(f*(1633632 + 10596729*f + 42168126*f**2 + 119219555*f**3 + 254186380*f**4 + 400287321*f**5 + 446018482*f**6 + 340447835*f**7 + 172819080*f**8 + 55634355*f**9 + 10274418*f**10 + 829521*f**11))/2.9640619008e11,
    83: lambda f: 0,
    84: lambda f: -(f*(6006 + 44187*f + 201344*f**2 + 658216*f**3 + 1641080*f**4 + 2947476*f**5 + 3623648*f**6 + 2977240*f**7 + 1600340*f**8 + 539490*f**9 + 103488*f**10 + 8624*f**11))/3.099672576e10,
    85: lambda f: (f*(612612 + 4499781*f + 20420400*f**2 + 66460888*f**3 + 164905440*f**4 + 294090412*f**5 + 356462064*f**6 + 286663720*f**7 + 150051720*f**8 + 49111230*f**9 + 9132816*f**10 + 737352*f**11))/1.58083301376e12,
    86: lambda f: 0,
    87: lambda f: (f*(10010 + 82225*f + 420420*f**2 + 1553305*f**3 + 4412600*f**4 + 8726484*f**5 + 11389952*f**6 + 9695140*f**7 + 5318460*f**8 + 1812510*f**9 + 349272*f**10 + 29106*f**11))/8.3691159552e11,
    88: lambda f: -(f*(680680 + 5584007*f + 28457286*f**2 + 104763503*f**3 + 296462320*f**4 + 582526284*f**5 + 749217448*f**6 + 623590268*f**7 + 332803296*f**8 + 110039202*f**9 + 20548836*f**10 + 1659042*f**11))/2.845499424768e13,
    89: lambda f: 0,
    90: lambda f: -(f*(2002 + 18161*f + 102960*f**2 + 424190*f**3 + 1352350*f**4 + 2888901*f**5 + 3941728*f**6 + 3440360*f**7 + 1913940*f**8 + 657090*f**9 + 127008*f**10 + 10584*f**11))/3.0433148928e12,
    91: lambda f: (f*(748748 + 6784921*f + 38361180*f**2 + 157579630*f**3 + 500786000*f**4 + 1063407069*f**5 + 1429125488*f**6 + 1218774760*f**7 + 659189160*f**8 + 219463650*f**9 + 41097672*f**10 + 3318084*f**11))/5.690998849536e14,
    92: lambda f: 0,
    93: lambda f: (f*(546 + 5421*f + 33748*f**2 + 153387*f**3 + 542250*f**4 + 1233839*f**5 + 1741992*f**6 + 1549065*f**7 + 870660*f**8 + 300510*f**9 + 58212*f**10 + 4851*f**11))/1.67382319104e13,
    94: lambda f: -(f*(74256 + 736593*f + 4575142*f**2 + 20742839*f**3 + 73135700*f**4 + 165482539*f**5 + 230036478*f**6 + 199759245*f**7 + 109100880*f**8 + 36504090*f**9 + 6849612*f**10 + 553014*f**11))/1.1381997699072e15,
    95: lambda f: 0,
    96: lambda f: -(f*(7098 + 76557*f + 519168*f**2 + 2580292*f**3 + 10017020*f**4 + 24023658*f**5 + 34848464*f**6 + 31439380*f**7 + 17809470*f**8 + 6171795*f**9 + 1197504*f**10 + 99792*f**11))/4.8206107901952e15,
    97: lambda f: (f*(241332 + 2600949*f + 17603976*f**2 + 87308260*f**3 + 338181680*f**4 + 806766042*f**5 + 1151904824*f**6 + 1014370420*f**7 + 558143460*f**8 + 187453035*f**9 + 35226576*f**10 + 2844072*f**11))/8.19503834333184e16,
    98: lambda f: 0,
    99: lambda f: (f*(42 + 489*f + 3588*f**2 + 19357*f**3 + 81860*f**4 + 205254*f**5 + 304352*f**6 + 277750*f**7 + 158310*f**8 + 55035*f**9 + 10692*f**10 + 891*f**11))/6.886586843136e14,
    100: lambda f: -(f*(219912 + 2558721*f + 18743010*f**2 + 100933573*f**3 + 426022040*f**4 + 1062829494*f**5 + 1550823428*f**6 + 1380926470*f**7 + 764295840*f**8 + 257446035*f**9 + 48436542*f**10 + 3910599*f**11))/1.8029084355330048e18,
    101: lambda f: 0,
    102: lambda f: -(f*(330 + 4125*f + 32560*f**2 + 189490*f**3 + 867050*f**4 + 2258471*f**5 + 3410288*f**6 + 3141460*f**7 + 1799490*f**8 + 627165*f**9 + 121968*f**10 + 10164*f**11))/1.414045831790592e17,
    103: lambda f: (f*(78540 + 981189*f + 7733572*f**2 + 44936066*f**3 + 205270240*f**4 + 532119567*f**5 + 790509944*f**6 + 710308116*f**7 + 394994292*f**8 + 133365309*f**9 + 25115244*f**10 + 2027718*f**11))/1.6827145398308045e19,
    104: lambda f: 0,
    105: lambda f: (f*(3696 + 49368*f + 417120*f**2 + 2604680*f**3 + 12821200*f**4 + 34517112*f**5 + 52923136*f**6 + 49131320*f**7 + 28259280*f**8 + 9869580*f**9 + 1920996*f**10 + 160083*f**11))/4.454244370140365e19,
    106: lambda f: -(f*(251328 + 3355341*f + 28313670*f**2 + 176557495*f**3 + 867807500*f**4 + 2325588321*f**5 + 3507413042*f**6 + 3175329115*f**7 + 1772661240*f**8 + 599682825*f**9 + 113018598*f**10 + 9124731*f**11))/1.514443085847724e21,
    107: lambda f: 0,
    108: lambda f: -(f*(7854 + 111639*f + 1005312*f**2 + 6704528*f**3 + 35326000*f**4 + 97889544*f**5 + 152055232*f**6 + 142088240*f**7 + 82008360*f**8 + 28691460*f**9 + 5588352*f**10 + 465696*f**11))/2.8507163968898335e21,
    109: lambda f: (f*(3471468 + 49322559*f + 443647776*f**2 + 2955095312*f**3 + 15550158400*f**4 + 42900535368*f**5 + 65539541536*f**6 + 59711192240*f**7 + 33443570160*f**8 + 11332191780*f**9 + 2137078944*f**10 + 172540368*f**11))/6.300083237126532e23,
    110: lambda f: 0,
    111: lambda f: (f*(6006 + 90519*f + 865436*f**2 + 6139159*f**3 + 34474640*f**4 + 97993304*f**5 + 153934592*f**6 + 144651640*f**7 + 83733160*f**8 + 29338260*f**9 + 5717712*f**10 + 476476*f**11))/7.000092485696147e22,
    112: lambda f: -(f*(72072 + 1085799*f + 10370646*f**2 + 73485815*f**3 + 412186080*f**4 + 1166679128*f**5 + 1802223696*f**6 + 1650863480*f**7 + 927205440*f**8 + 314612340*f**9 + 59363304*f**10 + 4792788*f**11))/4.200055491417688e23,
    113: lambda f: 0,
    114: lambda f: -(f*(38038 + 605891*f + 6129552*f**2 + 46083778*f**3 + 274753490*f**4 + 798842019*f**5 + 1267203392*f**6 + 1196559280*f**7 + 694393560*f**8 + 243609660*f**9 + 47500992*f**10 + 3958416*f**11))/1.5120199769103677e25,
    115: lambda f: (f*(76076 + 1211353*f + 12243660*f**2 + 91960934*f**3 + 547708720*f**4 + 1585981833*f**5 + 2473719136*f**6 + 2276585360*f**7 + 1281707280*f**8 + 435414420*f**9 + 82195344*f**10 + 6636168*f**11))/1.5120199769103677e25,
    116: lambda f: 0,
    117: lambda f: (f*(10010 + 168025*f + 1793220*f**2 + 14243255*f**3 + 89853850*f**4 + 266585751*f**5 + 426533128*f**6 + 404458985*f**7 + 235234440*f**8 + 82616940*f**9 + 16116408*f**10 + 1343034*f**11))/1.4364189780648492e26,
    118: lambda f: -(f*(80080 + 1343771*f + 14329458*f**2 + 113715589*f**3 + 716709260*f**4 + 2118060549*f**5 + 3331781138*f**6 + 3078809419*f**7 + 1736971488*f**8 + 590681196*f**9 + 111550824*f**10 + 9006228*f**11))/5.745675912259397e26,
    119: lambda f: 0,
}

Q022withhex20 = {
    0: lambda f: 0,
    1: lambda f: (-21 - 22*f - 11*f**2)/42.,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (21 + 44*f + 58*f**2 + 36*f**3 + 9*f**4)/168.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: (-231 - 726*f - 1551*f**2 - 1868*f**3 - 1317*f**4 - 510*f**5 - 85*f**6)/11088.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (9009 + 37752*f + 111540*f**2 + 198744*f**3 + 228766*f**4 + 172520*f**5 + 82980*f**6 + 23240*f**7 + 2905*f**8)/3.459456e6,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: (-9009 - 47190*f - 178035*f**2 - 419640*f**3 - 668810*f**4 - 746356*f**5 - 588390*f**6 - 322840*f**7 - 117845*f**8 - 25830*f**9 - 2583*f**10)/3.459456e7,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (3003 + 18876*f + 86658*f**2 + 254020*f**3 + 516905*f**4 + 762712*f**5 + 783980*f**6 + 529480*f**7 + 221165*f**8 + 51660*f**9 + 5166*f**10)/1.3837824e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: (-1287 - 9438*f - 51051*f**2 - 178932*f**3 - 442883*f**4 - 812218*f**5 - 985095*f**6 - 736120*f**7 - 324485*f**8 - 77490*f**9 - 7749*f**10)/8.3026944e8,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (9009 + 75504*f + 470184*f**2 + 1917552*f**3 + 5589388*f**4 + 12249776*f**5 + 16637880*f**6 + 13198640*f**7 + 5989270*f**8 + 1446480*f**9 + 144648*f**10)/9.299017728e10,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: (-1001 - 9438*f - 66495*f**2 - 309296*f**3 - 1037444*f**4 - 2644264*f**5 - 3899980*f**6 - 3218320*f**7 - 1487150*f**8 - 361620*f**9 - 36162*f**10)/1.8598035456e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (3003 + 31460*f + 247390*f**2 + 1292460*f**3 + 4902715*f**4 + 14245904*f**5 + 22370760*f**6 + 18984560*f**7 + 8882230*f**8 + 2169720*f**9 + 216972*f**10)/1.11588212736e13,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: (-273 - 3146*f - 27313*f**2 - 158340*f**3 - 670135*f**4 - 2186234*f**5 - 3606735*f**6 - 3125360*f**7 - 1475530*f**8 - 361620*f**9 - 36162*f**10)/2.23176425472e13,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (273 + 3432*f + 32604*f**2 + 207688*f**3 + 970122*f**4 + 3510744*f**5 + 6027260*f**6 + 5307960*f**7 + 2523255*f**8 + 619920*f**9 + 61992*f**10)/5.356234211328e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: (-63 - 858*f - 8853*f**2 - 61464*f**3 - 314066*f**4 - 1248484*f**5 - 2214990*f**6 - 1975960*f**7 - 944405*f**8 - 232470*f**9 - 23247*f**10)/3.2137405267968e15,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (99 + 1452*f + 16170*f**2 + 121524*f**3 + 674261*f**4 + 2920552*f**5 + 5326260*f**6 + 4801720*f**7 + 2304995*f**8 + 568260*f**9 + 56826*f**10)/1.414045831790592e17,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: (-231 - 3630*f - 43395*f**2 - 350980*f**3 - 2101295*f**4 - 9850162*f**5 - 18390155*f**6 - 16724680*f**7 - 8057315*f**8 - 1988910*f**9 - 198891*f**10)/9.898320822534144e18,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (693 + 11616*f + 148368*f**2 + 1284960*f**3 + 8256440*f**4 + 41643616*f**5 + 79334640*f**6 + 72684640*f**7 + 35122220*f**8 + 8678880*f**9 + 867888*f**10)/9.502387989632778e20,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: (-9009 - 160446*f - 2180607*f**2 - 20133984*f**3 - 138197896*f**4 - 746245328*f**5 - 1446876120*f**6 - 1333999520*f**7 - 646258060*f**8 - 159836040*f**9 - 15983604*f**10)/4.200055491417688e23,
    50: lambda f: 0,
    51: lambda f: 0,
    52: lambda f: (1001 + 18876*f + 271986*f**2 + 2667028*f**3 + 19475557*f**4 + 112098272*f**5 + 220726640*f**6 + 204622880*f**7 + 99348340*f**8 + 24590160*f**9 + 2459016*f**10)/1.6800221965670752e24,
    53: lambda f: 0,
    54: lambda f: 0,
    55: lambda f: (-3003 - 59774*f - 910195*f**2 - 9446268*f**3 - 73121177*f**4 - 446903446*f**5 - 892085625*f**6 - 830962720*f**7 - 404221580*f**8 - 100117080*f**9 - 10011708*f**10)/1.9152253040864657e26,
    56: lambda f: 0,
    57: lambda f: 0,
    58: lambda f: (3003 + 62920*f + 1009580*f**2 + 11055720*f**3 + 90426130*f**4 + 584854808*f**5 + 1181773020*f**6 + 1105448120*f**7 + 538649335*f**8 + 133489440*f**9 + 13348944*f**10)/7.660901216345863e27,
    59: lambda f: 0,
    60: lambda f: -0.041666666666666664 + (29*f)/630. + (2*f**2)/45.,
    61: lambda f: (-735 - 616*f - 242*f**2)/1764.,
    62: lambda f: 0.125 + (9*f)/70. + (8*f**2)/245.,
    63: lambda f: (35 - 2*f - 91*f**2 - 100*f**3 - 32*f**4)/1680.,
    64: lambda f: (245 + 462*f + 545*f**2 + 300*f**3 + 66*f**4)/1176.,
    65: lambda f: (-8085 - 16786*f - 19283*f**2 - 10820*f**3 - 2176*f**4)/129360.,
    66: lambda f: (-1155 - 1144*f + 2794*f**2 + 8380*f**3 + 8897*f**4 + 4460*f**5 + 880*f**6)/221760.,
    67: lambda f: (-8085 - 23716*f - 47168*f**2 - 52700*f**3 - 34341*f**4 - 12240*f**5 - 1870*f**6)/155232.,
    68: lambda f: (105105 + 328328*f + 654082*f**2 + 759980*f**3 + 511461*f**4 + 185980*f**5 + 27840*f**6)/6.72672e6,
    69: lambda f: (45045 + 91806*f - 23595*f**2 - 461760*f**3 - 952577*f**4 - 1006450*f**5 - 611385*f**6 - 203980*f**7 - 29120*f**8)/5.189184e7,
    70: lambda f: (315315 + 1255254*f + 3518229*f**2 + 5935800*f**3 + 6456811*f**4 + 4591670*f**5 + 2077815*f**6 + 546140*f**7 + 63910*f**8)/3.6324288e7,
    71: lambda f: (-105105 - 438438*f - 1237665*f**2 - 2167360*f**3 - 2454579*f**4 - 1816470*f**5 - 850475*f**6 - 228900*f**7 - 26880*f**8)/4.036032e7,
    72: lambda f: (-15015 - 46332*f - 46332*f**2 + 133640*f**3 + 553582*f**4 + 966800*f**5 + 1020100*f**6 + 693560*f**7 + 299425*f**8 + 75180*f**9 + 8400*f**10)/1.3837824e8,
    73: lambda f: (-105105 - 528528*f - 1912482*f**2 - 4318600*f**3 - 6586006*f**4 - 7023496*f**5 - 5283944*f**6 - 2762648*f**7 - 959441*f**8 - 199752*f**9 - 18942*f**10)/9.6864768e7,
    74: lambda f: (5360355 + 27975948*f + 102072828*f**2 + 238282200*f**3 + 377653402*f**4 + 419341040*f**5 + 328187340*f**6 + 178025960*f**7 + 63851515*f**8 + 13631940*f**9 + 1310400*f**10)/1.646701056e10,
    75: lambda f: (765765 + 3165162*f + 6439719*f**2 - 198900*f**3 - 34711790*f**4 - 97981540*f**5 - 155370642*f**6 - 163957024*f**7 - 120056615*f**8 - 60772950*f**9 - 20411685*f**10 - 4110876*f**11 - 376992*f**12)/7.05729024e10,
    76: lambda f: (5360355 + 32570538*f + 144452451*f**2 + 408739500*f**3 + 802234420*f**4 + 1140739100*f**5 + 1200311862*f**6 + 939355424*f**7 + 541754395*f**8 + 224309610*f**9 + 63248535*f**10 + 10902276*f**11 + 869022*f**12)/4.940103168e10,
    77: lambda f: (-101846745 - 638239602*f - 2854064499*f**2 - 8317799100*f**3 - 16911204410*f**4 - 24972376780*f**5 - 27300376518*f**6 - 22182995296*f**7 - 13262794685*f**8 - 5679068850*f**9 - 1650374775*f**10 - 291772404*f**11 - 23683968*f**12)/3.1287320064e12,
    78: lambda f: (-765765 - 3967392*f - 11829246*f**2 - 14254500*f**3 + 24376793*f**4 + 146125540*f**5 + 350966652*f**6 + 522521944*f**7 + 501180365*f**8 + 307125000*f**9 + 116044110*f**10 + 24665256*f**11 + 2261952*f**12)/8.468748288e11,
    79: lambda f: (-5360355 - 38186148*f - 200557500*f**2 - 682160700*f**3 - 1637570509*f**4 - 2910901160*f**5 - 3847513962*f**6 - 3708394424*f**7 - 2538283405*f**8 - 1193047380*f**9 - 365000580*f**10 - 65413656*f**11 - 5214132*f**12)/5.9281238016e11,
    80: lambda f: (33948915 + 248312064*f + 1314446562*f**2 + 4590430780*f**3 + 11378709569*f**4 + 20940677860*f**5 + 28782139436*f**6 + 28932218392*f**7 + 20633340245*f**8 + 10063103400*f**9 + 3176261550*f**10 + 583544808*f**11 + 47367936*f**12)/1.25149280256e13,
    81: lambda f: (255255 + 1589874*f + 6177171*f**2 + 12932920*f**3 + 5992483*f**4 - 51421090*f**5 - 221113249*f**6 - 443730868*f**7 - 501406955*f**8 - 335946450*f**9 - 132885795*f**10 - 28776132*f**11 - 2638944*f**12)/3.9520825344e12,
    82: lambda f: (1786785 + 14600586*f + 88617243*f**2 + 352097200*f**3 + 999436851*f**4 + 2132033750*f**5 + 3315874919*f**6 + 3612890148*f**7 + 2688572425*f**8 + 1332462390*f**9 + 420198765*f**10 + 76315932*f**11 + 6083154*f**12)/2.76645777408e12,
    83: lambda f: (-101846745 - 851632782*f - 5207209293*f**2 - 21187650120*f**3 - 61925916269*f**4 - 136375041250*f**5 - 221084258913*f**6 - 252357804916*f**7 - 196331079035*f**8 - 101129965650*f**9 - 32915038275*f**10 - 6127220484*f**11 - 497363328*f**12)/5.256269770752e14,
    84: lambda f: (-765765 - 5571852*f - 26546520*f**2 - 75688080*f**3 - 111506876*f**4 + 53426240*f**5 + 1104352872*f**6 + 2918699504*f**7 + 3682662130*f**8 + 2598107400*f**9 + 1053090360*f**10 + 230209056*f**11 + 21111552*f**12)/1.896999616512e14,
    85: lambda f: (-5360355 - 49417368*f - 340335138*f**2 - 1546911600*f**3 - 5068526132*f**4 - 12615132880*f**5 - 22147756512*f**6 - 26135495344*f**7 - 20427686930*f**8 - 10421994240*f**9 - 3339049140*f**10 - 610527456*f**11 - 48665232*f**12)/1.3278997315584e14,
    86: lambda f: (101846745 + 958329372*f + 6645673320*f**2 + 30866681040*f**3 + 103881752236*f**4 + 266235824960*f**5 + 488701102008*f**6 + 606450333776*f**7 + 496700655430*f**8 + 263636415000*f**9 + 87192491400*f**10 + 16339254624*f**11 + 1326302208*f**12)/8.4100316332032e15,
    87: lambda f: (255255 + 2124694*f + 11958089*f**2 + 42392220*f**3 + 93106076*f**4 + 87290920*f**5 - 555517164*f**6 - 1914717728*f**7 - 2615515630*f**8 - 1908321660*f**9 - 785319570*f**10 - 172656792*f**11 - 15833664*f**12)/1.1381997699072e15,
    88: lambda f: (1786785 + 18344326*f + 141335909*f**2 + 723266700*f**3 + 2686648142*f**4 + 7642448872*f**5 + 14733111012*f**6 + 18382186144*f**7 + 14837405702*f**8 + 7709528484*f**9 + 2494143414*f**10 + 457895592*f**11 + 36498924*f**12)/7.9673983893504e14,
    89: lambda f: (-11316305 - 118336218*f - 917636863*f**2 - 4789799300*f**3 - 18236697572*f**4 - 53298785560*f**5 - 107772743692*f**6 - 141844028704*f**7 - 120172140830*f**8 - 65002579740*f**9 - 21710981250*f**10 - 4084813656*f**11 - 331575552*f**12)/1.68200632664064e16,
    90: lambda f: (-85085 - 797368*f - 5168306*f**2 - 21724300*f**3 - 60941005*f**4 - 104518380*f**5 + 257389976*f**6 + 1157646672*f**7 + 1679014470*f**8 + 1254321600*f**9 + 521547180*f**10 + 115104528*f**11 + 10555776*f**12)/7.587998466048e15,
    91: lambda f: (-595595 - 6738732*f - 57429944*f**2 - 326748500*f**3 - 1356883135*f**4 - 4342425600*f**5 - 9016869586*f**6 - 11721072272*f**7 - 9677743110*f**8 - 5092144680*f**9 - 1658254080*f**10 - 305263728*f**11 - 24332616*f**12)/5.3115989262336e15,
    92: lambda f: (33948915 + 390574184*f + 3348794878*f**2 + 19403998900*f**3 + 82441197315*f**4 + 270544716020*f**5 + 591089077512*f**6 + 812581430864*f**7 + 705090210790*f**8 + 386389382400*f**9 + 129917321100*f**10 + 24508881936*f**11 + 1989453312*f**12)/1.009203795984384e18,
    93: lambda f: (23205 + 241774*f + 1771757*f**2 + 8574800*f**3 + 28786899*f**4 + 66137990*f**5 - 90550813*f**6 - 537209036*f**7 - 816531310*f**8 - 620770500*f**9 - 260059590*f**10 - 57552264*f**11 - 5277888*f**12)/4.5527990796288e16,
    94: lambda f: (162435 + 2008006*f + 18755165*f**2 + 117439400*f**3 + 539138663*f**4 + 1917169390*f**5 + 4228681603*f**6 + 5672132956*f**7 + 4762751420*f**8 + 2529093420*f**9 + 827516970*f**10 + 152631864*f**11 + 12166308*f**12)/3.18695935574016e16,
    95: lambda f: (-3086265 - 38739974*f - 363897937*f**2 - 2317512080*f**3 - 10867855999*f**4 - 39561198270*f**5 - 92085432927*f**6 - 130901770244*f**7 - 115623304090*f**8 - 63966552300*f**9 - 21611390850*f**10 - 4084813656*f**11 - 331575552*f**12)/2.018407591968768e18,
    96: lambda f: (-69615 - 798252*f - 6521268*f**2 - 35616360*f**3 - 138070294*f**4 - 385885040*f**5 + 325111164*f**6 + 2604753928*f**7 + 4111036055*f**8 + 3167885700*f**9 + 1334695320*f**10 + 295983072*f**11 + 27143424*f**12)/3.278015337332736e18,
    97: lambda f: (-487305 - 6534528*f - 66378234*f**2 - 453624600*f**3 - 2281229218*f**4 - 8923429880*f**5 - 20691828264*f**6 - 28450903208*f**7 - 24201319975*f**8 - 12941276040*f**9 - 4249591290*f**10 - 784963872*f**11 - 62569584*f**12)/2.2946107361329152e18,
    98: lambda f: (33948915 + 461705244*f + 4715157876*f**2 + 32735236040*f**3 + 167926752318*f**4 + 671425758960*f**5 + 1647547900372*f**6 + 2404968817944*f**7 + 2153638898565*f**8 + 1200121253100*f**9 + 406942212600*f**10 + 77027914656*f**11 + 6252567552*f**12)/5.3285960427975475e20,
    99: lambda f: (19635 + 245718*f + 2213145*f**2 + 13441220*f**3 + 58815274*f**4 + 191000780*f**5 - 100753466*f**6 - 1138215232*f**7 - 1852859855*f**8 - 1443160950*f**9 - 610753605*f**10 - 135658908*f**11 - 12440736*f**12)/2.4038779140440064e19,
    100: lambda f: (137445 + 1987062*f + 21809997*f**2 + 161528900*f**3 + 883080368*f**4 + 3768426380*f**5 + 9114069646*f**6 + 12785198272*f**7 + 10988104435*f**8 + 5908072170*f**9 + 1945515495*f**10 + 359775108*f**11 + 28677726*f**12)/1.6827145398308045e19,
    101: lambda f: (-7834365 - 114754794*f - 1265916135*f**2 - 9515017980*f**3 - 52998083542*f**4 - 230865948980*f**5 - 592363039482*f**6 - 883488355904*f**7 - 799847010655*f**8 - 448264797750*f**9 - 152432158725*f**10 - 28885467996*f**11 - 2344712832*f**12)/3.1971576256785285e21,
    102: lambda f: (-58905 - 798864*f - 7861854*f**2 - 52500420*f**3 - 255222751*f**4 - 937608140*f**5 + 295678068*f**6 + 5106142216*f**7 + 8529891335*f**8 + 6701947560*f**9 + 2846518290*f**10 + 633074904*f**11 + 58056768*f**12)/2.0192574477969654e21,
    103: lambda f: (-412335 - 6393156*f - 75400644*f**2 - 601580700*f**3 - 3552416917*f**4 - 16423010072*f**5 - 41172410706*f**6 - 58718785832*f**7 - 50889605767*f**8 - 27483845004*f**9 - 9070807284*f**10 - 1678950504*f**11 - 133829388*f**12)/1.4134802134578758e21,
    104: lambda f: (7834365 + 122962224*f + 1457149254*f**2 + 11788175700*f**3 + 70844435291*f**4 + 333935546140*f**5 + 890235835692*f**6 + 1351586626264*f**7 + 1234556350685*f**8 + 695084848920*f**9 + 236903678550*f**10 + 44932950216*f**11 + 3647331072*f**12)/8.95204135189988e22,
    105: lambda f: (58905 + 860574*f + 9185253*f**2 + 66840600*f**3 + 356760385*f**4 + 1456654010*f**5 - 235109427*f**6 - 7409180044*f**7 - 12651821315*f**8 - 10012662450*f**9 - 4265279235*f**10 - 949612356*f**11 - 87085152*f**12)/6.057772343390896e22,
    106: lambda f: (412335 + 6825126*f + 86078157*f**2 + 736032000*f**3 + 4668849145*f**4 + 23244978050*f**5 + 60110287797*f**6 + 86923734044*f**7 + 75858654445*f**8 + 41118800310*f**9 + 13596067485*f**10 + 2518425756*f**11 + 200744082*f**12)/4.240440640373627e22,
    107: lambda f: (-33948915 - 568401834*f - 7201188423*f**2 - 62386222600*f**3 - 402355785035*f**4 - 2040326920030*f**5 - 5622611970143*f**6 - 8665049916796*f**7 - 7973367063935*f**8 - 4506266705850*f**9 - 1538741069775*f**10 - 292064176404*f**11 - 23707651968*f**12)/1.1637653757469843e25,
    108: lambda f: (-255255 - 3996564*f - 45975072*f**2 - 361909600*f**3 - 2101508584*f**4 - 9416552960*f**5 + 412741552*f**6 + 45396787744*f**7 + 78995019740*f**8 + 62898654000*f**9 + 26860557360*f**10 + 5985435456*f**11 + 548900352*f**12)/8.400110982835376e24,
    109: lambda f: (-1786785 - 31447416*f - 422337630*f**2 - 3853002400*f**3 - 26128769208*f**4 - 139381892960*f**5 - 370310717312*f**6 - 541845438624*f**7 - 475643559580*f**8 - 258611196480*f**9 - 85643146680*f**10 - 15873713856*f**11 - 1265296032*f**12)/5.880077687984763e24,
    110: lambda f: (101846745 + 1811902092*f + 24438784656*f**2 + 225732193440*f**3 + 1555049011352*f**4 + 8440923754240*f**5 + 23945410738224*f**6 + 37375688324128*f**7 + 34606734679580*f**8 + 19620855399600*f**9 + 6710387065200*f**10 + 1274461860672*f**11 + 103451572224*f**12)/1.117214760717105e27,
    111: lambda f: (45045 + 752466*f + 9279699*f**2 + 78538980*f**3 + 492501832*f**4 + 2398761200*f**5 + 118371192*f**6 - 11075235136*f**7 - 19590398660*f**8 - 15679931400*f**9 - 6710141340*f**10 - 1496358864*f**11 - 137225088*f**12)/5.040066589701226e25,
    112: lambda f: (315315 + 5879874*f + 83776407*f**2 + 812241300*f**3 + 5864011654*f**4 + 33366842480*f**5 + 90782176728*f**6 + 134188959296*f**7 + 118383481300*f**8 + 64533946680*f**9 + 21399516180*f**10 + 3968428464*f**11 + 316324008*f**12)/3.528046612790858e25,
    113: lambda f: (-5990985 - 112858746*f - 1614623439*f**2 - 15839215860*f**3 - 116073701192*f**4 - 671491599280*f**5 - 1954264310232*f**6 - 3084050436544*f**7 - 2870782672940*f**8 - 1632049536600*f**9 - 558908450100*f**10 - 106205155056*f**11 - 8620964352*f**12)/2.23442952143421e27,
    114: lambda f: (-15015 - 266552*f - 3507790*f**2 - 31754580*f**3 - 213736571*f**4 - 1123032580*f**5 - 140704224*f**6 + 5003876192*f**7 + 8979163060*f**8 + 7219195200*f**9 + 3095011080*f**10 + 690627168*f**11 + 63334656*f**12)/6.048079907641471e26,
    115: lambda f: (-105105 - 2070068*f - 31187728*f**2 - 320225100*f**3 - 2452183097*f**4 - 14825374960*f**5 - 41194836726*f**6 - 61431631072*f**7 - 54430075700*f**8 - 29737879920*f**9 - 9872241120*f**10 - 1831582368*f**11 - 145995696*f**12)/4.2336559353490295e26,
    116: lambda f: (665665 + 13237224*f + 200215730*f**2 + 2078835980*f**3 + 16147286477*f**4 + 99174753340*f**5 + 295269295408*f**6 + 470448417376*f**7 + 439931359700*f**8 + 250686072000*f**9 + 85947611400*f**10 + 16339254624*f**11 + 1326302208*f**12)/8.93771808573684e27,
    117: lambda f: (5005 + 94094*f + 1316029*f**2 + 12685920*f**3 + 91184591*f**4 + 513685710*f**5 + 96857383*f**6 - 2221614444*f**7 - 4037504940*f**8 - 3258888360*f**9 - 1399348860*f**10 - 312426576*f**11 - 28651392*f**12)/7.660901216345863e27,
    118: lambda f: (35035 + 726726*f + 11543389*f**2 + 125130200*f**3 + 1013032747*f**4 + 6484894902*f**5 + 18361445815*f**6 + 27594347900*f**7 + 24541467762*f**8 + 13434416184*f**9 + 4464265764*f**10 + 828572976*f**11 + 66045672*f**12)/5.362630851442104e27,
    119: lambda f: (-105105 - 2200198*f - 35079473*f**2 - 384332000*f**3 - 3154051547*f**4 - 20496950150*f**5 - 62278808931*f**6 - 100065752612*f**7 - 93950429860*f**8 - 53644442040*f**9 - 18410231700*f**10 - 3501268848*f**11 - 284207616*f**12)/5.362630851442104e28,
}

Q024withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: (-2*f*(2 + f))/21.,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (f*(66 + 101*f + 68*f**2 + 17*f**3))/693.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: -(f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/36036.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/72072.,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: -(f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/2.9405376e7,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (f*(14586 + 82433*f + 272340*f**2 + 600185*f**3 + 937500*f**4 + 999050*f**5 + 688800*f**6 + 290850*f**7 + 68250*f**8 + 6825*f**9))/2.9405376e8,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: -(f*(4862 + 32487*f + 128656*f**2 + 345814*f**3 + 673150*f**4 + 843925*f**5 + 641200*f**6 + 284900*f**7 + 68250*f**8 + 6825*f**9))/1.17621504e9,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (f*(14586 + 112489*f + 519316*f**2 + 1647079*f**3 + 3838590*f**4 + 5373165*f**5 + 4321800*f**6 + 1973475*f**7 + 477750*f**8 + 47775*f**9))/4.940103168e10,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: -(f*(14586 + 127517*f + 672384*f**2 + 2457656*f**3 + 6670440*f**4 + 10112060*f**5 + 8443680*f**6 + 3921960*f**7 + 955500*f**8 + 95550*f**9))/7.9041650688e11,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (f*(4862 + 47515*f + 281724*f**2 + 1165911*f**3 + 3611400*f**4 + 5815500*f**5 + 4986240*f**6 + 2343180*f**7 + 573300*f**8 + 57330*f**9))/4.74249904128e12,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: -(f*(14586 + 157573*f + 1037680*f**2 + 4795870*f**3 + 16692750*f**4 + 28183725*f**5 + 24645600*f**6 + 11680200*f**7 + 2866500*f**8 + 286650*f**9))/2.845499424768e14,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (f*(1326 + 15691*f + 113628*f**2 + 580057*f**3 + 2241150*f**4 + 3930925*f**5 + 3490200*f**6 + 1664775*f**7 + 409500*f**8 + 40950*f**9))/5.690998849536e14,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: -(f*(4862 + 62543*f + 493952*f**2 + 2760188*f**3 + 11721380*f**4 + 21213830*f**5 + 19065200*f**6 + 9139900*f**7 + 2252250*f**8 + 225225*f**9))/5.00807898759168e16,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (f*(1122 + 15589*f + 133348*f**2 + 809557*f**3 + 3747780*f**4 + 6963270*f**5 + 6320160*f**6 + 3042270*f**7 + 750750*f**8 + 75075*f**9))/3.004847392555008e17,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: -(f*(1122 + 16745*f + 154224*f**2 + 1010786*f**3 + 5066250*f**4 + 9625175*f**5 + 8808240*f**6 + 4254180*f**7 + 1051050*f**8 + 105105*f**9))/8.413572699154022e18,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (f*(4862 + 77571*f + 765340*f**2 + 5385685*f**3 + 29055250*f**4 + 56269675*f**5 + 51851800*f**6 + 25113725*f**7 + 6210750*f**8 + 621075*f**9))/1.0937644508900229e21,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: -(f*(14586 + 247741*f + 2606848*f**2 + 19603312*f**3 + 113259600*f**4 + 223030200*f**5 + 206740800*f**6 + 100371600*f**7 + 24843000*f**8 + 2484300*f**9))/1.050013872854422e23,
    51: lambda f: 0,
    52: lambda f: 0,
    53: lambda f: (f*(858 + 15457*f + 172788*f**2 + 1382797*f**3 + 8518320*f**4 + 17021320*f**5 + 15859200*f**6 + 7715400*f**7 + 1911000*f**8 + 191100*f**9))/2.100027745708844e23,
    54: lambda f: 0,
    55: lambda f: 0,
    56: lambda f: -(f*(286 + 5447*f + 64464*f**2 + 547026*f**3 + 3579090*f**4 + 7244835*f**5 + 6780480*f**6 + 3304560*f**7 + 819000*f**8 + 81900*f**9))/2.520033294850613e24,
    57: lambda f: 0,
    58: lambda f: 0,
    59: lambda f: (f*(858 + 17225*f + 215156*f**2 + 1929659*f**3 + 13363650*f**4 + 27364275*f**5 + 25711560*f**6 + 12550545*f**7 + 3112200*f**8 + 311220*f**9))/2.8728379561296984e26,
    60: lambda f: (2*f)/63.,
    61: lambda f: (2*f*(28 + 11*f))/441.,
    62: lambda f: (-2*f*(77 + 39*f))/1617.,
    63: lambda f: -(f*(165 + 134*f + 34*f**2))/2079.,
    64: lambda f: -(f*(616 + 793*f + 457*f**2 + 99*f**3))/4851.,
    65: lambda f: (f*(7623 + 9064*f + 5270*f**2 + 1326*f**3))/53361.,
    66: lambda f: (f*(3861 + 7020*f + 6160*f**2 + 2624*f**3 + 435*f**4))/108108.,
    67: lambda f: (f*(108108 + 245661*f + 292354*f**2 + 192670*f**3 + 67570*f**4 + 9945*f**5))/2.270268e6,
    68: lambda f: -(f*(165165 + 355069*f + 407136*f**2 + 270350*f**3 + 101355*f**4 + 16965*f**5))/2.774772e6,
    69: lambda f: -(f*(1859 + 5278*f + 8038*f**2 + 7224*f**3 + 3855*f**4 + 1130*f**5 + 140*f**6))/216216.,
    70: lambda f: -(f*(48048 + 157599*f + 287605*f**2 + 322767*f**3 + 230250*f**4 + 102345*f**5 + 26005*f**6 + 2905*f**7))/4.540536e6,
    71: lambda f: (f*(77077 + 242814*f + 427946*f**2 + 473332*f**3 + 341385*f**4 + 158330*f**5 + 43540*f**6 + 5460*f**7))/5.549544e6,
    72: lambda f: (f*(123981 + 479128*f + 1041488*f**2 + 1434528*f**3 + 1308210*f**4 + 791640*f**5 + 306600*f**6 + 68880*f**7 + 6825*f**8))/8.8216128e7,
    73: lambda f: (f*(1021020 + 4387071*f + 10829068*f**2 + 17259284*f**3 + 18722180*f**4 + 14050626*f**5 + 7218932*f**6 + 2433284*f**7 + 486528*f**8 + 43911*f**9))/6.17512896e8,
    74: lambda f: -(f*(5054049 + 21045167*f + 50431792*f**2 + 78952692*f**3 + 85305690*f**4 + 64839210*f**5 + 34410600*f**6 + 12256020*f**7 + 2654925*f**8 + 266175*f**9))/2.264213952e9,
    75: lambda f: -(f*(2909907 + 14234610*f + 40236110*f**2 + 74755120*f**3 + 96629250*f**4 + 88951428*f**5 + 58386720*f**6 + 26785920*f**7 + 8176035*f**8 + 1492890*f**9 + 123354*f**10))/1.676106432e10,
    76: lambda f: -(f*(69837768 + 371397351*f + 1157342915*f**2 + 2394901265*f**3 + 3497233100*f**4 + 3709916862*f**5 + 2886617874*f**6 + 1636767930*f**7 + 659974980*f**8 + 179704875*f**9 + 29683731*f**10 + 2251557*f**11))/3.5198235072e11,
    77: lambda f: (f*(117366249 + 608401508*f + 1848629130*f**2 + 3759309790*f**3 + 5442915750*f**4 + 5783046456*f**5 + 4559708832*f**6 + 2655538620*f**7 + 1116862425*f**8 + 322686420*f**9 + 57606318*f**10 + 4810806*f**11))/4.3020065088e11,
    78: lambda f: (f*(1154725 + 6835972*f + 23793472*f**2 + 55659360*f**3 + 93179325*f**4 + 109996856*f**5 + 88550840*f**6 + 47028240*f**7 + 15703695*f**8 + 2985780*f**9 + 246708*f**10))/6.704425728e10,
    79: lambda f: (f*(27159132 + 172238781*f + 648719014*f**2 + 1652301978*f**3 + 3036934350*f**4 + 4060492839*f**5 + 3883832428*f**6 + 2598816220*f**7 + 1181289480*f**8 + 346895115*f**9 + 59367462*f**10 + 4503114*f**11))/1.40792940288e12,
    80: lambda f: -(f*(46235189 + 286972257*f + 1057502000*f**2 + 2650359058*f**3 + 4823449725*f**4 + 6401781287*f**5 + 6131679064*f**6 + 4182026940*f**7 + 1981506975*f**8 + 620086215*f**9 + 115212636*f**10 + 9621612*f**11))/1.72080260352e12,
    81: lambda f: -(f*(4018443 + 27923350*f + 115469270*f**2 + 325746792*f**3 + 669719505*f**4 + 930070638*f**5 + 832587420*f**6 + 470893920*f**7 + 162619485*f**8 + 31350690*f**9 + 2590434*f**10))/2.81585880576e12,
    82: lambda f: -(f*(31039008 + 228673341*f + 1010302979*f**2 + 3057245065*f**3 + 6777957970*f**4 + 10663173549*f**5 + 11487105133*f**6 + 8319630865*f**7 + 3972742620*f**8 + 1199532495*f**9 + 207786117*f**10 + 15760899*f**11))/1.971101164032e13,
    83: lambda f: (f*(160044885 + 1157403962*f + 5016385738*f**2 + 14957328960*f**3 + 32828916015*f**4 + 50856817746*f**5 + 54417764772*f**6 + 40021332120*f**7 + 19923060675*f**8 + 6422402070*f**9 + 1209732678*f**10 + 101026926*f**11))/7.227370934784e13,
    84: lambda f: (f*(4572711 + 36480912*f + 174750752*f**2 + 577224256*f**3 + 1407265020*f**4 + 2190546288*f**5 + 2091904080*f**6 + 1225180320*f**7 + 430626210*f**8 + 83601840*f**9 + 6907824*f**10))/4.505374089216e13,
    85: lambda f: (f*(104756652 + 879308391*f + 4458808280*f**2 + 15632494568*f**3 + 40595244200*f**4 + 71991819732*f**5 + 83706796824*f**6 + 63478416120*f**7 + 31134858720*f**8 + 9537858330*f**9 + 1662288936*f**10 + 126087192*f**11))/9.4612855873536e14,
    86: lambda f: -(f*(181384203 + 1497863081*f + 7466819424*f**2 + 25827123928*f**3 + 66416526540*f**4 + 115157553756*f**5 + 132221327952*f**6 + 101586331560*f**7 + 51951145050*f**8 + 17008401270*f**9 + 3225953808*f**10 + 269405136*f**11))/1.15637934956544e15,
    87: lambda f: -(f*(1708993 + 15393534*f + 83824314*f**2 + 317304864*f**3 + 894839580*f**4 + 1515636696*f**5 + 1511559840*f**6 + 905143680*f**7 + 321608070*f**8 + 62701380*f**9 + 5180868*f**10))/2.7032244535296e14,
    88: lambda f: -(f*(12932920 + 121842383*f + 697451639*f**2 + 2780383677*f**3 + 8277866040*f**4 + 16088340876*f**5 + 19721711492*f**6 + 15410436692*f**7 + 7686652344*f**8 + 2375704338*f**9 + 415572234*f**10 + 31521798*f**11))/1.89225711747072e15,
    89: lambda f: (f*(67574507 + 627431376*f + 3536786046*f**2 + 13925551326*f**3 + 41074237620*f**4 + 77564161632*f**5 + 93482408544*f**6 + 73892813400*f**7 + 38433701250*f**8 + 12703199040*f**9 + 2419465356*f**10 + 202053852*f**11))/6.93827609739264e15,
    90: lambda f: (f*(5681247 + 57022420*f + 347883920*f**2 + 1484663040*f**3 + 4754377125*f**4 + 8593487856*f**5 + 8840971440*f**6 + 5375895840*f**7 + 1924202070*f**8 + 376208280*f**9 + 31085208*f**10))/1.62193467211776e16,
    91: lambda f: (f*(14226212 + 148648799*f + 948098670*f**2 + 4235560370*f**3 + 14223085550*f**4 + 29713329111*f**5 + 37859171672*f**6 + 30211152440*f**7 + 15243888240*f**8 + 4739728350*f**9 + 831144468*f**10 + 63043596*f**11))/3.78451423494144e16,
    92: lambda f: -(f*(224062839 + 2310697103*f + 14533552960*f**2 + 64189244130*f**3 + 213648148125*f**4 + 431314133787*f**5 + 538497623664*f**6 + 434211465240*f**7 + 228483577350*f**8 + 76006786590*f**9 + 14516792136*f**10 + 1212323112*f**11))/4.162965658435584e17,
    93: lambda f: -(f*(566865 + 6273306*f + 42384706*f**2 + 201332360*f**3 + 721689825*f**4 + 1373466726*f**5 + 1446403140*f**6 + 889439040*f**7 + 320051970*f**8 + 62701380*f**9 + 5180868*f**10))/3.24386934423552e16,
    94: lambda f: -(f*(12697776 + 145734693*f + 1024862527*f**2 + 5071714669*f**3 + 18963551350*f**4 + 41996935719*f**5 + 55109344563*f**6 + 44665466895*f**7 + 22727171880*f**8 + 7097077890*f**9 + 1246716702*f**10 + 94565394*f**11))/6.812125622894592e17,
    95: lambda f: (f*(22309287 + 253006546*f + 1756632270*f**2 + 8601395684*f**3 + 31893105975*f**4 + 67931395902*f**5 + 87113450844*f**6 + 71283616740*f**7 + 37828378350*f**8 + 12642511140*f**9 + 2419465356*f**10 + 202053852*f**11))/8.325931316871168e17,
    96: lambda f: (f*(2263261 + 27377480*f + 202921520*f**2 + 1061806944*f**3 + 4212016710*f**4 + 8358975592*f**5 + 8964312280*f**6 + 5559911280*f**7 + 2008698615*f**8 + 394122960*f**9 + 32565456*f**10))/2.8546050229272576e18,
    97: lambda f: (f*(50438388 + 630769581*f + 4848691244*f**2 + 26329222260*f**3 + 108485834820*f**4 + 252092678178*f**5 + 338550358916*f**6 + 277691501780*f**7 + 142202823840*f**8 + 44551206315*f**9 + 7836504984*f**10 + 594411048*f**11))/5.994670548147241e19,
    98: lambda f: -(f*(88913825 + 1099806279*f + 8355038416*f**2 + 44924190140*f**3 + 183644092830*f**4 + 408727358974*f**5 + 535253181848*f**6 + 442967489580*f**7 + 236589351075*f**8 + 79348004505*f**9 + 15208067952*f**10 + 1270052784*f**11))/7.326819558846628e19,
    99: lambda f: -(f*(564927 + 7415434*f + 59825414*f**2 + 341909712*f**3 + 1487008590*f**4 + 3055297212*f**5 + 3324552000*f**6 + 2075969280*f**7 + 752370465*f**8 + 147796110*f**9 + 12212046*f**10))/1.7127630137563546e19,
    100: lambda f: -(f*(4178328 + 56551809*f + 471739885*f**2 + 2788855967*f**3 + 12554875100*f**4 + 30374575206*f**5 + 41560613402*f**6 + 34414232930*f**7 + 17711800260*f**8 + 5563164915*f**9 + 979563123*f**10 + 74301381*f**11))/1.1989341096294482e20,
    101: lambda f: (f*(22160061 + 296902892*f + 2449737298*f**2 + 14349663246*f**3 + 64117207530*f**4 + 148030464984*f**5 + 197153244288*f**6 + 164628262260*f**7 + 88374207075*f**8 + 29720732580*f**9 + 5703025482*f**10 + 476269794*f**11))/4.396091735307977e20,
    102: lambda f: (f*(607563 + 8600844*f + 75029024*f**2 + 465006304*f**3 + 2200143855*f**4 + 4654658232*f**5 + 5125484280*f**6 + 3218088720*f**7 + 1169244615*f**8 + 229905060*f**9 + 18996516*f**10))/4.795736438517793e20,
    103: lambda f: (f*(13430340 + 195593619*f + 1759695602*f**2 + 11250930446*f**3 + 54942498170*f**4 + 137560391997*f**5 + 191134664364*f**6 + 159491940636*f**7 + 82417804392*f**8 + 25940022339*f**9 + 4571294574*f**10 + 346739778*f**11))/1.0071046520887365e22,
    104: lambda f: -(f*(23801547 + 343386791*f + 3057993456*f**2 + 19383566566*f**3 + 93987604095*f**4 + 223833658629*f**5 + 302270517528*f**6 + 254244264540*f**7 + 137039415975*f**8 + 46188982455*f**9 + 8871372972*f**10 + 740864124*f**11))/1.2309056858862335e22,
    105: lambda f: -(f*(2817529 + 42787810*f + 401317810*f**2 + 2680912920*f**3 + 13709490375*f**4 + 29736976178*f**5 + 33071167220*f**6 + 20858029920*f**7 + 7594189785*f**8 + 1494382890*f**9 + 123477354*f**10))/6.234457370073131e22,
    106: lambda f: -(f*(62078016 + 967966077*f + 9342615115*f**2 + 64236352065*f**3 + 338207621850*f**4 + 872125027137*f**5 + 1227474843049*f**6 + 1030813825405*f**7 + 534453918180*f**8 + 168496262025*f**9 + 29713414731*f**10 + 2253808557*f**11))/1.3092360477153575e24,
    107: lambda f: (f*(110253143 + 1704096966*f + 16291218830*f**2 + 111104596840*f**3 + 581042303625*f**4 + 1421079411206*f**5 + 1941409256332*f**6 + 1642794819120*f**7 + 888461021175*f**8 + 299998277670*f**9 + 57663924318*f**10 + 4815616806*f**11))/1.6001773916521036e24,
    108: lambda f: (f*(9006855 + 146058016*f + 1465706816*f**2 + 10498688640*f**3 + 57701407800*f**4 + 127885905504*f**5 + 143422678560*f**6 + 90800324160*f**7 + 33116827380*f**8 + 6520943520*f**9 + 538810272*f**10))/5.985079075270205e24,
    109: lambda f: (f*(65957892 + 1096354701*f + 11300157584*f**2 + 83142892528*f**3 + 469492226800*f**4 + 1242116662392*f**5 + 1767428040784*f**6 + 1492241660560*f**7 + 775858050240*f**8 + 244947431820*f**9 + 43219512336*f**10 + 3278266992*f**11))/4.189555352689144e25,
    110: lambda f: -(f*(352098747 + 5804525441*f + 59292360640*f**2 + 432914021424*f**3 + 2428965293400*f**4 + 6079213706808*f**5 + 8387056159776*f**6 + 7132993554960*f**7 + 3868574700900*f**8 + 1308246636060*f**9 + 251624397024*f**10 + 21013600608*f**11))/1.5361702959860194e26,
    111: lambda f: -(f*(562419 + 9699690*f + 103699150*f**2 + 792833216*f**3 + 4660577640*f**4 + 10525477392*f**5 + 11889353280*f**6 + 7551425280*f**7 + 2758222740*f**8 + 543411960*f**9 + 44900856*f**10))/1.197015815054041e25,
    112: lambda f: -(f*(12324312 + 217542039*f + 2384772631*f**2 + 18696149245*f**3 + 112712391280*f**4 + 304985355288*f**5 + 438064374216*f**6 + 371554879080*f**7 + 193640971440*f**8 + 61207657140*f**9 + 10804878084*f**10 + 819566748*f**11))/2.5137332116134863e26,
    113: lambda f: (f*(21966945 + 384748936*f + 4182151674*f**2 + 32549430290*f**3 + 195034070520*f**4 + 498080377344*f**5 + 692981274048*f**6 + 591911008080*f**7 + 321792716700*f**8 + 108961550880*f**9 + 20968699752*f**10 + 1751133384*f**11))/3.0723405919720388e26,
    114: lambda f: (f*(198341 + 3624972*f + 41132112*f**2 + 334328256*f**3 + 2093133195*f**4 + 4806011424*f**5 + 5462677920*f**6 + 3479232960*f**7 + 1272427380*f**8 + 250805520*f**9 + 20723472*f**10))/1.4364189780648492e26,
    115: lambda f: (f*(1445444 + 27002287*f + 313706150*f**2 + 2610662586*f**3 + 16735732950*f**4 + 46195125387*f**5 + 66895868144*f**6 + 56963921840*f**7 + 29748253920*f**8 + 9412711980*f**9 + 1662288936*f**10 + 126087192*f**11))/1.0054932846453945e27,
    116: lambda f: -(f*(7740733 + 143547261*f + 1654369824*f**2 + 13672805118*f**3 + 87140414115*f**4 + 226537025853*f**5 + 317495010336*f**6 + 272199589200*f**7 + 148286898900*f**8 + 50266605060*f**9 + 9677861424*f**10 + 808215408*f**11))/3.6868087103664466e27,
    117: lambda f: -(f*(33033 + 637754*f + 7654834*f**2 + 65914344*f**3 + 437872005*f**4 + 1020252078*f**5 + 1165987620*f**6 + 744428160*f**7 + 272551860*f**8 + 53744040*f**9 + 4440744*f**10))/8.618513868389095e26,
    118: lambda f: -(f*(80080 + 1578421*f + 19372343*f**2 + 170559029*f**3 + 1158516830*f**4 + 3255017259*f**5 + 4747487423*f**6 + 4056580619*f**7 + 2122234128*f**8 + 672098196*f**9 + 118734924*f**10 + 9006228*f**11))/2.010986569290789e27,
    119: lambda f: (f*(1288287 + 25216906*f + 307144766*f**2 + 2686438956*f**3 + 18146100195*f**4 + 47926203246*f**5 + 67600814652*f**6 + 58144757580*f**7 + 31732526700*f**8 + 10767080520*f**9 + 2073827448*f**10 + 173189016*f**11))/2.212085226219868e28,
}

Q040withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: 0,
    3: lambda f: (f**2*(2 + f)**2)/35.,
    4: lambda f: 0,
    5: lambda f: 0,
    6: lambda f: -(f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/770.,
    7: lambda f: 0,
    8: lambda f: 0,
    9: lambda f: (f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/40040.,
    10: lambda f: 0,
    11: lambda f: 0,
    12: lambda f: -(f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/240240.,
    13: lambda f: 0,
    14: lambda f: 0,
    15: lambda f: (f**2*(2 + f)**2*(143 + 520*f + 1100*f**2 + 1512*f**3 + 1218*f**4 + 504*f**5 + 84*f**6))/1.92192e6,
    16: lambda f: 0,
    17: lambda f: 0,
    18: lambda f: -(f**2*(2 + f)**2*(143 + 650*f + 1725*f**2 + 3080*f**3 + 2870*f**4 + 1260*f**5 + 210*f**6))/1.92192e7,
    19: lambda f: 0,
    20: lambda f: 0,
    21: lambda f: (f**2*(2 + f)**2*(143 + 780*f + 2490*f**2 + 5460*f**3 + 5565*f**4 + 2520*f**5 + 420*f**6))/2.306304e8,
    22: lambda f: 0,
    23: lambda f: 0,
    24: lambda f: -(f**2*(2 + f)**2*(143 + 910*f + 3395*f**2 + 8820*f**3 + 9555*f**4 + 4410*f**5 + 735*f**6))/3.2288256e9,
    25: lambda f: 0,
    26: lambda f: 0,
    27: lambda f: (f**2*(2 + f)**2*(143 + 1040*f + 4440*f**2 + 13328*f**3 + 15092*f**4 + 7056*f**5 + 1176*f**6))/5.16612096e10,
    28: lambda f: 0,
    29: lambda f: 0,
    30: lambda f: -(f**2*(2 + f)**2*(143 + 1170*f + 5625*f**2 + 19152*f**3 + 22428*f**4 + 10584*f**5 + 1764*f**6))/9.299017728e11,
    31: lambda f: 0,
    32: lambda f: 0,
    33: lambda f: (f**2*(2 + f)**2*(143 + 1300*f + 6950*f**2 + 26460*f**3 + 31815*f**4 + 15120*f**5 + 2520*f**6))/1.8598035456e13,
    34: lambda f: 0,
    35: lambda f: 0,
    36: lambda f: -(f**2*(2 + f)**2*(13 + 130*f + 765*f**2 + 3220*f**3 + 3955*f**4 + 1890*f**5 + 315*f**6))/3.7196070912e13,
    37: lambda f: 0,
    38: lambda f: 0,
    39: lambda f: (f**2*(2 + f)**2*(143 + 1560*f + 10020*f**2 + 46200*f**3 + 57750*f**4 + 27720*f**5 + 4620*f**6))/9.819762720768e15,
    40: lambda f: 0,
    41: lambda f: 0,
    42: lambda f: -(f**2*(2 + f)**2*(11 + 130*f + 905*f**2 + 4536*f**3 + 5754*f**4 + 2772*f**5 + 462*f**6))/1.9639525441536e16,
    43: lambda f: 0,
    44: lambda f: 0,
    45: lambda f: (f**2*(2 + f)**2*(11 + 140*f + 1050*f**2 + 5684*f**3 + 7301*f**4 + 3528*f**5 + 588*f**6))/5.49906712363008e17,
    46: lambda f: 0,
    47: lambda f: 0,
    48: lambda f: -(f**2*(2 + f)**2*(143 + 1950*f + 15675*f**2 + 91140*f**3 + 118335*f**4 + 57330*f**5 + 9555*f**6))/2.1446361782157312e20,
    49: lambda f: 0,
    50: lambda f: 0,
    51: lambda f: (f**2*(2 + f)**2*(143 + 2080*f + 17840*f**2 + 110880*f**3 + 145320*f**4 + 70560*f**5 + 11760*f**6))/6.86283577029034e21,
    52: lambda f: 0,
    53: lambda f: 0,
    54: lambda f: -(f**2*(2 + f)**2*(143 + 2210*f + 20145*f**2 + 133280*f**3 + 176120*f**4 + 85680*f**5 + 14280*f**6))/2.3333641618987155e23,
    55: lambda f: 0,
    56: lambda f: 0,
    57: lambda f: (f**2*(2 + f)**2*(143 + 2340*f + 22590*f**2 + 158508*f**3 + 210987*f**4 + 102816*f**5 + 17136*f**6))/8.400110982835376e24,
    58: lambda f: 0,
    59: lambda f: 0,
    60: lambda f: 0,
    61: lambda f: (4*f**2)/35.,
    62: lambda f: 0,
    63: lambda f: (2*f**2*(2 + f)**2)/105.,
    64: lambda f: (-2*f**2*(121 + 112*f + 34*f**2))/1155.,
    65: lambda f: 0,
    66: lambda f: -(f**2*(2 + f)**2*(11 + 10*f + 5*f**2))/770.,
    67: lambda f: (f**2*(1287 + 2392*f + 2010*f**2 + 840*f**3 + 145*f**4))/10010.,
    68: lambda f: 0,
    69: lambda f: (f**2*(2 + f)**2*(143 + 260*f + 270*f**2 + 140*f**3 + 35*f**4))/30030.,
    70: lambda f: -(f**2*(2431 + 6760*f + 9388*f**2 + 7780*f**3 + 3925*f**4 + 1120*f**5 + 140*f**6))/60060.,
    71: lambda f: 0,
    72: lambda f: -(f**2*(2 + f)**2*(143 + 390*f + 615*f**2 + 588*f**3 + 357*f**4 + 126*f**5 + 21*f**6))/144144.,
    73: lambda f: (f**2*(201773 + 746096*f + 1444388*f**2 + 1787040*f**3 + 1493850*f**4 + 846720*f**5 + 313740*f**6 + 68880*f**7 + 6825*f**8))/2.450448e7,
    74: lambda f: 0,
    75: lambda f: (f**2*(2 + f)**2*(2431 + 8840*f + 18700*f**2 + 25704*f**3 + 24402*f**4 + 15960*f**5 + 6972*f**6 + 1848*f**7 + 231*f**8))/1.633632e7,
    76: lambda f: -(f**2*(1893749 + 8733920*f + 21670070*f**2 + 35620440*f**3 + 41522410*f**4 + 35150976*f**5 + 21603540*f**6 + 9434040*f**7 + 2783865*f**8 + 498960*f**9 + 41118*f**10))/1.5519504e9,
    77: lambda f: 0,
    78: lambda f: -(f**2*(2 + f)**2*(2431 + 11050*f + 29325*f**2 + 52360*f**3 + 64630*f**4 + 53100*f**5 + 27330*f**6 + 7920*f**7 + 990*f**8))/1.400256e8,
    79: lambda f: (f**2*(2632773 + 14545336*f + 43997122*f**2 + 90142840*f**3 + 131871685*f**4 + 137702656*f**5 + 100720340*f**6 + 50060640*f**7 + 16054815*f**8 + 2993760*f**9 + 246708*f**10))/1.86234048e10,
    80: lambda f: 0,
    81: lambda f: (f**2*(2 + f)**2*(9724 + 53040*f + 169320*f**2 + 371280*f**3 + 544740*f**4 + 504000*f**5 + 278040*f**6 + 83160*f**7 + 10395*f**8))/5.8810752e9,
    82: lambda f: -(f**2*(10484903 + 67486328*f + 240751280*f**2 + 590527980*f**3 + 1016638035*f**4 + 1202328288*f**5 + 957993120*f**6 + 502734120*f**7 + 166306245*f**8 + 31434480*f**9 + 2590434*f**10))/7.821830016e11,
    83: lambda f: 0,
    84: lambda f: -(f**2*(2 + f)**2*(2431 + 15470*f + 57715*f**2 + 149940*f**3 + 248675*f**4 + 247450*f**5 + 141855*f**6 + 43120*f**7 + 5390*f**8))/1.82966784e10,
    85: lambda f: (f**2*(4480333 + 32920160*f + 135274984*f**2 + 386359680*f**3 + 751293060*f**4 + 963868416*f**5 + 807717960*f**6 + 436695840*f**7 + 146819190*f**8 + 27941760*f**9 + 2302608*f**10))/4.1716426752e12,
    86: lambda f: 0,
    87: lambda f: (f**2*(2 + f)**2*(2431 + 17680*f + 75480*f**2 + 226576*f**3 + 411796*f**4 + 430416*f**5 + 252840*f**6 + 77616*f**7 + 9702*f**8))/2.6347216896e11,
    88: lambda f: -(f**2*(5588869 + 46155408*f + 214639314*f**2 + 699462960*f**3 + 1494664260*f**4 + 2030171136*f**5 + 1758572760*f**6 + 968824080*f**7 + 328981590*f**8 + 62868960*f**9 + 5180868*f**10))/7.50895681536e13,
    89: lambda f: 0,
    90: lambda f: -(f**2*(2 + f)**2*(2431 + 19890*f + 95625*f**2 + 325584*f**3 + 635292*f**4 + 687960*f**5 + 411012*f**6 + 127008*f**7 + 15876*f**8))/4.3113627648e12,
    91: lambda f: (f**2*(20461727 + 187611320*f + 973906370*f**2 + 3565493640*f**3 + 8213324085*f**4 + 11635577856*f**5 + 10317351240*f**6 + 5757978240*f**7 + 1968443190*f**8 + 377213760*f**9 + 31085208*f**10))/4.505374089216e15,
    92: lambda f: 0,
    93: lambda f: (f**2*(2 + f)**2*(2431 + 22100*f + 118150*f**2 + 449820*f**3 + 928935*f**4 + 1033200*f**5 + 624960*f**6 + 194040*f**7 + 24255*f**8))/7.9041650688e13,
    94: lambda f: -(f**2*(743223 + 7491016*f + 42934452*f**2 + 174439380*f**3 + 427187545*f**4 + 625034592*f**5 + 563929380*f**6 + 317706480*f**7 + 109141830*f**8 + 20956320*f**9 + 1726956*f**10))/3.003582726144e15,
    95: lambda f: 0,
    96: lambda f: -(f**2*(2 + f)**2*(2873 + 28730*f + 169065*f**2 + 711620*f**3 + 1539335*f**4 + 1748250*f**5 + 1067535*f**6 + 332640*f**7 + 41580*f**8))/1.896999616512e15,
    97: lambda f: (f**2*(9653501 + 106083536*f + 665308940*f**2 + 2970308000*f**3 + 7653051230*f**4 + 11486744192*f**5 + 10503534580*f**6 + 5960188080*f**7 + 2055046455*f**8 + 395176320*f**9 + 32565456*f**10))/7.92945839702016e17,
    98: lambda f: 0,
    99: lambda f: (f**2*(2 + f)**2*(2431 + 26520*f + 170340*f**2 + 785400*f**3 + 1765830*f**4 + 2039400*f**5 + 1254660*f**6 + 392040*f**7 + 49005*f**8))/3.5771992768512e16,
    100: lambda f: -(f**2*(2597243 + 30904640*f + 210504914*f**2 + 1024310520*f**3 + 2754639570*f**4 + 4220802432*f**5 + 3900827700*f**6 + 2226073080*f**7 + 769750905*f**8 + 148191120*f**9 + 12212046*f**10))/4.757675038212096e18,
    101: lambda f: 0,
    102: lambda f: -(f**2*(2 + f)**2*(187 + 2210*f + 15385*f**2 + 77112*f**3 + 179130*f**4 + 209748*f**5 + 129822*f**6 + 40656*f**7 + 5082*f**8))/6.67743865012224e16,
    103: lambda f: (f**2*(998393 + 12788216*f + 94007858*f**2 + 495159000*f**3 + 1381245565*f**4 + 2152813824*f**5 + 2006917500*f**6 + 1150527840*f**7 + 398760285*f**8 + 76839840*f**9 + 6332172*f**10))/4.44049670233129e19,
    104: lambda f: 0,
    105: lambda f: (f**2*(2 + f)**2*(1496 + 19040*f + 142800*f**2 + 773024*f**3 + 1846712*f**4 + 2187360*f**5 + 1360632*f**6 + 426888*f**7 + 53361*f**8))/1.4022621165256704e19,
    106: lambda f: -(f**2*(14826669 + 203399560*f + 1604961160*f**2 + 9097404820*f**3 + 26192645605*f**4 + 41412480928*f**5 + 38884238120*f**6 + 22375746120*f**7 + 7769925345*f**8 + 1498376880*f**9 + 123477354*f**10))/1.731793713909203e22,
    107: lambda f: 0,
    108: lambda f: -(f**2*(2 + f)**2*(41327 + 563550*f + 4530075*f**2 + 26339460*f**3 + 64469055*f**4 + 77108850*f**5 + 48166755*f**6 + 15135120*f**7 + 1891890*f**8))/1.093764450890023e22,
    109: lambda f: (f**2*(50392199 + 737142848*f + 6214194416*f**2 + 37715650560*f**3 + 111627758040*f**4 + 178654984704*f**5 + 168766360560*f**6 + 97423085760*f**7 + 33883673460*f**8 + 6538371840*f**9 + 538810272*f**10))/1.6625219653528348e24,
    110: lambda f: 0,
    111: lambda f: (f**2*(2 + f)**2*(2431 + 35360*f + 303280*f**2 + 1884960*f**3 + 4712680*f**4 + 5684000*f**5 + 3563280*f**6 + 1121120*f**7 + 140140*f**8))/1.9444701349155963e22,
    112: lambda f: -(f**2*(1111253 + 17266288*f + 154868810*f**2 + 1002023520*f**3 + 3038667720*f**4 + 4914545664*f**5 + 4666581360*f**6 + 2701107360*f**7 + 940708860*f**8 + 181621440*f**9 + 14966952*f**10))/1.1083479769018899e24,
    113: lambda f: 0,
    114: lambda f: -(f**2*(2 + f)**2*(2717 + 41990*f + 382755*f**2 + 2532320*f**3 + 6450920*f**4 + 7837200*f**5 + 4928280*f**6 + 1552320*f**7 + 194040*f**8))/7.000092485696147e23,
    115: lambda f: (f**2*(1241669 + 20421960*f + 194185662*f**2 + 1334235480*f**3 + 4134289515*f**4 + 6747869184*f**5 + 6436078320*f**6 + 3733954560*f**7 + 1301921460*f**8 + 251475840*f**9 + 20723472*f**10))/3.990052716846803e25,
    116: lambda f: 0,
    117: lambda f: (f**2*(2 + f)**2*(143 + 2340*f + 22590*f**2 + 158508*f**3 + 410571*f**4 + 501984*f**5 + 316512*f**6 + 99792*f**7 + 12474*f**8))/1.2600166474253064e24,
    118: lambda f: -(f**2*(217789 + 3780088*f + 37981684*f**2 + 276188940*f**3 + 872442855*f**4 + 1435438368*f**5 + 1374457140*f**6 + 799011360*f**7 + 278872020*f**8 + 53887680*f**9 + 4440744*f**10))/2.3940316301080822e26,
    119: lambda f: 0,
}

Q042withhex20 = {
    0: lambda f: 0,
    1: lambda f: (-6*f*(2 + f))/35.,
    2: lambda f: 0,
    3: lambda f: 0,
    4: lambda f: (f*(66 + 101*f + 68*f**2 + 17*f**3))/385.,
    5: lambda f: 0,
    6: lambda f: 0,
    7: lambda f: -(f*(858 + 2197*f + 2928*f**2 + 2182*f**3 + 870*f**4 + 145*f**5))/20020.,
    8: lambda f: 0,
    9: lambda f: 0,
    10: lambda f: (f*(286 + 1027*f + 2044*f**2 + 2521*f**3 + 1990*f**4 + 985*f**5 + 280*f**6 + 35*f**7))/40040.,
    11: lambda f: 0,
    12: lambda f: 0,
    13: lambda f: -(f*(14586 + 67405*f + 178432*f**2 + 306748*f**3 + 360900*f**4 + 295350*f**5 + 166320*f**6 + 61740*f**7 + 13650*f**8 + 1365*f**9))/1.633632e7,
    14: lambda f: 0,
    15: lambda f: 0,
    16: lambda f: (f*(14586 + 82433*f + 272340*f**2 + 600185*f**3 + 937500*f**4 + 999050*f**5 + 688800*f**6 + 290850*f**7 + 68250*f**8 + 6825*f**9))/1.633632e8,
    17: lambda f: 0,
    18: lambda f: 0,
    19: lambda f: -(f*(4862 + 32487*f + 128656*f**2 + 345814*f**3 + 673150*f**4 + 843925*f**5 + 641200*f**6 + 284900*f**7 + 68250*f**8 + 6825*f**9))/6.534528e8,
    20: lambda f: 0,
    21: lambda f: 0,
    22: lambda f: (f*(14586 + 112489*f + 519316*f**2 + 1647079*f**3 + 3838590*f**4 + 5373165*f**5 + 4321800*f**6 + 1973475*f**7 + 477750*f**8 + 47775*f**9))/2.74450176e10,
    23: lambda f: 0,
    24: lambda f: 0,
    25: lambda f: -(f*(14586 + 127517*f + 672384*f**2 + 2457656*f**3 + 6670440*f**4 + 10112060*f**5 + 8443680*f**6 + 3921960*f**7 + 955500*f**8 + 95550*f**9))/4.391202816e11,
    26: lambda f: 0,
    27: lambda f: 0,
    28: lambda f: (f*(4862 + 47515*f + 281724*f**2 + 1165911*f**3 + 3611400*f**4 + 5815500*f**5 + 4986240*f**6 + 2343180*f**7 + 573300*f**8 + 57330*f**9))/2.6347216896e12,
    29: lambda f: 0,
    30: lambda f: 0,
    31: lambda f: -(f*(14586 + 157573*f + 1037680*f**2 + 4795870*f**3 + 16692750*f**4 + 28183725*f**5 + 24645600*f**6 + 11680200*f**7 + 2866500*f**8 + 286650*f**9))/1.58083301376e14,
    32: lambda f: 0,
    33: lambda f: 0,
    34: lambda f: (f*(1326 + 15691*f + 113628*f**2 + 580057*f**3 + 2241150*f**4 + 3930925*f**5 + 3490200*f**6 + 1664775*f**7 + 409500*f**8 + 40950*f**9))/3.16166602752e14,
    35: lambda f: 0,
    36: lambda f: 0,
    37: lambda f: -(f*(4862 + 62543*f + 493952*f**2 + 2760188*f**3 + 11721380*f**4 + 21213830*f**5 + 19065200*f**6 + 9139900*f**7 + 2252250*f**8 + 225225*f**9))/2.7822661042176e16,
    38: lambda f: 0,
    39: lambda f: 0,
    40: lambda f: (f*(1122 + 15589*f + 133348*f**2 + 809557*f**3 + 3747780*f**4 + 6963270*f**5 + 6320160*f**6 + 3042270*f**7 + 750750*f**8 + 75075*f**9))/1.66935966253056e17,
    41: lambda f: 0,
    42: lambda f: 0,
    43: lambda f: -(f*(1122 + 16745*f + 154224*f**2 + 1010786*f**3 + 5066250*f**4 + 9625175*f**5 + 8808240*f**6 + 4254180*f**7 + 1051050*f**8 + 105105*f**9))/4.674207055085568e18,
    44: lambda f: 0,
    45: lambda f: 0,
    46: lambda f: (f*(4862 + 77571*f + 765340*f**2 + 5385685*f**3 + 29055250*f**4 + 56269675*f**5 + 51851800*f**6 + 25113725*f**7 + 6210750*f**8 + 621075*f**9))/6.076469171611238e20,
    47: lambda f: 0,
    48: lambda f: 0,
    49: lambda f: -(f*(14586 + 247741*f + 2606848*f**2 + 19603312*f**3 + 113259600*f**4 + 223030200*f**5 + 206740800*f**6 + 100371600*f**7 + 24843000*f**8 + 2484300*f**9))/5.833410404746789e22,
    50: lambda f: 0,
    51: lambda f: 0,
    52: lambda f: (f*(858 + 15457*f + 172788*f**2 + 1382797*f**3 + 8518320*f**4 + 17021320*f**5 + 15859200*f**6 + 7715400*f**7 + 1911000*f**8 + 191100*f**9))/1.1666820809493578e23,
    53: lambda f: 0,
    54: lambda f: 0,
    55: lambda f: -(f*(286 + 5447*f + 64464*f**2 + 547026*f**3 + 3579090*f**4 + 7244835*f**5 + 6780480*f**6 + 3304560*f**7 + 819000*f**8 + 81900*f**9))/1.4000184971392293e24,
    56: lambda f: 0,
    57: lambda f: 0,
    58: lambda f: (f*(858 + 17225*f + 215156*f**2 + 1929659*f**3 + 13363650*f**4 + 27364275*f**5 + 25711560*f**6 + 12550545*f**7 + 3112200*f**8 + 311220*f**9))/1.5960210867387213e26,
    59: lambda f: 0,
    60: lambda f: (-2*f)/35.,
    61: lambda f: (-2*f*(28 + 11*f))/245.,
    62: lambda f: (6*f*(77 + 39*f))/2695.,
    63: lambda f: (f*(990 + 469*f - 200*f**2 - 176*f**3))/23100.,
    64: lambda f: (f*(4158 + 5689*f + 3400*f**2 + 748*f**3))/16170.,
    65: lambda f: (-3*f*(30030 + 45721*f + 30720*f**2 + 7716*f**3))/700700.,
    66: lambda f: (f*(-8580 - 10517*f - 500*f**2 + 8743*f**3 + 6570*f**4 + 1560*f**5))/600600.,
    67: lambda f: -(f*(42042 + 100178*f + 123860*f**2 + 85319*f**3 + 31320*f**4 + 4785*f**5))/420420.,
    68: lambda f: (f*(60060 + 152893*f + 201220*f**2 + 148243*f**3 + 58770*f**4 + 9810*f**5))/1.4014e6,
    69: lambda f: -(f*(-7150 - 14937*f - 9400*f**2 + 10978*f**3 + 24470*f**4 + 19195*f**5 + 7280*f**6 + 1120*f**7))/2.4024e6,
    70: lambda f: (f*(38038 + 129545*f + 244120*f**2 + 284534*f**3 + 211810*f**4 + 98645*f**5 + 26320*f**6 + 3080*f**7))/1.68168e6,
    71: lambda f: -(f*(850850 + 3038971*f + 5964960*f**2 + 7281406*f**3 + 5711190*f**4 + 2813815*f**5 + 797160*f**6 + 99540*f**7))/9.52952e7,
    72: lambda f: (f*(-109395 - 329069*f - 409700*f**2 + 10081*f**3 + 766740*f**4 + 1192545*f**5 + 966000*f**6 + 460635*f**7 + 122955*f**8 + 14280*f**9))/2.450448e8,
    73: lambda f: -(f*(1225224 + 5429749*f + 13769320*f**2 + 22649746*f**3 + 25465980*f**4 + 19888920*f**5 + 10673040*f**6 + 3769710*f**7 + 791700*f**8 + 75075*f**9))/3.4306272e8,
    74: lambda f: (f*(4849845 + 22305088*f + 58262740*f**2 + 99287293*f**3 + 116268220*f**4 + 94913815*f**5 + 53367160*f**6 + 19780775*f**7 + 4364955*f**8 + 435645*f**9))/3.6212176e9,
    75: lambda f: -(f*(-1939938 - 7679971*f - 14405800*f**2 - 9952276*f**3 + 15188220*f**4 + 49510230*f**5 + 66762864*f**6 + 55592460*f**7 + 30445590*f**8 + 10768485*f**9 + 2245320*f**10 + 210672*f**11))/3.72468096e10,
    76: lambda f: (f*(56258202 + 307119059*f + 979400600*f**2 + 2081773760*f**3 + 3133660500*f**4 + 3438076218*f**5 + 2775393936*f**6 + 1637673660*f**7 + 689225250*f**8 + 196432635*f**9 + 34045704*f**10 + 2713788*f**11))/1.303638336e11,
    77: lambda f: -(f*(13579566 + 76417601*f + 249356000*f**2 + 545420384*f**3 + 849121020*f**4 + 966818046*f**5 + 811796832*f**6 + 498948660*f**7 + 218906310*f**8 + 65068185*f**9 + 11764368*f**10 + 978516*f**11))/8.69092224e10,
    78: lambda f: (f*(-1847560 - 9107631*f - 22900700*f**2 - 29598751*f**3 - 1311950*f**4 + 80448050*f**5 + 173788720*f**6 + 194059250*f**7 + 128866500*f**8 + 51129225*f**9 + 11226600*f**10 + 1053360*f**11))/3.72468096e11,
    79: lambda f: -(f*(10992982 + 71315816*f + 274065500*f**2 + 714443377*f**3 + 1347956900*f**4 + 1859524393*f**5 + 1846468736*f**6 + 1289499610*f**7 + 614013750*f**8 + 189300510*f**9 + 34045704*f**10 + 2713788*f**11))/2.607276672e11,
    80: lambda f: (f*(12932920 + 86083699*f + 337037580*f**2 + 900014629*f**3 + 1747771050*f**4 + 2505457480*f**5 + 2609429760*f**6 + 1920232650*f**7 + 963582900*f**8 + 312271575*f**9 + 58821840*f**10 + 4892580*f**11))/8.69092224e11,
    81: lambda f: -(f*(-12471030 - 73747037*f - 232883000*f**2 - 430227602*f**3 - 351108030*f**4 + 722578185*f**5 + 2611684320*f**6 + 3500584500*f**7 + 2542666350*f**8 + 1054721325*f**9 + 235758600*f**10 + 22120560*f**11))/3.1287320064e13,
    82: lambda f: (f*(75657582 + 568657973*f + 2557552760*f**2 + 7899016034*f**3 + 17918423670*f**4 + 29072055663*f**5 + 32570914656*f**6 + 24677092860*f**7 + 12367808250*f**8 + 3925385835*f**9 + 714959784*f**10 + 56989548*f**11))/2.19011240448e13,
    83: lambda f: -(f*(29099070 + 223634541*f + 1021610240*f**2 + 3221486366*f**3 + 7494926390*f**4 + 12698881055*f**5 + 15060418520*f**6 + 12123168400*f**7 + 6439533450*f**8 + 2155405875*f**9 + 411752880*f**10 + 34248060*f**11))/2.4334582272e13,
    84: lambda f: (f*(-3464175 - 23925902*f - 91021400*f**2 - 216504962*f**3 - 301452480*f**4 + 199314570*f**5 + 1411623360*f**6 + 2144702070*f**7 + 1640600850*f**8 + 696816750*f**9 + 157172400*f**10 + 14747040*f**11))/1.25149280256e14,
    85: lambda f: -(f*(42678636 + 364704145*f + 1879110640*f**2 + 6709238428*f**3 + 17781626520*f**4 + 32535204744*f**5 + 39410286048*f**6 + 31315118940*f**7 + 16139424000*f**8 + 5200564530*f**9 + 953279712*f**10 + 75986064*f**11))/1.752089923584e14,
    86: lambda f: (f*(24249225 + 211323073*f + 1103484280*f**2 + 4012559878*f**3 + 10877091120*f**4 + 20910497790*f**5 + 27021269520*f**6 + 22941115470*f**7 + 12573520050*f**8 + 4280316600*f**9 + 823505760*f**10 + 68496120*f**11))/2.92014987264e14,
    87: lambda f: -(f*(-5080790 - 40171833*f - 178877400*f**2 - 518058408*f**3 - 979622520*f**4 + 136858740*f**5 + 3661523040*f**6 + 6096907320*f**7 + 4823684460*f**8 + 2079054810*f**9 + 471517200*f**10 + 44241120*f**11))/3.003582726144e15,
    88: lambda f: (f*(31685654 + 303381949*f + 1761913320*f**2 + 7140216036*f**3 + 21651361080*f**4 + 43450830876*f**5 + 55571000352*f**6 + 45552130680*f**7 + 23893247700*f**8 + 7770891870*f**9 + 1429919568*f**10 + 113979096*f**11))/2.1025079083008e15,
    89: lambda f: -(f*(35565530 + 346556067*f + 2036295360*f**2 + 8387807412*f**3 + 25957574280*f**4 + 55073083620*f**5 + 75611813760*f**6 + 66489834600*f**7 + 37170575820*f**8 + 12786058530*f**9 + 2470517280*f**10 + 205488360*f**11))/7.008359694336e15,
    90: lambda f: (f*(-1662804 - 14818271*f - 75614300*f**2 - 257475251*f**3 - 605276730*f**4 - 88950420*f**5 + 1973218464*f**6 + 3524133060*f**7 + 2854963440*f**8 + 1242874710*f**9 + 282910320*f**10 + 26544672*f**11))/1.8021496356864e16,
    91: lambda f: -(f*(52378326 + 555435322*f + 3589725100*f**2 + 16278552385*f**3 + 55581156000*f**4 + 120007704843*f**5 + 159726159936*f**6 + 133827234660*f**7 + 71047966500*f**8 + 23252765760*f**9 + 4289758704*f**10 + 341937288*f**11))/6.3075237249024e16,
    92: lambda f: (f*(3879876 + 41801045*f + 272967300*f**2 + 1256199003*f**3 + 4369515690*f**4 + 10033096782*f**5 + 14407546944*f**6 + 12988345020*f**7 + 7360783920*f**8 + 2549892870*f**9 + 494103456*f**10 + 41097672*f**11))/1.4016719388672e16,
    93: lambda f: (f*(1637610 + 16245931*f + 93476200*f**2 + 365333026*f**3 + 1018758150*f**4 + 340054275*f**5 - 3027432240*f**6 - 5714793000*f**7 - 4711549500*f**8 - 2066031450*f**9 - 471517200*f**10 - 44241120*f**11))/3.6042992713728e17,
    94: lambda f: (f*(10405122 + 121052971*f + 861699400*f**2 + 4323217402*f**3 + 16413101550*f**4 + 37603384131*f**5 + 51596736912*f**6 + 43937601120*f**7 + 23532232500*f**8 + 7736657670*f**9 + 1429919568*f**10 + 113979096*f**11))/2.52300948996096e17,
    95: lambda f: -(f*(126095970 + 1488381739*f + 10693677280*f**2 + 54375815494*f**3 + 209991736350*f**4 + 514421212635*f**5 + 764690046120*f**6 + 702239838300*f**7 + 401962245300*f**8 + 139956582150*f**9 + 27175690080*f**10 + 2260371960*f**11))/9.25103479652352e18,
    96: lambda f: (f*(-1616615 - 17673591*f - 113211500*f**2 - 498972661*f**3 - 1602958940*f**4 - 749632345*f**5 + 4454092720*f**6 + 8793987125*f**7 + 7348797225*f**8 + 3240225450*f**9 + 740955600*f**10 + 69521760*f**11))/7.92945839702016e18,
    97: lambda f: -(f*(20692672 + 262046993*f + 2037135160*f**2 + 11203170374*f**3 + 46814282020*f**4 + 112643517536*f**5 + 158316325552*f**6 + 136510744370*f**7 + 73603876500*f**8 + 24281586945*f**9 + 4494032928*f**10 + 358220016*f**11))/1.1101241755828224e19,
    98: lambda f: (f*(11316305 + 145226614*f + 1138516860*f**2 + 6338905039*f**3 + 26909949660*f**4 + 69577998985*f**5 + 106300646760*f**6 + 99025212825*f**7 + 57114513225*f**8 + 19962991125*f**9 + 3882241440*f**10 + 322910280*f**11))/1.850206959304704e19,
    99: lambda f: (f*(1598850 + 19101251*f + 134820200*f**2 + 661107356*f**3 + 2398002540*f**4 + 1365563790*f**5 - 6331599120*f**6 - 12974175060*f**7 - 10958951850*f**8 - 4852876875*f**9 - 1111433400*f**10 - 104282640*f**11))/1.9030700152848384e20,
    100: lambda f: (f*(10296594 + 140997575*f + 1188549560*f**2 + 7109806232*f**3 + 32426806380*f**4 + 81306111942*f**5 + 116510002224*f**6 + 101463880980*f**7 + 54996075750*f**8 + 18191576865*f**9 + 3370524696*f**10 + 268665012*f**11))/1.3321490106993869e20,
    101: lambda f: -(f*(3730650 + 51719083*f + 439331680*f**2 + 2658178888*f**3 + 12303187420*f**4 + 33298008910*f**5 + 52015939360*f**6 + 49010242820*f**7 + 28437220350*f**8 + 9969515325*f**9 + 1941120720*f**10 + 161455140*f**11))/1.4801655674437632e20,
    102: lambda f: (f*(-852720 - 11054029*f - 85239700*f**2 - 460088629*f**3 - 1856702610*f**4 - 1207051230*f**5 + 4709280240*f**6 + 9956461410*f**7 + 8483655180*f**8 + 3769817205*f**9 + 864448200*f**10 + 81108720*f**11))/2.664298021398774e21,
    103: lambda f: -(f*(5521362 + 81293932*f + 738578260*f**2 + 4774470043*f**3 + 23600554740*f**4 + 61289156271*f**5 + 89240985792*f**6 + 78345347850*f**7 + 42646030350*f**8 + 14136800370*f**9 + 2621519208*f**10 + 208961676*f**11))/1.8650086149791416e21,
    104: lambda f: (f*(77597520 + 1155678173*f + 10574109140*f**2 + 69084002603*f**3 + 346217778270*f**4 + 974449241220*f**5 + 1550472880320*f**6 + 1474476289650*f**7 + 859682803980*f**8 + 302117911095*f**9 + 58880661840*f**10 + 4897472580*f**11))/8.081703998242947e22,
    105: lambda f: (f*(1570426 + 21956571*f + 183657800*f**2 + 1081714726*f**3 + 4801859930*f**4 + 3437697445*f**5 - 11790024064*f**6 - 25601144660*f**7 - 21972467790*f**8 - 9791648685*f**9 - 2247565320*f**10 - 210882672*f**11))/1.3854349711273624e23,
    106: lambda f: (f*(51085034 + 804767743*f + 7839274600*f**2 + 54458888510*f**3 + 290010390250*f**4 + 776273412593*f**5 + 1145547247936*f**6 + 1012424345660*f**7 + 553029545250*f**8 + 183648600135*f**9 + 34079749704*f**10 + 2716501788*f**11))/4.849022398945768e23,
    107: lambda f: -(f*(10992982 + 175043713*f + 1716292800*f**2 + 12041717134*f**3 + 64960044870*f**4 + 189146361271*f**5 + 305645171832*f**6 + 292907301960*f**7 + 171459907710*f**8 + 60376009785*f**9 + 11776132368*f**10 + 979494516*f**11))/3.232681599297179e23,
    108: lambda f: (f*(-6235515 - 93536924*f - 843546800*f**2 - 5382455204*f**3 - 26046674400*f**4 - 20077407900*f**5 + 62260074240*f**6 + 138346477500*f**7 + 119463298500*f**8 + 53364101700*f**9 + 12259447200*f**10 + 1150269120*f**11))/1.662521965352835e25,
    109: lambda f: -(f*(81477396 + 1367475733*f + 14217426400*f**2 + 105628103416*f**3 + 602878671600*f**4 + 1656815475312*f**5 + 2472964799424*f**6 + 2197910913240*f**7 + 1204121100000*f**8 + 400451846340*f**9 + 74355817536*f**10 + 5926912992*f**11))/2.3275307514939686e25,
    110: lambda f: (f*(14549535 + 246661857*f + 2580149840*f**2 + 19348334372*f**3 + 111785907200*f**4 + 335303065220*f**5 + 549009100640*f**6 + 529550688100*f**7 + 311023085100*f**8 + 109702483800*f**9 + 21411149760*f**10 + 1780899120*f**11))/1.2930726397188714e25,
    111: lambda f: (f*(1548690 + 24811891*f + 239989000*f**2 + 1648860736*f**3 + 8634309840*f**4 + 7058264520*f**5 - 20179010880*f**6 - 45750474000*f**7 - 39712079400*f**8 - 17775372300*f**9 - 4086482400*f**10 - 383423040*f**11))/1.330017572282268e26,
    112: lambda f: (f*(10156146 + 180916879*f + 1999615480*f**2 + 15821071012*f**3 + 96347514960*f**4 + 270981233832*f**5 + 408449248704*f**6 + 364766628240*f**7 + 200335863000*f**8 + 66708691140*f**9 + 12392636256*f**10 + 987818832*f**11))/9.310123005975875e25,
    113: lambda f: -(f*(10840830 + 194953889*f + 2167045760*f**2 + 17296736564*f**3 + 106555667760*f**4 + 328101091800*f**5 + 543355223040*f**6 + 527008330800*f**7 + 310411991400*f**8 + 109641493500*f**9 + 21411149760*f**10 + 1780899120*f**11))/3.103374335325292e26,
    114: lambda f: (f*(-271700 - 4630509*f - 47817300*f**2 - 351912129*f**3 - 1981880310*f**4 - 1699766160*f**5 + 4543707840*f**6 + 10485695640*f**7 + 9142761600*f**8 + 4099504500*f**9 + 943034400*f**10 + 88482240*f**11))/7.980105433693607e26,
    115: lambda f: -(f*(1787786 + 33688330*f + 394441140*f**2 + 3311196063*f**3 + 21430378920*f**4 + 61522264977*f**5 + 93525608064*f**6 + 83870215800*f**7 + 46161927000*f**8 + 15387729840*f**9 + 2859839136*f**10 + 227958192*f**11))/5.586073803585525e26,
    116: lambda f: (f*(1901900 + 36161541*f + 425663460*f**2 + 3603029451*f**3 + 23575699890*f**4 + 74303812410*f**5 + 124275312000*f**6 + 121114922040*f**7 + 71512660800*f**8 + 25289819100*f**9 + 4941034560*f**10 + 410976720*f**11))/1.862024601195175e27,
    117: lambda f: (f*(90090 + 1627483*f + 17871400*f**2 + 140250058*f**3 + 845042670*f**4 + 754358535*f**5 - 1905538320*f**6 - 4467118320*f**7 - 3910316760*f**8 - 1756000260*f**9 - 404157600*f**10 - 37920960*f**11))/9.576126520432329e27,
    118: lambda f: (f*(594594 + 11816779*f + 146107720*f**2 + 1297036786*f**3 + 8890380630*f**4 + 25993361943*f**5 + 39811279536*f**6 + 35830546920*f**7 + 19757896200*f**8 + 6592296060*f**9 + 1225645344*f**10 + 97696368*f**11))/6.70328856430263e27,
    119: lambda f: -(f*(210210 + 4213339*f + 52357920*f**2 + 468461454*f**3 + 3244612710*f**4 + 10441411455*f**5 + 17616081000*f**6 + 17239985700*f**7 + 10201128840*f**8 + 3611337660*f**9 + 705862080*f**10 + 58710960*f**11))/7.4480984047807e27,
}

Q044withhex20 = {
    0: lambda f: 0,
    1: lambda f: 0,
    2: lambda f: (-77 - 78*f - 39*f**2)/154.,
    3: lambda f: 0,
    4: lambda f: 0,
    5: lambda f: (5005 + 10140*f + 12786*f**2 + 7716*f**3 + 1929*f**4)/40040.,
    6: lambda f: 0,
    7: lambda f: 0,
    8: lambda f: (-5005 - 15210*f - 30753*f**2 - 36228*f**3 - 25407*f**4 - 9810*f**5 - 1635*f**6)/240240.,
    9: lambda f: 0,
    10: lambda f: 0,
    11: lambda f: (85085 + 344760*f + 959412*f**2 + 1676472*f**3 + 1929078*f**4 + 1463400*f**5 + 708420*f**6 + 199080*f**7 + 24885*f**8)/3.267264e7,
    12: lambda f: 0,
    13: lambda f: 0,
    14: lambda f: (-323323 - 1637610*f - 5803341*f**2 - 13434216*f**3 - 21485694*f**4 - 24255468*f**5 - 19374090*f**6 - 10752840*f**7 - 3957975*f**8 - 871290*f**9 - 87129*f**10)/1.24156032e9,
    15: lambda f: 0,
    16: lambda f: 0,
    17: lambda f: (323323 + 1965132*f + 8459370*f**2 + 24376164*f**3 + 49913361*f**4 + 74793528*f**5 + 77977020*f**6 + 53169480*f**7 + 22329405*f**8 + 5227740*f**9 + 522774*f**10)/1.489872384e10,
    18: lambda f: 0,
    19: lambda f: 0,
    20: lambda f: (-230945 - 1637610*f - 8295609*f**2 - 28601004*f**3 - 71380701*f**4 - 133315470*f**5 - 163933125*f**6 - 123467400*f**7 - 54641475*f**8 - 13069350*f**9 - 1306935*f**10)/1.489872384e11,
    21: lambda f: 0,
    22: lambda f: 0,
    23: lambda f: (1616615 + 13100880*f + 76333944*f**2 + 306374544*f**3 + 901885236*f**4 + 2017224720*f**5 + 2775592680*f**6 + 2216466000*f**7 + 1008941850*f**8 + 243961200*f**9 + 24396120*f**10)/1.66865707008e13,
    24: lambda f: 0,
    25: lambda f: 0,
    26: lambda f: (-1616615 - 14738490*f - 97090893*f**2 - 444608208*f**3 - 1507955292*f**4 - 3929075640*f**5 - 5865454980*f**6 - 4867899120*f**7 - 2255225490*f**8 - 548912700*f**9 - 54891270*f**10)/3.003582726144e14,
    27: lambda f: 0,
    28: lambda f: 0,
    29: lambda f: (323323 + 3275220*f + 24068022*f**2 + 123826572*f**3 + 475433523*f**4 + 1414118736*f**5 + 2245792680*f**6 + 1915386480*f**7 + 898118550*f**8 + 219565080*f**9 + 21956508*f**10)/1.2014330904576e15,
    30: lambda f: 0,
    31: lambda f: 0,
    32: lambda f: (-29393 - 327522*f - 2656029*f**2 - 15166788*f**3 - 65025087*f**4 - 217387746*f**5 - 362423115*f**6 - 315448560*f**7 - 149213610*f**8 - 36594180*f**9 - 3659418*f**10)/2.4028661809152e15,
    33: lambda f: 0,
    34: lambda f: 0,
    35: lambda f: (1616615 + 19651320*f + 174315348*f**2 + 1093954488*f**3 + 5180014422*f**4 + 19227475080*f**5 + 33335692500*f**6 + 29474814600*f**7 + 14035277025*f**8 + 3450308400*f**9 + 345030840*f**10)/3.171783358808064e18,
    36: lambda f: 0,
    37: lambda f: 0,
    38: lambda f: (-124355 - 1637610*f - 15772413*f**2 - 107900088*f**3 - 559235322*f**4 - 2281987620*f**5 - 4086042510*f**6 - 3658347000*f**7 - 1751159025*f**8 - 431288550*f**9 - 43128855*f**10)/6.343566717616128e18,
    39: lambda f: 0,
    40: lambda f: 0,
    41: lambda f: (17765 + 251940*f + 2618238*f**2 + 19391628*f**3 + 109187547*f**4 + 485799480*f**5 + 893670780*f**6 + 808342920*f**7 + 388568565*f**8 + 95841900*f**9 + 9584190*f**10)/2.537426687046451e19,
    42: lambda f: 0,
    43: lambda f: 0,
    44: lambda f: (-323323 - 4912830*f - 54794043*f**2 - 436798068*f**3 - 2655030987*f**4 - 12791605554*f**5 - 24077812395*f**6 - 21964498920*f**7 - 10595013975*f**8 - 2616483870*f**9 - 261648387*f**10)/1.3854349711273624e22,
    45: lambda f: 0,
    46: lambda f: 0,
    47: lambda f: (323323 + 5240352*f + 62434608*f**2 + 532996512*f**3 + 3478401288*f**4 + 18040778784*f**5 + 34636017360*f**6 + 31823195040*f**7 + 15395283540*f**8 + 3805794720*f**9 + 380579472*f**10)/4.4333919076075595e23,
    48: lambda f: 0,
    49: lambda f: 0,
    50: lambda f: (-95095 - 1637610*f - 20756949*f**2 - 188931744*f**3 - 1317580536*f**4 - 7319349360*f**5 - 14295765000*f**6 - 13215535200*f**7 - 6409185300*f**8 - 1585747800*f**9 - 158574780*f**10)/4.4333919076075595e24,
    51: lambda f: 0,
    52: lambda f: 0,
    53: lambda f: (95095 + 1733940*f + 23297382*f**2 + 225222732*f**3 + 1671503283*f**4 + 9901591200*f**5 + 19633116240*f**6 + 18246060000*f**7 + 8867709900*f**8 + 2195650800*f**9 + 219565080*f**10)/1.5960210867387213e26,
    54: lambda f: 0,
    55: lambda f: 0,
    56: lambda f: (-5005 - 96330*f - 1367601*f**2 - 13993956*f**3 - 110122119*f**4 - 692929890*f**5 - 1392412635*f**6 - 1300047840*f**7 - 633002580*f**8 - 156832200*f**9 - 15683220*f**10)/3.1920421734774425e26,
    57: lambda f: 0,
    58: lambda f: 0,
    59: lambda f: (1001 + 20280*f + 303348*f**2 + 3275448*f**3 + 27241782*f**4 + 181457064*f**5 + 368990820*f**6 + 345922920*f**7 + 168706125*f**8 + 41821920*f**9 + 4182192*f**10)/2.553633738781954e27,
    60: lambda f: 0.3333333333333333 + (13*f)/154.,
    61: lambda f: 0.3333333333333333 + (293*f)/1386. + (8*f**2)/245.,
    62: lambda f: -0.5 - (39*f)/154. - (1521*f**2)/11858.,
    63: lambda f: (-10010 - 12675*f - 8928*f**2 - 1929*f**3)/60060.,
    64: lambda f: (-210210 - 346255*f - 330384*f**2 - 144093*f**3 - 21216*f**4)/1.26126e6,
    65: lambda f: (385385 + 585585*f + 591126*f**2 + 298995*f**3 + 75231*f**4)/1.54154e6,
    66: lambda f: (10010 + 22815*f + 33288*f**2 + 25830*f**3 + 10398*f**4 + 1635*f**5)/240240.,
    67: lambda f: (210210 + 559195*f + 964248*f**2 + 957918*f**3 + 552630*f**4 + 169935*f**5 + 20880*f**6)/5.04504e6,
    68: lambda f: (-385385 - 975975*f - 1677519*f**2 - 1695702*f**3 - 1057635*f**4 - 380955*f**5 - 63765*f**6)/6.16616e6,
    69: lambda f: (-170170 - 560235*f - 1242360*f**2 - 1663671*f**3 - 1396458*f**4 - 715545*f**5 - 204900*f**6 - 24885*f**7)/2.450448e7,
    70: lambda f: (-3573570 - 13126295*f - 32677128*f**2 - 50844195*f**3 - 51688914*f**4 - 34279965*f**5 - 14278500*f**6 - 3378585*f**7 - 342720*f**8)/5.1459408e8,
    71: lambda f: (6551545 + 23228205*f + 57086748*f**2 + 88353777*f**3 + 91114344*f**4 + 63027855*f**5 + 28535280*f**6 + 7739235*f**7 + 970515*f**8)/6.2894832e8,
    72: lambda f: (3233230 + 13919685*f + 41442192*f**2 + 78872724*f**3 + 101109564*f**4 + 88443270*f**5 + 52208160*f**6 + 19911780*f**7 + 4430790*f**8 + 435645*f**9)/3.72468096e9,
    73: lambda f: (67897830 + 318179225*f + 1034954016*f**2 + 2193881892*f**3 + 3202503276*f**4 + 3283010910*f**5 + 2364096960*f**6 + 1172225460*f**7 + 381092670*f**8 + 73020465*f**9 + 6224400*f**10)/7.821830016e10,
    74: lambda f: (-124479355 - 567431865*f - 1819362423*f**2 - 3814918116*f**3 - 5554700046*f**4 - 5753556990*f**5 - 4264138590*f**6 - 2228192820*f**7 - 786286935*f**8 - 169465905*f**9 - 16990155*f**10)/9.560014464e10,
    75: lambda f: (-646646 - 3438981*f - 12852816*f**2 - 31716339*f**3 - 54761268*f**4 - 67885026*f**5 - 60971976*f**6 - 39430230*f**7 - 17924550*f**8 - 5439945*f**9 - 989688*f**10 - 81543*f**11)/7.44936192e9,
    76: lambda f: (-67897830 - 386958845*f - 1553717856*f**2 - 4170377355*f**3 - 7942353780*f**4 - 11036258130*f**5 - 11334994920*f**6 - 8612973894*f**7 - 4786448310*f**8 - 1892021985*f**9 - 503826120*f**10 - 80966655*f**11 - 5920992*f**12)/7.821830016e11,
    77: lambda f: (24895871 + 138705567*f + 549196254*f**2 + 1456322697*f**3 + 2751287571*f**4 + 3819281286*f**5 + 3958626732*f**6 + 3074887074*f**7 + 1774483725*f**8 + 742121835*f**9 + 213694278*f**10 + 38080581*f**11 + 3180177*f**12)/1.9120028928e11,
    78: lambda f: (3233230 + 20470125*f + 92070504*f**2 + 279186342*f**3 + 606470310*f**4 + 973887255*f**5 + 1123898880*f**6 + 893686500*f**7 + 471274650*f**8 + 156663675*f**9 + 29690640*f**10 + 2446290*f**11)/4.469617152e11,
    79: lambda f: (67897830 + 455738465*f + 2177156952*f**2 + 7072969374*f**3 + 16621985118*f**4 + 29175436755*f**5 + 37873181520*f**6 + 35378323764*f**7 + 23132533410*f**8 + 10256824935*f**9 + 2929590720*f**10 + 485799930*f**11 + 35525952*f**12)/9.3861960192e12,
    80: lambda f: (-124479355 - 819623805*f - 3864504753*f**2 - 12404120550*f**3 - 28863133263*f**4 - 50379941655*f**5 - 65331188085*f**6 - 61764629220*f**7 - 41809003425*f**8 - 19721666475*f**9 - 6155976015*f**10 - 1142417430*f**11 - 95405310*f**12)/1.14720173568e13,
    81: lambda f: (-3233230 - 23745345*f - 124861464*f**2 - 449136345*f**3 - 1176078834*f**4 - 2320050285*f**5 - 3156261780*f**6 - 2795995125*f**7 - 1571922450*f**8 - 540699075*f**9 - 103917240*f**10 - 8562015*f**11)/6.2574640128e12,
    82: lambda f: (-67897830 - 524518085*f - 2905271304*f**2 - 11079101229*f**3 - 30979473210*f**4 - 65728510785*f**5 - 100467197460*f**6 - 105556946649*f**7 - 74522654010*f**8 - 34621029135*f**9 - 10144640520*f**10 - 1700299755*f**11 - 124340832*f**12)/1.314067442688e14,
    83: lambda f: (124479355 + 945719775*f + 5174932872*f**2 + 19507751991*f**3 + 53984041650*f**4 + 113680045395*f**5 + 172363917180*f**6 + 182329419195*f**7 + 133216883100*f**8 + 66060179325*f**9 + 21248588340*f**10 + 3998461005*f**11 + 333918585*f**12)/1.606082429952e14,
    84: lambda f: (3233230 + 27020565*f + 162636960*f**2 + 676881384*f**3 + 2074739352*f**4 + 4854890460*f**5 + 7416521280*f**6 + 7017856440*f**7 + 4088408100*f**8 + 1431699150*f**9 + 277112640*f**10 + 22832040*f**11)/1.001194242048e14,
    85: lambda f: (67897830 + 593297705*f + 3738060912*f**2 + 16366216200*f**3 + 53070625656*f**4 + 132072539340*f**5 + 227564910720*f**6 + 257728078104*f**7 + 190199569140*f**8 + 90618933510*f**9 + 26907138720*f**10 + 4534132680*f**11 + 331575552*f**12)/2.1025079083008e15,
    86: lambda f: (-124479355 - 1071815745*f - 6677265627*f**2 - 28917820488*f**3 - 92810926476*f**4 - 229068048300*f**5 - 389348701980*f**6 - 442455164760*f**7 - 337930954410*f**8 - 172206273750*f**9 - 56266465290*f**10 - 10662562680*f**11 - 890449560*f**12)/2.5697318879232e15,
    87: lambda f: (-3233230 - 30295785*f - 205396992*f**2 - 970871139*f**3 - 3409689384*f**4 - 9232020900*f**5 - 15369636240*f**6 - 15202672380*f**7 - 9059348340*f**8 - 3207600270*f**9 - 623503440*f**10 - 51372090*f**11)/1.8021496356864e15,
    88: lambda f: (-67897830 - 662077325*f - 4675525776*f**2 - 23111757567*f**3 - 85268981736*f**4 - 243519183540*f**5 - 459733499280*f**6 - 548355295404*f**7 - 416491592580*f**8 - 201592455750*f**9 - 60344993520*f**10 - 10201798530*f**11 - 746044992*f**12)/3.78451423494144e16,
    89: lambda f: (124479355 + 1197911715*f + 8371503018*f**2 + 40959638721*f**3 + 149618059281*f**4 + 423684158220*f**5 + 785402872200*f**6 + 937687865940*f**7 + 737125550910*f**8 + 382125939930*f**9 + 126064357020*f**10 + 23990766030*f**11 + 2003511510*f**12)/4.62551739826176e16,
    90: lambda f: (646646 + 6714201*f + 50628312*f**2 + 267911058*f**3 + 1060659306*f**4 + 3261914577*f**5 + 5802740352*f**6 + 5925157560*f**7 + 3586520700*f**8 + 1279380690*f**9 + 249401376*f**10 + 20548836*f**11)/7.2085985427456e15,
    91: lambda f: (67897830 + 730856945*f + 5717665896*f**2 + 31493168610*f**3 + 130265812410*f**4 + 419900213385*f**5 + 851819433840*f**6 + 1055180295288*f**7 + 817758694620*f**8 + 400118051970*f**9 + 120428562240*f**10 + 20403597060*f**11 + 1492089984*f**12)/7.56902846988288e17,
    92: lambda f: (-24895871 - 264801537*f - 2051529009*f**2 - 11191703874*f**3 - 45852443937*f**4 - 146562177897*f**5 - 290798377839*f**6 - 359887417848*f**7 - 288687964950*f**8 - 151426862370*f**9 - 50283025506*f**10 - 9596306412*f**11 - 801404604*f**12)/1.850206959304704e17,
    93: lambda f: (-3233230 - 36846225*f - 305870664*f**2 - 1791383517*f**3 - 7893058470*f**4 - 27178077135*f**5 - 50962699260*f**6 - 53296810875*f**7 - 32632746300*f**8 - 11703695850*f**9 - 2286179280*f**10 - 188364330*f**11)/7.92945839702016e17,
    94: lambda f: (-67897830 - 799636565*f - 6864481272*f**2 - 41687892609*f**3 - 191070120318*f**4 - 686153014635*f**5 - 1475108460540*f**6 - 1880616671703*f**7 - 1479338603820*f**8 - 729533636370*f**9 - 220443355440*f**10 - 37406594610*f**11 - 2735498304*f**12)/1.6651862633742336e19,
    95: lambda f: (124479355 + 1450103655*f + 12335691708*f**2 + 74239775115*f**3 + 337182695388*f**4 + 1200946492185*f**5 + 2516617528920*f**6 + 3200679893565*f**7 + 2606103128475*f**8 + 1378758946950*f**9 + 459993275280*f**10 + 87966142110*f**11 + 7346208870*f**12)/2.0352276552351744e19,
    96: lambda f: (3233230 + 40121445*f + 363584304*f**2 + 2334805500*f**3 + 11331602964*f**4 + 43188345090*f**5 + 84529246560*f**6 + 90061933500*f**7 + 55628530650*f**8 + 20032672275*f**9 + 3919164480*f**10 + 322910280*f**11)/1.9030700152848384e19,
    97: lambda f: (67897830 + 868416185*f + 8115971904*f**2 + 53873372844*f**3 + 271008639780*f**4 + 1072906095690*f**5 + 2419485583680*f**6 + 3155143693548*f**7 + 2510492908770*f**8 + 1245465500895*f**9 + 377462741040*f**10 + 64125590760*f**11 + 4689425664*f**12)/3.9964470320981606e20,
    98: lambda f: (-124479355 - 1576199625*f - 14605643007*f**2 - 96128718636*f**3 - 479401282170*f**4 - 1882878381450*f**5 - 4126506064890*f**6 - 5361664756140*f**7 - 4416060396825*f**8 - 2351603105775*f**9 - 787358453805*f**10 - 150799100760*f**11 - 12593500920*f**12)/4.8845463725644186e20,
    99: lambda f: (-248710 - 3338205*f - 32790960*f**2 - 229097763*f**3 - 1214360604*f**4 - 5075334630*f**5 - 10292872920*f**6 - 11131250130*f**7 - 6923104650*f**8 - 2501088975*f**9 - 489895560*f**10 - 40363785*f**11)/3.806140030569677e19,
    100: lambda f: (-5222910 - 72091985*f - 728625984*f**2 - 5248234815*f**3 - 28748141292*f**4 - 124389584190*f**5 - 291968849880*f**6 - 387746160186*f**7 - 311334858450*f**8 - 155181171915*f**9 - 47140049880*f**10 - 8015698845*f**11 - 586178208*f**12)/7.992894064196321e20,
    101: lambda f: (9575335 + 130945815*f + 1312884534*f**2 + 9380820201*f**3 + 50963252607*f**4 + 218827428210*f**5 + 497868957780*f**6 + 658124269110*f**7 + 547007502195*f**8 + 292785310125*f**9 + 98302999410*f**10 + 18849887595*f**11 + 1574187615*f**12)/9.769092745128837e20,
    102: lambda f: (3233230 + 46671885*f + 493965192*f**2 + 3730229454*f**3 + 21441201054*f**4 + 97506109155*f**5 + 203755144320*f**6 + 223056085980*f**7 + 139507758390*f**8 + 50529123645*f**9 + 9906776880*f**10 + 816245430*f**11)/1.3854349711273624e22,
    103: lambda f: (67897830 + 1005975425*f + 10932978936*f**2 + 84926375142*f**3 + 503183909046*f**4 + 2362395785295*f**5 + 5737000323600*f**6 + 7734077790348*f**7 + 6255866970990*f**8 + 3129986644785*f**9 + 952584272640*f**10 + 162095243310*f**11 + 11853825984*f**12)/2.909413439367461e23,
    104: lambda f: (-124479355 - 1828391565*f - 19721259513*f**2 - 152030919726*f**3 - 893732512491*f**4 - 4165167081075*f**5 - 9781728505185*f**6 - 13114435212060*f**7 - 10980966768135*f**8 - 5901921230205*f**9 - 1986015416385*f**10 - 381186615810*f**11 - 31833571770*f**12)/3.555949759226897e23,
    105: lambda f: (-646646 - 9989421*f - 113326488*f**2 - 919826157*f**3 - 5698632114*f**4 - 28013512653*f**5 - 60055532628*f**6 - 66416260365*f**7 - 41731366950*f**8 - 15146843985*f**9 - 2972033064*f**10 - 244873629*f**11)/8.312609826764174e22,
    106: lambda f: (-67897830 - 1074755045*f - 12498495336*f**2 - 104148783765*f**3 - 663662785890*f**4 - 3360114585765*f**5 - 8402344084260*f**6 - 11470315777557*f**7 - 9334744121430*f**8 - 4685012673705*f**9 - 1428026778360*f**10 - 243142864965*f**11 - 17780738976*f**12)/8.728240318102382e24,
    107: lambda f: (24895871 + 390897507*f + 4513384944*f**2 + 37338960531*f**3 + 236160257598*f**4 + 1187241082083*f**5 + 2865066218196*f**6 + 3886882036947*f**7 + 3274502417550*f**8 + 1765949949855*f**9 + 595340793684*f**10 + 114355984743*f**11 + 9550071531*f**12)/2.133569855536138e24,
    108: lambda f: (3233230 + 53222325*f + 644284224*f**2 + 5593424592*f**3 + 37155714480*f**4 + 196334459640*f**5 + 430309568640*f**6 + 479997630000*f**7 + 302767756200*f**8 + 110086785900*f**9 + 21614785920*f**10 + 1780899120*f**11)/1.3300175722822679e25,
    109: lambda f: (67897830 + 1143534665*f + 14168686992*f**2 + 126071721744*f**3 + 859760128368*f**4 + 4669469063640*f**5 + 11977508194560*f**6 + 16526093790192*f**7 + 13518402657480*f**8 + 6802482321180*f**9 + 2076100004160*f**10 + 353662349040*f**11 + 25862893056*f**12)/2.7930369017927624e26,
    110: lambda f: (-124479355 - 2080583505*f - 25604494563*f**2 - 226267624080*f**3 - 1532080438488*f**4 - 8264549922840*f**5 - 20420110301880*f**6 - 27981913826160*f**7 - 23694794568900*f**8 - 12815233458300*f**9 - 4326940128420*f**10 - 831679889040*f**11 - 69455065680*f**12)/3.413711768857821e26,
    111: lambda f: (-190190 - 3323385*f - 42760032*f**2 - 395385915*f**3 - 2803361232*f**4 - 15845719560*f**5 - 35405759520*f**6 - 39786411000*f**7 - 25178953800*f**8 - 9168816300*f**9 - 1801232160*f**10 - 148408260*f**11)/2.6600351445645357e25,
    112: lambda f: (-3993990 - 71312605*f - 937856112*f**2 - 8874860727*f**3 - 64493607600*f**4 - 374019173160*f**5 - 981045511200*f**6 - 1366066243416*f**7 - 1122347940840*f**8 - 566021621340*f**9 - 172935715680*f**10 - 29471862420*f**11 - 2155241088*f**12)/5.586073803585525e26,
    113: lambda f: (7322315 + 129804675*f + 1696115826*f**2 + 15945570393*f**3 + 115088488245*f**4 + 663090311640*f**5 + 1672543390800*f**6 + 2311712387880*f**7 + 1966130457900*f**8 + 1065959019300*f**9 + 360380125560*f**10 + 69306657420*f**11 + 5787922140*f**12)/6.827423537715642e26,
    114: lambda f: (190190 + 3516045*f + 47914200*f**2 + 470116962*f**3 + 3543579306*f**4 + 21334934385*f**5 + 48487345920*f**6 + 54835870320*f**7 + 34801817400*f**8 + 12689252100*f**9 + 2494013760*f**10 + 205488360*f**11)/9.576126520432329e26,
    115: lambda f: (3993990 + 75358465*f + 1048417416*f**2 + 10513468170*f**3 + 81105265458*f**4 + 500220947925*f**5 + 1338234162480*f**6 + 1878326792496*f**7 + 1549056118680*f**8 + 782711192340*f**9 + 239363268480*f**10 + 40807194120*f**11 + 2984179968*f**12)/2.010986569290789e28,
    116: lambda f: (-7322315 - 137222085*f - 1897373421*f**2 - 18908313714*f**3 - 144917042193*f**4 - 888189762105*f**5 - 2281514012775*f**6 - 3177038818800*f**7 - 2712332539980*f**8 - 1473596806500*f**9 - 498752617860*f**10 - 95963064120*f**11 - 8014046040*f**12)/2.457872473577631e28,
    117: lambda f: (-10010 - 195195*f - 2808504*f**2 - 29142903*f**3 - 232710138*f**4 - 1486804545*f**5 - 3430311300*f**6 - 3901199085*f**7 - 2482046280*f**8 - 906001740*f**9 - 178143840*f**10 - 14677740*f**11)/1.9152253040864658e27,
    118: lambda f: (-210210 - 4179175*f - 61322952*f**2 - 649591779*f**3 - 5301874722*f**4 - 34652074725*f**5 - 94348881540*f**6 - 133354014129*f**7 - 110339749800*f**8 - 55845353340*f**9 - 17092041120*f**10 - 2914799580*f**11 - 213155712*f**12)/4.021973138581578e28,
    119: lambda f: (385385 + 7612605*f + 111048396*f**2 + 1169327697*f**3 + 9484322112*f**4 + 61614518535*f**5 + 160855043040*f**6 + 225462601035*f**7 + 193119397695*f**8 + 105111658260*f**9 + 35610624000*f**10 + 6854504580*f**11 + 572431860*f**12)/4.915744947155262e28,
}

###################

# Q(N-j)(l)(l') up to k^{2*8}
Qa = {
    0: {
        0: {0: Q000, 2: Q002},
        2: {0: Q020, 2: Q022}
    },
    1: {
        0: {0: Q100, 2: Q102},
        2: {0: Q120, 2: Q122}
    },
}

# Q(N-j)(l)(l') up to k^{2*12}
Qakp2x12 = {
    0: {
        0: {0: Q000kp2x12, 2: Q002kp2x12},
        2: {0: Q020kp2x12, 2: Q022kp2x12}
    },
    1: {
        0: {0: Q100kp2x12, 2: Q102kp2x12},
        2: {0: Q120kp2x12, 2: Q122kp2x12}
    },
}

# Q(N-j)(l)(l') up to k^{2*16}
Qakp2x16 = {
    0: {
        0: {0: Q000kp2x16, 2: Q002kp2x16},
        2: {0: Q020kp2x16, 2: Q022kp2x16}
    },
    1: {
        0: {0: Q100kp2x16, 2: Q102kp2x16},
        2: {0: Q120kp2x16, 2: Q122kp2x16}
    },
}

# Q(N-j)(l)(l') up to k^{2*16} with hexadecapole
Qawithhex = {
    0: {
        0: {0: Q000withhex, 2: Q002withhex, 4: Q004withhex},
        2: {0: Q020withhex, 2: Q022withhex, 4: Q024withhex},
        4: {0: Q040withhex, 2: Q042withhex, 4: Q044withhex}
    },
    1: {
        0: {0: Q100withhex, 2: Q102withhex, 4: Q104withhex},
        2: {0: Q120withhex, 2: Q122withhex, 4: Q124withhex},
        4: {0: Q140withhex, 2: Q142withhex, 4: Q144withhex}
    },
}

# Q(N-j)(l)(l') up to k^{2*16} with hexadecapole
Qawithhex20 = {
    0: {
        0: {0: Q000withhex20, 2: Q002withhex20, 4: Q004withhex20},
        2: {0: Q020withhex20, 2: Q022withhex20, 4: Q024withhex20},
        4: {0: Q040withhex20, 2: Q042withhex20, 4: Q044withhex20}
    },
    1: {
        0: {0: Q100withhex20, 2: Q102withhex20, 4: Q104withhex20},
        2: {0: Q120withhex20, 2: Q122withhex20, 4: Q124withhex20},
        4: {0: Q140withhex20, 2: Q142withhex20, 4: Q144withhex20}
    },
}
