"""Docker-style session name generation.

NOTE: All functions in this module are for internal use within tmux module.
"""

import random


_ADJECTIVES = [
    "admiring",
    "adoring",
    "affectionate",
    "agitated",
    "amazing",
    "angry",
    "awesome",
    "beautiful",
    "blissful",
    "bold",
    "boring",
    "brave",
    "busy",
    "charming",
    "clever",
    "cool",
    "compassionate",
    "competent",
    "condescending",
    "confident",
    "cranky",
    "crazy",
    "dazzling",
    "determined",
    "distracted",
    "dreamy",
    "eager",
    "ecstatic",
    "elastic",
    "elated",
    "elegant",
    "eloquent",
    "epic",
    "exciting",
    "fervent",
    "festive",
    "flamboyant",
    "focused",
    "friendly",
    "frosty",
    "funny",
    "gallant",
    "gifted",
    "goofy",
    "gracious",
    "great",
    "happy",
    "hardcore",
    "heuristic",
    "hopeful",
    "hungry",
    "infallible",
    "inspiring",
    "intelligent",
    "interesting",
    "jolly",
    "jovial",
    "keen",
    "kind",
    "laughing",
    "loving",
    "lucid",
    "magical",
    "mystifying",
    "modest",
    "musing",
    "naughty",
    "nervous",
    "nice",
    "nifty",
    "nostalgic",
    "objective",
    "optimistic",
    "peaceful",
    "pedantic",
    "pensive",
    "practical",
    "priceless",
    "quirky",
    "quizzical",
    "recursing",
    "relaxed",
    "reverent",
    "romantic",
    "sad",
    "serene",
    "sharp",
    "silly",
    "sleepy",
    "stoic",
    "strange",
    "stupefied",
    "suspicious",
    "sweet",
    "tender",
    "thirsty",
    "trusting",
    "unruffled",
    "upbeat",
    "vibrant",
    "vigilant",
    "vigorous",
    "wizardly",
    "wonderful",
    "xenodochial",
    "youthful",
    "zealous",
    "zen",
]

_ANIMALS = [
    "alligator",
    "ant",
    "ape",
    "baboon",
    "badger",
    "bat",
    "bear",
    "beaver",
    "bee",
    "beetle",
    "bird",
    "bison",
    "buffalo",
    "butterfly",
    "camel",
    "cat",
    "caterpillar",
    "cheetah",
    "chicken",
    "chipmunk",
    "cobra",
    "crab",
    "crane",
    "crocodile",
    "crow",
    "deer",
    "dog",
    "dolphin",
    "donkey",
    "dragonfly",
    "duck",
    "eagle",
    "elephant",
    "elk",
    "emu",
    "falcon",
    "ferret",
    "fish",
    "flamingo",
    "fly",
    "fox",
    "frog",
    "giraffe",
    "goat",
    "goose",
    "gorilla",
    "grasshopper",
    "hamster",
    "hare",
    "hawk",
    "hedgehog",
    "heron",
    "hippo",
    "horse",
    "hound",
    "hyena",
    "iguana",
    "impala",
    "jackal",
    "jaguar",
    "jellyfish",
    "kangaroo",
    "koala",
    "ladybug",
    "leopard",
    "lion",
    "lizard",
    "llama",
    "lobster",
    "lynx",
    "magpie",
    "mallard",
    "manatee",
    "meerkat",
    "mole",
    "mongoose",
    "monkey",
    "moose",
    "mosquito",
    "moth",
    "mouse",
    "mule",
    "octopus",
    "otter",
    "owl",
    "ox",
    "panda",
    "panther",
    "parrot",
    "peacock",
    "pelican",
    "penguin",
    "pig",
    "pigeon",
    "pony",
    "porcupine",
    "porpoise",
    "puma",
    "quail",
    "rabbit",
    "raccoon",
    "ram",
    "rat",
    "raven",
    "reindeer",
    "rhino",
    "rooster",
    "salmon",
    "scorpion",
    "seal",
    "shark",
    "sheep",
    "shrimp",
    "skunk",
    "sloth",
    "snail",
    "snake",
    "sparrow",
    "spider",
    "squid",
    "squirrel",
    "starfish",
    "stork",
    "swan",
    "termite",
    "tiger",
    "toad",
    "trout",
    "turkey",
    "turtle",
    "viper",
    "walrus",
    "wasp",
    "weasel",
    "whale",
    "wolf",
    "wombat",
    "woodpecker",
    "worm",
    "yak",
    "zebra",
]


def _generate_session_name() -> str:
    """Generate a Docker-style session name.

    Returns:
        Random adjective-animal name (e.g., 'epic-swan').
    """
    return f"{random.choice(_ADJECTIVES)}-{random.choice(_ANIMALS)}"
