"""
Setup script for TPath - Enhanced pathlib with age and size utilities.
"""

from setuptools import find_packages, setup

with open("README.md", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="tpath",
    version="0.1.0",
    author="Your Name",
    author_email="your.email@example.com",
    description="Enhanced pathlib with age and size utilities using lambdas",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/tpath",
    package_dir={"": "src"},
    packages=find_packages(where="src"),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: System :: Filesystems",
        "Topic :: Utilities",
    ],
    python_requires=">=3.7",
    install_requires=[
        # No external dependencies - only uses standard library
    ],
    extras_require={
        "dev": [
            "pytest>=6.0",
            "pytest-cov",
            "black",
            "flake8",
            "mypy",
        ],
    },
    project_urls={
        "Bug Reports": "https://github.com/yourusername/tpath/issues",
        "Source": "https://github.com/yourusername/tpath",
    },
)
