"""
YomiToku-Client - A Python library for processing SageMaker Yomitoku API outputs
"""

__version__ = "0.1.0"
__author__ = "YomiToku Team"
__email__ = "support-aws-marketplace@mlism.com"

from .client import YomitokuClient

# Import font manager and PDF functions
from .font_manager import FontManager

# Import main classes for easy access
from .models import (
    DocumentResult,
    MultiPageDocumentResult,
)
from .parser import parse_pydantic_model
from .renderers.csv_renderer import CSVRenderer
from .renderers.html_renderer import HTMLRenderer
from .renderers.json_renderer import JSONRenderer

# Import renderers
from .renderers.markdown_renderer import MarkdownRenderer
from .renderers.pdf_renderer import PDFRenderer
from .renderers.searchable_pdf import (
    create_searchable_pdf,
)

# Import visualizers
from .visualizers.document_visualizer import DocumentVisualizer

__all__ = [
    "DocumentResult",
    "MultiPageDocumentResult",
    "SageMakerParser",
    "YomitokuClient",
    "MarkdownRenderer",
    "HTMLRenderer",
    "CSVRenderer",
    "JSONRenderer",
    "PDFRenderer",
    "DocumentVisualizer",
    "FontManager",
    "create_searchable_pdf",
    "create_searchable_pdf_from_pdf",
    "parse_pydantic_model",
]


# Post-installation hook to ensure font is available
def _ensure_font_available():
    """Ensure MPLUS1p-Medium font is available from resource directory"""
    try:
        import os

        # Check if the default font exists in resource directory
        module_dir = os.path.dirname(os.path.abspath(__file__))
        font_path = os.path.join(module_dir, "resource", "MPLUS1p-Medium.ttf")
        if os.path.exists(font_path):
            return font_path
        else:
            return None
    except Exception:
        # Font not available, but don't fail the import
        return None


# Check font availability on import
_font_path = _ensure_font_available()
