"""
Setup configuration for Composio Claude plugin.
"""

from pathlib import Path

from setuptools import setup

setup(
    name="composio_anthropic",
    version="0.8.2",
    author="Composio",
    author_email="tech@composio.dev",
    description="Use Composio to get an array of tools with your Anthropic LLMs.",
    long_description=(Path(__file__).parent / "README.md").read_text(encoding="utf-8"),
    long_description_content_type="text/markdown",
    url="https://github.com/ComposioHQ/composio",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.10,<4",
    install_requires=["anthropic>=0.25.7"],
    include_package_data=True,
)
