---
title: User Guide
---

# User Guide

Welcome to the DataChain User Guide! This section provides comprehensive documentation on how to effectively use DataChain's advanced features and capabilities.

- [Interacting with Remote Storage](./remotes.md) - Learn how to connect to and work with various remote storage systems.
- [Data Processing Overview](./processing.md) - Discover DataChain's specialized data processing features.
    - [Delta Processing](./delta.md) - Incremental data processing to efficiently handle large datasets that change over time.
    - [Error Handling and Retries](./retry.md) - Learn how to handle processing errors and selectively reprocess problematic records.
- [Environment Variables](./env.md) - Configure DataChain's behavior using environment variables.
- [Namespaces](./namespaces.md) - Learn more about namespaces and projects.
- [Local DB Migrations](./namespaces.md) - Learn how to handle local DB migrations after upgrading datachain.
