import abc
from abc import ABC, abstractmethod

class BaseFilter(ABC, metaclass=abc.ABCMeta):
    def process(self, line: str) -> str | None: ...
    def finalize(self) -> str | None: ...
    @abstractmethod
    def reset(self) -> None: ...
