# Sample CWL Workflow Files and Parsing Codes

This repository contains some (simple) sample CWL workflow
files. Additionally, there is some Python code (`dump_cwl.py`), using
the auto-generated CWL parser (`parser_v1_0.py`) to explore the CWL
files and print the Python classes that brepresent the CWL file.

Also included is a sample CWL parser that also uses
`parser_v1_0.py`. The parser reads a CWL fle (**only** `grepcount.cwl`
for now), parses it into python objects, and loads the Neo4j databse
with a workflow using the BEE workflow interface.

## Using the CWL Parser

`parser.py` will allow the parsing of a generic CWL workflow with basic support and no JavaScript
support. The parser will automatically connect to and populate the graph database.

To use as a script:

`python3 parser.py cwl_file [-i cwl_inputs]`

where `cwl_file` is the CWL Workflow file and `cwl_inputs` is a YAML or JSON file providing
job parameter inputs.

To use as an imported module:

```py
from beeflow.common.parser import CwlParser

parser = CwlParser() # Initializes parser and forms a database connection
parser.parse_workflow(cwl_file, cwl_inputs) # cwl_inputs is optional
```

## Install Dependency

> **NOTE:** You don't need to do this is you're in a BEE development
> environment. Just make sure to do a `poetry update`.

Please install the Python parsing code using Poetry (make sure you're in an
active virtual environment for BEE).

Another useful tool to install is `cwltool`. Using this you can
validate a CWL file via `cwltool --validate file.cwl`.

```sh
$ poetry add -D cwl-utils cwltool
```

## Read the Parser's Documentation

Start a Python shell, load the parsing library, and explore the code's
documentation:

```sh
$ python       # 3.6 or greater
>>> import cwl_utils.parser.cwl_v1_2 as cwl
>>> top = cwl.load_document("../../data/cwl/bee_workflows/simple-workflows/grep-wordcount/gc.cwl")
>>> top
<cwl_utils.parser.cwl_v1_2.Workflow object at 0x2b1e3c4c0be0>
>>> help(cwl)
Help on module cwl_utils.parser.cwl_v1_2 in cwl_utils.parser:

NAME
    cwl_utils.parser.cwl_v1_2

DESCRIPTION
    # This file was autogenerated using schema-salad-tool --codegen=python
    # The code itself is released under the Apache 2.0 license and the help text is
    # subject to the license of the original schema.
    #

CLASSES
    builtins.Exception(builtins.BaseException)
        ValidationException
    builtins.object
...
```

All the usual Python exploration tools are useful as well (e.g. `vars`, `dir`,
etc.).

## References

- [`cwl-utils` repository](https://github.com/common-workflow-language/cwl-utils)

