# MD005 - List indentation should be consistent

## What this rule does

Ensures all list items at the same level use the same indentation. MD005 intelligently detects your
preferred indentation pattern (2, 3, 4 spaces, etc.) and ensures consistency throughout the document.

## Why this matters

- **Visual alignment**: Consistent indentation makes lists easier to scan
- **Readability**: Clear hierarchy helps readers understand list structure
- **Rendering**: Some Markdown processors require specific indentation
- **Maintenance**: Consistent spacing is easier to edit and update

## Examples

### ✅ Correct

```markdown
* Item 1
* Item 2
  * Nested item (2 spaces)
  * Another nested item
    * Deep nested (4 spaces)
* Item 3

1. First item
2. Second item
   1. Nested ordered (3 spaces - aligns with parent text)
   2. Another nested
3. Third item

# Also correct with 4-space indentation:
* Item A
    * Nested with 4 spaces
        * Double nested with 8 spaces
    * Consistent 4-space pattern
```

### ❌ Incorrect

```markdown
* Item 1
 * Item 2 (wrong: 1 space)
   * Nested (wrong: 3 spaces)
    * Another (wrong: 4 spaces for level 2)

1. First item
 2. Second item (wrong: 1 space)
    1. Nested (wrong: 4 spaces)

```

### 🔧 Fixed

```markdown
* Item 1
* Item 2
  * Nested
  * Another

1. First item
2. Second item
   1. Nested
```

## Configuration

This rule has no configuration options. MD005 automatically detects and adapts to your indentation pattern:

- Top-level items should always start at column 0
- Nested items align with their parent's text content OR use the detected indent increment
- The rule intelligently detects whether you're using 2, 3, 4, or other space increments
- Once a pattern is established, all items at the same level must use consistent indentation

## Automatic fixes

This rule automatically adjusts list item indentation to maintain consistency with the detected pattern.
It preserves your preferred indentation style while ensuring all items at the same level use identical spacing.

## Learn more

- [CommonMark lists](https://spec.commonmark.org/0.31.2/#lists) - Technical specification
- [Markdown Guide - Lists](https://www.markdownguide.org/basic-syntax/#lists) - List formatting guide

## Related rules

- [MD004](md004.md) - Unordered list style should be consistent
- [MD007](md007.md) - Unordered list indentation
- [MD030](md030.md) - Spaces after list markers
