# MD012 - Remove multiple blank lines

## What this rule does

Reduces multiple consecutive blank lines to just one, keeping your documents clean and consistent.

## Why this matters

- **Readability**: Too many blank lines make documents feel disconnected and harder to follow
- **File size**: Extra blank lines waste space without adding value
- **Professional appearance**: Clean spacing looks polished and intentional
- **Consistency**: Standard spacing makes documents easier to maintain

## Examples

### ✅ Correct

```markdown
# Chapter 1

This is the introduction paragraph.

## Section 1.1

Content for this section.

## Section 1.2

More content here.
```

### ❌ Incorrect

<!-- rumdl-disable MD012 -->

```markdown
# Chapter 1


This is the introduction paragraph.



## Section 1.1

Content for this section.


## Section 1.2


More content here.
```

<!-- rumdl-enable MD012 -->

### 🔧 Fixed

```markdown
# Chapter 1

This is the introduction paragraph.

## Section 1.1

Content for this section.

## Section 1.2

More content here.
```

## Configuration

```toml
[MD012]
maximum = 1  # Maximum number of consecutive blank lines allowed (default: 1)
```

## Automatic fixes

This rule automatically removes excess blank lines, keeping at most the configured maximum (default: 1) between content blocks.

## Learn more

- [Paragraphs in Markdown](https://www.markdownguide.org/basic-syntax/#paragraphs-1) - How to use blank lines effectively
- [CommonMark specification](https://spec.commonmark.org/0.31.2/#blank-lines) - Technical details about blank lines

## Related rules

- [MD009](md009.md) - Remove trailing spaces
- [MD047](md047.md) - End files with a single newline
