# MD014 - Show command output in documentation

## What this rule does

Checks that shell commands in code blocks include their output, making documentation more helpful and complete.

## Why this matters

- **Better documentation**: Readers can see what to expect when they run commands
- **Reduces confusion**: No guessing about whether a command worked or what it produced
- **Improves learning**: Examples with output help users understand command behavior
- **Catches errors**: Missing output often indicates incomplete or untested documentation

## Examples

<!-- rumdl-disable MD014 -->

### ✅ Correct

```bash
$ npm install
added 125 packages, and audited 126 packages in 3s

14 packages are looking for funding
  run `npm fund` for details

found 0 vulnerabilities
```

```bash
$ echo "Hello, World!"
Hello, World!
```

### ❌ Incorrect

```bash
$ npm install
```

```bash
$ echo "Hello, World!"
```

### 🔧 Fixed

```bash
$ npm install
added 125 packages, and audited 126 packages in 3s

14 packages are looking for funding
  run `npm fund` for details

found 0 vulnerabilities
```

<!-- rumdl-enable MD014 -->

## Configuration

```toml
[MD014]
show-output = true  # Whether commands should show output (default: true)
```

## Automatic fixes

This rule cannot be automatically fixed because the actual command output depends on your system and environment. You need to run the commands and add their output manually.

## Learn more

- [Writing better technical documentation](https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/)
- [Shell scripting best practices](https://google.github.io/styleguide/shellguide.html)

## Related rules

- [MD031](md031.md): Add blank lines around code blocks
- [MD040](md040.md): Specify language for code blocks
- [MD048](md048.md): Use consistent code fence style
