# MD022 - Add blank lines around headings

## What this rule does

Checks that headings have blank lines before and after them to improve readability and document structure.

## Why this matters

- **Better readability**: Blank lines create visual separation, making content easier to scan
- **Clear structure**: Spacing helps readers understand the document hierarchy
- **Consistent rendering**: Many Markdown processors require blank lines for proper formatting
- **Professional appearance**: Well-spaced documents look more polished and organized

## Examples

<!-- rumdl-disable MD022 -->

### ✅ Correct

```markdown
Some introductory text here.

# Main Heading

This is the content under the main heading.

## Subheading

More content follows here.

### Another Section

And even more content.
```

### ❌ Incorrect

```markdown
Some introductory text here.
# Main Heading
This is the content under the main heading.
## Subheading
More content follows here.
### Another Section
And even more content.
```

### 🔧 Fixed

```markdown
Some introductory text here.

# Main Heading

This is the content under the main heading.

## Subheading

More content follows here.

### Another Section

And even more content.
```

<!-- rumdl-enable MD022 -->

## Configuration

```toml
[MD022]
lines-above = 1  # Blank lines required above headings (default: 1)
lines-below = 1  # Blank lines required below headings (default: 1)
allowed-at-start = true  # Allow headings at document start without blank line above (default: true)
```

## Automatic fixes

This rule automatically adds the required number of blank lines:

- Before headings (except at the start of a document)
- After headings (except at the end of a document)

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Markdown best practices](https://www.markdownguide.org/basic-syntax/#headings)

## Related rules

- [MD001](md001.md): Use consistent heading levels
- [MD003](md003.md): Use consistent heading style
- [MD023](md023.md): Start headings at the beginning of lines
- [MD041](md041.md): First line should be a top-level heading
