# MD023 - Start headings at the beginning of lines

## What this rule does

Checks that headings start at the beginning of the line without any indentation.

## Why this matters

- **Proper rendering**: Indented headings may not be recognized by all Markdown processors
- **Clear structure**: Headings at the line start make document hierarchy obvious
- **Consistency**: Uniform alignment creates a professional appearance
- **Avoid confusion**: Indented text with # symbols might be misinterpreted

## Examples

<!-- rumdl-disable MD023 -->

### ✅ Correct

```markdown
# Main Title
## Section Header
### Subsection
#### Detail Level
```

### ❌ Incorrect

```markdown
   # Main Title
  ## Section Header
 ### Subsection
    #### Detail Level
```

### 🔧 Fixed

```markdown
# Main Title
## Section Header
### Subsection
#### Detail Level
```

<!-- rumdl-enable MD023 -->

## Configuration

```toml
[MD023]
```

## Automatic fixes

This rule automatically removes any leading spaces or tabs from heading lines, moving them to the beginning of the line.

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Markdown heading best practices](https://www.markdownguide.org/basic-syntax/#headings)

## Related rules

- [MD001](md001.md): Use consistent heading levels
- [MD003](md003.md): Use consistent heading style
- [MD022](md022.md): Add blank lines around headings
- [MD026](md026.md): Remove trailing punctuation in headings
