# MD026 - Keep headings clean and professional

## What this rule does

Removes trailing punctuation from the end of headings to maintain a clean, professional appearance. Question marks are allowed by default for FAQ-style headings.

## Why this matters

- **Professional appearance**: Clean headings look more polished and professional
- **Better readability**: Unnecessary punctuation can distract readers
- **Consistent style**: Maintains a uniform look throughout your document
- **Navigation clarity**: Clean headings work better in tables of contents and outlines

## Examples

### ✅ Correct

```markdown
# Introduction

## What is Markdown?

### FAQ: Frequently Asked Questions

#### Step 1: Getting Started

##### Chapter 2: Configuration
```

### ❌ Incorrect

<!-- rumdl-disable MD026 -->

```markdown
# This is a sentence.

## Random heading;

### This seems wrong,

#### Important!

##### Ending with colon:
```

<!-- rumdl-enable MD026 -->

### 🔧 Fixed

```markdown
# This is a sentence

## Random heading

### This seems wrong

#### Important

##### Ending with colon
```

## Configuration

```toml
[MD026]
punctuation = ".,;:!"  # Characters to remove from heading endings (default: ".,;:!")
```

To allow exclamation marks in headings, remove `!` from the list:

```toml
[MD026]
punctuation = ".,;:"
```

## Automatic fixes

This rule will:

- Remove periods, commas, semicolons, colons, and exclamation marks from heading endings (default: `.,;:!`)
- Preserve question marks for FAQ-style headings ("What is Markdown?")
- You can customize the punctuation list if you want to allow certain characters

## Learn more

- [CommonMark Spec: ATX headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [CommonMark Spec: Setext headings](https://spec.commonmark.org/0.31.2/#setext-headings)

## Related rules

- [MD001 - Keep heading levels organized](md001.md)
- [MD003 - Use consistent heading styles](md003.md)
- [MD025 - Keep your document organized with one main title](md025.md)
