# MD029 - Use consistent numbers for ordered lists

## What this rule does

Ensures ordered lists use consistent numbering - either all "1." (letting Markdown handle numbering) or sequential numbers (1, 2, 3).

## Why this matters

- **Easier maintenance**: Using all "1." means you can reorder items without renumbering
- **Clear intent**: Consistent numbering shows whether order matters
- **Better diffs**: All "1." creates cleaner version control diffs when reordering
- **Predictable rendering**: Prevents confusion about how lists will be numbered

## Examples

### ✅ Correct (one style - recommended)

```markdown
1. First item
1. Second item
1. Third item
```

### ✅ Correct (ordered style)

```markdown
1. First item
2. Second item
3. Third item
```

### ❌ Incorrect

<!-- rumdl-disable MD029 -->

```markdown
1. First item
3. Second item
5. Third item
```

<!-- rumdl-enable MD029 -->

### 🔧 Fixed

```markdown
1. First item
1. Second item
1. Third item
```

## Configuration

```toml
[MD029]
style = "one"  # How to number list items: "one" (all 1), "ordered" (1,2,3), or "zero" (all 0)
```

## Automatic fixes

This rule will:

- Renumber all list items according to your chosen style
- Preserve list item content and indentation
- Handle nested lists independently

## Learn more

- [CommonMark Spec: List items](https://spec.commonmark.org/0.31.2/#list-items)
- [CommonMark Spec: Lists](https://spec.commonmark.org/0.31.2/#lists)

## Related rules

- [MD004 - Use consistent list markers](md004.md)
- [MD005 - Keep list indentation consistent](md005.md)
- [MD007 - Indent lists properly](md007.md)
- [MD030 - Add spaces after list markers](md030.md)
