# MD033 - No HTML tags

## What this rule does

Prevents the use of HTML tags in Markdown - use Markdown syntax instead.

## Why this matters

- **Portability**: Pure Markdown works everywhere, HTML might be blocked or stripped
- **Security**: Many platforms sanitize HTML for security reasons
- **Simplicity**: Markdown syntax is cleaner and easier to read than HTML
- **Consistency**: Mixing HTML and Markdown creates inconsistent documents

## Examples

### ✅ Correct

```markdown
# Heading

This is a paragraph with **bold** and *italic* text.

> This is a quote

- List item 1
- List item 2

[Link text](https://example.com)

![Image description](image.png)

Contact us at <support@example.com>
Visit <https://example.com>
```

### ❌ Incorrect

<!-- rumdl-disable MD033 -->

```markdown
# Heading

This is a paragraph with <strong>bold</strong> and <em>italic</em> text.

<blockquote>This is a quote</blockquote>

<ul>
  <li>List item 1</li>
  <li>List item 2</li>
</ul>

<a href="https://example.com">Link text</a>

<img src="image.png" alt="Image description">
```

<!-- rumdl-enable MD033 -->

### 🔧 Fixed

```markdown
# Heading

This is a paragraph with **bold** and *italic* text.

> This is a quote

- List item 1
- List item 2

[Link text](https://example.com)

![Image description](image.png)
```

## Configuration

```toml
[MD033]
allowed-elements = []  # List of allowed HTML tags (default: none)
```

### Example allowing specific tags

```toml
[MD033]
allowed-elements = ["br", "hr", "details", "summary"]
```

This would allow line breaks, horizontal rules, and collapsible sections while blocking other HTML.

### mdbook projects with semantic HTML

mdbook documentation often uses HTML with CSS classes to add semantic meaning that pure Markdown cannot express (e.g., marking text as filenames, captions, or warnings). For mdbook projects, you can
allow semantic containers:

```toml
[tool.rumdl.MD033]
allowed-elements = ["div", "span"]
```

This permits semantic HTML like:

- `<span class="filename">src/main.rs</span>` - Filename styling
- `<div class="warning">Important note</div>` - Warning boxes
- `<span class="caption">Figure 1: Architecture</span>` - Figure captions

While still catching potentially problematic HTML like `<em>`, `<strong>`, or `<script>` tags that have Markdown equivalents or security concerns.

## Automatic fixes

This rule can automatically remove HTML tags when no allowed elements are configured. When specific tags are allowed via `allowed_elements`, those tags will be preserved while others are removed.

**Note**: The automatic fix removes HTML tags but does not convert them to Markdown equivalents. You may need to manually add appropriate Markdown formatting after the fix.

## What's allowed

These are **not** considered HTML and are allowed:

- HTML comments: `<!-- This is a comment -->`
- Email autolinks: `<user@example.com>`
- URL autolinks: `<https://example.com>`
- FTP autolinks: `<ftp://files.example.com>`

## Learn more

- [CommonMark HTML blocks](https://spec.commonmark.org/0.31.2/#html-blocks) - When HTML is needed
- [Markdown Guide - Basic Syntax](https://www.markdownguide.org/basic-syntax/) - Markdown alternatives to HTML

## Related rules

- [MD046](md046.md) - Code block style should be consistent
- [MD034](md034.md) - URLs should be formatted as links
