# MD034 - URLs should be formatted as links

## What this rule does

Ensures URLs are properly formatted with angle brackets or as clickable links, not pasted as plain text.

## Why this matters

- **Clickability**: Not all Markdown renderers make plain URLs clickable
- **Consistency**: Mixed URL formats look unprofessional
- **Control**: Proper link formatting lets you customize the display text

## Examples

### ✅ Correct

```markdown
For more information, see <https://example.com>.

Visit [our website](https://example.com) for details.

Email us at <contact@example.com>
```

### ❌ Incorrect

<!-- rumdl-disable MD034 -->

```markdown
For more information, see https://example.com.

Email us at contact@example.com
```

<!-- rumdl-enable MD034 -->

### 🔧 Fixed

```markdown
For more information, see <https://example.com>.

Email us at <contact@example.com>
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically wraps plain URLs and email addresses in angle brackets (`<` and `>`).

## Learn more

- [CommonMark autolinks](https://spec.commonmark.org/0.31.2/#autolinks) - Technical specification for URL formatting
- [Markdown Guide - Links](https://www.markdownguide.org/basic-syntax/#links) - Best practices for links

## Related rules

- [MD039](md039.md) - No spaces inside link text
- [MD042](md042.md) - No empty links
- [MD051](md051.md) - Link anchors should exist
