# MD042 - Avoid Empty Links

## What this rule does

Detects links that are missing either their text or URL, ensuring all links are complete and functional.

## Why this matters

- **User frustration**: Clicking empty links leads nowhere and confuses readers
- **Accessibility issues**: Screen readers can't describe links without text
- **Professional quality**: Empty links look like mistakes or unfinished work
- **SEO impact**: Search engines penalize broken or empty links

## Examples

### ✅ Correct

```markdown
[Visit our website](https://example.com)

[Download the guide](downloads/guide.pdf)

Check out the [documentation][docs]

[docs]: https://docs.example.com
```

### ❌ Incorrect  

```markdown
[](https://example.com)         <!-- Missing link text -->

[Click here]()                  <!-- Missing URL -->

[ ](https://example.com)        <!-- Only spaces as text -->

[Visit our website]()           <!-- Forgot to add URL -->
```

### 🔧 Fixed

```markdown
[Link](https://example.com)     <!-- Added generic text -->

[Click here](#)                 <!-- Added placeholder URL -->

[Link](https://example.com)     <!-- Replaced spaces with text -->

[Visit our website](#)          <!-- Added placeholder URL -->
```

## Configuration

This rule has no configuration options.

## Automatic fixes

When enabled, this rule will:

- Add generic text "Link" for empty link text
- Add placeholder "#" for empty URLs
- Replace these placeholders with meaningful content after fixing

## Special cases

- Image links (starting with `!`) are not checked by this rule
- Reference-style links are checked for both parts
- Links with only whitespace are considered empty

### MkDocs mode

When using MkDocs flavor (`flavor = "mkdocs"`), this rule recognizes valid MkDocs-specific syntax:

**Auto-references** (backtick-wrapped Python identifiers):

```markdown
[`module.Class`][]        <!-- Valid MkDocs auto-reference -->
[`str`][]                 <!-- Valid Python type reference -->
[`api.function`][]        <!-- Valid API reference -->
```

**Paragraph anchors** (using Python-Markdown attr_list extension):

```markdown
[](){ #my-anchor }        <!-- Valid anchor point -->
[](){ #anchor .class }    <!-- Valid anchor with CSS class -->
[](){: #anchor }          <!-- Valid with colon syntax -->
```

These patterns create anchor points in documentation and are widely used in MkDocs projects with the `attr_list` extension.

**References:**

- [Python-Markdown attr_list extension](https://python-markdown.github.io/extensions/attr_list/)
- [mkdocs-autorefs plugin](https://mkdocstrings.github.io/autorefs/)
- [MkDocs auto-references discussion](https://github.com/mkdocs/mkdocs/discussions/3754)

## Learn more

- [CommonMark specification for links](https://spec.commonmark.org/0.31.2/#links)
- [Writing meaningful link text](https://www.w3.org/WAI/WCAG21/Understanding/link-purpose-in-context.html)

## Related rules

- [MD034](md034.md) - Format bare URLs properly
- [MD039](md039.md) - Remove spaces inside link text
- [MD051](md051.md) - Ensure link fragments are valid
