# MD049 - Keep italic text formatting consistent

## What this rule does

Ensures all italic text uses the same style throughout your document - either asterisks (*) or underscores (_).

## Why this matters

- **Visual consistency**: Mixed styles make documents look unprofessional and hastily edited
- **Reader focus**: Consistent formatting helps readers concentrate on content, not style variations
- **Team standards**: Makes it easier to maintain shared documents across teams
- **Tool compatibility**: Some tools may handle different styles differently

## Examples

<!-- rumdl-disable MD049 -->

### ✅ Correct (consistent asterisks)

```markdown
This text has *italic* formatting.

Another paragraph with *emphasized* text.

Even more *italicized* content here.
```

### ✅ Correct (consistent underscores)

```markdown
This text has _italic_ formatting.

Another paragraph with _emphasized_ text.

Even more _italicized_ content here.
```

### ❌ Incorrect (mixed styles)

```markdown
This text has *italic* formatting.

Another paragraph with _emphasized_ text.

Even more *italicized* content here.
```

### 🔧 Fixed

```markdown
This text has *italic* formatting.

Another paragraph with *emphasized* text.

Even more *italicized* content here.
```

<!-- rumdl-enable MD049 -->

## Configuration

```toml
[MD049]
style = "consistent"  # Options: "consistent", "asterisk", "underscore"
```

### Style options

- **`consistent`** (default): Use whatever style is most prevalent in your document (in case of a tie, prefers asterisks)
- **`asterisk`**: Always use `*text*` for italics
- **`underscore`**: Always use `_text_` for underscores

## Automatic fixes

This rule can automatically fix issues by:

- Converting all italic markers to match your configured style
- When using "consistent", converting all markers to match the most prevalent style

## Learn more

- [CommonMark emphasis specification](https://spec.commonmark.org/0.31.2/#emphasis-and-strong-emphasis)
- [Markdown Guide: Italic](https://www.markdownguide.org/basic-syntax/#italic)

## Related rules

- [MD050 - Keep bold text formatting consistent](md050.md)
- [MD036 - Use proper headings instead of emphasized text](md036.md)
- [MD037 - Remove spaces inside emphasis markers](md037.md)
