# MD054 - Use consistent link and image style

## What this rule does

Ensures all links and images in your document use the same formatting style for better consistency and readability.

## Why this matters

- **Professional appearance**: Mixed link styles make documents look disorganized
- **Easier maintenance**: Consistent style makes it easier to find and update links
- **Better readability**: Readers can quickly recognize and understand link patterns
- **Team consistency**: Everyone follows the same linking conventions

## Examples

<!-- rumdl-disable MD054 -->

### ✅ Correct (all inline style)

```markdown
Check out [our website](https://example.com) for more info.

See the [documentation](https://docs.example.com) for details.

View our ![company logo](https://example.com/logo.png).
```

### ✅ Correct (all reference style)

```markdown
Check out [our website][site] for more info.

See the [documentation][docs] for details.

View our ![company logo][logo].

[site]: https://example.com
[docs]: https://docs.example.com
[logo]: https://example.com/logo.png
```

### ❌ Incorrect (mixed styles)

```markdown
Check out [our website](https://example.com) for more info.

See the [documentation][docs] for details.

View our <https://example.com/contact> page.

[docs]: https://docs.example.com
```

### 🔧 Fixed

```markdown
Check out [our website](https://example.com) for more info.

See the [documentation](https://docs.example.com) for details.

View our [contact page](https://example.com/contact).
```

<!-- rumdl-enable MD054 -->

## Configuration

Configure which link and image styles are allowed in your documents. By default, all styles are allowed. Set a style to `false` to disallow it.

```toml
[MD054]
autolink = true    # Allow <https://example.com>
inline = true      # Allow [text](url) and ![alt](url)
full = true        # Allow [text][ref] with separate [ref]: url definition
collapsed = true   # Allow [text][] with separate [text]: url definition
shortcut = true    # Allow [text] with separate [text]: url definition
url-inline = true  # Allow [https://example.com](https://example.com)
```

### Link and image styles

- **`autolink`**: `<https://example.com>` - Bare URLs in angle brackets
- **`inline`**: `[text](url)` and `![alt](url)` - Direct inline links and images
- **`full`**: `[text][ref]` - Full reference with separate definition `[ref]: url`
- **`collapsed`**: `[text][]` - Collapsed reference (label matches definition)
- **`shortcut`**: `[text]` - Shortcut reference (just label, definition inferred)
- **`url-inline`**: `[https://example.com](https://example.com)` - URL as both text and destination

### Common configurations

**Only allow inline links:**

```toml
[MD054]
autolink = false
inline = true
full = false
collapsed = false
shortcut = false
url-inline = false
```

**Only allow reference-style links:**

```toml
[MD054]
autolink = false
inline = false
full = true
collapsed = true
shortcut = true
url-inline = false
```

**Prefer autolinks for bare URLs:**

```toml
[MD054]
autolink = true
inline = true
full = true
collapsed = true
shortcut = true
url-inline = false  # Disallow [url](url), prefer <url> instead
```

## Automatic fixes

This rule currently does not support automatic fixing. Links and images must be manually updated to match the allowed styles.

## Learn more

- [Markdown Guide: Links](https://www.markdownguide.org/basic-syntax/#links)
- [CommonMark: Links](https://spec.commonmark.org/0.31.2/#links)

## Related rules

- [MD042 - Ensure links have content](md042.md)
- [MD034 - Format bare URLs properly](md034.md)
- [MD052 - Fix broken reference links](md052.md)
