# MD056 - Keep table column count consistent

## What this rule does

Ensures every row in a table has the same number of columns as the header row, preventing broken or misaligned tables.

## Why this matters

- **Proper rendering**: Tables with inconsistent columns may display incorrectly or break entirely
- **Data integrity**: Missing or extra columns can indicate missing or misplaced data
- **Professional appearance**: Well-formed tables look organized and trustworthy
- **Parser compatibility**: Many Markdown parsers require consistent column counts

## Examples

### ✅ Correct

```markdown
| Name     | Department | Years |
| -------- | ---------- | ----- |
| Alice    | Sales      | 5     |
| Bob      | Marketing  | 3     |
| Charlie  | IT         | 7     |
```

### ✅ Correct (with empty cells)

```markdown
| Name     | Department | Years |
| -------- | ---------- | ----- |
| Alice    | Sales      | 5     |
| Bob      |            | 3     |
| Charlie  | IT         |       |
```

### ❌ Incorrect

```markdown
| Name     | Department | Years |
| -------- | ---------- | ----- |
| Alice    | Sales      | 5     |
| Bob      | Marketing  |       | Extra data |
| Charlie  | IT         |
```

### 🔧 Fixed

```markdown
| Name     | Department | Years |
| -------- | ---------- | ----- |
| Alice    | Sales      | 5     |
| Bob      | Marketing  |       |
| Charlie  | IT         |       |
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule can automatically fix issues by:

- Adding empty cells to rows with too few columns
- Removing extra cells from rows with too many columns
- Matching all rows to the header row's column count

## Learn more

- [Markdown Guide: Tables](https://www.markdownguide.org/extended-syntax/#tables)
- [GitHub Flavored Markdown: Tables](https://github.github.com/gfm/#tables-extension-)

## Related rules

- [MD055 - Keep table formatting consistent](md055.md)
- [MD058 - Add blank lines around tables](md058.md)
