"""Growatt Sensor definitions for the Mix type."""

from __future__ import annotations

from homeassistant.components.sensor import SensorDeviceClass, SensorStateClass
from homeassistant.const import (
    PERCENTAGE,
    UnitOfElectricPotential,
    UnitOfEnergy,
    UnitOfPower,
)

from .sensor_entity_description import GrowattSensorEntityDescription

MIX_SENSOR_TYPES: tuple[GrowattSensorEntityDescription, ...] = (
    # Values from 'mix_info' API call
    GrowattSensorEntityDescription(
        key="mix_statement_of_charge",
        translation_key="mix_statement_of_charge",
        api_key="capacity",
        native_unit_of_measurement=PERCENTAGE,
        device_class=SensorDeviceClass.BATTERY,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_charge_today",
        translation_key="mix_battery_charge_today",
        api_key="eBatChargeToday",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_charge_lifetime",
        translation_key="mix_battery_charge_lifetime",
        api_key="eBatChargeTotal",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        state_class=SensorStateClass.TOTAL,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_discharge_today",
        translation_key="mix_battery_discharge_today",
        api_key="eBatDisChargeToday",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_discharge_lifetime",
        translation_key="mix_battery_discharge_lifetime",
        api_key="eBatDisChargeTotal",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        state_class=SensorStateClass.TOTAL,
    ),
    GrowattSensorEntityDescription(
        key="mix_solar_generation_today",
        translation_key="mix_solar_generation_today",
        api_key="epvToday",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_solar_generation_lifetime",
        translation_key="mix_solar_generation_lifetime",
        api_key="epvTotal",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        state_class=SensorStateClass.TOTAL,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_discharge_w",
        translation_key="mix_battery_discharge_w",
        api_key="pDischarge1",
        native_unit_of_measurement=UnitOfPower.WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_voltage",
        translation_key="mix_battery_voltage",
        api_key="vbat",
        native_unit_of_measurement=UnitOfElectricPotential.VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
    ),
    GrowattSensorEntityDescription(
        key="mix_pv1_voltage",
        translation_key="mix_pv1_voltage",
        api_key="vpv1",
        native_unit_of_measurement=UnitOfElectricPotential.VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
    ),
    GrowattSensorEntityDescription(
        key="mix_pv2_voltage",
        translation_key="mix_pv2_voltage",
        api_key="vpv2",
        native_unit_of_measurement=UnitOfElectricPotential.VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
    ),
    # Values from 'mix_totals' API call
    GrowattSensorEntityDescription(
        key="mix_load_consumption_today",
        translation_key="mix_load_consumption_today",
        api_key="elocalLoadToday",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_load_consumption_lifetime",
        translation_key="mix_load_consumption_lifetime",
        api_key="elocalLoadTotal",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        state_class=SensorStateClass.TOTAL,
    ),
    GrowattSensorEntityDescription(
        key="mix_export_to_grid_today",
        translation_key="mix_export_to_grid_today",
        api_key="etoGridToday",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_export_to_grid_lifetime",
        translation_key="mix_export_to_grid_lifetime",
        api_key="etogridTotal",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        state_class=SensorStateClass.TOTAL,
    ),
    # Values from 'mix_system_status' API call
    GrowattSensorEntityDescription(
        key="mix_battery_charge",
        translation_key="mix_battery_charge",
        api_key="chargePower",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_load_consumption",
        translation_key="mix_load_consumption",
        api_key="pLocalLoad",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_wattage_pv_1",
        translation_key="mix_wattage_pv_1",
        api_key="pPv1",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_wattage_pv_2",
        translation_key="mix_wattage_pv_2",
        api_key="pPv2",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_wattage_pv_all",
        translation_key="mix_wattage_pv_all",
        api_key="ppv",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_export_to_grid",
        translation_key="mix_export_to_grid",
        api_key="pactogrid",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_import_from_grid",
        translation_key="mix_import_from_grid",
        api_key="pactouser",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_battery_discharge_kw",
        translation_key="mix_battery_discharge_kw",
        api_key="pdisCharge1",
        native_unit_of_measurement=UnitOfPower.KILO_WATT,
        device_class=SensorDeviceClass.POWER,
    ),
    GrowattSensorEntityDescription(
        key="mix_grid_voltage",
        translation_key="mix_grid_voltage",
        api_key="vAc1",
        native_unit_of_measurement=UnitOfElectricPotential.VOLT,
        device_class=SensorDeviceClass.VOLTAGE,
    ),
    # Values from 'mix_detail' API call
    GrowattSensorEntityDescription(
        key="mix_system_production_today",
        translation_key="mix_system_production_today",
        api_key="eCharge",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_load_consumption_solar_today",
        translation_key="mix_load_consumption_solar_today",
        api_key="eChargeToday",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_self_consumption_today",
        translation_key="mix_self_consumption_today",
        api_key="eChargeToday1",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_load_consumption_battery_today",
        translation_key="mix_load_consumption_battery_today",
        api_key="echarge1",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    GrowattSensorEntityDescription(
        key="mix_import_from_grid_today",
        translation_key="mix_import_from_grid_today",
        api_key="etouser",
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
    ),
    # This sensor is manually created using the most recent X-Axis value from the chartData
    GrowattSensorEntityDescription(
        key="mix_last_update",
        translation_key="mix_last_update",
        api_key="lastdataupdate",
        device_class=SensorDeviceClass.TIMESTAMP,
    ),
    # Values from 'dashboard_data' API call
    GrowattSensorEntityDescription(
        key="mix_import_from_grid_today_combined",
        translation_key="mix_import_from_grid_today_combined",
        api_key="etouser_combined",  # This id is not present in the raw API data, it is added by the sensor
        native_unit_of_measurement=UnitOfEnergy.KILO_WATT_HOUR,
        device_class=SensorDeviceClass.ENERGY,
        state_class=SensorStateClass.TOTAL_INCREASING,
        previous_value_drop_threshold=0.2,
    ),
)
