<!-- These comments are hidden when you submit the pull request,
so you do not need to remove them!

Thank you so much for your PR! To help us review your contribution,

Please be sure to check out our code of conduct,
https://scikit-plots.github.io/dev/project/code_of_conduct.html

If you are new or need to be re-acquainted with scikit-plots
contributing workflow, please see
https://scikit-plots.github.io/dev/devel/index.html

Please just have a quick search on GitHub to see if a similar
pull request has already been posted.
We have old closed pull requests that might provide useful code or ideas
that directly tie in with your pull request.

We have several automatic features that run when a pull request is open.
They can appear daunting but do not worry because maintainers will help
you navigate them, if necessary. -->

## PR summary
<!-- Please provide at least 1-2 sentences describing the pull request
in detail (Why is this change required?/What problem does it solve?)
and link to relevant issues and PRs.
Also please summarize the changes in the title, for example
"Raise ValueError on non-numeric input to set_xlim" and avoid non-descriptive titles such as " Addresses issue #8576".
-->
Why is this change required?/What problem does it solve?
- ?:


## Contributor's Pull Request Submission Checklist
<!--
#<Issue Number> : define issue number if exist
[ ]   default checkbox is unchecked
[x]   If a checkbox applies to this PR, leave it checked.
[N/A] If any checkbox does not apply, mark it as [N/A].
-->

- [ ] Include "closes #<Issue Number>" in the PR description to [link the related issue](https://docs.github.com/en/issues/tracking-your-work-with-issues/linking-a-pull-request-to-an-issue).
- [ ] Ensure new or modified code is [tested](https://scikit-plots.github.io/dev/devel/testing.html).
- [ ] If your PR includes *plotting-related* features, demonstrate them in an [example](https://scikit-plots.github.io/dev/devel/document.html#write-examples-and-tutorials).
- [ ] For any *New Features* and *API Changes* are noted with a [directive and release note](https://scikit-plots.github.io/dev/devel/api_changes.html#announce-changes-deprecations-and-new-features).
- [ ] Make sure the documentation follows our [general guidelines](https://scikit-plots.github.io/dev/devel/document.html#write-rest-pages) and [docstring conventions](https://scikit-plots.github.io/dev/devel/document.html#write-docstrings).

<!--We understand that PRs can sometimes be overwhelming,
especially as the reviews start coming in. Please let us know
if the reviews are unclear or the recommended next step
seems overly demanding, if you would like help in addressing
a reviewer's comments, or if you have been waiting too long
to hear back on your PR.-->
